

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sybFindLatestFullBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  sybFindLatestFullBackup()
--  |
--  |Description:   Finds the latest FULL backup of the given databased id based
--  |				on the given restore time.
--  |
--  |       Input:  instanceid, commcellid, subclientid, databaseId, databasename,
--  |				and bkupLevel
--	|
--  |      Output:  Returns the following columns:
--  |                subclientid, archfileid, archfilectime, stream, maxstream, jobid_h &
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        param      Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sybFindLatestFullBackup <<<'

IF EXISTS (select * from sysobjects where name='sybFindLatestFullBackup')
	drop procedure sybFindLatestFullBackup
IF EXISTS (select * from GxQscripts where name='sybFindLatestFullBackup')
	delete from GxQscripts where name = 'sybFindLatestFullBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindLatestFullBackup')
	delete from GXDBVersions where aliasname = 'sybFindLatestFullBackup'
GO
print '... Creating Procedure: sybFindLatestFullBackup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sybFindLatestFullBackup
  @i_instanceId integer,
  @i_commCellId integer,
  @i_databaseName char(64),
  @i_databaseId integer,
  @i_backupLevel integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @subclientId integer;
  DECLARE @archFileId integer;
  DECLARE @archFileCTime integer;
  DECLARE @stream integer;
  DECLARE @maxStream integer;
  DECLARE @jobid integer;
-- These lines represent the actual SQL code that will get executed.
BEGIN
	 SET NOCOUNT ON
select saf.sybsubclientId, af.id, af.ctime, saf.stream, saf.maxstream, af.jobId
from sybArchFileInfo saf, archFile af, JMBkpStats jst
			where  saf.commcellId = @i_commCellId
			and saf.archFileId = af.id
			and saf.commcellid = af.commcellid
			and saf.sybDatabaseName = @i_databaseName
			and saf.sybDatabaseId = @i_databaseId
			and saf.sybInstanceId = @i_instanceId
			and af.backupLevel = @i_backupLevel
			and af.jobId = jst.jobId
			and af.commCellId = jst.commcellId
			and jst.status IN (1, 14)
			ORDER BY  af.ctime desc
-- Tell the AWK processor that there are no more input lines to scan
END
GO

IF EXISTS (select * from GxQscripts where name = 'sybFindLatestFullBackup')
	delete from GxQscripts where name = 'sybFindLatestFullBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindLatestFullBackup')
	delete from GXDBVersions where aliasname = 'sybFindLatestFullBackup'
GO

insert into GXDBVersions values(2, 'sybFindLatestFullBackup',  '00000000000000000000', 'sybFindLatestFullBackup', '00000000000000000000')
GO

