

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sybFindInstDatabasesInTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Procedure:  sybFindInstDatabasesInTime()
--  |
--  |Description:   Finds the latest FULL backup of the given databased id based
--  |				on the given restore time.
--  |
--  |       Input:  instanceid, subclientId, fromTime, toRestoreTime, backupLevel
--  |				, copyprecedence, includeAgedData
--	|
--  |      Output:  Returns the following columns:
--  |                databaseName, databaseId, subclientId, jobTime
--  |
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        param      Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sybFindInstDatabasesInTime')
BEGIN
	print '>>> Drop Stored Procedure: sybFindInstDatabasesInTime <<<'
	drop procedure sybFindInstDatabasesInTime
END
IF EXISTS (select * from GxQscripts where name='sybFindInstDatabasesInTime')
	delete from GxQscripts where name = 'sybFindInstDatabasesInTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindInstDatabasesInTime')
	delete from GXDBVersions where aliasname = 'sybFindInstDatabasesInTime'
GO
print '... Creating Procedure: sybFindInstDatabasesInTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sybFindInstDatabasesInTime
  @i_instanceId integer,
  @i_subClientId integer,
  @i_fromUnixTime integer,
  @i_toUnixTime integer,
  @i_backupLevel integer,
  @i_incopyprec integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @databaseName char(64);
  DECLARE @databaseId integer;
  DECLARE @subclientId integer;
  DECLARE @jobTime integer;
-- These lines represent the actual SQL code that will get executed.
BEGIN
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare  @i_tempArchFile table(id int, commcellid int, ctime int)
IF (@i_subClientId <= 0)
	SET @i_subClientId = 0
insert into @i_tempArchFile
select id, commcellid, ctime
from archfile
where (appId = @i_subClientId
	OR (@i_subClientId = 0 AND appid in (select id from APP_Application where instance = @i_instanceId)))
and backuplevel = @i_backupLevel
select a.sybdatabasename, a.sybdatabaseid, a.sybsubclientid, max(ctime) as jobtime
from sybarchfileinfo a, @i_tempArchFile b, archfilecopy c, archGroupCopy d
where a.archfileid = b.id and a.commcellid = b.commcellid
and b.id = c.archfileid and b.commcellid = c.commcellid
and b.ctime >= @i_fromUnixTime
and b.ctime <= @i_toUnixTime
   AND c.archCopyId = d.id
   AND ((@i_incopyprec = -1 AND d.id IN (SELECT defaultCopy FROM archGroup))
      OR @i_incopyprec = 0
      OR @i_incopyprec = d.copy)
   AND c.isValid > 0 AND (@i_includeAgedData <> 0 OR (c.flags & 256) = 0)
   AND d.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
group by a.sybdatabasename, a.sybdatabaseid, a.sybsubclientid
order by jobtime desc
-- Tell the AWK processor that there are no more input lines to scan
END
GO

IF EXISTS (select * from GxQscripts where name = 'sybFindInstDatabasesInTime')
	delete from GxQscripts where name = 'sybFindInstDatabasesInTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindInstDatabasesInTime')
	delete from GXDBVersions where aliasname = 'sybFindInstDatabasesInTime'
GO

insert into GXDBVersions values(2, 'sybFindInstDatabasesInTime',  '00000000000000000000', 'sybFindInstDatabasesInTime', '00000000000000000000')
GO

