

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sybFindFullBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  syb_findfullbackup()
--  |
--  |Description:   Finds the latest FULL backup of the given databased id based
--  |				on the given restore time.
--  |
--  |       Input:  instanceid, subclientid, databaseId, databasename, toRestoreTime, backupLevel.
--	|
--  |      Output:  Returns the following columns:
--  |                archFileId archGroupdId, commCellId, appId, stream, maxStream, archFile.ctime
--  |                jobId, sybArchFileId
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        param      Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sybFindFullBackup <<<'

IF EXISTS (select * from sysobjects where name='sybFindFullBackup')
	drop procedure sybFindFullBackup
IF EXISTS (select * from GxQscripts where name='sybFindFullBackup')
	delete from GxQscripts where name = 'sybFindFullBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindFullBackup')
	delete from GXDBVersions where aliasname = 'sybFindFullBackup'
GO
print '... Creating Procedure: sybFindFullBackup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sybFindFullBackup
  @i_instanceId integer,
  @i_subclientId integer,
  @i_databaseId integer,
  @i_databaseName char(64),
  @i_fromUnixTime integer,
  @i_toUnixTime integer,
  @i_backupLevel integer,
  @i_incopyprec integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @archFileId integer;
  DECLARE @archGroupId integer;
  DECLARE @commCellId integer;
  DECLARE @appId integer;
  DECLARE @stream integer;
  DECLARE @maxStream integer;
  DECLARE @archFileCTime integer;
  DECLARE @jobId integer;
  DECLARE @sybArchFileId integer;
  DECLARE @flags integer;
  DECLARE @copy integer;
-- These lines represent the actual SQL code that will get executed.
BEGIN
	 SET NOCOUNT ON
DECLARE @i_jobIDLow integer
DECLARE @i_JobCommCellID integer
DECLARE @i_minCopy integer
set @i_minCopy = 0
select top 1 @i_JobCommCellID=sybArchFileInfo.commCellID, @i_jobIDLow = jobId
from sybArchFileInfo, archFile where
				sybInstanceId = @i_instanceId
				and sybSubClientId = @i_subclientId
				and sybdatabaseId = @i_databaseId
				and sybdatabaseName = @i_databaseName
				and archFile.id = sybArchFileInfo.archFileId
				and archFile.commCellId = sybArchFileInfo.commCellId
				and archFile.ctime = @i_toUnixTime
				and backupLevel = @i_backupLevel
				ORDER BY archFile.ctime desc
select distinct archFile.id, archGroupId, archFile.commCellId, appId, stream, maxStream, archFile.ctime, jobId, sybArchFileInfo.id as sybArchFileId , flags =
																												case
																													WHEN  ((archfile.flags & 4) = 4) AND (archfile.name like 'not named') THEN 512
																													ELSE archfile.flags
																												end
into #tempArchFile
from sybArchFileInfo, archFile
				where sybInstanceId = @i_instanceId
				and sybSubClientId = @i_subclientId
				and sybdatabaseId = @i_databaseId
				and sybdatabaseName = @i_databaseName
				and backupLevel = @i_backupLevel
				and sybArchFileInfo.commCellID	= @i_JobCommCellID
				and jobId = @i_jobIDLow
				and archFile.id = sybArchFileInfo.archFileId
				and archFile.commCellID	= sybArchFileInfo.commCellID
				and archFile.ctime >=	@i_fromUnixTime
				and archFile.ctime <= @i_toUnixTime
				ORDER BY archFile.ctime desc
SELECT a.*, c.copy
into #tempSybArchFileCopy
FROM   #tempArchFile a, archFileCopy b, archGroupCopy c
WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId
   AND a.archGroupId = c.archGroupId AND b.archCopyId = c.id
   AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
   AND ((@i_incopyprec = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
      OR @i_incopyprec = 0
      OR @i_incopyprec = c.copy)
	AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
ORDER BY c.copy ASC, a.cTime desc
IF @i_includeAgedData <> 0
BEGIN
-- Variables used for select into
DECLARE @i_ArchFileID	integer
DECLARE @i_ArchGroupID	integer
DECLARE @i_CommCellID	integer
DECLARE @i_AppID		integer
DECLARE @i_Stream		integer
DECLARE @i_MaxStream	integer
DECLARE @i_CTime		integer
DECLARE @i_JobID		integer
DECLARE @i_SybArchFileID	integer
DECLARE @i_CopyID		integer
DECLARE @i_Flags	    integer
-- DECLARE CURSOR #tempArchFile
IF object_id('tempdb.dbo.#tempSybArchFileCopy1') IS NOT NULL DROP TABLE #tempSybArchFileCopy1
IF object_id('tempdb.dbo.#tempSybArchFileCopy2') IS NOT NULL DROP TABLE #tempSybArchFileCopy2
--IF object_id('tempdb.dbo.#tempSybArchFileCopy') IS NOT NULL DROP TABLE #tempSybArchFileCopy
IF object_id('tempdb.dbo.#tempArchFile') IS NOT NULL DROP TABLE #tempArchFile
-- Need this local table to temporarily insert the rows into the table.
CREATE TABLE #tempSybArchFileCopy1 (
ArchFileID	integer,
ArchGroupID	integer,
CommCellID	integer,
AppID		integer,
Stream		integer,
MaxStream	integer,
CTime		integer,
JobID		integer,
SybArchFileID	integer,
Flags 		integer,
CopyID		integer
 )
CREATE TABLE #tempSybArchFileCopy2 (
ArchFileID	integer,
ArchGroupID	integer,
CommCellID	integer,
AppID		integer,
Stream		integer,
MaxStream	integer,
CTime		integer,
JobID		integer,
SybArchFileID	integer,
Flags 		integer,
CopyID		integer
 )
-- Local Temporary variables used for processing the aged Data
DECLARE @i_ProcessingCopyID	integer
DECLARE	@i_ProcessingJobID	integer
DECLARE	@i_ProcessingMaxStream	integer
DECLARE	@i_StreamCount		integer
DECLARE	@i_DoneProcessing		integer
DECLARE TempSybArchFileCopyCursor CURSOR
FOR
SELECT id, archGroupId, commCellId, appId, stream, maxStream, ctime, jobId, sybArchFileId, flags, copy from #tempSybArchFileCopy
-- OPEN
Open TempSybArchFileCopyCursor
-- FETCH
FETCH NEXT FROM TempSybArchFileCopyCursor
INTO @i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID, @i_Flags, @i_CopyID
SET @i_ProcessingCopyID = @i_CopyID
SET @i_StreamCount = 0
SET @i_DoneProcessing = 0
WHILE (@@FETCH_STATUS = 0 and @i_DoneProcessing = 0 )
BEGIN
	IF @i_StreamCount = 0
	BEGIN
		SET @i_ProcessingJobID = @i_JobID
		SET @i_ProcessingMaxStream = @i_MaxStream
	END
	SET @i_StreamCount = @i_StreamCount + 1
--	If You found a new copy ID, then come out.
	IF ( @i_CopyID = @i_ProcessingCopyID )
	BEGIN
--		One set of valid archive files are inserted.
--		This set need to inserted to #tempSybArchFileCopy2
-- 		@i_StreamCount = 0, means insert the valid set into #tempSybArchFileCopy2
--		and start processing the next set.
		IF (@i_StreamCount = @i_ProcessingMaxStream AND
		    @i_ProcessingJobID = @i_JobID)
		BEGIN
			SET @i_StreamCount = 0
		END
		ELSE
		BEGIN
--			Here is the inconsistency different Job IDs
--			Different # of archive files.
--			Dont have process it. Come out
			IF (@i_ProcessingJobID <> @i_JobID AND
			    @i_StreamCount <> @i_ProcessingMaxStream )
			BEGIN
				SET @i_DoneProcessing=1
			END
		END
		IF @i_DoneProcessing = 0
		BEGIN
			INSERT INTO #tempSybArchFileCopy1
			VALUES (@i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID, @i_Flags, @i_CopyID)
--
--			There is something to be inserted int #tempSybArchFileCopy2.
--
			IF @i_StreamCount = 0
			BEGIN
				INSERT INTO #tempSybArchFileCopy2  SELECT * FROM #tempSybArchFileCopy1
				TRUNCATE TABLE #tempSybArchFileCopy1
			END
			FETCH NEXT FROM TempSybArchFileCopyCursor
			INTO @i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID, @i_Flags, @i_CopyID
		END
	END
	ELSE
	BEGIN
		SET @i_DoneProcessing = 1
	END
END
CLOSE TempSybArchFileCopyCursor
DEALLOCATE TempSybArchFileCopyCursor
SELECT @i_minCopy=min(CopyID) from #tempSybArchFileCopy2
SELECT * FROM #tempSybArchFileCopy2 WHERE CopyID = @i_minCopy
DROP TABLE #tempSybArchFileCopy1
DROP TABLE #tempSybArchFileCopy2
END
ELSE
BEGIN
	SELECT @i_minCopy=min(copy) from #tempSybArchFileCopy
	SELECT * FROM #tempSybArchFileCopy WHERE copy = @i_minCopy ORDER BY cTime desc
END
END
DROP TABLE #tempSybArchFileCopy
IF object_id('tempdb.dbo.#tempArchFile') IS NOT NULL DROP TABLE #tempArchFile
IF object_id('tempdb.dbo.#tempSybArchFileCopy') IS NOT NULL DROP TABLE #tempSybArchFileCopy
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sybFindFullBackup')
	delete from GxQscripts where name = 'sybFindFullBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindFullBackup')
	delete from GXDBVersions where aliasname = 'sybFindFullBackup'
GO

insert into GXDBVersions values(2, 'sybFindFullBackup',  '00000000000000000000', 'sybFindFullBackup', '00000000000000000000')
GO

