

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sybFindDatabaseBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  SybFindDatabaseBackup()
--  |
--  |Description:   Finds the latest FULL backup of the given databased id based
--  |				on the given restore time.
--  |
--  |       Input:  instanceid, subclientid, databaseId, databasename, toRestoreTime, archFileId.
--	|
--  |      Output:  Returns the following columns:
--  |                archFileId archGroupdId, commCellId, appId, stream, maxStream, archFile.ctime
--  |                jobId, sybArchFileId
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        param      Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SybFindDatabaseBackup <<<'

IF EXISTS (select * from sysobjects where name='SybFindDatabaseBackup')
	drop procedure SybFindDatabaseBackup
IF EXISTS (select * from GxQscripts where name='SybFindDatabaseBackup')
	delete from GxQscripts where name = 'SybFindDatabaseBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SybFindDatabaseBackup')
	delete from GXDBVersions where aliasname = 'SybFindDatabaseBackup'
GO
print '... Creating Procedure: SybFindDatabaseBackup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SybFindDatabaseBackup
  @i_instanceId integer,
  @i_subclientId integer,
  @i_databaseId integer,
  @i_databaseName char(64),
  @i_toRestoreTime integer,
  @i_sybArchFileId integer,
  @i_incopyprec integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @archFileId integer;
  DECLARE @archGroupId integer;
  DECLARE @commCellId integer;
  DECLARE @appId integer;
  DECLARE @stream integer;
  DECLARE @maxStream integer;
  DECLARE @archFileCTime integer;
  DECLARE @jobId integer;
  DECLARE @sybArchFileId integer;
  DECLARE @backupLevel integer;
  DECLARE @archFlags integer;
  DECLARE @copy integer;
-- These lines represent the actual SQL code that will get executed.
BEGIN
	 SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempArchFile') IS NOT NULL DROP TABLE #tempArchFile
DECLARE @i_jobIDLow integer
DECLARE @i_commCellID integer
DECLARE	@i_backupLevel integer
DECLARE @i_archFileName nvarchar(2048)
DECLARE	@i_archFileFlag integer
set @i_archFileName = ''
select top 1 @i_commCellID=sybArchFileInfo.commCellID, @i_jobIDLow = archFile.jobId,  @i_backupLevel=backupLevel,
@i_archFileName=isnull(archFile.name, ''), @i_archFileFlag=archFile.flags
from sybArchFileInfo, archFile
where 			sybInstanceId = @i_instanceId
				and sybdatabaseId = @i_databaseId
				and sybdatabaseName = @i_databaseName
				and archFile.id = sybArchFileInfo.archFileId
				and archFile.commCellId = sybArchFileInfo.commCellId
				and (archFile.ctime = @i_toRestoreTime or
					(archFile.flags & (2048 | 262144)) != 0) -- CVA_AF_SYBASE_MULTIPLE_DB_BACKUP_FLAG       262144  Sybase  multiple DB archfile flag
				and sybArchFileInfo.id = @i_sybArchFileId
				ORDER BY archFile.ctime desc
if (@i_archFileName != '')
BEGIN
	select @i_archFileName=SUBSTRING(@i_archFileName, 1, LEN(@i_archFileName) - 2)
END
select archFile.id, archGroupId, archFile.commCellId, appId, stream, maxStream,
 case
 -- Checking ArchiveFile flag old value(2048) & new value CVA_SYBASE_MULTIPLE_DB_BACKUP_FLAG (262144)
 -- in which case we need to consider  startTime or ctime
 when (archFile.flags & @i_archFileFlag) & ( 262144 | 2048) != 0 and
	sybTransLog.startTime is not null
 then
	sybTransLog.startTime
 else archFile.ctime
 end as ctime,
jobId, sybArchFileInfo.id as sybArchFileId , backupLevel, archFile.flags
into #tempArchFile
from archFile, sybArchFileInfo  LEFT OUTER JOIN sybTransLog ON sybArchFileInfo.id = sybTransLog.sybArchFileId
where			sybInstanceId = @i_instanceId
				and sybdatabaseId = @i_databaseId
				and sybdatabaseName = @i_databaseName
				and sybArchFileInfo.commCellID	= @i_commCellID
				and jobId = @i_jobIDLow
				and archFile.id = sybArchFileInfo.archFileId
				and archFile.commCellID	= sybArchFileInfo.commCellID
				--Checking ArchiveFile flag old value(2048) & new value CVA_SYBASE_MULTIPLE_DB_BACKUP_FLAG (262144)
				--in which case we need to consider  finishTime or ctime
				and ( ( (archFile.Flags & @i_archFileFlag) & (2048 | 262144) != 0 and
					archFile.fileType = 4 and sybTransLog.finishTime is not null
					  and sybTransLog.finishTime <= @i_toRestoreTime)
				or
				( (archFile.Flags & @i_archFileFlag) = 2 and
					( @i_archFileName = '' and archFile.ctime <= @i_toRestoreTime) )
				or
				( (archFile.Flags & @i_archFileFlag) = 4 and
					( @i_archFileName != '' and ( (archFile.name like (@i_archFileName + '%')) OR (archFile.name like 'not named') ) )
				)
				or
				( (@i_archFileName != '' and
					archFile.name like (@i_archFileName + '%') )
					or
					( @i_archFileName = '' and
						archFile.ctime <= @i_toRestoreTime) ) )
				and archFile.backupLevel = @i_backupLevel
				ORDER BY archFile.ctime desc
SELECT a.*, c.copy
FROM   #tempArchFile a, archFileCopy b, archGroupCopy c
WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId
   AND a.archGroupId = c.archGroupId AND b.archCopyId = c.id
   AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
   AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
   AND ((@i_incopyprec = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
      OR @i_incopyprec = 0
      OR @i_incopyprec = c.copy)
ORDER BY c.copy ASC, a.cTime ASC
END
DROP TABLE #tempArchFile
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sybFindDatabaseBackup')
	delete from GxQscripts where name = 'sybFindDatabaseBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindDatabaseBackup')
	delete from GXDBVersions where aliasname = 'sybFindDatabaseBackup'
GO

insert into GXDBVersions values(2, 'sybFindDatabaseBackup',  '00000000000000000000', 'sybFindDatabaseBackup', '00000000000000000000')
GO

