

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sybFindAllLogsBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  sybFindAllLogsBackup()
--  |
--  |Description:   Finds the latest FULL backup of the given databased id based
--  |               on the given restore time.
--  |
--  |       Input:  instanceid, subclientid, databaseId, databasename, fromRestoreTime,toRestoreTime, backupLevel.
--  |
--  |      Output:  Returns the following columns:
--  |                archFileId archGroupdId, commCellId, appId, stream, maxStream,
--  |                archFileCTime, jobId,sybArchFileId,finishTime
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        param      Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sybFindAllLogsBackup <<<'

IF EXISTS (select * from sysobjects where name='sybFindAllLogsBackup')
	drop procedure sybFindAllLogsBackup
IF EXISTS (select * from GxQscripts where name='sybFindAllLogsBackup')
	delete from GxQscripts where name = 'sybFindAllLogsBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindAllLogsBackup')
	delete from GXDBVersions where aliasname = 'sybFindAllLogsBackup'
GO
print '... Creating Procedure: sybFindAllLogsBackup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sybFindAllLogsBackup
  @i_instanceId integer,
  @i_subclientId integer,
  @i_databaseId integer,
  @i_databaseName char(64),
  @i_fromRestoreTime integer,
  @i_toRestoreTime integer,
  @i_backupLevel integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_RestoreFlag integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @archFileId integer
  DECLARE @archGroupId integer
  DECLARE @commCellId integer
  DECLARE @appId integer
  DECLARE @stream integer
  DECLARE @maxStream integer
  DECLARE @archFileCTime integer
  DECLARE @jobId integer
  DECLARE @sybArchFileId integer
  DECLARE @finishTime integer
  DECLARE @backupLevel integer
  DECLARE @archFileName NVARCHAR(2048)
  DECLARE @archFileFlags integer
  DECLARE @copy integer
-- These lines represent the actual SQL code that will get executed.
BEGIN
     SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
     SET NOCOUNT ON
     declare @l_nextDBBackupTime integer
	 declare @l_additionalLogTime integer
	 declare @l_endRestoreTime integer
	 declare @l_diffBkpTime integer
	 declare @l_pitRestore integer
	 declare @l_skipDiffBkp integer
     set @l_nextDBBackupTime=0
	 set @l_additionalLogTime=0
	 set @l_endRestoreTime=0
     set @l_diffBkpTime=0
	 set @l_pitRestore=0
	 set @l_skipDiffBkp=0
	 if (@i_RestoreFlag & 1) = 1
	 begin
		set @l_pitRestore = 1
	 end
	 if (@i_RestoreFlag & 2) = 2
	 begin
		set @l_skipDiffBkp = 1
	 end
     if @i_fromRestoreTime <> 0
     begin
        select  @l_nextDBBackupTime = ISNULL(min(y.cTime), 0)
        from sybArchFileInfo x, archFile y
        where x.archFileId = y.id and x.commcellid = y.commcellid
        and (x.sybDatabaseName = @i_databasename or x.sybdatabaseId = @i_databaseId)
        and x.sybInstanceId = @i_instanceId     and y.cTime > @i_fromRestoreTime
        and y.backupLevel=1 and y.isValid=1
     end
	 if @l_nextDBBackupTime = 0
	 begin
		set @l_nextDBBackupTime = (SELECT dbo.GetUnixTime(GETUTCDATE()))
	 end
	set @l_endRestoreTime = @i_toRestoreTime
    IF @l_nextDBBackupTime <> 0 AND ( @l_pitRestore <> 0 OR (@i_toRestoreTime >= @l_nextDBBackupTime) )
    begin
        set @l_endRestoreTime = @l_nextDBBackupTime - 1
    end
IF object_id('tempdb.dbo.#tempSybArchFileCopy1') IS NOT NULL DROP TABLE #tempSybArchFileCopy1
IF object_id('tempdb.dbo.#tempSybArchFileCopy2') IS NOT NULL DROP TABLE #tempSybArchFileCopy2
IF object_id('tempdb.dbo.#tempSybArchFileCopy') IS NOT NULL DROP TABLE #tempSybArchFileCopy
IF object_id('tempdb.dbo.#tempArchFile') IS NOT NULL DROP TABLE #tempArchFile
 select  archFile.id,  archGroupId, archFile.commCellId, appId, stream, maxStream,
 case
 -- Checking ArchiveFile flag old value (2048) or new value CVA_SYBASE_MULTIPLE_DB_BACKUP_FLAG
 -- in which case we need to consider  startTime, over archFile ctime
 when (archFile.flags & (2048 | 262144) ) = 0 then archFile.ctime
        else sybTransLog.startTime
 end as ctime, jobId, sybArchFileInfo.id as sybArchFileId, finishTime, backupLevel,
 archFile.name as ArchFileName, archFile.flags into #tempArchFile
                from sybArchFileInfo, archFile, sybTransLog
                where sybArchFileInfo.sybInstanceId = @i_instanceId
                and sybdatabaseId = @i_databaseId
                and sybdatabaseName = @i_databaseName
                and archFile.id = sybArchFileInfo.archFileId
                and archFile.commCellId = sybArchFileInfo.commCellId
                and ( backupLevel = 2  or backupLevel = 256 or (@l_skipDiffBkp = 0 AND backupLevel = 4 AND archFile.ctime < @i_toRestoreTime) )
                and (
                ((archFile.flags & (2048 |262144)) = 0
                and archFile.ctime >= @i_fromRestoreTime
                and archFile.ctime <= @l_endRestoreTime)
                or
                --Checking ArchiveFile flag old value (2048) or new value CVA_SYBASE_MULTIPLE_DB_BACKUP_FLAG
                --in which case we need to consider  startTime, over archFile ctime
                ((archFile.flags & (2048 | 262144)) != 0
                and sybTranslog.startTime >= @i_fromRestoreTime
                and sybTransLog.finishTime <= @l_endRestoreTime)
                )
                and sybTransLog.sybArchFileId = sybArchFileInfo.id
IF @l_pitRestore <> 0
BEGIN
--We have all the LOG + CUMULTATIVE(if any) jobs in the required backup job cycle
--Now find additional log which is required for PIT restores
set @l_additionalLogTime = (SELECT top 1 max(ctime) AS archCtime
							FROM #tempArchFile
							WHERE backupLevel = 2 AND ctime >= @i_toRestoreTime
							GROUP BY jobId
							ORDER BY archCtime)
IF @l_additionalLogTime <> 0
BEGIN
DELETE FROM #tempArchFile WHERE ctime > @l_additionalLogTime
END
END -- PIT RESTORE
BEGIN
--As we have eliminated any CUMULATIVE BACKUPs, after given PIT, we need the latest CUMULATIVE job is the list.
set @l_diffBkpTime = (SELECT  top 1 min(ctime) as archCtime
					  FROM #tempArchFile
					  WHERE backupLevel = 4
					  GROUP BY jobId
					  ORDER BY archCtime desc)
END
IF @l_diffBkpTime <> 0 AND @l_skipDiffBkp = 0
BEGIN
DELETE FROM #tempArchFile WHERE ctime < @l_diffBkpTime
END
SELECT a.*, c.copy
INTO  #tempSybArchFileCopy
FROM   #tempArchFile a, archFileCopy b, archGroupCopy c
WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId
   AND a.archGroupId = c.archGroupId AND b.archCopyId = c.id
   AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
   AND ((@i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
      OR @i_copyPrecedence = 0
      OR @i_copyPrecedence = c.copy)
    AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, 5 = 5
ORDER BY c.copy ASC, a.jobId asc, a.cTime desc
IF @i_includeAgedData <> 0
BEGIN
-- Variables used for select into
DECLARE @i_ArchFileID   integer
DECLARE @i_ArchGroupID  integer
DECLARE @i_CommCellID   integer
DECLARE @i_AppID        integer
DECLARE @i_Stream       integer
DECLARE @i_MaxStream    integer
DECLARE @i_CTime        integer
DECLARE @i_JobId        integer
DECLARE @i_SybArchFileID    integer
DECLARE @i_finishTime   integer
DECLARE @i_CopyID       integer
DECLARE @i_ArchFileName nvarchar(2048)
DECLARE @i_ArchFlags    integer
-- Need this local table to temporarily insert the rows into the table.
CREATE TABLE #tempSybArchFileCopy1 (
ArchFileID  integer,
ArchGroupID integer,
CommCellID  integer,
AppID       integer,
Stream      integer,
MaxStream   integer,
CTime       integer,
JobId       integer,
SybArchFileID   integer,
finishTime  integer,
backupLevel integer,
ArchFileName nvarchar(2048),
ArchFlags   integer,
CopyID      integer)
CREATE TABLE #tempSybArchFileCopy2 (
ArchFileID  integer,
ArchGroupID integer,
CommCellID  integer,
AppID       integer,
Stream      integer,
MaxStream   integer,
CTime       integer,
JobID       integer,
SybArchFileID   integer,
finishTime  integer,
backupLevel integer,
ArchFileName nvarchar(2048),
ArchFlags   integer,
CopyID      integer)
-- Local Temporary variables used for processing the aged Data
DECLARE @i_ProcessingCopyID integer
DECLARE @i_ProcessingJobID  integer
DECLARE @i_ProcessingMaxStream  integer
DECLARE @i_StreamCount      integer
DECLARE @i_DoneProcessing       integer
DECLARE TempSybArchFileCopyCursor CURSOR
FOR
SELECT id, archGroupId, commCellId, appId, stream, maxStream, ctime, jobId, sybArchFileId,  finishTime, backupLevel, ArchFileName, flags, copy from #tempSybArchFileCopy
-- OPEN
Open TempSybArchFileCopyCursor
-- FETCH
FETCH NEXT FROM TempSybArchFileCopyCursor
INTO @i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID,  @i_finishTime, @i_backupLevel, @i_ArchFileName, @i_ArchFlags, @i_CopyID
SET @i_ProcessingCopyID = @i_CopyID
SET @i_StreamCount = 0
SET @i_DoneProcessing = 0
WHILE (@@FETCH_STATUS = 0 and @i_DoneProcessing = 0 )
BEGIN
    IF (@i_ArchFlags & (2048 | 262144) ) !=  0
    BEGIN
        IF (NOT EXISTS (    SELECT *
                            FROM    #tempSybArchFileCopy2
                            WHERE   ArchFileID = @i_ArchFileId
                                    AND CommCellID = @i_CommCellId))
        BEGIN
            INSERT INTO #tempSybArchFileCopy2
            VALUES  (@i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID,  @i_finishTime, @i_backupLevel, @i_ArchFileName, @i_ArchFlags, @i_CopyID)
        END
        FETCH NEXT FROM TempSybArchFileCopyCursor
            INTO @i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID, @i_finishTime, @i_backupLevel, @i_ArchFileName, @i_ArchFlags, @i_CopyID
        CONTINUE
    END
    IF @i_StreamCount = 0
    BEGIN
        SET @i_ProcessingJobID = @i_JobID
        SET @i_ProcessingMaxStream = @i_MaxStream
    END
    SET @i_StreamCount = @i_StreamCount + 1
--  If You found a new copy ID, then come out.
    IF ( @i_CopyID = @i_ProcessingCopyID )
    BEGIN
--      One set of valid archive files are inserted.
--      This set need to inserted to #tempSybArchFileCopy2
--      @i_StreamCount = 0, means insert the valid set into #tempSybArchFileCopy2
--      and start processing the next set.
        IF (@i_StreamCount = @i_ProcessingMaxStream AND @i_ProcessingJobID = @i_JobID)
        BEGIN
            SET @i_StreamCount = 0
        END
        ELSE
        BEGIN
--          Here is the inconsistency different Job IDs
--          Different # of archive files.
--          Dont have process it. Come out
            IF (@i_ProcessingJobID <> @i_JobID AND @i_StreamCount <> @i_ProcessingMaxStream)
            BEGIN
                SET @i_DoneProcessing=1
            END
        END
        IF @i_DoneProcessing = 0
        BEGIN
            INSERT INTO #tempSybArchFileCopy1
            VALUES (@i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID,  @i_finishTime, @i_backupLevel, @i_ArchFileName, @i_ArchFlags, @i_CopyID)
--
--          There is something to be inserted int #tempSybArchFileCopy2.
--
            IF @i_StreamCount = 0
            BEGIN
                INSERT INTO #tempSybArchFileCopy2  SELECT * FROM #tempSybArchFileCopy1
                TRUNCATE TABLE #tempSybArchFileCopy1
            END
            FETCH NEXT FROM TempSybArchFileCopyCursor
            INTO @i_ArchFileID, @i_ArchGroupID, @i_CommCellID, @i_AppID, @i_Stream, @i_MaxStream, @i_CTime, @i_JobID, @i_SybArchFileID, @i_finishTime, @i_backupLevel, @i_ArchFileName, @i_ArchFlags, @i_CopyID
        END
    END
    ELSE
    BEGIN
        SET @i_DoneProcessing = 1
    END
END
CLOSE TempSybArchFileCopyCursor
DEALLOCATE TempSybArchFileCopyCursor
select * from #tempSybArchFileCopy2 order by CTime;
DROP TABLE #tempSybArchFileCopy1
DROP TABLE #tempSybArchFileCopy2
END
ELSE
BEGIN
    SELECT * FROM #tempSybArchFileCopy order by CTime
END
END
DROP TABLE #tempSybArchFileCopy
DROP TABLE #tempArchFile
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sybFindAllLogsBackup')
	delete from GxQscripts where name = 'sybFindAllLogsBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybFindAllLogsBackup')
	delete from GXDBVersions where aliasname = 'sybFindAllLogsBackup'
GO

insert into GXDBVersions values(2, 'sybFindAllLogsBackup',  '00000000000000000000', 'sybFindAllLogsBackup', '00000000000000000000')
GO

