

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sqlBrowseDbBackupsAddInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sqlBrowseDbBackupsAddInfo.sp,v $ $Id: sqlBrowseDbBackupsAddInfo.sp,v 1.2.2.2 2018/03/27 09:08:08 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: sqlBrowseDbBackupsAddInfo
--  |
--  | Description:
--  |  Gets the databases backed up during browse and restore along with
--	|  additional information (SP_CONTENT_DB)
--  |
--  |   Revisions  Author				Description
--  |   ---------  --------------		---------------------------------------------
--  |   1.0        ankumar		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sqlBrowseDbBackupsAddInfo <<<'

IF EXISTS (select * from sysobjects where name='sqlBrowseDbBackupsAddInfo')
	drop procedure sqlBrowseDbBackupsAddInfo
IF EXISTS (select * from GxQscripts where name='sqlBrowseDbBackupsAddInfo')
	delete from GxQscripts where name = 'sqlBrowseDbBackupsAddInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sqlBrowseDbBackupsAddInfo')
	delete from GXDBVersions where aliasname = 'sqlBrowseDbBackupsAddInfo'
GO
print '... Creating Procedure: sqlBrowseDbBackupsAddInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sqlBrowseDbBackupsAddInfo
  @i_unixTime integer,
  @i_serverId integer,
  @i_browseType integer,
  @i_dataType integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_excludeBeforeTime integer,
  @i_jobid integer,
  @i_ccid_1 integer,
  @i_ccid_2 integer
AS
  DECLARE @o_dbName nvarchar(128);
  DECLARE @o_dbId integer;
  DECLARE @o_majorVersion integer;
  DECLARE @o_minorVersion integer;
  DECLARE @o_buildVersion integer;
  DECLARE @o_bkpFinishTime integer;
  DECLARE @o_jobId integer;
  DECLARE @o_commCellId integer;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#appIdTable') is not null DROP TABLE #appIdTable
CREATE TABLE #appIdTable
(
	appId INT
)
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
CREATE TABLE #archFileIdTable
(
	archFileId INT,
	commCellId INT,
	jobId INT
)
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
CREATE TABLE #sqlDbBackupFileIdTable
(
	sqlDbBackupFileId INT,
	jobId INT,
	commCellId INT
)
IF @i_jobid = 0
BEGIN
	INSERT	INTO #appIdTable
		SELECT	DISTINCT appId
		FROM	sqlDbBackupInfo
		WHERE	instanceId = @i_serverId
			AND backup_finish_Date <= @i_unixTime
			AND backup_finish_Date >= @i_excludeBeforeTime
	IF @i_copyPrecedence = 0
		INSERT	INTO #archFileIdTable
		SELECT a.id, a.commCellId, a.jobid
		FROM	archFile a, archFileCopy b, archGroupCopy c
		WHERE	a.appId IN (SELECT appId FROM #appIdTable)
			AND a.id = b.archFileId AND a.commCellId = b.commCellId
			AND a.cTime >= @i_excludeBeforeTime
			AND a.cTime <= @i_unixTime
			AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
			AND b.archCopyId = c.id
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	ELSE
		INSERT	INTO #archFileIdTable
		SELECT	DISTINCT a.id, a.commCellId, a.jobid
		FROM	archFile a, archFileCopy b, archGroupCopy c
		WHERE	a.appId IN (SELECT appId FROM #appIdTable)
			AND a.id = b.archFileId AND a.commCellId = b.commCellId
			AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
			AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
			AND a.cTime >= @i_excludeBeforeTime
			AND a.cTime <= @i_unixTime
			AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
END
ELSE
BEGIN
	INSERT	INTO #appIdTable
		SELECT	DISTINCT appId
		FROM	archfile
		WHERE	jobid = @i_jobid
			AND commCellId = @i_ccid_1
	IF @i_copyPrecedence = 0
		INSERT	INTO #archFileIdTable
		SELECT a.id, a.commCellId, a.jobid
		FROM	archFile a, archFileCopy b, archGroupCopy c
		WHERE	a.appId IN (SELECT appId FROM #appIdTable)
			AND a.id = b.archFileId AND a.commCellId = b.commCellId
			AND a.jobid = @i_jobid
			AND a.commcellid = @i_ccid_1
			AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
			AND b.archCopyId = c.id
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	ELSE
		INSERT	INTO #archFileIdTable
		SELECT	DISTINCT a.id, a.commCellId, a.jobid
		FROM	archFile a, archFileCopy b, archGroupCopy c
		WHERE	a.appId IN (SELECT appId FROM #appIdTable)
			AND a.id = b.archFileId AND a.commCellId = b.commCellId
			AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
			AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
			AND a.jobid = @i_jobid
			AND a.commcellid = @i_ccid_1
			AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
END
update #archFileIdTable
set #archFileIdTable.commCellId = JMPreparedJob.commCellId, #archFileIdTable.jobId = JMPreparedJob.jobId, #archFileIdTable.archFileId = archFile.id
from JMPreparedJob, archFile
Where
JMPreparedJob.preparedJobId = #archFileIdTable.jobId and
JMPreparedJob.preparedJobCCId = #archFileIdTable.commCellId AND
archFile.jobId = JMPreparedJob.jobId and
archFile.commCellId = JMPreparedJob.commCellId
INSERT	INTO #sqlDbBackupFileIdTable
SELECT	DISTINCT sqlDbBackupFileId, b.jobId, b.commCellId
FROM	sqlArchiveInfo a, #archFileIdTable b
WHERE	a.aFileId = b.archFileId AND a.commCellId = b.commCellId
BEGIN
		INSERT	INTO #sqlDbBackupFileIdTable
			SELECT	DISTINCT dbinfo.ID, afid.jobId, afid.commCellId
			FROM sqldbbackupinfo dbinfo, #archFileIdTable afid
			WHERE
			dbinfo.jobId = afid.jobId and
			dbinfo.id not in (select sqlDbBackupFileId from #sqlDbBackupFileIdTable) and
			dbinfo.backupMethod = 2
END
IF @i_jobid = 0
BEGIN
	SELECT	c2.name, b.dbId, b.majorVersion, b.minorVersion, b.buildVersion, b.backup_finish_date, a.jobId, a.commCellId
	FROM	#sqlDbBackupFileIdTable a, sqlDbBackupInfo b, sqlNames c, sqlNames2 c2
	WHERE	b.id = a.sqlDbBackupFileId
		AND c.sqlid = c2.id
		AND c.id = b.sqlNameId
		AND b.backup_finish_date <= @i_unixTime
	ORDER BY backup_finish_date DESC
END
ELSE
BEGIN
	SELECT	c2.name, b.dbId, b.majorVersion, b.minorVersion, b.buildVersion, b.backup_finish_date, a.jobId, a.commCellId
	FROM	#sqlDbBackupFileIdTable a, sqlDbBackupInfo b, sqlNames c, sqlNames2 c2
	WHERE	b.id = a.sqlDbBackupFileId
		AND c.sqlid = c2.id
		AND c.id = b.sqlNameId
	ORDER BY backup_finish_date DESC
END
IF object_id('tempdb.dbo.#appIdTable') is not null DROP TABLE #appIdTable
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
GO

IF EXISTS (select * from GxQscripts where name = 'sqlBrowseDbBackupsAddInfo')
	delete from GxQscripts where name = 'sqlBrowseDbBackupsAddInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sqlBrowseDbBackupsAddInfo')
	delete from GXDBVersions where aliasname = 'sqlBrowseDbBackupsAddInfo'
GO

insert into GXDBVersions values(2, 'sqlBrowseDbBackupsAddInfo',  '00010002000200020000', 'sqlBrowseDbBackupsAddInfo', '00010002000200020000')
GO

