

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_SearchUserGroups.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_SearchUserGroups.sp,v $ $Id: sp_dm2_cve_SearchUserGroups.sp,v 1.1.2.2 2018/03/27 09:15:29 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_cve_SearchUserGroups <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_SearchUserGroups')
	drop procedure sp_dm2_cve_SearchUserGroups
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_SearchUserGroups')
	delete from GxQscripts where name = 'sp_dm2_cve_SearchUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SearchUserGroups')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SearchUserGroups'
GO
print '... Creating Procedure: sp_dm2_cve_SearchUserGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_SearchUserGroups
  @i_userGuid varchar(256), 
  @i_groupID int = 0,
  @i_debug bit = 0,
  @i_offset int = 0,
  @i_filter bigint = 0
AS
	SET NOCOUNT ON;
  DECLARE @o_outXML XML;
--Constants
DECLARE
		@FILTER_SORTBYRECENT BIGINT = 2,
		@FILTER_SORTBYUSERS BIGINT = 8,
		@FILTER_PUBLIC BIGINT = 1024,
		@FILTER_PRIVATE BIGINT = 2048,
		@FILTER_NONE BIGINT = 0,
		@FILTER_DEFAULT BIGINT = 1,
		--@VISIBILITYTYPE_PUBLIC INT = 1,
		--@VISIBILITYTYPE_PRIVATE INT = 2,
		@GROUPTYPE_NONE INT =0,
		@USERTYPE_REJECTED INT = 8,
		@USERTYPE_LEFT INT = 10,
		@USERTYPE_REMOVED INT = 11
DECLARE @UserList TABLE (ParticipantID INT)
DECLARE @GroupIDList TABLE (GroupID INT)
DECLARE @tags nvarchar(max) = N'';
DECLARE @Tag TABLE (tag nvarchar(256) )
	IF ISNULL(@i_groupID, 0) > 0
	BEGIN
		INSERT INTO @GroupIDList
		SELECT @i_groupID AS GroupID
		--Updating last seen of user for this group
		UPDATE CvEvents_GroupUser
		SET LastSeen=GETUTCDATE()
		WHERE GroupUserGuid=ISNULL(@i_userguid,'') AND GroupID=@i_groupID
	END
	ELSE
	BEGIN
		--Getting interests of user to display groups(public only) he might be interested
		SELECT @tags=Tags from CvEvents_User with(nolock) where UserID=@i_userguid AND ISNULL(Tags,'') <> ''
		IF @tags <> ''
		BEGIN
		--Getting all tags of user in @Tag table
		INSERT INTO @Tag
		SELECT Data FROM dbo.SplitString(@tags,';')
		END
		;WITH GR
		AS
		(
		SELECT DISTINCT GroupID FROM CvEvents_GroupUser GU WITH(NOLOCK)
		WHERE GU.GroupUserGuid = @i_userGuid AND GU.MembershipStatus NOT IN (@USERTYPE_REJECTED,@USERTYPE_REMOVED,@USERTYPE_LEFT)	---getting all the groups in which user is member
		UNION
		/*
		SELECT DISTINCT id FROM UMGroups G WITH(NOLOCK) ,@Tag T
		WHERE G.VisibilityType & @VisibilityType_Public =@VisibilityType_Public AND CHARINDEX(T.tag,' ' + REPLACE(G.tags,';',' ')) > 0	---getting all public groups in which user is interested
		UNION*/
		SELECT DISTINCT USG.groupId
		FROM UMUserGroup USG WITH(NOLOCK)
		JOIN UMUsers UU WITH(NOLOCK) ON UU.userGuid = @i_userGuid AND UU.id = USG.userId
		JOIN UMGroups UG WITH(NOLOCK) ON USG.groupId = UG.id AND UG.groupFlags = 1	--added to show comcell groups created from commcell gui
		)
		INSERT INTO @GroupIDList
		SELECT G.id FROM UMGroups G WITH(NOLOCK)
		JOIN GR ON GR.GroupID = G.id
	END
	IF @i_debug = 1
		SELECT * FROM @GroupIDList
	/* If groups exists for users */
	IF EXISTS (SELECT TOP 1 * FROM @GroupIDList)
	BEGIN
		SELECT
		(
			SELECT G.id AS '@groupId'
			,name AS '@groupName'
			,description AS '@groupDesc'
			--,dbo.GetUnixTimeBig(G.ModifiedTime)*1000 AS '@modifiedTime'
			--,VisibilityType AS '@visibilityType'
			--,ModifiedType AS '@gModifiedType'
			/*,
			(
			SELECT
			CASE WHEN ISNULL(AU.MailID,'') <> '' THEN GA.Data ELSE '' END AS '@smtpAddress',
			CASE WHEN ISNULL(AU.MailID,'') <> '' THEN AU.DisplayName ELSE GA.Data END AS '@displayName'
			FROM dbo.split(G.AdminsList, ';') GA
			LEFT JOIN CvEvents_User AU WITH(NOLOCK) ON GA.Data = AU.MailID
			FOR XML PATH('groupAdminsDisp'), TYPE
			),
			(
			SELECT
			CASE WHEN ISNULL(MU.MailID,'') <> '' THEN GM.Data ELSE '' END AS '@smtpAddress',
			CASE WHEN ISNULL(MU.MailID,'') <> '' THEN MU.DisplayName ELSE GM.Data END AS '@displayName'
			FROM dbo.split(G.MembersList, ';') GM
			LEFT JOIN CvEvents_User MU WITH(NOLOCK) ON GM.Data = MU.MailID
			FOR XML PATH('groupMembersDisp'), TYPE
			),*/
				--Getting group users
				,(
				SELECT DISTINCT U.UserID AS '@userGuid'
				,U.MailID AS '@smtpAddress'
				,U.DisplayName AS '@displayName'
				,GU.GroupType AS '@groupType'
				,GU.MembershipStatus AS '@userType'
				,GU.NotificationCode AS '@notificationCode'
				FROM CvEvents_User U WITH(NOLOCK)
				JOIN CvEvents_GroupUser GU WITH(NOLOCK) ON
				U.UserID = GU.GroupUserGuid AND
				GU.GroupID = GL.GroupID AND
				GU.GroupType=@GROUPTYPE_NONE AND
				GU.MembershipStatus NOT IN (@USERTYPE_REJECTED,@USERTYPE_REMOVED,@USERTYPE_LEFT)  --removing rejected,removed, or left users from group
				FOR XML PATH('groupUsers'), TYPE
				)
			FROM UMGroups G WITH(NOLOCK) JOIN @GroupIDList GL ON G.id = GL.groupID
			/*AND
			(@i_filter=@Filter_None
			OR (@i_filter & @Filter_Public = @Filter_Public AND G.VisibilityType & @VisibilityType_Public = @VisibilityType_Public)
			OR (@i_filter & @Filter_Private = @Filter_Private AND G.VisibilityType & @VisibilityType_Private = @VisibilityType_Private)
			OR @i_filter & @Filter_Default = @Filter_Default
			)*/
			order by
			 G.id desc
			FOR XML PATH('groups'), TYPE
		)
		FOR XML PATH('DM2ContentIndexing_CvEventResp')
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_SearchUserGroups')
	delete from GxQscripts where name = 'sp_dm2_cve_SearchUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SearchUserGroups')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SearchUserGroups'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_SearchUserGroups',  '00010001000200020000', 'sp_dm2_cve_SearchUserGroups', '00010001000200020000')
GO

