

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_SearchUserEvents.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_SearchUserEvents.sp,v $ $Id: sp_dm2_cve_SearchUserEvents.sp,v 1.8.14.20 2020/08/27 00:59:16 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_SearchUserEvents')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_cve_SearchUserEvents <<<'
	drop procedure sp_dm2_cve_SearchUserEvents
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_SearchUserEvents')
	delete from GxQscripts where name = 'sp_dm2_cve_SearchUserEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SearchUserEvents')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SearchUserEvents'
GO
print '... Creating Procedure: sp_dm2_cve_SearchUserEvents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_SearchUserEvents
  @i_userguid varchar(256), 
  @i_startDate bigint = 0,
  @i_endDate bigint = 0,
  @i_eventId int = 0,
  @i_isOrganizerSearch BIT =0,
  @i_searchOnlyQuestion BIT=0,
  @i_participantWithResp BIT =0,
  @i_getMailContent BIT=0,
  @i_debug bit = 0,
  @i_offset int = 0,
  @i_filter bigint = 1,
  @i_getInterestedParticipants BIT = 0,	
  @i_fetchCount int = 0,
  @i_eventTitle nvarchar(1024) = ''
AS
DECLARE @ParticipantList TABLE (ParticipantID INT)
DECLARE @EventIdList TABLE (EventId INT, isExpired INT)
DECLARE @currentTime bigint = 0;
DECLARE @tags nvarchar(max) = ''
DECLARE @totalEvents int = 0
DECLARE @Tag TABLE (tag nvarchar(256) )
--Constants
DECLARE
		@FILTER_SORTBYRECENT BIGINT = 2,
		@FILTER_SORTBYUSERS BIGINT = 8,
		@FILTER_PUBLIC BIGINT = 1024,
		@FILTER_PRIVATE BIGINT = 2048,
		@FILTER_NONE BIGINT = 0,
		@FILTER_DEFAULT BIGINT = 1,
		@FILTER_PROPOSAL BIGINT = 4096,
		@FILTER_EVENT BIGINT = 8192,
		@FILTER_DRAFT BIGINT = 16384,
		@FILTER_EXPIRED BIGINT = 16,
		@FILTER_FAVORITE BIGINT = 524288,
		@FILTER_UPCOMING BIGINT = 1048576,
		@FILTER_PAST BIGINT = 2097152,
		@FILTER_SURVEY BIGINT = 4194304,
		@FILTER_TEMPLATE BIGINT = 8388608,
		@FILTER_NON_WEBCONSOLE BIGINT = 16777216,
		@EVENTTYPE_PUBLIC INT = 1,
		@EVENTTYPE_PRIVATE INT = 2,
		@EVENTTYPE_PROPOSAL INT = 4,
		@EVENTTYPE_EVENT INT = 8,
		@EVENTTYPE_SURVEY INT = 16,
		@EVENTTYPE_TEMPLATE INT = 32,
		@EVENTTYPE_NON_WEBCONSOLE INT = 64,
		@DEFAULT_FETCHCOUNT INT = 9
		--@GROUPTYPE_LOGICAL INT = 2,
		--@GROUPTYPE_NONE INT  = 0
--TODO comment
SET @currentTime= cast(Datediff(s, '1970-01-01 00:00:00', GETUTCDATE()) AS bigint)*1000; --To get the current time for filters
	IF ISNULL(@i_eventId, 0) > 0 OR ISNULL(@i_eventTitle, '') <> ''
	BEGIN
		IF dbo.canManageEventSurvey(@i_userguid, @i_eventId, 3) = 1
		BEGIN
			IF ISNULL(@i_eventTitle, '') <> ''
			BEGIN
				SELECT @i_eventId=EventID FROM CvEvents_Event WITH(NOLOCK) WHERE EventType & @EVENTTYPE_TEMPLATE = @EVENTTYPE_TEMPLATE AND Title=@i_eventTitle
			END
			/*	Updating filter value in case 	*/
			SET @i_filter = @FILTER_DEFAULT
			INSERT INTO @EventIdList
			SELECT @i_eventId AS EventId,
			0 as isExpired
			--Updating last seen of user for this event
			UPDATE CvEvents_Participant SET LastSeen=GETUTCDATE() WHERE GroupUserGuid=@i_userguid AND EventID=@i_eventId
		END
	END
	ELSE
	BEGIN
		--Getting interests of user to display events or proposal(public only) he might be interested
		SELECT @tags=Tags from CvEvents_User with(nolock) where UserID=@i_userguid AND ISNULL(Tags,'') <> ''
		IF @tags <> ''
		BEGIN
		--Getting all tags of user in @Tag table
		INSERT INTO @Tag
		SELECT Data FROM dbo.SplitString(@tags,';')
		END
		;WITH OP
		AS
		(
		SELECT DISTINCT EventID FROM CvEvents_Organizer O WITH(NOLOCK)
		WHERE O.GroupUserGuid = @i_userguid
		UNION
		SELECT DISTINCT P.EventID FROM CvEvents_Participant P, CvEvents_Event E WITH(NOLOCK)
		WHERE P.GroupUserGuid = @i_userguid AND P.EventID = E.EventID AND E.isDraft = 0	--ignore draft events
		--UNION
		--SELECT DISTINCT E.EVENTID FROM CvEvents_Event E WITH(NOLOCK)
		--WHERE CreatedBy = @i_userguid
		UNION
		--Getting public events matching to the user interest or created by user
		SELECT DISTINCT E.EVENTID FROM CvEvents_Event E WITH(NOLOCK) , @Tag T
		where ((E.EventType & @EVENTTYPE_PUBLIC) = @EVENTTYPE_PUBLIC AND CHARINDEX(T.tag,' ' + REPLACE(E.Tags,';',' ')) > 0 AND E.ExpiryDate > @currentTime) AND E.isDraft = 0	-- ignore draft events
		)
		INSERT INTO @EventIdList
		SELECT E.EventID as EventId,
		CASE  WHEN E.isDraft = 1 OR ((E.EventType & @EVENTTYPE_SURVEY) = @EVENTTYPE_SURVEY AND E.ExpiryDate >= @currentTime) OR ((E.EventType & @EVENTTYPE_PROPOSAL) = @EVENTTYPE_PROPOSAL AND E.ScheduledDate = 0) OR (E.ScheduledEndDate >= @currentTime) THEN
		(
			Select 0 AS isExpired
		)
		WHEN  ((E.EventType & @EVENTTYPE_SURVEY) = @EVENTTYPE_SURVEY AND E.ExpiryDate < @currentTime) OR E.ScheduledEndDate <= @currentTime  THEN
		(
			Select 1 AS isExpired
		)
		END
		FROM CVEvents_Event E WITH(NOLOCK)
		JOIN OP ON OP.EventID = E.EventID
		WHERE /*(((@i_startDate = 0 OR (ScheduledDate = 0 AND (EventType & @EventType_Proposal)=@EventType_Proposal OR E.isDraft =1) OR (@i_startDate <> 0 AND ScheduledDate >= @i_startDate) OR E.isDraft =1) AND (@i_endDate = 0 OR (@i_endDate <> 0 AND ScheduledDate <> 0 AND ScheduledDate <= @i_endDate AND E.isDraft!=1))) )	--some changes here
		AND */
		(@i_filter & @FILTER_PROPOSAL = @FILTER_PROPOSAL AND E.EventType & @EVENTTYPE_PROPOSAL = @EVENTTYPE_PROPOSAL)
		OR (@i_filter & @FILTER_EVENT = @FILTER_EVENT AND E.EventType & @EVENTTYPE_EVENT = @EVENTTYPE_EVENT)
		OR (@i_filter & @FILTER_SURVEY = @FILTER_SURVEY AND E.EventType & @EVENTTYPE_SURVEY = @EVENTTYPE_SURVEY)
		OR (@i_filter & @FILTER_TEMPLATE = @FILTER_TEMPLATE AND E.EventType & @EVENTTYPE_TEMPLATE = @EVENTTYPE_TEMPLATE)
		OR (@i_filter & @FILTER_NON_WEBCONSOLE = @FILTER_NON_WEBCONSOLE AND E.EventType & @EVENTTYPE_NON_WEBCONSOLE = @EVENTTYPE_NON_WEBCONSOLE)	--applying filter
		--DECLARE @v XML = (SELECT * FROM @EventIdList FOR XML AUTO)--Debugging (to be removed)
	END
	IF @i_debug = 1
		SELECT * FROM @EventIdList
	/* If Interested events for user exist start */
	select 	@totalEvents=count(*) from @EventIdList		--getting total event count for pagination.
	IF @totalEvents > 0
	BEGIN
		IF @i_fetchCount = 0
		BEGIN
			SET @i_fetchCount=@totalEvents
		END
		IF @i_isOrganizerSearch = 0
			BEGIN
				INSERT INTO @ParticipantList
								SELECT CP.ParticipantID FROM CvEvents_Participant CP WITH(NOLOCK)  WHERE CP.EventID IN(SELECT EventId FROM @EventIdList) AND CP.GroupUserGuid = @i_userguid AND CP.GroupType=0
			END
		ELSE
			BEGIN
				INSERT INTO @ParticipantList
				SELECT CP.ParticipantID FROM CvEvents_Participant CP WITH(NOLOCK) WHERE CP.EventID IN(SELECT EventId FROM @EventIdList) AND CP.GroupType=0
			END
			IF @i_getInterestedParticipants = 1
			BEGIN
				DELETE FROM @ParticipantList
				/** getting interested participants in case converting from proposal to event */
				INSERT INTO @ParticipantList
				SELECT CP.ParticipantID
				FROM
				@EventIdList EL
				JOIN CvEvents_Participant CP WITH(NOLOCK) ON CP.EventID = EL.EventId
				JOIN CvEvents_Response R WITH(NOLOCK) ON R.ParticipantID=CP.ParticipantID
				JOIN CvEvents_Question Q WITH(NOLOCK) ON R.QuestionID = Q.QuestionID
				JOIN CvEvents_QuestionOption QO WITH(NOLOCK) ON QO.QuestionID = Q.QuestionID AND QO.OptionValue = 'Yes' AND R.OptionID = QO.QuestionOptionID
			END
		SELECT @totalEvents as '@totalEvents',
		(
			SELECT CASE WHEN LTRIM(RTRIM(U.DisplayName)) <> '' THEN U.DisplayName ELSE U.MailID END AS '@displayName'
			FROM CvEvents_User U WHERE U.UserID = @i_userguid
			FOR XML PATH('users'), TYPE
		),
		(
			SELECT E.EventID as '@eventID', Title as '@eventTitle',
			Description as '@eventDescription',
			dbo.GetUnixTime(CreationTime) as '@eventCreationTime',
			ScheduledDate AS '@eventScheduledTime',
			ScheduledEndDate AS '@eventScheduledEndTime',
			ExpiryDate as '@eventExpiryDate',
			IIF(@i_eventId = 0, null,ImageFileName) as '@eventImageFilename',
			isDraft		as '@isDraft',
			OldScheduledDate AS '@eventOldScheduledTime',
			OldScheduledEndDate AS '@eventOldScheduledEndTime',
			isGuestAllowed AS '@isGuestAllowed',
			EventType AS '@eventType',
			Tags AS '@tags',
			MaxUserLimit AS '@maxUserLimit',
			MinUserLimit AS '@minUserLimit',
			CASE @i_getMailContent WHEN 1 THEN
			(
				SELECT e.MailContent AS 'cvEventMailContentData' from CvEvents_Event e WITH (NOLOCK) where e.EventID=EL.EventId
				FOR XML PATH('eventMailContent'), TYPE
			)
			END,
			CASE isGuestAllowed WHEN 1 THEN
			(
			SELECT distinct ISNULL(P.AdultCount,0) AS '@adultCount',ISNULL(P.ChildCount,0) as '@childCount',
				(CASE WHEN LTRIM(RTRIM(U.displayName))IS NOT NULL AND LTRIM(RTRIM(U.displayName))<>''
				THEN U.displayName ELSE U.MailID END) AS '@userName'
				FROM CvEvents_User U WITH(NOLOCK)
				JOIN CvEvents_Participant P WITH(NOLOCK) ON U.UserID = P.GroupUserGuid AND P.EventID = E.EventID
				JOIN @ParticipantList PL ON P.ParticipantID=PL.ParticipantID
				JOIN CvEvents_Response CR WITH(NOLOCK) ON PL.ParticipantID=CR.ParticipantID
				FOR XML PATH('guestCount'), TYPE
			)
			END,
			CASE @i_searchOnlyQuestion WHEN 0 THEN
			(
				SELECT
				[1] AS '@eventAddressLine1',
				[2] AS '@eventAddressLine2',
				[3] AS '@eventAptRoom',
				[4] AS '@eventCity',
				[5] AS '@eventState',
				[6] AS '@eventZipCode',
				[7] AS '@gpsXcoordinate',
				[8] AS '@gpsYcoordinate'
				FROM
				(SELECT * FROM dbo.split((SELECT Location from CvEvents_Event IE WITH (NOLOCK) WHERE IE.EventID = E.EventID), '|') ) As SourceTable
				PIVOT
				(max (data) FOR Id IN([1],[2],[3], [4],[5],[6],[7],[8])
				) As PivotTable
				FOR XML PATH('eventAddr'), TYPE
			)END,
			CASE @i_searchOnlyQuestion WHEN 0 THEN
			(
				SELECT
				[1] AS '@eventAddressLine1',
				[2] AS '@eventAddressLine2',
				[3] AS '@eventAptRoom',
				[4] AS '@eventCity',
				[5] AS '@eventState',
				[6] AS '@eventZipCode',
				[7] AS '@gpsXcoordinate',
				[8] AS '@gpsYcoordinate'
				FROM
				(SELECT * FROM dbo.split((SELECT OldLocation from CvEvents_Event IE WITH (NOLOCK) WHERE IE.EventID = E.EventID), '|') ) As SourceTable
				PIVOT
				(max (data) FOR Id IN([1],[2],[3], [4],[5],[6],[7],[8])
				) As PivotTable
				FOR XML PATH('eventOldAddr'), TYPE
			)END,
			CASE @i_searchOnlyQuestion WHEN 0 THEN
			(
				SELECT * from ( SELECT
				CASE WHEN ISNULL(OU.MailID,'') <> '' THEN OT.Data ELSE '' END AS '@smtpAddress',
				CASE WHEN ISNULL(OU.MailID,'') <> '' THEN OU.DisplayName ELSE OT.Data END AS '@displayName'
				FROM dbo.split(E.OrganizersList, ';') OT
				LEFT JOIN CvEvents_User OU WITH(NOLOCK) ON OT.Data = OU.MailID
				JOIN CvEvents_Organizer O WITH(NOLOCK) ON OU.UserID = O.GroupUserGuid AND O.EventID = E.EventID
				UNION
				SELECT
				OT.Data  AS '@smtpAddress',
				OT.Data  AS '@displayName'
				FROM dbo.split(E.OrganizersList, ';') OT
				where NOT EXISTS (Select 1 from CvEvents_User where MailID =OT.Data ) ) AS US
				FOR XML PATH('eventOrganizersDisp'), TYPE
			)END,
			CASE @i_searchOnlyQuestion WHEN 0 THEN
			(
				SELECT * from ( SELECT
				CASE WHEN ISNULL(PU.MailID,'') <> '' THEN PT.Data ELSE '' END AS '@smtpAddress',
				CASE WHEN ISNULL(PU.MailID,'') <> '' THEN PU.DisplayName ELSE PT.Data END AS '@displayName'
				FROM dbo.split(E.ParticipantsList, ';') PT
				LEFT JOIN CvEvents_User PU WITH(NOLOCK) ON PT.Data = PU.MailID
				JOIN CvEvents_Participant P WITH(NOLOCK) ON PU.UserID = P.GroupUserGuid AND P.EventID = E.EventID
				UNION
				SELECT
				PT.Data  AS '@smtpAddress',
				PT.Data  AS '@displayName'
				FROM dbo.split(E.ParticipantsList, ';') PT
				where NOT EXISTS (Select 1 from CvEvents_User  where MailID =PT.Data ) ) AS US
				FOR XML PATH('eventParticipantsDisp'), TYPE
			)END,
			(
				SELECT U.MailID '@smtpAddress', U.UserID AS '@userGuid', U.DisplayName as '@displayName', O.isFavorite as '@isFavorite',O.NotificationCode as '@notificationCode', U.Department as '@department'
				FROM CvEvents_User U WITH(NOLOCK)
				JOIN CvEvents_Organizer O WITH(NOLOCK) ON U.UserID = O.GroupUserGuid AND O.EventID = E.EventID AND O.GroupType=0
				FOR XML PATH('eventOrganizers'), TYPE
			),
			CASE WHEN @i_getInterestedParticipants = 0 THEN
			(
				SELECT U.MailID '@smtpAddress', U.UserID AS '@userGuid', U.DisplayName as '@displayName',
				CASE WHEN P.ParticipantID NOT IN (SELECT CR.ParticipantId FROM CvEvents_Question CQ WITH(NOLOCK) INNER JOIN CvEvents_Response CR WITH(NOLOCK) ON CQ.QuestionID=CR.QuestionID WHERE CQ.EventID = E.EventID ) THEN null ELSE ParticipatedAt END as '@participatedAt',
				P.ParticipationStatus as '@userType',P.isFavorite as '@isFavorite',P.NotificationCode as '@notificationCode',U.Department as '@department'
				FROM CvEvents_User U WITH(NOLOCK)
				JOIN CvEvents_Participant P WITH(NOLOCK) ON U.UserID = P.GroupUserGuid AND P.EventID = E.EventID AND P.GroupType=0
				FOR XML PATH('eventParticipants'), TYPE
			)
			WHEN @i_getInterestedParticipants = 1 THEN
			(
				SELECT U.MailID '@smtpAddress', U.UserID AS '@userGuid', U.DisplayName as '@displayName',P.ParticipatedAt as '@participatedAt', P.ParticipationStatus as '@userType',P.isFavorite as '@isFavorite',P.NotificationCode as '@notificationCode',U.Department as '@department'
				FROM CvEvents_User U WITH(NOLOCK)
				JOIN CvEvents_Participant P WITH(NOLOCK) ON U.UserID = P.GroupUserGuid AND P.EventID = E.EventID AND P.GroupType=0
				JOIN @ParticipantList PL ON P.ParticipantID=PL.ParticipantID
				FOR XML PATH('eventParticipants'), TYPE
			)END,
			(
				SELECT Q.QuestionID AS '@eventQuestionID', Q.QuestionTitle AS '@eventQuestionTitle',( CASE Q.QuestionType WHEN 'radio' THEN 0 WHEN 'select' THEN 1 WHEN 'checkbox' THEN 2 WHEN 'text' THEN 3 WHEN 'textarea' THEN 4 WHEN 'rating' THEN  5 WHEN 'multiselect_rating' THEN  10 END) AS '@eventQuestionType',
				(CASE  WHEN Q.QuestionType IN('text', 'textarea') THEN
					(SELECT count(CR.ResponseID)
					FROM CvEvents_Response CR WITH(NOLOCK) WHERE CR.QuestionID=Q.QuestionID AND CR.ParticipantID IN(SELECT PL.ParticipantID FROM @ParticipantList PL)
					)
				  END) as '@CustomQuestionStats',
				(
					SELECT QuestionOptionID as '@eventQuestionOptionID', QO.OptionValue AS '@eventOptionVal',
					QO.DisplayOrder AS '@eventOptionDisplayOrder', QO.IsDefault AS '@eventOptionIsDefault',
					QO.OptionType AS '@eventQuestionOptionType',QO.SubOptionValue AS '@eventQuestionOptionTypeValue',
					(
						SELECT QS.OptionCount '@count' FROM
						(
							SELECT COUNT(OptionID) AS OptionCount FROM CvEvents_Response R WITH(NOLOCK)
							WHERE R.OptionID = QO.QuestionOptionID AND
							((Q.QuestionType IN ('textarea', 'text') AND ISNULL(R.CustomResponse, '') <> '')
							OR(Q.QuestionType NOT IN ('textarea', 'text'))
							) GROUP BY OptionID
						) QS
						FOR XML PATH('questionOptionStats'), TYPE
					)
					FROM CvEvents_QuestionOption QO WITH(NOLOCK)
					WHERE QO.QuestionID = Q.QuestionID
					FOR XML PATH('eventQuestionOptions'), TYPE
				),
				CASE @i_searchOnlyQuestion WHEN 0 THEN
				(
					SELECT CR.ResponseID AS '@eventResponseID',CR.ParticipantID AS '@eventParticipantID',CR.CustomResponse AS '@eventCustomResponse',
					(select
						(CASE
							WHEN LTRIM(RTRIM(cu.displayName))IS NOT NULL AND LTRIM(RTRIM(cu.displayName))<>''
							THEN cu.displayName ELSE cu.MailID
						END)
						from CvEvents_User cu WITH(NOLOCK) where cu.UserID in(select cp.GroupUserGuid from CvEvents_Participant cp WITH(NOLOCK) where cp.ParticipantID=cr.ParticipantID )) as '@participantName',
					(select cu.Department from CvEvents_User cu WITH(NOLOCK) where cu.UserID in(select cp.GroupUserGuid from CvEvents_Participant cp WITH(NOLOCK) where cp.ParticipantID=cr.ParticipantID ))as '@department',
					(SELECT CRR.OptionID AS '@val' FROM CvEvents_Response CRR WITH(NOLOCK) WHERE CRR.ResponseID=CR.ResponseID FOR XML PATH('eventOptionResponse'),TYPE),
					(SELECT CR.ResponseXml as responseXml)
					FROM CvEvents_Response CR WITH(NOLOCK) WHERE CR.QuestionID=Q.QuestionID AND CR.ParticipantID IN(SELECT PL.ParticipantID FROM @ParticipantList PL)
					FOR XML PATH('eventQuestionResponse'), TYPE
				)
				when 1 then
				(
				    CASE WHEN @i_participantWithResp = 1 THEN
					(
					SELECT
					(select
						(CASE
							WHEN LTRIM(RTRIM(cu.displayName))IS NOT NULL AND LTRIM(RTRIM(cu.displayName))<>''
							THEN cu.displayName ELSE cu.MailID
						END)
						from CvEvents_User cu WITH(NOLOCK) where cu.UserID in(select cp.GroupUserGuid from CvEvents_Participant cp WITH(NOLOCK) where cp.ParticipantID=cr.ParticipantID )) as '@participantName',
					(select cu.Department from CvEvents_User cu WITH(NOLOCK) where cu.UserID in(select cp.GroupUserGuid from CvEvents_Participant cp WITH(NOLOCK) where cp.ParticipantID=cr.ParticipantID ))as '@department',
					CR.CustomResponse AS '@eventCustomResponse',
					(SELECT CRR.OptionID AS '@val' FROM CvEvents_Response CRR WITH(NOLOCK) WHERE CRR.ResponseID=CR.ResponseID FOR XML PATH('eventOptionResponse'),TYPE),
					(SELECT CR.ResponseXml as responseXml)
					FROM CvEvents_Response CR WITH(NOLOCK) WHERE CR.QuestionID=Q.QuestionID AND CR.ParticipantID IN(SELECT PL.ParticipantID FROM @ParticipantList PL)
					FOR XML PATH('eventQuestionResponse'), TYPE) END
				)
				END,
				(
				 SELECT Q.QuestionXml as 'questionXml'
				)
				FROM CvEvents_Question Q WITH(NOLOCK)
				WHERE Q.EventID = EL.EventId
				FOR XML PATH('eventQuestions'), TYPE
			),
			(
				SELECT U.MailID '@smtpAddress', U.UserID AS '@userGuid', U.DisplayName as '@displayName',U.Department as '@department' FROM CvEvents_User U WITH(NOLOCK)
				WHERE U.UserID = E.CreatedBy
				FOR XML PATH('eventCreator'), TYPE
			),
			(
				SELECT CASE when A.DistinctUsesrInEvent >0 THEN (a.CountParticipated * 100 / A.DistinctUsesrInEvent) ELSE 0 END  AS '@percentage', CountParticipated as '@count',A.DistinctUsesrInEvent as '@totalParticipant',dbo.CountInterestedUsers(EL.EventId) as '@interestedUserCount'  FROM
				(
				SELECT COUNT(DISTINCT GroupUserGuid) AS DistinctUsesrInEvent, ISNULL((SELECT COUNT(DISTINCT P.GroupUserGuid) FROM CvEvents_Response R WITH(NOLOCK)
				JOIN CvEvents_Participant P WITH(NOLOCK) ON R.ParticipantID = P.ParticipantID AND P.GroupType=0
				WHERE QuestionID IN (SELECT QuestionID FROM CvEvents_Question WITH(NOLOCK) WHERE EventID = E.EventID)), 0) AS CountParticipated
				FROM CvEvents_Participant WITH(NOLOCK)
				WHERE EventID = E.EventID AND GroupType=0
				) A
				FOR XML PATH('eventStats'), TYPE
			),
			(
				SELECT E.EventXml as 'eventXml'
			)
			FROM CvEvents_Event E WITH(NOLOCK) , @EventIdList EL WHERE E.EventID = EL.EventId
			AND		--Filters for search TODO: add search with query code
				(@i_filter=@FILTER_NONE
				OR ((@i_filter & @FILTER_PUBLIC = @FILTER_PUBLIC) AND (E.EventType & @EVENTTYPE_PUBLIC = @EVENTTYPE_PUBLIC))
				OR ((@i_filter & @FILTER_PRIVATE = @FILTER_PRIVATE) AND (E.EventType & @EVENTTYPE_PRIVATE = @EVENTTYPE_PRIVATE))
				OR ((@i_filter & @FILTER_DRAFT = @FILTER_DRAFT) AND (E.isDraft = 1) )
				OR ((@i_filter & @FILTER_EXPIRED = @FILTER_EXPIRED) AND (E.ExpiryDate <@currentTime) )
				OR ((@i_filter & @FILTER_FAVORITE = @FILTER_FAVORITE )
					AND (E.EventID IN (SELECT EventId FROM CvEvents_Participant WITH(NOLOCK) WHERE GroupUserGuid=@i_userguid AND isFavorite=1)
						OR E.EventID IN (SELECT EventId FROM CvEvents_Organizer WITH(NOLOCK) WHERE GroupUserGuid=@i_userguid AND isFavorite =1)))
				OR ((E.EventType & @EVENTTYPE_SURVEY <> @EVENTTYPE_SURVEY) AND (@i_filter & @FILTER_UPCOMING = @FILTER_UPCOMING) AND (E.isDraft=0 AND (E.ScheduledEndDate=0 OR E.ScheduledEndDate>@currentTime)))
				OR ((E.EventType & @EVENTTYPE_SURVEY = @EVENTTYPE_SURVEY) AND (@i_filter & @FILTER_UPCOMING = @FILTER_UPCOMING) AND (E.isDraft=0 AND (E.ExpiryDate > @currentTime)))
				OR ((E.EventType & @EVENTTYPE_SURVEY <> @EVENTTYPE_SURVEY) AND (@i_filter & @FILTER_PAST = @FILTER_PAST) AND (E.isDraft = 0 AND E.ScheduledEndDate <> 0 AND E.ScheduledEndDate <= @currentTime))
				OR ((E.EventType & @EVENTTYPE_SURVEY = @EVENTTYPE_SURVEY) AND (@i_filter & @FILTER_PAST = @FILTER_PAST) AND (E.isDraft=0 AND (E.ExpiryDate <= @currentTime)))
				OR (@i_filter & @FILTER_DEFAULT = @FILTER_DEFAULT)
			)
			order by
/*			case when (@i_filter & @Filter_SortByRecent = @Filter_SortByRecent) then E.ScheduledDate end,
			case when (@i_filter & @Filter_SortByUsers = @Filter_SortByUsers) then E.UserCount end desc,
			E.ScheduledDate*/
			EL.isExpired asc, E.isDraft asc,
			CASE WHEN (E.EventType & @EVENTTYPE_PROPOSAL) = @EVENTTYPE_PROPOSAL THEN E.ExpiryDate END desc,
			CASE WHEN ((E.EventType & @EVENTTYPE_EVENT) = @EVENTTYPE_EVENT) AND (E.ScheduledEndDate >= @currentTime) THEN E.ScheduledDate END asc,	-- upcoming events in ascending order of schedule time
			CASE WHEN ((E.EventType & @EVENTTYPE_EVENT) = @EVENTTYPE_EVENT) AND (E.ScheduledEndDate < @currentTime) THEN E.ScheduledDate END desc, -- past events in descending order of schedule time
			CASE WHEN ((E.EventType & @EVENTTYPE_SURVEY) = @EVENTTYPE_SURVEY) AND (E.ExpiryDate >= @currentTime) THEN E.ExpiryDate END asc, -- upcoming surveys in ascending order of expiry time
			CASE WHEN ((E.EventType & @EVENTTYPE_SURVEY) = @EVENTTYPE_SURVEY) AND (E.ExpiryDate < @currentTime) THEN E.ExpiryDate END desc -- past surveys in descending order of expiry time
			offset @i_offset rows
			fetch next @i_fetchCount rows only
			FOR XML PATH('events'), TYPE
		)
		FOR XML PATH('DM2ContentIndexing_CvEventResp')
		--IF @i_suppressResults = 0  --to suppress output when called from GetUserInformation
			--SELECT @o_outXML
	END
	/* EndIf Interested events for user exist */
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_SearchUserEvents')
	delete from GxQscripts where name = 'sp_dm2_cve_SearchUserEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SearchUserEvents')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SearchUserEvents'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_SearchUserEvents',  '00010008001400200000', 'sp_dm2_cve_SearchUserEvents', '00010008001400200000')
GO

