

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_SaveEventQuestion.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_SaveEventQuestion.sp,v $ $Id: sp_dm2_cve_SaveEventQuestion.sp,v 1.1.54.4 2018/03/27 08:41:05 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_cve_SaveEventQuestion <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_SaveEventQuestion')
	drop procedure sp_dm2_cve_SaveEventQuestion
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_SaveEventQuestion')
	delete from GxQscripts where name = 'sp_dm2_cve_SaveEventQuestion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SaveEventQuestion')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SaveEventQuestion'
GO
print '... Creating Procedure: sp_dm2_cve_SaveEventQuestion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_SaveEventQuestion
  @i_EventQuestionXML XML, 
  @i_EventId INT,
  @i_debug BIT = 0
AS
  DECLARE @o_errCode INT;
  DECLARE @o_retMsg varchar(max);
  DECLARE @o_returnId int;
	SET QUOTED_IDENTIFIER ON
	SET NOCOUNT ON
	DECLARE @tempCount int
	DECLARE @errCode INT
	DECLARE	@retMsg varchar(max)
	DECLARE	@QuestionId int
	DECLARE @questionXml xml
	DECLARE @CVEventQuestion table  (OptionValue NVARCHAR(1024), DisplayOrder INT,
			 IsDefault bit,
			 QuestionOptionId INT,
			 QuestionId INT,
			 OptionType	INT,
			 SubOptionValue varchar(MAX)
			 )
	DECLARE @CVEventQuestionOptions TABLE (
		OptionValue nvarchar(1024),
		DisplayOrder int,
		IsDefaultOption BIT,
		QuestionID INT)
	SET @errCode = 0
	SET @retMsg = ''
		SELECT @QuestionId = T.ref.value('@eventQuestionID', 'int') FROM @i_EventQuestionXML.nodes('/DM2ContentIndexing_CvEventQuestion') T(ref)
		SELECT @questionXml = @i_EventQuestionXML.query('/DM2ContentIndexing_CvEventQuestion/questionXml')
	IF ISNULL(@QuestionId,0) <= 0
	BEGIN
		;WITH Q
		AS
		(
			SELECT @i_EventId as EventId,
			T.ref.value('@eventQuestionTitle', 'nvarchar(1024)') as QuestionTitle,
			T.ref.value('@eventQuestionType', 'int') as QuestionType,
			@questionXml as QuestionXml
			FROM @i_EventQuestionXML.nodes('(/DM2ContentIndexing_CvEventQuestion)[1]') T(ref)
		)
		INSERT INTO CvEvents_Question(EventID, QuestionTitle, QuestionType, QuestionXml)
		SELECT EventId, QuestionTitle,
		(CASE QuestionType WHEN 0 THEN 'radio' WHEN 1 THEN 'select' WHEN 2 THEN 'checkbox' WHEN 3 THEN 'text' WHEN 4 THEN 'textarea' WHEN 5 THEN 'rating' WHEN 10 THEN 'multiselect_rating' END) as
		QuestionType,
		QuestionXml
		FROM Q
		SELECT @errCode = @@ERROR, @QuestionId = @@IDENTITY
	END
	ELSE
	BEGIN
		UPDATE q
		SET QuestionTitle = T.ref.value('@eventQuestionTitle', 'nvarchar(1024)'), QuestionXml = @questionXml
		FROM CvEvents_Question q
		CROSS APPLY @i_EventQuestionXML.nodes('(/DM2ContentIndexing_CvEventQuestion)[1]') T(ref)
		WHERE QuestionID = @QuestionId
		SELECT @errCode = @@ERROR
	END
	IF @errCode = 0
	BEGIN
	INSERT INTO @CVEventQuestion
			SELECT T.ref.value('@eventOptionVal', 'nvarchar(1024)') as OptionValue,
			T.ref.value('@eventOptionDisplayOrder', 'int') as DisplayOrder,
			ISNULL(T.ref.value('@eventOptionIsDefault', 'bit'), 0) as IsDefault,
			ISNULL(T.ref.value('@eventQuestionOptionID', 'INT'),0) as QuestionOptionID,
			@QuestionId AS QuestionID,
			ISNULL(T.ref.value('@eventQuestionOptionType', 'INT'),0) as OptionType,
			ISNULL(T.ref.value('@eventQuestionOptionTypeValue', 'varchar(MAX)'),0) as SubOptionValue
			FROM @i_EventQuestionXML.nodes('/DM2ContentIndexing_CvEventQuestion/eventQuestionOptions') T(ref)
		/*Deleting the entries from the table CvEvents_QuestionOption if question option is deleted from the question for particular event	*/
		DELETE   C
		FROM	CvEvents_QuestionOption AS C
		INNER JOIN	@CVEventQuestion AS T
		ON C.QuestionID = T.QuestionId
		AND C.QuestionOptionID
		NOT IN (SELECT DISTINCT CEQ.QuestionOptionId
				FROM @CVEventQuestion CEQ
				WHERE T.QuestionId = CEQ.QuestionId)
		MERGE CvEvents_QuestionOption AS A
		USING (SELECT * FROM @CVEventQuestion) AS QT
		ON QT.QuestionID = A.QuestionID  AND QT.QuestionOptionID =A.QuestionOptionID
		WHEN MATCHED  THEN
			UPDATE SET OptionValue = QT.OptionValue, DisplayOrder = QT.DisplayOrder, IsDefault = QT.IsDefault, OptionType = QT.OptionType, SubOptionValue = QT.SubOptionValue
		WHEN NOT MATCHED BY TARGET THEN
			INSERT (OptionValue, DisplayOrder, IsDefault, QuestionId, OptionType, SubOptionValue)
			VALUES (QT.OptionValue, QT.DisplayOrder, QT.IsDefault, QT.QuestionId, QT.OptionType, QT.SubOptionValue);
		SELECT @errCode = @@ERROR
		IF @errCode = 0
		BEGIN
			IF @i_debug = 1
			BEGIN
				SELECT 'Total question options saved in DB for question ' + CONVERT(VARCHAR(10), @QuestionId) + ': #' + CONVERT(VARCHAR(10), COUNT(QuestionOptionID)) + ' '
				FROM CvEvents_QuestionOption QO WITH(NOLOCK)
				WHERE EXISTS (SELECT EVENTID FROM CvEvents_Question Q WITH(NOLOCK) WHERE QO.QuestionID = Q.QuestionID AND Q.EventID = @i_EventId)
			END
		END
	END
	SELECT @errCode AS ReturnCode, @retMsg as ReturnMessage, (CASE WHEN @errCode = 0 THEN @QuestionId ELSE 0 END) as ReturnId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_SaveEventQuestion')
	delete from GxQscripts where name = 'sp_dm2_cve_SaveEventQuestion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SaveEventQuestion')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SaveEventQuestion'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_SaveEventQuestion',  '00010001005400040000', 'sp_dm2_cve_SaveEventQuestion', '00010001005400040000')
GO

