

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_SaveEvent.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_SaveEvent.sp,v $ $Id: sp_dm2_cve_SaveEvent.sp,v 1.8.14.11 2020/08/27 00:59:11 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_SaveEvent')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_cve_SaveEvent <<<'
	drop procedure sp_dm2_cve_SaveEvent
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_SaveEvent')
	delete from GxQscripts where name = 'sp_dm2_cve_SaveEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SaveEvent')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SaveEvent'
GO
print '... Creating Procedure: sp_dm2_cve_SaveEvent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_SaveEvent
  @i_EventXML XML, 
  @i_EventId INTEGER = 0,
  @i_InviteMore BIT=0,
  @i_debug BIT = 0,
  @i_userGUID nvarchar(128)
AS
  DECLARE @o_errCode INT;
  DECLARE @o_retMsg varchar(max);
  DECLARE @o_returnId INT;
	SET NOCOUNT ON
	DECLARE 	@Title NVARCHAR(1024)
	DECLARE		@Description NVARCHAR(max)
	DECLARE		@Location NVARCHAR(2048)
	DECLARE		@scheduleDateTime BIGINT
	DECLARE		@scheduleEndDateTime BIGINT
	DECLARE		@expiryDateTime BIGINT
	DECLARE		@imageFileName NVARCHAR(max)=N''
	DECLARE		@organizers NVARCHAR(max) = N''
	DECLARE		@participants NVARCHAR(max) = N''
	DECLARE		@eventCreator NVARCHAR(1024)
	DECLARE		@found BIT
	DECLARE		@gpsX float(53)
	DECLARE		@gpsY float(53)
	DECLARE		@tempCount INT
	DECLARE		@isDraft INT
	DECLARE		@isGuestAllowed INT
	DECLARE		@oldScheduleDateTime BIGINT = 0
	DECLARE		@oldScheduleEndDateTime BIGINT = 0
	DECLARE		@oldLocation NVARCHAR(2048) =N''
	DECLARE		@tempOldScheduleDateTime BIGINT = 0
	DECLARE		@tempOldScheduleEndDateTime BIGINT = 0
	DECLARE		@tempOldLocation NVARCHAR(2048) =N''
	DECLARE		@tempLocation NVARCHAR(2048)
	DECLARE		@tempScheduleDateTime BIGINT
	DECLARE		@tempScheduleEndDateTime BIGINT
	DECLARE		@errCode INT
	DECLARE		@retMsg varchar(max)
	DECLARE		@eventXml xml
	DECLARE @CVEventExQuestions TABLE (QuestionId INT, isEdit INT, isDeleteResponse INT)
	DECLARE		@isDraftEvent INT
	DECLARE @oldEventType INT
	IF object_id('tempdb.dbo.#CVEventUsers') IS NOT null DROP TABLE #CVEventUsers
		CREATE TABLE #CVEventUsers(
			UserGuid				nvarchar(256),
			DisplayName				nvarchar(256),
			AliasName				nvarchar(256),
			Mail					nvarchar(256),
			OrganizerNotParticipant BIT,
			GroupGuid				nvarchar(256),
			GroupType				INT,
			Department				nvarchar(256)
			)
	DECLARE @CVGroups TABLE(
		GroupName varchar(256),
		GroupID int,
		OrganizerNotParticipant BIT
	)
	DECLARE		@mailContentReset BIT = 0
	DECLARE     @tags   NVARCHAR(max) = N''
	DECLARE		@modifiedType BIGINT = 0
	DECLARE		@modifiedBy	NVARCHAR(1024)
	DECLARE     @modifiedTime BIGINT = 0
	DECLARE     @maxUserLimit INT = 0
	DECLARE		@minUserLimit INT = 0
	DECLARE		@eventType INT = 0
	DECLARE		@notifyPref INT = 0
	DECLARE		@userCount INT = 0
--constant
	DECLARE @USERTYPE_INVITED INT = 6,
			@NOTIFICATION_ON INT = 1,
			@GROUPTYPE_NONE INT = 0,
			@GROUPTYPE_LOGICAL INT = 2,
			@USERTYPE_REJECTED INT = 8,
			@USERTYPE_LEFT INT = 10,
			@USERTYPE_REMOVED INT = 11,
			@EVENTTYPE_EVENT INT = 8,
			@EVENTTYPE_PROPOSAL INT = 4
	SET @found = @i_EventXML.exist('/DM2ContentIndexing_CvEvent')
	SET @errCode = 0
	SET @retMsg = ''
	IF @found = 1
	BEGIN
		/* Validations Start */
		IF @i_InviteMore = 0
		BEGIN
			SELECT @eventCreator = ISNULL(T.ref.value('@userGuid', 'nvarchar(1024)'), '') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventCreator') T(ref)
			IF LTRIM(RTRIM(@eventCreator)) = ''
			BEGIN
				SELECT @retMsg = 'Event Creator not specified', @errCode = 10506	--  EVENT_CREATOR_NOT_SPECIFIED
				GOTO ExitLine
			END
			--PRINT '@eventCreator='+@eventCreator
			SELECT @Title = ISNULL(T.ref.value('@eventTitle', 'nvarchar(1024)'), '') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF LTRIM(RTRIM(@Title)) = ''
			BEGIN
				SELECT @retMsg = 'Event Title not provided.', @errCode = 10507	--  EVENT_TITLE_NOT_PROVIDED
				GOTO ExitLine
			END
			--PRINT '@Title='+@Title
			SELECT @Description = ISNULL(T.ref.value('@eventDescription', 'nvarchar(max)'), '') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF LTRIM(RTRIM(@Description)) = ''
			BEGIN
				SELECT @retMsg = 'Event description not provided.', @errCode = 10508	-- EVENT_DESCRIPTION_NOT_PROVIDED
				GOTO ExitLine
			END
			--PRINT '@Description='+@Description
			SELECT @eventType = ISNULL(T.ref.value('@eventType','int'),0) FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF @eventType = 0
			BEGIN
				SELECT @retMsg = 'Event type bit not specified', @errCode = 10540	-- EVENT_TYPE_NOT_SPECIFIED
				GOTO ExitLine
			END
				SELECT @scheduleDateTime = ISNULL(T.ref.value('@eventScheduledTime', 'bigint'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
				IF (@eventType & @EVENTTYPE_EVENT) = @EVENTTYPE_EVENT AND @scheduleDateTime = 0
				BEGIN
					SELECT @retMsg = 'Event schedule time not provided', @errCode = 10509	--EVENT_SCHEDULE_TIME_NOT_PROVIDED
					GOTO ExitLine
				END
				SELECT @scheduleEndDateTime = ISNULL(T.ref.value('@eventScheduledEndTime', 'bigint'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
				IF (@eventType & @EVENTTYPE_EVENT) = @EVENTTYPE_EVENT AND @scheduleEndDateTime = 0
				BEGIN
					SELECT @retMsg = 'Event schedule end time not provided', @errCode = 10531	-- EVENT_SCHEDULE_END_TIME_NOT_PROVIDED
					GOTO ExitLine
				END
			--PRINT '@scheduleDateTime='+convert(varchar(20),@scheduleDateTime)
			SELECT @expiryDateTime = ISNULL(T.ref.value('@eventExpiryDate', 'bigint'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF @expiryDateTime = 0
			BEGIN
				SELECT @retMsg = 'Event expiry time not specified', @errCode = 10510	-- EVENT_EXPIRY_TIME_NOT_SPECIFIED
				GOTO ExitLine
			END
			--PRINT '@expiryDateTime='+convert(varchar(20),@expiryDateTime)
			SELECT @isDraft = T.ref.value('@isDraft', 'int') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF @isDraft is Null
			BEGIN
				SELECT @retMsg = 'Event draft bit not specified', @errCode = 10530	-- EVENT_DRAFT_NOT_SPECIFIED
				GOTO ExitLine
			END
			SELECT @isGuestAllowed = T.ref.value('@isGuestAllowed', 'int') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF (@eventType & @EVENTTYPE_EVENT = @EVENTTYPE_EVENT) AND (@isGuestAllowed is Null)
			BEGIN
				SELECT @retMsg = 'Event guest allowed bit not specified', @errCode = 10532	-- EVENT_GUEST_NOT_SPECIFIED
				GOTO ExitLine
			END
			ELSE IF @eventType & @EVENTTYPE_PROPOSAL = @EVENTTYPE_PROPOSAL
			BEGIN
				SET @isGuestAllowed = 0
			END
			SELECT @imageFileName = ISNULL(T.ref.value('@eventImageFilename', 'nvarchar(max)'), '') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			IF LTRIM(RTRIM(@imageFileName)) = ''
			BEGIN
				SELECT @retMsg = 'Event Image not specified', @errCode = 10524	-- EVENT_IMAGE_NOT_SPECIFIED
				GOTO ExitLine
			END
			SELECT @mailContentReset = T.ref.value('@mailContentOperation', 'BIT') FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventMailContent') T(ref)
			SELECT @notifyPref = ISNULL(T.ref.value('@notifyPref','int'),0) FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			SELECT @modifiedBy = ISNULL(T.ref.value('@userGuid','nvarchar(256)'),0) FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent/modifiedBy') T(ref)
			SELECT @modifiedType = ISNULL(T.ref.value('@modifiedType','bigint'),0) FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			SELECT @tags = ISNULL(T.ref.value('@tags','nvarchar(max)'),'') FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			SELECT @minUserLimit = ISNULL(T.ref.value('@minUserLimit','int'),0) FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			SELECT @maxUserLimit = ISNULL(T.ref.value('@maxUserLimit','int'),100) FROM @i_EVENTXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
			SELECT @eventXml = @i_EventXML.query('/DM2ContentIndexing_CvEvent/eventXml')
			SELECT @isDraftEvent= isDraft FROM CvEvents_Event CV WITH(NOLOCK) WHERE CV.EventID = @i_EventId
			--TODO: Handle case where a event is already created and we receive a draft event request
			IF @isDraft = 1 OR @isDraftEvent = 1
			BEGIN
				DELETE QO
				FROM CvEvents_QuestionOption QO
					INNER JOIN CvEvents_Question Q ON QO.QuestionID = Q.QuestionID
					INNER JOIN CvEvents_Event E ON Q.EventID = E.EventID AND E.isDraft = 1
					WHERE Q.EventID = @i_EventId
				DELETE Q
				FROM CvEvents_Question Q
					INNER JOIN CvEvents_Event E ON Q.EventID = E.EventID AND E.isDraft = 1
					WHERE Q.EventID = @i_EventId
			END
			IF @i_EventId > 0 AND  @isDraftEvent = 0
				BEGIN
					SELECT @tempLocation = ISNULL(Location,''),@tempScheduleDateTime=ISNULL(ScheduledDate,0),@tempScheduleEndDateTime=ISNULL(ScheduledEndDate,0),
					@tempOldLocation = ISNULL(OldLocation,''),@tempOldScheduleDateTime=ISNULL(oldScheduledDate,0),@tempOldScheduleEndDateTime=ISNULL(OldScheduledEndDate,0)
					  FROM CvEvents_Event IE WITH(NOLOCK)
					WHERE IE.EventID = @i_EventId
				END
			/* Validations end */
			/* Capture rest of data */
			/* Capturing organizers and participants to temp table for sake of saving it to CVEvents_Organizer, CvEvents_Participant CVEvents_User table who already not exist in DB */
			/*inserting participant subgroups in CVGroup temp table*/
			INSERT INTO @CVGroups(GroupName, GroupID,OrganizerNotParticipant)
			SELECT ISNULL(T.ref.value('@smtpAddress','nvarchar(256)'),'') AS GroupName,
			G.id AS GroupID,
			0 AS OrganizerNotParticipant
			FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventParticipants') T(ref) JOIN UMGroups G WITH(NOLOCK)
			ON ISNULL(RTRIM(LTRIM(T.ref.value('@smtpAddress','nvarchar(256)'))),'')=G.name
			AND ISNULL(T.ref.value('@groupType','int'),0)=@GROUPTYPE_LOGICAL
			/*inserting organizer subgroups in CVGroup temp table*/
			INSERT INTO @CVGroups(GroupName, GroupID,OrganizerNotParticipant)
			SELECT ISNULL(T.ref.value('@smtpAddress','nvarchar(256)'),'') AS GroupName,
			G.id AS GroupID,
			1 AS OrganizerNotParticipant
			FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventOrganizers') T(ref) JOIN UMGroups G WITH(NOLOCK)
			ON ISNULL(RTRIM(LTRIM(T.ref.value('@smtpAddress','nvarchar(256)'))),'')=G.name
			AND ISNULL(T.ref.value('@groupType','int'),0)=@GROUPTYPE_LOGICAL
			IF @i_debug = 1
				DECLARE @v4 XML = (SELECT * FROM @CVGroups FOR XML AUTO) --DEBUGGING PURPOSE
			/*getting organizers into temp table*/
			INSERT INTO #CVEventUsers(UserGuid,DisplayName,AliasName,Mail,OrganizerNotParticipant,GroupGuid,GroupType,Department)
			SELECT DISTINCT ISNULL(T.ref.value('@userGuid', 'nvarchar(256)'),'') as UserGuid, ISNULL(T.ref.value('@displayName', 'nvarchar(256)'),'') as DisplayName,
			ISNULL(T.ref.value('@aliasName', 'nvarchar(256)'),'') as AliasName,
			ISNULL(T.ref.value('@smtpAddress', 'nvarchar(256)'),'') as Mail,
			1 as OrganizerNotParticipant,
			ISNULL(T.ref.value('@groupGuid','nvarchar(256)'),'') as GroupGuid,
			ISNULL(T.ref.value('@groupType','int'),0) as GroupType,
			ISNULL(T.ref.value('@department','nvarchar(256)'),'') as Department
			FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventOrganizers') T(ref) WHERE ISNULL(T.ref.value('@groupType','int'),0) <> @GROUPTYPE_LOGICAL
			/*Inserting all logical group users who are organizer in temp table*/
			INSERT INTO #CVEventUsers(UserGuid,OrganizerNotParticipant,GroupGuid,GroupType)
			SELECT DISTINCT C.GroupUserGuid as UserGuid,
			1 as OrganizerNotParticipant,
			'' AS GroupGuid,
			@GROUPTYPE_NONE as GroupType
			FROM @CVGroups CV  JOIN CvEvents_GroupUser C WITH(NOLOCK) ON
			CV.OrganizerNotParticipant=1 AND
			C.GroupID = CV.GroupID AND
			C.GroupType = @GROUPTYPE_NONE AND --C.GroupType to avoid nested groups
			C.MembershipStatus NOT IN (@USERTYPE_REJECTED,@USERTYPE_REMOVED,@USERTYPE_LEFT)  --ignoring rejected,removed, or left users from group
			/*Inserting ends here*/
			IF @i_debug = 1
				DECLARE @v2 XML = (SELECT * FROM #CVEventUsers FOR XML AUTO) --DEBUGGING PURPOSE
			/*inserting event creator into temp table*/
			INSERT INTO #CVEventUsers(UserGuid,DisplayName,AliasName,Mail,Department)
			SELECT DISTINCT T.ref.value('@userGuid', 'nvarchar(256)') as UserGuid, T.ref.value('@displayName', 'nvarchar(256)') as DisplayName,
			T.ref.value('@aliasName', 'nvarchar(256)') as AliasName,
			T.ref.value('@smtpAddress', 'nvarchar(256)') as Mail,
			ISNULL(T.ref.value('@department','nvarchar(256)'),'') as Department
			FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventCreator') T(ref)
		END
		/*Getting participants into temp table*/
		INSERT INTO #CVEventUsers(UserGuid,DisplayName,AliasName,Mail,OrganizerNotParticipant,GroupGuid,GroupType,Department)
		SELECT DISTINCT ISNULL(T.ref.value('@userGuid', 'nvarchar(256)'),'') as UserGuid,
		ISNULL(T.ref.value('@displayName', 'nvarchar(256)'),'') as DisplayName,
		ISNULL(T.ref.value('@aliasName', 'nvarchar(256)'),'') as AliasName,
		ISNULL(T.ref.value('@smtpAddress', 'nvarchar(256)'),'') as Mail,
		0 AS OrganizerNotParticipant,
		ISNULL(T.ref.value('@groupGuid','nvarchar(256)'),'') as GroupGuid,
		ISNULL(T.ref.value('@groupType','int'),0) as GroupType,
		ISNULL(T.ref.value('@department','nvarchar(256)'),'') as Department
		FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventParticipants') T(ref)  WHERE ISNULL(T.ref.value('@groupType','int'),0) <> @GROUPTYPE_LOGICAL
		/*Inserting all logical group users who are participant in temp table*/
		INSERT INTO #CVEventUsers(UserGuid,OrganizerNotParticipant,GroupGuid,GroupType)
		SELECT DISTINCT C.GroupUserGuid as UserGuid,
		0 as OrganizerNotParticipant,
		'' AS GroupGuid,
		@GROUPTYPE_NONE as GroupType
		FROM @CVGroups CV  JOIN CvEvents_GroupUser C WITH(NOLOCK) ON
		CV.OrganizerNotParticipant=0 AND
		C.GroupID = CV.GroupID AND
		C.GroupType = @GROUPTYPE_NONE AND --C.GroupType to avoid nested groups
		C.MembershipStatus NOT IN (@USERTYPE_REJECTED,@USERTYPE_REMOVED,@USERTYPE_LEFT)  --ignoring rejected,removed, or left users from group
		/*Inserting participants ends here */
		IF @i_debug = 1
		BEGIN
			SELECT *, 'EventUserTemp' FROM #CVEventUsers
			DECLARE @v3 XML = (SELECT * FROM #CVEventUsers FOR XML AUTO) --DEBUGGING PURPOSE
		END
		/* Capturing organizers and participants data that goes to cvEvent table and is used for display purposes */
		IF @i_InviteMore =0
		BEGIN
			;WITH EvUsers AS
			(
				SELECT DISTINCT
				CASE WHEN ISNULL(T.ref.value('@groupType','int'),0)=@GROUPTYPE_LOGICAL THEN T.ref.value('@displayName', 'nvarchar(256)') ELSE T.ref.value('@smtpAddress', 'nvarchar(256)')  END AS EventUser
				FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventOrganizersDisp') T(ref)
			)
			SELECT @organizers = @organizers + EventUser + ';' FROM EvUsers
			WHERE ISNULL(EventUser,'') <> ''
			IF RIGHT(@organizers,1) = ';'
			SET @organizers = LEFT(@organizers,LEN(@organizers)-1)
			--PRINT '@organizers='+@organizers
		END
		;WITH EvParticipants AS
		(
			SELECT DISTINCT
				CASE WHEN (ISNULL(T.ref.value('@groupType','int'),0)=@GROUPTYPE_LOGICAL OR ISNULL(T.ref.value('@smtpAddress','nvarchar(256)'),'') = '') THEN T.ref.value('@displayName', 'nvarchar(256)') ELSE T.ref.value('@smtpAddress', 'nvarchar(256)')  END AS EventParticipant
			FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventParticipantsDisp') T(ref)
		)
		SELECT @participants = @participants + EventParticipant + ';' FROM EvParticipants
		WHERE ISNULL(EventParticipant,'') <> '';
		IF RIGHT(@participants,1) = ';'
			SET @participants = LEFT(@participants,LEN(@participants)-1)
		--PRINT '@participants='+@participants
		/* Capturing Location */
		IF @i_InviteMore = 0
		BEGIN
			SELECT @Location =
			LTRIM(RTRIM(ISNULL(T.ref.value('@eventAddressLine1', 'nvarchar(1024)'), ''))) + '|' +
			LTRIM(RTRIM(ISNULL(T.ref.value('@eventAddressLine2', 'nvarchar(50)'), ''))) + '|' +
			LTRIM(RTRIM(ISNULL(T.ref.value('@eventAptRoom', 'nvarchar(50)'), ''))) + '|' +
			LTRIM(RTRIM(ISNULL(T.ref.value('@eventCity', 'nvarchar(50)'), ''))) + '|' +
			LTRIM(RTRIM(ISNULL(T.ref.value('@eventState', 'nvarchar(50)'), ''))) + '|' +
			LTRIM(RTRIM(ISNULL(T.ref.value('@eventZipCode', 'nvarchar(10)'), '')))
			FROM @i_EventXML.nodes('(/DM2ContentIndexing_CvEvent/eventAddr)[1]') T(ref)
			SELECT @gpsX = ISNULL(T.ref.value('@gpsXcoordinate', 'float(53)'), 0), @gpsY = ISNULL(T.ref.value('@gpsYcoordinate', 'float(53)'), 0)
			FROM @i_EventXML.nodes('(/DM2ContentIndexing_CvEvent/eventAddr)[1]') T(ref)
			if @gpsX <> 0 and @gpsY <> 0
			BEGIN
				SET @Location =@Location + '|' + CAST( @gpsX as nvarchar) + '|' + CAST( @gpsY as nvarchar)
			END
		END
		IF @i_EventId > 0 AND  @isDraftEvent = 0
			BEGIN
				IF @tempLocation = @Location
				BEGIN
					SET @oldLocation=@tempOldLocation
				END
				ELSE
				BEGIN
					SET @oldLocation=@tempLocation
				END
				IF @tempScheduleDateTime = @scheduleDateTime
				BEGIN
					SET @oldScheduleDateTime=@tempOldScheduleDateTime
				END
				ELSE
				BEGIN
					SET @oldScheduleDateTime=@tempScheduleDateTime
				END
				IF @tempScheduleEndDateTime =@scheduleEndDateTime
				BEGIN
					SET @oldScheduleEndDateTime=@tempOldScheduleEndDateTime
				END
				ELSE
				BEGIN
					SET @oldScheduleEndDateTime=@tempScheduleEndDateTime
				END
			END
		--PRINT '@Location = ' + @Location
		/* Saving CVEvents_User entries who already not exist in DB */
		;WITH DU AS
		(
		SELECT distinct UserGuid, Mail, DisplayName,Department,
		ROW_NUMBER() OVER(PARTITION BY UserGuid ORDER BY Mail) AS 'RowNum'
		FROM #CVEventUsers T WHERE Mail <> '')
		MERGE INTO CvEvents_User CU
		USING (
				SELECT *
				FROM DU
				WHERE RowNum = 1
			) S
		ON CU.UserID = S.UserGuid AND ISNULL(S.UserGuid, '') <> '' --AND ISNULL(S.Mail,'') <>'' --removing thee mailId Null Check
		WHEN MATCHED THEN
		UPDATE 	SET MailID = S.Mail, DisplayName = S.DisplayName
		WHEN NOT MATCHED BY TARGET THEN
		INSERT (UserID, MailID, DisplayName,Department)
		VALUES(S.UserGuid,S.Mail,S.DisplayName,S.Department);
		IF @i_EventId > 0
		BEGIN
			IF dbo.canManageEventSurvey(@i_userGUID, @i_EventId, 0) = 0
			BEGIN
				SELECT @retMsg = 'Event does not exists for the user.', @errCode = 10514 -- INVALID_OR_UNKNOWN_USER
				GOTO ExitLine
			END
			/* Updating CVEvents_Event table data */
			IF @i_InviteMore =0
			BEGIN
				/* Need to check if we are trying to convert a proposal into event*/
				SELECT @oldEventType=EventType FROM CvEvents_Event WHERE EventID=@i_EventId
				-------------if old eventtype is proposal and now we are trying to convert it into event--------------
				IF ( (@oldEventType & @EVENTTYPE_PROPOSAL)= @EVENTTYPE_PROPOSAL) AND ( (@eventType & @EVENTTYPE_EVENT) = @EVENTTYPE_EVENT)
				BEGIN
					--------------------------delete proposal questions and responses---------------------------------
					-----------First delete questions response----------------
					DELETE FROM CvEvents_Response WHERE QuestionID IN (SELECT QuestionID FROM CvEvents_Question WHERE EventID=@i_EventId)
					-----------Delete Question Options of questions related to this proposal---------------
					DELETE FROM CvEvents_QuestionOption WHERE QuestionID IN (SELECT QuestionID FROM CvEvents_Question WHERE EventID=@i_EventId)
					-----------Delete questions related to this proposal---------------
					DELETE FROM CvEvents_Question WHERE EventID=@i_EventId
					-----------delete existing Pariticipants-------------------------------------------
					DELETE CEP
					FROM CvEvents_Participant CEP
					WHERE CEP.EventID=@i_EventId AND CEP.GroupUserGuid IN(SELECT UserGuid FROM #CVEventUsers WHERE OrganizerNotParticipant= 0)
				END
				UPDATE CvEvents_Event
				SET Title = @Title, Description = @Description, Location = @Location, ScheduledDate = @scheduleDateTime,
				ImageFileName = @imageFileName, ExpiryDate = @expiryDateTime, ParticipantsList = @participants,OrganizersList=@organizers,
				isDraft = @isDraft,ScheduledEndDate=@scheduleEndDateTime,OldLocation=@oldLocation,isGuestAllowed=@isGuestAllowed,
				OldScheduledDate=@oldScheduleDateTime,OldScheduledEndDate=@oldScheduleEndDateTime, ModifiedBy=@modifiedBy, ModifiedTime= GETUTCDATE(),
				MailContent= (CASE @mailContentReset WHEN 1 THEN NULL ELSE MailContent END), Tags=@tags, MaxUserLimit=@maxUserLimit,
				MinUserLimit=@minUserLimit,ModifiedType=@modifiedType, EventType=@eventType, EventXml = @eventXml
				WHERE EventID = @i_EventId
				SELECT @errCode = @@ERROR, @tempCount = @@ROWCOUNT
				IF @errCode = 0 AND @i_debug = 1
					--PRINT 'Updated CVEvents_Event successfully. No of effected rows: ' + CONVERT(varchar(10), @tempCount)
				IF @tempCount <= 0
				BEGIN
					SELECT @errCode = 10528, @retMsg = 'Event not found for specified id: # ' + CONVERT(varchar(10), @i_EventId)
					--PRINT 'Specified EventId @' + convert(varchar(10), @i_EventId) + ' not found'
				END
				--In case of edit, questions that are not part of input event are deleted, as they must be deleted in UI.
				--Insert / Update to Event Question table happen in sp_dm2_cve_SaveEventQuestion stored procedure.
				;WITH EQ AS
				(
					SELECT T.ref.value('@eventQuestionID', 'int') as QuestionId,
					ISNULL(T.ref.value('@isEdit','int'),0) as isEdit,
					ISNULL(T.ref.value('@isDeleteResponse','int'),0) as isDeleteResponse
					FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventQuestions') T(ref)
				)
				INSERT INTO @CVEventExQuestions
				SELECT * FROM EQ;
				DELETE FROM CvEvents_Response
				WHERE QuestionID IN (SELECT QuestionID FROM @CVEventExQuestions WHERE isDeleteResponse=1)
				DELETE FROM CvEvents_QuestionOption
				WHERE QuestionID IN (SELECT QuestionID FROM @CVEventExQuestions WHERE isEdit=0)
				DELETE FROM CvEvents_Question
				WHERE EventID = @i_EventId AND QuestionID IN (SELECT QuestionID FROM @CVEventExQuestions WHERE isEdit=0)
			END
			ELSE
			BEGIN
				UPDATE CvEvents_Event
				SET ParticipantsList = @participants
				WHERE EventID = @i_EventId
				SELECT @errCode = @@ERROR, @tempCount = @@ROWCOUNT
				IF @errCode = 0 AND @i_debug = 1
					--PRINT 'Updated CVEvents_Event successfully. No of effected rows: ' + CONVERT(varchar(10), @tempCount)
				IF @tempCount <= 0
				BEGIN
					SELECT @errCode = 10528, @retMsg = 'Event not found for specified id: # ' + CONVERT(varchar(10), @i_EventId)
					--PRINT 'Specified EventId @' + convert(varchar(10), @i_EventId) + ' not found'
				END
			END
		END
		ELSE
		BEGIN
			/* Inserting CVEvents_Event table data */
			INSERT INTO CvEvents_Event
			(Title, Description, Location, CreatedBy, CreationTime,
			ScheduledDate, ExpiryDate, ImageFileName, OrganizersList, ParticipantsList,isDraft,ScheduledEndDate,OldLocation,isGuestAllowed,OldScheduledDate,OldScheduledEndDate,ModifiedTime,ModifiedBy,UserCount,Tags,MaxUserLimit,MinUserLimit,EventType,ModifiedType,EventXml)
			SELECT @Title as Title, @Description as Description, @Location as Location, @eventCreator as CreatedBy, GETUTCDATE() as CreationTime,
			@scheduleDateTime as ScheduledDate, @expiryDateTime as ExpiryDate, @imageFileName as ImageFileName, @organizers as OrganizersList, @participants as ParticipantsList, @isDraft as isDraft,
			@scheduleEndDateTime as ScheduledEndDate,@oldLocation as OldLocation,@isGuestAllowed as isGuestAllowed,
			@oldScheduleDateTime as OldScheduledDate,@oldScheduleEndDateTime as OldScheduledEndDate,
			GETUTCDATE() as ModifiedTime, @modifiedBy as ModifiedBy, 0 as UserCount, @tags as Tags, @maxUserLimit as MaxUserLimit, @minUserLimit as MinUserLimit,
			@eventType as EventType,@modifiedType as ModifiedType, @eventXml as EventXml
			SELECT @errCode = @@ERROR, @i_EventId = @@IDENTITY
			IF @i_debug = 1
				SELECT *, 'SavedEvent' FROM CvEvents_Event WITH(NOLOCK) WHERE EventID = @i_EventId
		END
		/* Saving CvEvents_Organizer table data */
		IF @errCode = 0 AND @i_InviteMore =0
		BEGIN
			--INSERT INTO CvEvents_Organizer (UserID, EventID)
			--SELECT UserGuid AS UserID, @i_EventId AS EventID FROM #CVEventUsers
			--WHERE OrganizerNotParticipant = 1
			DELETE CEO
			FROM CvEvents_Organizer CEO
			WHERE CEO.EventID=@i_EventId AND CEO.GroupUserGuid NOT IN(SELECT UserGuid FROM #CVEventUsers WHERE OrganizerNotParticipant= 1) AND CEO.GroupUserGuid NOT IN(SELECT GroupGuid FROM #CVEventUsers WHERE OrganizerNotParticipant= 1)
			MERGE CvEvents_Organizer AS A
			USING (SELECT DISTINCT UserGuid,GroupGuid,GroupType FROM #CVEventUsers WHERE OrganizerNotParticipant = 1 Group by UserGuid,GroupGuid,GroupType) AS O
			ON (A.GroupUserGuid = O.UserGuid OR (A.GroupType>0 AND A.GroupUserGuid = O.GroupGuid)) AND A.EventId = @i_EventId
			WHEN NOT MATCHED BY TARGET THEN
			INSERT (GroupUserGuid, EventID,GroupType)
			VALUES (
			case when (O.GroupType > 0) then O.GroupGuid else O.UserGuid end,
			@i_EventId,
			O.GroupType
			);
			--WHEN NOT MATCHED BY SOURCE THEN
			--DELETE;
			SELECT @errCode = @@ERROR, @tempCount = @@ROWCOUNT
			IF @tempCount <= 0
				PRINT '****No organizers specified****' --TODO: Do we need to raise error from here?
			ELSE
			BEGIN
				IF @i_debug = 1
					SELECT 'Saved #' + CONVERT(VARCHAR(10), COUNT(GroupUserGuid)) + ' Organizers' FROM CvEvents_Organizer WITH(NOLOCK)  WHERE EventID = @i_EventId
			END
		END
		/* Saving CvEvents_Participant table data */
		IF @errCode = 0
		BEGIN
			--INSERT INTO CvEvents_Participant(UserID, EventID)
			--SELECT UserGuid AS UserID, @i_EventId AS EventID FROM #CVEventUsers
			--WHERE OrganizerNotParticipant = 0
			IF @i_InviteMore = 0
			BEGIN
				DELETE CR
				FROM CvEvents_Response CR
				WHERE CR.ParticipantID
					IN(SELECT ParticipantID
						FROM CvEvents_Participant CEP WITH(NOLOCK)
						WHERE CEP.EventID=@i_EventId
						AND CEP.GroupUserGuid
							NOT IN(SELECT UserGuid FROM #CVEventUsers WHERE OrganizerNotParticipant= 0)
					)
				DELETE CEP
				FROM CvEvents_Participant CEP
				WHERE CEP.EventID=@i_EventId AND CEP.GroupUserGuid NOT IN(SELECT UserGuid FROM #CVEventUsers WHERE OrganizerNotParticipant= 0) AND CEP.GroupUserGuid NOT IN (SELECT GroupGuid FROM #CVEventUsers WHERE OrganizerNotParticipant= 0)
			END
			MERGE CvEvents_Participant AS A
			USING (SELECT DISTINCT UserGuid,GroupGuid,GroupType FROM #CVEventUsers WHERE OrganizerNotParticipant = 0  Group by UserGuid,GroupGuid,GroupType) AS P
			ON (A.GroupUserGuid = P.UserGuid OR (P.GroupType>0 AND A.GroupUserGuid = P.GroupGuid)) AND A.EventId = @i_EventId
			WHEN NOT MATCHED BY TARGET THEN
			INSERT (GroupUserGuid, EventID, GroupType, ParticipationStatus,isFavorite, NotificationCode,LastSeen)
			VALUES(
			case when (P.GroupType > 0) then P.GroupGuid else P.UserGuid end
			,@i_EventId
			,P.GroupType
			,@USERTYPE_INVITED
			,0
			,@NOTIFICATION_ON
			,GETUTCDATE()
			);
			--WHEN NOT MATCHED BY SOURCE THEN
			--DELETE;
			SELECT @errCode = @@ERROR, @tempCount = @@ROWCOUNT
			IF @tempCount <= 0
				PRINT '****No participants specified****'
			ELSE
			BEGIN
				IF @i_debug = 1
					SELECT 'Saved #' + CONVERT(VARCHAR(10), COUNT(GroupUserGuid)) + ' Participants' FROM CvEvents_Participant WITH(NOLOCK) WHERE EventID = @i_EventId
			END
			IF object_id('tempdb.dbo.#CVEventUsers') IS NOT null
				DROP TABLE #CVEventUsers
		END
	END
	ELSE
	BEGIN
		/* Invalid XML input */
		SELECT @errCode = 10511, @retMsg = 'Event XML not valid.'
	END
ExitLine:
	/* Invalid XML input */
	SELECT @errCode AS ReturnCode, @retMsg as ReturnMessage, (CASE WHEN @errCode = 0 THEN @i_EventId ELSE 0 END) as ReturnId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_SaveEvent')
	delete from GxQscripts where name = 'sp_dm2_cve_SaveEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_SaveEvent')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_SaveEvent'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_SaveEvent',  '00010008001400110000', 'sp_dm2_cve_SaveEvent', '00010008001400110000')
GO

