

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_RespondToEvent.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_RespondToEvent.sp,v $ $Id: sp_dm2_cve_RespondToEvent.sp,v 1.2.42.6 2020/08/27 00:59:31 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_RespondToEvent')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_cve_RespondToEvent <<<'
	drop procedure sp_dm2_cve_RespondToEvent
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_RespondToEvent')
	delete from GxQscripts where name = 'sp_dm2_cve_RespondToEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_RespondToEvent')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_RespondToEvent'
GO
print '... Creating Procedure: sp_dm2_cve_RespondToEvent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_RespondToEvent
  @i_EventXML xml,
  @i_UserGUID varchar(255),
  @i_debug bit = 0
AS
 SET NOCOUNT ON
  DECLARE @o_Error INT;
  DECLARE @o_ReturnMessage nvarchar(max);
DECLARE @RespTemp TABLE (
		QuestionID INT,
		OptionID INT,
		CustomResponse NVARCHAR(MAX),
		ResponseID int,
		ResponseXml xml
	)
	DECLARE @OptionRespTemp TABLE (
	 ID INT IDENTITY(1, 1),
	 OptionID INT
	)
	DECLARE @CustomRespTemp TABLE (
	 ID INT IDENTITY(1, 1),
	 customResp INT
	)
	DECLARE @OperationResult TABLE(
		MergeAction varchar(100),
		InsParticipantID varchar(36),
		InsQuestionID int,
		InsOptionID int,
		InsCustomResponse nvarchar(max),
		DelParticipantID varchar(36),
		DelQuestionID int,
		DelOptionID int,
		DelCustomResponse nvarchar(max)
	)
	DECLARE @particiationTime TABLE(participatedAt BIGINT)
	DECLARE @GuestCount TABLE(
	userName varchar(255),
	adultCount INT,
	childCount INT
	)
	DECLARE @EventID INT
	DECLARE @ParticipantIdVal INT
	DECLARE @ParticipatedAt BIGINT
	DECLARE @AdultCount INT =0
	DECLARE @ChildCount INT =0
	DECLARE @IsGuestAllowed INT
	DECLARE @Error INT
	DECLARE @ReturnMessage nvarchar(max)
	DECLARE @eventType int
	DECLARE @userSmtpAddress nvarchar(256)
	DECLARE @responseXml xml
	--constants
	DECLARE @EVENTTYPE_PUBLIC INT = 1,
			@GROUPTYPE_NONE INT = 0,
			@USERTYPE_INVITED INT = 6
	SELECT @EventID = ISNULL(T.ref.value('@eventID', 'INT'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
	SELECT @eventType = ISNULL(T.ref.value('@eventType', 'INT'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
	IF dbo.canManageEventSurvey(@i_UserGUID, @EventID, 2) = 0
	BEGIN
		SELECT @ReturnMessage = 'Event does not exists for the user.', @Error = 10514 -- INVALID_OR_UNKNOWN_USER
		GOTO ExitLine
	END
	IF (@eventType & @EVENTTYPE_PUBLIC) = @EVENTTYPE_PUBLIC
	BEGIN
		IF NOT EXISTS(SELECT P.ParticipantID FROM CvEvents_Participant P WITH(NOLOCK) WHERE P.EventID = @EventID and p.GroupUserGuid = @i_UserGUID)
		BEGIN --in case some one wants to join a public proposal
			INSERT INTO CvEvents_Participant(GroupUserGuid,GroupType,ParticipationStatus,EventID,isFavorite,NotificationCode,LastSeen)
			VALUES(
			@i_UserGUID,
			@GROUPTYPE_NONE,
			@USERTYPE_INVITED,
			@EventID,
			0,
			1,
			GETUTCDATE()
			)
			SELECT @userSmtpAddress=MailID FROM CvEvents_User WITH(NOLOCK) WHERE UserID=@i_UserGUID
			UPDATE CvEvents_Event SET
			ParticipantsList= CASE WHEN ISNULL(ParticipantsList,'') != '' THEN
											ParticipantsList + ',' + @userSmtpAddress
											ELSE
											@userSmtpAddress END
			WHERE EventID = @EventID
		END
	END
	SELECT @ParticipantIdVal = P.ParticipantID FROM CvEvents_Participant P WITH(NOLOCK) WHERE P.EventID = @EventID and p.GroupUserGuid = @i_UserGUID
	INSERT INTO @particiationTime
	SELECT ISNULL(T.ref.value('@participatedAt', 'bigint'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventParticipants') T(ref)
	SELECT @ParticipatedAt= (SELECT TOP 1 participatedAt FROM @particiationTime)
		IF @ParticipatedAt = 0
		BEGIN
			SELECT @ReturnMessage = 'Participant Respondtime is not provided', @Error = 10529
			GOTO ExitLine
		END
	SELECT @IsGuestAllowed = ISNULL(T.ref.value('@isGuestAllowed', 'INT'), 0) FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent') T(ref)
	IF @IsGuestAllowed >0
		BEGIN
			INSERT INTO @GuestCount
			SELECT ISNULL(T.ref.value('@userName', 'varchar(255)'), ''),
			ISNULL(T.ref.value('@adultCount', 'INT'), 0),
			ISNULL(T.ref.value('@childCount', 'INT'), 0)
			FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/guestCount') T(ref)
		END
	SELECT @AdultCount=ISNULL(GC.adultCount,0),@ChildCount=ISNULL(GC.childCount,0) FROM (SELECT TOP 1 adultCount,childCount FROM @GuestCount) GC
	IF ISNULL(@ParticipantIdVal,0) > 0
	BEGIN
		--Collect normal option selected responses
		;WITH CTE1
		AS
		(
		SELECT
		T.ref.value('../../@eventQuestionID', 'INT') AS QuestionID,
		NULL AS CustomResponse,
		T.ref.value('@val', 'int') as OptionID,
		T.ref.query('../responseXml') as ResponseXml
		FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventQuestions/eventQuestionResponse/eventOptionResponse') T(ref)
		)
		INSERT INTO @RespTemp
		SELECT CTE1.QuestionID, CTE1.OptionID, CTE1.CustomResponse, ISNULL(PR.ResponseID, -1),CTE1.ResponseXml  FROM CTE1
		LEFT JOIN CvEvents_Response PR WITH(NOLOCK) ON CTE1.OptionID = PR.OptionID AND CTE1.QuestionID = PR.QuestionID AND PR.ParticipantID=@ParticipantIdVal
		INSERT INTO @OptionRespTemp
		SELECT T.ref.value('@val','int')
		FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventQuestions/eventQuestionResponse/eventOptionResponse') T(ref)
		WHERE T.ref.query('../responseXml').exist('/responseXml/subQuestionLabels') = 1
		INSERT INTO @CustomRespTemp
		SELECT T.ref.value('@val','int')
		FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventQuestions/eventQuestionResponse/responseXml/subQuestionLabels') T(ref)
		;WITH CTE1
		AS
		(
		SELECT
		ORT.OptionID AS OptionID,
		CRT.customResp AS CustomResp
		FROM @OptionRespTemp ORT, @CustomRespTemp CRT
		WHERE ORT.ID = CRT.ID
		)
		MERGE @RespTemp as RT
		USING CTE1 ON CTE1.OptionId = RT.OptionId
		WHEN MATCHED THEN
			UPDATE SET CustomResponse =  CTE1.customResp,ResponseXml = NULL;
		IF EXISTS (select top 1 * from @RespTemp a LEFT JOIN CvEvents_QuestionOption QO WITH(NOLOCK) ON A.OptionID = QO.QuestionOptionID AND A.QuestionID = QO.QuestionID WHERE QO.QuestionOptionID IS NULL)
		BEGIN
			SELECT @Error = 10521, @ReturnMessage = 'Failed because of responding with a question option that has become stale or out-of-date.'
			goto exitLine
		END
		IF @i_debug = 1
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 * FROM @RespTemp)
				SELECT 'No responses with regular question option entries found'
			ELSE
				SELECT *, 'After inserting regular question options' FROM @RespTemp
		END
		--Collect custom responses
		;WITH CTE2
		AS
		(
		SELECT
		Q.ref.value('../@eventQuestionID', 'INT') AS QuestionID,
		Q.ref.value('@eventCustomResponse', 'NVARCHAR(MAX)') AS CustomResponse,
		NULL AS OptionID,
		NULL AS ResponseXml
		FROM @i_EventXML.nodes('/DM2ContentIndexing_CvEvent/eventQuestions/eventQuestionResponse') Q(ref)
		)
		INSERT INTO @RespTemp
		SELECT CTE2.QuestionID, CTE2.OptionID, CTE2.CustomResponse, ISNULL(PR.ResponseID, -1), CTE2.ResponseXml FROM CTE2
		LEFT JOIN CvEvents_Response PR WITH(NOLOCK) ON CTE2.QuestionID = PR.QuestionID AND PR.CustomResponse IS NOT NULL AND PR.ParticipantID=@ParticipantIdVal
		WHERE CTE2.CustomResponse IS NOT NULL
		IF @i_debug = 1
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 * FROM @RespTemp WHERE ISNULL(CustomResponse,'') <> '')
				SELECT 'No custom responses found'
			ELSE
				SELECT *, 'After inserting custom response entries' FROM @RespTemp
		END
	SET NOCOUNT OFF
		MERGE CvEvents_Response as A
		USING (SELECT * FROM @RespTemp) AS S ON A.ResponseID = S.ResponseId
		WHEN NOT MATCHED BY TARGET THEN
			INSERT (ParticipantID, QuestionID, OptionID, CustomResponse,ResponseXml)
			VALUES (@ParticipantIdVal, S.QuestionID, S.OptionID, S.CustomResponse, S.ResponseXml)
		WHEN MATCHED THEN
			UPDATE SET CustomResponse = S.CustomResponse, ResponseXml = S.ResponseXml
		WHEN NOT MATCHED BY SOURCE AND A.ParticipantID = @ParticipantIdVal AND A.QuestionID IN (SELECT QuestionID FROM CVEvents_Question WITH(NOLOCK) WHERE EventID = @EventID) THEN
			DELETE
		OUTPUT $Action as MergeAction, inserted.ParticipantID, inserted.QuestionID, inserted.OptionID, inserted.CustomResponse,
		deleted.ParticipantID, deleted.QuestionID, deleted.OptionID, deleted.CustomResponse INTO @OperationResult;
		UPDATE CvEvents_Participant
		SET ParticipatedAt = @ParticipatedAt,
		AdultCount=@AdultCount,
		ChildCount=@ChildCount
		WHERE ParticipantID = @ParticipantIdVal
		SELECT @Error = @@ERROR, @returnMessage = (CASE WHEN @Error > 0 THEN 'Unexpected Error' ELSE 'Success' END)
		IF @i_debug = 1
		BEGIN
			SELECT * FROM @OperationResult
		END
	END
	ELSE
	BEGIN
		SELECT @Error = 10519, @ReturnMessage = 'Specified user [' + CONVERT(nvarchar,ISNULL(@i_UserGUID, '')) + '] is not allowed to respond to this event [' + @EventID + ']'
	END
exitLine:
	SELECT @Error 'ReturnCode', @ReturnMessage 'ReturnMessage'
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_RespondToEvent')
	delete from GxQscripts where name = 'sp_dm2_cve_RespondToEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_RespondToEvent')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_RespondToEvent'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_RespondToEvent',  '00010002004200060000', 'sp_dm2_cve_RespondToEvent', '00010002004200060000')
GO

