

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_GetUserInformation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_GetUserInformation.sp,v $ $Id: sp_dm2_cve_GetUserInformation.sp,v 1.1.2.3 2018/03/27 08:50:54 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_cve_GetUserInformation <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_GetUserInformation')
	drop procedure sp_dm2_cve_GetUserInformation
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_GetUserInformation')
	delete from GxQscripts where name = 'sp_dm2_cve_GetUserInformation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_GetUserInformation')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_GetUserInformation'
GO
print '... Creating Procedure: sp_dm2_cve_GetUserInformation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_GetUserInformation
  @i_userGuid nvarchar(256),
  @i_userInfo XML,
  @i_adGroups XML = ''--it is cveventuser list having all the adgroups in which this user belongs
AS
  DECLARE @o_retMsg nvarchar(max)
  DECLARE @o_errCode int
	SET NOCOUNT ON
DECLARE @errCode int = 0
DECLARE @retMsg nvarchar(max) = N''
DECLARE @tags nvarchar(max) = N''
DECLARE @CVGroups TABLE (GroupId int)
DECLARE @ad_CVGroups TABLE (GroupId int) --get all the groups in which adgroups of user is a participant
DECLARE @CVEvents TABLE (EventId int , participantNotOrganizer BIT)
DECLARE @CVAdGroups TABLE (GroupGuid nvarchar(256))
DECLARE @userInfoFound BIT
DECLARE @adGroupFound BIT
DECLARE @userGuid NVARCHAR(256)
DECLARE @userName NVARCHAR(1024)
DECLARE @aliasName NVARCHAR(1024)
DECLARE @smtpAddress NVARCHAR(1024)
DECLARE @currentTime bigint = 0
DECLARE @out_notifications XML
DECLARE @out_events XML
--Constants
DECLARE @GROUPTYPE_LOGICAL INT = 2,
		@GROUPTYPE_NONE INT = 0,
		@GROUPTYPE_DOMAIN INT =1,
		@NOTIFICATION_ON INT =1,
		@USERTYPE_INVITED INT = 6,
		@USERTYPE_MEMBER INT = 2
SET @userInfoFound = @i_userInfo.exist('/DM2ContentIndexing_UserInfo')
SET @adGroupFound = @i_adGroups.exist('/DM2ContentIndexing_CvEventUsers')
	IF ISNULL(@i_userGuid,'') <> ''
	BEGIN
		IF @userInfoFound <> 0
		BEGIN
				--Get the user information from UserInfo
				SELECT @userGuid = ISNULL(T.ref.value('@userGuid','nvarchar(256)'),'') FROM @i_userInfo.nodes('/DM2ContentIndexing_UserInfo') T(ref)
				IF @userGuid = ''
				BEGIN
					SELECT @errCode=10517, @retMsg='UserGuid not provided' --USER_GUID_NOT_PROVIDED
					GOTO EXITLINE
				END
				SELECT @userName = ISNULL(T.ref.value('@userName','nvarchar(256)'),'') FROM @i_userInfo.nodes('/DM2ContentIndexing_UserInfo') T(ref)
				IF @userName = ''
				BEGIN
					SELECT @errCode=10544, @retMsg='UserName not provided' --USER_DETAILS_NOT_VALID
					GOTO EXITLINE
				END
				SELECT @smtpAddress = ISNULL(T.ref.value('@smtpAddress','nvarchar(256)'),'') FROM @i_userInfo.nodes('/DM2ContentIndexing_UserInfo') T(ref)
				IF @smtpAddress = ''
				BEGIN
					SELECT @errCode=10544, @retMsg='Email not provided' --USER_DETAILS_NOT_VALID
					GOTO EXITLINE
				END
		END
		IF @adGroupFound <> 0
		BEGIN
				--Get the adgroups in temp table @CVAdGroups
				INSERT INTO @CVAdGroups
				SELECT ISNULL(T.ref.value('@groupGuid','nvarchar(256)'),'') AS GroupGuid
				FROM @i_adGroups.nodes('/DM2ContentIndexing_CvEventUsers/users') T(ref)
				--Get the groups in which adgroups are member
				INSERT INTO @ad_CVGroups
				SELECT GU.GroupID
				FROM CvEvents_GroupUser GU WITH(NOLOCK) JOIN @CVAdGroups AD
				ON GU.GroupType=@GROUPTYPE_DOMAIN AND GU.GroupUserGuid=AD.GroupGuid
		END
/*
		--Get Groups in which user belongs
		INSERT INTO @CVGroups
		SELECT GroupID
		FROM CvEvents_GroupUser WITH (NOLOCK)
		WHERE GroupUserGuid=@i_userGuid
		--Get Events in which above group belongs
		INSERT INTO @CVEvents
		SELECT P.EventID
		FROM CvEvents_Participant P WITH(NOLOCK) JOIN @CVGroups G
		ON P.GroupType=@GROUPTYPE_LOGICAL AND P.GroupUserGuid=G.GroupId
		*/
		--get events in which groups(in which user is a member) are participants
		INSERT INTO @CVEvents
		SELECT P.EventID as EventId, 1 as participantNotOrganizer from CvEvents_Participant P WITH(NOLOCK)
		JOIN CvEvents_GroupUser CG
		ON P.GroupType=@GROUPTYPE_LOGICAL AND P.GroupUserGuid = CONVERT(NVARCHAR(20),CG.GroupID)
		WHERE CG.GroupUserGuid = @i_userGuid
		--Get events in which adgroups are participant
		INSERT INTO @CVEvents
		SELECT P.EventID as EventId, 1 as participantNotOrganizer
		FROM CvEvents_Participant P WITH(NOLOCK) JOIN @CVAdGroups AD ON P.GroupType=@GROUPTYPE_DOMAIN AND P.GroupUserGuid = AD.GroupGuid
		--check if user is a participant in those events and add if not
		MERGE
		CvEvents_Participant P
		USING (SELECT * FROM @CVEvents WHERE participantNotOrganizer =1) E
		ON P.EventID=E.EventID AND P.GroupUserGuid=@i_userGuid
		WHEN NOT MATCHED BY TARGET THEN
			INSERT (GroupUserGuid,GroupType,ParticipationStatus,EventID,isFavorite,NotificationCode,AdultCount,ChildCount,LastSeen)
			VALUES(
			@i_userGuid,
			@GROUPTYPE_NONE,
			@USERTYPE_INVITED,
			E.EventId,
			0,
			@NOTIFICATION_ON,
			0,
			0,
			GETUTCDATE()
			);
		--get events in which groups(in which user is a member) are organizer
		INSERT INTO @CVEvents
		SELECT O.EventID as EventId, 0 as participantNotOrganizer from CvEvents_Organizer O WITH(NOLOCK)
		JOIN CvEvents_GroupUser CG
		ON O.GroupType=@GROUPTYPE_LOGICAL AND O.GroupUserGuid = CONVERT(NVARCHAR(20),CG.GroupID)
		WHERE CG.GroupUserGuid = @i_userGuid
		--Get events in which adgroups are organizer
		INSERT INTO @CVEvents
		SELECT O.EventID as EventId, 0 as participantNotOrganizer
		FROM CvEvents_Organizer O WITH(NOLOCK) JOIN @CVAdGroups AD ON O.GroupType=@GROUPTYPE_DOMAIN AND O.GroupUserGuid = AD.GroupGuid
		--check if user is a organizer in those events and add if not
		MERGE
		CvEvents_Organizer O
		USING (SELECT * FROM @CVEvents WHERE participantNotOrganizer = 0) E
		ON O.EventID=E.EventID AND O.GroupUserGuid=@i_userGuid
		WHEN NOT MATCHED BY TARGET THEN
			INSERT (GroupUserGuid,EventID, GroupType, isFavorite, NotificationCode)
			VALUES(
			@i_userGuid,
			E.EventId,
			@GROUPTYPE_NONE,
			0,
			@NOTIFICATION_ON
			);
		--get events in which groups(in which user is a member) are organizers
		INSERT INTO @CVEvents
		SELECT O.EventID as EventId, 0 as participantNotOrganizer from CvEvents_Organizer O WITH(NOLOCK)
		JOIN CvEvents_GroupUser CG
		ON O.GroupType=@GROUPTYPE_LOGICAL AND O.GroupUserGuid = CG.GroupID
		WHERE CG.GroupUserGuid = @i_userGuid
		--check if user is a member in those groups in which adgroup is a member and if not add
		MERGE
		CvEvents_GroupUser GU
		USING @ad_CVGroups AG
		ON GU.GroupID=AG.GroupId AND GU.GroupUserGuid=@i_userGuid
		WHEN NOT MATCHED BY TARGET THEN
		INSERT (GroupUserGuid,GroupID, NotificationCode, MembershipStatus, ParticipatedAt, LastSeen)
		VALUES(
		@i_userGuid,
		AG.GroupId,
		@NOTIFICATION_ON,
		@USERTYPE_MEMBER,
		GETUTCDATE(),
		GETUTCDATE()
		);
		--check and add user to CvEvents_User
		IF NOT EXISTS(SELECT * FROM CvEvents_User WITH (NOLOCK) WHERE UserID=@i_userGuid)
		BEGIN
			INSERT INTO CvEvents_User(UserID,MailID,DisplayName,Tags,LastSeen)
			VALUES(
			@userGuid,
			@smtpAddress,
			@userName,
			'',
			GETUTCDATE()
			)
		END
		ELSE
		BEGIN
			UPDATE CvEvents_User SET LastSeen=GETUTCDATE() WHERE UserID=@i_userGuid  --TODO
		END
		SET @currentTime= dbo.GetUnixTimeBig(GETUTCDATE())*1000
		/*Calling GetNotification procedure for getting notifications*/
		/*
		EXEC sp_dm2_cve_GetNotification @i_userGuid= @i_userGuid, @i_suppressResults='1',@o_outXML = @out_notifications OUTPUT --suppressResults will hide the xml from results after executing this sp
		EXEC sp_dm2_cve_SearchUserEvents @i_userGuid= @i_userGuid, @i_isOrganizerSearch=False , @i_searchOnlyQuestion=False , @i_participantWithResp=False, @i_suppressResults='1',@i_startDate=@currentTime ,@o_outXML = @out_events OUTPUT
		--return user with tags to store on frontend in local storage
		SELECT
		(
		 SELECT Tags
		 FROM CvEvents_User U
		 WHERE U.UserID=@i_userGuid
		 )as '@tags',	----getting user tags
		 (
		 SELECT ISNULL(T.ref.value('@totalEvents','int'),0)
		 FROM @out_events.nodes('/DM2ContentIndexing_CvEventResp') T(ref) -----to get total count of events
		 ) as '@totalEvents',
		 (
		 SELECT @out_events.query('/DM2ContentIndexing_CvEventResp/events') ---getting all timeline events
		 ),
		 (
		 SELECT @out_notifications.query('/DM2ContentIndexing_CvEventResp/notifications')	---get all the notifications related to events and groups
		 )
		FOR XML PATH('DM2ContentIndexing_CvEventResp')*/
		SELECT
		(
		 SELECT Tags
		 FROM CvEvents_User U
		 WHERE U.UserID=@i_userGuid
		 )as '@tags'	----getting user tags
		 for xml path('DM2ContentIndexing_CvEventResp')
	END
	ELSE
	BEGIN
		SELECT @retMsg = 'No user GUID is passed', @errCode = 10517   --USER_GUID_NOT_PROVIDED
		GOTO EXITLINE
	END
	EXITLINE:
		SELECT @retMsg , @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_GetUserInformation')
	delete from GxQscripts where name = 'sp_dm2_cve_GetUserInformation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_GetUserInformation')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_GetUserInformation'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_GetUserInformation',  '00010001000200030000', 'sp_dm2_cve_GetUserInformation', '00010001000200030000')
GO

