

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_GetNotification.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_GetNotification.sp,v $ $Id: sp_dm2_cve_GetNotification.sp,v 1.1.2.2 2018/03/27 09:11:04 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_cve_GetNotification <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_GetNotification')
	drop procedure sp_dm2_cve_GetNotification
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_GetNotification')
	delete from GxQscripts where name = 'sp_dm2_cve_GetNotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_GetNotification')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_GetNotification'
GO
print '... Creating Procedure: sp_dm2_cve_GetNotification'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_GetNotification
  @i_userGuid nvarchar(256)
AS
	DECLARE @lastSeen datetime
---------------------------------------------------------------------------------------------
------------------------CONSTANTS------------------------------------------------------------
---------------------------------------------------------------------------------------------
/*	DECLARE @USERTYPE_REJECTED INT = 8,
			@USERTYPE_LEFT INT = 10,
			@USERTYPE_REMOVED INT = 11
			*/
	-----------------------table to store modified events-----------------------------------
	DECLARE @CvEvent TABLE (
		EventId			int,
		Title			nvarchar(512),
		ModifiedBy		nvarchar(512),
		ModifiedTime	datetime,
		ModifiedType	bigint,
		seen			int
	)
	-----------------------temp table to store modified groups-------------------------------
	/*
	DECLARE @CvEventGroup TABLE(
		GroupID			int,
		GroupName		nvarchar(256),
		ModifiedBy		nvarchar(256),
		ModifiedTime	bigint,
		ModifiedType	bigint,
		seen			int
	)*/
  ---------------------------------------------------------------------------------------------
  -----------------------MAIN LOGIC------------------------------------------------------------
  ---------------------------------------------------------------------------------------------
	---getting last seen time of user from CvEvents_User table
	SELECT @lastSeen=LastSeen FROM CvEvents_User WITH(NOLOCK) WHERE UserID=@i_userGuid
	--UPDATE CvEvents_User SET LastSeen=GETUTCDATE() where UserID=@i_userGuid --updating last seen of user  --TODO LATER
	-----------Adding events which are modified since the user lastseen them-------------------
	INSERT INTO @CvEvent(EventId,Title,ModifiedBy,ModifiedTime,ModifiedType,seen)
	SELECT E.EventID AS EventId,
	E.Title	AS Title,
	E.ModifiedBy AS ModifiedBy,
	E.ModifiedTime AS ModifiedTime,
	E.ModifiedType AS ModifiedType,
	CASE WHEN @lastSeen >E.ModifiedTime THEN 1 ELSE 0 END AS seen
	FROM CvEvents_Event E WITH(NOLOCK) JOIN CvEvents_Participant P WITH(NOLOCK) ON E.EventID=P.EventID AND
	P.GroupUserGuid=@i_userGuid AND
	E.ModifiedTime>P.LastSeen AND E.ModifiedType > 0
	--DECLARE @v XML = (SELECT * FROM @CVEvent FOR XML AUTO)--Debugging (to be removed)
	/*
	---------------Adding gorups which are modified since the user lastseen them---------------
	INSERT INTO @CvEventGroup(GroupID,GroupName,ModifiedBy,ModifiedTime,ModifiedType,seen)
	SELECT G.GroupID as GroupID,
	G.GroupName	as GroupName,
	G.ModifiedBy as ModifiedBy,
	dbo.GetUnixTimeBig(G.ModifiedTime)*1000 as ModifiedTime,
	G.ModifiedType as ModifiedType,
	CASE WHEN @lastSeen > dbo.GetUnixTimeBig(G.ModifiedTime)*1000 THEN 1 ELSE 0 END AS seen
	FROM CvEvents_Group G WITH(NOLOCK) JOIN CvEvents_GroupUser GU WITH(NOLOCK) ON
	G.GroupID=GU.GroupID AND
	G.ModifiedType > 0 AND
	GU.GroupUserGuid=@i_userGuid AND
	dbo.GetUnixTimeBig(G.ModifiedTime)> dbo.GetUnixTimeBig(GU.LastSeen) AND
	GU.MembershipStatus NOT IN(@UserType_Rejected, @UserType_Removed, @UserType_Left) --to ignore notifications for left, remove or rejected users
	*/
	--Getting Events notifications
	 SELECT
		(
		SELECT
		ModifiedTime AS '@modifiedTime',
		seen AS '@seen',
		0 AS '@isGroup',		--to separate events and groups notifications
		ModifiedType AS '@modifiedType',
			(
			SELECT
			CVE.EventID AS '@eventID',
			CVE.Title AS '@eventTitle'
			FOR XML PATH('cvEvent'), Type
			),
			(
			SELECT
			U.UserID AS '@userGuid',
			U.MailID AS '@smtpAddress',
			U.DisplayName AS '@smptpAddress'
			FROM CvEvents_User U WITH(NOLOCK) WHERE U.UserID = ModifiedBy
			FOR XML PATH('modifiedBy'),Type
			)
		FROM @CvEvent CVE
		FOR XML PATH('notifications'),Type
		)
	/*,
	--Getting Groups Notification
		(
		SELECT
		ModifiedTime AS '@modifiedTime',
		seen AS '@seen',
		1 AS '@isGroup',
		ModifiedType AS '@modifiedType',
			(SELECT
			GP.GroupID AS '@groupId',
			GP.GroupName AS '@groupName'
			FOR XML PATH('group'), Type
			),
			(
			SELECT
			U.UserID as '@userGuid',
			U.MailID as '@smtpAddress',
			U.DisplayName as '@smptpAddress'
			FROM CvEvents_User U WITH(NOLOCK) WHERE U.UserID = ModifiedBy
			FOR XML PATH('modifiedBy'),Type
			)
		FROM @CvEventGroup GP
		FOR XML PATH('notifications'),Type
		)*/
	FOR XML PATH('DM2ContentIndexing_CvEventResp')
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_GetNotification')
	delete from GxQscripts where name = 'sp_dm2_cve_GetNotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_GetNotification')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_GetNotification'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_GetNotification',  '00010001000200020000', 'sp_dm2_cve_GetNotification', '00010001000200020000')
GO

