

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_DeleteGroup.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_DeleteGroup.sp,v $ $Id: sp_dm2_cve_DeleteGroup.sp,v 1.1.2.2 2018/03/27 09:07:02 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_cve_DeleteGroup <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_DeleteGroup')
	drop procedure sp_dm2_cve_DeleteGroup
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_DeleteGroup')
	delete from GxQscripts where name = 'sp_dm2_cve_DeleteGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_DeleteGroup')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_DeleteGroup'
GO
print '... Creating Procedure: sp_dm2_cve_DeleteGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_DeleteGroup
  @i_GroupIds nvarchar(max)=N'', --comma separated list of groupids 
  @i_UserGUID nvarchar(max)=N'',
  @i_DeleteAll BIT =0
AS
/********************** (For now this Stored Procedure is not in use) ******************************/
---------------------------------------------------------------------------------------------
------------------------------Local VARIABLES------------------------------------------------
---------------------------------------------------------------------------------------------
  DECLARE @o_errCode INT;;
  DECLARE @o_retMsg varchar(max);
  DECLARE @iterator1 int =1
  DECLARE @iterator2 int  =1
  DECLARE @count int = 0
  DECLARE @memberCount int = 0
  DECLARE @currentGroupId int = 0
  DECLARE @memberId nvarchar(max) = N''
  DECLARE @groupName nvarchar(max) = N''
   ---------------------------------------------------------------------------------------------
  ---------------------------------CONSTANT----------------------------------------------------
  ---------------------------------------------------------------------------------------------
  DECLARE @USERTYPE_CREATOR INT = 9,
		  @GROUPTYPE_LOGICAL INT = 2,
		  @GROUPTYPE_NONE INT = 0
	SET NOCOUNT ON
	DECLARE		@errCode INT
	DECLARE		@retMsg varchar(max)
	DECLARE @tmpGroupId TABLE (
		seq int IDENTITY(1,1),
		GroupId INT
	)
	/*************************** Create Temp Tables ***************************/
	IF object_id('tempdb.dbo.#members') IS NOT null DROP TABLE #members
		CREATE TABLE #members(
		seq int IDENTITY(1,1),
		userGuid nvarchar(256)
		)
    SET @errCode=0
	SET @retMsg=''
	---------------------------------------------------------------------------------------------
	-------------------------------MAIN LOGIC----------------------------------------------------
	---------------------------------------------------------------------------------------------
	IF @i_DeleteAll = 0
	BEGIN
			IF LEN(@i_GroupIds)=0
			BEGIN
				SELECT @retMsg = 'No Group ID is passed', @errCode = 10545
				GOTO ExitLine
			END
			ELSE
			BEGIN
				INSERT INTO @tmpGroupId
				SELECT  _ID
				FROM dbo.SplitIDs(@i_GroupIds)
				WHERE _ID IS NOT NULL
			END
	END
	ELSE
	BEGIN
	------------------------------TO DELETE ALL GROUPS CREATED BY USER IF @i_DeleteAll------------------------------------
		IF LEN(@i_UserGUID) =0
		BEGIN
			SELECT @retMsg = 'No user GUID is passed', @errCode = 10517
			GOTO ExitLine
		END
		ELSE
		BEGIN
			INSERT INTO @tmpGroupId(GroupId)
			SELECT GroupID FROM CvEvents_GroupUser WITH(NOLOCK) WHERE GroupUserGuid=@i_UserGUID AND MembershipStatus = @USERTYPE_CREATOR /*To get all groups created by user*/
		END
	END
	IF EXISTS(SELECT TOP 1 * FROM @tmpGroupId)
	BEGIN
			SET @iterator1=1
			SELECT @count=count(*) FROM @tmpGroupId
			------------------------iterating over each group tmpGroupId table------------------------------
			WHILE @iterator1<=@count
			BEGIN
				SELECT @currentGroupId=GroupID FROM @tmpGroupId WHERE seq=@iterator1
				SELECT @groupName=name FROM UMGroups WITH(NOLOCK) WHERE id=@currentGroupId
				---------------------------------------------------------------------------------------------
				---------------Removing group users from all the parent groups-------------------------------
				---------------------------------------------------------------------------------------------
				INSERT INTO #members(userGuid)	------TO GET ALL THE MEMBERS OF CURRENT GROUP
				SELECT DISTINCT GroupUserGuid FROM CvEvents_GroupUser WITH(NOLOCK) WHERE GroupID=@currentGroupId AND GroupType=@GROUPTYPE_NONE
				SET @iterator2=1
				SELECT @memberCount=count(*) FROM #members
				-------------ITERATING OVER ALL MEMBERS-----------------
				WHILE @iterator2<=@memberCount
				BEGIN
					SELECT @memberId=userGuid FROM #members WHERE seq=@iterator2
					EXEC sp_dm2_cve_GroupMemberDeletion @i_userGuid=@memberId,@i_groupId=@currentGroupId	---call GroupMemberDeletion to delete current member from all the parent groups of currentGroup
					SET @iterator2=@iterator2+1
				END
				DELETE FROM #members --empty temporary table for next iteration
				------------------After removing from all parent groups removing users from current group-------------------------
				DELETE CvEvents_GroupUser
				FROM CvEvents_GroupUser GU
				where
				GU.GroupID = @currentGroupId
				SELECT @errCode = @@ERROR
				IF @errCode <> 0
				BEGIN
					SELECT @retMsg ='Unexpected Error'
					GOTO ExitLine
				END
				-------------------------Removing group entries from participant table if any-------------------------------------
				DELETE CvEvents_Participant
				FROM CvEvents_Participant CEP
				where CEP.GroupType= @GROUPTYPE_LOGICAL AND CEP.GroupUserGuid=@currentGroupId
				SELECT @errCode = @@ERROR
				IF @errCode <> 0
				BEGIN
					SELECT @retMsg ='Unexpected Error'
					GOTO ExitLine
				END
				-------------------------Removing group entries from organizer table if any---------------------------------------
				DELETE CvEvents_Organizer
				FROM CvEvents_Organizer CEO
				where CEO.GroupType= @GROUPTYPE_LOGICAL AND CEO.GroupUserGuid=@currentGroupId
				SELECT @errCode = @@ERROR
				IF @errCode <> 0
				BEGIN
					SELECT @retMsg ='Unexpected Error'
					GOTO ExitLine
				END
				------------------Removal of Group Name from all parent groups admin and member list------------------------------
				--EXEC sp_dm2_cve_UpdateGroupDisplayLists @i_groupId=@currentGroupId,@i_nameOrMail=@groupName,@i_isName=0
				------------------Finally deleting group from UMGroups table------------------------------------------------------
				DELETE FROM UMGroups WHERE id=@currentGroupId
				SELECT @errCode = @@ERROR, @retMsg = (CASE WHEN @errCode > 0 THEN 'Unexpected Error' ELSE 'Success' END)
				SET @iterator1=@iterator1+1
			END
	END
	ELSE
		SELECT @errCode=10546, @retMsg='No group found to delete'
	ExitLine:
		if object_id('tempdb.dbo.#members') is not null
	        DROP TABLE #members
		SELECT @errCode AS ReturnCode, @retMsg as ReturnMessage
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_DeleteGroup')
	delete from GxQscripts where name = 'sp_dm2_cve_DeleteGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_DeleteGroup')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_DeleteGroup'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_DeleteGroup',  '00010001000200020000', 'sp_dm2_cve_DeleteGroup', '00010001000200020000')
GO

