

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_DeleteEventResponse.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_DeleteEventResponse.sp,v $ $Id: sp_dm2_cve_DeleteEventResponse.sp,v 1.2.54.2 2018/03/27 09:04:21 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_cve_DeleteEventResponse <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_DeleteEventResponse')
	drop procedure sp_dm2_cve_DeleteEventResponse
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_DeleteEventResponse')
	delete from GxQscripts where name = 'sp_dm2_cve_DeleteEventResponse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_DeleteEventResponse')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_DeleteEventResponse'
GO
print '... Creating Procedure: sp_dm2_cve_DeleteEventResponse'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_DeleteEventResponse
  @i_EventId INT=0,
  @i_ParticipantGUIDList nvarchar(max)='',
  @i_QuestionList nvarchar(max)=''  
AS
  DECLARE @o_errCode INT;
  DECLARE @o_retMsg varchar(max);
  DECLARE @o_returnId BIT;
	SET NOCOUNT ON
	DECLARE		@errCode INT
	DECLARE		@retMsg varchar(max)
	DECLARE		@hasParticipants INT=0
	DECLARE		@hasQuestions INT=0
------------------------------------TABLES---------------------------------------------------
---------------------------------------------------------------------------------------------
	 DECLARE @ParticipantIds
	TABLE(
			ParticipantID NVARCHAR(MAX)
		)
	DECLARE @QuestionIds
	TABLE(
		QuestionID INT
		)
    SET @errCode=0
	SET @retMsg=''
	---------------------------------MAIN LOGIC--------------------------------------------------
	---------------------------------------------------------------------------------------------
	IF(@i_EventId=0)
		BEGIN
			SELECT @retMsg = 'No Event ID is passed.', @errCode = 10518	-- EVENT_ID_NOT_PROVIDED
			GOTO ExitLine
		END
	ELSE
	BEGIN
		IF LEN(@i_ParticipantGUIDList)=0 AND LEN(@i_QuestionList) =0
			BEGIN
				SELECT @retMsg = 'No Question/participant ID is passed to delete', @errCode = 10523		-- Q_ID_OR_PARTICIPANT_ID_NOT_PASSED
				GOTO ExitLine
			END
		IF LEN(@i_ParticipantGUIDList)>0
				BEGIN
					SET @hasParticipants=1
					INSERT INTO @ParticipantIds
					SELECT  LTRIM(RTRIM(ID))
					FROM dbo.splitStringToTable(@i_ParticipantGUIDList)
					WHERE ID IS NOT NULL
					AND LEN(ID) > 0
				END
		IF LEN(@i_QuestionList)>0
				BEGIN
					SET @hasQuestions=1
					INSERT INTO @QuestionIds
					SELECT  _ID
					FROM dbo.SplitIDs(@i_QuestionList)
					WHERE _ID IS NOT NULL
				END
		-----------------------DELETING PARTICIPANTS RESPONSES------------------------------------------------
		IF(@hasParticipants>0)
			BEGIN
				DELETE CvEvents_Response
				FROM CvEvents_Response CER,(SELECT P.ParticipantID FROM CvEvents_Participant P WITH(NOLOCK) WHERE P.GroupUserGuid IN(SELECT ParticipantID FROM @ParticipantIds) AND P.EventID=@i_EventId) AS PL
				WHERE CER.ParticipantID = PL.ParticipantID
				SELECT @errCode = @@ERROR
				IF(@errCode>0)
					BEGIN
						SET @retMsg='Failed to delete the responses for the participants'
						GOTO ExitLine
					END
			END
		----------------------DELETING QUESTIONS RESPONSES -----------------------------------------------------
		IF(@hasQuestions>0)
			BEGIN
				DELETE CvEvents_Response
				FROM CvEvents_Response CER,(SELECT CVQ.QuestionID FROM CvEvents_Question CVQ WITH(NOLOCK) WHERE CVQ.EventID=@i_EventId AND CVQ.QuestionID NOT IN(SELECT QID.QuestionID FROM @QuestionIds QID)) Q
				WHERE CER.QuestionID=Q.QuestionID
				SELECT @errCode = @@ERROR
				IF(@errCode>0)
					BEGIN
						SET @retMsg='Failed to delete the responses for the questions'
						GOTO ExitLine
					END
			END
	END
	ExitLine:
	SELECT @errCode AS ReturnCode, @retMsg as ReturnMessage, (CASE WHEN @errCode = 0 THEN 1 ELSE 0 END) as ReturnId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_DeleteEventResponse')
	delete from GxQscripts where name = 'sp_dm2_cve_DeleteEventResponse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_DeleteEventResponse')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_DeleteEventResponse'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_DeleteEventResponse',  '00010002005400020000', 'sp_dm2_cve_DeleteEventResponse', '00010002005400020000')
GO

