

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_dm2_cve_DeleteEvent.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_dm2_cve_DeleteEvent.sp,v $ $Id: sp_dm2_cve_DeleteEvent.sp,v 1.1.54.3 2020/08/27 00:59:22 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_cve_DeleteEvent')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_cve_DeleteEvent <<<'
	drop procedure sp_dm2_cve_DeleteEvent
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_cve_DeleteEvent')
	delete from GxQscripts where name = 'sp_dm2_cve_DeleteEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_DeleteEvent')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_DeleteEvent'
GO
print '... Creating Procedure: sp_dm2_cve_DeleteEvent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_cve_DeleteEvent
  @i_EventIds nvarchar(max)=N'',  
  @i_UserGUID nvarchar(max)=N'',
  @i_DeleteAll BIT =0
 -- i_EventIds --> This will be comma seperated list of EventIds from CvEvents_Event
AS
  DECLARE @o_errCode INT;
  DECLARE @o_retMsg varchar(max);
	SET NOCOUNT ON
	DECLARE		@errCode INT
	DECLARE		@retMsg varchar(max)
	DECLARE @tmpEventId TABLE (
		EventId INT
	)
    SET @errCode=0
	SET @retMsg=''
	IF @i_DeleteAll = 0
		IF LEN(@i_EventIds)=0
		BEGIN
			SELECT @retMsg = 'No Event ID is passed', @errCode = 10518 --EVENT_ID_NOT_PROVIDED
			GOTO ExitLine
		END
		ELSE
			BEGIN
				-------------------Get eventids from comma separated @i_eventids-------------------------
				INSERT INTO @tmpEventId
				SELECT  _ID
				FROM dbo.SplitIDs(@i_EventIds)
				WHERE _ID IS NOT NULL AND dbo.canManageEventSurvey(@i_UserGUID, _ID, 1) = 1
				IF NOT EXISTS(SELECT TOP 1 1 from @tmpEventId)
				BEGIN
					SELECT @retMsg = 'Event does not exists for the user.', @errCode = 10514 -- INVALID_OR_UNKNOWN_USER
					GOTO ExitLine
				END
			END
	ELSE	----------------if no deleteall is 1
		IF LEN(@i_UserGUID) =0
		BEGIN
			SELECT @retMsg = 'No user GUID is passed', @errCode = 10517	--USER_GUID_NOT_PROVIDED
			GOTO ExitLine
		END
		ELSE
		BEGIN
			-----------------get all the events created by @i_UserGuid--------------------------------------
			INSERT INTO @tmpEventId
			SELECT EventID FROM CvEvents_Event CEE WITH(NOLOCK) WHERE CEE.CreatedBy=@i_UserGUID
		END
	---------------Delete responses corresponding to each event from @tmpEventId table----------------------------
	DELETE CvEvents_Response
	FROM CvEvents_Response CER
		INNER JOIN CvEvents_Question CEQ WITH(NOLOCK) ON CEQ.QuestionID=CER.QuestionID
		INNER JOIN @tmpEventId T ON CEQ.EventID=T.EventId
	SELECT @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SELECT @retMsg ='Unexpected Error'
		GOTO ExitLine
	END
	---------------Delete question options corresponding to each event from @tmpEventId table----------------------------
	DELETE CvEvents_QuestionOption
	FROM CvEvents_QuestionOption CEQO
	INNER JOIN CvEvents_Question CEQ WITH(NOLOCK) ON CEQO.QuestionID=CEQ.QuestionID
	INNER JOIN @tmpEventId T ON CEQ.EventID=T.EventId
	SELECT @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SELECT @retMsg ='Unexpected Error'
		GOTO ExitLine
	END
	---------------Delete questions corresponding to each event from @tmpEventId table----------------------------
	DELETE CvEvents_Question
	FROM CvEvents_Question CEQ
	INNER JOIN @tmpEventId T ON ceq.EventID=t.EventId
	SELECT @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SELECT @retMsg ='Unexpected Error'
		GOTO ExitLine
	END
	---------------Delete participants corresponding to each event from @tmpEventId table----------------------------
	DELETE CvEvents_Participant
	FROM CvEvents_Participant CEP
	INNER JOIN @tmpEventId T ON CEP.EventID=t.EventId
	SELECT @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SELECT @retMsg ='Unexpected Error'
		GOTO ExitLine
	END
	---------------Delete organizers corresponding to each event from @tmpEventId table----------------------------
	DELETE CvEvents_Organizer
	FROM CvEvents_Organizer CEO
	INNER JOIN @tmpEventId T ON CEO.EventID=T.EventId
	SELECT @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SELECT @retMsg ='Unexpected Error'
		GOTO ExitLine
	END
	---------------Delete events entry from CvEvents_Event table corresponding to each event from @tmpEventId table----------------------------
	DELETE CvEvents_Event
	FROM CvEvents_Event CEE
	INNER JOIN @tmpEventId T ON CEE.EventID=T.EventId
	SELECT @errCode = @@ERROR, @retMsg = (CASE WHEN @errCode > 0 THEN 'Unexpected Error' ELSE 'Success' END)
	ExitLine:
	/* Invalid XML input */
	SELECT @errCode AS ReturnCode, @retMsg as ReturnMessage
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_cve_DeleteEvent')
	delete from GxQscripts where name = 'sp_dm2_cve_DeleteEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_cve_DeleteEvent')
	delete from GXDBVersions where aliasname = 'sp_dm2_cve_DeleteEvent'
GO

insert into GXDBVersions values(2, 'sp_dm2_cve_DeleteEvent',  '00010001005400030000', 'sp_dm2_cve_DeleteEvent', '00010001005400030000')
GO

