

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sp_AppendToFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sp_AppendToFile.sp,v $ $Id: sp_AppendToFile.sp,v 1.2.294.1 2020/07/06 22:15:32 mnatarajan Exp $";
-- =============================================
-- Author:		Anand V
-- Create date: 08/07/2007
-- Description: Appends text to a file
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_AppendToFile')
BEGIN
	print '>>> Drop Stored Procedure: sp_AppendToFile <<<'
	drop procedure sp_AppendToFile
END
IF EXISTS (select * from GxQscripts where name='sp_AppendToFile')
	delete from GxQscripts where name = 'sp_AppendToFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_AppendToFile')
	delete from GXDBVersions where aliasname = 'sp_AppendToFile'
GO
print '... Creating Procedure: sp_AppendToFile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_AppendToFile
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @FileName nvarchar(255),
  @Text1 nvarchar(MAX),
  @noTime integer
AS
BEGIN
DECLARE @FS int, @OLEResult int, @FileID int
DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
DECLARE @errorMessage NVARCHAR(MAX) = ''
IF @noTime = 0
		SET @Text1 = CAST (GETDATE() AS NVARCHAR(25)) + '   ' + @Text1
IF @isOsWindows = 1
BEGIN
	EXECUTE @OLEResult = sp_OACreate 'Scripting.FileSystemObject', @FS OUT
	IF @OLEResult <> 0 PRINT 'Scripting.FileSystemObject'
	--Open a file
	execute @OLEResult = sp_OAMethod @FS, 'OpenTextFile', @FileID OUT, @FileName, 8, 1
	IF @OLEResult <> 0 PRINT 'OpenTextFile'
	--Write Text1
	execute @OLEResult = sp_OAMethod @FileID, 'WriteLine', Null, @Text1
	IF @OLEResult <> 0 PRINT 'WriteLine'
	EXECUTE @OLEResult = sp_OADestroy @FileID
	EXECUTE @OLEResult = sp_OADestroy @FS
END
ELSE
BEGIN
	EXECUTE cv_spWriteToFile @FileName , @Text1, @errorMessage OUTPUT, 1
	IF @errorMessage != NULL AND LEN(@errorMessage)>0
	BEGIN
		PRINT 'cv_spWriteToFile'
	END
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_AppendToFile')
	delete from GxQscripts where name = 'sp_AppendToFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_AppendToFile')
	delete from GXDBVersions where aliasname = 'sp_AppendToFile'
GO

insert into GXDBVersions values(2, 'sp_AppendToFile',  '00010002029400010000', 'sp_AppendToFile', '00010002029400010000')
GO

