SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Sp/clFetchProc.sp] ---------- 

-- * ---------------------------------------------------------------------- *
-- *                                                                        *
-- *               Copyright (c) 1998  CommVault Systems, Inc.              *
-- *                         All rights reserved.                           *
-- *                                                                        *
-- *                                                                        *
-- *        This is unpublished proprietary source code of CommVault        *
-- *        Systems, Inc. The copyright notice above does not evidence      *
-- *        any actual or intended publication of such source code.         *
-- * ---------------------------------------------------------------------- *
-- static char const clfetchproc_sp_rcsid[]="@(#) $Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/clFetchProc.sp,v $ $Id: clFetchProc.sp,v 1.10 2011/05/11 07:03:51 smekala Exp $";
-- *
-- *******************************************************************************
-- *
-- * APP_Client fetch program
-- *
-- * Author:	Michael Krastev
-- *
-- *******************************************************************************
-- *
-- * version 1.0 Thu Mat  4 21:18:44 EST 1999
-- * first release
-- *
-- *******************************************************************************
-- *
-- *
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: clFetchProc <<<'

IF EXISTS (select * from sysobjects where name='clFetchProc')
	drop procedure clFetchProc
IF EXISTS (select * from GxQscripts where name='clFetchProc')
	delete from GxQscripts where name = 'clFetchProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='clFetchProc')
	delete from GXDBVersions where aliasname = 'clFetchProc'
GO
print '... Creating Procedure: clFetchProc'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure clFetchProc
  @comm_cell_id integer,
  @client_id integer
AS
  DECLARE @r_id integer;
  DECLARE @r_name char(128);
  DECLARE @r_commCellId integer;
  DECLARE @r_opersys_ID integer;
  DECLARE @r_net_hostname char(128);
  DECLARE @r_client_password char(128);
  DECLARE @r_refTime integer;
--  	FOREACH	--skip for mssql7--
	  SELECT id, name, 2, simOperatingSystemId, net_hostname, client_password, refTime
--  	    :INTO @r_id, @r_name, @r_commCellId, @r_opersys_ID, @r_net_hostname, @r_client_password, @r_refTime	--skip for mssql7--
	      FROM APP_Client
		WHERE ID = @client_id
--  	  return @r_id, @r_name, @r_commCellId, @r_opersys_ID, @r_net_hostname, @r_client_password, @r_refTime	--skip for mssql7--
--  	  with resume;	--skip for mssql7--
--  	END FOREACH	--skip for mssql7--
GO


IF EXISTS (select * from GxQscripts where name = 'clFetchProc')
	delete from GxQscripts where name = 'clFetchProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='clFetchProc')
	delete from GXDBVersions where aliasname = 'clFetchProc'
GO

insert into GXDBVersions values(2, 'clFetchProc',  '00010010000000000000', 'clFetchProc', '00010010000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cxPurgeUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cxPurgeUser.sp,v $ $Id: cxPurgeUser.sp,v 1.16 2014/12/04 08:10:14 saggarwal Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						PROCEDURE: "cxPurgeUser"						|
--	|																		|
--	|		Purge all records in all tables for specified UID				|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cxPurgeUser <<<'

IF EXISTS (select * from sysobjects where name='cxPurgeUser')
	drop procedure cxPurgeUser
IF EXISTS (select * from GxQscripts where name='cxPurgeUser')
	delete from GxQscripts where name = 'cxPurgeUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cxPurgeUser')
	delete from GXDBVersions where aliasname = 'cxPurgeUser'
GO
print '... Creating Procedure: cxPurgeUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cxPurgeUser
  @uid integer
AS
  DECLARE @retVal integer;
  DECLARE @retString varchar(64);
begin tran
	DECLARE @rowCount  integer
	DECLARE @thisTable varchar(32)
	set @retString = '>> '
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'TM_Task' TABLE	|
--	+-----------------------------------------------+
	set @thisTable = 'TM_Task'
	delete from TM_Task where ownerId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMProfile' TABLE		|
--	+-----------------------------------------------+
	set @thisTable = 'UMProfile'
	delete UMProfile where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMUserGroup' TABLE	|
--	+-----------------------------------------------+
	set @thisTable = 'UMUserGroup'
	delete UMUserGroup where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+---------------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMDSUserGroup' TABLE	|
--	+---------------------------------------------------+
	set @thisTable = 'UMDSUserGroup'
	delete UMDSUserGroup where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
	DELETE UG 	FROM UMUSERGRoup UG JOIN UMGROUPS G ON G.id=UG.groupId WHERE userId = @uid   and G.umdsProviderId<>0
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-------------------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMUserCredentials' TABLE	|
--	+-------------------------------------------------------+
	set @thisTable = 'UMUserCredentials'
	delete UMUserCredentials where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'evFilterContent'	|
--	|  AND 'evFilterName TABLEs						|
--	+-----------------------------------------------+
	set @thisTable = 'evFilterContent'
	DELETE evFilterContent
	WHERE evFilterNameId in (select id from evFilterName where userId = @uid)
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'evFilterName'
	delete evFilterName where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'evParam'			|
--	|  AND 'evMsg TABLEs							|
--	+-----------------------------------------------+
	set @thisTable = 'evParam'
	DELETE evParam
	WHERE evMsgId in (select id from evMsg where userId = @uid)
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'evMsg'
	delete evMsg where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'JMJobInfo' and 	|
--	|  AND related tables							|
--	+-----------------------------------------------+
	set @thisTable = 'JMBkpAttemptInfo'
	DELETE JMBkpAttemptInfo
	FROM  JMBkpAttemptInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMBkpJobInfo'
	DELETE JMBkpJobInfo
	FROM  JMBkpJobInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMJobStreams'
	DELETE JMJobStreams
	FROM  JMJobStreams b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMRstAttemptInfo'
	DELETE JMRstAttemptInfo
	FROM  JMRstAttemptInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMRstJobInfo'
	DELETE JMRstJobInfo
	FROM  JMRstJobInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
--	-----------------------------------------------
	set @thisTable = 'JMJobInfo'
	delete JMJobInfo where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+================================================+
--	+-----------------------------------------------+
-- 	|  FINALLY, CAN NOW DELETE 'user' TABLE entry!	|
--	+-----------------------------------------------+
	set @thisTable = 'UMUsers'
	delete UMUsers where id = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--  +----------------------------+
--  |	NORMAL, 'HAPPY' EXIT:    |
--  +----------------------------+
	select @retVal, @retString
	commit tran
	return @retVal;
--  +----------------------------+
--  |	ABNORMAL, 'ERROR' EXIT:  |
--  +----------------------------+
CX_DELETE_ERROR_EXIT:
	rollback transaction
	select @retVal, @thisTable
	return @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'cxPurgeUser')
	delete from GxQscripts where name = 'cxPurgeUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cxPurgeUser')
	delete from GXDBVersions where aliasname = 'cxPurgeUser'
GO

insert into GXDBVersions values(2, 'cxPurgeUser',  '00010016000000000000', 'cxPurgeUser', '00010016000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLAdminUtilExecQuery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SQLAdminUtilExecQuery <<<'

IF EXISTS (select * from sysobjects where name='SQLAdminUtilExecQuery')
	drop procedure SQLAdminUtilExecQuery
IF EXISTS (select * from GxQscripts where name='SQLAdminUtilExecQuery')
	delete from GxQscripts where name = 'SQLAdminUtilExecQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLAdminUtilExecQuery')
	delete from GXDBVersions where aliasname = 'SQLAdminUtilExecQuery'
GO
print '... Creating Procedure: SQLAdminUtilExecQuery'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SQLAdminUtilExecQuery
  @Query NVARCHAR(MAX),
  @AllowOtherDB INT = 0
AS
IF @AllowOtherDB = 1
	-- Execute as login functionality because sqladmin_cv user can only access CSDB.
	-- For queries that refer to other databases, we need to execute as the login.
	EXECUTE AS LOGIN = 'sqladmin_cv'
ELSE
	-- We use an explicit EXECUTE AS USER statement and not "WITH EXECUTE AS 'dbo'" clause
	-- because the clause cannot coexist with EXECUTE AS LOGIN statement.
	EXECUTE AS USER = 'sqladmin_cv'
EXEC sp_executesql @Query
REVERT
GO
GO

IF EXISTS (select * from GxQscripts where name = 'SQLAdminUtilExecQuery')
	delete from GxQscripts where name = 'SQLAdminUtilExecQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLAdminUtilExecQuery')
	delete from GXDBVersions where aliasname = 'SQLAdminUtilExecQuery'
GO

insert into GXDBVersions values(2, 'SQLAdminUtilExecQuery',  '00000000000000000000', 'SQLAdminUtilExecQuery', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLUtilTruncateTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SQLUtilTruncateTable <<<'

IF EXISTS (select * from sysobjects where name='SQLUtilTruncateTable')
	drop procedure SQLUtilTruncateTable
IF EXISTS (select * from GxQscripts where name='SQLUtilTruncateTable')
	delete from GxQscripts where name = 'SQLUtilTruncateTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLUtilTruncateTable')
	delete from GXDBVersions where aliasname = 'SQLUtilTruncateTable'
GO
print '... Creating Procedure: SQLUtilTruncateTable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SQLUtilTruncateTable
  @TableName NVARCHAR(128)
AS
DECLARE @Query NVARCHAR(256)
SET @Query = 'TRUNCATE TABLE ' + @TableName
EXEC SQLAdminUtilExecQuery @Query
GO

IF EXISTS (select * from GxQscripts where name = 'SQLUtilTruncateTable')
	delete from GxQscripts where name = 'SQLUtilTruncateTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLUtilTruncateTable')
	delete from GXDBVersions where aliasname = 'SQLUtilTruncateTable'
GO

insert into GXDBVersions values(2, 'SQLUtilTruncateTable',  '00000000000000000000', 'SQLUtilTruncateTable', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLUtilIdentityInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SQLUtilIdentityInsert <<<'

IF EXISTS (select * from sysobjects where name='SQLUtilIdentityInsert')
	drop procedure SQLUtilIdentityInsert
IF EXISTS (select * from GxQscripts where name='SQLUtilIdentityInsert')
	delete from GxQscripts where name = 'SQLUtilIdentityInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLUtilIdentityInsert')
	delete from GXDBVersions where aliasname = 'SQLUtilIdentityInsert'
GO
print '... Creating Procedure: SQLUtilIdentityInsert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SQLUtilIdentityInsert
  @Query NVARCHAR(MAX),
  @TableName NVARCHAR(128)
AS
DECLARE @FullQuery NVARCHAR(MAX)
SET @FullQuery = ''
SET @FullQuery = @FullQuery + 'SET IDENTITY_INSERT ' + @TableName + ' ON '
SET @FullQuery = @FullQuery + @Query + ' '
SET @FullQuery = @FullQuery + 'SET IDENTITY_INSERT ' + @TableName + ' OFF '
EXEC SQLAdminUtilExecQuery @FullQuery
GO

IF EXISTS (select * from GxQscripts where name = 'SQLUtilIdentityInsert')
	delete from GxQscripts where name = 'SQLUtilIdentityInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLUtilIdentityInsert')
	delete from GXDBVersions where aliasname = 'SQLUtilIdentityInsert'
GO

insert into GXDBVersions values(2, 'SQLUtilIdentityInsert',  '00000000000000000000', 'SQLUtilIdentityInsert', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLRepairOrphanedDBUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
-- This proc needs to execute as sqladmin_cv login and not as dbo to be able to
-- successfully call sp_change_users_login with UPDATE_ONE.
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SQLRepairOrphanedDBUsers <<<'

IF EXISTS (select * from sysobjects where name='SQLRepairOrphanedDBUsers')
	drop procedure SQLRepairOrphanedDBUsers
IF EXISTS (select * from GxQscripts where name='SQLRepairOrphanedDBUsers')
	delete from GxQscripts where name = 'SQLRepairOrphanedDBUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLRepairOrphanedDBUsers')
	delete from GXDBVersions where aliasname = 'SQLRepairOrphanedDBUsers'
GO
print '... Creating Procedure: SQLRepairOrphanedDBUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SQLRepairOrphanedDBUsers
AS
  DECLARE @RepairedUserName NVARCHAR(128)
BEGIN TRY
	-- Remember results because this is a two pass op.
	CREATE TABLE #OrphanedUsers
	(UserName NVARCHAR(128), UserSID varbinary(85))
	-- Find out who all got orphaned.
	INSERT INTO #OrphanedUsers
	EXEC sp_change_users_login 'REPORT'
	-- Eliminate people we dont care about.
	DELETE FROM #OrphanedUsers
	WHERE UserName NOT IN ('sqladmin_cv', 'sqlexec_cv')
	-- Do sqladmin_cv.
	IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = 'sqladmin_cv')
	EXEC sp_change_users_login 'UPDATE_ONE', 'sqladmin_cv', 'sqladmin_cv'
	-- Do sqlexec_cv.
	IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = 'sqlexec_cv')
	EXEC sp_change_users_login 'UPDATE_ONE', 'sqlexec_cv', 'sqlexec_cv'
	-- Let the caller know what's up.
	SELECT UserName
	FROM #OrphanedUsers
	-- Clean up.
	DROP TABLE #OrphanedUsers
END TRY
BEGIN CATCH
	
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	DECLARE @ErrMsg NVARCHAR(4000) = ERROR_MESSAGE()
	DECLARE @ErrSev INT = ERROR_SEVERITY()
	DECLARE @ErrState INT = ERROR_STATE()
	RAISERROR (@ErrMsg, @ErrSev, @ErrState)
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SQLRepairOrphanedDBUsers')
	delete from GxQscripts where name = 'SQLRepairOrphanedDBUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLRepairOrphanedDBUsers')
	delete from GXDBVersions where aliasname = 'SQLRepairOrphanedDBUsers'
GO

insert into GXDBVersions values(2, 'SQLRepairOrphanedDBUsers',  '00000000000000000000', 'SQLRepairOrphanedDBUsers', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_ExecuteSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   06/16/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_ExecuteSP.sp,v $ $Id: CV_ExecuteSP.sp,v 1.18 2010/04/13 12:57:04 mmohan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_ExecuteSP <<<'

IF EXISTS (select * from sysobjects where name='CV_ExecuteSP')
	drop procedure CV_ExecuteSP
IF EXISTS (select * from GxQscripts where name='CV_ExecuteSP')
	delete from GxQscripts where name = 'CV_ExecuteSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_ExecuteSP')
	delete from GXDBVersions where aliasname = 'CV_ExecuteSP'
GO
print '... Creating Procedure: CV_ExecuteSP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_ExecuteSP
  @SPName varchar(128),
  @Arguments NTEXT,
  @BinaryRevision varchar(20),
  @loggingLevel_in INT = 0,
  @jobId_in BIGINT = 0,
  @threadId_in INT = 0,
  @logFileName_in VARCHAR(MAX) = 'FDCMgr',
  @vmInstance_in VARCHAR(MAX) = 'Instance001',
  @processName_in VARCHAR(MAX) = 'placeholder.exe'
AS
	SET NOCOUNT ON
	IF @loggingLevel_in > 0
	BEGIN
		IF EXISTS ( SELECT  *
					FROM    DBLog WITH ( READUNCOMMITTED )
					WHERE   connectionId = @@SPID )
		BEGIN
			UPDATE  DBLog WITH ( ROWLOCK )
			SET     loggingLevel = @loggingLevel_in ,
                jobId = @jobId_in ,
                threadId = @threadId_in ,
                logFileName = @logFileName_in ,
                processName = @processName_in
			WHERE   connectionId = @@SPID
		END
		ELSE
		BEGIN
			INSERT  INTO DBLog
			VALUES  ( @loggingLevel_in, @jobId_in, @threadId_in, @@SPID,
					@logFileName_in, @vmInstance_in, @processName_in )
		END
	END
	IF ISNULL(DATALENGTH(@Arguments), 0) = 0
		EXECUTE @SPName
	ELSE
		EXECUTE ( 'EXEC ' + @SPName  + ' ' + @Arguments)
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CV_ExecuteSP')
	delete from GxQscripts where name = 'CV_ExecuteSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_ExecuteSP')
	delete from GXDBVersions where aliasname = 'CV_ExecuteSP'
GO

insert into GXDBVersions values(2, 'CV_ExecuteSP',  '00010018000000000000', 'CV_ExecuteSP', '00010018000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_GetSPToExecute.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   06/16/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_GetSPToExecute.sp,v $ $Id: CV_GetSPToExecute.sp,v 1.1 2008/04/08 14:27:40 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_GetSPToExecute <<<'

IF EXISTS (select * from sysobjects where name='CV_GetSPToExecute')
	drop procedure CV_GetSPToExecute
IF EXISTS (select * from GxQscripts where name='CV_GetSPToExecute')
	delete from GxQscripts where name = 'CV_GetSPToExecute'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSPToExecute')
	delete from GXDBVersions where aliasname = 'CV_GetSPToExecute'
GO
print '... Creating Procedure: CV_GetSPToExecute'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_GetSPToExecute
  @SPName varchar(128),
  @BinaryRevision varchar(20)
AS
	DECLARE @AliasName 			varchar(128)
	DECLARE	@SafeRevision 	varchar(20)
	SET NOCOUNT ON
	-- Get the alias name for the given binary revision
	SELECT	@AliasName = aliasname,
			@SafeRevision = SafeRevision
	FROM	GXDBVersions
	WHERE	name = @SPName
	AND		type = 2
	AND		revision = @BinaryRevision
	-- If not found then the DB is not patched yet
	IF @AliasName IS null
		SELECT	TOP 1 @AliasName = aliasname,
				@SafeRevision = SafeRevision
		FROM	GXDBVersions
		WHERE 	name = @SPName
		AND		type = 2
		AND		revision < @BinaryRevision
		ORDER BY id DESC
	-- If still not found then error out
	IF @AliasName IS null
		GOTO CX_EXIT
	-- Now get the safe version that could be executed moving forward. This way binary need not be patched till the signature actually changes
	IF ISNULL(@SafeRevision, '') <> ''
		SELECT	TOP 1 @AliasName = aliasname
		FROM	GXDBVersions
		WHERE 	name = @SPName
		AND		type = 2
		AND		SafeRevision = @SafeRevision
		ORDER BY id DESC
	CX_EXIT:
		-- If not found then the DB is not patched yet
		IF @AliasName IS null
			SELECT -1 AS errorCode, @SPName AS AliasName
		ELSE
		SELECT 0 AS errorCode, @AliasName AS AliasName
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CV_GetSPToExecute')
	delete from GxQscripts where name = 'CV_GetSPToExecute'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSPToExecute')
	delete from GXDBVersions where aliasname = 'CV_GetSPToExecute'
GO

insert into GXDBVersions values(2, 'CV_GetSPToExecute',  '00010001000000000000', 'CV_GetSPToExecute', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_GetDBNameFromBackupHeader.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_GetDBNameFromBackupHeader.sp,v $ $Id: CV_GetDBNameFromBackupHeader.sp,v 1.3 2010/04/08 14:55:39 ylu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_GetDBNameFromBackupHeader <<<'

IF EXISTS (select * from sysobjects where name='CV_GetDBNameFromBackupHeader')
	drop procedure CV_GetDBNameFromBackupHeader
IF EXISTS (select * from GxQscripts where name='CV_GetDBNameFromBackupHeader')
	delete from GxQscripts where name = 'CV_GetDBNameFromBackupHeader'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetDBNameFromBackupHeader')
	delete from GXDBVersions where aliasname = 'CV_GetDBNameFromBackupHeader'
GO
print '... Creating Procedure: CV_GetDBNameFromBackupHeader'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_GetDBNameFromBackupHeader
  @dumpFilePath nvarchar(1024)
AS
  DECLARE @o_dbName nvarchar(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
declare @tblBackupHeader table (
    bname	nvarchar(128),
    bdes	nvarchar(128),
    bt		smallint,
    edt		datetime,
    comp	tinyint,
    pos		smallint,
    dt		tinyint,
    uname	nvarchar(128),
    sname	nvarchar(128),
    dbname	nvarchar(128),
    dbver	int,
    dbcdt	datetime,
    bkupsize	numeric(20,0),
    flsn		numeric(25,0),
    llsn		numeric(25,0),
    cplsn		numeric(25,0),
    dbbup		numeric(25,0),
    bupdt		datetime,
    bupfdt		datetime,
    so			smallint,
    cp			smallint,
    locid		int,
    cs			int,
    complev		tinyint,
    vid			int,
    svmaj		int,
    svmin		int,
    svb			int,
    mname		nvarchar(128),
    flags		int,
    bid			uniqueidentifier,
    rid			uniqueidentifier,
    coll		nvarchar(128),
    fguid		uniqueidentifier,
    hbld		bit,
    issnap		bit,
    isro		bit,
    issing		bit,
    hbcs		bit,
    isdam		bit,
    blc			bit,
    himd		bit,
    ifo			bit,
    isco		bit,
    frfid		uniqueidentifier,
    fplns		numeric(25,0),
    recmodel	nvarchar(60),
    dblsn		numeric(25,0),
    dbguid		uniqueidentifier,
    btd			nvarchar(60),
    bsguid		uniqueidentifier,
    compressedBkpSize bigint
)
DECLARE @sqlQuery	nvarchar(max)
IF (@dumpFilePath IS NOT null)
BEGIN
SET	@sqlQuery = 'restore headeronly from disk = ''' + @dumpFilePath + ''''
END
insert @tblBackupHeader
EXEC sp_executesql @sqlQuery
select distinct dbname from @tblBackupHeader
GO

IF EXISTS (select * from GxQscripts where name = 'CV_GetDBNameFromBackupHeader')
	delete from GxQscripts where name = 'CV_GetDBNameFromBackupHeader'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetDBNameFromBackupHeader')
	delete from GXDBVersions where aliasname = 'CV_GetDBNameFromBackupHeader'
GO

insert into GXDBVersions values(2, 'CV_GetDBNameFromBackupHeader',  '00010003000000000000', 'CV_GetDBNameFromBackupHeader', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_GetSqlVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_GetSqlVersion.sp,v $ $Id: CV_GetSqlVersion.sp,v 1.2 2012/11/14 05:28:19 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_GetSqlVersion <<<'

IF EXISTS (select * from sysobjects where name='CV_GetSqlVersion')
	drop procedure CV_GetSqlVersion
IF EXISTS (select * from GxQscripts where name='CV_GetSqlVersion')
	delete from GxQscripts where name = 'CV_GetSqlVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSqlVersion')
	delete from GXDBVersions where aliasname = 'CV_GetSqlVersion'
GO
print '... Creating Procedure: CV_GetSqlVersion'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_GetSqlVersion
AS
  DECLARE @o_version integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
    DECLARE @sql_Version nvarchar(228)
    DECLARE @sql_Version_Constant nvarchar(128)
    set         @sql_Version_Constant = N'Microsoft SQL Server'
    set         @sql_Version = (select @@version);
    select SUBSTRING(@sql_Version,len(@sql_Version_Constant)+2,4)
GO

IF EXISTS (select * from GxQscripts where name = 'CV_GetSqlVersion')
	delete from GxQscripts where name = 'CV_GetSqlVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSqlVersion')
	delete from GXDBVersions where aliasname = 'CV_GetSqlVersion'
GO

insert into GXDBVersions values(2, 'CV_GetSqlVersion',  '00010002000000000000', 'CV_GetSqlVersion', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_GetSpParams.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_GetSpParams.sp,v $ $Id: CV_GetSpParams.sp,v 1.2 2010/03/17 15:29:00 ylu Exp $";
--  +========================================================================+
--  | Stored Precedure: CV_GetSpParams()
--  | Description:  Return list of parameters and their data type for sp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_GetSpParams <<<'

IF EXISTS (select * from sysobjects where name='CV_GetSpParams')
	drop procedure CV_GetSpParams
IF EXISTS (select * from GxQscripts where name='CV_GetSpParams')
	delete from GxQscripts where name = 'CV_GetSpParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSpParams')
	delete from GXDBVersions where aliasname = 'CV_GetSpParams'
GO
print '... Creating Procedure: CV_GetSpParams'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_GetSpParams
  @i_sp_name VARCHAR(1024)
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ParamTbl TABLE (Parameter VARCHAR(64), Type VARCHAR(128))
	INSERT INTO @ParamTbl
    SELECT
        [Param] = COALESCE(PARAMETER_NAME, '<no params>'),
        [DataType] = COALESCE(UPPER(DATA_TYPE) + CASE
            WHEN DATA_TYPE IN ('NUMERIC', 'DECIMAL') THEN
                '(' + CAST(NUMERIC_PRECISION AS VARCHAR)
                + ', ' + CAST(NUMERIC_SCALE AS VARCHAR) + ')'
            WHEN RIGHT(DATA_TYPE, 4) = 'CHAR' THEN (CASE WHEN CHARACTER_MAXIMUM_LENGTH = -1 THEN '(MAX)' ELSE
                '(' + CAST(CHARACTER_MAXIMUM_LENGTH AS VARCHAR) + ')' END)
            ELSE '' END + CASE PARAMETER_MODE
            WHEN 'INOUT' THEN ' OUTPUT' ELSE ' ' END, '-')
    FROM INFORMATION_SCHEMA.PARAMETERS
    WHERE SPECIFIC_NAME = @i_sp_name
    ORDER BY ORDINAL_POSITION
    SELECT * FROM @ParamTbl
GO

IF EXISTS (select * from GxQscripts where name = 'CV_GetSpParams')
	delete from GxQscripts where name = 'CV_GetSpParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSpParams')
	delete from GXDBVersions where aliasname = 'CV_GetSpParams'
GO

insert into GXDBVersions values(2, 'CV_GetSpParams',  '00010002000000000000', 'CV_GetSpParams', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetQscriptInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetQscriptInfo.sp,v $ $Id: QS_GetQscriptInfo.sp,v 1.5 2010/05/04 20:48:39 ylu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetQscriptInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetQscriptInfo')
	drop procedure QS_GetQscriptInfo
IF EXISTS (select * from GxQscripts where name='QS_GetQscriptInfo')
	delete from GxQscripts where name = 'QS_GetQscriptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptInfo')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptInfo'
GO
print '... Creating Procedure: QS_GetQscriptInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetQscriptInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_name varchar(1024)=''
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @tblQscriptList TABLE
	(
		QscriptName varchar(64),
		AuditLevel	int,
		TimeCreated	datetime,
		TimeExpires	datetime
	)
	INSERT INTO @tblQscriptList
	SELECT name, auditLevel, timeCreated, timeExpires
	FROM GxQscripts
	WHERE  name not like '%_CVupdate_%'
	AND   ( @i_name = '' OR
			name like @i_name OR
			name like 'QS_' + @i_name )
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: Qscript not found!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	SELECT * FROM @tblQscriptList
	ORDER BY QscriptName, TimeCreated desc
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetQscriptInfo')
	delete from GxQscripts where name = 'QS_GetQscriptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptInfo')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptInfo'
GO

insert into GXDBVersions values(2, 'QS_GetQscriptInfo',  '00010005000000000000', 'QS_GetQscriptInfo', '00010005000000000000')
GO

insert into GxQscripts values(2,'QS_GetQscriptInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getQscriptInfo -si @i_name=''script_name''
'
 + CHAR(10) + '	qoperation execscript -sn getQscriptInfo -si ''script_name''
'
 + CHAR(10) + '-- 	script_name: Full script name or name with wild card ''%''. If no name is inputed, then all scripts will be returned.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetQscriptExec.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetQscriptExec.sp,v $ $Id: QS_GetQscriptExec.sp,v 1.5 2010/05/04 20:46:04 ylu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetQscriptExec <<<'

IF EXISTS (select * from sysobjects where name='QS_GetQscriptExec')
	drop procedure QS_GetQscriptExec
IF EXISTS (select * from GxQscripts where name='QS_GetQscriptExec')
	delete from GxQscripts where name = 'QS_GetQscriptExec'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptExec')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptExec'
GO
print '... Creating Procedure: QS_GetQscriptExec'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetQscriptExec
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_name varchar(1024)='',
  @i_from varchar(1024)='',
  @i_to varchar(1024)='',
  @i_status int = 0
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	IF @i_status not in (0, 1, 2)
	BEGIN
		SET @localErrorMsg = 'Error: Invalid status!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	DECLARE @tblQscriptList TABLE
	(
		QscriptName varchar(64),
		TimeStart	datetime,
		TimeEnd		datetime,
		Status		int,
		InputParams	varchar(max)
	)
	INSERT INTO @tblQscriptList
	SELECT 	name, timeStart, timeEnd, status, inputParams
	FROM GxQscriptExec
	WHERE (name = @i_name OR name = 'QS_' + @i_name)
	AND (@i_status = 0 OR status = @i_status)
	AND (@i_from = '' OR timeStart > @i_from) AND (@i_to = '' OR timeEnd < @i_to)
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: No execution record found!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	SELECT * FROM @tblQscriptList
	ORDER BY QscriptName, TimeStart desc
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetQscriptExec')
	delete from GxQscripts where name = 'QS_GetQscriptExec'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptExec')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptExec'
GO

insert into GXDBVersions values(2, 'QS_GetQscriptExec',  '00010005000000000000', 'QS_GetQscriptExec', '00010005000000000000')
GO

insert into GxQscripts values(2,'QS_GetQscriptExec',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getQscriptExec -si @i_name=''script_name'' -si @i_from=''from_time'' -si @i_to=''to_time'' -si @i_status=''exec_status''
'
 + CHAR(10) + '	qoperation execscript -sn getQscriptExec -si ''script_name'' -si ''from_time'' -si ''to_time'' -si ''exec_status''
'
 + CHAR(10) + '-- 	script_name: full script name.'
 + CHAR(10) + '-- 	from_time: SQL datetime. For example ''01/01/2010''. Ignored if not given.'
 + CHAR(10) + '-- 	to_time: SQL datetime. For example ''06/01/2010''. Ignored if not given.'
 + CHAR(10) + '-- 	exec_status: 1 for successful execution, 2 for failed execution. 0 for all status.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetClientGroup.sp,v $ $Id: QS_SetClientGroup.sp,v 1.7 2014/06/19 12:27:15 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientGroup')
	drop procedure QS_SetClientGroup
IF EXISTS (select * from GxQscripts where name='QS_SetClientGroup')
	delete from GxQscripts where name = 'QS_SetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroup'
GO
print '... Creating Procedure: QS_SetClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @clientNames nvarchar(MAX),
  @groupName nvarchar(1024),
  @option nvarchar(100)='ADD'
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'SetClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @optAdd	varchar(32)
	SET		@optAdd	= 'ADD'
	DECLARE @optRem	varchar(32)
	SET		@optRem	= 'REM'
	DECLARE @now				integer
	DECLARE @userId				integer
	DECLARE @clientlist nvarchar(max)
	DECLARE @sql nvarchar(max)
	DECLARE @fwMessage nvarchar(512)
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1
-----------------------invalid parameters------------------------------
BEGIN TRY
	DECLARE @flag as INT = 0
	DECLARE @clientGroupId integer
	SET @clientGroupId = ISNULL((SELECT id FROM app_clientgroup WHERE name like @groupName), 0)
	IF LEN(@clientNames) <= 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Names cannot be empty.'
		GOTO ARGS_ERROR
	END
	IF @clientGRoupId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] does not exist.'
		GOTO ARGS_ERROR
	END
	SET @flag = (SELECT flag from APP_ClientGroup WHERE id = @clientGroupId)
	IF ( (@flag & 0x0100) <> 0 OR (@flag & 0x0200) <> 0)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] has EDC clients associated, hence can not change association'
		GOTO ARGS_ERROR
	END
	IF ((@flag & 0x1000) <> 0)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] is a smart client group, hence can not change association'
		GOTO ARGS_ERROR
	END
	SET @clientlist = ''''+REPLACE(@clientNames,',',''',''')+''''
	SET @sql = 'select client.id,0 from APP_Client client where client.name in('+@clientlist+')'
BEGIN TRAN
	CREATE TABLE #tmptable1
	(
		clientid integer,
		cgGroup integer
	)
	INSERT INTO #tmptable1
		EXECUTE  sp_executesql @sql
	UPDATE #tmptable1 SET cgGroup = @clientGroupId
	CREATE TABLE #tmpTable2
	(
		id integer,
		clientName nvarchar(1024)
	)
	INSERT INTO #tmpTable2
		SELECT * FROM dbo.SplitString(@clientNames,',')
	DECLARE @nameNotAdded nvarchar(max)
	SET @nameNotAdded = ''
	SELECT @nameNotAdded = @nameNotAdded+clientName+',' FROM #tmptable2 WHERE clientName NOT IN
		(SELECT name FROM APP_Client WHERE id in(SELECT clientid FROM #tmptable1))
	IF @option = @optAdd
	BEGIN
			INSERT INTO APP_ClientGroupAssoc(clientGroupId,clientId)
				SELECT DISTINCT cgGroup,clientid FROM #tmptable1 WHERE clientid NOT IN
					(SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId )
	END
	ELSE IF @option = @optRem
	BEGIN
			DELETE FROM APP_ClientGroupAssoc WHERE clientId IN (SELECT clientid FROM #tmptable1) and clientGroupId = @clientGroupId
	END
	IF EXISTS( select * from APP_Firewall where ( forClientGroupId=@clientGroupId and forClientId=0)
						 or (clientGroupId= @clientGroupId and clientId =0 ))
	   OR EXISTS(select * from APP_FirewallOptions where clientGroupId = @clientGroupId)
		SET @fwMessage = 'Info: Client Group :['+ @groupName  + '] has firewall setting set.Please push the firewall configuration on to successfully added/removed clients to reflect the firewall configuration.'
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
 TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
	PRINT ''
	PRINT @scriptName + 'completed at '
					+ Convert(varchar(60), getdate())+' with parameters client Name ['
					+ @clientNames + '] client group Name ['
					+ @groupName + '] option ['
					+ @option + ']. ErrorCode ('+
					+ Convert(varchar(2),@lastError) +').'
	IF(LEN(@nameNotAdded) > 0)
	BEGIN
		PRINT 'Clients not added/removed['+@nameNotAdded+']'
	END
	IF (LEN(@fwMessage) > 0)
	BEGIN
		PRINT ''
		PRINT @fwMessage
	END
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientGroup')
	delete from GxQscripts where name = 'QS_SetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroup'
GO

insert into GXDBVersions values(2, 'QS_SetClientGroup',  '00010007000000000000', 'QS_SetClientGroup', '00010007000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientGroup -si @clientNames=''client_name1,client_name2,client_name3'' -si @groupName=''group_name'' -si @option=''ADD/REM''
'
 + CHAR(10) + '	qoperation execscript -sn SetClientGroup -si ''client_name'' -si ''group_name'' -si ''REM''
'
 + CHAR(10) + '-- 	script_name: SetClientGroup.'
 + CHAR(10) + '-- 	exec_status: 1 for successful execution, 2 for failed execution. 0 for all status.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateClientGroup.sp,v $ $Id: QS_CreateClientGroup.sp,v 1.5 2014/06/19 12:27:15 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateClientGroup')
	drop procedure QS_CreateClientGroup
IF EXISTS (select * from GxQscripts where name='QS_CreateClientGroup')
	delete from GxQscripts where name = 'QS_CreateClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateClientGroup')
	delete from GXDBVersions where aliasname = 'QS_CreateClientGroup'
GO
print '... Creating Procedure: QS_CreateClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @groupName nvarchar(1024),
  @groupDescription nvarchar(1024)=''
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'CreateClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @now				integer
	DECLARE @userId				integer
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1
BEGIN TRY
BEGIN TRAN
	IF EXISTS(SELECT * FROM APP_ClientGroup WHERE name=@groupName )
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Group name ['+CAST(@groupName AS VARCHAR(10))+'] already exists.'
		GOTO TRANS_EXIT
	END
	ELSE IF (LEN(@groupName)>100)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. ClientGroup name cannot be more than '+ CAST (100 AS VARCHAR(3)) + ' characters.'
		GOTO TRANS_EXIT
	END
	INSERT INTO APP_ClientGroup VALUES (@groupName, @groupDescription, 0, 0, @userId, @now, @now, '', 2, NEWID())
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
			 + Convert(varchar(60), getdate())
			 + ' with Parameters: ['+@groupName+', '+@groupDescription+
			 + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateClientGroup')
	delete from GxQscripts where name = 'QS_CreateClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateClientGroup')
	delete from GXDBVersions where aliasname = 'QS_CreateClientGroup'
GO

insert into GXDBVersions values(2, 'QS_CreateClientGroup',  '00010005000000000000', 'QS_CreateClientGroup', '00010005000000000000')
GO

insert into GxQscripts values(2,'QS_CreateClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateClientGroup -si @groupName=''group_name'' -si @groupDescription=''group_description''
'
 + CHAR(10) + '	qoperation execscript -sn CreateClientGroup -si ''group_name'' -si ''group_description''
'
 + CHAR(10) + '-- 	script_name: CreateClientGroup.'
 + CHAR(10) + '-- 	exec_status: 1 for successful execution, 2 for failed execution. 0 for all status.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteClientGroup.sp,v $ $Id: QS_DeleteClientGroup.sp,v 1.5 2014/10/20 17:21:40 jswaminathan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteClientGroup')
	drop procedure QS_DeleteClientGroup
IF EXISTS (select * from GxQscripts where name='QS_DeleteClientGroup')
	delete from GxQscripts where name = 'QS_DeleteClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteClientGroup')
	delete from GXDBVersions where aliasname = 'QS_DeleteClientGroup'
GO
print '... Creating Procedure: QS_DeleteClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @groupName nvarchar(1024)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'DeleteClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @now				integer
	DECLARE @userId				integer
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1	-- Until we find a way to fetch from Qcommand!
-----------------------validate parameters------------------------------
	DECLARE @clientGroupId integer
	SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name like @groupName), 0)
	IF @clientGRoupId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] does not exist.'
		GOTO PROC_ERROR
	END
------------------------Check EDC clients associated with Client Group------------------------
	DECLARE @flag as INT = 0
	SET @flag = (SELECT flag from APP_ClientGroup WHERE id = @clientGroupId)
	IF ( (@flag & 0x0100) <> 0 OR (@flag & 0x0200) <> 0)
	BEGIN
		SET @lastError = 1;
		SET @localErrorMsg = 'Error. EDC clients associated with Client Group ['+ @groupName +'] please use GUI to delete client group.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
	------------------------delete all associated schedules------------------------
	delete FROM TM_AssocEntity WHERE clientGroupId = @clientGroupId
	------------------------remove NetworkThrottle Entries------------------------
	delete FROM APP_NetworkThrottle WHERE clientGroupId = @clientGroupId OR forClientGroupId = @clientGroupId
	delete FROM APP_NetworkThrottleOptions WHERE clientGroupId = @clientGroupId
	------------------------Remove the entries from firewall tables------------------------
	delete FROM APP_Firewall WHERE clientGroupId = @clientGroupId OR forClientGroupId = @clientGroupId
	delete FROM APP_FirewallOptions WHERE clientGroupId = @clientGroupId
	delete FROM App_FWOutGoingRoutes WHERE clientGroupId = @clientGroupId OR forClientGroupId = @clientGroupId
	delete FROM APP_FWPortRange WHERE clientGroupId = @clientGroupId
	------------------------remove Security Entries------------------------
	delete FROM UMGroupAssociation WHERE type1 = 2572 AND id1 = @clientGroupId
	EXEC sec_deleteSecurityAssociationsForEntity 28, @clientGroupId
	------------------------remove Activity Control Entries------------------------
	delete FROM JMJobAction WHERE clientGroupId = @clientGroupId AND clientId = 1 AND appType = 0 AND mediaAgentID = 1
	------------------------remove SQL Authentication Entries------------------------
	delete FROM APP_ComponentProp WHERE componentType = 8 AND componentId = @clientGroupId
	------------------------remove clients from client group------------------------
	delete APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId
	------------------------remove client group----------------------------
	delete APP_ClientGroup WHERE id = @clientGroupId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto PROC_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + 'completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'client group Name ['+ @groupName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteClientGroup')
	delete from GxQscripts where name = 'QS_DeleteClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteClientGroup')
	delete from GXDBVersions where aliasname = 'QS_DeleteClientGroup'
GO

insert into GXDBVersions values(2, 'QS_DeleteClientGroup',  '00010005000000000000', 'QS_DeleteClientGroup', '00010005000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DeleteClientGroup -si ''group_name''
'
 + CHAR(10) + '	script_name: DeleteClientGroup.
'
 + CHAR(10) + '	group_name - name of the group to be deleted
'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateDB2Backupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateDB2BackupSet.sp,v $ $Id: QS_CreateDB2BackupSet.sp,v 1.3 2011/08/26 13:03:34 jswaminathan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateDB2BackupSet <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateDB2BackupSet')
	drop procedure QS_CreateDB2BackupSet
IF EXISTS (select * from GxQscripts where name='QS_CreateDB2BackupSet')
	delete from GxQscripts where name = 'QS_CreateDB2BackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2BackupSet')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2BackupSet'
GO
print '... Creating Procedure: QS_CreateDB2BackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateDB2BackupSet
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = ''
AS
SET NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @clientname varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @logSP varchar(1024)
DECLARE @backupsetName varchar(1024)
SET @clientname = @PARAM1
SET @instancename = @PARAM2
SET @logSP = @PARAM3
SET @backupsetName = @PARAM4
     -------------------------------
      --SET @clientname = 'bingo'
      --SET @instancename = '%s'
      --select @clientname, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
     DECLARE @scriptName nvarchar(128)
     SET @scriptName = 'CreateDB2BackupSet'
     DECLARE @db2user nvarchar(128)
     SET @db2user = ''
     DECLARE @db2password nvarchar(128)
     SET @db2password = ''
     DECLARE @nowTime integer
     SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
     DECLARE @DB2Apptype varchar(128)
     SET @DB2Apptype = '62'
     DECLARE @defArchGrpId integer
     SET @defArchGrpId = 1
     DECLARE @logArchGrpId integer
     SET @logArchGrpId = 1
     DECLARE @cmdArchGrpId integer
     SET @cmdArchGrpId = 1
     DECLARE @instStatus integer
     SET @instStatus = 0
     DECLARE @instanceId integer
     SET @instanceId = 0
     ---------------------parameter 1 - clientname name--------------------------------------------
     IF @clientname = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. clientname Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @clientname), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@clientname+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @DB2Apptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@clientname+'] does not have DB2 iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters for ---------------
     SET @instanceId =   ISNULL((SELECT distinct I.id
							from  APP_Application APP INNER JOIN  APP_InstanceName I
							ON APP.instance = I.id
							where APP.clientId = @clientId
							and APP.appTypeId = @DB2Apptype
							and I.name = @instanceName),0)
	IF (@instanceId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Instance ['+@instanceName+'] not found in client ['+@clientname+'] , apptype [' + @DB2Apptype + '], instanceName [' +  @instanceName +'].'
     	GOTO ERROR_EXIT
     END
	IF @logSP = @noParameter OR
    	@backupsetName = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create backupset. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     	END
     IF LEN(@backupsetName)>100
     BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Backupset name cannot be more than ' + CAST (100 AS VARCHAR(3)) + ' characters.'
		GOTO ERROR_EXIT
	 END
     IF EXISTS (SELECT * FROM APP_backupSetName I INNER JOIN APP_Application A ON I.id = A.backupSet
     		WHERE I.name = @backupSetName AND A.clientid = @clientId AND A.apptypeid = @DB2Apptype and A.instance = @instanceId)
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Backupset ['+@backupsetName+'] already exists in client ['+@clientname+'].'
     	GOTO ERROR_EXIT
     END
    SET @logArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @logSP), 0)
    SET @defArchGrpId = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName like 'DB2 Default Data SP' and componentNameId = @instanceId and modified = 0), 0)
    SET @cmdArchGrpId = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName like 'DB2 Default Command Line SP' and componentNameId = @instanceId and modified = 0), 0)
     IF @defArchGrpId = 0 OR
     	@logArchGrpId = 0 OR
     	@cmdArchGrpId = 0
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Invalid storage policy given.'
     	GOTO ERROR_EXIT
     END
     BEGIN TRAN
     --Create backupset
     INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES (@backupsetName, @nowTime, 0, 0)
     SET @errorCode = @@error
     IF @errorCode <> 0
     BEGIN
     	SET @errorString = 'Error. Error trying to create Backupset['+@backupsetName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @backupsetId integer
    SET @backupsetId = @@IDENTITY
    SET @db2user = ISNULL((SELECT attrVal from APP_InstanceProp where attrName = 'DB2 User Id' and componentNameId = @instanceId and modified = 0),0)
    SET @db2password = ISNULL((SELECT attrVal from APP_InstanceProp where attrName = 'DB2 Domain Password' and componentNameId = @instanceId and modified = 0),0)
    INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@backupsetId, 'DB2 Default Index SP', 7, @logArchGrpId, @nowTime ,0)
    INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@backupsetId, 'DB2 SQL Connect', 1, @db2user, @nowTime ,0)
    INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@backupsetId, 'DB2 SQL Connect Password', 1, @db2password, @nowTime ,0)
     --Create default SC
     INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @DB2Apptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, 'default', 8)
     SET @errorCode = @@error
    IF @errorCode <> 0
    BEGIN
     	SET @errorString = 'Error. Error trying to create default subclient for Backupset['+@backupsetName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @subclientId integer
    SET @subclientId = @@IDENTITY
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last data SP', 10, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last log SP', 10, 1, @nowTime ,0)
    INSERT INTO archPipeConfig(appNumber, compressWhere, numNWAgents, NWWriteSpeed)
	VALUES (@subclientId, 2, 2, 0)
     --Create commandline SC
    INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @DB2Apptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(command line)', 64)
    SET @errorCode = @@error
     IF @errorCode <> 0
     BEGIN
     	SET @errorString = 'Error. Error trying to create subclient for backupset['+@backupsetName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @cmdsubclientId integer
    SET @cmdsubclientId = @@IDENTITY
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'last data SP', 10, 1, @nowTime ,0)
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@cmdsubclientId, 'last log SP', 10, 1, @nowTime ,0)
     TRANS_EXIT:
     IF @errorCode <> 0
     	ROLLBACK TRAN
     ELSE
    	COMMIT TRAN
     --ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
     ERROR_EXIT:
     Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateDB2Backupset')
	delete from GxQscripts where name = 'QS_CreateDB2Backupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2Backupset')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2Backupset'
GO

insert into GXDBVersions values(2, 'QS_CreateDB2Backupset',  '00010003000000000000', 'QS_CreateDB2Backupset', '00010003000000000000')
GO

insert into GxQscripts values(2,'QS_CreateDB2Backupset',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateDB2BackupSet.sql -si cleintname -si instancename -si logstoragepolicy -si backupsetname
'
 + CHAR(10) + '-- 	script_name: CreateDb2BackupSet.'
 + CHAR(10) + '-- 	create DB2 backup set under the given client and instance name.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateDB2Subclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_CreateDB2Subclient.sp,v $ $Id: QS_CreateDB2Subclient.sp,v 1.4 2011/08/26 13:03:34 jswaminathan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateDB2Subclient <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateDB2Subclient')
	drop procedure QS_CreateDB2Subclient
IF EXISTS (select * from GxQscripts where name='QS_CreateDB2Subclient')
	delete from GxQscripts where name = 'QS_CreateDB2Subclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2Subclient')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2Subclient'
GO
print '... Creating Procedure: QS_CreateDB2Subclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CreateDB2Subclient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = '',
  @PARAM5 nvarchar(1024) = ''
AS
Set NOCOUNT ON
      -------------------INPUTS all mandatory----------------------------------
DECLARE @client varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @defSP varchar(1024)
DECLARE @backupsetName varchar(1024)
DECLARE @subclientName varchar(1024)
SET @client = @PARAM1
SET @instancename = @PARAM2
SET @defSP = @PARAM3
SET @backupsetName = @PARAM4
SET @subclientName = @PARAM5
     -------------------------------
      --select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'CreateDB2Subclient'
      DECLARE @db2user nvarchar(128)
      SET @db2user = ''
      DECLARE @db2password nvarchar(128)
      SET @db2password = ''
      DECLARE @nowTime integer
      SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
      DECLARE @DB2Apptype varchar(128)
      SET @DB2Apptype = '62'
      DECLARE @defArchGrpId integer
      SET @defArchGrpId = 1
      DECLARE @logArchGrpId integer
      SET @logArchGrpId = 1
      DECLARE @cmdArchGrpId integer
      SET @cmdArchGrpId = 1
      DECLARE @instStatus integer
      SET @instStatus = 0
      DECLARE @instanceId integer
      SET @instanceId = 0
      DECLARE @backupsetId integer
      SET @backupsetId = 0
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @DB2Apptype)
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have DB2 iDataAgent.'
     	GOTO ERROR_EXIT
     END
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters---------------
    SET @instanceId =   ISNULL((SELECT distinct I.id
							from  APP_Application APP INNER JOIN  APP_InstanceName I
							ON APP.instance = I.id
							where APP.clientId = @clientId
							and APP.appTypeId = @DB2Apptype
							and I.name = @instanceName),0)
	IF (@instanceId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Instance ['+@instanceName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '].'
     	GOTO ERROR_EXIT
     END
     IF @defSP = @noParameter OR
    	@backupsetName = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create subclient. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     END
     --get backupset id
    SET @backupsetId = ISNULL(( select distinct APP_BackupSetName.id
							from APP_BackupSetName, APP_Application, APP_Client, APP_InstanceName
							where APP_Application.clientId = APP_Client.id
							and APP_Application.appTypeId = @DB2Apptype
							and APP_Application.instance = APP_InstanceName.id
							and APP_BackupSetName.id = APP_Application.backupSet
							and APP_Client.name = @client
							and APP_InstanceName.name = @instanceName
							and APP_BackupSetName.name = @backupsetName), 0)
	IF (@backupsetId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Backupset ['+@backupsetName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '], instanceName [' +  @instanceName +'].'
     	GOTO ERROR_EXIT
     END
     IF LEN(@subclientName) > 100
     BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Subclientname cannot be more than ' + CAST(100 AS VARCHAR(3))+ ' characters.'
		GOTO ERROR_EXIT
	 END
    SET @defArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @defSP), 0)
    SET @logArchGrpId = ISNULL((SELECT attrVal FROM APP_BackupSetProp WHERE attrName like 'DB2 Default index SP' and componentNameId = @backupsetId and modified = 0), 0)
    SET @cmdArchGrpId = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName like 'DB2 Default Command Line SP' and componentNameId = @instanceId and modified = 0), 0)
     IF @defArchGrpId = 0 OR
     	@logArchGrpId = 0 OR
     	@cmdArchGrpId = 0
     BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Invalid storage policy given.'
     	GOTO ERROR_EXIT
     END
    BEGIN TRAN
    IF EXISTS (SELECT * FROM APP_Application A WHERE A.subclientName = @subclientName AND A.clientid = @clientId AND A.apptypeid = @DB2Apptype and A.instance = @instanceId and
		A.backupSet = @backupsetId and A.subclientStatus = 4)
    BEGIN
	update APP_Application
	SET subclientName = @subclientName + '_' + convert(varchar(1024),@nowTime) where subclientName = @subclientName 	AND clientid = @clientId AND apptypeid = @DB2Apptype and instance = @instanceId and
		backupSet = @backupsetId and subclientStatus = 4
    END
    IF EXISTS (SELECT * FROM APP_Application A WHERE A.subclientName = @subclientName AND A.clientid = @clientId AND                A.apptypeid = @DB2Apptype and A.instance = @instanceId and
		A.backupSet = @backupsetId )
    BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. subclient ['+@subclientName+'] already exists in client ['+@client+'].'
     	GOTO ERROR_EXIT
    END
     --Create  SC
     INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
     	VALUES(@clientId, @DB2Apptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, @subclientName, 0)
     SET @errorCode = @@error
    IF @errorCode <> 0
    BEGIN
     	SET @errorString = 'Error. Error tryint to create  subclient for instance['+@instanceName +'].'
     	GOTO TRANS_EXIT
     END
    DECLARE @subclientId integer
    SET @subclientId = @@IDENTITY
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Single Instancing Option', 7, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'Encrypt: encryption', 10, 2,@nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last data SP', 10, 1, @nowTime ,0)
    INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		   VALUES (@subclientId, 'last log SP', 10, 1, @nowTime ,0)
    INSERT INTO archPipeConfig(appNumber, compressWhere, numNWAgents, NWWriteSpeed)
				VALUES (@subclientId, 2, 2, 0)
     TRANS_EXIT:
     IF @errorCode <> 0
     	ROLLBACK TRAN
    ELSE
    	COMMIT TRAN
     --ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
     ERROR_EXIT:
    -- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateDB2Subclient')
	delete from GxQscripts where name = 'QS_CreateDB2Subclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateDB2Subclient')
	delete from GXDBVersions where aliasname = 'QS_CreateDB2Subclient'
GO

insert into GXDBVersions values(2, 'QS_CreateDB2Subclient',  '00010004000000000000', 'QS_CreateDB2Subclient', '00010004000000000000')
GO

insert into GxQscripts values(2,'QS_CreateDB2Subclient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateDB2SubClient.sql -si cleintname -si instancename -si storagepolicy -si backupsetname -si subclientName
'
 + CHAR(10) + '-- 	script_name: CreateDB2SubClient.'
 + CHAR(10) + '-- 	creates new DB2 subclient under the given client, instance name and backupset.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_mappingsForTapeImport.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_mappingsForTapeImport <<<'

IF EXISTS (select * from sysobjects where name='QS_mappingsForTapeImport')
	drop procedure QS_mappingsForTapeImport
IF EXISTS (select * from GxQscripts where name='QS_mappingsForTapeImport')
	delete from GxQscripts where name = 'QS_mappingsForTapeImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_mappingsForTapeImport')
	delete from GXDBVersions where aliasname = 'QS_mappingsForTapeImport'
GO
print '... Creating Procedure: QS_mappingsForTapeImport'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_mappingsForTapeImport
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_option VARCHAR(10)
 DECLARE @i_oldId INT
 DECLARE @i_newId INT
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'mappingsForTapeImport'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @entityType integer
BEGIN TRY
BEGIN TRAN
	IF(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter OR @PARAM3 = @NoParameter) --Requires option and both old and new ids
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_mappingsForTapeImport'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_option = @PARAM1
	SET @i_oldId = convert(INT, @PARAM2)
	SET @i_NewId = convert(INT, @PARAM3)
	IF NOT EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'TapeImport_Mappings')
		CREATE TABLE TapeImport_Mappings
		(
			old_Id 	INT,
			new_Id 	INT,
			entityType	INT,
			oldArchGroupId INT,
			allowReset INT,
			primary key(old_Id, entityType)
		)
	--------------------------------------------------------
	--Set allowReset to true if mapped new entity is deleted
	UPDATE TapeImport_Mappings
	SET allowReset = 1
	FROM TapeImport_Mappings a LEFT OUTER JOIN ArchGroupCopy b ON a.new_Id = b.id
	WHERE b.id IS NULL
		AND a.entityType = 18
		AND a.allowReset = 0
	UPDATE TapeImport_Mappings
	SET allowReset = 1
	FROM TapeImport_Mappings a LEFT OUTER JOIN APP_Application b ON a.new_Id = b.id
	WHERE b.id IS NULL
		AND a.entityType = 7
		AND a.allowReset = 0
	--------------------------------------------------------
	IF @i_option = 'SPCOPY'
	BEGIN
		--Validate old and new ids
		IF EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_oldId)
		BEGIN
			SET @localErrorMsg	=	'Error: Mapping is allowed for only deleted storage policy copies, given old copy [' + CONVERT(varchar, @i_oldId) + '] still exist'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF NOT EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_newId)
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid new storage policy copy [' + CONVERT(varchar, @i_newId) + ']'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_newId AND isSnapCopy = 1)
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid mapping, mapping to snap copy is not allowed'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF EXISTS(SELECT * FROM ArchGroupCopy WHERE id = @i_newId AND ((dedupeFlags & 262144) > 0 OR type = 5))
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid mapping, mapping to dedup\transitive copy is not allowed'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		--Check whether given new copy is already mapped with different old copy
		IF EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE old_Id <> @i_oldId AND new_Id = @i_newId AND entityType = 18)
		BEGIN
			SET @localErrorMsg	=	'Error: Mapping one storage policy copy with multiple storage policies is not allowed. '  + CHAR(13) + CHAR(10)
									+ 'Storage policy copy [' + CONVERT(varchar, @i_newId) + '] is already mapped with ['  + CHAR(13) + CHAR(10)
									+ (SELECT  CONVERT(varchar, old_Id) FROM TapeImport_Mappings WHERE new_Id = @i_newId AND entityType = 18)
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		SET @entityType = 18
	END
	ELSE IF @i_option = 'SUBCLIENT'
	BEGIN
		--Validate old and new ids
		IF EXISTS(SELECT 1 FROM APP_Application WHERE id = @i_oldId)
		BEGIN
			SET @localErrorMsg	=	'Error: Mapping is allowed for only deleted subclients, given old subclient  [' + CONVERT(varchar, @i_oldId) + '] still exist'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE id = @i_newId)
		BEGIN
			SET @localErrorMsg	=	'Error: Invalid new subclient id [' + CONVERT(varchar, @i_newId) + ']'
			SET	@lastError		=	1
			GOTO SCRIPT_EXIT
		END
		SET @entityType = 7
	END
	ELSE
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_mappingsForTapeImport'
		SET @localErrorMsg	=	'Error: Invalid option'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	--Insert mappings if not exist already, if exists and allowed to reset then update
	IF NOT EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE old_Id = @i_oldId AND entityType = @entityType)
	BEGIN
		INSERT INTO TapeImport_Mappings VALUES(@i_oldId, @i_newId, @entityType, 0, 1)
	END
	ELSE IF EXISTS(SELECT 1 FROM TapeImport_Mappings WHERE old_Id = @i_oldId AND entityType = @entityType AND allowReset = 0)
	BEGIN
		SET @localErrorMsg	=	'Error: Mapping already exist and resetting is not allowed'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	ELSE
	BEGIN
		UPDATE TapeImport_Mappings
		SET new_Id = @i_newId
		WHERE old_Id = @i_oldId AND entityType = @entityType
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successfully mapped old ' + @i_option + '[' + convert(VARCHAR, @i_oldId) + ']  with new ' + @i_option + '[' + convert(VARCHAR, @i_newId) + '].'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_mappingsForTapeImport')
	delete from GxQscripts where name = 'QS_mappingsForTapeImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_mappingsForTapeImport')
	delete from GXDBVersions where aliasname = 'QS_mappingsForTapeImport'
GO

insert into GXDBVersions values(2, 'QS_mappingsForTapeImport',  '00000000000000000000', 'QS_mappingsForTapeImport', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_mappingsForTapeImport',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn mappingsForTapeImport -si <OPTION> -si <old_Id> -si <new_Id>'
 + CHAR(10) + '-- 	OPTION - SPCOPY or SUBCLIENT'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConvertNextGRCExportAsFull.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ConvertNextGRCExportAsFull <<<'

IF EXISTS (select * from sysobjects where name='QS_ConvertNextGRCExportAsFull')
	drop procedure QS_ConvertNextGRCExportAsFull
IF EXISTS (select * from GxQscripts where name='QS_ConvertNextGRCExportAsFull')
	delete from GxQscripts where name = 'QS_ConvertNextGRCExportAsFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertNextGRCExportAsFull')
	delete from GXDBVersions where aliasname = 'QS_ConvertNextGRCExportAsFull'
GO
print '... Creating Procedure: QS_ConvertNextGRCExportAsFull'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ConvertNextGRCExportAsFull
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_ccName VARCHAR(1024)
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ConvertNextGRCExportAsFull'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @l_ccId integer
BEGIN TRY
BEGIN TRAN
	IF(@PARAM1 = @NoParameter) --Requires commcell name
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_ConvertNextGRCExportAsFull'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_ccName = @PARAM1
	--------------------------------------------------------
	--Validate commcell name
	SELECT @l_ccId = id FROM App_CommCell WHERE aliasName = @i_ccName
	IF ISNULL(@l_ccId, 0) = 0
	BEGIN
		SET @localErrorMsg	=	'Error: Invalid CommCell ['+ @i_ccName + ']'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	DELETE 	GRC_SubClientTrackingStats
	WHERE	commcellId = @l_ccId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'Error: Unknown')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		print 'Successfully converted next GRC Export job as full for CommCell [' + @i_ccName + '].'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConvertNextGRCExportAsFull')
	delete from GxQscripts where name = 'QS_ConvertNextGRCExportAsFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConvertNextGRCExportAsFull')
	delete from GXDBVersions where aliasname = 'QS_ConvertNextGRCExportAsFull'
GO

insert into GXDBVersions values(2, 'QS_ConvertNextGRCExportAsFull',  '00000000000000000000', 'QS_ConvertNextGRCExportAsFull', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConvertNextGRCExportAsFull',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn ConvertNextGRCExportAsFull -si <GRC CommCell Name>'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSubClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSubclients <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSubclients')
	drop procedure QS_GetSubclients
IF EXISTS (select * from GxQscripts where name='QS_GetSubclients')
	delete from GxQscripts where name = 'QS_GetSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclients')
	delete from GXDBVersions where aliasname = 'QS_GetSubclients'
GO
print '... Creating Procedure: QS_GetSubclients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSubclients
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
-----------------------------------------
--SET @clientName = 'oscar'
-----------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetSubclients'
DECLARE	@NoParameter			varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
---- Validate inputs   -----------
if(@clientName is NULL)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name [' + @clientName + '] could not be found.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
if(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--7.0 Get description from APP_Client clientDescription
--8.0 Get description from APP_SubclientProp
-------- Get subclients   -----------
SELECT APP.id, APP.subclientName, IDA.name as iDA, ISNULL(PROP.attrVal, '') as Description
FROM APP_Application APP
LEFT JOIN APP_Client CLI ON APP.clientId = CLI.id
LEFT JOIN APP_iDAType IDA ON APP.appTypeId=IDA.type
LEFT JOIN APP_SubclientProp PROP ON PROP.ComponentNameId = APP.id AND PROP.attrName = N'User Description'
WHERE APP.subclientStatus & 2 <> 2 and APP.subclientStatus & 4 <> 4 and APP.subclientStatus & 16 <> 16 and APP.subclientStatus & 32 <> 32
AND CLI.name = @clientName  AND APP.apptypeid <1000
--select * from app_application where clientid = @clientId
--CV_STATUS_UNINSTALLED		0x0002
--CV_STATUS_DELETED			0x0004
--CV_STATUS_DEFAULT			0x0008
--CV_STATUS_DUMMY			0x0010
--CV_STATUS_HIDDEN			0x0020
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSubClients')
	delete from GxQscripts where name = 'QS_GetSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubClients')
	delete from GXDBVersions where aliasname = 'QS_GetSubClients'
GO

insert into GXDBVersions values(2, 'QS_GetSubClients',  '00000000000000000000', 'QS_GetSubClients', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSubClients',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSubclients.sql -si client_name
'
 + CHAR(10) + '--   script_name : GetSubclients'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_Changedefaultbackupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ChangeDefaultBackupset <<<'

IF EXISTS (select * from sysobjects where name='QS_ChangeDefaultBackupset')
	drop procedure QS_ChangeDefaultBackupset
IF EXISTS (select * from GxQscripts where name='QS_ChangeDefaultBackupset')
	delete from GxQscripts where name = 'QS_ChangeDefaultBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeDefaultBackupset')
	delete from GXDBVersions where aliasname = 'QS_ChangeDefaultBackupset'
GO
print '... Creating Procedure: QS_ChangeDefaultBackupset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ChangeDefaultBackupset
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @idaName varchar(1024) = '%s',
  @instanceName varchar(1024) = '%s',
  @oldDefaultBS varchar(1024) = '%s',
  @newDefaultBS varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName	= '%s'
--DECLARE @idaName	varchar(1024)
--SET		@idaName	= '%s'
--DECLARE @instanceName	varchar(1024)
--SET		@instanceName	= '%s'
--DECLARE @oldDefaultBS	varchar(1024)
--SET		@oldDefaultBS	= '%s'
--DECLARE @newDefaultBS	varchar(1024)
--SET		@newDefaultBS	= '%s'
---------------------------------------
--test
--SET		@clientName = 'stlcvserv2'
--SET		@idaName = 'Virtual Server'
--SET		@instanceName = 'StlVcenter'
--SET		@newDefaultBS	= 'dontuse'
--SET		@oldDefaultBS	= 'defaultBackupSet'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ChangeDefaultBackupset'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
DECLARE @now				integer
DECLARE @userId				integer
SET @now = dbo.GetUnixTime(GETDATE())
SET @userId	 = 1
----------------------- check inputs -----------------
IF @clientName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @idaName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @oldDefaultBS	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Old default backup set name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @newDefaultBS	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. New default backup set name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @instanceName	= @NoParameter
BEGIN
	SET @instanceName = 'DefaultInstanceName'
END
--------------SETP 1 ---------------------
BEGIN TRY
BEGIN TRAN
	DECLARE @clientId	int
	DECLARE @appTypeId	int
	DECLARE @instanceId	int
	DECLARE @oldBSId	int
	DECLARE @newBSId	int
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name=@clientName), 0)
	IF @clientId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client name ['+CAST(@clientName AS VARCHAR(10))+'] does not exists.'
		GOTO TRANS_EXIT
	END
	SET @appTypeId = (SELECT appTypeId FROM APP_IdaName
								 WHERE clientid = @clientId
								 AND appTypeId IN (SELECT distinct type FROM APP_IDAType
												   WHERE displayName = @idaName))
	IF @appTypeId IS null
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. IDA name ['+CAST(@idaName AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	SET @instanceId = (SELECT id FROM APP_InstanceName
								WHERE name = @instanceName
								AND id IN (SELECT instance FROM APP_Application WHERE clientId=@clientId AND appTypeId=@appTypeId) )
	IF @instanceId IS null
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. IDA name ['+CAST(@instanceName AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'] and appType ['+CAST(@idaName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	SET @oldBSId = ISNULL((SELECT id FROM APP_Backupsetname WHERE id in (
							SELECT backupset FROM APP_Application WHERE clientId=@clientId and appTypeId=@appTypeId and instance=@instanceId) AND
								name = @oldDefaultBS), 0)
	IF @oldBSId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. BackupSet name1 ['+CAST(@oldDefaultBS AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'] and appType ['+CAST(@idaName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	SET @newBSId = ISNULL((SELECT id FROM APP_Backupsetname WHERE id in (
							SELECT backupset FROM APP_Application WHERE clientId=@clientId and appTypeId=@appTypeId and instance=@instanceId) AND
								name = @newDefaultBS), 0)
	IF @newBSId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. BackupSet name2 ['+CAST(@newDefaultBS AS VARCHAR(10))+'] not found for client ['+CAST(@clientName AS VARCHAR(100))+'] and appType ['+CAST(@idaName AS VARCHAR(100))+'].'
		GOTO TRANS_EXIT
	END
	--REMOVE DEFAULT BACKUP SET
	UPDATE APP_BackupSetName SET status=status&~8 WHERE id=@oldBSId
	--SET NEW DEFAULT BACKUP SET
	UPDATE APP_BackupSetName SET status=status|8 WHERE id=@newBSId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName+', '+@idaName+
		 + @instanceName+', '+@oldDefaultBS+', '+@newDefaultBS+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_Changedefaultbackupset')
	delete from GxQscripts where name = 'QS_Changedefaultbackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_Changedefaultbackupset')
	delete from GXDBVersions where aliasname = 'QS_Changedefaultbackupset'
GO

insert into GXDBVersions values(2, 'QS_Changedefaultbackupset',  '00000000000000000000', 'QS_Changedefaultbackupset', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_Changedefaultbackupset',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript sn ChangeDefaultBackupSet.sql -si client name -si IDA Name -si Instance Name -si current default backupset -si new default backupset
'
 + CHAR(10) + '	Qoperation execscript sn ChangeDefaultBackupSet.sql -si myClient -si Oracle -si myInstance -si oldbackupset -si newbackupset
'
 + CHAR(10) + '--   script_name : Changedefaultbackupset'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeMediaType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_changeMediatype <<<'

IF EXISTS (select * from sysobjects where name='QS_changeMediatype')
	drop procedure QS_changeMediatype
IF EXISTS (select * from GxQscripts where name='QS_changeMediatype')
	delete from GxQscripts where name = 'QS_changeMediatype'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_changeMediatype')
	delete from GXDBVersions where aliasname = 'QS_changeMediatype'
GO
print '... Creating Procedure: QS_changeMediatype'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_changeMediatype
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 VARCHAR(1024)='%s',
  @PARAM2 VARCHAR(1024)='%s',
  @PARAM3 VARCHAR(1024)='%s',
  @PARAM4 VARCHAR(1024)='%s',
  @PARAM5 VARCHAR(1024)='%s'
AS
SET nocount ON
--------------------------------------------
---------- COMMANDLINE PARAMETERS ----------
--------------------------------------------
 --DECLARE @PARAM1 varchar(1024)
 --SET @PARAM1 ='%s'
 --DECLARE @PARAM2 varchar(1024)
 --SET @PARAM2 ='%s'
 --DECLARE @PARAM3 varchar(1024)
 --SET @PARAM3 ='%s'
 --DECLARE @PARAM4 varchar(1024)
 --SET @PARAM4 = '%s'
 --DECLARE @PARAM5 varchar(1024)
 --SET @PARAM5 = '%s'
/*
-- @Test remove comments
--  SET @PARAM1 = 'inlibraryandexportedgui'--'media' --'ListMediaTypes'--'inlibraryandexported''ListMediaTypes'
 -- SET @PARAM2 = 'HGB_SL500_Shared' --'SH_HP_MSL6030_Library' --'ECX477L1'--'KK1367L2'
 -- SET @PARAM3 = 'ULTRIUM V2'
--SET @PARAM4 = 'restrictbysuffix'
--SET @PARAM5 = 'L3'
*/
/* locale variables */
DECLARE @LibararyName NVARCHAR(128) --= 'EGDCLIB1'-- 'WICHLIB3'
DECLARE @LibraryId INTEGER
DECLARE @MediaType NVARCHAR(128)
DECLARE @MediaTypeId INTEGER
DECLARE @RecFormatId INTEGER
DECLARE @optionType VARCHAR(128)
DECLARE @Barcode NVARCHAR(128)
DECLARE @spareGrpId INTEGER
DECLARE @suffix VARCHAR(128)
DECLARE @useBarCodeForMtyp VARCHAR(128)
DECLARE @mediaCapacity		BIGINT
DECLARE @changeMediaTypeList TABLE
								(
										MediaId				INTEGER,
										SpareGroupType		INTEGER,
										oldSpareGroupId		INTEGER,
										origSpareGroupId	INTEGER,
										libraryId			INTEGER
								)
BEGIN TRANSACTION
-- we need at least two parameters
IF(@PARAM1 = '%s' OR @PARAM2 = '%s' )
BEGIN
		print 'Error: Insufficient command line parameters'
		print 'Please refer to the readme file and retry with necessary parameters'
		GOTO SCRIPT_EXIT
END
SET @optionType = @PARAM1
IF( @optionType NOT IN ('ListMediaTypes','media','inlibraryandexported','inlibrary','inlibraryandexportedgui'))
BEGIN
		print 'Error: Wrong option type '
		GOTO SCRIPT_EXIT
END
IF (@optionType = 'media')
BEGIN
		SET @Barcode = @PARAM2
END
ELSE
BEGIN
	SET @LibararyName = @PARAM2
	IF(ISNULL((SELECT COUNT(*) FROM MMLibrary WHERE AliasName = @LibararyName),0) = 0 )
	BEGIN
				print 'Error: Library does not exist'
				GOTO SCRIPT_EXIT
	END
	ELSE
				SELECT @libraryId = LibraryId FROM MMLibrary WHERE AliasName = @LibararyName
END
IF (@optionType = 'ListMediaTypes')
BEGIN
	SELECT DISTINCT MDT.MediaTypeName
	FROM MMRecFmtMedtyp MMR
	INNER JOIN MMDrive 	MDR ON MDR.driveTypeId = MMR.driveTypeId
	INNER JOIN MMMasterPool MMP ON MMP.masterPoolID = MDR.masterPoolID  AND MMP.LibraryId = @LibraryId
	INNER JOIN MMMediatype	MDT	ON MMR.MediaTypeId = MDT.MediaTypeId AND MDT.IsCleaningMedia <> 1
	GOTO EXIT_OK
END
IF(@PARAM3 = '%s' )
BEGIN
	print 'Error: Insufficient command line parameters'
	print 'Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
SET @MediaType = @PARAM3
IF(ISNULL((SELECT COUNT(*) FROM MMMediaType MDT WHERE MDT.MediaTypeName = @MediaType),0) = 0)
BEGIN
			print 'Error: Wrong Media Type'
			GOTO SCRIPT_EXIT
END
ELSE
	SELECT @mediaTypeId = MDT.MediaTypeId FROM MMMediaType MDT WHERE MDT.MediaTypeName = @MediaType
IF(@optionType = 'media')
 BEGIN
		IF EXISTS(SELECT MediaId FROM MMMedia MD WHERE MD.BarCode =  @Barcode)
		BEGIN
			INSERT @changeMediaTypeList (
										MediaId,
										SpareGroupType,
										oldSpareGroupId,
										origSpareGroupId,
										libraryId
										)
			SELECT MD.MediaId,MSP.SpareGroupType,MD.SpareGroupId,MD.origSpareGroupId,MD.LibraryId
				FROM MMMedia MD,MMSpareGroup MSP WHERE MD.BarCode =  @Barcode
													AND MSP.SpareGroupId = MD.SpareGroupId
			SELECT @LibraryId = LibraryId  FROM MMMedia MD WHERE MD.BarCode =  @Barcode
		END
		ELSE
		BEGIN
			print 'Error: Barcode does not exist'
			GOTO SCRIPT_EXIT
		END
 END
ELSE
 BEGIN
	SET @useBarCodeForMtyp = @PARAM4
	IF(@PARAM4 = 'restrictbysuffix')
	BEGIN
		SET @suffix = @PARAM5
		IF(@suffix = '%s' OR @suffix = '' )
		BEGIN
			print 'Error: Invalid suffix '
		END
	END
	INSERT @changeMediaTypeList	(
										MediaId,
										SpareGroupType,
										oldSpareGroupId,
										origSpareGroupId,
										libraryId
									)
    SELECT MD.MediaId,MSG.SpareGroupType,MD.SpareGroupId,MD.origSpareGroupId,MD.LibraryId
            FROM MMMedia MD INNER JOIN MMSpareGroup MSG ON MSG.SpareGroupId = MD.SpareGroupId
                         AND MSG.SpareGroupType <> 32 --Cleaning media
                         AND (
								(
								MD.LibraryId = @LibraryId
								AND (
										@optionType IN ('inlibraryandexported', 'inlibraryandexportedgui')
									  OR MD.MediaLocation <> 3
									)
                                )
								OR  (
										@optionType = 'inlibraryandexportedgui'
										AND MD.MediaLocation = 3
										AND LastWriteLibraryId = @libraryId
									)
								OR (
										@optionType = 'inlibraryandexportedgui'
										AND MD.MediaLocation = 3
										AND MD.SparegroupId IN
										( SELECT MSP.SpareGroupId FROM MMSpareGroup MSP WHERE MSP.LibraryId = @libraryId )
									)
							)
                        AND(
								@useBarCodeForMtyp <> 'restrictbysuffix'
                                OR  RIGHT(MD.BarCode,LEN(@suffix))= @suffix
                            )
END
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Script failed to run '
	GOTO SCRIPT_EXIT
END
-- now bein updating the media.
UPDATE MMMedia
	SET MMMedia.MediaTypeId = @MediaTypeId --change media type
FROM @changeMediaTypeList CMT
WHERE CMT.MediaId = MMMedia.MediaId
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Failed to update MMMedia table'
	GOTO SCRIPT_EXIT
END
-- Update media capcity MR#80734.
SELECT
	@mediaCapacity = MaxUncompressCapacityMB
FROM MMMediaType
where MediaTypeId = @MediaTypeId
-- Update Totalsize MMMediaSide
UPDATE MMMediaSide
	SET TotalSpaceMB = @mediaCapacity
FROM MMMediaSide MSD
INNER JOIN @changeMediaTypeList ML ON MSD.MediaId = ML.MediaId
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Failed to update MMMediaSide table'
	GOTO SCRIPT_EXIT
END
-- now update the sparegroup type
UPDATE MMMedia
SET MMMedia.SpareGroupId =
(
	SELECT TOP 1 IMSP.SpareGroupId
	FROM
		-- IMSP specifies the target sparegroup
		MMSpareGroup IMSP
	WHERE
		-- library has to match
		IMSP.LibraryId = @LibraryId AND
		(
			-- the default spare group for the new library is always a candidate
			IMSP.SpareGroupType = 2
			OR
			-- if it is a type 1, only allow it if it is of matching media type
			IMSP.SpareGroupType = 1 AND CMT.SpareGroupType IN (1,2) AND IMSP.MediaTypeId = @MediaTypeId
			OR
			-- if it is not (1,2) type, then allow any matching sparegroup types
			IMSP.SpareGroupType = CMT.SpareGroupType AND IMSP.SpareGroupType > 2
		)
	ORDER BY
				--keep same sparegroup if possible
				CASE WHEN IMSP.SpareGroupId = CMT.oldSpareGroupId THEN 0 ELSE 1 END,
				-- if sparegroup has to change, prefer default if it matches the media type and original type was user or default
				CASE WHEN IMSP.SpareGroupType = 2 AND IMSP.MediaTypeID = @mediaTypeID AND CMT.SpareGroupType IN (1,2) THEN 0 ELSE 1 END,
				-- if sparegroup is not (1,2), then make sure to use the right type
				CASE WHEN IMSP.SpareGroupType = CMT.SpareGroupType AND CMT.SpareGroupType > 2 THEN 0 ELSE 1 END,
				-- else prefer default
				CASE WHEN IMSP.SpareGroupType = 2 THEN 0 ELSE 1 END
)
FROM  @changeMediaTypeList CMT,MMSpareGroup MSP
WHERE
		-- which media need to change
		CMT.MediaId = MMMedia.MediaId
		-- MSP has info on old spare group info
		AND MSP.SpareGroupId = CMT.oldSpareGroupId
		AND
		(
			-- change sparegroup if library is the same and old spare group is user type and media type does not match
			MSP.MediaTypeId <> @MediaTypeId AND MSP.SpareGroupType = 1
			OR
			-- definately change if the library is different
			MSP.LibraryId <> @LibraryId
		)
IF(@@ERROR <> 0 )
BEGIN
	print 'Error: Failed to update MMMedia table'
	GOTO SCRIPT_EXIT
END
--change recording format type in MMVolume
SET @RecFormatId = (
					SELECT TOP 1 MRF.RecordingFormatId FROM MMRecFmtMedTyp MRF
											INNER JOIN MMMediaType MDT ON MRF.MediaTypeId = MDT.MediaTypeId
																		AND MDT.MediaTypeName =	@MediaType
											INNER JOIN MMDrive MMDR ON	MMDR.DriveTypeId = MRF.DriveTypeId
											INNER JOIN MMMasterPool MSP ON MSP.masterPoolId = MMDR.masterPoolId
																		AND MSP.LibraryId = @LibraryId
											ORDER BY MRF.RecordingFormatId DESC
					)
IF (@RecFormatId IS NULL)
BEGIN
	print 'Error: Cannot find recording format for media type and library combination'
	print 'Error: Incompatible target media type'
	GOTO SCRIPT_EXIT
END
UPDATE MMVolume
	SET RecordingFormatId = @RecFormatId
FROM @changeMediaTypeList CMT WHERE MMVolume.MediaId = CMT.MediaId
IF(@@ERROR <> 0 )
BEGIN
		print 'Error: Failed to update MMVolume table'
		GOTO SCRIPT_EXIT
END
GOTO EXIT_OK
SCRIPT_EXIT:
	ROLLBACK TRANSACTION
	print 'Error: Failed to run script'
	GOTO FINAL_EXIT
EXIT_OK:
	COMMIT TRANSACTION
FINAL_EXIT:
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeMediaType')
	delete from GxQscripts where name = 'QS_ChangeMediaType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeMediaType')
	delete from GXDBVersions where aliasname = 'QS_ChangeMediaType'
GO

insert into GXDBVersions values(2, 'QS_ChangeMediaType',  '00000000000000000000', 'QS_ChangeMediaType', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeMediaType',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Note - if the mediatype or library name has spaces, use double quotes!
'
 + CHAR(10) + '	1. List ALL compatible media types for that library
'
 + CHAR(10) + '	qscript -f changeMediaType.sql -i ListMediaTypes  Libarary Name
'
 + CHAR(10) + '	2. change mediatype of a specific media
'
 + CHAR(10) + '	qscript -f changeMediaType.sql -i media barcode MediaType 
'
 + CHAR(10) + '	3. Change mediatype of all available media in library
'
 + CHAR(10) + '	qscript -f changeMediaType.sql -i inlibrary  Libarary Name  MediaType
'
 + CHAR(10) + '	4. Change mediatype of all available media in library whose barcode ends with suffix
'
 + CHAR(10) + '	qscript -f changeMediaType.sql -i inlibrary  Libarary Name MediaType  restrictbysuffix  Suffix
'
 + CHAR(10) + '	5. Change mediatype of all existing AND exported media of library
'
 + CHAR(10) + '	qscript -f changeMediaType.sql -i inlibraryandexported Libarary Name MediaType 
'
 + CHAR(10) + '	6. Change mediatype of all existing AND exported media of library whose barcode ends with suffix
'
 + CHAR(10) + '	qscript -f changeMediaType.sql -i inlibraryandexported Libarary Name MediaType  restrictbysuffix Suffix
'
 + CHAR(10) + '	Note:- In addition to "inlibraryandexported" an additional option "inlibraryandexportedgui" can be used.
'
 + CHAR(10) + '	"inlibraryandexported" selects the media in the library and media which were last exported from the library.
'
 + CHAR(10) + '	"inlibraryandexportedgui" selects the same as above  but in addition also selects media that were at one point written to inside the specified library. The name GUI comes from the fact that the exported media it selects uses a similar logic as the exported media node in the GUI.	
'
 + CHAR(10) + '--   script_name : ChangeMediaType'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_Commcellaveragedatatransfer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_Commcellaveragedatatransfer.sp,v $ $Id: QS_Commcellaveragedatatransfer.sp,v 1.2 2012/08/30 19:38:17 xsui Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CommCellAverageDataTransfer <<<'

IF EXISTS (select * from sysobjects where name='QS_CommCellAverageDataTransfer')
	drop procedure QS_CommCellAverageDataTransfer
IF EXISTS (select * from GxQscripts where name='QS_CommCellAverageDataTransfer')
	delete from GxQscripts where name = 'QS_CommCellAverageDataTransfer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommCellAverageDataTransfer')
	delete from GXDBVersions where aliasname = 'QS_CommCellAverageDataTransfer'
GO
print '... Creating Procedure: QS_CommCellAverageDataTransfer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_CommCellAverageDataTransfer
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @Param1 varchar(255)='',
  @Param2 varchar(255)='',
  @Param3 varchar(255)=''
AS
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'CommCellAverageDataTransfer'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------------------------------
--test
--SET		@PARAM1= '2009/01/01'
--SET		@PARAM2= '2010/01/01'
--SET		@PARAM3= 'AVG'
---------------------------------------
IF @PARAM1 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Start Date is not provided.'
	GOTO ARGS_ERROR
END
IF @PARAM2 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. End Date is not provided.'
	GOTO ARGS_ERROR
END
IF @PARAM3 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. MAX / AVG option is not provided.'
	GOTO ARGS_ERROR
END
IF @PARAM3 NOT IN ('MAX' , 'AVG')
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. option entered is invalid. Please provide option MAX / AVG.'
	GOTO ARGS_ERROR
END
DECLARE @StartDate as DATETIME
DECLARE @EndDate as DATETIME
DECLARE @UTCAdd as DATETIME
SET @StartDate = @PARAM1
SET @EndDate = @PARAM2
SET @UTCAdd = '1970/01/01'
IF @PARAM3 = 'MAX'
BEGIN
		select JMBkpStats.appId ,
		   MAX(APP_Client.name) as ClientName,
		   APP_Client.id as ClientId,
		   JMBkpStats.appType as AppTypeId,
		   MAX(APP_iDAType.name) AS AppType,
		   MAX(APP_Application.subclientName) AS subClientName,
		   archGroup.id as SPId,
		   MAX(archGroup.name) as SPName,
		   CASE JMBkpStats.bkpLevel WHEN 1 THEN 'FULL' WHEN 2 THEN 'INCR' WHEN 4 THEN 'DIFF' END AS BackupLevel,
		   count(*) as NumOfJobs,
		   CAST(MAX(totalUnCompBytes)/(1024.0 * 1024) as DECIMAL (20,2)) as MaxUncompMB,
		   CAST(MAX(totalCompBytes)/(1024.0 * 1024) as DECIMAL (20,2))as MaxcompMB,
		   CASE WHEN MAX(totalUnCompBytes) = MAX(totalCompBytes) THEN 'UnCompressed' ELSE 'Compressed' END as IsCompressed
	FROM         APP_Application INNER JOIN
		     APP_Client ON APP_Application.clientId = APP_Client.id INNER JOIN
		     APP_iDAType ON APP_Application.appTypeId = APP_iDAType.type INNER JOIN
		     JMBkpStats ON APP_Application.id = JMBkpStats.appId INNER JOIN
		     archGroup on JMBkpStats.dataArchGrpId = archGroup.id
			AND bkpLevel in (1,2,4)
			AND JMBkpStats.status in (1)
			AND (dateadd(ss, servStartDate, @UTCAdd) Between @StartDate AND @EndDate)
	Group by JMBkpStats.appId, APP_Client.id, JMBkpStats.appType, archGroup.id, bkplevel
	Order by SPId, ClientId, JMBkpStats.appId, JMBkpStats.bkplevel
END
ELSE IF @PARAM3 = 'AVG'
BEGIN
		select JMBkpStats.appId ,
		   MAX(APP_Client.name) as ClientName,
		   APP_Client.id as ClientId,
		   JMBkpStats.appType as AppTypeId,
		   MAX(APP_iDAType.name) AS AppType,
		   MAX(APP_Application.subclientName) AS subClientName,
		   archGroup.id as SPId,
		   MAX(archGroup.name) as SPName,
		   CASE JMBkpStats.bkpLevel WHEN 1 THEN 'FULL' WHEN 2 THEN 'INCR' WHEN 4 THEN 'DIFF' END AS BackupLevel,
		   count(*) as NumOfJobs,
		   CAST(AVG(totalUnCompBytes)/(1024.0 * 1024) as DECIMAL (20,2)) as AvgUncompMB,
		   CAST(AVG(totalCompBytes)/(1024.0 * 1024) as DECIMAL (20,2))as AvgcompMB,
		   CASE WHEN AVG(totalUnCompBytes) = AVG(totalCompBytes) THEN 'UnCompressed' ELSE 'Compressed' END as IsCompressed
	FROM         APP_Application INNER JOIN
			  APP_Client ON APP_Application.clientId = APP_Client.id INNER JOIN
			  APP_iDAType ON APP_Application.appTypeId = APP_iDAType.type INNER JOIN
			  JMBkpStats ON APP_Application.id = JMBkpStats.appId INNER JOIN
			  archGroup on JMBkpStats.dataArchGrpId = archGroup.id
			  AND bkpLevel in (1,2,4)
			  AND JMBkpStats.status in (1)
			  AND (dateadd(ss, servStartDate, @UTCAdd) Between @StartDate AND @EndDate)
	Group by JMBkpStats.appId, APP_Client.id, JMBkpStats.appType, archGroup.id, bkplevel
	Order by SPId, ClientId, JMBkpStats.appId, JMBkpStats.bkplevel
END
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_Commcellaveragedatatransfer')
	delete from GxQscripts where name = 'QS_Commcellaveragedatatransfer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_Commcellaveragedatatransfer')
	delete from GXDBVersions where aliasname = 'QS_Commcellaveragedatatransfer'
GO

insert into GXDBVersions values(2, 'QS_Commcellaveragedatatransfer',  '00010002000000000000', 'QS_Commcellaveragedatatransfer', '00010002000000000000')
GO

insert into GxQscripts values(2,'QS_Commcellaveragedatatransfer',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CommCellAverageDataTransfer -si <Start Date in the form yyyy/mm/dd> -si <Start Date in the form yyyy/mm/dd> -si MAX/AVG
'
 + CHAR(10) + '-- 	script_name: CommCellAverageDataTransfer'
 + CHAR(10) + '-- 	Lists the Max / Average amount of data transferred by each backup type (Full, Incremental, Differential) for all subclients in the given time range. Returns data only for completed jobs. Since the CommServe database does not  contain information for jobs pruned more than a week ago, for the most accurate information, do not use older time ranges. Typical use is to find Max / Average amount of data transferred in the last month.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateOracleInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CreateOracleInstance <<<'

IF EXISTS (select * from sysobjects where name='QS_CreateOracleInstance')
	drop procedure QS_CreateOracleInstance
IF EXISTS (select * from GxQscripts where name='QS_CreateOracleInstance')
	delete from GxQscripts where name = 'QS_CreateOracleInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateOracleInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateOracleInstance'
GO
print '... Creating Procedure: QS_CreateOracleInstance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CreateOracleInstance
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @client nvarchar(1024) = '%s',
  @instancename nvarchar(1024) = '%s',
  @homeDir nvarchar(1024) = '%s',
  @version nvarchar(1024) = '%s',
  @defSP nvarchar(1024) = '%s',
  @logSP nvarchar(1024) = '%s',
  @cmdSP nvarchar(1024) = '%s',
  @user nvarchar(1024) = '%s',
  @pwd nvarchar(1024) = '%s',
  @service nvarchar(1024) = '%s',
  @useCat nvarchar(1024)= '%s',
  @catUser nvarchar(1024) = '%s',
  @catpwd nvarchar(1024) = '%s',
  @catservice nvarchar(1024) = '%s',
  @hostuser nvarchar(1024) = '%s',
  @ntpwd nvarchar(1024) = '%s'
AS
SET NOCOUNT ON
-------------------INPUTS all mandatory----------------------------------
--DECLARE @client nvarchar(1024)
--SET @client = '%s'
--DECLARE @instanceName nvarchar(1024)
--SET @instancename = '%s'
--DECLARE @homeDir nvarchar(1024)
--SET @homeDir = '%s'
--DECLARE @version nvarchar(1024)
--SET @version = '%s'
--DECLARE @defSP nvarchar(1024)
--SET @defSP = '%s'
--DECLARE @logSP nvarchar(1024)
--SET @logSP = '%s'
--DECLARE @cmdSP nvarchar(1024)
--SET @cmdSP = '%s'
--DECLARE @user nvarchar(1024)
--SET @user = '%s'
--DECLARE @pwd nvarchar(1024)
--SET @pwd = '%s'
--DECLARE @service nvarchar(1024)
--SET @service = '%s'
--DECLARE @useCat nvarchar(1024)
--SET @useCat = '%s'
--DECLARE @catUser nvarchar(1024)
--SET @catUser = '%s'
--DECLARE @catpwd nvarchar(1024)
--SET @catPwd = '%s'
--DECLARE @catService nvarchar(1024)
--SET @catService = '%s'
--DECLARE @hostuser nvarchar(1024)
--SET @hostuser = '%s'
--DECLARE @ntpwd nvarchar(1024)
--SET  @ntpwd = '%s'
--DECLARE @MAX_ENTITY_SIZE smallint
--SET @MAX_ENTITY_SIZE = 100
-------------------------------
--SET @client = 'bingo'
--SET @instancename = '%s'
--select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
-------------------------------
----------------------Error Handling----------------------------------------------
DECLARE @errorCode integer
SET @errorCode = 0
DECLARE @errorString nvarchar(1024)
SET @errorString = ''
DECLARE @noParameter nvarchar(4)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
----------------------const------------------------------
DECLARE @scriptName nvarchar(128)
SET @scriptName = 'CreateOracleInstance'
DECLARE @onDmndInst nvarchar(128)
SET @onDmndInst = 'On Demand Instance'
DECLARE @nowTime integer
SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
DECLARE @oracleApptype integer
SET @oracleApptype = 22
DECLARE @defArchGrpId integer
SET @defArchGrpId = 1
DECLARE @logArchGrpId integer
SET @logArchGrpId = 1
DECLARE @cmdArchGrpId integer
SET @cmdArchGrpId = 1
DECLARE @instStatus integer
SEt @instStatus = 0
---------------------parameter 1 - client name--------------------------------------------
IF @client = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
DECLARE @clientId integer
SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name like @client), 0)
IF @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@client+'] not found.'
	GOTO ERROR_EXIT
END
IF NOT EXISTS(SELECT id FROM APP_IdaName WHERE clientid = @clientId and apptypeId = @oracleApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@client+'] does not have Oracle iDataAgent.'
	GOTO ERROR_EXIT
END
-----------------------------instance name ----------------------------
IF @instanceName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance Name was not supplied as an input.'
	GOTO ERROR_EXIT
END
IF @instanceName = @onDmndInst
BEGIN
	SET @instStatus = 2048
	SET @instanceName = @onDmndInst
	IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
			WHERE I.status & 2048 = 2048 AND A.clientid = @clientId AND A.apptypeid = @oracleApptype)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. On Demand Instance already exists in client ['+@client+'].'
		GOTO ERROR_EXIT
	END
END
-----------------Validate other parameters for non ondemand instance---------------
DECLARE @useCatalogConnect integer
IF EXISTS (SELECT * FROM APP_InstanceName I INNER JOIN APP_Application A ON I.id = A.instance
		WHERE I.name = @instanceName AND A.clientid = @clientId AND A.apptypeid = @oracleApptype)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Instance ['+@instanceName+'] already exists in client ['+@client+'].'
	GOTO ERROR_EXIT
END
IF @instanceName <> @onDmndInst
BEGIN
	--SQL connect
	IF @user = '/'
	BEGIN
		SET @ntpwd = @catService
		SET @hostuser = @catPwd
		SET @catService = @catUser
		SET @catPwd = @useCat
		SET @catUser = @service
		SET @useCat = @pwd
		SET @service = ''
		SET @pwd = '2'
		--select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
	END
	IF @homeDir = @noparameter OR
		@version = @noParameter OR
		@defSP = @noParameter OR
		@logSP = @noParameter OR
		@cmdSP = @noParameter OR
		@user = @noParameter OR
		@pwd = @noParameter OR
		@service = @noParameter OR
		@useCat = @noParameter
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. The parameters supplied are not sufficient to create the instance. Please try again with all inputs.'
		GOTO ERROR_EXIT
	END
	SET @defArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @defSP), 0)
	SET @logArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @logSP), 0)
	SET @cmdArchGrpId = ISNULL((SELECT id FROM ArchGRoup WHERE name like @cmdSP), 0)
	IF @defArchGrpId = 0 OR
		@logArchGrpId = 0 OR
		@cmdArchGrpId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid storage policy given.'
		GOTO ERROR_EXIT
	END
	IF @useCat = 'yes'
		SET @useCatalogConnect = 1
	ELSE IF @useCat = 'no'
		SET @useCatalogConnect = 0
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid input for Catalog connect.'
		GOTO ERROR_EXIT
	END
	IF @useCatalogConnect = 1 AND
		(@catUser = @noParameter OR
		@catPwd = @noParameter OR
		@catService = @noParameter OR
		@hostuser = @noParameter)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Please provide Catalog connect parameters and host user name.'
		GOTO ERROR_EXIT
	END
	IF LEN(@instanceName ) > 100
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Instance name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
		GOTO ERROR_EXIT
	END
	--if no catalog connect is NOT used then the username and password that follow it are for the host computer.
	IF @useCatalogConnect = 0
	BEGIN
		SET @hostuser = @catUser
		SET @ntpwd = @catPwd
		SET @catUser = ''
		SET @catPwd = ''
		SET @catService = ''
	END
	--split hostuser into domain name and user name
	DECLARE @domainName nvarchar(1024)
	SET @domainName= ''
	DECLARE @userName nvarchar(1024)
	SET @userName = SUBSTRING(@hostuser, charindex('\', @hostuser, 0)+1, LEN(@hostuser))
	IF @userName = @hostuser
	BEGIN
		SET @userName = SUBSTRING(@hostuser, charindex('/', @hostuser, 0)+1, LEN(@hostuser))
	END
	SET @domainName = SUBSTRING(@hostuser, 0, LEN(@hostuser)-LEN(@userName))
	--nt password
	IF @ntpwd = @noParameter
		SET @ntpwd = ''
END  --IF @instanceName <> @onDmndInst
BEGIN TRAN
--Create instance
INSERT INTO APP_InstanceName (name, reftime, modified, status) VALUES(@instanceName, @nowTime, 0, @instStatus)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Could not create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @instanceId integer
SET @instanceId = @@IDENTITY
IF @instanceName <> @onDmndInst
BEGIN
	--Create instance properties
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle Home', 1, @homeDir, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle Version', 1, @version, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Domain Name', 1, @domainName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Oracle User', 1, @userName, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Domain User Password', 1, @ntPwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect', 1, @user, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect Password', 1, @pwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'SQL Connect Machine', 1, @service, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'use Catalog Connect', 2, @useCatalogConnect, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Catalog Connect', 1, @catUser, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Catalog Connect Password', 1, @catPwd, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'Catalog Connect Machine', 1, @catService, @nowTime, 0)
	INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified)
		VALUES (@instanceId, 'TNS admin path', 1, '', @nowTime, 0)
END
--Create default backupset
INSERT INTO APP_BackupsetName (name, refTime, modified, status) VALUES ('default', @nowTime, 0, 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
DECLARE @backupsetId integer
SET @backupsetId = @@IDENTITY
--Create default SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @defArchGrpId , @logArchGrpId , @nowTime, 0, 'default', 8)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error tryint to create default subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
--Create commandline SC
INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
	VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @cmdArchGrpId , @logArchGrpId , @nowTime, 0, '(command line)', 64)
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Error trying to create subclient for instance['+@instanceName +'].'
	GOTO TRANS_EXIT
END
TRANS_EXIT:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ERROR_EXIT:
Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateOracleInstance')
	delete from GxQscripts where name = 'QS_CreateOracleInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateOracleInstance')
	delete from GXDBVersions where aliasname = 'QS_CreateOracleInstance'
GO

insert into GXDBVersions values(2, 'QS_CreateOracleInstance',  '00000000000000000000', 'QS_CreateOracleInstance', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateOracleInstance',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CreateOracleInstance.sql -si client_name -si instance_name -si oracle_home -si Oracle_version	-si default_Storage_policy -si log_storage_policy -si cmd_storage_policy -si Oracle_user -p2 Oracle_pwd -si Oracle_service -si yes/no(catalog_connect) [-si catalog_user] [-p2 catalog_pwd] [-si catalog_service] -si host_user [-p2 host_pwd]
'
 + CHAR(10) + '--   script_name : CreateOracleInstance'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteScheduleTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteScheduleTemplate <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteScheduleTemplate')
	drop procedure QS_DeleteScheduleTemplate
IF EXISTS (select * from GxQscripts where name='QS_DeleteScheduleTemplate')
	delete from GxQscripts where name = 'QS_DeleteScheduleTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteScheduleTemplate')
	delete from GXDBVersions where aliasname = 'QS_DeleteScheduleTemplate'
GO
print '... Creating Procedure: QS_DeleteScheduleTemplate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteScheduleTemplate
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @schedName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @schedName       varchar(1024)
--SET	@schedName         = '%s'
--SET	@schedName         = 'Mypolicy'
---------------------------------------
--test
--SET		@schedName	= 'Mypolicy'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'DeleteScheduleTemplate'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @schedName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule policy name Expected as parameter 1.'
	GOTO ARGS_ERROR
END
------------ validate subclient id ----------------
DECLARE @taskId integer
SET @taskId = ISNULL((Select taskId FROM TM_Task WHERE taskName COLLATE Latin1_General_CS_AS = @schedName and taskType = 4), 0)
IF @taskId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@schedName +'] not found.'
	GOTO ARGS_ERROR
END
BEGIN TRAN
	UPDATE TM_Task SET deleted = 1 WHERE taskId = @taskId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@schedName+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteScheduleTemplate')
	delete from GxQscripts where name = 'QS_DeleteScheduleTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteScheduleTemplate')
	delete from GXDBVersions where aliasname = 'QS_DeleteScheduleTemplate'
GO

insert into GXDBVersions values(2, 'QS_DeleteScheduleTemplate',  '00000000000000000000', 'QS_DeleteScheduleTemplate', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteScheduleTemplate',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DeleteScheduleTemplate.sql -si schedulepolicy_name
'
 + CHAR(10) + '--   script_name : DeleteScheduleTemplate'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteStaleSnapsforRepset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteStaleSnapsforRepset <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteStaleSnapsforRepset')
	drop procedure QS_DeleteStaleSnapsforRepset
IF EXISTS (select * from GxQscripts where name='QS_DeleteStaleSnapsforRepset')
	delete from GxQscripts where name = 'QS_DeleteStaleSnapsforRepset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteStaleSnapsforRepset')
	delete from GXDBVersions where aliasname = 'QS_DeleteStaleSnapsforRepset'
GO
print '... Creating Procedure: QS_DeleteStaleSnapsforRepset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteStaleSnapsforRepset
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'DeleteStaleSnapsForRepset'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------------------------------
--test
--SET		@PARAM1= '674'
---------------------------------------
IF @PARAM1 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Repset id is not provided.'
	GOTO ARGS_ERROR
END
declare @RepSetId  INT
set @RepSetId = CONVERT(INT, @PARAM1)
BEGIN
	DECLARE @sRepId				nvarchar(128)
	DECLARE @sQuery				nvarchar(1024)
--begin transaction
IF object_id('tempdb.dbo.#cvTempSnaps') IS NOT Null DROP TABLE #cvTempSnaps
CREATE table #cvTempSnaps( nSnapID int, nRPID int)  -- to keep the snap id and RPIDs to be deleted
-- figure out the sna[s to be deleted
DECLARE @Quote nvarchar(4)
SET @Quote = ''''
set @sRepId	= CAST(@RepSetId  as nvarchar(128))
-- Do not delete fan in Rps
set @sQuery = ' select id, consistencyPointId from QRFLRSnapShot where consistencyPointId  in ( select id from QRFLRConsistencyPoint where FLRSetid = ' + @sRepId + ' and type <> 1 )'
insert into #cvTempSnaps EXEC dbo.sp_executesql @sQuery
begin transaction
-- delete netwrok shares of concerned mount points of snaps to be deleted
delete QRFLRSnapNetworkshare where mountPointId in( select id from QRFLRSnapMountPoint where SnapshotId in ( select nSnapID from #cvTempSnaps ))
-- Now delete entries from QRFLRSnapMountPoint
delete QRFLRSnapMountPoint where SnapshotId in ( select nSnapID from #cvTempSnaps )
-- we have one more dependency for QRFLRSnapShot on QRFLRSnapPair. deleing entries from it
delete QRFLRSnapPair where snapshotid in  ( select nSnapID from #cvTempSnaps )
-- now we can remove entries from QRFLRSnapshot
delete QRFLRSnapShot where id in   ( select nSnapID from #cvTempSnaps )
-- finally remove all CP info from DB
delete QRFLRConsistencypoint where id in (select DISTINCT nRPID from #cvTempSnaps)
commit transaction
-- Now delete the temo table
delete #cvTempSnaps
END_PROC:
--rollback transaction
END
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteStaleSnapsforRepset')
	delete from GxQscripts where name = 'QS_DeleteStaleSnapsforRepset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteStaleSnapsforRepset')
	delete from GXDBVersions where aliasname = 'QS_DeleteStaleSnapsforRepset'
GO

insert into GXDBVersions values(2, 'QS_DeleteStaleSnapsforRepset',  '00000000000000000000', 'QS_DeleteStaleSnapsforRepset', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteStaleSnapsforRepset',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn DeleteStaleSnapsForRepset.sql -si RepsetId
'
 + CHAR(10) + '--   script_name : DeleteStaleSnapsforRepset'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableSystemState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableSystemState <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableSystemState')
	drop procedure QS_EnableSystemState
IF EXISTS (select * from GxQscripts where name='QS_EnableSystemState')
	delete from GxQscripts where name = 'QS_EnableSystemState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSystemState')
	delete from GXDBVersions where aliasname = 'QS_EnableSystemState'
GO
print '... Creating Procedure: QS_EnableSystemState'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_EnableSystemState
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(1024) = '%s',
  @BACKUPSETNAME VARCHAR(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
--DECLARE @CLIENTNAME     varchar(1024)
--DECLARE @BACKUPSETNAME  varchar(1024)
--SET		@ClientName		= '%s'
--SET		@BACKUPSETNAME	= '%s'
DECLARE @debug integer
SET @debug = 0
------- TEST DATA (FAKE OUT QSCRIPT  -----------------
--SET @debug = 1
--SET   @CLIENTNAME = 'allclients'
--SET   @CLIENTNAME = 'c=bingo_cn'
--SET	@BACKUPSETNAME = 'a'
------------------------------------------------------
-------------  Convenience Definitions  ---------------------
DECLARE @scriptName				varchar(40)
SET		@scriptName				= 'EnableSystemStateOnDefaultSubclient'
DECLARE @sysStateProp varchar(32)
SET @sysStateProp = 'System State'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())DECLARE @srcSubClientID   int
DECLARE @newValue varchar(5)
SET @newValue = '1'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @defaultStatusBit  integer
SET		@defaultStatusBit = 8						-- Default SubClient
DECLARE @invalidStatusBits  integer
SET		@invalidStatusBits = 4+2					-- DELETED, UNINSTALLED
DECLARE @lastError		int
SET		@lastError = 0							-- Be pessimistic
DECLARE	@errorString	varchar(1024)
set		@errorString = 'Error encountered when running script'
DECLARE @describeSC		varchar(1024)
set		@describeSC  = 'Unknown SubClient'
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
DECLARE @clientId    integer
IF @ClientName = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@ClientName, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @errorString = 'Error.  Client ['+ (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @errorString = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
IF @debug = 1
	SELECT 'clientId', @clientId
--IS BACKUPSETNAME PRESENT---
----------------------------------------------------------------------
DECLARE @backupSetId integer
IF @BACKUPSETNAME = @NoParameter
BEGIN
	SET @backupSetId = 0
END
ELSE
BEGIN
	SET @backupSetId = (Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
						  where
							APP.clientId = @clientId
							AND APP.backupSet = BSN.id
							AND BSN.name = @BACKUPSETNAME
							AND appTypeId in (1,11,33,34,42,43)
							)
	IF @backupSetId is NulL
	BEGIN
		Set @lastError = 1
		SET @errorString = 'Error : No backupset with name ['+@BACKUPSETNAME+'] exists.'
		goto ARGS_ERROR
	END
END
---DO NOT SET SYSTEM STATE WEHN BACKUPSET IS ASSOCIATED WITH SUBCLIENT POLICY
declare @SubclientPolicyBackupsets table(backupsetId integer)
INSERT INTO @SubclientPolicyBackupsets
SELECT DISTINCT(SC.backupset) FROM APP_Application SC JOIN APP_BackupSetName BS
		ON SC.backupset = BS.id JOIN APP_BackupsetProp BSPROP
		ON BS.id = BSPROP.componentnameid
		WHERE appTypeId in (1,11,33,34,42,43)
		  AND BSPROP.Attrname = 'Associated subclient Policy' AND BSPROP.modified = 0 AND BSPROP.AttrVal > 0
IF @backupSetId in (SELECT backupSetId FROM @SubclientPolicyBackupsets)
BEGIN
	Set @lastError = 1
	SET @errorString = 'Error : Backupset ['+@BACKUPSETNAME+'] is associated with a subclient policy. Cannot Enable System State.'
	goto ARGS_ERROR
END
IF @debug = 1
BEGIN
	SELECT 'backupSetId', @backupSetId
	SELECt 'SCP associated', * from @SubclientPolicyBackupsets SCP_bs, APP_backupsetNAme BS where scp_bs.backupsetId = BS.id
END
--------------------------------------------------------------
--GET LIST OF DEFAULT SUBCLIENTS TO ENABLE SYSTEM STATE
--AND LISt OF OTHER SUBCLIENTS THAT  ALREADY HAVE SYSTEM STATE ENABLED IN ORDER TO RESET
--------------------------------------------------------------
declare  @SetsubclientList table(subclientId integer)
declare  @ResetSubclientList table(subclientId integer)
IF @clientId <> 0 AND @backupSetId <> 0
BEGIN
	INSERT @SetsubclientList
	SELECT id FROM APP_Application
		WHERE clientId = @clientId
		  AND  backupSet = @backupSetId
	      AND  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) <> 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
	INSERT @ResetsubclientList
	SELECT SC.id FROM APP_Application SC JOIN App_subclientProp  ScProp
		ON SC.id = ScProp.componentNameId
		WHERE SC.clientId = @clientId
		  AND  SC.backupSet = @backupSetId
	      AND  SC.appTypeId in (1,11,33,34,42,43)
		  AND (SC.subClientStatus & @defaultStatusBit) = 0
		  AND (SC.subClientStatus & @invalidStatusBits) =  0
		  AND ScProp.attrName like @sysStateProp
		  AND ScProp.modified = 0
		  AND ScProp.attrVal = '1'
		  AND SC.backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
END
ELSE IF @clientId <> 0 AND @backupSetId = 0
BEGIN
	INSERT @SetsubclientList
	SELECT id FROM APP_Application sc
		WHERE clientId = @clientId
	      AND  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) <> 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
	INSERT @ResetsubclientList
	SELECT SC.id FROM APP_Application SC JOIN App_subclientProp  ScProp
		ON SC.id = ScProp.componentNameId
		WHERE clientId = @clientId
	      AND  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) = 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND ScProp.attrName like @sysStateProp
		  AND ScProp.modified = 0
		  AND ScProp.attrVal = '1'
		  AND SC.backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
END
ELSE IF @clientId = 0 AND @backupSetId = 0
BEGIN
	INSERT @SetsubclientList
	SELECT id FROM APP_Application SC
		WHERE  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) <> 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
	INSERT @resetsubclientList
	SELECT SC.id FROM APP_Application SC JOIN App_subclientProp  ScProp
		ON SC.id = ScProp.componentNameId
		WHERE  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) = 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND ScProp.attrName like @sysStateProp
		  AND ScProp.modified = 0
		  AND ScProp.attrVal = '1'
		  AND SC.backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
END
ELSE
BEGIN
	Set @lastError = 1
	SET @errorString= 'No client['+@CLIENTNAME+ '], backupset['+@BACKUPSETNAME+'] found.'
	goto ARGS_ERROR
END
IF @debug = 1
BEGIN
	SELECT 'enable', sc.subclientId, app.subclientName, app.subclientStatus FROM @SetsubclientList sc, APP_Application app where sc.subclientId = app.id
	SELECT 'disable', sc.subclientId, app.subclientName, app.subclientStatus FROM @resetsubclientList sc, APP_Application app where sc.subclientId = app.id
END
DECLARE @scId integer
BEGIN TRAN
DECLARE subClientCursor CURSOR STATIC FOR
  SELECT subclientid from @SetsubclientList
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @scId
    WHILE @@FETCH_STATUS = 0
    BEGIN
		DECLARe @subclientNAme varchar(100)
		SET @subclientNAme = (select subclientname from app_application where id = @scid)
		IF @debug = 1
			Print 'subclient ['+@subclientNAme+'].'
		DECLARE @oldValue integer
		SET @oldValue  = ISNULL((SELECT attrVal FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @scId
				AND   attrName = @sysStateProp
				AND   modified = 0), 0)
		IF @oldValue <> @newValue
		BEGIN
			UPDATE APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @scId
					AND   attrName = @sysStateProp
					AND   modified = 0
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @sysStateProp
							+ ' for subClient '
							+ cast (@scId as nvarchar(10))
							+ 'All changes will be rolled back for this client.'
				GOTO TRANS_EXIT
			END
			INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@scId, @sysStateProp, 2, @newValue, @nowTime, 0)
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @sysStateProp
							+ ' for subClient '
							+ cast (@scId as nvarchar(10))
							+ 'All changes will be rolled back for this client.'
				GOTO TRANS_EXIT
			END
			IF @debug = 1
				PRINT 'Enabled successfully on subclient ['+ @subclientNAme +'].'
		END
		ELSE
		BEGIN
			IF @debug = 1
				Print 'No change for ['+@subclientNAme+'].'
			FETCH NEXT FROM subClientCursor INTO @scId
			CONTINUE
		END
		FETCH NEXT FROM subClientCursor INTO @scId
    END
IF @debug = 1
	PRINT 'Done enabling.'
DECLARE resetSubClientCursor CURSOR STATIC FOR
SELECT subclientid from @resetSubClientList
	IF @debug = 1
		PRINT 'Will disable on all other subclients'
    OPEN resetSubClientCursor
    FETCH NEXT FROM resetSubClientCursor INTO @scId
    WHILE @@FETCH_STATUS = 0
    BEGIN
		SET @subclientNAme = (select subclientname from app_application where id = @scid)
		IF @debug  = 1
			Print 'subclient ['+@subclientNAme+'].'
		SET @oldValue  = ISNULL((SELECT attrVal FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @scId
				AND   attrName = @sysStateProp
				AND   modified = 0), 0)
		IF @oldValue  <> 0
		BEGIN
			UPDATE APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @scId
					AND   attrName = @sysStateProp
					AND   modified = 0
			INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@scId, @sysStateProp, 2, 0, @nowTime, 0)
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @sysStateProp
							+ ' for subClient '
							+ cast (@scId as nvarchar(10))
							+ 'All changes will be rolled back for this client.'
				GOTO TRANS_EXIT
			END
			IF @debug  = 1
				PRINT 'Disabled successfully on subclient ['+ @subclientNAme +'].'
		END
		ELSE
		BEGIN
			IF @debug  = 1
				Print 'No change for ['+@subclientNAme+'].'
			FETCH NEXT FROM resetSubClientCursor INTO @scId
			CONTINUE
		END
		FETCH NEXT FROM resetSubClientCursor INTO @scId
    END
IF @debug = 1
	PRINT 'Done.'
TRANS_EXIT:
    CLOSE       subClientCursor
    DEALLOCATE  subClientCursor
    IF  CURSOR_STATUS('global', 'resetSubClientCursor') >= 0
    BEGIN
		CLOSE       resetSubClientCursor
		DEALLOCATE  resetSubClientCursor
	END
IF @LastError <> 0
	ROLLBACK TRAN
ELSE
BEGIN
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
END
PRINT Convert(varchar(60), getdate()) +' Complete ['+ @scriptName + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
	)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableSystemState')
	delete from GxQscripts where name = 'QS_EnableSystemState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSystemState')
	delete from GXDBVersions where aliasname = 'QS_EnableSystemState'
GO

insert into GXDBVersions values(2, 'QS_EnableSystemState',  '00000000000000000000', 'QS_EnableSystemState', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EnableSystemState',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn EnableSystemState -si allclients/c=clientName -si backupsetname
'
 + CHAR(10) + '--   script_name : EnableSystemState'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EncryptionConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EncryptionConfig <<<'

IF EXISTS (select * from sysobjects where name='QS_EncryptionConfig')
	drop procedure QS_EncryptionConfig
IF EXISTS (select * from GxQscripts where name='QS_EncryptionConfig')
	delete from GxQscripts where name = 'QS_EncryptionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EncryptionConfig')
	delete from GXDBVersions where aliasname = 'QS_EncryptionConfig'
GO
print '... Creating Procedure: QS_EncryptionConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_EncryptionConfig
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @subclientname varchar(1024)='%s',
  @opt varchar(1024) = '%s',
  @iEncryptionTypeStr varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @ClientName			nvarchar(1024)
--SET		@ClientName			= N'%s'
--DECLARE @SubClientName		nvarchar(1024)
--SET		@SubClientName		= N'%s'
--DECLARE @OPT				varchar(1024)
--SET		@OPT				= '%s'
--DECLARE @iEncryptionTypeStr	varchar(512)
--SET		@iEncryptionTypeStr	= '%s'
---------------------------------------
--test
--SET		@ClientName			= 'all'
--SET		@SubClientName		= 'all'
--SET		@OPT				= 'get'
--SET		@iEncryptionType	= 0
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'EncryptionConfig'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter			=@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
SET @clientId					= 0
DECLARE @subClientId			integer
SET @subClientId				= 0
DECLARE @lastError				integer
SET @lastError					= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			= 'No error encountered when running script.'
DECLARE @iEncryptionType		INTEGER
SET		@iEncryptionType		= -1
DECLARE @tClients				TABLE	(	id	INTEGER)
DECLARE @tSubClients			TABLE	(	id	INTEGER)
DECLARE @tSCPSubClients			TABLE	(	id	INTEGER)
IF LOWER(@OPT) = 'set'
BEGIN
	IF @iEncryptionTypeStr = @NoParameter
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Parameter4 property value is not mentioned'
		goto ARGS_ERROR
	END
	SET @iEncryptionType = convert(integer, @iEncryptionTypeStr)
	IF @iEncryptionType < 0 OR @iEncryptionType > 3
	BEGIN
		PRINT N'Encryption Parameter is invalid'
		PRINT N'	0 - None'
		PRINT N'	1 - Media Only (Media Agent Side)'
		PRINT N'	2 - Network and Media (Agent Side)'
		PRINT N'	3 - Network Only (Agent Encrypts, Media Agent Decrypts)'
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Invalid encryption type parameter.'
		goto ARGS_ERROR
	END
END
-- Parse Client Name parameter
IF LOWER(@ClientName) = N'all'
BEGIN
	INSERT @tClients(id) SELECT id FROM App_Client WHERE id > 1
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@ClientName, 1, 2)) = N'c='
	BEGIN
		set @clientId= ISNULL((SELECT TOP(1) id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @lastError = 2
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2)) + '] Does not exist.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as all or c=clientName.'
		goto ARGS_ERROR
	END
	INSERT @tClients(id)
	SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))
END
-- Parse Sub Client Name parameter
IF LOWER(@SubClientName) = N'all'
BEGIN
	INSERT @tSubClients(id) SELECT id FROM App_Application WHERE clientId IN (SELECT id AS clientId FROM @tClients)
END
ELSE
BEGIN
	IF LOWER(@ClientName) = N'all'
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg = 'Error.  Parameter2 must be all when Parameter1 is all.'
		goto ARGS_ERROR
	END
	IF LOWER(SUBSTRING(@SubClientName, 1, 2)) = N's='
	BEGIN
		set @subClientId= ISNULL((SELECT TOP(1) id from App_Application WHERE subclientName = (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2))
									AND clientId IN (SELECT id AS clientId FROM @tClients)),0)
		IF @subClientId = 0
		BEGIN
			SET @lastError = 5
			SET @localErrorMsg = 'Error.  Sub Client ['+ (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2)) + '] Does not exist.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 6
		SET @localErrorMsg = 'Error.  Parameter2 must be specified as all or s=subClientName.'
		goto ARGS_ERROR
	END
	INSERT @tSubClients(id)
	SELECT id from App_Application WHERE subclientName = (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2))
		AND clientId IN (SELECT id AS clientId FROM @tClients)
	IF LOWER(@OPT) = 'set'
	BEGIN
		IF (SELECT COUNT(id)
		FROM @tSubClients
		WHERE id IN
			(
				(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE AttrName = 'Associated subclient Policy' AND Modified = 0)
				UNION
				(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = 1030)
			)) > 0
		BEGIN
			SELECT DISTINCT 'Error! can not modify sub client "' + A.subClientName + '", it has associated subclient policy.'
			FROM @tSubClients AS T INNER JOIN App_Application AS A ON T.id = A.id
			WHERE T.id IN
				(
					(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
					WHERE AttrName = 'Associated subclient Policy' AND Modified = 0)
					UNION
					(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = 1030)
				)
			SET @lastError = 9
			SET @localErrorMsg = 'Error. Subclient policy is associated with mentioned sub client.'
			goto ARGS_ERROR
		END
	END
END
-- Remove hidden, dummy and deleted subclients
DELETE FROM @tSubClients
WHERE id IN
(
	SELECT Id FROM App_Application
	WHERE (subClientStatus & 0x4) <> 0 OR
		(subClientStatus & 0x10) <> 0 OR
		(subClientStatus & 0x20) <> 0
)
INSERT @tSCPSubClients(id)
SELECT id FROM @tSubClients
WHERE id IN
(
	SELECT DISTINCT ComponentNameId FROM App_SubClientProp
	WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
)
DELETE FROM @tSubClients
WHERE id IN
(
	SELECT DISTINCT ComponentNameId FROM App_SubClientProp
	WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
)
IF LOWER(@OPT) = 'get'
BEGIN
	-- To get encryption properties
	(
		SELECT	C.name AS ClientName,
				A.subclientName AS SubClientName,
				EncryptionType=
				CASE SP.attrVal
					WHEN 0 THEN 'None'
					WHEN 1 THEN 'Media Only (Media Agent Side)'
					WHEN 2 THEN 'Network and Media (Agent Side)'
					WHEN 3 THEN 'Network Only (Agent Encrypts, Media Agent Decrypts)'
					ELSE 'unknown'
				END
		FROM @tSubClients AS T INNER JOIN App_Application AS A ON T.id = A.Id
				INNER JOIN App_Client AS C ON C.id = A.clientId
				INNER JOIN App_SubClientProp AS SP ON A.id = SP.componentNameId
				WHERE SP.attrName = 'Encrypt: encryption' AND SP.attrType = 10 AND SP.modified = 0
	)
	UNION ALL
	(
		SELECT	C.name AS ClientName,
				A.subclientName AS SubClientName,
				EncryptionType=
				CASE SP.attrVal
					WHEN 0 THEN 'None'
					WHEN 1 THEN 'Media Only (Media Agent Side)'
					WHEN 2 THEN 'Network and Media (Agent Side)'
					WHEN 3 THEN 'Network Only (Agent Encrypts, Media Agent Decrypts)'
					ELSE 'unknown'
				END
		FROM App_Application AS A
			INNER JOIN App_Client AS C ON C.id = A.clientId
			INNER JOIN App_SubClientProp AS SP ON A.id = SP.componentNameId
			WHERE SP.attrName = 'Encrypt: encryption' AND SP.attrType = 10 AND SP.modified = 0
			AND A.id IN (
				SELECT attrVal AS id FROM App_SubClientProp
				WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
				AND componentNameId IN (
					SELECT id FROM @tSCPSubClients
			)
		)
	)
END
ELSE IF LOWER(@OPT) = 'set'
BEGIN
	BEGIN TRY
		BEGIN TRANSACTION
			INSERT App_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT componentNameId, attrName, attrType, @iEncryptionType, @nowTime, 0
			FROM App_SubClientProp AS SP
			WHERE SP.attrName = 'Encrypt: encryption' AND SP.attrType = 10 AND SP.modified = 0
				AND attrVal <> CONVERT(nvarchar(1024), @iEncryptionType)
				AND SP.componentNameId IN (SELECT id AS componentNameId FROM @tSubclients)
			UPDATE App_SubClientProp SET modified = @nowTime
			WHERE attrName = 'Encrypt: encryption' AND attrType = 10 AND modified = 0
				AND attrVal <> CONVERT(nvarchar(1024), @iEncryptionType)
				AND componentNameId IN (SELECT id AS componentNameId FROM @tSubclients)
		COMMIT TRANSACTION
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT @lastError = ERROR_NUMBER(), @localErrorMsg = ERROR_MESSAGE()
		PRINT N'Error occured. ErrorNo(' + CAST(@lastError AS NVARCHAR) + N') ErrorMsg(' + @localErrorMsg + N').'
		IF (XACT_STATE()) <> 0
		BEGIN
			PRINT N'So Rolling back Transactions.'
			ROLLBACK TRANSACTION
		END
	END CATCH
END
ELSE
BEGIN
	SET @lastError = 7
	SET @localErrorMsg ='Error, Parameter3 must be set or get.'
	goto ARGS_ERROR
END
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with '
         + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EncryptionConfig')
	delete from GxQscripts where name = 'QS_EncryptionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EncryptionConfig')
	delete from GXDBVersions where aliasname = 'QS_EncryptionConfig'
GO

insert into GXDBVersions values(2, 'QS_EncryptionConfig',  '00000000000000000000', 'QS_EncryptionConfig', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EncryptionConfig',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Examples:
'
 + CHAR(10) + '	To set the encryption to Media Only for subclient01 in client01:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 -si s=subclient01 -si set -si 1
'
 + CHAR(10) + '	To set the encryption to Network and Media for all subclients in client01:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 si all -si set -si 2
'
 + CHAR(10) + '	To set the encryption to Network Only for all subclients in a CommCell
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si all -si all -si set -si 3
'
 + CHAR(10) + '	To reset the encryption for subclient01 in client01:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 -si s=subclient01 -si set -si 0
'
 + CHAR(10) + '	To get the encryption for subclient01 in client01 - this will provide the encryption properties of the subclient as an output in the command console:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 -si s=subclient01 -si get
'
 + CHAR(10) + '--   script_name : EncryptionConfig'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_getAlertSNMPNotification.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_getAlertSNMPnotification <<<'

IF EXISTS (select * from sysobjects where name='QS_getAlertSNMPnotification')
	drop procedure QS_getAlertSNMPnotification
IF EXISTS (select * from GxQscripts where name='QS_getAlertSNMPnotification')
	delete from GxQscripts where name = 'QS_getAlertSNMPnotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getAlertSNMPnotification')
	delete from GXDBVersions where aliasname = 'QS_getAlertSNMPnotification'
GO
print '... Creating Procedure: QS_getAlertSNMPnotification'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_getAlertSNMPnotification
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'getAlertSNMPnotification'
DECLARE @NT_ALERTTYPE_SRM_ADVISORY		integer
SET     @NT_ALERTTYPE_SRM_ADVISORY		= 49
DECLARE @NT_SNMP_ALERTNOTIF			    integer
SET     @NT_SNMP_ALERTNOTIF				= 4
--DECLARE @SC_STATUS_BITS        integer
--SET		@SC_STATUS_BITS        =  2+4+16					-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--DECLARE @appTypeId				integer
--DECLARE @instanceId				integer
--DECLARE @backupSetId			integer
--DECLARE	@subClientId			integer
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
-- Please refer sql stored procedure br_NTalertList for detail
DECLARE @hasSRM             int
SET @hasSRM    = ISNULL(db_id('SRM'), 0)
SELECT NTnotificationRule.NotificationName as AlertName,
		NTAlertType.name as AlertType,
		CASE (NTnotificationRule.NotifType & @NT_SNMP_ALERTNOTIF)WHEN @NT_SNMP_ALERTNOTIF THEN 'YES' ELSE 'NO' END as SNMPEnabled
FROM NTnotificationRule,NTAlertType
WHERE NTnotificationRule.alertTypeId = NTAlertType.id
		-- as per sql stored procedure br_NTalertList logic used to not show  SRM ADVISORIES Alerts is different than this thats why its is commented
		--AND NTnotificationRule.alertTypeId <> @NT_ALERTTYPE_SRM_ADVISORY
		AND NTnotificationRule.revision > 0
		-- Do NOT show these ALERTS
		AND NOT
		(
			-- ROMS ALERTS
			( NTnotificationRule.status &64 = 64 )
			---- JOB BASED ALERTS
			--OR	( (NTnotificationRule.status &32 = 32) OR (NTnotificationRule.status &8 = 8)))
			-- SRM ADVISORIES ALERTS
			OR	( (NTnotificationRule.status &32 = 32) OR (NTnotificationRule.status &8 = 8) )
		)
		-- IF SRM ISN'T INSTALLED (ANYMORE) --
		-- .. DON'T RETURN SRM ALERTS       --
		AND NOT
		(
			@hasSRM <> 0 AND (
			NTnotificationRule.categoryId = 7   				--'NT_CATEGORY_SRM'
			OR NTnotificationRule.alertTypeId in (
						51,					-- 'NT_ALERTTYPE_SRM'
						56,			-- 'NT_ALERTTYPE_SRM_REPORT'
						31, 			-- 'NT_ALERTTYPE_SRM_WINFS'
						32,			-- 'NT_ALERTTYPE_SRM_ORACLE'
						33,				-- 'NT_ALERTTYPE_SRM_SQL'
						34,				-- 'NT_ALERTTYPE_SRM_NAS'
						35,			-- 'NT_ALERTTYPE_SRM_EXCHANGE'
						36,		-- 'NT_ALERTTYPE_SRM_SHARE_POINT'
						37,			-- 'NT_ALERTTYPE_SRM_UNIXFS'
						38,		--'NT_ALERTTYPE_SRM_COST_ANALYSIS'
						39 )   		--'NT_ALERTTYPE_SRM_NETWARE'
			)
		)
 SET @lastError = @@error
	IF @lastError <> 0
		GOTO ARGS_ERROR
---------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_getAlertSNMPNotification')
	delete from GxQscripts where name = 'QS_getAlertSNMPNotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getAlertSNMPNotification')
	delete from GXDBVersions where aliasname = 'QS_getAlertSNMPNotification'
GO

insert into GXDBVersions values(2, 'QS_getAlertSNMPNotification',  '00000000000000000000', 'QS_getAlertSNMPNotification', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_getAlertSNMPNotification',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f getAlertSNMPnotification.sql 
'
 + CHAR(10) + '--   script_name : getAlertSNMPnotification'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_getAllRunningJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetAllRunningJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_GetAllRunningJobs')
	drop procedure QS_GetAllRunningJobs
IF EXISTS (select * from GxQscripts where name='QS_GetAllRunningJobs')
	delete from GxQscripts where name = 'QS_GetAllRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetAllRunningJobs')
	delete from GXDBVersions where aliasname = 'QS_GetAllRunningJobs'
GO
print '... Creating Procedure: QS_GetAllRunningJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetAllRunningJobs
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-- Convenience Definitions ----------------------
DECLARE @scriptName	varchar(32)
set	@scriptName	= 'GetAllRunningJobs'
-------------------------- Get All Running Jobs ------------------
if OBJECT_ID('tempdb.dbo.#JobOperationName') is not NULL drop table dbo.#JobOperationName
create table #JobOperationName(opType integer, OpName nvarchar(64));
if OBJECT_ID('tempdb.dbo.#JobStateName') is not NULL drop table dbo.#JobStateName
create table #JobStateName(stateType integer, stateName nvarchar(64));
if OBJECT_ID('tempdb.dbo.#JobTypeName') is not NULL drop table dbo.#JobTypeName
create table #JobTypeName(jobType integer, jobTypeName nvarchar(64));
insert into #JobOperationName values	( 0,'No Operation');
insert into #JobOperationName values	( 1,'All Operation');
insert into #JobOperationName values	( 2,'Online');
insert into #JobOperationName values	( 3, 'Offline');
insert into #JobOperationName values	( 4,'Backup');
insert into #JobOperationName values	( 5,'Restore');
insert into #JobOperationName values	( 6, 'Import');
insert into #JobOperationName values	( 7,'CvImport');
insert into #JobOperationName values	( 8 , 'Media Init');
insert into #JobOperationName values	( 9 , 'Media Recycle');
insert into #JobOperationName values	( 10 , 'Prune');
insert into #JobOperationName values	( 11 , 'CS DR Backup');
insert into #JobOperationName values	( 12 , 'Index Restore');
insert into #JobOperationName values	( 13 , 'Aux Copy');
insert into #JobOperationName values	( 14 , 'Synthetic Full');
insert into #JobOperationName values	( 15 , 'W2K System Restore');
insert into #JobOperationName values	( 16 , 'W2K Full Build Restore');
insert into #JobOperationName values	( 17 , 'Report');
insert into #JobOperationName values	( 18 , 'Backup 3RD');
insert into #JobOperationName values	( 19 , 'W2K Full Build Restore371');
insert into #JobOperationName values	( 20 , 'SchedExport');
insert into #JobOperationName values	( 21 , 'Media Inventory');
insert into #JobOperationName values	( 22 , 'Snap Shot');
insert into #JobOperationName values	( 23 , 'Create Replica');
insert into #JobOperationName values	( 24 , 'Update Replica');
insert into #JobOperationName values	( 25 , 'DM Outlook Restore');
insert into #JobOperationName values	( 26 , 'Media Prediction');
insert into #JobOperationName values	( 27 , 'Snap Recovery');
insert into #JobOperationName values	( 28 , 'Schedule');
insert into #JobOperationName values	( 29 , 'Quick DM Restore');
insert into #JobOperationName values	( 30 , 'System State Backup');
insert into #JobOperationName values	( 31 , 'Archive Check');
insert into #JobOperationName values	( 32 , 'Tape Erase');
insert into #JobOperationName values	( 33 , 'Shelf Mangement');
insert into #JobOperationName values	( 34 , 'QR Copy Backup');
insert into #JobOperationName values	( 35 , 'Patch Update');
insert into #JobOperationName values	( 36 , 'Patch Download');
insert into #JobOperationName values	( 37 , 'QR RollBack');
insert into #JobOperationName values	( 38 , 'Selective Delete');
insert into #JobOperationName values	( 39 , 'WorkFlow');
insert into #JobOperationName values	( 40 , 'Index Free Restore');
insert into #JobOperationName values	( 41 , 'Drive Validation');
insert into #JobOperationName values	( 42 , 'Drive Cleaning');
insert into #JobOperationName values	( 43 , 'SysRecovery Backup');
insert into #JobOperationName values	( 44 , 'Browse And Delete');
insert into #JobOperationName values	( 45 , 'Snap Vault Restore');
insert into #JobOperationName values	( 46 , 'Stap Media');
insert into #JobOperationName values	( 47 , 'Catalogue Media');
insert into #JobOperationName values	( 48 , 'SR System Recovery');
insert into #JobOperationName values	( 49 , 'Search And Retrieve');
insert into #JobOperationName values	( 50 , 'Create Consistency Point');
insert into #JobOperationName values	( 51 , 'Create Recovery Point');
insert into #JobOperationName values	( 52 , 'FLR Copy Backup');
insert into #JobOperationName values	( 53 , 'Offline content Index');
insert into #JobOperationName values	( 54 , 'Power Restore');
insert into #JobOperationName values	( 55 , 'Power Search And Restore');
insert into #JobOperationName values	( 56 , 'CDR');
insert into #JobOperationName values	( 57 , 'Online Content Index');
insert into #JobOperationName values	( 58 , 'SRM OpType');
insert into #JobOperationName values	( 59 , 'Snap Backup');
insert into #JobOperationName values	( 60 , 'Snap To Tape');
insert into #JobOperationName values	( 61 , 'Snap Tp Tape WorkFlow');
insert into #JobOperationName values	( 62 , 'SRM Report');
insert into #JobOperationName values	( 63 , 'Maglib Maintenance');
insert into #JobOperationName values	( 64 , 'Info Management');
insert into #JobOperationName values	( 65 , 'Snap Backup3RD');
insert into #JobOperationName values	( 66 , 'Offline Mining Restore');
insert into #JobOperationName values	( 67 , 'Install Client');
insert into #JobOperationName values	( 68 , 'UnInstall Client');
insert into #JobOperationName values	( 69 , 'FDC WorkFlow');
insert into #JobOperationName values	( 70 , 'Mining Backup');
insert into #JobOperationName values	( 71 , 'CCM Capture');
insert into #JobOperationName values	( 72 , 'CCM Merge');
insert into #JobOperationName values	( 73 , 'FDC Client');
insert into #JobOperationName values	( 74 , 'Media Refreshing');
insert into #JobOperationName values	( 75 , 'FD CopyType');
insert into #JobOperationName values	( 76 , 'Archive Optype');
insert into #JobOperationName values	( 77 , 'Mining Content Index');
insert into #JobOperationName values	( 78 , 'FDC Preparation');
insert into #JobOperationName values	( 104 , 'Aux Copy');
insert into #JobOperationName select operation, OpName from JMOpTable where operation not in (select optype from #JobOperationName)
insert into #JobStateName values (0, 'null');
insert into #JobStateName values (1, 'Running');
insert into #JobStateName values (2, 'Pending');
insert into #JobStateName values (3, 'Waiting');
insert into #JobStateName values (4, 'Completed');
insert into #JobStateName values (5, 'Suspended');
insert into #JobStateName values (6, 'Kill Pending');
insert into #JobStateName values (7, 'Suspend Pending');
insert into #JobStateName values (8, 'Interrupt Pending');
insert into #JobStateName values (9, 'Completed Success');
insert into #JobStateName values (10, 'Failed');
insert into #JobStateName values (11, 'Killed');
insert into #JobStateName values (12, 'Completed w/ one or more errors');
insert into #JobStateName values (13, 'System Kill Pending');
insert into #JobStateName values (14, 'Suspended');
insert into #JobStateName values (15, 'Queued');
insert into #JobStateName values (16, 'Queued');
insert into #JobStateName values (17, 'Running (cannot be verified');
insert into #JobStateName values (18, 'Abnormal Terminated Cleanup');
insert into #JobStateName values (19, 'Completed w/ one or more warnings');
insert into #JobTypeName values (1, 'Full');
insert into #JobTypeName values (2, 'Incremental');
insert into #JobTypeName values (4, 'Differential');
insert into #JobTypeName values (8, 'Any Level');
insert into #JobTypeName values (64, 'Synthetic Full');
insert into #JobTypeName values (128, 'Synthetic Full');
insert into #JobTypeName values (256, 'Trans. Log No Trunc.');
insert into #JobTypeName values (512, 'ASR');
insert into #JobTypeName values (1024, 'Offline Full');
insert into #JobTypeName values (2048, 'Create Snapshot');
insert into #JobTypeName values (4096, 'Create QR Volume');
insert into #JobTypeName values (8192, 'Update QR Volume');
insert into #JobTypeName values (16384, 'Synthetic Full');
insert into #JobTypeName values (32768, 'Online Full');
insert into #JobTypeName values (131072, 'SRM Analysis');
insert into #JobTypeName values (262144, 'SRM Discovery')
Select jobID, case (select COUNT(*) from #JobOperationName where runningBackups.opType = #JobOperationName.opType)
		when 0 then
		     (select JMOpTable.opName from JMOpTable where runningBackups.opType = JMOpTable.operation and JMOpTable.appTypeType = runningBackups.appTypeId)
		else
			(select #JobOperationName.OpName from #JobOperationName where runningBackups.opType = #JobOperationName.opType)
		end as "OperationType",
(select jobtypename from #JobTypeName where runningBackups.bkpLevel = jobType) as JobType, combPriority as Priority,
clientName, instanceName, backupSetName, subclientname, currentPhaseName, currentPolicyName as storagePolicyName, mediaAgentName, jobDescription, DelayReason, UserName, fromTime,
(select stateName from #JobStateName where runningBackups.state = stateType) as StateName, jobStartTime, percentcomplete, filesXfered as FilesTransfered
from RunningBackups runningBackups
Union ALL
Select jobID, case (select COUNT(*) from #JobOperationName where runningAdminJobs.opType = #JobOperationName.opType)
		when 0 then
		     (select JMOpTable.opName from JMOpTable where runningAdminJobs.opType = JMOpTable.operation and JMOpTable.appTypeType = runningAdminJobs.appType)
		else
			(select #JobOperationName.OpName from #JobOperationName where runningAdminJobs.opType = #JobOperationName.opType)
		end as "OperationType",
(select jobtypename from #JobTypeName where RunningAdminJobs.ER_BkpLevel = jobType) as JobType, combPriority as Priority,
		clientName, instanceName, backupSetName, subclientname, currentPhaseName,
storagePolicyName, null as mediaAgentName, jobDescription, DelayReason, UserName, fromTime,
(select stateName from #JobStateName where runningAdminJobs.state = stateType) as StateName, jobStartTime, percentcomplete, NULL as FilesTransfered
from RunningAdminJobs runningAdminJobs
Union ALL
Select jobID, case (select COUNT(*) from #JobOperationName where runningRestores.opType = #JobOperationName.opType)
		when 0 then
		     (select JMOpTable.opName from JMOpTable where runningRestores.opType = JMOpTable.operation and JMOpTable.appTypeType = runningRestores.appType)
		else
			(select #JobOperationName.OpName from #JobOperationName where runningRestores.opType = #JobOperationName.opType)
		end as "OperationType",
NULL as JobType, combPriority as Priority,
		NULL as clientName, NULL as instance, null as backupSetName, null as subclientname,
currentPhaseName, null as storagePolicyName, mediaAgent, jobDescription, DelayReason,
UserName, null as fromTime, (select stateName from #JobStateName where runningRestores.state = stateType) as StateName, jobStartTime, percentcomplete, NULL as FilesTransfered
from RunningRestores runningRestores
drop table #JobOperationName
drop table #JobStatename
drop table #JobTypeName
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_getAllRunningJobs')
	delete from GxQscripts where name = 'QS_getAllRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_getAllRunningJobs')
	delete from GXDBVersions where aliasname = 'QS_getAllRunningJobs'
GO

insert into GXDBVersions values(2, 'QS_getAllRunningJobs',  '00000000000000000000', 'QS_getAllRunningJobs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_getAllRunningJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetAllRunningJobs
'
 + CHAR(10) + '--   script_name :GetAllRunningJobs'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClientInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClientInfo')
	drop procedure QS_GetClientInfo
IF EXISTS (select * from GxQscripts where name='QS_GetClientInfo')
	delete from GxQscripts where name = 'QS_GetClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientInfo')
	delete from GXDBVersions where aliasname = 'QS_GetClientInfo'
GO
print '... Creating Procedure: QS_GetClientInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClientInfo
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-------------------------------------------
 --				NO INPUT				--
-------------------------------------------
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetClientInfo'
DECLARE @propName varchar(32)
SET @propName = 'Active Physical Node'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
------------ No error handling ---------------
SELECT C.Name, ISNULL(C.net_hostName, 'Not Applicable') as 'Host Name', sSOS.name as 'OS',
			CASE(C.status & 2 )
			WHEN (2) THEN 'NO'
			ELSE (CASE(C.status & 4 ) WHEN(4) THEN 'NO' ELSE 'YES' END)END
			as 'ACTIVE' FROM APP_Client C
		 	join simOperatingSystem AS sSOS on sSOS.id = C.simOperatingSystemId
		 	WHERE C.simOperatingSystemId <> 0
			AND C.Id IN (SELECT clientId FROM APP_Platform WHERE platformType = 4)		--Check whether the client package is there for this client
			AND C.Id NOT IN (SELECT PMClientId FROM APP_VMToPMMap WHERE VMClientId = 2)	--Check whether this client is a physical machine for a cluster CS
 SET @lastError = @@error
 IF @lastError <> 0
 BEGIN
	SET @localErrorMsg = 'Error: Query Unsucess full'
	GOTO ARGS_ERROR
 END
--PRINT @scriptName + ' completed at '
--         + Convert(varchar(60), getdate()) + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClientInfo')
	delete from GxQscripts where name = 'QS_GetClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientInfo')
	delete from GXDBVersions where aliasname = 'QS_GetClientInfo'
GO

insert into GXDBVersions values(2, 'QS_GetClientInfo',  '00000000000000000000', 'QS_GetClientInfo', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClientInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn GetClient_Info.sql
'
 + CHAR(10) + '--   script_name : GetClientInfo'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClientDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClientDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClientDescription')
	drop procedure QS_GetClientDescription
IF EXISTS (select * from GxQscripts where name='QS_GetClientDescription')
	delete from GxQscripts where name = 'QS_GetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_GetClientDescription'
GO
print '... Creating Procedure: QS_GetClientDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClientDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
----------------------------------------------
--SET @clientName = 'bingo'
----------------------------------------------
----------------------- const   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetClientDescription'
DECLARE @propName varchar(32)
SET @propName  = 'User Description'
--------------------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
--------------------- Input validation    -------------
if(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
IF(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------------- Get Descrition   -------------
SELECT ClientDescription from APP_Client  where id = @clientId
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClientDescription')
	delete from GxQscripts where name = 'QS_GetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_GetClientDescription'
GO

insert into GXDBVersions values(2, 'QS_GetClientDescription',  '00000000000000000000', 'QS_GetClientDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClientDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetClientDescription.sql -si client_name
'
 + CHAR(10) + '--   script_name : GetClientDescription'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClientGroup')
	drop procedure QS_GetClientGroup
IF EXISTS (select * from GxQscripts where name='QS_GetClientGroup')
	delete from GxQscripts where name = 'QS_GetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_GetClientGroup'
GO
print '... Creating Procedure: QS_GetClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClientGroup
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @param1 nvarchar(1030) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs--------------------
--DECLARE @param1  NVARCHAR(1030)
--SET @param1 = '%s'
------------------input prefixes-------------------------
DECLARE @clientPrefix  NVARCHAR(32)
SET @clientPrefix = 'c='
DECLARE @cGroupPrefix NVARCHAR(32)
SET @cGroupPrefix = 'cg='
----------------------script Name-------------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'GetClientGroup'
-----------------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @param1 = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Please provide client name or client group name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters------------------------------
DECLARE @clientName NVARCHAR(1024)
SET @clientName = ''
DECLARE @cGroupName NVARCHAR(1024)
SET @cGroupName = ''
IF SUBSTRING(@param1, 1, 2) = @clientPrefix
	SET @clientName =  SUBSTRING(@param1, 3, LEN(@param1)-2)
ELSE IF SUBSTRING(@param1, 1, 3) = @cGroupPrefix
	SET @cGroupName =  SUBSTRING(@param1, 4, LEN(@param1)-3)
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']'
	GOTO ARGS_ERROR
END
IF @clientName = '' AND @cGroupName = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']. Please provide client name or client name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters II------------------------------
DECLARE @clientId integer
SET @ClientId = ISNULL((SELECT id FROM app_client WHERE name = @clientName), 0)
DECLARE @clientGroupId integer
SET @clientGroupId = ISNULL((SELECT id FROM app_clientgroup WHERE name like @cGroupName), 0)
IF @clientName <> '' AND @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+ @clientName +'] does not exist.'
	GOTO ARGS_ERROR
END
IF @cGroupName <> '' AND @clientGroupId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client Group ['+ @cGroupName +'] does not exist.'
	GOTO ARGS_ERROR
END
------------------------get clients/client groups------------------------
IF @clientGroupId > 0
	SELECT C.name as 'Client' FROM APP_client C INNER JOIN APP_ClientGroupAssoc CG
				ON C.id = CG. clientId
				WHERE CG.clientGroupId = @clientGroupId
ELSE
	SELECT G.name as 'Client Group' FROM APP_clientGroup G INNER JOIN APP_ClientGroupAssoc CG
				ON G.id = CG. clientgroupId
				WHERE CG.clientId = @clientId
ARGS_ERROR:
print @scriptName + 'completed at '	+ Convert(varchar(60), getdate())+' with parameters client 	['+ @clientName +'] or client group ['+ @cGroupName +']. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClientGroup')
	delete from GxQscripts where name = 'QS_GetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_GetClientGroup'
GO

insert into GXDBVersions values(2, 'QS_GetClientGroup',  '00000000000000000000', 'QS_GetClientGroup', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetClientGroup.sql -si c=client_name/cg=client_group_name
'
 + CHAR(10) + '--   script_name : GetClientGroup'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClients <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClients')
	drop procedure QS_GetClients
IF EXISTS (select * from GxQscripts where name='QS_GetClients')
	delete from GxQscripts where name = 'QS_GetClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClients')
	delete from GXDBVersions where aliasname = 'QS_GetClients'
GO
print '... Creating Procedure: QS_GetClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClients
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-------------------------------------------
 --				NO INPUT				--
-------------------------------------------
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetClients'
DECLARE @propName varchar(32)
SET @propName = 'Active Physical Node'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
------------ No error handling ---------------
SELECT Name, ISNULL(net_hostName, 'Not Applicable') as 'IP'	FROM APP_Client
	WHERE status & 2 <> 2 AND status & 4 <> 4 and ID<>1
		AND Id IN (SELECT clientId FROM APP_Platform WHERE platformType = 4)		--Check whether the client package is there for this client
		AND Id NOT IN (SELECT PMClientId FROM APP_VmToPMMap WHERE VMClientId = 2)	--Check whether this client is a physical machine for a cluster CS
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClients')
	delete from GxQscripts where name = 'QS_GetClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClients')
	delete from GXDBVersions where aliasname = 'QS_GetClients'
GO

insert into GXDBVersions values(2, 'QS_GetClients',  '00000000000000000000', 'QS_GetClients', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClients',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetClients.sql 
'
 + CHAR(10) + '--   script_name : GetClients'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableSCActivityControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableSCActivityControl <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableSCActivityControl')
	drop procedure QS_EnableSCActivityControl
IF EXISTS (select * from GxQscripts where name='QS_EnableSCActivityControl')
	delete from GxQscripts where name = 'QS_EnableSCActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSCActivityControl')
	delete from GXDBVersions where aliasname = 'QS_EnableSCActivityControl'
GO
print '... Creating Procedure: QS_EnableSCActivityControl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableSCActivityControl
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @param1 varchar(100) = '%s',
  @param2 varchar(100) = '%s',
  @param3 varchar(100) = '%s',
  @param4 varchar(100) = '%s',
  @param5 varchar(100) = '%s',
  @activity varchar(10) = '%s'
AS
SET NOCOUNT ON
--SET @param1 = 'c=stargate'
--SET @param2 = 'a=Q_LINUX_FS'
--SET @param3 = 'b=defaultbackupset'
--SET @param4 = 's=sc'
--SET @param5 = '%s'
--SET @activity = '0'
--select @activity, @param1, @param2, @param3, @param4, @param5
-----------------------------------------
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'EnableSCActivityControl'
DECLARE @activityInt INT
--DECLARE @nowTime   integer
--SET       @nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
IF @activity = '0'
BEGIN
	SET @activityInt = 1
END
ELSE IF @activity = '1'
BEGIN
	SET @activityInt = 0
END
ELSE
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Invalid option to enable/disable activity.'
    GOTO ARGS_ERROR
END
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
    SET @errorCode = 1
    SET @errorString  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
    GOTO ARGS_ERROR
END
EXECUTE @errorCode = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
    @subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @errorString OUTPUT
IF @errorCOde != 0
BEGIN
    GOTO ARGS_ERROR
END
--------------------------apptype and default subclient checks..------------------------
IF ((SELECT SubclientStatus & 2 FROM APP_APPLICATION WHERE id = @subclientid) = 2  OR
(SELECT SubclientStatus & 4 FROM APP_APPLICATION WHERE id = @subclientid) = 4 )
BEGIN
    SET @errorCode = 1
    SET @errorString  = 'Error. Subclient is deleted or deconfigured.'
    GOTO ARGS_ERROR
END
--SELECT @activityInt,@subclientId
--BACKUP 0x4
exec dbo.APPSetActivityControlSubClientProp 0x4,@activityInt,@subclientId
ARGS_ERROR:
print @scriptName + ' completed at '    + Convert(varchar(60), getdate())+'. ErrorCode ('+  Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableSCActivityControl')
	delete from GxQscripts where name = 'QS_EnableSCActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSCActivityControl')
	delete from GXDBVersions where aliasname = 'QS_EnableSCActivityControl'
GO

insert into GXDBVersions values(2, 'QS_EnableSCActivityControl',  '00000000000000000000', 'QS_EnableSCActivityControl', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EnableSCActivityControl',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn EnableSCActivityControl.sql -si c=client_name -si a=Ida_type -si i=instanceName -si b=backupsetName -si s=subclient_name -si activity(0/1)
'
 + CHAR(10) + '--   script_name : EnableSCActivityControl'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateQSDKSession.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UpdateQSDKSession <<<'

IF EXISTS (select * from sysobjects where name='sec_UpdateQSDKSession')
	drop procedure sec_UpdateQSDKSession
IF EXISTS (select * from GxQscripts where name='sec_UpdateQSDKSession')
	delete from GxQscripts where name = 'sec_UpdateQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpdateQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_UpdateQSDKSession'
GO
print '... Creating Procedure: sec_UpdateQSDKSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UpdateQSDKSession
  @sessions XML
AS
	declare @iSession int
	exec sp_xml_preparedocument @iSession OutPut, @sessions
	select * into #TobeUpdated from OpenXml(@iSession,'/App_UpdateSessionDetailsRequest/sessionDetails', 1) with (guid uniqueidentifier , lastAccesstime bigint )
	update session set session.lastAccessedTime =  u.lastAccesstime from UMQSDKSessions session join #TobeUpdated u on session.GUID = u.guid;
	exec sp_xml_removedocument @iSession
	select GUID from UMQSDKSessions
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateQSDKSession')
	delete from GxQscripts where name = 'sec_updateQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_updateQSDKSession'
GO

insert into GXDBVersions values(2, 'sec_updateQSDKSession',  '00000000000000000000', 'sec_updateQSDKSession', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getMyDataApplications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getMyDataApplications <<<'

IF EXISTS (select * from sysobjects where name='sec_getMyDataApplications')
	drop procedure sec_getMyDataApplications
IF EXISTS (select * from GxQscripts where name='sec_getMyDataApplications')
	delete from GxQscripts where name = 'sec_getMyDataApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMyDataApplications')
	delete from GXDBVersions where aliasname = 'sec_getMyDataApplications'
GO
print '... Creating Procedure: sec_getMyDataApplications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getMyDataApplications
  @userId integer,
  @myDataApplications XML output
AS
declare @isVMExist bit;
declare @isDriveExist bit;
declare @sharePointExist bit;
declare @mailExist bit;
declare @computerExist bit;
declare @sharesExist bit;
declare @isSyncAllowed bit;
declare @out_xml XML
declare @GUID VARCHAR(255)
declare @userMailBoxXML XML
declare @userDelegatedMailBoxXML XML
declare @fsCount int
declare @syncCount int
declare @excludeStatusMaskForSync int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
DECLARE @edgeClientsWithCapabilities TABLE(clientId INT, clientStatus INT, capabilities BIGINT)
DECLARE @clientId int
DECLARE @t_userCaps TABLE(caps bigint)
DECLARE @i_userCaps bigint
IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT Null DROP TABLE #tempLaptopSecurityObjects
create table  #tempLaptopSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	  EXEC sec_getUserObjects @userId, 2009, 0, '#tempLaptopSecurityObjects'
CREATE TABLE  #clientList
(
	cId                           int not null,
	status						  int not null
)
IF Exists(
SELECT um.clientId
							FROM UMOwnerCredentials um
							INNER JOIN App_ClientProp prop on prop.componentNameId = um.clientId
							WHERE attrName = 'Virtual Server Discovered Clients' AND modified = 0
							AND um.userId = @userId
			)
	BEGIN
		set @isVMExist = 1
	End
Else
	set @isVMExist = 0
If exists(
			SELECT TOP 1 AAP.id FROM APP_BackupSetProp ABP INNER JOIN App_Application AAP
			ON ABP.componentNameId = AAP.backupset
			WHERE 1 = 1
			AND ABP.attrName = 'Edge Drive User Id'
			AND ABP.attrVal = CAST(@userId AS NVARCHAR(256))
			AND ABP.modified =0
			)
		BEGIN
			set @isDriveExist = 1
		END
ELSE
	BEGIN
		INSERT INTO @edgeClientsWithCapabilities
		EXEC AppGetEdgeCapabilties @userId, NULL
		SET @clientId = ISNULL((SELECT TOP 1 EC.clientId
							FROM @edgeClientsWithCapabilities  EC
							INNER JOIN App_EdgeDriveAssociation EDA ON EDA.clientId = EC.clientId AND EDA.entityType = 11 AND EDA.entityId > 1
							WHERE capabilities & 4112 = 4112 -- Client with upload and browse capability
							--AND (@clientToUse = 0 OR EC.clientId = @clientToUse)
							ORDER BY (EC.clientStatus & 0x40000000) DESC), 0)
		IF(@clientId > 0)
		BEGIN
			SET @isDriveExist = 1
		END
		ELSE
			set @isDriveExist = 0
	END
IF EXISTS(
				SELECT C.id
				FROM APP_Client C
				INNER JOIN APP_IDAName i
				ON i.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(55,0)) and c.id = i.clientId
				JOIN #tempLaptopSecurityObjects t on t.clientId in (c.id , 0)
			)
		BEGIN
			set @sharePointExist = 1
		END
ELSE
			set @sharePointExist = 0
Insert into #clientList(cId, status) select  um.clientId, C.Status
            FROM   UMOwnerCredentials um
             JOIN APP_IDAName ida on ida.clientId = um.clientId AND (  1 = 1 AND ida.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and ida.appTypeId <> 13 )
			JOIN APP_Client C on C.id = um.clientId
            WHERE um.userId = @userId
select @fsCount = count(*) from #clientList
IF(@fsCount > 0)
		BEGIN
			set @computerExist = 1
		END
ELSE
	BEGIN
		INSERT INTO @t_UserCaps execute GetUserCapabilities @userId
		set @i_userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
		IF( @i_userCaps & CONVERT(bigint, (POWER(2.0, 7  -1))) <> 0 )
		BEGIN
			set @computerExist = 1
		END
		ELSE
			set @computerExist = 0
	END
select @syncCount = count(*) from #clientList where (status & 4096 = 4096) and (status & @excludeStatusMaskForSync = 0)
IF(@syncCount > 1)
		BEGIN
			set @isSyncAllowed = 1
		END
ELSE
			set @isSyncAllowed = 0
select @GUID = userGuid from UMUsers where id = @userId
EXEC    [dbo].AppGetLaptopUserMailBox @GUID ,@userid, @userMailBoxXML OUTPUT
EXEC [dbo].AppGetLaptopUserDelegatedMailBox '', @userId, @userDelegatedMailBoxXML output
select MailBoxId = Tab.Col.value('(mailBoxId)[1]', 'int')
into #tmpDelegatedMailBox
from @userDelegatedMailBoxXML.nodes('/userDeletegatedMailBoxes') Tab(Col)
select MailBoxId = Tab.Col.value('(mailBoxId)[1]', 'int')
into #tmpMailBox
from @userMailBoxXML.nodes('/userMailBoxes') Tab(Col)
If Exists(select * from #tmpMailBox) or Exists(select * from #tmpDelegatedMailBox)
	BEGIN
		set @mailExist = 1
	END
ELSE
		set @mailExist = 0
drop table #tmpMailBox
drop table #tmpDelegatedMailBox
exec AppSharingDoesUserHaveSharedFolder @userId, @sharesExist output
set @out_xml = (select @isVMExist as '@IsVMEnabled'
				, @isDriveExist as '@IsDriveEnabled'
				, @sharePointExist as '@IsSharePointEnabled'
				, @mailExist as '@IsEmailEnabled'
				, @computerExist as '@IsComputersEnabled'
				, @sharesExist as '@IsSharesEnabled'
				, @isSyncAllowed as '@IsSyncAllowed'
	   FOR XML PATH('myDataApplications'))
select @myDataApplications = @out_xml
GO


IF EXISTS (select * from GxQscripts where name = 'sec_getMyDataApplications')
	delete from GxQscripts where name = 'sec_getMyDataApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMyDataApplications')
	delete from GXDBVersions where aliasname = 'sec_getMyDataApplications'
GO

insert into GXDBVersions values(2, 'sec_getMyDataApplications',  '00000000000000000000', 'sec_getMyDataApplications', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getAuxiliaryApplications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getAuxiliaryApplications <<<'

IF EXISTS (select * from sysobjects where name='sec_getAuxiliaryApplications')
	drop procedure sec_getAuxiliaryApplications
IF EXISTS (select * from GxQscripts where name='sec_getAuxiliaryApplications')
	delete from GxQscripts where name = 'sec_getAuxiliaryApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAuxiliaryApplications')
	delete from GXDBVersions where aliasname = 'sec_getAuxiliaryApplications'
GO
print '... Creating Procedure: sec_getAuxiliaryApplications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getAuxiliaryApplications
  @userId integer,
  @applications integer,
  @outXML XML output
AS
declare @myDataApps_xml XML
declare @analyticsApps_xml XML
if @applications & 1 = 1
BEGIN
	exec sec_getMyDataApplications @userId, @myDataApps_xml output
	exec sec_getAnalyticsApplications @userId, @analyticsApps_xml output
END
if @applications & 1073741823 = 1073741823
	BEGIN
		set @outXML = (select @myDataApps_xml, @analyticsApps_xml for XML PATH('auxiliaryAppLicenses'))
	END
else
	BEGIN
		set @outXML = (select @myDataApps_xml, @analyticsApps_xml FOR XML PATH(''), ROOT('DM2ContentIndexing_AuxiliaryApplicationResponse'))
	END
select @outXML
GO


IF EXISTS (select * from GxQscripts where name = 'sec_getAuxiliaryApplications')
	delete from GxQscripts where name = 'sec_getAuxiliaryApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAuxiliaryApplications')
	delete from GXDBVersions where aliasname = 'sec_getAuxiliaryApplications'
GO

insert into GXDBVersions values(2, 'sec_getAuxiliaryApplications',  '00000000000000000000', 'sec_getAuxiliaryApplications', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetDoNotBackupDBName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetDoNotBackupDBName <<<'

IF EXISTS (select * from sysobjects where name='QS_GetDoNotBackupDBName')
	drop procedure QS_GetDoNotBackupDBName
IF EXISTS (select * from GxQscripts where name='QS_GetDoNotBackupDBName')
	delete from GxQscripts where name = 'QS_GetDoNotBackupDBName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetDoNotBackupDBName')
	delete from GXDBVersions where aliasname = 'QS_GetDoNotBackupDBName'
GO
print '... Creating Procedure: QS_GetDoNotBackupDBName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetDoNotBackupDBName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-------------------------------------------
 --				NO INPUT				--
-------------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET	@scriptName				= 'GetDoNotBackupDBName'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0
Select client =C.name, A.subclientname , DbName =p.attrName
From APP_Client C, App_application A, app_subclientprop p
Where a.clientId = C.id and p.componentNameId = a.id and a.subclientname like 'Do Not Backup'
	and p.attrtype =118 and p.modified =0
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetDoNotBackupDBName')
	delete from GxQscripts where name = 'QS_GetDoNotBackupDBName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetDoNotBackupDBName')
	delete from GXDBVersions where aliasname = 'QS_GetDoNotBackupDBName'
GO

insert into GXDBVersions values(2, 'QS_GetDoNotBackupDBName',  '00000000000000000000', 'QS_GetDoNotBackupDBName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetDoNotBackupDBName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn GetDoNotBackupDBName.sql
'
 + CHAR(10) + '--   script_name : GetDoNotBackupDBName'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TFA_CheckConfigResp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =============================================
-- Author:		Imtiaz Mohammad
-- Create date: 07/15/2013
-- Description:	Return the user and server settings to the UI for validation while enabling TFA
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TFA_CheckConfigResp <<<'

IF EXISTS (select * from sysobjects where name='TFA_CheckConfigResp')
	drop procedure TFA_CheckConfigResp
IF EXISTS (select * from GxQscripts where name='TFA_CheckConfigResp')
	delete from GxQscripts where name = 'TFA_CheckConfigResp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_CheckConfigResp')
	delete from GXDBVersions where aliasname = 'TFA_CheckConfigResp'
GO
print '... Creating Procedure: TFA_CheckConfigResp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TFA_CheckConfigResp
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @usrid int = 0,
  @xmlText XML
AS
BEGIN
SET NOCOUNT ON
	SET @xmlText = (
			SELECT
			(SELECT ISNULL(email, '') '@emailId' from UMUsers where id=@usrid FOR XML PATH('userDetails'), TYPE),
			(SELECT ISNULL(smtpServer, '') '@emailServer' from APP_CommCell where id = 2 FOR XML PATH('serverDetails'), TYPE)
			FOR XML PATH(''),
			ROOT('App_TFACheckConfigResp')
		)
	SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'TFA_CheckConfigResp')
	delete from GxQscripts where name = 'TFA_CheckConfigResp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_CheckConfigResp')
	delete from GXDBVersions where aliasname = 'TFA_CheckConfigResp'
GO

insert into GXDBVersions values(2, 'TFA_CheckConfigResp',  '00000000000000000000', 'TFA_CheckConfigResp', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteTFASecretForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteTFASecretForUser <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteTFASecretForUser')
	drop procedure QS_DeleteTFASecretForUser
IF EXISTS (select * from GxQscripts where name='QS_DeleteTFASecretForUser')
	delete from GxQscripts where name = 'QS_DeleteTFASecretForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteTFASecretForUser')
	delete from GXDBVersions where aliasname = 'QS_DeleteTFASecretForUser'
GO
print '... Creating Procedure: QS_DeleteTFASecretForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DeleteTFASecretForUser
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @user varchar(510) = ''
AS
SET NOCOUNT ON
DECLARE @ErrorCode      INT = 0
DECLARE @ErrorString    varchar(512)
IF(@user = '')
BEGIN
	SET @ErrorString    =   'Error: Parameter user is empty'
	SET @ErrorCode      =   1
	GOTO SCRIPT_EXIT
END
DELETE UMUsersProp WHERE componentNameId IN (SELECT id FROM UMUsers WHERE login = @user) AND attrName IN ('secret', 'OTP')
SCRIPT_EXIT:
if @ErrorCode <> 0
	Raiserror(@ErrorString,
				15,  --Severity (> 10 to force DOS Error Code = 1)
				1    --State
			)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteTFASecretForUser')
	delete from GxQscripts where name = 'QS_DeleteTFASecretForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteTFASecretForUser')
	delete from GXDBVersions where aliasname = 'QS_DeleteTFASecretForUser'
GO

insert into GXDBVersions values(2, 'QS_DeleteTFASecretForUser',  '00000000000000000000', 'QS_DeleteTFASecretForUser', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteTFASecretForUser',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn QS_DeleteTFASecretForUser -si @user = ''login'''
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_MergeOMLInfo.sp] ---------- 

-- -----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_MergeOMLInfo.sp,v $ $Id: TapeImport_MergeOMLInfo.sp,v 1.3 2014/07/24 20:48:53 kbora Exp $";
--
--  +========================================================================+
--  | Stored Precedure: TapeImport_MergeOMLInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TapeImport_MergeOMLInfo <<<'

IF EXISTS (select * from sysobjects where name='TapeImport_MergeOMLInfo')
	drop procedure TapeImport_MergeOMLInfo
IF EXISTS (select * from GxQscripts where name='TapeImport_MergeOMLInfo')
	delete from GxQscripts where name = 'TapeImport_MergeOMLInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeOMLInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeOMLInfo'
GO
print '... Creating Procedure: TapeImport_MergeOMLInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TapeImport_MergeOMLInfo
  @i_xmlStr xml,
  @MeidaId integer
AS
SET NOCOUNT ON
  DECLARE @CommCellId integer
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
	DECLARE @Application nvarchar(1024)
	DECLARE @BarCode nvarchar(1024)
	DECLARE @CheckSum nvarchar(1024)
	DECLARE @CopyID nvarchar(1024)
	DECLARE @DRPassword nvarchar(1024)
	DECLARE @DRUserName nvarchar(1024)
	DECLARE @FlushBlockSizeKB INT
	DECLARE @LabelGUID nvarchar(1024)
	DECLARE @LabelType nvarchar(1024)
	DECLARE @LabelVersion nvarchar(1024)
	DECLARE @LastMediaBarCode nvarchar(1024)
	DECLARE @LastMediaID nvarchar(1024)
	DECLARE @LastMediaSideName nvarchar(1024)
	DECLARE @MMSCommCellId INT
	DECLARE @MagicNumber nvarchar(1024)
	DECLARE @MediaCreationTime INT
	DECLARE @MediaGroupID nvarchar(1024)
	DECLARE @UniqueMediaID nvarchar(1024)
	DECLARE @MediaName nvarchar(1024)
	DECLARE @SideName nvarchar(1024)
	DECLARE @StoragePolicyId nvarchar(1024)
	DECLARE @Vendor nvarchar(1024)
	DECLARE @VolId INT
	DECLARE @flag bit
	SELECT
	 @Application=(doc.col.value('@Application', 'nvarchar(1024)')),
	 @BarCode=(doc.col.value('@BarCode', 'nvarchar(1024)')),
	 @CheckSum=(doc.col.value('@CheckSum', 'nvarchar(1024)')),
	 @CopyID=(doc.col.value('@CopyID', 'nvarchar(1024)')),
	 @DRPassword=(doc.col.value('@DRPassword', 'nvarchar(1024)')),
	 @DRUserName=(doc.col.value('@DRUserName', 'nvarchar(1024)')),
	 @FlushBlockSizeKB =(doc.col.value('@FriendlyName', 'INT')),
	 @LabelGUID=(doc.col.value('@LabelGUID', 'nvarchar(1024)')),
	 @LabelType=(doc.col.value('@LabelType', 'nvarchar(1024)')),
	 @LabelVersion=(doc.col.value('@LabelVersion', 'nvarchar(1024)')),
	 @LastMediaBarCode=(doc.col.value('@LastMediaBarCode', 'nvarchar(1024)')),
	 @LastMediaID=(doc.col.value('@LastMediaID', 'nvarchar(1024)')),
	 @LastMediaSideName=(doc.col.value('@LastMediaSideName', 'nvarchar(1024)')),
	 @MMSCommCellId=(doc.col.value('@MMSCommCellId', 'INT')),
	 @MagicNumber=(doc.col.value('@MagicNumber', 'nvarchar(1024)')),
	 @MediaCreationTime=(doc.col.value('@MediaCreationTime', 'INT')),
	 @MediaGroupID=(doc.col.value('@MediaGroupID', 'nvarchar(1024)')),
	 @UniqueMediaID=(doc.col.value('@MediaID', 'nvarchar(1024)')),
	 @MediaName=(doc.col.value('@MediaName', 'nvarchar(1024)')),
	 @SideName=(doc.col.value('@SideName', 'nvarchar(1024)')),
	 @StoragePolicyId=(doc.col.value('@StoragePolicyId', 'nvarchar(1024)')),
	 @VolId=(doc.col.value('@VolId', 'INT')),
	 @Vendor=(doc.col.value('@Vendor', 'nvarchar(1024)'))
	FROM @i_xmlStr.nodes('/MediaManager_OMLInfo') doc(col)
BEGIN TRANSACTION TRAN_Merge_OML
	DECLARE @OrigMeidaId INT
	DECLARE @MaxCCId INT
	SET @errorString='Media Lable Information successfully merged into CommServ Database'
--get MediaId from XML
	SELECT @OrigMeidaId=CAST(reverse(substring(reverse(@UniqueMediaID),0,charindex('_',reverse(@UniqueMediaID)))) AS INT)
--Create new CommCell Entry in App_CommCell table if Media is from foreign CommCell
	IF	@MMSCommCellId =-1
	BEGIN
		SET @errorString = 'ERROR:The Media is from Unlicenced CommCell, It Can not be Catalogued  '
		GOTO CX_ERROR_EXIT
	END
	IF NOT EXISTS (
			SELECT id
			FROM APP_CommCell WHERE number=@MMSCommCellId
	)
	BEGIN
		INSERT INTO APP_CommCell VALUES(
		@MMSCommCellId,0,1,'TapeImportedCommCell_',2,0,'','','','','',0,0,'','','',1
		)
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: OMLInfo_Merge --Failed to create new entry in App_CommCell table'
			GOTO CX_ERROR_EXIT
		END
		UPDATE APP_CommCell
		SET aliasName=aliasName+CAST(id AS VARCHAR(10))
		WHERE @MMSCommCellId=number
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: OMLInfo_Merge --Failed to update aliasName in App_CommCell table'
			GOTO CX_ERROR_EXIT
		END
	END
	SET @CommCellId = ISNULL ((SELECT id FROM APP_CommCell WHERE number=@MMSCommCellId), 0)
	UPDATE MMMedia
	SET UniqueId=@UniqueMediaID,
		CreationTime=@MediaCreationTime,
		origCCcommCellID=@CommCellId,
		origCCmediaID = CASE WHEN @CommCellId = 2 THEN  mediaId ELSE @OrigMeidaId END -- This is required becuase in same CommCell scenerio in DR case, media id will be different
	FROM MMMedia WHERE MediaId=@MeidaId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: OMLInfo_Merge --Failed to Update MMMedia Table'
		GOTO CX_ERROR_EXIT
	END
	UPDATE MMVolume
	SET origCCvolumeID = CASE WHEN @CommCellId = 2 THEN  volumeId ELSE @VolId END, -- This is required becuase in same CommCell scenerio in DR case, media id will be different
		origCCcommCellID=@CommCellId,
		FlushBlockSizeKB = @FlushBlockSizeKB,
		ReformatTime = @MediaCreationTime
	FROM MMVolume WHERE MediaId=@MeidaId
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: OMLInfo_Merge --Failed to Update MMVolume Table'
		GOTO CX_ERROR_EXIT
	END
	IF  EXISTS ( SELECT 1 FROM MMMediaSide WHERE MediaId=@MeidaId )
		BEGIN
			UPDATE MMMediaSide
			SET IsOMLValid=1,
				IsOMLWritten=2
			WHERE MediaId=@MeidaId
		END
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: OMLInfo_Merge --Failed to Update MMMediaSide Table'
		GOTO CX_ERROR_EXIT
	END
	COMMIT  TRANSACTION TRAN_Merge_OML
	SELECT  @CommCellId,0, @errorString
	RETURN	(0)
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TRAN_Merge_OML
	RAISERROR ('%s' , 16, 1, @errorString)
	SELECT @CommCellId,-1, @errorString
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'TapeImport_MergeOMLInfo')
	delete from GxQscripts where name = 'TapeImport_MergeOMLInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeOMLInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeOMLInfo'
GO

insert into GXDBVersions values(2, 'TapeImport_MergeOMLInfo',  '00010003000000000000', 'TapeImport_MergeOMLInfo', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_MergeCMTInfo.sp] ---------- 

-- -----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_MergeCMTInfo.sp,v $ $Id: TapeImport_MergeCMTInfo.sp,v 1.7 2015/06/05 16:54:48 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: TapeImport_MergeCMTInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TapeImport_MergeCMTInfo <<<'

IF EXISTS (select * from sysobjects where name='TapeImport_MergeCMTInfo')
	drop procedure TapeImport_MergeCMTInfo
IF EXISTS (select * from GxQscripts where name='TapeImport_MergeCMTInfo')
	delete from GxQscripts where name = 'TapeImport_MergeCMTInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeCMTInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeCMTInfo'
GO
print '... Creating Procedure: TapeImport_MergeCMTInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TapeImport_MergeCMTInfo
  @i_xmlStr xml,
  @CommCellId int,
  @MediaId int
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
------------------ChunkmapTrailer Inofrmation---------------------
DECLARE @CMTVersion TINYINT
DECLARE @TrailerSize VARCHAR(100)
DECLARE @NumberOfArchFilesInChunk INT
DECLARE @CCIdInCMT INT
DECLARE @ChunkId BIGINT
DECLARE @ArchGroupId SMALLINT
DECLARE @CopyId SMALLINT
DECLARE @StreamId INT
DECLARE @MediaGroupId INT
DECLARE @FileMarkNumber INT
DECLARE @VolumeId INT
DECLARE @TotalPhysicalChunkSize BIGINT
DECLARE @TotalLogicalChunkSize BIGINT
DECLARE @GalaxyVersion VARCHAR(100)
DECLARE @uniqueMediaIdString VARCHAR(100)
DECLARE @HwEncKey VARCHAR(100)
DECLARE @SIDBEngineId VARCHAR(100)
--------------------AFile Information -----------------------------
DECLARE @ArchFileId INT
DECLARE @IsArchFileClosed INT
DECLARE @AppId INT
DECLARE @JobId INT
DECLARE @CreateJobId VARCHAR(100)
DECLARE @AppTypeId INT
DECLARE @BackupLevel INT
DECLARE @BackupTime VARCHAR(100)
DECLARE @FileType TINYINT
DECLARE @FileSeqNo VARCHAR(100)
DECLARE @ClientName VARCHAR(100)
DECLARE @ArchiveFileName VARCHAR(MAX)
DECLARE @ChunkSeqNumber INT
DECLARE @PhysicalSizeInChunk BIGINT
DECLARE @LogicalSizeInChunk BIGINT
DECLARE @PhysicalOffsetForChunk BIGINT
DECLARE @LogicalOffsetForChunk BIGINT
DECLARE @EncryptionType INT
DECLARE @NeedPassPhrase INT
DECLARE @DataEncKey NVARCHAR(MAX)
DECLARE @RsaPriKey NVARCHAR(MAX)
DECLARE @ObjNameForNAS VARCHAR(100)
DECLARE @ObjNameVersionForNAS VARCHAR(100)
--Get ChunkMapTrailer Info
	SELECT
	 @CMTVersion=(doc.col.value('@version', 'TINYINT')),
	 @TrailerSize=(doc.col.value('@trailerSize', 'nvarchar(100)')),
	 @NumberOfArchFilesInChunk=(doc.col.value('@archFileCount', 'INT')),
	 @CCIdInCMT=(doc.col.value('@commCellId', 'nvarchar(100)')),
	 @ChunkId=(doc.col.value('@chunkId', 'BIGINT')),
	 @ArchGroupId=(doc.col.value('@archGroupId', 'SMALLINT')),
	 @CopyId=(doc.col.value('@copyId', 'SMALLINT')),
	 @StreamId=(doc.col.value('@streamId', 'INT')),
	 @MediaGroupId=(doc.col.value('@mediaGroupId', 'INT')),
	 @FileMarkNumber=(doc.col.value('@fileMarkerNo', 'INT')),
	 @VolumeId=(doc.col.value('@volumeId', 'INT')),
	 @TotalPhysicalChunkSize=(doc.col.value('@totalPhysicalSize', 'BIGINT')),
	 @TotalLogicalChunkSize=(doc.col.value('@totalLogicalSize', 'BIGINT')),
	 @GalaxyVersion=(doc.col.value('@galaxyVersion', 'nvarchar(100)')),
	 @uniqueMediaIdString=(doc.col.value('@uniqueMediaId', 'nvarchar(1000)')),
	 @HwEncKey=(doc.col.value('@hwEncKey', 'nvarchar(1000)')),
	 @SIDBEngineId=(doc.col.value('@sidbEngineId', 'nvarchar(1000)'))
	FROM @i_xmlStr.nodes('/MediaManager_ChunkMapTrailerInfo') doc(col)
DECLARE @ClientId INT
DECLARE @SubClientName VARCHAR(100)
DECLARE @ArchGroupName VARCHAR(100)
DECLARE @CopyName VARCHAR(100)
DECLARE @EncKeyLen SMALLINT
DECLARE @ArchFileSize BIGINT
DECLARE @SizeOnMedia BIGINT
DECLARE @NextClientPropId INT
DECLARE @OrigMediaId INT
SELECT @OrigMediaId=CAST(reverse(substring(reverse(@uniqueMediaIdString),0,charindex('_',reverse(@uniqueMediaIdString)))) AS INT)
IF @CommCellId = 2
BEGIN
	SET @OrigMediaId = @MediaId
	SELECT @VolumeId = VolumeId FROM MMVolume WHERE MediaId = @MediaId
END
SET @NextClientPropId = 1
DECLARE @dummyGUID VARCHAR(100)
SET @dummyGUID = '00000000-0000-0000-0000-000000000000'
------------------------CCM_APP_CommCell Table------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_APP_CommCell)
		BEGIN
			INSERT INTO CommServ_Convert..CCM_APP_CommCell
			SELECT A.* FROM APP_CommCell A WHERE id = @CommCellId
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_APP_CommCell TABLE'
				GOTO RETURN_ERROR
			END
			UPDATE CommServ_Convert..CCM_APP_CommCell
			SET id = 2
			WHERE id = @CommCellId
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO UPDATE CCM_APP_CommCell TABLE'
				GOTO RETURN_ERROR
			END
		END
IF @@ERROR>0
		BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_APP_CommCell TABLE'
				GOTO RETURN_ERROR
		END
-----------------------CCM_APP_CustomCalendar-------------------------------------------------------
IF NOT EXISTS (SELECT * FROM CommServ_Convert..CCM_APP_CustomCalendar)
BEGIN
		INSERT INTO CommServ_Convert..CCM_APP_CustomCalendar VALUES (
			1,'Standard',0,1,0,0,1,1,0,0,2,@dummyGUID )
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_APP_CustomCalendar TABLE'
			GOTO RETURN_ERROR
		END
END
-------------------------------------------CCM_MMVolume-----------------------------------------------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_MMVolume WHERE VolumeId = @VolumeId )
BEGIN
	INSERT INTO CommServ_Convert..CCM_MMVolume
	SELECT * FROM MMVolume WHERE origCCvolumeId=@VolumeId AND origCCcommCellID = @CommCellId
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to insert into CommServ_Convert..CCM_MMVolume'
		GOTO RETURN_ERROR
	END
	UPDATE 	CommServ_Convert..CCM_MMVolume
	SET		VolumeId = @VolumeId,MediaId = @OrigMediaId,origCCcommCellID = 2
	WHERE 	origCCvolumeId=@VolumeId AND origCCcommCellID = @CommCellId
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CommServ_Convert..CCM_MMVolume'
		GOTO RETURN_ERROR
	END
END
-------------------------------------------CCM_MMMedia-------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_MMMedia WHERE MediaID=@OrigMediaId)
BEGIN
		INSERT INTO CommServ_Convert..CCM_MMMedia
		SELECT * FROM MMMedia WHERE origCCmediaId = @OrigMediaId AND origCCcommCellID = @CommCellId
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to insert into CommServ_Convert..CCM_MMMedia'
			GOTO RETURN_ERROR
		END
		UPDATE 	CommServ_Convert..CCM_MMMedia
		SET		MediaId = @OrigMediaId,origCCcommCellID = 2
		WHERE 	origCCmediaId = @OrigMediaId AND origCCcommCellID = @CommCellId
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to update CommServ_Convert..CCM_MMVolume'
			GOTO RETURN_ERROR
		END
END
---------------------------------------------------------------------------------------------------------------------------------------------
--Get AFile Info
	DECLARE ArchFileInfo_Cursor CURSOR LOCAL FAST_FORWARD FOR
	SELECT
		 (doc.col.value('@ArchFileId', 'INT')),
		 (doc.col.value('@IsArchFileClosed', 'INT')),
		 (doc.col.value('@AppId', 'INT')),
		 (doc.col.value('@JobId', 'INT')),
		 (doc.col.value('@CreateJobId', 'nvarchar(100)')),
		 (doc.col.value('@AppType', 'INT')),
		 (doc.col.value('@BackupLevel', 'INT')),
		 (doc.col.value('@BackupTime', 'nvarchar(100)')),
		 (doc.col.value('@FileType', 'TINYINT')),
		 (doc.col.value('@FileSeqNo', 'nvarchar(100)')),
		 (doc.col.value('@ClientName', 'nvarchar(100)')),
		 (doc.col.value('@ArchiveFileName', 'nvarchar(MAX)')),
		 (doc.col.value('@ChunkSeqNumber', 'INT')),
		 (doc.col.value('@PhysicalSizeInChunk', 'BIGINT')),
		 (doc.col.value('@LogicalSizeInChunk', 'BIGINT')),
		 (doc.col.value('@PhysicalOffsetForChunk', 'BIGINT')),
		 (doc.col.value('@LogicalOffsetForChunk', 'BIGINT')),
		 (doc.col.value('@EncryptionType', 'INT')),
		 (doc.col.value('@NeedPassPhrase', 'INT')),
		 (doc.col.value('@DataEncKey', 'nvarchar(MAX)')),
		 (doc.col.value('@RsaPriKey', 'nvarchar(MAX)')),
		 (doc.col.value('@ObjNameForNAS', 'nvarchar(1000)')),
		 (doc.col.value('@ObjNameVersionForNAS', 'nvarchar(1000)'))
		FROM @i_xmlStr.nodes('/MediaManager_ChunkMapTrailerInfo/ArchFileInfoList') doc(col)
OPEN ArchFileInfo_Cursor
		FETCH NEXT FROM ArchFileInfo_Cursor INTO @ArchFileId,@IsArchFileClosed,@AppId,@JobId,@CreateJobId,
								 @AppTypeId, @BackupLevel, @BackupTime, @FileType, @FileSeqNo, @ClientName, @ArchiveFileName,
								 @ChunkSeqNumber, @PhysicalSizeInChunk, @LogicalSizeInChunk, @PhysicalOffsetForChunk,
								 @LogicalOffsetForChunk, @EncryptionType, @NeedPassPhrase, @DataEncKey, @RsaPriKey, @ObjNameForNAS, @ObjNameVersionForNAS
WHILE (@@FETCH_STATUS = 0)
	BEGIN
-----------------------GetClient Id-----------------------------------------------
	IF EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_APP_Client WHERE name=@ClientName)
		BEGIN
			SELECT @ClientId= id FROM CommServ_Convert..CCM_APP_Client WHERE name=@ClientName
		END
	ELSE IF EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_APP_Client)
		BEGIN
			SELECT @ClientId= MIN(id) FROM CommServ_Convert..CCM_APP_Client
			SET @ClientId=@ClientId-1
		END
	ELSE SET @ClientId=-10
----------------------------------------CCM_APP_Client table----------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_APP_Client WHERE id = @ClientId ) AND @FileType=1 --For index client name will be different ,it will be MA name
		BEGIN
			INSERT INTO CommServ_Convert..CCM_APP_Client VALUES(
						@ClientId,@ClientName,0,'','',0,0,0,0,'','','',0,0,0,0,0,0,0,0,2,@dummyGUID,0,'')
			IF @@ERROR>0
					BEGIN
						SET @errorString='FAILED TO INSERT INTO CCM_APP_Client TABLE'
						GOTO RETURN_ERROR
					END
			SET @NextClientPropId = ISNULL ( (SELECT MAX(id) FROM CommServ_Convert..CCM_APP_ClientProp),1)
			IF @RsaPriKey <> ''
			BEGIN
				INSERT INTO CommServ_Convert..CCM_APP_ClientProp VALUES (@NextClientPropId,@ClientId,'Encrypt: rsaPriKeyBPF',1,@RsaPriKey,dbo.GetUnixTime(getutcdate()),0,0)
				IF @@ERROR>0
						BEGIN
							SET @errorString='FAILED TO INSERT INTO CCM_APP_ClientProp TABLE for rsaPriKeyBPF'
							GOTO RETURN_ERROR
						END
				INSERT INTO CommServ_Convert..CCM_APP_ClientProp VALUES (@NextClientPropId+1,@ClientId,'Encrypt: rsaPubKey',	1,	@RsaPriKey,dbo.GetUnixTime(getutcdate()),0,0)
				IF @@ERROR>0
						BEGIN
							SET @errorString='FAILED TO INSERT INTO CCM_APP_ClientProp TABLE for rsaPubKey'
							GOTO RETURN_ERROR
						END
			END
		END
--------------------------------------CCM_APP_Application table--------------------------------------------------------
	IF @AppId=1 AND @CommCellId = 2
		SET @AppTypeId=1000
	IF NOT EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_APP_Application WHERE id=@AppId ) -- AND @AppTypeId<>1
	BEGIN
		SET @SubClientName='TapeImportSubClient_'+CAST(@AppId AS VARCHAR(10))
		INSERT INTO CommServ_Convert..CCM_APP_Application VALUES(
					@AppId,@ClientId,@AppTypeId,0,0,0,@ArchGroupId,@ArchGroupId,0,0,@SubClientName,0,0,0,2,@dummyGUID)
		IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_APP_Application TABLE'
				GOTO RETURN_ERROR
			END
	END
-------------------------------------CCM_archGroup table------------------------------------------------------------------
	SET @ArchGroupName='TapeImportSP_'+CAST(@ArchGroupId AS VARCHAR(10))
	IF NOT EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_archGroup WHERE id=@ArchGroupId)
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archGroup VALUES(
					@ArchGroupId,@CopyId,@ArchGroupName,'Created by tape import',10,1,0,2,@ArchGroupId,0,0,-1,-1,0,'',0,'',0,'')
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archGroup TABLE'
			GOTO RETURN_ERROR
		END
	END
------------------------------------CCM_archGroupCopy table------------------------------------------------------------------
		--SET MAXMULTIPLEX
	SET @CopyName='TapeImportCopy_SP'+CAST(@ArchGroupId AS VARCHAR(10))+'_Copy'+CAST(@CopyId AS VARCHAR(10))
	SET @EncKeyLen=LEN(@DataEncKey)
	IF NOT EXISTS ( SELECT 1 FROM CommServ_Convert..CCM_archGroupCopy WHERE id=@CopyId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archGroupCopy VALUES(
					@CopyId,@ArchGroupId,1,'PRIMARY',0,0,1,1,0,0,0,0,2,@CopyId,0,0,0,0,1,0,0,0,0,0,0,0,0,0,'',0,0,1,0,0,0,0,0,16,0,0,'')
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archGroupCopy TABLE'
			GOTO RETURN_ERROR
		END
	END
----------------------------------CCM_archFile table-----------------------------------------------------------------------------
--is ObjNameForNAS == ObjName ??
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_archFile WHERE id=@ArchFileId )
	BEGIN
	INSERT INTO CommServ_Convert..CCM_archFile VALUES(
				@ArchFileId,@ArchiveFileName,2,@ArchGroupId,'N/A',0,@AppId,@FileType,@BackupTime,@JobId,@BackupLevel,1,0,0,0)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archFile TABLE'
			GOTO RETURN_ERROR
		END
	END
	----------------------------------CCM_archFileCopy table---------------------------------------------------------------------------
		/* Mapping for EncKeyType as we are not writing actual type on media
		BLOWFISH	2----->2
		AES			3----->4
		TWO FISH	5----->9
		3-DES		6----->10
		SERPENT		4----->6
		GOST		8----->11
		*/
		SELECT
		@EncryptionType = CASE @EncryptionType
                         WHEN 2 THEN 2
                         WHEN 3 THEN 4
                         WHEN 4 THEN 6
                         WHEN 5 THEN 9
                         WHEN 6 THEN 10
						 WHEN 8 THEN 11
						 ELSE @EncryptionType
                     END
		IF EXISTS
		(
		SELECT 1
		FROM CommServ_Convert..CCM_archFileCopy
		WHERE archFileId=@ArchFileId AND archCopyId = @CopyId
		)
		BEGIN
			UPDATE CommServ_Convert..CCM_archFileCopy
			SET physicalSize=physicalSize+@PhysicalSizeInChunk,
				logicalSize=logicalSize+@LogicalSizeInChunk,
				lastChunkNumber= CASE WHEN lastChunkNumber>@ChunkSeqNumber THEN lastChunkNumber ELSE @ChunkSeqNumber END
			WHERE archFileId=@ArchFileId AND archCopyId = @CopyId
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO UPDATE INTO CCM_archFileCopy TABLE'
				GOTO RETURN_ERROR
			END
		END
		ELSE
		BEGIN
			DECLARE @encRSA INT = 0
			IF LEN(@RsaPriKey) > 10
				SET @encRSA = 1
			IF (@NeedPassPhrase & 2) > 0
				SET @encRSA = (@encRSA | 2)
			INSERT INTO CommServ_Convert..CCM_archFileCopy VALUES(
						@ArchFileId,2,@CopyId,0,1,1,@ChunkSeqNumber,@PhysicalSizeInChunk,@LogicalSizeInChunk,0,
						@encRSA,@EncryptionType,@DataEncKey,0,0,0)
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_archFileCopy TABLE'
				GOTO RETURN_ERROR
			END
		END
-------------------------------------CCM_archChunk table------------------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_archChunk WHERE id=@ChunkId)
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archChunk VALUES(
					@ChunkId,2,@VolumeId,@FileMarkNumber,0,@CMTVersion,'',@TotalPhysicalChunkSize,@TotalLogicalChunkSize,0,0,0,@HwEncKey,0,2)
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_archChunk TABLE'
				GOTO RETURN_ERROR
			END
	END
------------------------------------CCM_archChunkMapping table-------------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_archChunkMapping WHERE @ChunkId=archChunkId AND @ArchFileId=archFileId AND archCopyId = @CopyId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_archChunkMapping VALUES(
					@ChunkId,@ArchFileId,2,@CopyId,@ChunkSeqNumber,@PhysicalOffsetForChunk,@LogicalOffsetForChunk,@PhysicalSizeInChunk,@LogicalSizeInChunk,
					0,0,0,0,2,@JobId,-1)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_archChunkMapping TABLE'
			GOTO RETURN_ERROR
		END
	END
-----------------------------------------CCM_JMJobStats table ----------------------------------------------------------------------------
	IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_JMJobStats WHERE jobId=@JobId )
	BEGIN
		INSERT INTO CommServ_Convert..CCM_JMJobStats VALUES(
					@JobId,2,
					CASE @AppTypeId WHEN 1000 THEN 11 ELSE 4 END,
					2,0,'','',0,'')
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_JMJobStats TABLE'
			GOTO RETURN_ERROR
		END
	END
----------------------------------------CCM_JMJobDataStats table------------------------------------------------------------------------
	IF EXISTS(SELECT 1 FROM CommServ_Convert..CCM_JMJobDataStats WHERE jobId=@JobId AND archGrpCopyId=@CopyId AND dataType=@FileType)
		BEGIN
		UPDATE CommServ_Convert..CCM_JMJobDataStats
		SET sizeOnMedia+=@PhysicalSizeInChunk
		WHERE jobId=@JobId AND archGrpCopyId=@CopyId  AND dataType=@FileType
		IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO UPDATE INTO CCM_JMJobDataStats TABLE'
				GOTO RETURN_ERROR
			END
		END
	ELSE
		BEGIN
			INSERT INTO CommServ_Convert..CCM_JMJobDataStats VALUES(
						@JobId,@ArchGroupId,@CopyId,@FileType,4,0,100,0,@AppId,2,0,0,0,0,0,0,0,0,@PhysicalSizeInChunk,0,0)
			IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO INSERT INTO CCM_JMJobDataStats TABLE'
				GOTO RETURN_ERROR
			END
		END
------------------------------------------------------CCM_JMAdminJobStatsTable table---------------------------------------------------------------
	IF @AppTypeId=1000
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM CommServ_Convert..CCM_JMAdminJobStatsTable WHERE jobId=@JobId )
		BEGIN
			INSERT INTO CommServ_Convert..CCM_JMAdminJobStatsTable VALUES(
						@JobId,11,1,0,0,@ArchGroupId,@ArchGroupName,0,0,0,0,0,'CommServ','',0,'',0,0,0,0,'',@CopyId,0,0,'admin',0,0,0,
						2,@AppId,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'',0)
		END
		IF @@ERROR>0
			BEGIN
				SET @errorString='FAILED TO insert into CCM_JMAdminJobStatsTable TABLE'
				GOTO RETURN_ERROR
			END
	END
------------------------------------------------------CCM_JMBkpStats table---------------------------------------------------------------------------
	IF @AppTypeId<>1000
	BEGIN
		IF EXISTS(SELECT 1 FROM CommServ_Convert..CCM_JMBkpStats WHERE jobId=@JobId )
			BEGIN
			UPDATE CommServ_Convert..CCM_JMBkpStats
			SET totalBackupSize+=@PhysicalSizeInChunk,
				totalUncompBytes+=@LogicalSizeInChunk
			WHERE jobId=@JobId
			IF @@ERROR>0
				BEGIN
					SET @errorString='FAILED TO UPDATE CCM_JMBkpStats TABLE'
					GOTO RETURN_ERROR
				END
			END
		--Check Status,Data Status
		ELSE
			BEGIN
				INSERT INTO CommServ_Convert..CCM_JMBkpStats VALUES(
							@JobId,2,@AppId,@AppTypeId,0,@ArchGroupId,0,@BackupLevel,0,1,0,1,0,0,
							4,1,0,'',0,0,0,0,0,0,'',0,0,0,@LogicalSizeInChunk,0,0,@ArchGroupId,0,0,0,0,NULL,0,0,0,0,0,0,0,0,0,0,0,0,
							@PhysicalSizeInChunk,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0)
				IF @@ERROR>0
				BEGIN
					SET @errorString='FAILED TO INSERT INTO CCM_JMBkpStats TABLE'
					GOTO RETURN_ERROR
				END
			END
	END
/*
-----------------------------------------------------------CCM_TI_AllArchiveFilesAndChunks-----------------------------------------------------
IF NOT EXISTS (SELECT 1 FROM CCM_TI_AllArchiveFilesAndChunks WHERE archFileId=@ArchFileId AND copyId=@CopyId AND chunkId=@ChunkId )
BEGIN
		INSERT INTO CCM_TI_AllArchiveFilesAndChunks VALUES(
						@JobId,@ArchFileId,@CopyId,@FileType,@ChunkId,2,@ChunkSeqNumber,@IsArchFileClosed)
		IF @@ERROR>0
		BEGIN
			SET @errorString='FAILED TO INSERT INTO CCM_TI_AllArchiveFilesAndChunks TABLE'
			GOTO RETURN_ERROR
		END
END
*/
FETCH NEXT FROM ArchFileInfo_Cursor INTO @ArchFileId,@IsArchFileClosed,@AppId,@JobId,@CreateJobId,
									 @AppTypeId, @BackupLevel, @BackupTime, @FileType, @FileSeqNo, @ClientName, @ArchiveFileName,
									 @ChunkSeqNumber, @PhysicalSizeInChunk, @LogicalSizeInChunk, @PhysicalOffsetForChunk,
									 @LogicalOffsetForChunk, @EncryptionType, @NeedPassPhrase, @DataEncKey, @RsaPriKey, @ObjNameForNAS, @ObjNameVersionForNAS
END
CLOSE ArchFileInfo_Cursor
DEALLOCATE ArchFileInfo_Cursor
	SET @errorString = 'Successfully populated the convert db with ChunkMapTrailers for CommCellId ['+CAST(@CommCellId AS VARCHAR(100)) + ']'
	SELECT  0, @errorString
	RETURN	(0)
RETURN_ERROR:
	RAISERROR ('%s' , 16, 1, @errorString)
    SELECT -1, @errorString
    RETURN	(-1)

IF EXISTS (select * from GxQscripts where name = 'TapeImport_MergeCMTInfo')
	delete from GxQscripts where name = 'TapeImport_MergeCMTInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_MergeCMTInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_MergeCMTInfo'
GO

insert into GXDBVersions values(2, 'TapeImport_MergeCMTInfo',  '00010007000000000000', 'TapeImport_MergeCMTInfo', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_TapeImportMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: kbora
--  Date:   25/12/2013
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Precedure: Drop all mapping table. Create new if asked by input.
--  +========================================================================+
-- $Id: CCM_TapeImportMap.sp,v 1.3 2015/05/08 07:31:24 kbora Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_TapeImportMap <<<'

IF EXISTS (select * from sysobjects where name='CCM_TapeImportMap')
	drop procedure CCM_TapeImportMap
IF EXISTS (select * from GxQscripts where name='CCM_TapeImportMap')
	delete from GxQscripts where name = 'CCM_TapeImportMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_TapeImportMap')
	delete from GXDBVersions where aliasname = 'CCM_TapeImportMap'
GO
print '... Creating Procedure: CCM_TapeImportMap'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_TapeImportMap
  @creatNewTable integer
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_MAP_Client')
        DROP TABLE CCM_TI_MAP_Client
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_MAP_Client
		(
			old_clientId			INT,
			new_clientId			INT,
			clientName				VARCHAR(1024),
			osType					INT
		)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_MAP_backupSet')
        DROP TABLE CCM_TI_MAP_backupSet
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_MAP_backupSet
		(
			old_backupSetId			INT,
			new_backupSetId			INT,
			old_clientId			INT,
			new_clientId			INT,
			clientName				VARCHAR(1024),
			instanceId				INT,
			appTypeId				INT,
			backupSetGUID           VARCHAR(1024)
		)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_MAP_archGroup')
        DROP TABLE CCM_TI_MAP_archGroup
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_MAP_archGroup
		(
			old_archGroupId				INT,
			new_archGroupId				INT
		)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_MAP_archGroupCopy')
        DROP TABLE CCM_TI_MAP_archGroupCopy
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_MAP_archGroupCopy
		(
			old_CopyId				INT,
			new_CopyId				INT,
			old_archGroupId			INT,
			new_archGroupId			INT
		)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_MAP_Application')
        DROP TABLE CCM_TI_MAP_Application
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_MAP_Application
		(
			old_appId				INT,
			new_appId				INT,
			appTypeId				INT,
			old_clientId			INT,
			new_clientId			INT,
			old_backupSetId			INT,
			new_backupSetId			INT,
			old_archGroupId			INT,
			new_archGroupId			INT,
			instanceId				INT,
			clientName				VARCHAR(200),
			subClientGUID           VARCHAR(1024)
		)
/*
	------------Create table to find out whether all the medias are catalogued for given archFile---------------
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_AllArchiveFiles')
        DROP TABLE CCM_TI_AllArchiveFiles
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_AllArchiveFiles
			(
			jobId	INT,
			archFileId INT,
			copyId INT,
			fileType INT,
			CommCellId INT,
			isArchFileClose INT,
			isChunkSeqMatched INT
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_TI_AllArchiveFilesAndChunks')
        DROP TABLE CCM_TI_AllArchiveFilesAndChunks
	IF @creatNewTable > 0
		CREATE TABLE CCM_TI_AllArchiveFilesAndChunks
			(
			jobId	INT,
			archFileId INT,
			copyId INT,
			fileType INT,
			chunkId		INT,
			CommCellId INT,
			chunkSeqNo INT,
			isArchFileClose INT
			)
	*/
		SELECT  0,'CCM_TapeImportMap proc Successful'
		RETURN	0

IF EXISTS (select * from GxQscripts where name = 'CCM_TapeImportMap')
	delete from GxQscripts where name = 'CCM_TapeImportMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_TapeImportMap')
	delete from GXDBVersions where aliasname = 'CCM_TapeImportMap'
GO

insert into GXDBVersions values(2, 'CCM_TapeImportMap',  '00010003000000000000', 'CCM_TapeImportMap', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_GetMissingEntityInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: kbora
--  Date:   25/12/2013
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_GetMissingEntityInfo.sp,v $ $Id: TapeImport_GetMissingEntityInfo.sp,v 1.4 2015/05/08 07:31:14 kbora Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TapeImport_GetMissingEntityInfo <<<'

IF EXISTS (select * from sysobjects where name='TapeImport_GetMissingEntityInfo')
	drop procedure TapeImport_GetMissingEntityInfo
IF EXISTS (select * from GxQscripts where name='TapeImport_GetMissingEntityInfo')
	delete from GxQscripts where name = 'TapeImport_GetMissingEntityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_GetMissingEntityInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_GetMissingEntityInfo'
GO
print '... Creating Procedure: TapeImport_GetMissingEntityInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TapeImport_GetMissingEntityInfo
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
	INSERT INTO CCM_TI_MAP_Client
	SELECT id,0,name,0
	FROM Commserv_Merge..CCM_APP_Client
	INSERT INTO CCM_TI_MAP_archGroup
	SELECT id,0
	FROM Commserv_Merge..CCM_archGroup
	INSERT INTO CCM_TI_MAP_archGroupCopy
	SELECT id,0,archGroupId,0
	FROM Commserv_Merge..CCM_archGroupCopy
	INSERT INTO CCM_TI_MAP_Application
	SELECT id,0,appTypeId,clientId,0,0,0,dataArchGrpID,0,0,'',''
	FROM Commserv_Merge..CCM_APP_Application
	UPDATE CCM_TI_MAP_Application
	SET clientName=B.name
	FROM CCM_TI_MAP_Application A, Commserv_Merge..CCM_APP_Client B
	WHERE A.old_clientId=B.id
	IF OBJECT_ID('tempdb..#WinCompatibleAppTypes') IS NOT NULL
		DROP TABLE #WinCompatibleAppTypes
	CREATE TABLE #WinCompatibleAppTypes ( appTypeId INT)
	INSERT INTO #WinCompatibleAppTypes
	SELECT DISTINCT A.type
	FROM APP_iDAType A, APP_AppTypeGroupAssoc B
	WHERE B.appGroupId=57 AND A.displayName LIKE '%File System%' AND A.type = B.appTypeId
	IF OBJECT_ID('tempdb..#WinAppTypes') IS NOT NULL
	DROP TABLE #WinAppTypes
	CREATE TABLE #WinAppTypes ( appTypeId INT)
	INSERT INTO #WinAppTypes
	SELECT distinct appTypeId FROM APP_AppTypeGroupAssoc where appGroupId in (
	select appTypeGroupId from APP_AppTypeGroup where groupName like '%windows%')
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to Insert into WinAppTypes table'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('tempdb..#UnixAppTypes') IS NOT NULL
	DROP TABLE #UnixAppTypes
    CREATE TABLE #UnixAppTypes ( appTypeId INT)
	INSERT INTO #UnixAppTypes
	SELECT distinct appTypeId FROM APP_AppTypeGroupAssoc where appGroupId in (
	select appTypeGroupId from APP_AppTypeGroup where groupName like '%unix%')
	IF @@ERROR>0
	BEGIN
	SET @errorString='Failed to Insert into UnixAppTypes table'
	GOTO CX_ERROR_EXIT
	END
	DECLARE @CommCellId INT
	SET @CommCellId = ISNULL ( (SELECT TOP 1 B.id  FROM CommServ_Merge..CCM_APP_CommCell A, CommServ..APP_CommCell B WHERE A.number = B.number  ), 0)
	IF @CommCellId = 0
	BEGIN
	SET @errorString='CommCell entry is not present in the Db..'
	GOTO CX_ERROR_EXIT
	END
	IF @CommCellId = 2
	BEGIN
		UPDATE CCM_TI_MAP_Application
		SET new_appId=B.id,new_clientId=B.clientId,new_backupSetId=B.backupSet,clientName=C.name,new_archGroupId=B.dataArchGrpID,appTypeId=B.appTypeId
		FROM CCM_TI_MAP_Application A, APP_Application B, APP_Client C
		WHERE B.id=A.old_appId AND B.clientId = C.id
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to update CCM_TI_MAP_Application --when applicatin exists on CS'
			GOTO CX_ERROR_EXIT
		END
	END
	UPDATE CCM_TI_MAP_Application
	SET new_appId=B.new_Id,new_clientId=C.clientId,new_backupSetId=C.backupSet,clientName=D.name,new_archGroupId=C.dataArchGrpID,appTypeId=C.appTypeId
	FROM CCM_TI_MAP_Application A,TapeImportMappings B, APP_Application C, APP_Client D
	WHERE A.old_appId=B.old_Id AND B.entityType=7 AND C.id=B.new_Id AND A.new_appId=0 AND C.clientId=D.id AND B.newCCId = @CommCellId
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_TI_MAP_Application --when applicatin exists in TapeImportMapping table'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_TI_MAP_Client
	SET	new_clientId=B.new_clientId
	FROM CCM_TI_MAP_Client A, CCM_TI_MAP_Application B
	WHERE A.old_clientId=B.old_clientId AND B.new_appId <> 0
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_TI_MAP_Client --when applicatin exists on CS'
		GOTO CX_ERROR_EXIT
	END
	-- this is needed when subclients already exists and jobs are imported with other appType
	UPDATE Commserv_Merge..CCM_APP_Application
	SET appTypeId = B.appTypeId
	FROM Commserv_Merge..CCM_APP_Application A, CCM_TI_MAP_Application B
	WHERE A.id = B.old_appId AND B.new_appId <> 0
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_APP_Application --when applicatin exists on CS'
		GOTO CX_ERROR_EXIT
	END
	-- this is needed when subclients already exists and jobs are imported with other appType
	UPDATE Commserv_Merge..CCM_JMBkpStats
	SET appType = B.appTypeId
	FROM Commserv_Merge..CCM_JMBkpStats A, CCM_TI_MAP_Application B
	WHERE A.appId = B.old_appId AND B.new_appId <> 0
	IF @@ERROR>0
	BEGIN
		SET @errorString='Failed to update CCM_JMBkpStats --applicatin exists on CS'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @AppId			INT
	DECLARE @new_AppId			INT
	DECLARE @AppType			INT
	DECLARE @ClientId			INT
	DECLARE @BackupSetId		INT
	DECLARE @archGroupId		INT
	DECLARE @copyId				INT
	DECLARE @ClientName			VARCHAR(100)
	DECLARE @nextBackupSetId	INT
	DECLARE @osType				INT
	DECLARE @CompatibleAppTypeId INT
	DECLARE @newClientId		INT
	DECLARE @newBackupSetId	    INT
	DECLARE @propValue			VARCHAR(100)
	DECLARE @dbGUID 			VARCHAR(256)
	DECLARE @backupSetGUID 		VARCHAR(256)
	DECLARE @subClientGUID 		VARCHAR(256)
	DECLARE @str1	VARCHAR(1024)
	DECLARE @str2	VARCHAR(1024)
	SET @nextBackupSetId = 0
	DECLARE ApplicationInfo CURSOR LOCAL FAST_FORWARD FOR
	SELECT old_appId,new_appId, appTypeId, old_clientId, clientName
	FROM CCM_TI_MAP_Application
	OPEN ApplicationInfo
	FETCH NEXT FROM ApplicationInfo
	INTO @AppId,@new_AppId, @AppType, @ClientId, @ClientName
	 WHILE @@FETCH_STATUS = 0
	 BEGIN
		SET @newClientId		=	0
		SET @newBackupSetId		=	0
		SET @osType				=	0
		SET @backupSetGUID		=	''
		SET @str1				=	''
		SET @str2				=	''
		SET @dbGUID				=	''
		SET @subClientGUID		=	''
		IF EXISTS(SELECT 1 FROM #WinAppTypes WHERE appTypeId = @AppType) OR @AppType = 1000
		BEGIN
			SET @osType=1
		END
		ELSE IF EXISTS(SELECT 1 FROM #UnixAppTypes WHERE appTypeId = @AppType)
			SET @osType=2
		ELSE
		BEGIN
			SET @errorString='Un supported appType found exiting..'
			GOTO CX_ERROR_EXIT
		END
		IF @AppType = 1000 OR @AppType = 1
		SET @AppType = 43
		SELECT @str1 = SUBSTRING(name,CHARINDEX('V1_',name)+3,256) FROM Commserv_Merge..CCM_archFile
		WHERE fileType = 2 AND name LIKE '%IdxLogs_%:%' AND appId = @AppId
		IF @str1 <> ''
		BEGIN
			SET @backupSetGUID = SUBSTRING(@str1,0, CHARINDEX(':',@str1))
			SET @str2 = SUBSTRING(@str1,CHARINDEX(':',@str1)+1,256)
			SET @dbGUID = SUBSTRING(@str2,0,CHARINDEX(':',@str2))
			SET @subClientGUID = SUBSTRING(@str2,CHARINDEX(':',@str2)+1,256)
			UPDATE CCM_TI_MAP_Application
			SET subClientGUID = @subClientGUID
			WHERE old_appId = @AppId
		END
		IF @new_AppId>0 AND @backupSetGUID <> '' AND EXISTS (SELECT id FROM APP_BackupSetName WHERE GUID = @backupSetGUID AND origCCId = @CommCellId)
		BEGIN
			-- when backupset exists and tape import creates new backupset if M1 has only data archfile. when M2 brings index archFile we should map to existing backupSet based on the GUID
			UPDATE APP_Application
			SET backupSet = (SELECT id FROM APP_BackupSetName WHERE GUID = @backupSetGUID AND origCCId = @CommCellId)
			WHERE id = @new_AppId
			GOTO END_LOOP
		END
		ELSE IF @new_AppId>0 GOTO END_LOOP
		-- if we come to this point means, subclient is not present. so we can not find client. here we have to make use of global params to decide of.
		SET @newClientId=ISNULL((	SELECT DISTINCT componentNameId FROM APP_ClientProp WHERE attrName='TapeImportClientProp' AND attrVal=@ClientName+'_'+CAST(@CommCellId AS VARCHAR(100))),0)
		IF @newClientId=0
		BEGIN
		SET @newClientId =  ISNULL(( SELECT A.id FROM APP_Client A INNER JOIN APP_CommCell B ON A.origCCId = B.id WHERE A.name = @ClientName AND B.id = @CommCellId ),0)
		END
		IF @newClientId<>0
		BEGIN
			UPDATE CCM_TI_MAP_Client
			SET	new_clientId=@newClientId
			FROM CCM_TI_MAP_Client
			WHERE clientName=@ClientName AND new_clientId=0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Client --when orig ccid is 2'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_TI_MAP_backupSet
			SET new_clientId=A.new_clientId,appTypeId = @AppType
			FROM CCM_TI_MAP_Client A, CCM_TI_MAP_backupSet B
			WHERE A.old_clientId=B.old_clientId AND A.new_clientId <> 0 AND B.new_clientId = 0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_backupSet --when orig ccid <> 2'
				GOTO CX_ERROR_EXIT
			END
			-- we always taking compatible appType, problem comes when one client has more than one agent. think about it when problem comes.
			IF @AppType IN ( SELECT appTypeId FROM #WinCompatibleAppTypes) AND @AppType NOT IN ( SELECT appTypeId FROM APP_Application WHERE clientId=@newClientId)
			BEGIN
				SET @AppType= ISNULL (( SELECT TOP 1 A.appTypeId
										FROM #WinCompatibleAppTypes A, APP_Application B
										WHERE A.appTypeId=B.appTypeId AND B.clientId=@newClientId),@AppType)
			END
			IF @backupSetGUID <> ''
			BEGIN
				SET @newBackupSetId = ISNULL ( (SELECT id FROM APP_BackupSetName WHERE GUID = @backupSetGUID AND origCCId = @CommCellId), 0)
			END
			ELSE IF @newBackupSetId = 0	AND @backupSetGUID <> ''
			BEGIN
				SET @newBackupSetId = ISNULL((	SELECT DISTINCT C.componentNameId
												FROM APP_Application A, APP_BackupSetName B, APP_BackupSetProp C
												WHERE A.clientId=@newClientId AND A.backupSet=B.id
												AND B.id=C.componentNameId AND C.attrName='TapeImportBackupSetProp'
												AND C.attrVal=CAST(@AppType AS VARCHAR(100))+'_'+CAST(@newClientId as VARCHAR(100))+'_'+CAST(@CommCellId AS VARCHAR(100))),0
											)
			END
			IF @newBackupSetId = 0
			BEGIN
				IF @backupSetGUID <> ''
				BEGIN
					SET @newBackupSetId=ISNULL ((SELECT old_backupSetId FROM CCM_TI_MAP_backupSet WHERE backupSetGUID = @backupSetGUID ),0)
				END
				ELSE IF @newBackupSetId = 0
				BEGIN
					SET @newBackupSetId=ISNULL ((SELECT old_backupSetId FROM CCM_TI_MAP_backupSet WHERE appTypeId=@AppType AND old_clientId=@ClientId AND backupSetGUID = ''),0)
				END
				IF @newBackupSetId=0
				BEGIN
					SET @nextBackupSetId=@nextBackupSetId-1
					SET @newBackupSetId=@nextBackupSetId
					INSERT INTO CCM_TI_MAP_backupSet VALUES(
					@nextBackupSetId,0,@ClientId,@newClientId,@ClientName,1,@AppType,@backupSetGUID)
					IF @@ERROR>0
					BEGIN
						SET @errorString='Failed to INSERT CCM_TI_MAP_backupSet --when @CompatibleAppTypeId=0'
						GOTO CX_ERROR_EXIT
					END
				END
			END
			UPDATE CCM_TI_MAP_Application
			SET new_clientId=@newClientId,new_backupSetId=@newBackupSetId,appTypeId=@AppType,old_backupSetId=@newBackupSetId
			WHERE old_appId=@AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application --when applicatin not exists in TapeImportMapping table and no backup set exists'
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_APP_Application
			SET appTypeId=@AppType
			FROM Commserv_Merge..CCM_APP_Application
			WHERE id = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_APP_Application '
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_JMBkpStats
			SET appType= @AppType
			FROM Commserv_Merge..CCM_JMBkpStats A
			WHERE A.appId = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application -- when bakcup set exists and application does not exists, updating with right appTypeId '
				GOTO CX_ERROR_EXIT
			END
			IF NOT EXISTS(SELECT 1 FROM TapeImportMappings WHERE old_Id=@AppId AND entityType=7 AND newCCId=@CommCellId)
				BEGIN
					INSERT INTO TapeImportMappings
					SELECT old_appId,0,@CommCellId,7
					FROM CCM_TI_MAP_Application
					WHERE old_appId = @AppId AND new_appId = 0
					IF @@ERROR>0
					BEGIN
						SET @errorString='Failed to INSERT INTO TapeImportMappings '
						GOTO CX_ERROR_EXIT
					END
				END
		END
		ELSE
		BEGIN
			UPDATE CCM_TI_MAP_Client
			SET clientName=@ClientName,osType=@osType
			WHERE old_clientId=@ClientId AND new_clientId=0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Client'
				GOTO CX_ERROR_EXIT
			END
			IF @backupSetGUID <> ''
			BEGIN
				SET @newBackupSetId=ISNULL ((SELECT old_backupSetId FROM CCM_TI_MAP_backupSet WHERE backupSetGUID = @backupSetGUID ),0)
			END
			ELSE
			BEGIN
				SET @newBackupSetId=ISNULL ((SELECT old_backupSetId FROM CCM_TI_MAP_backupSet WHERE appTypeId=@AppType AND old_clientId=@ClientId AND backupSetGUID = ''),0)
			END
			IF @newBackupSetId=0
			BEGIN
				SET @nextBackupSetId=@nextBackupSetId-1
				SET @newBackupSetId=@nextBackupSetId
				INSERT INTO CCM_TI_MAP_backupSet VALUES(
				@nextBackupSetId,0,@ClientId,@newClientId,@ClientName,1,@AppType,@backupSetGUID)
			END
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to INSERT CCM_TI_MAP_backupSet --when applicatin not exist in  TapeImportMapping table but backup exists'
				GOTO CX_ERROR_EXIT
			END
			UPDATE CCM_TI_MAP_Application
			SET old_backupSetId=@newBackupSetId,clientName=@ClientName,appTypeId = @AppType -- AppType should be updated if appType is 1 or 1000
			WHERE old_appId=@AppId AND new_appId=0
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application when no client, no backupset'
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_APP_Application
			SET appTypeId=@AppType
			FROM Commserv_Merge..CCM_APP_Application
			WHERE id = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_APP_Application '
				GOTO CX_ERROR_EXIT
			END
			UPDATE Commserv_Merge..CCM_JMBkpStats
			SET appType= @AppType
			FROM Commserv_Merge..CCM_JMBkpStats A
			WHERE A.appId = @AppId
			IF @@ERROR>0
			BEGIN
				SET @errorString='Failed to update CCM_TI_MAP_Application -- when bakcup set exists and application does not exists, updating with right appTypeId '
				GOTO CX_ERROR_EXIT
			END
			IF NOT EXISTS(SELECT 1 FROM TapeImportMappings WHERE old_Id=@AppId AND entityType=7 AND newCCId=@CommCellId)
			BEGIN
				INSERT INTO TapeImportMappings
				SELECT old_appId,0,@CommCellId,7
				FROM CCM_TI_MAP_Application
				WHERE old_appId = @AppId AND new_appId = 0
				IF @@ERROR>0
				BEGIN
					SET @errorString='Failed to INSERT INTO TapeImportMappings '
					GOTO CX_ERROR_EXIT
				END
			END
		END
	END_LOOP:
	FETCH NEXT FROM ApplicationInfo
	INTO @AppId, @new_AppId, @AppType, @ClientId, @ClientName
	END
/*	-- Set subclient status to un-deleted, think about not to update existing subclientStatus flags.
	UPDATE APP_Application
	SET subclientStatus = 0
	FROM APP_Application A, CCM_TI_MAP_Application B
	WHERE A.id = B.new_appId */
	-- Needed this when synthetic backup job,incremental job is present on media, in this case media says one application present under two clients.
	DELETE CCM_TI_MAP_Client
	FROM CCM_TI_MAP_Client a
	WHERE a.old_clientId NOT IN (SELECT DISTINCT b.old_clientId FROM CCM_TI_MAP_Application b)
	IF @CommCellId=2
	BEGIN
		 UPDATE CCM_TI_MAP_ArchGroup
		 SET new_archGroupId = b.Id
		 FROM CCM_TI_MAP_archGroup a, archGroup b,Commserv_Merge..CCM_archGroup c
		 WHERE A.old_archGroupId=B.id AND b.id = c.id
		 IF @@ERROR>0
		 BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_ArchGroup --When commcell id is 2'
			GOTO CX_ERROR_EXIT
		 END
		 UPDATE CCM_TI_MAP_archGroupCopy
		 SET new_CopyId = B.id
		 FROM CCM_TI_MAP_archGroupCopy A,archGroupCopy B, Commserv_Merge..CCM_archGroupCopy C
		 WHERE A.old_CopyId = B.id AND B.id = C.id
		 IF @@ERROR>0
		 BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy --When commcell id is 2'
			GOTO CX_ERROR_EXIT
		 END
		 -- This is needed when sp is present but not copy
		 UPDATE CCM_TI_MAP_archGroupCopy
		 SET new_archGroupId = B.new_archGroupId
		 FROM CCM_TI_MAP_archGroupCopy A,CCM_TI_MAP_archGroup B
		 WHERE A.old_archGroupId = B.old_archGroupId
		 IF @@ERROR>0
		 BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy --When commcell id is 2'
			GOTO CX_ERROR_EXIT
		 END
	END
	DECLARE ArchGroupCopyInfo CURSOR LOCAL FAST_FORWARD FOR
	SELECT id,archGroupId
	FROM Commserv_Merge..CCM_archGroupCopy A, CCM_TI_MAP_archGroupCopy B
	WHERE A.id = B.old_CopyId AND B.new_CopyId = 0
	OPEN ArchGroupCopyInfo
	FETCH NEXT FROM ArchGroupCopyInfo
	INTO @copyId, @archGroupId
	WHILE @@FETCH_STATUS = 0
    BEGIN
		IF EXISTS  (    	SELECT 1
							FROM TapeImportMappings
							WHERE old_Id=@copyId AND entityType=18  AND newCCId=@CommCellId AND new_Id<>0
					)
				BEGIN
				UPDATE CCM_TI_MAP_archGroupCopy
				SET new_CopyId=C.id,new_archGroupId=C.archGroupId
				FROM CCM_TI_MAP_archGroupCopy A,TapeImportMappings B,archGroupCopy C
				WHERE A.old_CopyId=@copyId AND A.old_CopyId=B.old_Id AND B.entityType=18  AND B.new_Id=C.id and new_CopyId=0 AND B.newCCId = @CommCellId
				IF @@ERROR>0
				BEGIN
					SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy --TapeImportMappings'
					GOTO CX_ERROR_EXIT
				END
				UPDATE CCM_TI_MAP_archGroup
				SET new_archGroupId=B.new_archGroupId
				FROM CCM_TI_MAP_archGroup A, CCM_TI_MAP_archGroupCopy B
				WHERE A.old_archGroupId=B.old_archGroupId
				IF @@ERROR>0
				BEGIN
					SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroup --TapeImportMappings'
					GOTO CX_ERROR_EXIT
				END
			END
			IF NOT EXISTS(SELECT 1 FROM TapeImportMappings WHERE old_Id=@copyId AND entityType=18  AND newCCId=@CommCellId)
				BEGIN
					INSERT INTO TapeImportMappings
					SELECT old_CopyId,0,@CommCellId,18
					FROM CCM_TI_MAP_archGroupCopy
					WHERE old_CopyId=@copyId AND new_CopyId = 0
					IF @@ERROR>0
					BEGIN
						SET @errorString='Failed to INSERT INTO TapeImportMappings '
						GOTO CX_ERROR_EXIT
					END
				END
		FETCH NEXT FROM ArchGroupCopyInfo
		INTO @copyId, @archGroupId
	END
       -- The below two update statements are needed, when CCM brings the sp, copy we have to use orig ids to find sp,copy
		UPDATE CCM_TI_MAP_archGroup
		SET new_archGroupId = B.id
		FROM CCM_TI_MAP_archGroup A,archGroup B
		WHERE A.old_archGroupId = B.origCCarchGroupId AND B.origCCcommCellID = @CommCellId AND A.new_archGroupId = 0
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroup with archgroupId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_TI_MAP_archGroupCopy
		SET new_CopyId = B.id,new_archGroupId = B.archGroupId
		FROM CCM_TI_MAP_archGroupCopy A, archGroupCopy B
		WHERE A.old_CopyId = B.origCCarchCopyId AND B.origCCcommCellID = @CommCellId AND A.new_CopyId = 0
		IF @@ERROR>0
		BEGIN
			SET @errorString='Failed to UPDATE CCM_TI_MAP_archGroupCopy with archgroupId'
			GOTO CX_ERROR_EXIT
		END
		SET @errorString = 'TapeImportMissingInfo proc Successful'
		SELECT  0,@errorString
		RETURN
	CX_ERROR_EXIT:
		RAISERROR ('%s' , 16, 1, @errorString)
		SELECT -1, @errorString
		RETURN

IF EXISTS (select * from GxQscripts where name = 'TapeImport_GetMissingEntityInfo')
	delete from GxQscripts where name = 'TapeImport_GetMissingEntityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_GetMissingEntityInfo')
	delete from GXDBVersions where aliasname = 'TapeImport_GetMissingEntityInfo'
GO

insert into GXDBVersions values(2, 'TapeImport_GetMissingEntityInfo',  '00010004000000000000', 'TapeImport_GetMissingEntityInfo', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TapeImport_SetIndexingV2ClientProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TapeImport_SetIndexingV2ClientProperty.sp,v $ $Id: TapeImport_SetIndexingV2ClientProperty.sp,v 1.3 2015/05/08 07:31:18 kbora Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TapeImport_SetIndexingV2ClientProperty <<<'

IF EXISTS (select * from sysobjects where name='TapeImport_SetIndexingV2ClientProperty')
	drop procedure TapeImport_SetIndexingV2ClientProperty
IF EXISTS (select * from GxQscripts where name='TapeImport_SetIndexingV2ClientProperty')
	delete from GxQscripts where name = 'TapeImport_SetIndexingV2ClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_SetIndexingV2ClientProperty')
	delete from GXDBVersions where aliasname = 'TapeImport_SetIndexingV2ClientProperty'
GO
print '... Creating Procedure: TapeImport_SetIndexingV2ClientProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure TapeImport_SetIndexingV2ClientProperty
  @i_clientId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @MinCTime integer
DECLARE @MinCTimeInProp INT
SET @MinCTime = ISNULL(( SELECT MIN(A.cTime) FROM archFile A INNER JOIN APP_Application B ON A.appId = B.id WHERE B.clientId = @i_clientId AND A.name LIKE '%IdxLogs_V1%' ),0)
SET @MinCTimeInProp = ISNULL (( SELECT created FROM APP_ClientProp WHERE attrName LIKE 'IndexingV2' AND componentNameId = @i_clientId), -1)
IF @MinCTime > 0 AND @MinCTimeInProp = -1
BEGIN
	INSERT INTO APP_ClientProp
	SELECT @i_clientId, 'IndexingV2', 2, 1, @MinCTime, 0, 0
END
ELSE IF @MinCTime > 0 AND @MinCTime < @MinCTimeInProp
BEGIN
	UPDATE APP_ClientProp
	SET created = @MinCTime
	WHERE attrName LIKE 'IndexingV2' AND componentNameId = @i_clientId
END
-- When backupSet is missing but subclient is present, after creating new backupSet we need to update the APP_Application table with new backupSetId, and subClientGUID
UPDATE APP_Application
SET backupSet = B.new_backupSetId
FROM APP_Application A INNER JOIN  CCM_TI_MAP_Application B ON A.id = new_appId
WHERE A.backupSet <> B.new_backupSetId
UPDATE APP_Application
SET GUID = CAST (B.subClientGUID AS uniqueidentifier)
FROM APP_Application A INNER JOIN  CCM_TI_MAP_Application B ON A.id = new_appId
WHERE A.GUID <> B.subClientGUID AND B.subClientGUID <> ''
return;
GO

IF EXISTS (select * from GxQscripts where name = 'TapeImport_SetIndexingV2ClientProperty')
	delete from GxQscripts where name = 'TapeImport_SetIndexingV2ClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TapeImport_SetIndexingV2ClientProperty')
	delete from GXDBVersions where aliasname = 'TapeImport_SetIndexingV2ClientProperty'
GO

insert into GXDBVersions values(2, 'TapeImport_SetIndexingV2ClientProperty',  '00010003000000000000', 'TapeImport_SetIndexingV2ClientProperty', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateQSDKSession.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UpdateQSDKSession <<<'

IF EXISTS (select * from sysobjects where name='sec_UpdateQSDKSession')
	drop procedure sec_UpdateQSDKSession
IF EXISTS (select * from GxQscripts where name='sec_UpdateQSDKSession')
	delete from GxQscripts where name = 'sec_UpdateQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpdateQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_UpdateQSDKSession'
GO
print '... Creating Procedure: sec_UpdateQSDKSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UpdateQSDKSession
  @sessions XML
AS
	declare @iSession int
	exec sp_xml_preparedocument @iSession OutPut, @sessions
	select * into #TobeUpdated from OpenXml(@iSession,'/App_UpdateSessionDetailsRequest/sessionDetails', 1) with (guid uniqueidentifier , lastAccesstime bigint )
	update session set session.lastAccessedTime =  u.lastAccesstime from UMQSDKSessions session join #TobeUpdated u on session.GUID = u.guid;
	exec sp_xml_removedocument @iSession
	select GUID from UMQSDKSessions
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateQSDKSession')
	delete from GxQscripts where name = 'sec_updateQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_updateQSDKSession'
GO

insert into GXDBVersions values(2, 'sec_updateQSDKSession',  '00000000000000000000', 'sec_updateQSDKSession', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QscriptGetAppIdsFromNames.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QscriptGetAppIdsFromNames.sp,v $ $Id: QscriptGetAppIdsFromNames.sp,v 1.13 2015/03/30 21:15:05 anarde Exp $";
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  Returns a AppId given five names
--
--  BEGIN
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QscriptGetAppIdsFromNames <<<'

IF EXISTS (select * from sysobjects where name='QscriptGetAppIdsFromNames')
	drop procedure QscriptGetAppIdsFromNames
IF EXISTS (select * from GxQscripts where name='QscriptGetAppIdsFromNames')
	delete from GxQscripts where name = 'QscriptGetAppIdsFromNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QscriptGetAppIdsFromNames')
	delete from GXDBVersions where aliasname = 'QscriptGetAppIdsFromNames'
GO
print '... Creating Procedure: QscriptGetAppIdsFromNames'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QscriptGetAppIdsFromNames
  @PARAM1 varchar(1030),
  @PARAM2 varchar(100),
  @PARAM3 varchar(1030),
  @PARAM4 varchar(1030),
  @PARAM5 varchar(1030),
  @SubclientId integer OUTPUT,
  @BackupsetId integer OUTPUT,
  @InstanceId integer OUTPUT,
  @ApptypeId integer OUTPUT,
  @ClientId integer OUTPUT,
  @errorString varchar(1024)  OUTPUT
AS
	DECLARE @i_retCode integer
	SET @i_retCode =0
	--extracting names from input
	DECLARE @clientOption			varchar(10)
	SET		@clientOption			='c='
	DECLARE @apptypeOption			varchar(32)
	set		@apptypeOption			='a='
	DECLARE @instanceOption			varchar(32)
	set		@instanceOption			='i='
	DECLARE @backupsetOption		varchar(32)
	set		@backupsetOption		='b='
	DECLARE @subclientOption		varchar(32)
	set		@subclientOption		='s='
	DECLARE @clientName varchar(1024)
	DECLARE @appTypeName varchar(100)
	DECLARE @instanceName varchar(1024)
	DECLARE @backupsetName varchar(1024)
	DECLARE @subclientName varchar(1024)
--@PARAM1
	IF SUBSTRING(@PARAM1, 1, 2) = @clientOption
		SET @clientName  = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))
  	ELSE
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter1 must be Client name beginning with c= . But it was ['+@PARAM1+'].'
		GOTO EXIT_ERR
	END
--@PARAM2
	IF SUBSTRING(@PARAM2, 1, 2) = @apptypeOption
		SET @appTypeName  = (SELECT SUBSTRING(@PARAM2, 3, LEN(@PARAM2)-2))
  	ELSE
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter2 must be iDA name beginning with a= . But it was ['+@PARAM2+'].'
		GOTO EXIT_ERR
	END
--@PARAM3
	IF SUBSTRING(@PARAM3, 1, 2) = @instanceOption
	BEGIN
		SET @instanceName  = (SELECT SUBSTRING(@PARAM3, 3, LEN(@PARAM3)-2))
		SET @backupsetName = ''
	END
	ELSE IF SUBSTRING(@PARAM3, 1, 2) = @backupsetOption
	BEGIN
		SET @instanceName = ''
		SET @backupsetName  = (SELECT SUBSTRING(@PARAM3, 3, LEN(@PARAM3)-2))
	END
	ELSE IF SUBSTRING(@PARAM3, 1, 2) = @subclientOption
	BEGIN
		SET @instanceName = ''
		SET @backupsetName  = ''
		SET @subclientName = (SELECT SUBSTRING(@PARAM3, 3, LEN(@PARAM3)-2))
	END
  	ELSE
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter3 must be Instance Name / Backupset Name / Subclient Name beginning with i= | b= | s= . But it was ['+@PARAM3+'].'
		GOTO EXIT_ERR
	END
--@PARAM4
	IF SUBSTRING(@PARAM4, 1, 2) = @backupsetOption
		SET @backupsetName  = (SELECT SUBSTRING(@PARAM4, 3, LEN(@PARAM4)-2))
	ELSE IF SUBSTRING(@PARAM4, 1, 2) = @subclientOption
	BEGIN
		SET @subclientName = (SELECT SUBSTRING(@PARAM4, 3, LEN(@PARAM4)-2))
	END
  	ELSE IF @subclientName IS NULL
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter4 must be Backupset Name / Subclient Name beginning with  b= | s= . But it was ['+@PARAM4+'].'
		GOTO EXIT_ERR
	END
--@PARAM5
	IF SUBSTRING(@PARAM5, 1, 2) = @subclientOption
		SET @subclientName = (SELECT SUBSTRING(@PARAM5, 3, LEN(@PARAM5)-2))
  	ELSE IF @subclientName IS NULL  --don't error out if it was seem earlier
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter5 must be Subclient Name beginning with s= . But it was ['+@PARAM5+'].'
		GOTO EXIT_ERR
	END
--If all the inputs were fine then proceed otherwise abort here
	IF (@clientName IS NULL OR
		@appTypeName  IS NULL OR
		@instanceName IS NULL OR
		@backupsetName IS NULL OR
		@subclientName IS NULL)
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. One or more of the inputs are incorrect Client ['+ @clientName + '], iDA ['+@apptypeName+'], Instance ['+ @instanceName + '], Backupset ['+ @backupsetName + '], Subclient ['+ @subclientName+'].'
		GOTO EXIT_ERR
	END
	ELSE
		PRINT 'Client ['+ @clientName + '], iDA ['+@apptypeName+'], Instance ['+ @instanceName + '], Backupset ['+ @backupsetName + '], Subclient ['+ @subclientName+'].'
--Proceed to find the ids
	DECLARE @i_SubclientId integer
	DECLARE @i_BackupsetId integer
	DECLARE @i_InstanceId integer
	DECLARE @i_ApptypeId integer
	DECLARE @i_ClientId integer
	SET @i_retCode = 0
	SET @errorString =''
	--Client Id
    SELECT @i_ClientId = id FROM APP_Client WHERE name = @clientName AND status & 2 <> 2 AND status & 4 <> 4
	IF(@i_ClientId = 0 OR @i_ClientId IS NULL)
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Client ['+ @clientName + '] does not exist'
		GOTO EXIT_ERR
	END
IF @appTypeName = 'Q_FILESYSTEM'
BEGIN
	SELECT @i_ApptypeId = appTypeId FROM APP_IDAName WHERE clientId = @i_ClientId AND appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = (SELECT appTypeGroupId FROM APP_AppTypeGroup WHERE groupName = 'APPGRP_FileSystemIDA'))
END
ELSE
	--APPTYPE defined by QSDK:
    SELECT @i_ApptypeId =
        CASE @appTypeName
            WHEN 'Q_WINDOWS_FS'THEN 33
			WHEN 'Q_WINDOWS_FS_64'THEN 34
			WHEN 'Q_WINNET_FS'THEN 42
			WHEN 'Q_WINNET_FS_64'THEN 43
			WHEN 'Q_SHAREPOINT_SERVER'THEN 78
			WHEN 'Q_SHAREPOINT_SERVER'THEN 69
			WHEN 'Q_MSEXCH_MB'THEN 54
			WHEN 'Q_MSEXCH_DB'THEN 53
			WHEN 'Q_MSEX_WEB'THEN 55
			WHEN 'Q_MSEX_MIG'THEN 56
			WHEN 'Q_MSEX_PUB'THEN 35
			WHEN 'Q_FS'THEN 1
			WHEN 'Q_WIN2K_FS'THEN 11
			WHEN 'Q_NETWARE_FS'THEN 12
			WHEN 'Q_HPUX64_FS'THEN 18
			WHEN 'Q_SOLARIS64_FS'THEN 20
			WHEN 'Q_AIX_FS'THEN 21
			WHEN 'Q_HPUX_FS'THEN 17
			WHEN 'Q_SOLARIS_FS'THEN 19
			WHEN 'Q_LINUX_FS'THEN 29
			WHEN 'Q_WINXP32_FS'THEN 33
			WHEN 'Q_WINXP64_FS'THEN 34
			WHEN 'Q_TRU64_FS_64'THEN 36
			WHEN 'Q_TRU64_FS_32'THEN 38
			WHEN 'Q_WINNET32_FS'THEN 42
			WHEN 'Q_WINNET64_FS'THEN 43
			WHEN 'Q_MAC_FS'THEN 63
			WHEN 'Q_SGI_FS'THEN 64
			WHEN 'Q_FREEBSD_FS'THEN 74
			WHEN 'Q_WINFS_MIG'THEN 58
			WHEN 'Q_UNIXFS_MIG'THEN 66
			WHEN 'Q_ORACLE'THEN 22
			WHEN 'Q_DB2'THEN 37
			WHEN 'Q_UNIX_DB2'THEN 62
			WHEN 'Q_INFORMIX'THEN 3
			WHEN 'Q_MSSQLSERVER'THEN 4
			WHEN 'Q_MSSQL_2K'THEN 16
			WHEN 'Q_MSSQL_YUKON'THEN 70
			WHEN 'Q_MSSQL'THEN 81
			WHEN 'Q_SYBASE'THEN 5
			WHEN 'Q_MSEX_MB'THEN 8
			WHEN 'Q_MSEX2K_MB'THEN 14
			WHEN 'Q_MSEX2003_MB'THEN 54
			WHEN 'Q_MSEX_DB'THEN 9
			WHEN 'Q_MSEX2K_DB'THEN 15
			WHEN 'Q_MSEX2003_DB'THEN 53
			WHEN 'Q_MSEX55_PUB'THEN 35
			WHEN 'Q_MSEX2K_WEB'THEN 44
			WHEN 'Q_MSEX2003_WEB'THEN 55
			WHEN 'Q_MSEX_ARCH'THEN 67
			WHEN 'Q_MSEX55_ARCH'THEN 68
			WHEN 'Q_MSEX2K_MIG'THEN 45
			WHEN 'Q_MSEX2003_MIG'THEN 56
			WHEN 'Q_MSEX55_MIG'THEN 57
			WHEN 'Q_LOTUS_DB'THEN 6
			WHEN 'Q_LOTUS_UNIX_DB'THEN 51
			WHEN 'Q_LOTUS_DOMINO_DB'THEN 59
			WHEN 'Q_LOTUS6_DB'THEN 77
			WHEN 'Q_LOTUS_DOC'THEN 7
			WHEN 'Q_LOTUS_UNIX_DOC'THEN 52
			WHEN 'Q_LOTUS_DOMINO_DOC'THEN 60
			WHEN 'Q_SHAREPOINT_DB'THEN 69
			WHEN 'Q_SHAREPOINT_DOC'THEN 78
			WHEN 'Q_GROUPWISE'THEN 71
			WHEN 'Q_NDS'THEN 10
			WHEN 'Q_SDM_WIN2K'THEN 24
			WHEN 'Q_SDM_UNIX'THEN 48
			WHEN 'Q_SAP_ORADB'THEN 61
			WHEN 'Q_SAP_SAPDB'THEN 79
			WHEN 'Q_PROXYHOST'THEN 25
			WHEN 'Q_PROXYHOST_UNIX'THEN 40
			WHEN 'Q_ACTIVEDIR'THEN 41
			WHEN 'Q_IMAGELEVEL_WIN'THEN 65
			WHEN 'Q_IMAGELEVEL_UNIX'THEN 75
			WHEN 'Q_IMAGELEVEL_PROXY'THEN 76
			WHEN 'Q_NETSTORAGE_MIG'THEN 73
			WHEN 'Q_NAS'THEN 13
			WHEN 'Q_REPLICATION'THEN 47
			WHEN 'Q_REPLICATION_UNIX'THEN 50
			WHEN 'Q_MSEXPF_MIG'THEN 82
			WHEN 'Q_ORACLE_RAC'THEN 80
			WHEN 'Q_NETWARE_MIG'THEN 83
			WHEN 'Q_FILE_REPLICATION'THEN 84
			WHEN 'Q_DATA_CLASSIFICATION'THEN 85
			WHEN 'Q_NETWARE_LINUX'THEN 86
			WHEN 'Q_PROXYHOST_IMAGE_UNIX'THEN 87
			WHEN 'Q_CENTERA'THEN 88
			WHEN 'Q_SHAREPOINT_ARCH'THEN 89
			WHEN 'Q_LOTUS_DOC_MIG'THEN 90
			WHEN 'Q_DPM_AGENT'THEN 91
			WHEN 'Q_DB2_DPF'THEN 103
			WHEN 'Q_MYSQL'THEN 104
			WHEN 'Q_VIRTUAL_SERVER'THEN 106
            ELSE 0
		END
	IF((SELECT count(id) FROM app_idaname WHERE clientId = @i_clientId AND AppTypeId = @i_AppTypeId AND status & 2 <> 2 AND status & 4 <> 4) < 1)
		SET @i_AppTypeId = 0
	IF(@i_AppTypeId = 0 OR @i_ApptypeId IS NULL)
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. AppType ['+ @apptypeName + '] does not exist on Client ['+ @clientName+'].'
		GOTO EXIT_ERR
	END
	--@InstanceId, @BackupsetId and subclientid
	--All five names are given
	if(@instanceName <> '' AND @backupsetName <> '')
		SELECT  @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND INS.name = @instanceName AND BS.name = @backupsetName AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
    ELSE if(@instanceName = '' AND @backupsetName <> '')
   		SELECT @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND BS.name = @backupsetName AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
	ELSE if(@instanceName <> ''AND @backupsetName = '')
		SELECT @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND INS.name = @instanceName AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
    ELSE --only apptype and subclient given
    	SELECT @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
	IF @@ROWCOUNT > 1
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Ambiguous input Instance ['+ @instanceName + '] Backupset ['+ @backupsetName + '] Subclient ['+ @subclientName+'] for Client ['+@clientName+'] and iDA ['+@apptypeName+'].'
		GOTO EXIT_ERR
	END
	IF(@i_InstanceId = 0 OR @i_BackupsetId = 0 OR @i_subclientId = 0 OR @i_InstanceId IS null OR @i_BackupsetId IS null OR @i_subclientId IS NULL)
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Instance ['+ @instanceName + '] Backupset ['+ @backupsetName + '] Subclient ['+ @subclientName+'] incorrect for Client ['+@clientName+'] and iDA ['+@apptypeName+'].'
		GOTO EXIT_ERR
	END
EXIT_ERR:
    SELECT 	@SubclientId = @i_SubclientId, @BackupsetId = @i_BackupsetId, @InstanceId = @i_InstanceId, @ApptypeId  = @i_ApptypeId, @ClientId = @i_ClientId
	RETURN @i_retCode
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  END
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+


IF EXISTS (select * from GxQscripts where name = 'QscriptGetAppIdsFromNames')
	delete from GxQscripts where name = 'QscriptGetAppIdsFromNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QscriptGetAppIdsFromNames')
	delete from GXDBVersions where aliasname = 'QscriptGetAppIdsFromNames'
GO

insert into GXDBVersions values(2, 'QscriptGetAppIdsFromNames',  '00010013000000000000', 'QscriptGetAppIdsFromNames', '00010013000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPResetCSNameChangeOnClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  APPGetEntityFirewallXML
--  |
--  | Description:  Procedure to return all the Firewall properties of an entity
--  |
--  |       Input:  XML Containing clientId/ClientGroupId
--  |
--  |      Output:  XML containing firewall properties
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1       Shilpa Nagendra					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPResetCSNameChangeOnClients <<<'

IF EXISTS (select * from sysobjects where name='APPResetCSNameChangeOnClients')
	drop procedure APPResetCSNameChangeOnClients
IF EXISTS (select * from GxQscripts where name='APPResetCSNameChangeOnClients')
	delete from GxQscripts where name = 'APPResetCSNameChangeOnClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPResetCSNameChangeOnClients')
	delete from GXDBVersions where aliasname = 'APPResetCSNameChangeOnClients'
GO
print '... Creating Procedure: APPResetCSNameChangeOnClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPResetCSNameChangeOnClients
  @cshostname nvarchar(MAX),
  @entityInfo XML	OUTPUT
AS
DECLARE @clientList table ( clientId integer)
DECLARE @rootTag INTEGER=0
SET @rootTag = (SELECT @entityInfo.exist('/App_NameChangeResponse'))
IF  @rootTag = 1
BEGIN
	INSERT INTO @clientList
	SELECT  ref.value('@clientId', 'INTEGER')
	FROM    @entityInfo.nodes('App_NameChangeResponse/failedClientList/entity') R ( ref )
END
ELSE
BEGIN
	INSERT INTO @clientList
	SELECT  ref.value('@clientId', 'INTEGER')
	FROM    @entityInfo.nodes('EVGui_ClientNameControlResp/clientList') R ( ref ) --ClientNameControlResp
END
UPDATE	App_Client
SET	CsHostName = @cshostname
WHERE	id in (select clientId from @clientList)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPResetCSNameChangeOnClients')
	delete from GxQscripts where name = 'APPResetCSNameChangeOnClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPResetCSNameChangeOnClients')
	delete from GXDBVersions where aliasname = 'APPResetCSNameChangeOnClients'
GO

insert into GXDBVersions values(2, 'APPResetCSNameChangeOnClients',  '00000000000000000000', 'APPResetCSNameChangeOnClients', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetGlobalFilterState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetGlobalFilterState <<<'

IF EXISTS (select * from sysobjects where name='QS_GetGlobalFilterState')
	drop procedure QS_GetGlobalFilterState
IF EXISTS (select * from GxQscripts where name='QS_GetGlobalFilterState')
	delete from GxQscripts where name = 'QS_GetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_GetGlobalFilterState'
GO
print '... Creating Procedure: QS_GetGlobalFilterState'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetGlobalFilterState
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
------------------ Constants    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetGlobalFilterState'
DECLARE @propName1 varchar(50)
SET @propName1 = 'use cs setting for Global Filters'
DECLARE @propName2 varchar(32)
SET @propName2 = 'Use Global Filters'
-------- Local Variables    -------------
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
---------------------------------------
--test
--SET		@PARAM1= 'c=bingo'
--SET		@PARAM2= 'a=Q_WINNET_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
------------ Get ids -------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
IF  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
----------------------- input validation ------------------------
DECLARE @scpid integer
SET @scpid = ISNULL((select attrval from app_backupsetprop where attrname like 'Associated subclient Policy' and componentnameid = @backupsetid AND modified = 0),0)
DECLARE @useSCPfilters integer
IF @scpid >0
BEGIN
	SET @useSCPfilters = ISNULL((select attrval from app_subclientprop where componentNameId = @subclientId and modified=0 AND attrname like 'use SCP filters'), 0)
END
IF @useSCPfilters = 0
BEGIN
	SELECT 'NOT APPLICABLE (USES SUBCLIENT POLICY FILTERS)' As GlobalFilterState
	GOTO ARGS_ERROR
END
IF @AppTypeId NOT IN  (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43, 54,56,57,58, 63,64,67,68,74,86, 105,106)
BEGIN
	SELECT 'NOT APPLICABLE' AS GlobalFilterState
	GOTO ARGS_ERROR
END
----------------------- Get global filter state ------------------------
IF (ISNULL(( SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1), '1')= '0')
BEGIN
	IF(ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2), '0') = '1')
		SELECT 'ON' AS GlobalFilterState
	ELSE
		SELECT 'OFF'AS GlobalFilterState
END
ELSE
	SELECT 'USE CELL LEVEL POLICY'AS GlobalFilterState
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetGlobalFilterState')
	delete from GxQscripts where name = 'QS_GetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_GetGlobalFilterState'
GO

insert into GXDBVersions values(2, 'QS_GetGlobalFilterState',  '00000000000000000000', 'QS_GetGlobalFilterState', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetGlobalFilterState',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetGlobalFilterState -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : GetGlobalFilterState'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobConfiguration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobConfiguration <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobConfiguration')
	drop procedure QS_GetJobConfiguration
IF EXISTS (select * from GxQscripts where name='QS_GetJobConfiguration')
	delete from GxQscripts where name = 'QS_GetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_GetJobConfiguration'
GO
print '... Creating Procedure: QS_GetJobConfiguration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobConfiguration
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
--INPUT
-------------------------------------------
--DECLARE @CLIENTNAME     	varchar(512)
--SET @CLIENTNAME = '%s'  			-- c=clientName, allclients
--SET @CLIENTNAME = 'roman'
--------------- Constants   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetJobConfiguration'
-------------- Local Variables    -------------
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
-------------- Validate inputs -------------
IF(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId				integer
SET @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = @CLIENTNAME),0)
IF @clientId = 0
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+@CLIENTNAME+ '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
-------------- Get Job configuration -------------
SELECT 'Prune Job results when Disk Capaicity reaches' as 'Job Property', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'DiskFullPercent' AND componentnameid = @clientId AND MODIFIED = 0), 90) as Value
UNION
SELECT 'Job Priority', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'JMPriority' AND componentnameid = @clientId AND MODIFIED = 0), 6)
UNION
SELECT 'Low Space Threshold on Job Results Folder(MB)', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'JobResultsThresholdMB' AND componentnameid = @clientId AND MODIFIED = 0), 500)
UNION
SELECT 'Prune job results after', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'AgingDays' AND componentnameid = @clientId AND MODIFIED = 0), 7)
UNION
SELECT 'Job Results Directory UserName (windows client)', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'Job Results Dir Username' AND componentnameid = @clientId AND MODIFIED = 0), '')
UNION
SELECT 'Job Results Directory', jobResultDir FROM APP_Client WHERE Id = @clientid
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: [ ' + @CLIENTNAME+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobConfiguration')
	delete from GxQscripts where name = 'QS_GetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_GetJobConfiguration'
GO

insert into GXDBVersions values(2, 'QS_GetJobConfiguration',  '00000000000000000000', 'QS_GetJobConfiguration', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobConfiguration',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetJobConfiguration.sql -si client_name
'
 + CHAR(10) + '--   script_name : GetJobConfiguration'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobDescription')
	drop procedure QS_GetJobDescription
IF EXISTS (select * from GxQscripts where name='QS_GetJobDescription')
	delete from GxQscripts where name = 'QS_GetJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobDescription')
	delete from GXDBVersions where aliasname = 'QS_GetJobDescription'
GO
print '... Creating Procedure: QS_GetJobDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @inJobId varchar(64) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @inJobId	varchar(64)
--SET @inJobId =	'%s'
--SET @inJobId = 10
-------------------------------------------
---- Convenience Definitions    -----------
-------------------------------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetJobDescription'
-------------------------------------------
-------- Local Variables    -------------
-------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0			-- Be optimistic
DECLARE @NoParameter varchar(4)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------------------------------------------
---- Input parameter validation -----------
-------------------------------------------
IF (@inJobId = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid jobId paramater value'
	Set @lastError = 1
	goto	ARGS_ERROR
END
IF NOT EXISTS(select * from JMJobStats where jobId = @inJobId)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid jobId.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-------------------------------------------
----- Procession Logic --------------------
-------------------------------------------
select jobDescription from JMJobStats where jobId = @inJobId
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobDescription')
	delete from GxQscripts where name = 'QS_GetJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobDescription')
	delete from GXDBVersions where aliasname = 'QS_GetJobDescription'
GO

insert into GXDBVersions values(2, 'QS_GetJobDescription',  '00000000000000000000', 'QS_GetJobDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetJobDescription.sql -si jobId
'
 + CHAR(10) + '--   script_name : GetJobDescription'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobDetails <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobDetails')
	drop procedure QS_GetJobDetails
IF EXISTS (select * from GxQscripts where name='QS_GetJobDetails')
	delete from GxQscripts where name = 'QS_GetJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobDetails')
	delete from GXDBVersions where aliasname = 'QS_GetJobDetails'
GO
print '... Creating Procedure: QS_GetJobDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobDetails
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetJobDetails'
DECLARE @COMMCELLID int
SET @COMMCELLID = 2
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
-------- Local Variables    -------------
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------------------------------------
--SET @clientName = 'oscar'
------------------------------------------
if(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = (Select id FROM APP_Client WHERE name LIKE @clientName)
if(@clientId = 0 OR @clientId IS NULL)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+@clientName+'] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @localeId integer
SET @localeId = 0
SELECT jobID = JMJobInfo.jobId,
	(case bkpLevel  WHEN 0x1 THEN 'Full'
				    WHEN 0x2 THEN 'Incremental'
					WHEN 0x4 THEN 'Differential'
					WHEN 0x8 THEN 'Any'
					WHEN 0x40 THEN 'Synthetic Full'
					WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
					WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
					WHEN 0x200 THEN 'ASR'
					WHEN 0x400 THEN 'Selective Online Full'
					WHEN 0x800 THEN 'Snapshot Backup'
					WHEN 0x1000 THEN 'Create Replication Backup'
					WHEN 0x2000 THEN 'Update Replication Backup'
					WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
					WHEN 0x8000 THEN 'Selective Online Full'
					WHEN 0x10000 THEN 'Qnet SAP Operation'
					WHEN 0x20000 THEN 'SRM Analysis'
					WHEN 0x40000 THEN 'SRM Discovery'
					WHEN 0x80000 THEN 'Qnet SAP Operation'
	END)As Level,
	(case displayState 	WHEN 1 THEN 'Running'
						WHEN 2 THEN 'Pending'
						WHEN 3 THEN 'Waiting'
						WHEN 4 THEN 'Completed'
						WHEN 5 THEN 'Stopped'
						WHEN 6 THEN 'Kill Pending'
						WHEN 7 THEN 'Stop Pending'
						WHEN 8 THEN 'Interrupt Pending'
						WHEN 9 THEN 'Completed Successfully'
						WHEN 10 THEN 'Completed with Errors'
						WHEN 11 THEN 'Killed'
						WHEN 12 THEN 'Completed Partial Success'
						WHEN 13 THEN 'System Kill Pending'
						WHEN 14 THEN 'Dormant'
						WHEN 15 THEN 'Queued'
						WHEN 16 THEN 'Dormant Schedule Wait'
						WHEN 17 THEN 'Running Unavailable'
						WHEN 18 THEN 'Dangling Job Cleanup'
						ELSE 'Unknown'
	END)as Status,
	StoragePolicyName = CASE
		WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = currentPolicy),'Unavailable')
		WHEN currentPolicy = 0 THEN ''
		ELSE ISNULL((SELECT name FROM archGroup WHERE id = currentPolicy),'Unavailable')
		END,
	(Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = currentPolicy),0)) as RetentionDays,
	--ClientName = (select name from APP_Client where id = APP_Application.clientId),
	AppTypeName = (select name from APP_iDAType where type = APP_Application.appTypeId),
	--instanceName = (select name from APP_InstanceName where id = APP_Application.instance),
	--backupSetName = (select name from APP_BackupSetName where id = APP_Application.backupSet),
	APP_Application.SubclientName,
	DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(jobStartTime)) as 'StartTime/EndTime',
	Active = 'Yes',
	BackupSize      = -1,
	ApplicationSize = -1
	--dbo.JMGetLocalizedMessageAndIDFunc(@localeId,failureReason) as PendingReason
FROM JMBkpJobInfo
INNER JOIN JMJobInfo ON
JMBkpJobInfo.jobId = JMJobInfo.jobId AND
JMBkpJobInfo.commcellId = JMJobInfo.commcellId
INNER JOIN APP_Application ON
JMBkpJobInfo.applicationId = APP_Application.id
WHERE APP_Application.clientId= @clientId
UNION
SELECT jobID = JMBkpStats.jobId,
	(case bkpLevel  WHEN 0x1 THEN 'Full'
				    WHEN 0x2 THEN 'Incremental'
					WHEN 0x4 THEN 'Differential'
					WHEN 0x8 THEN 'Any'
					WHEN 0x40 THEN 'Synthetic Full'
					WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
					WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
					WHEN 0x200 THEN 'ASR'
					WHEN 0x400 THEN 'Selective Online Full'
					WHEN 0x800 THEN 'Snapshot Backup'
					WHEN 0x1000 THEN 'Create Replication Backup'
					WHEN 0x2000 THEN 'Update Replication Backup'
					WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
					WHEN 0x8000 THEN 'Selective Online Full'
					WHEN 0x10000 THEN 'Qnet SAP Operation'
					WHEN 0x20000 THEN 'SRM Analysis'
					WHEN 0x40000 THEN 'SRM Discovery'
					WHEN 0x80000 THEN 'Qnet SAP Operation'
	END)As Level,
	(case status 	WHEN 1 THEN 'Success'
						WHEN 2 THEN 'Failed'
						WHEN 3 THEN 'Partial Success'
						WHEN 4 THEN 'Killed'
						WHEN 5 THEN 'Stopped'
						WHEN 6 THEN 'Interrupted'
						WHEN 7 THEN 'Any'
						WHEN 8 THEN 'Skipped'
						WHEN 9 THEN 'Dropped'
						WHEN 10 THEN 'In Sync'
						WHEN 11 THEN 'Out of Sync'
						WHEN 12 THEN 'Not Attempted'
						WHEN 13 THEN 'Started'
						ELSE 'Unknown'
	END) as Status,
	StoragePolicyName = CASE
		WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
		WHEN (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END) = 0 THEN ''
		ELSE ISNULL((SELECT name FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
		END,
	(Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),0)) as RetentionDays,
	--ClientName = (select name from APP_Client where id = APP_Application.clientId),
	AppTypeName = (select name from APP_iDAType where type = APP_Application.appTypeId),
	--instanceName = (select name from APP_InstanceName where id = APP_Application.instance),
	--backupSetName = (select name from APP_BackupSetName where id = APP_Application.backupSet),
	APP_Application.SubclientName,
	DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'StartTime/EndTime',
	Active = 'No',
	BackupSize  = JMBkpStats.totalBackupSize,
	ApplicationSize    = JMBkpStats.totalUncompBytes
 	--dbo.JMGetLocalizedMessageAndIDFunc(@localeId,failureReason) as PendingReason
FROM JMBkpStats
INNER JOIN APP_Application ON
JMBkpStats.appId = APP_Application.id
WHERE APP_Application.clientId = @clientId
ORDER BY 'StartTime/EndTime' DESC
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters ClientName : ['+@clientName+']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobDetails')
	delete from GxQscripts where name = 'QS_GetJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobDetails')
	delete from GXDBVersions where aliasname = 'QS_GetJobDetails'
GO

insert into GXDBVersions values(2, 'QS_GetJobDetails',  '00000000000000000000', 'QS_GetJobDetails', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobDetails',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetJobDetails.sql -si Client_name
'
 + CHAR(10) + '--   script_name : GetJobDetails'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobList <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobList')
	drop procedure QS_GetJobList
IF EXISTS (select * from GxQscripts where name='QS_GetJobList')
	delete from GxQscripts where name = 'QS_GetJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobList')
	delete from GXDBVersions where aliasname = 'QS_GetJobList'
GO
print '... Creating Procedure: QS_GetJobList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobList
--QScript is enabled
-- QScript secure this script does the user validation
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName = '%s'
------------------------------------------
--SET @clientName = 'oscar'
------------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetJobList'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @userId INT
SET @userId = 0
------------ Input Validation    -----------
IF(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = (Select id FROM APP_Client WHERE name = @clientName)
if(@clientId = 0 OR @clientId IS NULL)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+@clientName+'] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--Existence of table and fetching of top 1 userId is done for safety measures
IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
BEGIN
	 SET @localErrorMsg = 'Error, no logged in user found'
	 Set @lastError = 1
	 goto   ARGS_ERROR
END
SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
IF @userId = 0
BEGIN
	 SET @localErrorMsg = 'Error, no logged in user found'
	 Set @lastError = 1
	 goto   ARGS_ERROR
END
------------------ Get jobs------------------------
--running jobs
SELECT jobID = JMJobInfo.jobId,
	(case bkpLevel  WHEN 0x1 THEN 'Full'
				    WHEN 0x2 THEN 'Incremental'
					WHEN 0x4 THEN 'Differential'
					WHEN 0x8 THEN 'Any'
					WHEN 0x40 THEN 'Synthetic Full'
					WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
					WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
					WHEN 0x200 THEN 'ASR'
					WHEN 0x400 THEN 'Selective Online Full'
					WHEN 0x800 THEN 'Snapshot Backup'
					WHEN 0x1000 THEN 'Create Replication Backup'
					WHEN 0x2000 THEN 'Update Replication Backup'
					WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
					WHEN 0x8000 THEN 'Selective Online Full'
					WHEN 0x10000 THEN 'Qnet SAP Operation'
					WHEN 0x20000 THEN 'SRM Analysis'
					WHEN 0x40000 THEN 'SRM Discovery'
					WHEN 0x80000 THEN 'Qnet SAP Operation'
	END)As Level,
	(case displayState 	WHEN 1 THEN 'Running'
						WHEN 2 THEN 'Pending'
						WHEN 3 THEN 'Waiting'
						WHEN 4 THEN 'Completed'
						WHEN 5 THEN 'Stopped'
						WHEN 6 THEN 'Kill Pending'
						WHEN 7 THEN 'Stop Pending'
						WHEN 8 THEN 'Interrupt Pending'
						WHEN 9 THEN 'Completed Successfully'
						WHEN 10 THEN 'Completed with Errors'
						WHEN 11 THEN 'Killed'
						WHEN 12 THEN 'Completed Partial Success'
						WHEN 13 THEN 'System Kill Pending'
						WHEN 14 THEN 'Dormant'
						WHEN 15 THEN 'Queued'
						WHEN 16 THEN 'Dormant Schedule Wait'
						WHEN 17 THEN 'Running Unavailable'
						WHEN 18 THEN 'Dangling Job Cleanup'
						ELSE 'Unknown'
	END)as Status,
	StoragePolicyName = CASE
		WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = currentPolicy),'Unavailable')
		WHEN currentPolicy = 0 THEN ''
		ELSE ISNULL((SELECT name FROM archGroup WHERE id = currentPolicy),'Unavailable')
		END,
	(Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = currentPolicy),0)) as RetentionDays,
	--ClientName = (select name from APP_Client where id = APP_Application.clientId),
	AppTypeName = (select name from APP_iDAType where type = APP_Application.appTypeId),
	--instanceName = (select name from APP_InstanceName where id = APP_Application.instance),
	--backupSetName = (select name from APP_BackupSetName where id = APP_Application.backupSet),
	APP_Application.SubclientName,
	DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(jobStartTime)) as 'StartTime/EndTime',
	Active = 'Yes'
	--dbo.JMGetLocalizedMessageAndIDFunc(@localeId,failureReason) as PendingReason
FROM JMBkpJobInfo
INNER JOIN JMJobInfo ON
JMBkpJobInfo.jobId = JMJobInfo.jobId AND
JMBkpJobInfo.commcellId = JMJobInfo.commcellId
INNER JOIN APP_Application ON
JMBkpJobInfo.applicationId = APP_Application.id AND JMBkpJobInfo.commcellId = APP_Application.origCCId
WHERE APP_Application.clientId= @clientId
AND ((JMJobInfo.userId = @userId) OR (dbo.isBkpJobVisible(@userId,APP_Application.origCCId,APP_Application.clientId,APP_Application.appTypeId,APP_Application.instance,APP_Application.backupSet,APP_Application.id)=1))
UNION
--completed jobs
SELECT jobID = JMBkpStats.jobId,
	(case bkpLevel  WHEN 0x1 THEN 'Full'
				    WHEN 0x2 THEN 'Incremental'
					WHEN 0x4 THEN 'Differential'
					WHEN 0x8 THEN 'Any'
					WHEN 0x40 THEN 'Synthetic Full'
					WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
					WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
					WHEN 0x200 THEN 'ASR'
					WHEN 0x400 THEN 'Selective Online Full'
					WHEN 0x800 THEN 'Snapshot Backup'
					WHEN 0x1000 THEN 'Create Replication Backup'
					WHEN 0x2000 THEN 'Update Replication Backup'
					WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
					WHEN 0x8000 THEN 'Selective Online Full'
					WHEN 0x10000 THEN 'Qnet SAP Operation'
					WHEN 0x20000 THEN 'SRM Analysis'
					WHEN 0x40000 THEN 'SRM Discovery'
					WHEN 0x80000 THEN 'Qnet SAP Operation'
	END)As Level,
	(case status 	WHEN 1 THEN 'Success'
						WHEN 2 THEN 'Failed'
						WHEN 3 THEN 'Partial Success'
						WHEN 4 THEN 'Killed'
						WHEN 5 THEN 'Stopped'
						WHEN 6 THEN 'Interrupted'
						WHEN 7 THEN 'Any'
						WHEN 8 THEN 'Skipped'
						WHEN 9 THEN 'Dropped'
						WHEN 10 THEN 'In Sync'
						WHEN 11 THEN 'Out of Sync'
						WHEN 12 THEN 'Not Attempted'
						WHEN 13 THEN 'Started'
						ELSE 'Unknown'
	END) as Status,
	StoragePolicyName = CASE
		WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
		WHEN (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END) = 0 THEN ''
		ELSE ISNULL((SELECT name FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
		END,
	(Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),0)) as RetentionDays,
	--ClientName = (select name from APP_Client where id = APP_Application.clientId),
	AppTypeName = (select name from APP_iDAType where type = APP_Application.appTypeId),
	--instanceName = (select name from APP_InstanceName where id = APP_Application.instance),
	--backupSetName = (select name from APP_BackupSetName where id = APP_Application.backupSet),
	APP_Application.SubclientName,
	DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'StartTime/EndTime',
	Active = 'No'
 	--dbo.JMGetLocalizedMessageAndIDFunc(@localeId,failureReason) as PendingReason
FROM JMBkpStats
INNER JOIN APP_Application ON
JMBkpStats.appId = APP_Application.id AND JMBkpStats.commCellId = APP_Application.origCCId
WHERE APP_Application.clientId = @clientId AND
((JMBkpStats.userName = ISNULL((SELECT TOP 1 login FROM UMUsers WHERE id = @userId),'')) OR (dbo.isBkpJobVisible(@userId, APP_Application.origCCId,APP_Application.clientId,APP_Application.appTypeId,APP_Application.instance,APP_Application.backupSet,APP_Application.id)=1))
ORDER BY 'StartTime/EndTime' DESC
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters ClientName : ['+@clientName+']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobList')
	delete from GxQscripts where name = 'QS_GetJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobList')
	delete from GXDBVersions where aliasname = 'QS_GetJobList'
GO

insert into GXDBVersions values(2, 'QS_GetJobList',  '00000000000000000000', 'QS_GetJobList', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_GetJobList',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetJobList -si Client_name
'
 + CHAR(10) + '--   script_name : GetJobList'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobHistory <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobHistory')
	drop procedure QS_GetJobHistory
IF EXISTS (select * from GxQscripts where name='QS_GetJobHistory')
	delete from GxQscripts where name = 'QS_GetJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobHistory')
	delete from GXDBVersions where aliasname = 'QS_GetJobHistory'
GO
print '... Creating Procedure: QS_GetJobHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobHistory
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '',
  @fromTime varchar(128) = ''
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName   varchar(1024)
--SET       @clientName = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName varchar(32)
SET     @scriptName = 'GetJobHistory'
DECLARE @COMMCELLID int
SET @COMMCELLID = 2
DECLARE @nowTime    integer = 0
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
DECLARE @fromPeriodInt    integer = 0
-------- Local Variables    -------------
DECLARE @lastError              integer
SET     @lastError  = 0
DECLARE @localErrorMsg          varchar(512)
SET     @localErrorMsg          ='Error Encountered when running script.'
if(@clientName = '')
BEGIN
    SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
    Set @lastError = 1
    goto   ARGS_ERROR
END
IF (@fromTime IS null)
BEGIN
	SET	@fromPeriodInt = 0
END
ELSE
BEGIN
	DECLARE @csTimeZone    VARCHAR(256)
	SELECT  @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
	SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone
	WHERE  TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
	SET @fromPeriodInt = dbo.getUnixTime(dbo.LocalToUTCTime(CONVERT(DATETIME, @fromTime), @csTimeZone))
END
DECLARE @clientId int
SET @clientId = ISNULL((Select id FROM APP_Client WHERE name LIKE @clientName), 0)
if(@clientId = 0)
BEGIN
    SET @localErrorMsg = 'Error.  Client ['+@clientName+'] does not exist.'
    Set @lastError = 1
    goto   ARGS_ERROR
END
SELECT jobID = JMBkpStats.jobId,
    (case bkpLevel  WHEN 0x1 THEN 'Full'
                    WHEN 0x2 THEN 'Incremental'
                    WHEN 0x4 THEN 'Differential'
                    WHEN 0x8 THEN 'Any'
                    WHEN 0x40 THEN 'Synthetic Full'
                    WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
                    WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
                    WHEN 0x200 THEN 'ASR'
                    WHEN 0x400 THEN 'Selective Online Full'
                    WHEN 0x800 THEN 'Snapshot Backup'
                    WHEN 0x1000 THEN 'Create Replication Backup'
                    WHEN 0x2000 THEN 'Update Replication Backup'
                    WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
                    WHEN 0x8000 THEN 'Selective Online Full'
                    WHEN 0x10000 THEN 'Qnet SAP Operation'
                    WHEN 0x20000 THEN 'SRM Analysis'
                    WHEN 0x40000 THEN 'SRM Discovery'
                    WHEN 0x80000 THEN 'Qnet SAP Operation'
    END)As Level,
    (case status    WHEN 1 THEN 'Success'
                        WHEN 2 THEN 'Failed'
                        WHEN 3 THEN 'Partial Success'
                        WHEN 4 THEN 'Killed'
                        WHEN 5 THEN 'Stopped'
                        WHEN 6 THEN 'Interrupted'
                        WHEN 7 THEN 'Any'
                        WHEN 8 THEN 'Skipped'
                        WHEN 9 THEN 'Dropped'
                        WHEN 10 THEN 'In Sync'
                        WHEN 11 THEN 'Out of Sync'
                        WHEN 12 THEN 'Not Attempted'
                        WHEN 13 THEN 'Started'
                        ELSE 'Unknown'
    END) as Status,
    StoragePolicyName = CASE
        WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
        WHEN (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END) = 0 THEN ''
        ELSE ISNULL((SELECT name FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
        END,
    (Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),0)) as RetentionDays,
    --ClientName = (select name from APP_Client WITH (NOLOCK) where id = APP_Application.clientId),
    AppTypeName = (select name from APP_iDAType WITH (NOLOCK) where type = APP_Application.appTypeId),
    --instanceName = (select name from APP_InstanceName WITH (NOLOCK) where id = APP_Application.instance),
    --backupSetName = (select name from APP_BackupSetName WITH (NOLOCK) where id = APP_Application.backupSet),
    APP_Application.SubclientName,
    DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servStartDate)) as 'CommServerStartTime',
    servStartDate as 'UTCStartTime',
    DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'CommServerEndTime',
    servEndDate as 'UTCEndTime',
    BackupSize  = JMBkpStats.totalBackupSize,
    ApplicationSize    = JMBkpStats.totalUncompBytes
FROM JMBkpStats
INNER JOIN APP_Application WITH (NOLOCK) ON
JMBkpStats.appId = APP_Application.id
WHERE APP_Application.clientId = @clientId
AND JMBkpStats.servStartDate > @fromPeriodInt
ORDER BY servStartDate ASC
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ' with Parameters ClientName : ['+@clientName+']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
    Raiserror(@localErrorMsg,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobHistory')
	delete from GxQscripts where name = 'QS_GetJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobHistory')
	delete from GXDBVersions where aliasname = 'QS_GetJobHistory'
GO

insert into GXDBVersions values(2, 'QS_GetJobHistory',  '00000000000000000000', 'QS_GetJobHistory', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobHistory',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn GetJobHistory -si Client_name unixTime
'
 + CHAR(10) + '--   script_name : GetJobHistory'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetLicenseInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetLicenseInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetLicenseInfo')
	drop procedure QS_GetLicenseInfo
IF EXISTS (select * from GxQscripts where name='QS_GetLicenseInfo')
	delete from GxQscripts where name = 'QS_GetLicenseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetLicenseInfo')
	delete from GXDBVersions where aliasname = 'QS_GetLicenseInfo'
GO
print '... Creating Procedure: QS_GetLicenseInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetLicenseInfo
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @licName varchar(1024) = '%s'
AS
SET NOCOUNT ON
--DECLARE @licName	varchar(1024)
DECLARE @evalFld	varchar(1024)
DECLARE @permFld	varchar(1024)
DECLARE @isAllLic	integer
DECLARE @licTypeId	integer
DECLARE @evalTotal	integer
DECLARE @evalUsed	integer
DECLARE @permTotal	integer
DECLARE @permUsed	integer
DECLARE @retLicData	TABLE (	licName	varchar(1024),
				licTypeId INTEGER,
				TotalPermLicensesIssued INTEGER,
				FreePermLicensesAvailable INTEGER,
				TotalEvalLicensesIssued INTEGER,
				FreeEvalLicensesAvailable INTEGER	)
SET @evalTotal	= 0
SET @evalUsed	= 0
SET @permTotal	= 0
SET @permUsed	= 0
--SET @licName = '%s'
SET @isAllLic = (CASE @licName WHEN '%s' THEN 1 WHEN 'ALL' THEN 1 ELSE 0 END)
IF @isAllLic = 0
BEGIN
	SET @licTypeId = ISNULL((SELECT TOP 1 id FROM simLicAppTypeV2 WHERE short_name = @licName), 0)
	IF @licTypeId = 0
	BEGIN
		RAISERROR ('Invalid input license name', 16, 1)
		RETURN
	END
	IF NOT EXISTS (SELECT * FROM licAAL WHERE simLicAppTypeId = @licTypeId)
	BEGIN
		RAISERROR ('The license is not avaliable', 16, 1)
		RETURN
	END
	SELECT @evalFld = eval_fld1, @permFld = perm_fld1 FROM licAAL WHERE simLicAppTypeId = @licTypeId
	IF len(@evalFld) > 0
		EXEC MASTER.dbo.xp_getAALInfo @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT
	IF len(@permFld) > 0
		EXEC MASTER.dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
	INSERT INTO @retLicData
	SELECT @licName, @licTypeId, @permTotal, @permTotal - @permUsed, @evalTotal, @evalTotal - @evalUsed
END
ELSE
BEGIN
	DECLARE licList CURSOR FOR
 		SELECT DISTINCT simLicAppTypeId, eval_fld1, perm_fld1 FROM licAAL WHERE simLicAppTypeId < 1000
	OPEN licList
	FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @evalTotal	= 0
		SET @evalUsed	= 0
		SET @permTotal	= 0
		SET @permUsed	= 0
		IF len(@evalFld) > 0
			EXEC MASTER.dbo.xp_getAALInfo @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT
		IF len(@permFld) > 0
			EXEC MASTER.dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
		INSERT INTO @retLicData
		SELECT '', @licTypeId, @permTotal, @permTotal - @permUsed, @evalTotal, @evalTotal - @evalUsed
		FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
	END
	CLOSE licList
	DEALLOCATE licList
END
SELECT	licName = (CASE @isAllLic WHEN 1 THEN (SELECT short_name FROM simLicAppTypeV2 WHERE id = licTypeId) ELSE @licName END),
		TotalPermLicensesIssued,
		FreePermLicensesAvailable,
		TotalEvalLicensesIssued,
		FreeEvalLicensesAvailable
FROM	@retLicData
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetLicenseInfo')
	delete from GxQscripts where name = 'QS_GetLicenseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetLicenseInfo')
	delete from GXDBVersions where aliasname = 'QS_GetLicenseInfo'
GO

insert into GXDBVersions values(2, 'QS_GetLicenseInfo',  '00000000000000000000', 'QS_GetLicenseInfo', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetLicenseInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript sn getLicenseInfo.sql -si license_name|all
'
 + CHAR(10) + '--   script_name : GetLicenseInfo'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetMSSQLcredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetMSSQLcredentials <<<'

IF EXISTS (select * from sysobjects where name='QS_GetMSSQLcredentials')
	drop procedure QS_GetMSSQLcredentials
IF EXISTS (select * from GxQscripts where name='QS_GetMSSQLcredentials')
	delete from GxQscripts where name = 'QS_GetMSSQLcredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMSSQLcredentials')
	delete from GXDBVersions where aliasname = 'QS_GetMSSQLcredentials'
GO
print '... Creating Procedure: QS_GetMSSQLcredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetMSSQLcredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER! 				 --
-------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM1='allclients'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetMSSQLcredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @useConnect             varchar (30)
SET     @useConnect             = 'MSSQL username'
DECLARE @usePassword            varchar(30)
SET     @usePassword            = 'MSSQL password'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @currentUserName        nvarchar(512)
DECLARE @currentPassword        nvarchar(512)
DECLARE @currentClientName      nvarchar(512)
DECLARE @currentDomainName      nvarchar(512)
DECLARE @componentNameId        int
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
---SET @PARAM1 =  'c=jewelfish_cn'
---SET @PARAM1 =  'allclients'
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
-- MS SQL SERVER --
	IF object_id('tempdb.dbo.MsSqlCredentialsList') is not null DROP TABLE #MsSqlCredentialsList
	CREATE TABLE #MsSqlCredentialsList
	(
	clientName nvarchar(512),
	--domainName nvarchar(512)
	userName nvarchar(512),
	encryptedPassword nvarchar(512)
	)
	 IF @clientId = 0
			DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE appTypeId in (4, 16, 70, 81))
		ELSE
          	DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE clientID = @clientId AND appTypeId in (4, 16, 70, 81))
		OPEN GetUserNameList
			FETCH GetUserNameList INTO @componentNameId, @currentUserName
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @currentPassword = AttrVal from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @usePassword
				SELECT @currentClientName = name from APP_Client,APP_APPLICATION where APP_APPLICATION.instance = @componentNameId AND APP_APPLICATION.clientId=APP_Client.id
				--SELECT @domainName = AttrVal from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @CV_ORACLE_DOMAIN_NAME
				INSERT INTO #MsSqlCredentialsList (clientName, userName, encryptedPassword) VALUES(@currentClientName, @currentUserName , @currentPassword)
				FETCH GetUserNameList INTO @componentNameId, @currentUserName
			END
		CLOSE GetUserNameList
		DEALLOCATE GetUserNameList
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems Getting Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
SELECT clientName,userName,encryptedPassword from #MsSqlCredentialsList
DROP TABLE #MsSqlCredentialsList
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + +REPLACE(@PARAM1, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetMSSQLcredentials')
	delete from GxQscripts where name = 'QS_GetMSSQLcredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMSSQLcredentials')
	delete from GXDBVersions where aliasname = 'QS_GetMSSQLcredentials'
GO

insert into GXDBVersions values(2, 'QS_GetMSSQLcredentials',  '00000000000000000000', 'QS_GetMSSQLcredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetMSSQLcredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f GetMSSQLcredentials -i c=clientName|allclients  
'
 + CHAR(10) + '--   script_name : GetMSSQLcredentials'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetNetworkPendingJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetNetworkPendingJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_GetNetworkPendingJobs')
	drop procedure QS_GetNetworkPendingJobs
IF EXISTS (select * from GxQscripts where name='QS_GetNetworkPendingJobs')
	delete from GxQscripts where name = 'QS_GetNetworkPendingJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetNetworkPendingJobs')
	delete from GXDBVersions where aliasname = 'QS_GetNetworkPendingJobs'
GO
print '... Creating Procedure: QS_GetNetworkPendingJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetNetworkPendingJobs
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--sp input param
  @noOfHours varchar(1024) = '%s'
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetNetworkPendingJobs'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @currTime				integer
DECLARE @NoParameter varchar(4)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--DECLARE @noOfHours varchar(1024)
--SET @noOfHours = '%s'
if (@noOfHours = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error. input argument was not supplied.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
set @currTime = dbo.getunixtime(getutcdate())
-- errorType=400 ==> NETWORKERROR
select jobId from jmjobinfo t1 where errorType = 400 and state = 2 and
(t1.jobStartTime < @currTime and
(t1.jobStartTime  < @currTime - CAST(@noOfHours AS DECIMAL)*60*60))
and not exists(select t2.jobid from JMBkpAttemptInfo t2 where t2.jobid = t1.jobid)
order by jobid
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetNetworkPendingJobs')
	delete from GxQscripts where name = 'QS_GetNetworkPendingJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetNetworkPendingJobs')
	delete from GXDBVersions where aliasname = 'QS_GetNetworkPendingJobs'
GO

insert into GXDBVersions values(2, 'QS_GetNetworkPendingJobs',  '00000000000000000000', 'QS_GetNetworkPendingJobs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetNetworkPendingJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetNetworkPendingJobs.sql -si numberOfHours
'
 + CHAR(10) + '--   script_name : GetNetworkPendingJobs'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOperationWindow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetOperationWindow <<<'

IF EXISTS (select * from sysobjects where name='QS_GetOperationWindow')
	drop procedure QS_GetOperationWindow
IF EXISTS (select * from GxQscripts where name='QS_GetOperationWindow')
	delete from GxQscripts where name = 'QS_GetOperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindow')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindow'
GO
print '... Creating Procedure: QS_GetOperationWindow'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOperationWindow
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
--SP INPUT PARAMS
  @PARAM1 varchar(1024) = '%s'
AS
-------------------------------------------
-- @PARAM1  IS FILLED IN FROM COMMANDLINE			 --
-------------------------------------------
--DECLARE @PARAM1 varchar(1024)
--SET @PARAM1 ='%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				='GetOperationWindow'
DECLARE @commcellOption			varchar(32)
set		@commcellOption			='cc'
DECLARE @clientGroupOption		varchar(10)
SET		@clientGroupOption		='cg='
DECLARE @clientOption			varchar(10)
SET		@clientOption			='c='
DECLARE @COMMCELLID int
SET		@COMMCELLID = 2
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-----------------------------------------
--SET @PARAM1='cc'
--SET @PARAM1='c=navia'
--SET @PARAM1='cg=g1'
---------------------------------------------
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
	-----------------*****************-------------------
DECLARE @dow TABLE (id int, daysofweek varchar(1024),OperationString varchar(1024))
DECLARE @C INT
SET @C = (
		SELECT COUNT(id)
		FROM APP_OpWindowRule
		)
WHILE(@C<>0)
BEGIN
	DECLARE @days AS INT
	DECLARE @id AS INT
	DECLARE @operations AS INT
	DECLARE @daysofweek AS VARCHAR(1024)
	DECLARE @operationstring AS VARCHAR(1024)
	SELECT @id = Id, @dayS = daysofweek, @operations = opType
	FROM APP_OpWindowRule
	WHERE id = @C
	---------days of week----------
	SET @daysofweek = ''
	IF @days& 1 = 1 SET @DaysOfWeek = @DaysOfWeek +  'Sun'
	IF @days& 2 = 2
	BEGIN
		IF len(@DaysOfWeek) >0 SET @DaysOfWeek =	@DaysOfWeek+ ', '
		SET @DaysOfWeek = @DaysOfWeek +  'Mon'
	END
	IF @days& 4 = 4
	BEGIN
		IF len(@DaysOfWeek) >0 SET @DaysOfWeek =	@DaysOfWeek+ ', '
		SET @DaysOfWeek = @DaysOfWeek +  'Tue'
	END
	IF @days& 8 = 8
	BEGIN
		IF len(@DaysOfWeek) >0 SET @DaysOfWeek =	@DaysOfWeek+ ', '
		SET @DaysOfWeek = @DaysOfWeek +  'Wed'
	END
	IF @days& 16 = 16
	BEGIN
		IF len(@DaysOfWeek) >0 SET @DaysOfWeek =	@DaysOfWeek+ ', '
		SET @DaysOfWeek = @DaysOfWeek +  'Thu'
	END
	IF @days& 32 = 32
	BEGIN
		IF len(@DaysOfWeek) >0 SET @DaysOfWeek =	@DaysOfWeek+ ', '
		SET @DaysOfWeek = @DaysOfWeek +  'Fri'
	END
	IF @days& 64 = 64
	BEGIN
		IF len(@DaysOfWeek) >0 SET @DaysOfWeek =	@DaysOfWeek+ ', '
		SET @DaysOfWeek = @DaysOfWeek +  'Sat'
	END
	-------------------operation string-----------------
	SET @OperationString = ''
	IF @operations & 1		= 1		SET @OperationString =	@OperationString+  'Full Data Management'   --(1<<0)
	IF @operations & 2		= 2
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Non Full Data Management'	--(1<<1)
	END
	IF @operations & 4		= 4
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Synthetic Full'	--(1<<2)
	END
	IF @operations & 8		= 8
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Data Recovery'	--(1<<3)
	END
	IF @operations & 16		= 16
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Auxiliary Copy'	--(1<<4)
	END
	IF @operations & 32		= 32
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Disaster Recovery Backup'	--(1<<5)
	END
	IF @operations & 64		= 64
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Data Verification'	--(1<<6)
	END
	IF @operations & 128	= 128
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Media'	--(1<<7)
	END
	IF @operations & 512	= 512
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Data by browsing'	--(1<<9)
	END
	IF @operations & 1024	= 1024
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Archived Data'	--(1<<10)
	END
	IF @operations & 2048	= 2048
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Offline Content Indexing'	--(1<<11)
	END
	IF @operations & 4096	= 4096
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Online Content Indexing'	--(1<<12)
	END
	IF @operations & 16384	= 16384
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Information Management'	--(1<<14)
	END
	IF @operations & 32768	= 32768
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Media Refreshing'	--(1<<15)
	END
	INSERT @dow
	VALUES(@id , @daysofweek , @Operationstring)
	SET @C=@C - 1
END
		-------------------*********-----------------
--COMMCELL LEVEL RULES
IF SUBSTRING(@PARAM1, 1, 2) = @commcellOption
	SELECT		description,
				D.OperationString  as Operation,
				D.daysofweek as DaysOfWeek,
				SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0))) as StartTime,
				SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0))) as EndTime,
				I.name as iDA
		FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
		INNER JOIN @dow D ON D.id = App_OpWindowRule.Id
		WHERE clientId = @COMMCELLID and apptypeId = 1000
--CLIENT GROUP
ELSE IF SUBSTRING(@PARAM1, 1, 3) = @clientGroupOption
BEGIN
		DECLARE @clientgGroupId int
		SET @clientgGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))),0)
		IF @clientgGroupId = 0
		BEGIN
				SET @localErrorMsg	='Clientgroup  ['+(SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		SELECT 		description,
					D.OperationString  as Operation,
					D.daysofweek as DaysOfWeek,
					SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0))) as StartTime,
					SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0))) as EndTime,
					I.name as iDA
			FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
			INNER JOIN @dow D ON D.id = APP_OpWindowRule .id
			WHERE clientGroupId = (SELECT id from APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3)))
	END
--CLIENT
ELSE IF SUBSTRING(@PARAM1, 1, 2) = @clientOption
BEGIN
		DECLARE @clientId int
		SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
				SET @localErrorMsg	='Client ['+(SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		SELECT	O.description,
				D.OperationString AS OperationString,
				D.daysofweek AS DaysOfWeek,
				SUBSTRING(dbo.GetDateTime2(o.startTime,NULL,0),12, LEN(dbo.GetDateTime2(o.startTime,NULL,0))) as StartTime,
				SUBSTRING(dbo.GetDateTime2(o.endTime,NULL,0),12, LEN(dbo.GetDateTime2(o.endTime,NULL,0))) as EndTime,
				I.name as iDA
		FROM APP_OpWindowRule O
		INNER JOIN APP_Client C ON O.clientId=C.id
		INNER JOIN APP_iDAType I ON O.appTypeId=I.type
		INNER JOIN @dow D ON O.id = D.Id
		WHERE C.id= @clientId
END
ELSE
BEGIN
	SET @localErrorMsg	='Parameter 1 must be cc or cg=client_group_name or c=client_name. ['+@PARAM1+'] not supported.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
ARGS_ERROR:
 if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOperationWindow')
	delete from GxQscripts where name = 'QS_GetOperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindow')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindow'
GO

insert into GXDBVersions values(2, 'QS_GetOperationWindow',  '00000000000000000000', 'QS_GetOperationWindow', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOperationWindow',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetOperationWindow.sql -si cc | cg=client_group_name | c=client_name
'
 + CHAR(10) + '-- 	script_name: GetOperationWindow'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOperationWindowAll.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetOperationWindowAll <<<'

IF EXISTS (select * from sysobjects where name='QS_GetOperationWindowAll')
	drop procedure QS_GetOperationWindowAll
IF EXISTS (select * from GxQscripts where name='QS_GetOperationWindowAll')
	delete from GxQscripts where name = 'QS_GetOperationWindowAll'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindowAll')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindowAll'
GO
print '... Creating Procedure: QS_GetOperationWindowAll'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOperationWindowAll
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
--SP INPUT PARAMS
  @PARAM1 VARCHAR(1024) = '%s'
AS
-------------------------------------------
-- INPUT
-------------------------------------------
--DECLARE @PARAM1 varchar(1024)
--SET @PARAM1 ='%s'
-----------------------------------------
--SET @PARAM1='cc'
--SET @PARAM1='c=navia'
--SET @PARAM1='cg=s1'
---------------------------------------------
---------------- Constants    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				='GetOperationWindow'
DECLARE @commcellOption			varchar(32)
set		@commcellOption			='cc'
DECLARE @clientGroupOption		varchar(10)
SET		@clientGroupOption		='cg='
DECLARE @clientOption			varchar(10)
SET		@clientOption			='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
-------- Get operation window rules-------------
------****************-----------------
--1. Expand the days and operation from the numbers stored in DB to user readable format
DECLARE @dow TABLE (daysOfWeek int, opType int, daysOfWeekString varchar(1024),OperationString varchar(1024))
DECLARE @daysOfWeek AS INT
DECLARE @opType AS INT
IF ( CURSOR_STATUS(N'global', N'APP_OpWindowRuleItr') >= 0  /* cursor is open */
	OR CURSOR_STATUS(N'local', 'APP_OpWindowRuleItr') >= 0 )
		CLOSE APP_OpWindowRuleItr
IF ( CURSOR_STATUS(N'global', N'APP_OpWindowRuleItr') >= -1  /* cursor is open */
	OR CURSOR_STATUS(N'local', 'APP_OpWindowRuleItr') >= -1 )
		DEALLOCATE APP_OpWindowRuleItr
DECLARE APP_OpWindowRuleItr CURSOR
FOR
	SELECT DISTINCT daysOfWeek, opType
	FROM APP_OpWindowRule
OPEN APP_OpWindowRuleItr
FETCH NEXT FROM APP_OpWindowRuleItr INTO @daysOfWeek, @opType
WHILE @@FETCH_STATUS = 0
BEGIN
	---------days of week----------
	DECLARE @daysOfWeekString NVARCHAR(MAX) = N''
	DECLARE @operationString NVARCHAR(MAX) = N''
	IF @daysOfWeek & 1 = 1 SET @daysOfWeekString = @daysOfWeekString +  'Sun'
	IF @daysOfWeek & 2 = 2
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString + ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Mon'
	END
	IF @daysOfWeek & 4 = 4
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Tue'
	END
	IF @daysOfWeek & 8 = 8
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Wed'
	END
	IF @daysOfWeek & 16 = 16
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Thu'
	END
	IF @daysOfWeek & 32 = 32
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Fri'
	END
	IF @daysOfWeek & 64 = 64
	BEGIN
		IF len(@daysOfWeekString) >0 SET @daysOfWeekString =	@daysOfWeekString+ ', '
		SET @daysOfWeekString = @daysOfWeekString +  'Sat'
	END
	-------------------operation string-----------------
	SET @OperationString = ''
	IF @opType & 1		= 1		SET @OperationString =	@OperationString+  'Full Data Management'   --(1<<0)
	IF @opType & 2		= 2
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Non Full Data Management'	--(1<<1)
	END
	IF @opType & 4		= 4
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Synthetic Full'	--(1<<2)
	END
	IF @opType & 8		= 8
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Data Recovery'	--(1<<3)
	END
	IF @opType & 16		= 16
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Auxiliary Copy'	--(1<<4)
	END
	IF @opType & 32		= 32
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Disaster Recovery Backup'	--(1<<5)
	END
	IF @opType & 64		= 64
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Data Verification'	--(1<<6)
	END
	IF @opType & 128	= 128
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Media'	--(1<<7)
	END
	IF @opType & 512	= 512
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Data by browsing'	--(1<<9)
	END
	IF @opType & 1024	= 1024
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Erase Archived Data'	--(1<<10)
	END
	IF @opType & 2048	= 2048
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Offline Content Indexing'	--(1<<11)
	END
	IF @opType & 4096	= 4096
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Online Content Indexing'	--(1<<12)
	END
	IF @opType & 16384	= 16384
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Information Management'	--(1<<14)
	END
	IF @opType & 32768	= 32768
	BEGIN
		IF len(@OperationString) >0 SET @OperationString =	@OperationString+ ', '
		SET @OperationString =	@OperationString+  'Media Refreshing'	--(1<<15)
	END
	INSERT @dow
	VALUES(@daysOfWeek, @optype, @daysofweekString , @Operationstring)
	FETCH NEXT FROM APP_OpWindowRuleItr INTO @daysOfWeek, @opType
END
CLOSE APP_OpWindowRuleItr
DEALLOCATE APP_OpWindowRuleItr
----------------****************------------------
--COMMCELL LEVEL RULES
IF SUBSTRING(@PARAM1, 1, 2) = @commcellOption
	SELECT		description,
				D.OperationString as Operation,
				dbo.GetDateTime2(startDate, NULL, 1) as StartDate,
				dbo.GetDateTime2(endDate, NULL, 1) as EndDate,
				D.daysOfWeekString as DaysOfWeek,
				CASE
					WHEN startTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0)))
					ELSE '12:00AM'
				END as StartTime,
				CASE
					WHEN endTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0)))
					ELSE '12:00AM'
				END as EndTime,
				I.name as iDA,
				 '' as Instance,
				 ''as Backupset,
				 '' as Subclient
		FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
		INNER JOIN @dow D ON (D.daysOfWeek = APP_OpWindowRule.daysOfWeek AND D.opType = APP_OpWindowRule.opType)
		WHERE clientId = 2 and apptypeId = 1000
--CLIENT GROUP
ELSE IF SUBSTRING(@PARAM1, 1, 3) = @clientGroupOption
BEGIN
		DECLARE @clientgGroupId int
		SET @clientgGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))),0)
		IF @clientgGroupId = 0
		BEGIN
				SET @localErrorMsg	='Clientgroup  ['+(SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		SELECT 		description,
					D.OperationString as Operation,
					dbo.GetDateTime2(startDate, NULL, 1) as StartDate,
					dbo.GetDateTime2(endDate, NULL, 1) as EndDate,
					D.daysOfWeekString as DaysOfWeek,
					CASE
						WHEN startTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0)))
						ELSE '12:00AM'
					END as StartTime,
					CASE
						WHEN endTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0)))
						ELSE '12:00AM'
					END as EndTime,
					I.name as iDA,
					'' as Instance,
					'' as Backupset,
					'' as Subclient
			FROM APP_OpWindowRule LEFT JOIN APP_iDAType I on appTypeId=I.type
			INNER JOIN @dow D ON (D.daysOfWeek = APP_OpWindowRule.daysOfWeek AND D.opType = APP_OpWindowRule.opType)
			WHERE clientGroupId = (SELECT id from APP_ClientGroup WHERE name = (SELECT SUBSTRING(@PARAM1, 4, LEN(@PARAM1)-3)))
	END
--CLIENT
ELSE IF SUBSTRING(@PARAM1, 1, 2) = @clientOption
BEGIN
		DECLARE @clientId int
		SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
				SET @localErrorMsg	='Client ['+(SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))+'] does not exist.'
				Set @lastError = 1
				goto   ARGS_ERROR
		END
		SELECT	O.description,
				D.OperationString as Operation,
				D.daysOfWeekString as DaysOfWeek,
				dbo.GetDateTime2(O.startDate, NULL, 1) as StartDate,
				dbo.GetDateTime2(O.endDate, NULL, 1) as EndDate,
				CASE
					WHEN startTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(startTime,NULL,0),12, LEN(dbo.GetDateTime2(startTime,NULL,0)))
					ELSE '12:00AM'
				END as StartTime,
				CASE
					WHEN endTime <> 0 THEN SUBSTRING(dbo.GetDateTime2(endTime,NULL,0),12, LEN(dbo.GetDateTime2(endTime,NULL,0)))
					ELSE '12:00AM'
				END as EndTime,
				Ida.name as iDA,
				ISNULL(Ins.name, '') as Instance,
				ISNULL(Bs.name, '')  as Backupset,
				ISNULL(SC.subclientname, '')  as Subclient
		FROM APP_OpWindowRule O
		LEFT JOIN APP_Client C ON O.clientId=C.id
		LEFT JOIN APP_iDAType Ida ON O.appTypeId=Ida.type
		LEFT JOIN APP_InstanceName Ins ON O.instanceId=Ins.id and Ins.id >1
		LEFT JOIN APP_BackupsetName BS ON O.backupsetId=BS.id
		LEFT JOIN APP_Application SC ON O.subclientId=SC.id
		INNER JOIN @dow D ON (D.daysOfWeek = O.daysOfWeek AND D.opType = O.opType)
		WHERE C.id= @clientId AND (O.appTypeId <> 1000)		--Operation window specified at commcell level gets saved as clientId = 2 and apptypeid = 1000
															--This should not come and mess up with the output when queried against clientId = 2 at client level
END
ELSE
BEGIN
	SET @localErrorMsg	='Parameter 1 must be cc or cg=client_group_name or c=client_name. ['+@PARAM1+'] not supported.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOperationWindowAll')
	delete from GxQscripts where name = 'QS_GetOperationWindowAll'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOperationWindowAll')
	delete from GXDBVersions where aliasname = 'QS_GetOperationWindowAll'
GO

insert into GXDBVersions values(2, 'QS_GetOperationWindowAll',  '00000000000000000000', 'QS_GetOperationWindowAll', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOperationWindowAll',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetOperationWindowAll.sql -si cc | cg=client_group_name | c=client_name
'
 + CHAR(10) + '-- 	script_name: GetOperationWindowAll'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetOraclecredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetOraclecredentials <<<'

IF EXISTS (select * from sysobjects where name='QS_GetOraclecredentials')
	drop procedure QS_GetOraclecredentials
IF EXISTS (select * from GxQscripts where name='QS_GetOraclecredentials')
	delete from GxQscripts where name = 'QS_GetOraclecredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOraclecredentials')
	delete from GXDBVersions where aliasname = 'QS_GetOraclecredentials'
GO
print '... Creating Procedure: QS_GetOraclecredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetOraclecredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM2 = '%s'					-- Type (Catalog, DB, (user) impersonate
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @PARAM1 =	'c=TESTRAC'
-- SET @PARAM1 =	'allclients'
--SET @PARAM2 =	't=DB'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetOraclecredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
-----
DECLARE @CV_ORACLE_CATALOG_CONNECT		varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT		= 'Catalog Connect'
DECLARE @CV_ORACLE_CATALOG_CONNECT_PWD	varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT_PWD	= 'Catalog Connect Password'
-----
DECLARE @CV_ORACLE_SQL_CONNECT			varchar(40)
SET		@CV_ORACLE_SQL_CONNECT			= 'SQL Connect'
DECLARE @CV_ORACLE_SQL_CONNECT_PWD		varchar(40)
SET		@CV_ORACLE_SQL_CONNECT_PWD		= 'SQL Connect Password'
-----
DECLARE @CV_ORACLE_DOMAIN_NAME			varchar(40)
SET		@CV_ORACLE_DOMAIN_NAME			= 'Domain Name'
DECLARE @CV_ORACLE_DOMAIN_USER_PASSWORD	varchar(40)
SET		@CV_ORACLE_DOMAIN_USER_PASSWORD	= 'Domain User Password'
DECLARE	@CV_ORACLE_USER_NAME			varchar(40)
SET		@CV_ORACLE_USER_NAME			='Oracle User'
-----
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
DECLARE @domainName				nvarchar(1024)
SET		@domainName				=''
DECLARE @useConnect				nvarchar(40)
SET		@useConnect				=''
DECLARE @usePassword			nvarchar(40)
SET		@usePassword			=''
DECLARE	@isOracleRAC			integer
SET		@isOracleRAC			= 0
DECLARE @SlashPosn				int
DECLARE @Domain					nvarchar(1024)
DECLARE @currentUserName        nvarchar(512)
DECLARE @currentPassword        nvarchar(512)
DECLARE @currentClientName      nvarchar(512)
DECLARE @currentDomainName      nvarchar(512)
DECLARE @componentNameId        int
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
---------------------------------------
---       CREDENTIALS TYPE			---
-- Type is one of:					---
--   Catalog, DB, user impersonate  ---
--   or Oracle RAC					---
---------------------------------------
IF @PARAM2 = 't=Catalog'
BEGIN
	SET		@useConnect				=@CV_ORACLE_CATALOG_CONNECT
	SET		@usePassword			=@CV_ORACLE_CATALOG_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=DB'
BEGIN
	SET		@useConnect				=@CV_ORACLE_SQL_CONNECT
	SET		@usePassword			=@CV_ORACLE_SQL_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=Impersonate'
BEGIN
--	SET		@useConnect				=@CV_ORACLE_DOMAIN_NAME
	SET		@useConnect				=@CV_ORACLE_USER_NAME
	SET		@usePassword			=@CV_ORACLE_DOMAIN_USER_PASSWORD
END
ELSE IF @PARAM2 = 't=RAC'
	SET		@isOracleRAC = 1
-----
ELSE
BEGIN
	SET @localErrorMsg	='Error. Parameter 2 must be specified as t=Catalog|DB|Impersonate|RAC.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1 +', ' +@PARAM2+ ')'
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
	IF object_id('tempdb.dbo.OracleCredentialsList') is not null DROP TABLE #OracleCredentialsList
	CREATE TABLE #OracleCredentialsList
	(
	clientName nvarchar(512),
	--domainName nvarchar(512)
	userName nvarchar(512),
	encryptedPassword nvarchar(512)
	)
	IF @IsOracleRAC = 0
	BEGIN
		IF @clientId = 0
			DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE appTypeId in (2, 22, 80))
		ELSE
          	DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE clientID = @clientId AND appTypeId in (2, 22, 80))
		OPEN GetUserNameList
			FETCH GetUserNameList INTO @componentNameId, @currentUserName
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @currentPassword = AttrVal from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @usePassword
				SELECT @currentClientName = name from APP_Client,APP_APPLICATION where APP_APPLICATION.instance = @componentNameId AND APP_APPLICATION.clientId=APP_Client.id
				--SELECT @domainName = AttrVal from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @CV_ORACLE_DOMAIN_NAME
				INSERT INTO #OracleCredentialsList (clientName, userName, encryptedPassword) VALUES(@currentClientName, @currentUserName , @currentPassword)
				FETCH GetUserNameList INTO @componentNameId, @currentUserName
			END
		CLOSE GetUserNameList
		DEALLOCATE GetUserNameList
	END
    ELSE
	IF @clientId = 0
	BEGIN
        INSERT INTO #OracleCredentialsList SELECT DISTINCT  APP_client.name as clientName,InstanceOraUser as userName ,InstanceOraPasswd as  encryptedPassword from  APP_OracleRACInstance,app_application,APP_client
        WHERE 	instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80) AND APP_client.id = app_application.clientId
	END
	ELSE
	BEGIN
		INSERT INTO #OracleCredentialsList SELECT DISTINCT  APP_client.name as clientName,InstanceOraUser as userName ,InstanceOraPasswd as  encryptedPassword from  APP_OracleRACInstance,app_application,APP_client
        WHERE 	instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80) AND APP_client.id = app_application.clientId AND app_application.clientId = @clientID
    END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems Getting Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit   Tran
--	rollback Tran				-- For Debugging
ELSE
	rollback Tran
SELECT clientName,userName,encryptedPassword from #OracleCredentialsList
DROP TABLE #OracleCredentialsList
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( '
		 +REPLACE(@PARAM1, @NoParameter, '[]') +', '
		 +REPLACE(@PARAM2, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetOraclecredentials')
	delete from GxQscripts where name = 'QS_GetOraclecredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetOraclecredentials')
	delete from GXDBVersions where aliasname = 'QS_GetOraclecredentials'
GO

insert into GXDBVersions values(2, 'QS_GetOraclecredentials',  '00000000000000000000', 'QS_GetOraclecredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetOraclecredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qscript -f GetOracleCredentials -i c=clientName|allclients t=Catalog|DB|Impersonate|RAC
'
 + CHAR(10) + '--   script_name : GetOraclecredentials'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSchedulePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSchedulePolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSchedulePolicy')
	drop procedure QS_GetSchedulePolicy
IF EXISTS (select * from GxQscripts where name='QS_GetSchedulePolicy')
	delete from GxQscripts where name = 'QS_GetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSchedulePolicy'
GO
print '... Creating Procedure: QS_GetSchedulePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSchedulePolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=iida7w2k8_cn'
--SET		@PARAM2= 'a=Q_WINXP32_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetSchedulePolicy'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------ Get ids    -----------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
 SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
------------ Get schedule policy   -----------
SELECT T.taskName as SchedulePolicy, ST.subTaskName as ScheduleName, PT.description  as Details, T.description as Description
FROM TM_Task AS T
INNER JOIN TM_AssocEntity AS TA ON TA.taskId=T.taskId
INNER JOIN TM_SubTask AS ST ON ST.taskId=T.taskId
INNER JOIN TM_PatternAssoc AS PA ON PA.subTaskId=ST.subTaskId
INNER JOIN TM_Pattern AS PT ON PT.patternId=PA.patternId
WHERE taskType=4 and TA.clientId =  @ClientId and TA.AppTypeId = 0 and TA.InstanceId = 0 and TA.backupsetId = 0 and TA.subClientId = 0
UNION
SELECT T.taskName as SchedulePolicy, ST.subTaskName as ScheduleName, PT.description   as Details, T.description as Description
FROM TM_Task AS T
INNER JOIN TM_AssocEntity AS TA ON TA.taskId=T.taskId
INNER JOIN TM_SubTask AS ST ON ST.taskId=T.taskId
INNER JOIN TM_PatternAssoc AS PA ON PA.subTaskId=ST.subTaskId
INNER JOIN TM_Pattern AS PT ON PT.patternId=PA.patternId
WHERE taskType=4 and TA.clientId =  @ClientId and TA.AppTypeId = @AppTypeId and TA.InstanceId = 0 and TA.backupsetId = 0 and TA.subClientId = 0
UNION
SELECT T.taskName as SchedulePolicy, ST.subTaskName as ScheduleName, PT.description   as Details, T.description as Description
FROM TM_Task AS T
INNER JOIN TM_AssocEntity AS TA ON TA.taskId=T.taskId
INNER JOIN TM_SubTask AS ST ON ST.taskId=T.taskId
INNER JOIN TM_PatternAssoc AS PA ON PA.subTaskId=ST.subTaskId
INNER JOIN TM_Pattern AS PT ON PT.patternId=PA.patternId
WHERE taskType=4 and TA.clientId =  @ClientId and TA.AppTypeId = @AppTypeId and TA.InstanceId = @InstanceId and TA.backupsetId = 0 and TA.subClientId = 0
UNION
SELECT T.taskName as SchedulePolicy, ST.subTaskName as ScheduleName, PT.description   as Details, T.description as Description
FROM TM_Task AS T
INNER JOIN TM_AssocEntity AS TA ON TA.taskId=T.taskId
INNER JOIN TM_SubTask AS ST ON ST.taskId=T.taskId
INNER JOIN TM_PatternAssoc AS PA ON PA.subTaskId=ST.subTaskId
INNER JOIN TM_Pattern AS PT ON PT.patternId=PA.patternId
WHERE taskType=4 and TA.clientId =  @ClientId and TA.AppTypeId = @AppTypeId and TA.InstanceId = @InstanceId and TA.backupsetId = @BackupsetId and TA.subClientId = 0
UNION
SELECT T.taskName as SchedulePolicy, ST.subTaskName as ScheduleName, PT.description   as Details, T.description as Description
FROM TM_Task AS T
INNER JOIN TM_AssocEntity AS TA ON TA.taskId=T.taskId
INNER JOIN TM_SubTask AS ST ON ST.taskId=T.taskId
INNER JOIN TM_PatternAssoc AS PA ON PA.subTaskId=ST.subTaskId
INNER JOIN TM_Pattern AS PT ON PT.patternId=PA.patternId
WHERE taskType=4 and TA.clientId =  @ClientId and TA.AppTypeId = @AppTypeId and TA.InstanceId = @InstanceId and TA.backupsetId = @BackupsetId and TA.subClientId = @subclientId
ARGS_ERROR:
/*PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'*/
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSchedulePolicy')
	delete from GxQscripts where name = 'QS_GetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSchedulePolicy'
GO

insert into GXDBVersions values(2, 'QS_GetSchedulePolicy',  '00000000000000000000', 'QS_GetSchedulePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSchedulePolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSchedulePolicy.sql -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : GetSchedulePolicy'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSQLSubclientConf.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSQLSubclientConf <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSQLSubclientConf')
	drop procedure QS_GetSQLSubclientConf
IF EXISTS (select * from GxQscripts where name='QS_GetSQLSubclientConf')
	delete from GxQscripts where name = 'QS_GetSQLSubclientConf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLSubclientConf')
	delete from GXDBVersions where aliasname = 'QS_GetSQLSubclientConf'
GO
print '... Creating Procedure: QS_GetSQLSubclientConf'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSQLSubclientConf
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=bingo'
--SET		@PARAM2= 'a=Q_MSSQL'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetSQLSubclientConf'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
----------- Get ids   -------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
----------- Get SQL subclient content   -------------
SELECT SCP.attrName	as 'Database' FROM APP_SubClientProp SCP
	WHERE SCP.attrType='118'
	AND SCP.modified='0'
	AND SCP.componentNameId = @subclientId
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSQLSubclientConf')
	delete from GxQscripts where name = 'QS_GetSQLSubclientConf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSQLSubclientConf')
	delete from GXDBVersions where aliasname = 'QS_GetSQLSubclientConf'
GO

insert into GXDBVersions values(2, 'QS_GetSQLSubclientConf',  '00000000000000000000', 'QS_GetSQLSubclientConf', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSQLSubclientConf',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSQLSubclientConf.sql  -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : GetSQLSubclientConf'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSubclientConf.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSubclientConf <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSubclientConf')
	drop procedure QS_GetSubclientConf
IF EXISTS (select * from GxQscripts where name='QS_GetSubclientConf')
	delete from GxQscripts where name = 'QS_GetSubclientConf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclientConf')
	delete from GXDBVersions where aliasname = 'QS_GetSubclientConf'
GO
print '... Creating Procedure: QS_GetSubclientConf'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSubclientConf
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=bingo'
--SET		@PARAM2= 'a=Q_WINNET_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetSubclientConf'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
--------------------- Get ids --------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
--Get Global filter settings first
DECLARE @GlobalFilterState varchar(32)
DECLARE @propName1 varchar(50)
SET @propName1 = 'use cs setting for Global Filters'
DECLARE @propName2 varchar(32)
SET @propName2 = 'Use Global Filters'
DECLARE @scpid integer
SET @scpid = ISNULL((select attrval from app_backupsetprop where attrname like 'Associated subclient Policy'
   and componentnameid = @backupsetid and modified = 0),0)
DECLARE @useSCPfilters integer
if @scpid >0
begin
	SET @useSCPfilters = ISNULL((select attrval from app_subclientprop where attrname like 'use SCP filters' AND componentNameId = @subclientId and modified = 0), 0)
end
IF @useSCPfilters <> 0
	SET @GlobalFilterState = 'NOT APPLICABLE (SUBCLIENT POLICY)'
ELSE IF @AppTypeId NOT IN (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43, 54,56,57,58, 63,64,74,86, 105,106)
	SET @GlobalFilterState = 'NOT APPLICABLE'
ELSE IF (ISNULL(( SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1), '1')= '0')
BEGIN
	IF(ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2), '0') = '1')
		SET @GlobalFilterState = 'ON'
	ELSE
		SET @GlobalFilterState = 'OFF'
END
ELSE
	SET @GlobalFilterState = 'USE CELL LEVEL POLICY'
--Get schedulePolicy
SELECT
	(CASE(FC.type)
		WHEN 1 THEN 'Content'
		WHEN 2 THEN 'Except'
		WHEN 3 THEN 'Exclude'
		WHEN 4 THEN 'Except file'
		WHEN 5 THEN 'Exclude file'
		ELSE 'Unknown'
	END) AS Property, FC.filename AS Value
	FROM APP_ScFilterFile FC
	JOIN APP_Application AP ON AP.id=FC.componentNameId AND FC.modified=0
	WHERE AP.id=@subclientId
UNION
SELECT 'Global Filters',  @GlobalFilterState
UNION
SELECT 'Schedule Policy ', T.taskName
	FROM TM_Task T (NOLOCK)
	JOIN TM_AssocEntity E (NOLOCK) ON E.taskId = T.taskId AND T.taskType = 4 AND E.exclude = 0
	WHERE
	(
		(
			E.clientId = @ClientId AND E.apptypeId = 0 AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = @BackupsetId AND E.subclientId = 0
		)
		OR
		(
			E.clientId = @ClientId AND E.apptypeId = @AppTypeId AND E.instanceId = @InstanceId AND E.backupsetId = @BackupsetId AND E.subclientId = @subclientId
		)
		OR
		(
			E.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientId = @ClientId) AND E.clientId = 0 AND E.apptypeId = 0 AND E.instanceId = 0 AND E.backupsetId = 0 AND E.subclientId = 0
		)
		OR
		(
			E.assocType = 2
		)
	)
	AND NOT EXISTS
	(
		SELECT 1 FROM TM_AssocEntity AE WHERE
		(
			AE.clientId=@ClientId
			AND ( AE.apptypeId=@AppTypeId OR AE.apptypeId=0)
			AND (AE.instanceId=@InstanceId OR AE.instanceId=0)
			AND (AE.backupsetId=@BackupsetId OR AE.backupsetId=0)
			AND (AE.subclientId=@subclientId OR AE.subclientId=0)
			AND AE.exclude = 1
			AND AE.taskId = E.taskId
		)
	)
	AND
	(	--CHECK FOR AGENT TYPE
		(
			EXISTS ( SELECT taskId
						FROM [TM_AssocFilter] WITH (NOLOCK)
						WHERE taskId = T.taskId
					)
			AND
			EXISTS
			( SELECT taskId
				FROM [TM_AssocFilter] FLT WITH (NOLOCK)
				WHERE FLT.taskId = T.taskId
				AND
				(  -- filter_type, 1 is appgroup and 2 is individual apptype
					(
						FLT.filter_type = 2
						AND
						(
							FLT.filter_value = @appTypeId
							OR
							( @appTypeId = 0 AND FLT.filter_value IN (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE clientId=@clientId) )
						)
					)
					OR
					(
						FLT.filter_type = 1
						AND EXISTS
						(
							SELECT FLT.filter_value
							FROM [APP_AppTypeGroupAssoc] WITH (NOLOCK)
							WHERE appGroupId = FLT.filter_value
							AND
							(
								appTypeId = @appTypeId
								OR
								( @appTypeId = 0 AND appTypeId IN (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE clientId=@clientId) )
							)
						)
					)
				)
			)
			OR
			NOT EXISTS ( SELECT taskId
						FROM [TM_AssocFilter] WITH (NOLOCK)
						WHERE taskId = T.taskId
					)
		)
	)
--MSSQL Database files
UNION
SELECT 'SQL Database', SCP.attrName
	FROM APP_SubClientProp SCP
	WHERE SCP.attrType='118'
	AND SCP.modified='0'
	AND SCP.componentNameId = @subclientId
ARGS_ERROR:
/*PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'*/
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSubclientConf')
	delete from GxQscripts where name = 'QS_GetSubclientConf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclientConf')
	delete from GXDBVersions where aliasname = 'QS_GetSubclientConf'
GO

insert into GXDBVersions values(2, 'QS_GetSubclientConf',  '00000000000000000000', 'QS_GetSubclientConf', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSubclientConf',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn GetSubclientConf.sql -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + ' 
'
 + CHAR(10) + ' Example
'
 + CHAR(10) + ' qoperation execscript -sn GetSubclientConf.sql -si c=desktop -si a=Q_WINDOWS_FS -si s=default
'
 + CHAR(10) + ' 
'
 + CHAR(10) + ' app_type_name is the argument value for the agent, for example, Q_ORACLE.
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--   script_name : GetSubclientConf'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetSubClientPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetSubclientPolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_GetSubclientPolicy')
	drop procedure QS_GetSubclientPolicy
IF EXISTS (select * from GxQscripts where name='QS_GetSubclientPolicy')
	delete from GxQscripts where name = 'QS_GetSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubclientPolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSubclientPolicy'
GO
print '... Creating Procedure: QS_GetSubclientPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetSubclientPolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @param1 varchar(1030) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs--------------------
--DECLARE @param1  NVARCHAR(1030)
--SET @param1 = '%s'
------------------input prefixes-------------------------
DECLARE @clientPrefix  NVARCHAR(32)
SET @clientPrefix = 'c='
DECLARE @scPolicyPrefix NVARCHAR(32)
SET @scPolicyPrefix = 'scp='
---------------------------Sample Input------------------------
--SET @param1 = 'c=kubica_cn'
--SET @param1 = 'scp=SCP2'
---------------------------------------------------------
----------------------script Name-------------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'GetSubclientPolicy'
-----------------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @param1 = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Please provide client name or subclient policy name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters------------------------------
DECLARE @clientName NVARCHAR(1024)
SET @clientName = ''
DECLARE @subclientPolicyName NVARCHAR(1024)
SET @subclientPolicyName = ''
IF SUBSTRING(@param1, 1, 2) = @clientPrefix
	SET @clientName =  SUBSTRING(@param1, 3, LEN(@param1)-2)
ELSE IF SUBSTRING(@param1, 1, 4) = @scPolicyPrefix
	SET @subclientPolicyName =  SUBSTRING(@param1, 5, LEN(@param1)-4)
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']'
	GOTO ARGS_ERROR
END
IF @clientName = '' AND @subclientPolicyName = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']. Please provide client name or subclient policy name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters II------------------------------
DECLARE @clientId integer
SET @clientId = ISNULL((SELECT id FROM app_client WHERE name = @clientName), 0)
DECLARE @subclientPolicyId integer
SET @subclientPolicyId = ISNULL((SELECT DISTINCT B.id FROM APP_BackupSetName B INNER JOIN APP_Application A ON A.backupSet = B.id WHERE B.name = @subclientPolicyName AND A.appTypeId = 1030), 0)
IF @clientName <> '' AND @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+ @clientName +'] does not exist.'
	GOTO ARGS_ERROR
END
IF @subclientPolicyName <> '' AND @subclientPolicyId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. SubclientPolicy ['+ @subclientPolicyName +'] does not exist.'
	GOTO ARGS_ERROR
END
-----------------		Create a temporary table with clientId, backupsetId, subclientPolicyId triplet  ------------------------
IF object_id('tempdb.dbo.#SubclientPolicyId_Tbl') is not null
DROP TABLE #SubclientPolicyId_Tbl
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SubclientPolicyId_Tbl')
	DROP TABLE #SubclientPolicyId_Tbl
CREATE TABLE #SubclientPolicyId_Tbl
	(clientId INT,clientName varchar(255), backupsetId INT,backupsetName varchar(255), subclientPolicyId INT)
INSERT INTO #SubclientPolicyId_Tbl(clientId, clientName, backupsetId, backupsetName, subclientPolicyId)
(
	SELECT DISTINCT C.id, C.name, BSP.componentNameId, B.name, BSP.attrVal
	FROM APP_Client C,APP_BackupSetProp BSP
	INNER JOIN APP_BackupSetName B ON BSP.componentNameId = B.id
	INNER JOIN APP_Application A ON A.backupSet = B.id
	WHERE BSP.attrName = 'Associated subclient Policy' and BSP.modified =0
	AND C.id = A.clientId
	AND BSP.attrVal >0							-- Positive attrval
	AND (A.subclientStatus & 0x4) <> 0x4		--Not deleted
)
--select * from #SubclientPolicyId_Tbl
------------------------get clients/client groups------------------------
IF @clientId > 0
	SELECT DISTINCT P.backupsetName AS 'BackupsetName',B.name as 'SubclientPolicyName'
	FROM #SubclientPolicyId_Tbl P INNER JOIN APP_BackupSetName B  ON P.subclientPolicyId = B.id
	INNER JOIN APP_Application A ON A.backupSet = P.subclientPolicyId
	WHERE P.clientId = @clientId
	AND A.appTypeId = 1030
ELSE IF @subclientPolicyId > 0
	SELECT DISTINCT P.clientName as 'ClientName',P.backupsetName AS 'BackupsetName'
	FROM #SubclientPolicyId_Tbl P INNER JOIN APP_Application A ON P.subclientPolicyId = A.backupSet
	WHERE P.subclientPolicyId = @subclientPolicyId
	AND A.appTypeId = 1030
--DROP TABLE #SubclientPolicyId_Tbl
ARGS_ERROR:
print @scriptName + 'completed at '	+ Convert(varchar(60), getdate())+' with parameters client 	['+ @clientName +'] or subclientPolicy ['+ @subclientPolicyName +']. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetSubClientPolicy')
	delete from GxQscripts where name = 'QS_GetSubClientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetSubClientPolicy')
	delete from GXDBVersions where aliasname = 'QS_GetSubClientPolicy'
GO

insert into GXDBVersions values(2, 'QS_GetSubClientPolicy',  '00000000000000000000', 'QS_GetSubClientPolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetSubClientPolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetSubclientPolicy.sql -si scp=subclient_policy_name/c=client_name
'
 + CHAR(10) + '--   script_name : GetSubclientPolicy'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MergeVirtualclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_mergeVirtualClient <<<'

IF EXISTS (select * from sysobjects where name='QS_mergeVirtualClient')
	drop procedure QS_mergeVirtualClient
IF EXISTS (select * from GxQscripts where name='QS_mergeVirtualClient')
	delete from GxQscripts where name = 'QS_mergeVirtualClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_mergeVirtualClient')
	delete from GXDBVersions where aliasname = 'QS_mergeVirtualClient'
GO
print '... Creating Procedure: QS_mergeVirtualClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_mergeVirtualClient
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM_1 varchar(1024) = '%s',
  @PARAM_2 varchar(1024) = '%s',
  @PARAM_3 varchar(1024) = '%s',
  @PARAM_4 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER   			 --
-------------------------------------------
--DECLARE @PARAM_1		varchar(1024)
--DECLARE @PARAM_2		varchar(1024)
--DECLARE @PARAM_3		varchar(1024)
--DECLARE @PARAM_4		varchar(1024)
--SET		@PARAM_1		= '%s'
--SET		@PARAM_2		= '%s'
--SET		@PARAM_3		= '%s'
--SET		@PARAM_4		= '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName			varchar(32)
SET	@scriptName			= 'mergeVirtualClient'
DECLARE @lastError			integer
SET	@lastError			= 0
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter			=@NoParameter + 's'         -- .. Substitution
DECLARE @Option_Galaxy			varchar(1024)
SET	@Option_Galaxy			= 'sim'
DECLARE @Option_Virtual			varchar(1024)
SET	@Option_Virtual			= 'virt'
DECLARE @VirtualFlag			integer
SET	@VirtualFlag			= 11
DECLARE @galaxyClientName 		varchar(1024)
SET 	@galaxyClientName		= NULL
DECLARE @galaxyClientId 		integer
SET 	@galaxyClientId			= 0
DECLARE @galaxyClientSpecialFlags	integer
DECLARE @virtualClientName 		varchar(1024)
SET 	@virtualClientName		= NULL
DECLARE @virtualClientId 		integer
SET 	@virtualClientId		= 0
DECLARE @virtualClientSpecialFlags	integer
DECLARE @propId 			integer
DECLARE @propValue 			varchar(1064)
DECLARE @unixTime 			integer
SET 	@unixTime 			= dbo.GetUnixTime(GetUTCDate())
IF @PARAM_1 = @Option_Galaxy
BEGIN
	SET @galaxyClientName = @PARAM_2
END
ELSE IF @PARAM_1 = @Option_Virtual
BEGIN
	SET @virtualClientName = @PARAM_2
END
IF @PARAM_3 = @Option_Galaxy
BEGIN
	SET @galaxyClientName = @PARAM_4
END
ELSE IF @PARAM_3 = @Option_Virtual
BEGIN
	SET @virtualClientName = @PARAM_4
END
IF @galaxyClientName = NULL OR @virtualClientName = NULL
BEGIN
	SET @localErrorMsg = 'Error.  Missing client name input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @galaxyClientId = (SELECT id FROM APP_Client WHERE name = @galaxyClientName)
SET @galaxyClientSpecialFlags = (SELECT specialClientFlags FROM APP_Client WHERE name = @galaxyClientName)
IF @galaxyClientId = 0 OR @galaxyClientSpecialFlags = @VirtualFlag
BEGIN
	SET @localErrorMsg = 'Error.  Galaxy client not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @virtualClientId = (SELECT id FROM APP_Client WHERE name = @virtualClientName)
SET @virtualClientSpecialFlags = (SELECT specialClientFlags FROM APP_Client WHERE name = @virtualClientName)
IF @virtualClientId = 0 OR @virtualClientSpecialFlags != @VirtualFlag
BEGIN
	SET @localErrorMsg = 'Error.  Virtual client not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
BEGIN TRAN
BEGIN TRY
--Update the AppClientProps and VM Hosts
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Name' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine Name' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine Name' AND modified = 0) WHERE id = @propId
END
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine GUID' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine GUID' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine GUID' AND modified = 0) WHERE id = @propId
END
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine Host Name' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine Host Name' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine Host Name' AND modified = 0) WHERE id = @propId
END
SET @propId = null
SET @propValue = null
select @propId = id, @propValue = attrVal from APP_ClientProp where attrName = 'Virtual Machine IP Address' and modified = 0 and componentNameId = @galaxyClientId
IF @propId is null
BEGIN
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @galaxyClientId, attrName, 1, attrVal, @unixTime, 0 FROM APP_ClientProp
		WHERE componentNameId = @virtualClientId AND attrName = 'Virtual Machine IP Address' AND modified = 0
END
ELSE
BEGIN
	UPDATE APP_ClientProp SET attrVal = (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @virtualClientId
		AND attrName = 'Virtual Machine IP Address' AND modified = 0) WHERE id = @propId
END
UPDATE App_VM SET clientId = @galaxyClientId WHERE clientId = @virtualClientId
--Delete @currentAppClientId from app_client
DELETE FROM APP_ClientGroupAssoc WHERE clientId = @virtualClientId
DELETE FROM APP_ClientProp WHERE componentNameId = @virtualClientId
DELETE FROM APP_Platform WHERE clientId = @virtualClientId
DELETE FROM APP_Client WHERE id = @virtualClientId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
	set @lastError = ERROR_NUMBER()
    	set @localErrorMsg = @localErrorMsg + ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
PRINT ' '
PRINT 'Script ' + @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: '
PRINT '   ' + REPLACE(@PARAM_1, @NoParameter, '[]')
PRINT '   ' + REPLACE(@PARAM_2, @NoParameter, '[]')
PRINT '   ' + REPLACE(@PARAM_3, @NoParameter, '[]')
PRINT '   ' + REPLACE(@PARAM_4, @NoParameter, '[]')
PRINT 'Exit Code(' + convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MergeVirtualclient')
	delete from GxQscripts where name = 'QS_MergeVirtualclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MergeVirtualclient')
	delete from GXDBVersions where aliasname = 'QS_MergeVirtualclient'
GO

insert into GXDBVersions values(2, 'QS_MergeVirtualclient',  '00000000000000000000', 'QS_MergeVirtualclient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MergeVirtualclient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '   Qscript -f mergeVirtualClient.sql -i sim clientName_1 virt clientName_2 
'
 + CHAR(10) + '--   script_name : mergeVirtualClient'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_MoveNASSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_MoveNASSubclient <<<'

IF EXISTS (select * from sysobjects where name='QS_MoveNASSubclient')
	drop procedure QS_MoveNASSubclient
IF EXISTS (select * from GxQscripts where name='QS_MoveNASSubclient')
	delete from GxQscripts where name = 'QS_MoveNASSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveNASSubclient')
	delete from GXDBVersions where aliasname = 'QS_MoveNASSubclient'
GO
print '... Creating Procedure: QS_MoveNASSubclient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_MoveNASSubclient
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @srcClientName varchar(1024) = '%s',
  @srcBsetName varchar(1024) = '%s',
  @srcSCName varchar(1024) = '%s',
  @destClientName varchar(1024) = '%s',
  @destBsetName varchar(1024) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs-------
--DECLARE @srcClientName nvarchar(1024)
--SET @srcClientName = '%s'
--DECLARE @srcBsetName nvarchar(1024)
--SET @srcBsetName = '%s'
--DECLARE @srcSCName nvarchar(1024)
--SET @srcSCName = '%s'
--DECLARE @destClientName nvarchar(1024)
--SET @destClientName = '%s'
--DECLARE @destBsetName nvarchar(1024)
--SET @destBsetName = '%s'
------------------------------
--SET @srcClientName = '%s'
--SET @srcBsetName = '%s'
--SET @srcSCName = '%s'
--SET @destClientName = '%s'
--SET @destBsetame = '%s'
------------------------------
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'MoveNASSubclient'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @srcClientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No input was given.'
	GOTO ARGS_ERROR
END
---------------------validate input-------------------------
DECLARE @srcClientId integer
DECLARE @srcBsetId integer
DECLARE @srcSCID integer
DECLARE @destClientID integer
DECLARE @destBsetID integer
SET @srcClientId = ISNULL((SELECT id from APP_Client where name like @srcClientName), 0)
IF @srcClientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@srcClientName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @srcBsetId = ISNULL((Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
                      where APP.clientId = @srcClientId
						AND APP.backupSet = BSN.id
						AND BSN.name = @srcBsetName
						AND appTypeId = 13  --CV_APPTYPE_NAS_FS
						), 0)
IF @srcBsetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Backupset ['+@srcBsetName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @srcSCId = ISNULL((Select DISTINCT id FROM APP_APPLICATION
                      where clientId = @srcClientId
						AND backupSet = @srcBsetId
						AND appTypeId = 13  --CV_APPTYPE_NAS_FS
						AND subclientName = @srcSCName
						AND subClientStatus & 2 <>2
						AND subclientStatus & 4 <> 4 --UNINSTALLED, DELETED
						), 0)
IF @srcSCId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient ['+@srcSCName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @destClientId = ISNULL((SELECT id from APP_Client where name like @destClientName), 0)
IF @destClientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+@destClientName+'] does not exist.'
	GOTO ARGS_ERROR
END
SET @destBsetId = ISNULL((Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
                      where APP.clientId = @destClientId
						AND APP.backupSet = BSN.id
						AND BSN.name = @destBsetName
						AND appTypeId = 13  --CV_APPTYPE_NAS_FS
						), 0)
IF @destBsetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Backupset ['+@destBsetName+'] does not exist.'
	GOTO ARGS_ERROR
END
IF exists (select 1 from app_application where @destClientId=clientId and @destBsetId=backupSet and subclientName = @srcSCName AND subClientStatus & 2 <>2 AND subclientStatus & 4 <> 4)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient with name ['+@srcSCName+'] already exists in Destination Client'
	GOTO ARGS_ERROR
END
--exists but is deleted,So append the timestamp
IF exists (select 1 from app_application where @destClientId=clientId and @destBsetId=backupSet and subclientName = @srcSCName AND subClientStatus&4 = 4)
BEGIN
UPDATE APP_Application SET subclientName = subclientName+'_'+CAST(modified AS NVARCHAR(10)) WHERE @destClientId=clientId and @destBsetId=backupSet and subclientName = @srcSCName
END
-------------------------Move subclient---------------
BEGIN TRY
BEGIN TRAN
UPDATE APP_Application SET clientId = @destClientId, backupset = @destBsetId, modified = @nowTime
		WHERE  id = @srcSCId
UPDATE SchedBackupTask SET clientId = @destClientId, backupset = @destBsetId
		WHERE clientId = @srcClientId
		AND subclient = @srcSCId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Problems updating Job Result Information ' +ERROR_MESSAGE()
END
END CATCH
IF (@errorCode  = 0)
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + '. Exit Code(' +convert(varchar(2), @errorCode) + ').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_MoveNASSubclient')
	delete from GxQscripts where name = 'QS_MoveNASSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_MoveNASSubclient')
	delete from GXDBVersions where aliasname = 'QS_MoveNASSubclient'
GO

insert into GXDBVersions values(2, 'QS_MoveNASSubclient',  '00000000000000000000', 'QS_MoveNASSubclient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_MoveNASSubclient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn MoveNASSubclient.sql -si source_client_Name -si source_backupset -si source_subclient -si dest_client -si dest_backupset
'
 + CHAR(10) + '--   script_name : MoveNASSubclient'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PromoteToFullById.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PromoteToFullById <<<'

IF EXISTS (select * from sysobjects where name='QS_PromoteToFullById')
	drop procedure QS_PromoteToFullById
IF EXISTS (select * from GxQscripts where name='QS_PromoteToFullById')
	delete from GxQscripts where name = 'QS_PromoteToFullById'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PromoteToFullById')
	delete from GXDBVersions where aliasname = 'QS_PromoteToFullById'
GO
print '... Creating Procedure: QS_PromoteToFullById'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_PromoteToFullById
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @AppIdString varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @AppIdString	varchar(1024)
--SET		@AppIdString = '%s'
---------------------------------------
--test
--SET		@AppIdString = '10'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'PromoteToFullById'
DECLARE @NoParameter varchar(4)
SET     @NoParameter  ='%'                        -- Get Around QScript Parameter
SET     @NoParameter  =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------Validata subclient id -----------
IF @AppIdString = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. No input was given. Please give the subclientId  as input'
	GOTO ARGS_ERROR
END
DECLARE @subclientId integer
SET @subclientId = convert(integer, @AppIdString)
IF (SELECT count(*) from APP_application where id = @subclientId) = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id [' +@AppIdString +'] not found.'
	GOTO ARGS_ERROR
END
DECLARE @subclientFlag integer
SET @subclientFlag = (SELECT subclientStatus from APP_Application where id = @subclientId)
IF ((@subclientFlag & 2 = 2) OR  (@subclientFlag & 4 = 4))
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id [' +@AppIdString +'] is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
------ To Reset backupset modified time in the end  --------
DECLARE @backupsetId integer
SELECT @backupsetId = backupset FROM App_application where id = @subclientId
------------ change the properties...  -----------
BEGIN TRAN
		IF((select count (*) from App_subclientprop	where attrname like 'sys:last full' and componentnameid = @SubclientId) > 0)
			DELETE FROM App_subclientprop
				where attrname like 'sys:last full' and componentnameid = @SubclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		IF((select count (*) from App_subclientprop	where attrname like 'sys:last incr' and componentnameid = @SubclientId) > 0)
			DELETE FROM App_subclientprop
				where attrname like 'sys:last incr' and componentnameid = @SubclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
		Values (@SubclientId, 'Reason last backup time cleared', 18, 7, @nowTime, 0)
		--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7, 	CV_CLEAR_USER_REQUEST_USING_QSCRIPT 17
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		-- Reset backupset modified time
		UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@AppIdString+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PromoteToFullById')
	delete from GxQscripts where name = 'QS_PromoteToFullById'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PromoteToFullById')
	delete from GXDBVersions where aliasname = 'QS_PromoteToFullById'
GO

insert into GXDBVersions values(2, 'QS_PromoteToFullById',  '00000000000000000000', 'QS_PromoteToFullById', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_PromoteToFullById',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn PromoteToFullById -si subclientId
'
 + CHAR(10) + '--   script_name : PromoteToFullById'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RenameBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RenameBackupSet <<<'

IF EXISTS (select * from sysobjects where name='QS_RenameBackupSet')
	drop procedure QS_RenameBackupSet
IF EXISTS (select * from GxQscripts where name='QS_RenameBackupSet')
	delete from GxQscripts where name = 'QS_RenameBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameBackupSet')
	delete from GXDBVersions where aliasname = 'QS_RenameBackupSet'
GO
print '... Creating Procedure: QS_RenameBackupSet'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RenameBackupSet
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @AppTypeName varchar(1024) = '%s',
  @OldBackupset varchar(1024) = '%s',
  @Newbackupset varchar(1024) = '%s',
  @InstanceName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @ClientName			nvarchar(1024)
--SET		@ClientName			= N'%s'
--DECLARE @AppTypeName		nvarchar(1024)
--SET 	@AppTypeName		= N'%s'
--DECLARE @OldBackupSet		nvarchar(1024)
--SET		@OldBackupSet		= N'%s'
--DECLARE @NewBackupSet		nvarchar(1024)
--SET		@NewBackupSet		= N'%s'
--DECLARE @InstanceName		nvarchar(1024)
--SET		@InstanceName		= N'%s'
--DECLARE @MAX_ENTITY_SIZE	smallint
--SET		@MAX_ENTITY_SIZE	= 100
---------------------------------------
--test
--SET		@ClientName			= 'c=uxustnst302'
--SET		@OldBackupSet		= 'o=defaultBackupSet'
--SET		@NewBackupSet		= 'n=zzz-defaultBackupSet'
--SET		@InstanceName		= 'i=default'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'RenameBackupSet'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter			=@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
SET @clientId					= 0
DECLARE @instanceId				integer
SET @instanceId					= 0
DECLARE @oldBackupSetId			integer
SET @oldBackupSetId				= 0
DECLARE @lastError				integer
SET @lastError					= 0
DECLARE @appTypeId				integer
SET @appTypeId					= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			= 'No error encountered when running script.'
DECLARE @tmpAppTbl	TABLE(
						id integer,
						appTypeId integer,
						instance integer,
						backupset integer,
						clientId integer
					)
-- Process client name parameter
IF @ClientName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client name not specified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@ClientName, 1, 2)) = N'c='
	BEGIN
		SET @ClientName = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))
		SET @clientId = ISNULL((SELECT TOP(1) id FROM App_Client WHERE name = @ClientName),0)
		IF @clientId = 0
		BEGIN
			SET @lastError = 2
			SET @localErrorMsg = 'Error. Client not found.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error. Invalid format to mention client name. Use c=<clientName>'
		goto ARGS_ERROR
	END
END
INSERT INTO @tmpAppTbl
SELECT id, appTypeId, instance, backupset, clientId FROM App_Application
WHERE clientId = @clientId
-- Process AppType name parameter
IF @AppTypeName = @NoParameter
BEGIN
	SET @lastError = 9
	SET @localErrorMsg = 'Error. App Type name not spcified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@AppTypeName, 1, 2)) = N'a='
	BEGIN
		SET @AppTypeName = UPPER(SUBSTRING(@AppTypeName, 3, LEN(@AppTypeName)-2))
		SET @appTypeId = (SELECT type FROM app_IDAType WHERE name=@AppTypeName AND type IN
							(SELECT appTypeId FROM @tmpAppTbl WHERE clientId = @clientId)
						)
		IF @appTypeId IS null
		BEGIN
			SET @appTypeId = (SELECT appTypeId FROM app_idaname
								WHERE clientid = @clientId AND appTypeId IN
									(SELECT DISTINCT type FROM APP_IDAType
											WHERE displayName = @AppTypeName)
							)
		END
		IF @appTypeId IS NULL
		BEGIN
			SET @lastError = 10
			SET @localErrorMsg = 'Error. AppType ['+ @apptypeName + '] does not exist on Client ['+ @clientName+'].'
			GOTO ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 11
		SET @localErrorMsg = 'Error. Invalid format to mention app type name. Use a=<appTypeName>'
		goto ARGS_ERROR
	END
END
-- Process instance name parameter
IF @InstanceName <> @NoParameter
BEGIN
	IF LOWER(SUBSTRING(@InstanceName, 1, 2)) = N'i='
	BEGIN
		SET @InstanceName = (SELECT SUBSTRING(@InstanceName, 3, LEN(@InstanceName)-2))
		SET @instanceId = ISNULL(
			(SELECT TOP(1) I.id FROM App_InstanceName I INNER JOIN @tmpAppTbl A ON A.instance = I.id
				WHERE I.name = @InstanceName AND A.clientId = @clientId AND A.appTypeId = @appTypeId)
		,0)
		IF @instanceId = 0
		BEGIN
			SET @lastError = 4
			SET @localErrorMsg = 'Error. Instance not found.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 5
		SET @localErrorMsg = 'Error. Invalid format to mention instance name. Use i=<instanceName>'
		goto ARGS_ERROR
	END
END
-- Process old BackupSet name
IF @OldBackupSet = @NoParameter
BEGIN
	SET @lastError = 6
	SET @localErrorMsg = 'Error. Old backup set not spcified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@OldBackupSet, 1, 2)) = N'o='
	BEGIN
		SET @OldBackupSet = (SELECT SUBSTRING(@OldBackupSet, 3, LEN(@OldBackupSet)-2))
		IF @instanceId = 0
		BEGIN
			IF  ( (SELECT COUNT(T.id) FROM (
					SELECT DISTINCT B.id AS id FROM App_BackupSetName B INNER JOIN @tmpAppTbl A ON
					B.id = A.BackupSet WHERE B.name = @OldBackupSet AND
					A.clientId = @clientId AND A.appTypeId = @appTypeId
				) T)
					> 1
				)
			BEGIN
				SET @lastError = 12
				SET @localErrorMsg = 'Error. Multiple backupsets found, please specify instance name.'
				goto ARGS_ERROR
			END
			SET @oldBackupSetId = ISNULL(
					(SELECT TOP(1) B.id FROM App_BackupSetName B INNER JOIN @tmpAppTbl A ON B.id = A.BackupSet
						WHERE B.name = @OldBackupSet AND A.clientId = @clientId AND A.appTypeId = @appTypeId)
				,0)
		END
		ELSE
		BEGIN
			SET @oldBackupSetId = ISNULL(
					(SELECT TOP(1) B.id FROM App_BackupSetName B INNER JOIN @tmpAppTbl A ON B.id = A.BackupSet
						WHERE B.name = @OldBackupSet AND A.clientId = @clientId AND A.appTypeId = @appTypeId AND A.instance = @instanceId)
				,0)
		END
		IF @oldBackupSetId = 0
		BEGIN
			SET @lastError = 7
			SET @localErrorMsg = 'Error. Backup set not found.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 8
		SET @localErrorMsg = 'Error. Invalid format to mention old backup set name. Use o=<oldBackupSet>'
		goto ARGS_ERROR
	END
END
-- Process new BackupSet name
IF @NewBackupSet = @NoParameter
BEGIN
	SET @lastError = 6
	SET @localErrorMsg = 'Error. New backup set not spcified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@NewBackupSet, 1, 2)) = N'n='
	BEGIN
		SET @NewBackupSet = (SELECT SUBSTRING(@NewBackupSet, 3, LEN(@NewBackupSet)-2))
	END
	ELSE
	BEGIN
		SET @lastError = 8
		SET @localErrorMsg = 'Error. Invalid format to mention new backup set name. Use n=<newBackupSet>'
		goto ARGS_ERROR
	END
END
-- Check if backup set name already exists
IF @instanceId = 0
BEGIN
	IF EXISTS (SELECT B.name
	FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
	WHERE A.clientId = @clientId AND B.name = @NewBackupSet AND A.appTypeId IN (@appTypeId))
	BEGIN
		SET @lastError = 9
		SET @localErrorMsg = 'Error. New Backup Set name already exists. Please specify a different name.'
		goto ARGS_ERROR
	END
END
ELSE
BEGIN
	IF EXISTS (SELECT B.name
	FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
	WHERE A.clientId = @clientId AND B.name = @NewBackupSet AND A.appTypeId IN (@appTypeId) AND A.instance = @instanceId)
	BEGIN
		SET @lastError = 9
		SET @localErrorMsg = 'Error. New Backup Set name already exists. Please specify a different name.'
		goto ARGS_ERROR
	END
END
IF LEN(@NewBackupSet ) > 100
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Backupset name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
BEGIN TRY
	BEGIN TRANSACTION
		IF @instanceId = 0
		BEGIN
			UPDATE App_BackupSetName SET name = @NewBackupSet
			FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
			WHERE A.clientId = @clientId AND B.name = @OldBackupSet AND A.appTypeId IN (@appTypeId)
		END
		ELSE
		BEGIN
			UPDATE App_BackupSetName SET name = @NewBackupSet
			FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
			WHERE A.clientId = @clientId AND B.name = @OldBackupSet AND A.appTypeId IN (@appTypeId) AND A.instance = @instanceId
		END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SELECT @lastError = ERROR_NUMBER(), @localErrorMsg = ERROR_MESSAGE()
	PRINT N'Error occured. ErrorNo(' + CAST(@lastError AS NVARCHAR) + N') ErrorMsg(' + @localErrorMsg + N').'
	PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION
END CATCH
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with '
         + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RenameBackupSet')
	delete from GxQscripts where name = 'QS_RenameBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameBackupSet')
	delete from GXDBVersions where aliasname = 'QS_RenameBackupSet'
GO

insert into GXDBVersions values(2, 'QS_RenameBackupSet',  '00000000000000000000', 'QS_RenameBackupSet', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RenameBackupSet',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn RenameBackupSet.sql -si c=clientName -si a=appTypeName -si o=oldBackupSetName -si n=newBackupSetName [-si i=instanceName]
'
 + CHAR(10) + '--   script_name : RenameBackupSet'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RenameSubclientName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RenameSubclientName <<<'

IF EXISTS (select * from sysobjects where name='QS_RenameSubclientName')
	drop procedure QS_RenameSubclientName
IF EXISTS (select * from GxQscripts where name='QS_RenameSubclientName')
	delete from GxQscripts where name = 'QS_RenameSubclientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameSubclientName')
	delete from GXDBVersions where aliasname = 'QS_RenameSubclientName'
GO
print '... Creating Procedure: QS_RenameSubclientName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RenameSubclientName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @newSubClientName varchar(1030) = '%s',
  @param1 varchar(1030) = '%s',
  @param2 varchar(1030) = '%s',
  @param3 varchar(1030) = '%s',
  @param4 varchar(1030) = '%s',
  @param5 varchar(1030) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs-------
--DECLARE @newSubClientName NVARCHAR(1030)
--SET @newSubClientName = '%s'
--DECLARE @param1  NVARCHAR(1030)
--SET @param1 = '%s'
--DECLARE @param2  NVARCHAR(1030)
--SET @param2 = '%s'
--DECLARE @param3  NVARCHAR(1030)
--SET @param3 = '%s'
--DECLARE @param4  NVARCHAR(1030)
--SET @param4 = '%s'
--DECLARE @param5  NVARCHAR(1030)
--SET @param5 = '%s'
--DECLARE @MAX_ENTITY_SIZE smallint
--SET @MAX_ENTITY_SIZE = 100
------------------------------------------
--SET @newSubClientName = 'newsubclientname'
--SET @param1 = 'c=stargate'
--SET @param2 = 'a=Q_LINUX_FS'
--SET @param3 = 'b=defaultbackupset'
--SET @param4 = 's=sc'
--SET @param5 = '%s'
--select @newSubClientName, @param1, @param2, @param3, @param4, @param5
-----------------------------------------
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'RenameSubclientName'
--DECLARE @nowTime   integer
--SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @noParameter varchar(4)
SET     @noParameter            ='%'                        -- Get Around QScript Parameter
SET     @noParameter            =@noParameter + 's'         -- .. Substitution
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
IF @newSubClientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No New Subclient name given.'
	GOTO ARGS_ERROR
END
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @errorCode = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @errorString OUTPUT
IF @errorCOde != 0
BEGIN
	GOTO ARGS_ERROR
END
--------------------------apptype and default subclient checks..------------------------
IF ((SELECT SubclientStatus & 2 FROM APP_APPLICATION WHERE id = @subclientid) = 2  OR
(SELECT SubclientStatus & 4 FROM APP_APPLICATION WHERE id = @subclientid) = 4 )
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Subclient is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
IF EXISTS (SELECT * from APP_Application where clientId = @Clientid and instance = @InstanceId and AppTypeId = @AppTypeId and Backupset = @BackupsetId and subclientName=@newSubClientName)
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Subclient with this name already exists.'
	GOTO ARGS_ERROR
END
IF (LEN(@newSubClientName) > 100)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
-------------------reset empty options so that script exit message does not have [%s] as parameter--------
IF @PARAM1 = @noParameter
	SET @PARAM1 = ''
IF @PARAM2 = @noParameter
	SET @PARAM2 = ''
IF @PARAM3 = @noParameter
	SET @PARAM3 = ''
IF @PARAM4 = @noParameter
	SET @PARAM4 = ''
IF @PARAM5 = @noParameter
	SET @PARAM5 = ''
------------------------set contents or filters or exception to filter depending on input---------
--get correct slash
UPDATE APP_Application
    SET subclientName=@newSubClientName
    WHERE id=@subclientId
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RenameSubclientName')
	delete from GxQscripts where name = 'QS_RenameSubclientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameSubclientName')
	delete from GXDBVersions where aliasname = 'QS_RenameSubclientName'
GO

insert into GXDBVersions values(2, 'QS_RenameSubclientName',  '00000000000000000000', 'QS_RenameSubclientName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RenameSubclientName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn RenameSubclientName.sql -si newsubclientname -si c=client_name -si a=Ida_type -si b=backupsetName -si s=old_subclient_name
'
 + CHAR(10) + '--   script_name : RenameSubclientName'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetClientDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ResetClientDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_ResetClientDescription')
	drop procedure QS_ResetClientDescription
IF EXISTS (select * from GxQscripts where name='QS_ResetClientDescription')
	delete from GxQscripts where name = 'QS_ResetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_ResetClientDescription'
GO
print '... Creating Procedure: QS_ResetClientDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ResetClientDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
----------------------------------------
--SET @clientName ='os6car'
----------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'ResetClientDescription'
DECLARE @propName varchar(32)
SET @propName  = 'User Description'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
----------- VAlidate inputs   -------------
if @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
if(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
----------- Set description  -------------
UPDATE APP_Client SET clientDescription = '' WHERE id = @clientId
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' on client ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetClientDescription')
	delete from GxQscripts where name = 'QS_ResetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_ResetClientDescription'
GO

insert into GXDBVersions values(2, 'QS_ResetClientDescription',  '00000000000000000000', 'QS_ResetClientDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ResetClientDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn ResetClientDescription -si client_name
'
 + CHAR(10) + '--   script_name : ResetClientDescription'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_scalereport_jobs_completed_bytes_transferred_perma.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_scalereport_jobs_completed_bytes_transferred_perma <<<'

IF EXISTS (select * from sysobjects where name='QS_scalereport_jobs_completed_bytes_transferred_perma')
	drop procedure QS_scalereport_jobs_completed_bytes_transferred_perma
IF EXISTS (select * from GxQscripts where name='QS_scalereport_jobs_completed_bytes_transferred_perma')
	delete from GxQscripts where name = 'QS_scalereport_jobs_completed_bytes_transferred_perma'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_jobs_completed_bytes_transferred_perma')
	delete from GXDBVersions where aliasname = 'QS_scalereport_jobs_completed_bytes_transferred_perma'
GO
print '... Creating Procedure: QS_scalereport_jobs_completed_bytes_transferred_perma'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_scalereport_jobs_completed_bytes_transferred_perma
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
SET NOCOUNT ON;
/****************************************************************************************
 *
 *
 * Copyright (C) 2008 Commvault Systems. All Rights Reserved
 *
 * FILE NAME   : scalereport_jobs_completed_bytes_transferred_perma.sql
 *
 *DESCRIPTION: : Report containing various parameters pertaining to a MA generated
 *				 for scale reporting of GALAXY Version 7.0. The output table gives the
 *				 list of Media Agents which were used in the last one hour and twenty
 *				 four hours The parameters taken into consideration are the count of jobs
 *				 bytes transferred.
 *
 *
 ***************************************************************************************/
CREATE TABLE #perMA ( MediaAgent VARCHAR(50),
					 avg_of_jobsprhr FLOAT(5) NULL,avg_jobspr24hr FLOAT(5) NULL,
					 B_perhr FLOAT(5) NULL, B_per24hr FLOAT(5) NULL,
				   )
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
/*
  Report Format:
  ---------------------------------------------------------------------------------------
		MediaAgent, AvgJobs/h, AvgJobs/h, GB/h, GB/h
 ----------------------------------------------------------------------------------------
*/
/*************************A. Count of Jobs completed per hour ***************************
*
*		The table JMBkpStats consists of all the jobs which are completed along with the
*		time at which the job has finished. The table JMJobResourceHistory has a mapping
*		of JobId to the Media Agent Id. Hence applying INNER JOIN over these tables along
*		with the App_Client table gives the name of the MediaAgent along with the jobIds.
*		These are counted over a period of last one hour and twenty four hours to obtain
*		the desired result.
*
****************************************************************************************/
/****************************B. Bytes Transferred per hour ******************************
*
*		The total number of bytes transferred by a job is given by totalUncompBytes
*		column present in the JMBkpStats table. Doing an INNER JOIN JMBkpStats with
*		JMJobResourceHistory gives all the required details like the Job Id, amount
*		of data it has transferred, time it took for transfer and the time at which
*		a job has ended. Since the units of column totalUncompBytes is in Bytes, we
*		divide it with 1024*1024*1024 to get the output in Giga Bytes.The output is
*		grouped by MediaAgent to get the output per Media Agent.
*
****************************************************************************************/
INSERT INTO #perMA
SELECT DISTINCT COALESCE(A.MediaAgent,B.MediaAgent),
	   A.count_of_jobs_hr,A.count_of_jobs_24hr,
	   B.gbytes_per_hr,B.gbytes_per_24hr
FROM
(
/** This Select statement gets the count of jobs/hour in the last one and twenty four hours**/
	SELECT  ab.name AS MediaAgent,
			query1.count_of_jobs_24hr AS count_of_jobs_24hr ,
			query2.count_of_jobs_1hr AS count_of_jobs_hr
	FROM
	(
		SELECT COUNT(DISTINCT b.JobId)/24.0 AS count_of_jobs_24hr, r.ClientId AS client1
    	FROM JMJobResourceHistory r INNER JOIN JMBkpStats b
		ON b.JobId = r.JobId AND b.CommcellId = r.CommcellId
		WHERE (b.servEndDate > ( @CUR_TIME-24*60*60))
		GROUP BY r.ClientId
	) query1 LEFT JOIN
    (
		SELECT COUNT(DISTINCT b.JobId) AS count_of_jobs_1hr, r.ClientId AS client2
    	FROM JMJobResourceHistory r INNER JOIN JMBkpStats b
		ON b.JobId = r.JobId AND b.CommcellId = r.CommcellId
		WHERE (b.servEndDate > ( @CUR_TIME-60*60))
		GROUP BY r.ClientId
	 ) query2 ON query1.client1 = query2.client2,
	 app_client ab
	WHERE ab.id = query1.client1
) A FULL OUTER JOIN
(
/************ This Select is for obtaining the amount of GB transferred *************/
	SELECT ad.name AS MediaAgent,
		   query1.gbytes_per_24hr AS gbytes_per_24hr,
		   query2.gbytes_per_hr AS gbytes_per_hr
	FROM
    (
		SELECT ClientId, SUM(totalUncompBytes)/(1024.0*1024*1024*24) AS gbytes_per_24hr
		FROM JMJobResourceHistory
		WHERE (ReservationTime > ( @CUR_TIME-24*60*60))
		group by ClientId
	) query1 LEFT JOIN
	(
		SELECT ClientId,SUM(totalUncompBytes)/(1024.0*1024*1024) AS gbytes_per_hr
		FROM JMJobResourceHistory
		WHERE (ReservationTime > ( @CUR_TIME-60*60))
		group by ClientId
	) query2 ON query1.clientid = query2.clientid ,
	app_client ad
	WHERE ad.id = query1.clientid
) B ON A.MediaAgent = B.MediaAgent,
app_client ae
ORDER BY  COALESCE(A.MediaAgent,B.MediaAgent)
/******************************** GENERAL REMARKS: **************************************
*
*		In the above script we have used the LEFT and RIGHT joins to combine tables in
*		which there may be chances of the first table to be empty in case of LEFT JOIN
*		and the second TABLE may be empty for RIGHT JOIN cases. The FULL OUTER JOINS are
*		used when there may be chances that any or both the tables can be empty.
*
***************************************************************************************/
DECLARE @MA VARCHAR(50)
DECLARE @JAVGHR FLOAT(5)
DECLARE @JAVG24HR FLOAT(5)
DECLARE @BHR FLOAT(5)
DECLARE @B24HR FLOAT(5)
DECLARE TableCursor CURSOR FOR
SELECT * FROM #perma;
PRINT 'Name'+char(9)+char(9)+'1hour'+char(9)+char(9)+'24hours'+char(9)+char(9)+char(9)+'1hour'+char(9)+char(9)+'24hours'
PRINT ' ';
PRINT 'MAgent'+char(9)+char(9)+'AvgJobs/h'+char(9)+'AvgJobs/h'+char(9)+char(9)+'GB/h'+char(9)+char(9)+'GB/h'
PRINT ' ';
OPEN TableCursor
FETCH NEXT FROM TableCursor INTO @MA, @JAVGHR, @JAVG24HR,@BHR,@B24HR
WHILE @@FETCH_STATUS = 0
BEGIN
PRINT @MA +char(9)+char(9)+CAST( convert(float,round(ISNULL(@JAVGHR,0),2)) AS VARCHAR) + char(9)+char(9)+ CAST( convert(float,round(ISNULL(@JAVG24HR,0),2)) AS VARCHAR) + char(9)+char(9)+char(9)+CAST( convert(float,round(ISNULL(@BHR,0),2)) AS VARCHAR)+ char(9)+char(9)+CAST( convert(float,round(ISNULL(@B24HR,0),2)) AS VARCHAR)
FETCH NEXT FROM TableCursor INTO @MA, @JAVGHR, @JAVG24HR,@BHR,@B24HR
END
CLOSE TableCursor
DEALLOCATE TableCursor
/***************************************************************************************/
--SELECT * FROM perma;
DROP TABLE #perma;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_scalereport_jobs_completed_bytes_transferred_perma')
	delete from GxQscripts where name = 'QS_scalereport_jobs_completed_bytes_transferred_perma'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_scalereport_jobs_completed_bytes_transferred_perma')
	delete from GXDBVersions where aliasname = 'QS_scalereport_jobs_completed_bytes_transferred_perma'
GO

insert into GXDBVersions values(2, 'QS_scalereport_jobs_completed_bytes_transferred_perma',  '00000000000000000000', 'QS_scalereport_jobs_completed_bytes_transferred_perma', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_scalereport_jobs_completed_bytes_transferred_perma',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	QOperation execscript -sn scalereport_jobs_completed_bytes_transferred_perma.sql
'
 + CHAR(10) + '--   script_name : scalereport_jobs_completed_bytes_transferred_perma'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setAlertSNMPnotification.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setAlertSNMPnotification <<<'

IF EXISTS (select * from sysobjects where name='QS_setAlertSNMPnotification')
	drop procedure QS_setAlertSNMPnotification
IF EXISTS (select * from GxQscripts where name='QS_setAlertSNMPnotification')
	delete from GxQscripts where name = 'QS_setAlertSNMPnotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setAlertSNMPnotification')
	delete from GXDBVersions where aliasname = 'QS_setAlertSNMPnotification'
GO
print '... Creating Procedure: QS_setAlertSNMPnotification'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_setAlertSNMPnotification
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @ACTION varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @ACTION     	varchar(512)
--SET @ACTION = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setAlertSNMPnotification'
DECLARE @NT_ALERTTYPE_SRM_ADVISORY		integer
SET     @NT_ALERTTYPE_SRM_ADVISORY		= 49
DECLARE @NT_SNMP_ALERTNOTIF			    integer
SET     @NT_SNMP_ALERTNOTIF				= 4
--DECLARE @SC_STATUS_BITS        integer
--SET		@SC_STATUS_BITS        =  2+4+16					-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--DECLARE @appTypeId				integer
--DECLARE @instanceId				integer
--DECLARE @backupSetId			integer
--DECLARE	@subClientId			integer
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @ACTION =  'enable'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @ACTION = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------------------------------------------------
--- CHECK IF A PROPER REQUEST WAS MADE		 ---
------------------------------------------------
IF @ACTION <> 'enable' AND @ACTION <> 'disable'							-- Case Insensitive Check
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter specified incorrectly as ['+@action +'].'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameter: @ACTION = ['
         + @ACTION
         + ']'
BEGIN TRAN
--
IF @ACTION = 'disable'
BEGIN
	UPDATE NTnotificationRule SET NotifType = NotifType & ~@NT_SNMP_ALERTNOTIF
	SET @lastError = @@error
	GOTO ALL_DONE
END
ELSE
BEGIN
	--------------------------------------------------------------------------
	-- ENABLE THE SNMP TRAP NOTIFICATION :									--
	--------------------------------------------------------------------------
	UPDATE NTnotificationRule SET NotifType = NotifType | @NT_SNMP_ALERTNOTIF
		WHERE alertTypeid <> @NT_ALERTTYPE_SRM_ADVISORY
	SET @lastError = @@error
	IF @lastError <> 0
		GOTO ALL_DONE
	--------------------------------------------------------------------------
	-- IF We are adding SNMP For the 1st Time, then There won't 00 be		--
	-- format strings in NTmessageFormat.  We will have to add them now		--
	--------------------------------------------------------------------------
--  THIS IS FOR ALL ALERT TYPES, THE NON-ESCALATED CASE:
	INSERT NTMessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage, SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen,
								mfOptions, baseDir, userName, password, rssID)
		SELECT  NRULE.id, TEMPLATE.messageType, 1, TEMPLATE.defaultFormatString, '', 0, 0, 0, 0,
								0, N'', N'', N'', 0
		FROM NTNotificationRule as NRULE, NTnotificationTemplate as TEMPLATE
		WHERE NRULE.alertTypeId = TEMPLATE.NTalertTypeId
		  AND NRULE.locale     = TEMPLATE.locale
		  AND TEMPLATE.messageType = @NT_SNMP_ALERTNOTIF
		  AND NOT EXISTS (Select * from NTMessageFormat where NTnotificationId = NRULE.id AND messageType = @NT_SNMP_ALERTNOTIF AND escalationLevel = 1)
	SET @lastError = @@error
	IF @lastError <> 0
		GOTO ALL_DONE
--	THIS IS FOR !ONLY! THOSE ALERT TYPES THAT CAN BE ESCALATED:
	INSERT NTMessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage, SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen,
								mfOptions, baseDir, userName, password, rssID)
		SELECT  NRULE.id, TEMPLATE.messageType, 2, TEMPLATE.defaultFormatString, '', 0, 0, 0, 0,
								0, N'', N'', N'', 0
		FROM NTNotificationRule as NRULE, NTnotificationTemplate as TEMPLATE
		WHERE NRULE.alertTypeId = TEMPLATE.NTalertTypeId
		  AND NRULE.locale     = TEMPLATE.locale
		  AND TEMPLATE.messageType = @NT_SNMP_ALERTNOTIF
		  AND EXISTS (Select * from NTavailcriteria WHERE alertTypeId = TEMPLATE.NTalertTypeId and escReportingOptions <> 0)
		  AND NOT EXISTS (Select * from NTMessageFormat where NTnotificationId = NRULE.id AND messageType = @NT_SNMP_ALERTNOTIF AND escalationLevel = 2)
	SET @lastError = @@error
	IF @lastError <> 0
		GOTO ALL_DONE
END
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
/* Following Lines were used for debugging:
select * from NTnotificationRule Where alertTypeid <> @NT_ALERTTYPE_SRM_ADVISORY
select * from NTMessageFormat WHERE messageType in (1,4)
	order by NTnotificationId, messageType
*/
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setAlertSNMPnotification')
	delete from GxQscripts where name = 'QS_setAlertSNMPnotification'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setAlertSNMPnotification')
	delete from GXDBVersions where aliasname = 'QS_setAlertSNMPnotification'
GO

insert into GXDBVersions values(2, 'QS_setAlertSNMPnotification',  '00000000000000000000', 'QS_setAlertSNMPnotification', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_setAlertSNMPnotification',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f setAlertSNMPnotification.sql -i enable | disable 
'
 + CHAR(10) + '--   script_name : setAlertSNMPnotification'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetAuxCopyJobPriority.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetAuxCopyJobPriority <<<'

IF EXISTS (select * from sysobjects where name='QS_SetAuxCopyJobPriority')
	drop procedure QS_SetAuxCopyJobPriority
IF EXISTS (select * from GxQscripts where name='QS_SetAuxCopyJobPriority')
	delete from GxQscripts where name = 'QS_SetAuxCopyJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAuxCopyJobPriority')
	delete from GXDBVersions where aliasname = 'QS_SetAuxCopyJobPriority'
GO
print '... Creating Procedure: QS_SetAuxCopyJobPriority'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetAuxCopyJobPriority
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @enabled varchar(64) = '%s',
  @priority varchar(64) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @enabled	varchar(64)
--SET @enabled =		'%s'
--DECLARE @priority	varchar(64)
--SET @priority =		'%s'
--------------------------------------------
-- Testing --
--------------------------------------------
--SET @enabled =		'Y'
--SET @priority =		'127'
--------------------------------------------
-- Convenience Definitions --
--------------------------------------------
DECLARE @scriptName			varchar(32)
SET		@scriptName	=		'SetAuxCopyJobPriority'
DECLARE @transactionName	varchar(32)
SET @transactionName =		'SetAuxCopyPriorityTran'
DECLARE @propName varchar(32)
SET @propName  = 'JMAuxCopyCombinedPriority'
DECLARE @nowTime int
Set     @nowTime =  datediff(second, '01/01/1970', GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--------------------------------------------
-- Local Variables --
--------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--------------------------------------------
--------------------------------------------
-- @enabled is compulsory param
if (@enabled = @noParameter) or (LOWER(@enabled) <> 'y' and LOWER(@enabled) <> 'n')
BEGIN
	SET @localErrorMsg = 'Error.  Invalid enabled paramater value. Enter [y] to enable and [n] to disable.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-- If @enabled is true, Validate @priority
if (LOWER(@enabled) = 'y')
	if @priority = @noParameter or ((convert(int, @priority)) < 1 or (convert(int, @priority)) > 999)
	BEGIN
		SET @localErrorMsg = 'Error.  Invalid Priority parameter  value. Priority value should be between 1 and 999.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
BEGIN TRY
BEGIN TRANSACTION @transactionName
	DELETE from GxGlobalParam where name = @propName
	if (@enabled ='y')
		INSERT INTO GxGlobalParam  VALUES (@propname, @priority,@nowTime,0)
COMMIT TRANSACTION @transactionName
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	ROLLBACK TRANSACTION @transactionName
	SET @localErrorMsg = 'Error.  Database error occured. Please retry'
	Set @lastError = 1
	goto   ARGS_ERROR
END CATCH
ARGS_ERROR:
	Print ''
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: Enabled = ['
         + convert(varchar(4),@enabled)
         + '], Priority = ['
         + convert(varchar(4),@priority)
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if (@lastError <> 0)
		Raiserror(@localErrorMsg,
				    15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetAuxCopyJobPriority')
	delete from GxQscripts where name = 'QS_SetAuxCopyJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAuxCopyJobPriority')
	delete from GXDBVersions where aliasname = 'QS_SetAuxCopyJobPriority'
GO

insert into GXDBVersions values(2, 'QS_SetAuxCopyJobPriority',  '00000000000000000000', 'QS_SetAuxCopyJobPriority', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetAuxCopyJobPriority',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetAuxCopyJobPriority.sql -si y or n -si priorityvalue
'
 + CHAR(10) + '--   script_name : SetAuxCopyJobPriority'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientDescription')
	drop procedure QS_SetClientDescription
IF EXISTS (select * from GxQscripts where name='QS_SetClientDescription')
	delete from GxQscripts where name = 'QS_SetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_SetClientDescription'
GO
print '... Creating Procedure: QS_SetClientDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @description varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
--DECLARE @description varchar(1024)
--SET @description = '%s'
----------------------------------------
--SET @clientName ='os6car'
--SET @description = 'new desc'
----------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetClientDescription'
DECLARE @propName varchar(32)
SET @propName  = 'User Description'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
----------- VAlidate inputs   -------------
if @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
if @description = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Description for Client ['+ @clientName +'] was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
if(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
----------- Set description  -------------
UPDATE APP_Client SET clientDescription = @description WHERE id = @clientId
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: description = ['
         + @description
         + '], client = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientDescription')
	delete from GxQscripts where name = 'QS_SetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_SetClientDescription'
GO

insert into GXDBVersions values(2, 'QS_SetClientDescription',  '00000000000000000000', 'QS_SetClientDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientDescription -si client_name -si description
'
 + CHAR(10) + '--   script_name : SetClientDescription'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetCommcellActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetCommcellActivity <<<'

IF EXISTS (select * from sysobjects where name='QS_SetCommcellActivity')
	drop procedure QS_SetCommcellActivity
IF EXISTS (select * from GxQscripts where name='QS_SetCommcellActivity')
	delete from GxQscripts where name = 'QS_SetCommcellActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCommcellActivity')
	delete from GXDBVersions where aliasname = 'QS_SetCommcellActivity'
GO
print '... Creating Procedure: QS_SetCommcellActivity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetCommcellActivity
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @operationName varchar(64) = '%s',
  @enabled varchar(64) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @operationName	varchar(64)
--SET @operationName =	'%s'
--SET @operationName =	'backup'jo
--DECLARE @enabled	varchar(64)
--SET @enabled =		'%s'
--SET @enabled =		'y'
-------------------------------------------
---- Convenience Definitions    -----------
-------------------------------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetCommcellActivity'
if object_id('tempdb.dbo.#activityControlOpType') is not null DROP TABLE #activityControlOpType
CREATE TABLE #activityControlOpType(opType int, operationName varchar(32))
INSERT INTO #activityControlOpType values(1, 'ALLOPS') -- ALLOPS
INSERT INTO #activityControlOpType values(4, 'BACKUP') -- BACKUP
INSERT INTO #activityControlOpType values(5, 'RESTORE') -- RESTORE
INSERT INTO #activityControlOpType values(13, 'AUXCOPY') -- AUXCOPY
INSERT INTO #activityControlOpType values(10, 'PRUNE') -- PRUNE
INSERT INTO #activityControlOpType values(28, 'SCHEDULE') -- SCHEDULE
--INSERT INTO #activityControlOpType values(31, 'ARCHIVECHECK') -- ARCHIVECHECK
--INSERT INTO #activityControlOpType values(32, 'TAPEERASE') -- TAPEERASE
--INSERT INTO #activityControlOpType values(38, 'SELECTIVEDELETE') -- SELECTIVEDELETE
INSERT INTO #activityControlOpType values(57, 'ONLINECONTENTINDEX') -- ONLINECONTENTINDEX
INSERT INTO #activityControlOpType values(53, 'OFFLINECONTENTINDEX') -- OFFLINECONTENTINDEX
-------------------------------------------
-------- Local Variables    -------------
-------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
DECLARE @isExist				integer
DECLARE @actionType				integer
DECLARE @opType					integer
SET		@isExist = 0
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0			-- Be optimistic
SET		@actionType = 0			-- 1- Disable activity 2- Enable activity
SET		@opType		= 0
DECLARE @NoParameter varchar(4)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------------------------------------------
---- Input parameter validation -----------
-------------------------------------------
IF EXISTS(select *from #activityControlOpType where operationName = @operationName)
	set @isExist = 1
IF (@enabled = @noParameter) or (LOWER(@enabled) <> 'y' and LOWER(@enabled) <> 'n') or (@isExist = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid enabled paramater value. Enter [y] to enable and [n] to disable and correct Operation Type' +
						 ' [ALLOPS, BACKUP, RESTORE, AUXCOPY, PRUNE, SCHEDULE, ONLINECONTENTINDEX, OFFLINECONTENTINDEX]'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-------------------------------------------
----- Procession Logic --------------------
-------------------------------------------
select @opType = opType from #activityControlOpType where operationName = @operationName
IF (LOWER(@enabled) = 'y')
	SET @actionType  =  2
ELSE IF (LOWER(@enabled) = 'n')
	SET @actionType  = 1
UPDATE JMJobAction set action = @actionType where clientId = 1 and appType = 0 and mediaAgentID =1 and opType = @opType
		and appId = (select id from APP_Application where appTypeId = 1000)
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetCommcellActivity')
	delete from GxQscripts where name = 'QS_SetCommcellActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCommcellActivity')
	delete from GXDBVersions where aliasname = 'QS_SetCommcellActivity'
GO

insert into GXDBVersions values(2, 'QS_SetCommcellActivity',  '00000000000000000000', 'QS_SetCommcellActivity', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetCommcellActivity',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetCommcellActivity.sql -si operationName -si activity(Enable (Y)or disable(N))
'
 + CHAR(10) + ' Operation Name: Possible Operations
'
 + CHAR(10) + ' --------------
'
 + CHAR(10) + ' ALLOPS			-- All Job Activity
'
 + CHAR(10) + ' BACKUP			-- Data Management Activity
'
 + CHAR(10) + ' RESTORE			-- Data Recovery Activity
'
 + CHAR(10) + ' AUXCOPY			-- Auxiliary Copy Activity
'
 + CHAR(10) + ' PRUNE			-- Data Aging Activity
'
 + CHAR(10) + ' SCHEDULE		-- Scheduler Activity
'
 + CHAR(10) + ' ONLINECONTENTINDEX	-- Online Content Index Activity
'
 + CHAR(10) + ' OFFLINECONTENTINDEX	-- Offline Content Index Activity
'
 + CHAR(10) + ' activity: Enable or disable
'
 + CHAR(10) + ' --------
'
 + CHAR(10) + ' Enable			-- y or Y
'
 + CHAR(10) + ' Disable 		-- n or N
'
 + CHAR(10) + '--   script_name : SetCommcellActivity'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDeconfClientName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDeconfClientName <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDeconfClientName')
	drop procedure QS_SetDeconfClientName
IF EXISTS (select * from GxQscripts where name='QS_SetDeconfClientName')
	delete from GxQscripts where name = 'QS_SetDeconfClientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDeconfClientName')
	delete from GXDBVersions where aliasname = 'QS_SetDeconfClientName'
GO
print '... Creating Procedure: QS_SetDeconfClientName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetDeconfClientName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(1024) = '%s',
  @NEWNAME varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
--INPUTS
-------------------------------------------
--DECLARE @CLIENTNAME     varchar(1024)
--SET @CLIENTNAME ='%s'
--DECLARE @NEWNAME		varchar(512)
--SET @NEWNAME = '%s'
--------------------------
--SET @CLIENTNAME = 'bingo'
--SET @NEWNAME = 'Bingo'
---------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetDeconfClientName'
DECLARE @STATUS_BIT        integer
SET		@STATUS_BIT        =  2					-- 0x00002
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
--DECLARE @MAX_ENTITY_SIZE		smallint
--SET @MAX_ENTITY_SIZE			= 100
---------VAlidate inputs   ----------
IF(@CLIENTNAME = @NoParameter)
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. No client was not given as input.'
	GOTO ARGS_ERROR
END
IF(@NEWNAME = @NoParameter)
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. New client name was not given as input.'
	GOTO ARGS_ERROR
END
DECLARE @clientId int
DECLARE @status int
SELECT @clientId = id, @status = status FROM APP_Client WHERE name like @CLIENTNAME
IF @clientId is NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. Client ['+@CLIENTNAME+'] not found.'
	GOTO ARGS_ERROR
END
IF (@status & @STATUS_BIT) <> @STATUS_BIT
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. Client ['+@CLIENTNAME+'] cannot be renamed. It is not deconfigured. Deconfigure the client and try again or use the name change utility.'
	GOTO ARGS_ERROR
END
IF (LEN(@NEWNAME ) > 100)
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client Name cannot be more than ' + CAST(100 AS varchar(3)) + ' characters.'
	GOTO ARGS_ERROR
END
------------ Rename client  ----------
UPDATE App_Client SET name = @NEWNAME WHERE id = @clientId
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: client = ['
         + @CLIENTNAME
         + '], new client name ['
		 + @NEWNAME
		 +'] Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDeconfClientName')
	delete from GxQscripts where name = 'QS_SetDeconfClientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDeconfClientName')
	delete from GXDBVersions where aliasname = 'QS_SetDeconfClientName'
GO

insert into GXDBVersions values(2, 'QS_SetDeconfClientName',  '00000000000000000000', 'QS_SetDeconfClientName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDeconfClientName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetDeconfClientName.sql -si old_client_name -si new_client_name
'
 + CHAR(10) + '--   script_name : SetDeconfClientName'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDefaultSCContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDefaultSCContent <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDefaultSCContent')
	drop procedure QS_SetDefaultSCContent
IF EXISTS (select * from GxQscripts where name='QS_SetDefaultSCContent')
	delete from GxQscripts where name = 'QS_SetDefaultSCContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDefaultSCContent')
	delete from GXDBVersions where aliasname = 'QS_SetDefaultSCContent'
GO
print '... Creating Procedure: QS_SetDefaultSCContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetDefaultSCContent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(1024) = '%s',
  @listofPaths varchar(1024) = '%s',
  @DELIM varchar(1024) = '%s',
  @BACKUPSETNAME varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
-----------------------------------------------------
-- GET THE FOLLOWING FROM THE QSCRIPT COMMAND LINE --
-----------------------------------------------------
--DECLARE @CLIENTNAME     varchar(1024)
--DECLARE @listOfPaths	varchar(2048)
--DECLARE @DELIM			varchar(2)
--DECLARE @BACKUPSETNAME  varchar(1024)
--SET		@ClientName		= '%s'
--SET		@listOfPaths	= '%s'
--SET		@DELIM			= '%s'
--SET		@BACKUPSETNAME	= '%s'
------- TEST DATA (FAKE OUT QSCRIPT  -----------------
--SET   @CLIENTNAME = 'jewelfish_cn'
--SET	@BACKUPSETNAME = 'defaultBackupSet'
--SET   @DELIM       = ';'
--SET	@listOfPaths = 'C:\;d:\tmp;e:\DB_Backups;f:\;c:\tmp'
--SET	@listOfPaths = 'C:\'
--SET	@listOfPaths = '\;d:\'
------------------------------------------------------
DECLARE @subClientName varchar(1024)
DECLARE @clientId    integer
DECLARE @backupSetId integer
DECLARE @subClientId	integer
DECLARE @thisPath		varchar(1024)
DECLARE @inStrLen       int
DECLARE @nextSeper		int
-------------  Convenience Definitions  ---------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetDefaultSCContent'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())DECLARE @srcSubClientID   int
DECLARE @hasStatusBits  integer
SET		@hasStatusBits = 8						-- Default SubClient
DECLARE @notStatusBits  integer
SET		@notStatusBits = 4+2					-- DELETED, UNINSTALLED
DECLARE @lastError		int
SET		@lastError = 1							-- Be pessimistic
DECLARE	@errorString	varchar(1024)
set		@errorString = 'Error encountered when running script'
DECLARE @describeSC		varchar(1024)
set		@describeSC  = 'Unknown SubClient'
--------------------------------------
-- CHECK FOR MINIMUM ARGS, SET		--
-- .. DEFAULTS, AS REQUIRED			--
--------------------------------------
IF @ClientName = @NoParameter
BEGIN
	SET @errorString = 'Error. No Client specified.'
	GOTO ARGS_ERROR
END
IF @listOfPaths = @NoParameter
BEGIN
	SET @errorString = 'Error. No Content specified.'
	GOTO ARGS_ERROR
END
IF @DELIM = @NoParameter
BEGIN
	SET @DELIM = ';'
	PRINT 'Setting Delimiter to default [' + @DELIM + '].'
END
IF @BACKUPSETNAME = @NoParameter
BEGIN
	SET @BACKUPSETNAME = 'defaultBackupSet'
	PRINT 'Setting BackupSetName to default [' + @BACKUPSETNAME + '].'
END
PRINT Convert(varchar(60), getdate()) +' [Start] '+ @scriptName +' {' + @clientName  +'}, {' +@listOfPaths + '}, {' +@DELIM + '}, {' +@BackupSetName + '}'
--------------------------------------
-- Figure Out ClientId from name:	--
--------------------------------------
SET @clientId     = (Select id from APP_CLIENT where name = @CLIENTNAME)
IF @clientId is NulL
	BEGIN
		Set @errorString = 'No Client with name ['+@ClientName+'] exists.'
		goto ARGS_ERROR
	END
--------------------------------------------------
-- Figure out BackupSetId from name:			--
-- .. Not as easy as clientId,backupSet names	--
-- .. are not necessarily unique Commcell-wide	--
--------------------------------------------------
SET @backupSetId = (Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
                      where
						APP.clientId = @clientId
						AND APP.backupSet = BSN.id
						AND BSN.name = @BACKUPSETNAME
						AND appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
						)
IF @backupSetId is NulL
	BEGIN
		SET @errorString = 'No backupset with name ['+@BACKUPSETNAME+'] exists.'
		goto ARGS_ERROR
	END
--------------------------------------------------
-- Now we can determine the id for the default	--
-- SubClient for this Client/Backupset			--
--------------------------------------------------
SET @subClientId = (Select id from APP_APPLICATION
		 WHERE clientId = @clientId
		  AND  backupSet = @backupSetId
          AND  appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
		  AND (subClientStatus & @hasStatusBits) <> 0
		  AND (subClientStatus & @notStatusBits) =  0
		)
IF @subClientId is NulL
	BEGIN
		SET @errorString= 'No Active default subClient for client['+@CLIENTNAME+ '], backupset['+@BACKUPSETNAME+'].'
		goto ARGS_ERROR
	END
SET @subClientName = (select subClientName from APP_APPLICATION where id = @subClientId)
SET @describeSC = '[' +@clientName + '(FS)-->' + @backupsetName + '-->' +@subClientName + '{'+convert(varchar(10), @subClientId) + '}]'
---
 PRINT  'Processing content for ' +@describeSC
--SELECT 'step'= 'pre clear', * FROM APP_SCFILTERFILE WHERE COMPONENTNAMEID = @SUBCLIENTID
BEGIN TRAN
---------------------------------------------
--	AGE ALL OLD CONTENT FOR THIS SUBCLIENT --
---------------------------------------------
	UPDATE APP_SCFILTERFILE
		SET modified = @nowTime
			WHERE COMPONENTNAMEID = @subClientId AND Modified = 0 AND Type = 1
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		SET @errorString = 'Error. Could not age content for ' +@describeSC
		GOTO TRANS_EXIT
	END
-------------------------------------------------------------
-- PARSE LIST OF PATHS. IF THEY DON'T EXIST AS CONTENT FOR --
-- ANY OTHER SUBLCIENT IN THE BACKUPSET, OK TO ADD IT IN   --
-- TO THE DEFAULT SUBCLIENT								   --
-------------------------------------------------------------
print 'debug DELIM ['+@DELIM+']'
SET  @inStrLen   = LEN(@listOfPaths)
IF @inStrLen > 0
BEGIN
    WHILE (LEN(@listOfPaths) > 0)
    BEGIN
		SET @nextSeper   = CHARINDEX(@DELIM, @listOfPaths, 1)
		IF @nextSeper = 0
		BEGIN
			SET @listOfPaths = @listOfPaths+@DELIM
			SET @nextSeper = @instrlen+1
		END
        SET @thisPath    = RTRIM(LTRIM(SUBSTRING(@listOfPaths, 1, @nextSeper-1)))
		IF EXISTS (SELECT * FROM APP_SCFILTERFILE AS SCF, APP_APPLICATION AS APP
				WHERE APP.ClientId = @clientId
				  AND APP.backupSet = @backupSetId
				  AND  appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
		          AND (subClientStatus & @notStatusBits) =  0
                  AND SCF.modified = 0
				  --AND SCF.componentNameId <> @subClientId
                  AND SCF.componentNameId = APP.id
				  AND SCF.Filename =  @thisPath
				  AND SCF.type in (1, 3)
				)
		BEGIN
			SET @errorString = 'Cannot Add path ['+@thisPath+'] to default subClient.  It already exists in another subClient'
			set @lastError = 1
			goto TRANS_EXIT
		END
		ELSE
		BEGIN
			INSERT APP_SCFILTERFILE(componentNameId,type,fileName,created,modified)
				VALUES (@subClientId, 1, @thisPath, @nowTime, 0)
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString = 'Error. Could not add content[' +@thisPath +'] to ' +@describeSC
				GOTO TRANS_EXIT
			END
			PRINT '.. adding Path ['+@thisPath+']'
		END
--      SET UP TO GET NEXT PATH IN THE LIST:
--      --------------------------------------
        IF (@inStrLen - @nextSeper <= 0)
            BREAK
        SET @listOfPaths = SUBSTRING(@listOfPaths, @nextSeper+1, @inStrLen-@nextSeper)
        SET @inStrLen = LEN(@listOfPaths)
    END
END
TRANS_EXIT:
IF @LastError <> 0
	ROLLBACK TRAN
ELSE
BEGIN
COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
END
PRINT Convert(varchar(60), getdate()) +' [Complete] '+ @scriptName + '. Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
	)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDefaultSCContent')
	delete from GxQscripts where name = 'QS_SetDefaultSCContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDefaultSCContent')
	delete from GXDBVersions where aliasname = 'QS_SetDefaultSCContent'
GO

insert into GXDBVersions values(2, 'QS_SetDefaultSCContent',  '00000000000000000000', 'QS_SetDefaultSCContent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDefaultSCContent',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetDefaultSCContent.sql -si clientname -si listofpaths [-si delimiter] [-si backupsetName]
'
 + CHAR(10) + '--   script_name : SetDefaultSCContent'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetGlobalFilterState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetGlobalFilterState <<<'

IF EXISTS (select * from sysobjects where name='QS_SetGlobalFilterState')
	drop procedure QS_SetGlobalFilterState
IF EXISTS (select * from GxQscripts where name='QS_SetGlobalFilterState')
	delete from GxQscripts where name = 'QS_SetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_SetGlobalFilterState'
GO
print '... Creating Procedure: QS_SetGlobalFilterState'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetGlobalFilterState
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @STATE varchar(1024) = '%s',
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @STATE	varchar(1024)
--SET		@STATE  = '%s'
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
------------------------------
--SKATZ As Extracted from reported error email:
--SET		@STATE  = 'ON'
--SET		@PARAM1 = 'c=bigblue'
--SET		@PARAM2	= 'a=Q_SOLARIS_FS'
--SET		@PARAM3 = 'b=CmpTests'
--SET		@PARAM4 = 's=default'
--SET		@PARAM5 = '%s'
------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetGlobalFilterState'
DECLARE @propName1 varchar(50)
SET @propName1 = 'use cs setting for Global Filters'
DECLARE @propName2 varchar(32)
SET @propName2 = 'Use Global Filters'
DECLARE @NoParameter varchar(4)
SET @NoParameter = '%s'
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------------ Get ids ---------------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
------------------- VAlidate inputs --------------------------------
DECLARE @scpid integer
SET @scpid = ISNULL((select attrval from app_backupsetprop where attrname like 'Associated subclient Policy' and componentnameid = @backupsetid AND modified = 0),0)
DECLARE @useSCPfilters integer
if @scpid >0
begin
	SET @useSCPfilters = ISNULL((select attrval from app_subclientprop where componentNameId = @subClientid AND attrname like 'use SCP filters' AND modified=0), 0)
end
if @useSCPfilters <> 0
BEGIN
	SET @localErrorMsg	='Cannot set global filters for subclient. It is associated to a subclient policy and uses policy filters.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @AppTypeId NOT IN (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,  54,56,57,58, 63,64,67,68,74,86, 105,106)
BEGIN
	SET @localErrorMsg	='Global filters are not applicable to iDA ['+@PARAM2+'].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @STATE= @NoParameter OR (@STATE <> N'ON' AND @STATE <> N'OFF' AND @STATE <> N'ENABLE' AND @STATE <> N'DISABLE' AND @STATE <> 'USE CELL LEVEL POLICY')
BEGIN
	SET @localErrorMsg	='Parameter1 Global Filter State must be "OFF" or "ON" or "USE CELL LEVEL POLICY"'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------ ONLY AGE OLD PROPERTY/ADD NEW IF THE STATE OF THE PROPERTY HAS CHANGED!
DECLARE @propVal1 integer
DECLARE @propVal2 integer
DECLARE @oldPropVal1 integer
DECLARE @oldPropVal2 integer
IF(@state = N'OFF')
BEGIN
	SET @propVal1 = 0
	SET @propVal2 = 0
END
ELSE IF(@state = N'ON')
BEGIN
	SET @propVal1 = 0
	SET @propVal2 = 1
END
ELSE IF(@state = N'USE CELL LEVEL POLICY')
BEGIN
	SET @propVal1 = 1
	SET @propVal2 = 0
END
SET @oldPropVal1 = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1), 1)
SET @oldPropVal2 = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2), 0)
BEGIN TRY
	BEGIN TRAN
	-- ONLY AGE OLD PROPERTY/ADD NEW IF THE STATE OF THE PROPERTY HAS CHANGED!
	IF @propVal1 <> @oldPropVal1
	BEGIN
		UPDATE APP_SubclientProp SET modified = @nowTime WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1
		INSERT INTO APP_SubclientProp(componentNameId, created, modified, attrtype, attrname, attrval)
								VALUES (@subclientId, @nowTime, 0, 2 , @propName1, @propVal1)
	END
	IF @propVal2 <> @oldPropVal2
	BEGIN
		UPDATE APP_SubclientProp SET modified = @nowTime WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2
		INSERT INTO APP_SubclientProp(componentNameId, created, modified, attrtype, attrname, attrval)
								VALUES (@subclientId, @nowTime, 0, 2 , @propName2, @propVal2)
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
	ROLLBACK TRAN
    SET @lastError = ERROR_NUMBER()
    SET @localErrorMsg = 'Problems updating Global filter state' +ERROR_MESSAGE()
END
END CATCH
IF @lastError = 0
	COMMIT TRAN
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
--
-- Select * from app_subclientProp where componentNameId=208 and attrName=@propname
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetGlobalFilterState')
	delete from GxQscripts where name = 'QS_SetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_SetGlobalFilterState'
GO

insert into GXDBVersions values(2, 'QS_SetGlobalFilterState',  '00000000000000000000', 'QS_SetGlobalFilterState', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetGlobalFilterState',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetGlobalFilterState.sql -si OFF/ON/"USE CELL LEVEL POLICY" -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : SetGlobalFilterState'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetHoliday.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetHoliday <<<'

IF EXISTS (select * from sysobjects where name='QS_SetHoliday')
	drop procedure QS_SetHoliday
IF EXISTS (select * from GxQscripts where name='QS_SetHoliday')
	delete from GxQscripts where name = 'QS_SetHoliday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetHoliday')
	delete from GXDBVersions where aliasname = 'QS_SetHoliday'
GO
print '... Creating Procedure: QS_SetHoliday'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetHoliday
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @Name NVARCHAR(80) = '%s',
  @isAnually NVARCHAR(4) = '%s',
  @StartDateTime NVARCHAR(100) = '%s',
  @EndDateTime NVARCHAR(100) = '%s',
  @HolidayDescription NVARCHAR(80) = '%s'
AS
---------------command line inputs-------
--DECLARE @Name NVARCHAR(80)
--SET @Name = '%s'
--DECLARE @isAnually NVARCHAR(4)
--SET @isAnually = '%s'
--DECLARE @StartDateTime NVARCHAR(100)
--SET @StartDateTime = '%s'
--DECLARE @EndDateTime NVARCHAR(100)
--SET @EndDateTime = '%s'
--DECLARE @HolidayDescription NVARCHAR(80)
--SET @HolidayDescription = '%s'
------------------command line input format------------------------------
-- cl=name YES/NO 10/17/2009 14:29:20 10/18/2009 16:29:20  Its a festival
-------------------------------------------------------------------------
------------------input prefixes-----------------------------------------
----------------------constants------------------------------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetHoliday'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling------------------------------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters -----------------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
BEGIN TRAN
IF @Name = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Group/Client Name not given.'
	GOTO ARGS_ERROR
END
SET @Name = RTRIM(LTRIM(@Name))
IF @StartDateTime = @noParameter or @EndDateTime = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Date and Time not given.'
	GOTO ARGS_ERROR
END
IF @isAnually = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error.Anunal Holiday Information not given (Yes/No)'
	GOTO ARGS_ERROR
END
IF @HolidayDescription = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Holday description is not given'
	GOTO ARGS_ERROR
END
-------------------------------------------------------------------------------
DECLARE @ClientId  INT
DECLARE @GroupId  INT
DECLARE @vtPolicyId INT
DECLARE @association NVARCHAR(10)
DECLARE @pos INT
BEGIN TRY
SET @association = UPPER(RTRIM(LTRIM(@Name)))
SET @pos = CHARINDEX('=',@association)
IF (@pos > 0)
BEGIN
	SET @association = LEFT(@association, @pos-1)
	SET @Name = RIGHT(@Name, LEN(@Name)-@pos)
END
IF @association = 'CG'
BEGIN
	IF EXISTS(SELECT id FROM APP_ClientGroup where name = @Name)
	BEGIN
		SET @GroupId = (SELECT id FROM APP_ClientGroup where name = @Name)
		SET @ClientId = 0
		SET @vtPolicyId = 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. InValid Group Name given ['+@Name+']'
		GOTO ARGS_ERROR
	END
END
ELSE IF @association = 'CL'
BEGIN
	IF EXISTS(SELECT id FROM APP_Client where name = @Name)
	BEGIN
		SET @ClientId = (SELECT id FROM APP_Client where name = @Name)
		SET @GroupId = 0
		SET @vtPolicyId = 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. InValid Client Name given ['+@Name+']'
		GOTO ARGS_ERROR
	END
END
ELSE IF @association = 'VT'
BEGIN
	IF EXISTS(SELECT PolicyId FROM VTPolicy where PolicyName = @Name)
	BEGIN
		SET @vtPolicyId = (SELECT PolicyId FROM VTPolicy where PolicyName = @Name)
		SET @GroupId = 0
		SET @ClientId = 0
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. InValid VT Policy Name given ['+@Name+']'
		GOTO ARGS_ERROR
	END
END
ELSE IF @association = 'CS'
BEGIN
	SET @ClientId = 0
	SET @GroupId = 0
	SET @vtPolicyId = 0
END
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid holiday association type'
	GOTO ARGS_ERROR
END
SET @isAnually = UPPER(RTRIM(LTRIM(@isAnually)))
DECLARE @isAnuallyInt int
SET @isAnuallyInt = (SELECT CASE(@isAnually) WHEN('YES') THEN 1 ELSE 0 END)
DECLARE @StartDay	int
SET @StartDay = 0
DECLARE @StartMonth	int
SET @StartMonth	= 0
DECLARE @StartYear	int
SET @StartYear	= 0
DECLARE @StartHour	int
SET @StartHour = 0
DECLARE @StartMin	int
SET @StartMin = 0
DECLARE @StartSec	int
SET @StartSec = 0
DECLARE @EndDay		int
SET @EndDay = 0
DECLARE @EndMonth	int
SET @EndMonth = 0
DECLARE @EndYear	int
SET @EndYear = 0
DECLARE @EndHour	int
SET @EndHour = 0
DECLARE @EndMin		int
SET @EndMin = 0
DECLARE @EndSec		int
SET @EndSec = 0
BEGIN TRY
		SET @StartDay	= DATEPART(DAY,@StartDateTime)
		SET @StartMonth	= DATEPART(MONTH,@StartDateTime)
		SET @StartYear	= DATEPART(YEAR,@StartDateTime)
		SET @StartHour	= DATEPART(HOUR,@StartDateTime)
		SET @StartMin	= DATEPART(MINUTE,@StartDateTime)
		SET @StartSec	= DATEPART(SECOND,@StartDateTime)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SET @errorCode = 1
		SET @errorString = 'Error. Wrong Start Date Time given'
		GOTO ARGS_ERROR
END CATCH
BEGIN TRY
		SET @EndDay		= DATEPART(DAY,@EndDateTime)
		SET @EndMonth	= DATEPART(MONTH,@EndDateTime)
		SET @EndYear	= DATEPART(YEAR,@EndDateTime)
		SET @EndHour	= DATEPART(HOUR,@EndDateTime)
		SET @EndMin		= DATEPART(MINUTE,@EndDateTime)
		SET @EndSec		= DATEPART(SECOND,@EndDateTime)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SET @errorCode = 1
		SET @errorString = 'Error. Wrong End Date Time given'
		GOTO ARGS_ERROR
END CATCH
BEGIN TRY
DECLARE @dtDiff int
SET @dtDiff = (SELECT DATEDIFF(SECOND, GETDATE(),@StartDateTime))
IF(@dtDiff < 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Past date are not allowed ['+@StartDateTime+']'
	GOTO ARGS_ERROR
END
SET @dtDiff = (SELECT DATEDIFF(SECOND, GETDATE(),@EndDateTime))
IF(@dtDiff < 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Past date are not allowed ['+@EndDateTime+']'
	GOTO ARGS_ERROR
END
SET @dtDiff = (SELECT DATEDIFF(SECOND, @StartDateTime,@EndDateTime))
IF (@dtDiff <= 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. End Date should be bigger than start date'
	GOTO ARGS_ERROR
END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @errorCode = 1
	SET @errorString = 'Error. Please Do not put Such a long Leave'
	GOTO ARGS_ERROR
END CATCH
SET @StartMonth = @StartMonth -1 -- start for 0 offset
SET @EndMonth = @EndMonth -1	 -- start for 0 offset
IF EXISTS(select * from SchedHoliday where (startYear = @StartYear or startYear = 0) and startMonth = @StartMonth and startDay = @StartDay and
startHour = @StartHour and startMinute = @StartMin and startSecond = @StartSec and endDay = @EndDay and endMonth = @EndMonth and
(endYear = @EndYear or endYear = 0) and endHour = @EndHour and endMinute = @EndMin and endSecond = @EndSec and clientId = @ClientId and groupId = @GroupId and vtPolicyId = @vtPolicyId)
BEGIN
	update SchedHoliday set description = @HolidayDescription,modified = @nowTime ,
		startYear = CASE(@isAnuallyInt)WHEN(0) THEN @StartYear ELSE 0 END
		,endYear = CASE(@isAnuallyInt)WHEN(0) THEN @EndYear ELSE 0 END
		where (startYear = @StartYear or startYear = 0) and startMonth = @StartMonth and startDay = @StartDay and
			startHour = @StartHour and startMinute = @StartMin and startSecond = @StartSec and endDay = @EndDay and endMonth = @EndMonth and
			(endYear = @EndYear or endYear = 0) and endHour = @EndHour and endMinute = @EndMin and endSecond = @EndSec and clientId = @ClientId and groupId = @GroupId and vtPolicyId = @vtPolicyId
	SET @errorCode = @@error
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Updation failed'
		GOTO ARGS_ERROR
	END
END
ELSE
BEGIN
	IF @isAnuallyInt <> 0
	BEGIN
		SET @EndYear	= 0
		SET @StartYear	= 0
	END
	insert into SchedHoliday (startYear,startMonth ,startDay,startHour,startMinute,startSecond,endYear,endMonth,endDay,
								endHour,endMinute,endSecond,clientId,groupId,description,modified,vtPolicyId)
		values(@StartYear,@StartMonth,@StartDay,@StartHour,@StartMin,@StartSec,@EndYear,@EndMonth,@EndDay,@EndHour,@EndMin,@EndSec,@ClientId,@GroupId,@HolidayDescription,@nowTime,@vtPolicyId)
	SET @errorCode = @@error
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Insertion failed'
		GOTO ARGS_ERROR
	END
END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @errorCode = @@ERROR
	SET @errorString = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+ ' with Parameters:[ clientId=' +CAST(@ClientId AS NVARCHAR(10))+ ' client groupId='+CAST(@GroupId AS NVARCHAR(10))+ ' VT PolicyId='+CAST(@vtPolicyId AS NVARCHAR(10))+ ' IsAnually='+@isAnually+
				' StartDateTime='+@StartDateTime + ' EndDateTime='+@EndDateTime+ ' Holiday Description='+@HolidayDescription +']. ErrorCode('+ Convert(varchar(2),@errorCode) +').'
ARGS_ERROR:
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetHoliday')
	delete from GxQscripts where name = 'QS_SetHoliday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetHoliday')
	delete from GXDBVersions where aliasname = 'QS_SetHoliday'
GO

insert into GXDBVersions values(2, 'QS_SetHoliday',  '00000000000000000000', 'QS_SetHoliday', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetHoliday',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetHoliday.sql -si name -si isAnnualHoliday -si StartDateTime -si EndDateTime -si HolidayDescription
'
 + CHAR(10) + '--   script_name : SetHoliday'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetIDAVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetIDAVersion <<<'

IF EXISTS (select * from sysobjects where name='QS_SetIDAVersion')
	drop procedure QS_SetIDAVersion
IF EXISTS (select * from GxQscripts where name='QS_SetIDAVersion')
	delete from GxQscripts where name = 'QS_SetIDAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIDAVersion')
	delete from GXDBVersions where aliasname = 'QS_SetIDAVersion'
GO
print '... Creating Procedure: QS_SetIDAVersion'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetIDAVersion
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @idaType varchar(1024) = '%s',
  @idaVersion varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName	= '%s'
--DECLARE @idaType	varchar(1024)
--SET		@idaType	= '%s'
--DECLARE @idaVersion	varchar(1024)
--SET		@idaVersion	= '%s'
---------------------------------------
--test
--SET		@clientName	= 'MyClient'
--SET		@idaType	= 'File System'
--SET		@idaVersion	= '12'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetIDAVersion'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @clientName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client Name Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @idaType	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA type Expected as parameter 2.'
	GOTO ARGS_ERROR
END
IF @idaVersion	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. IDA version name Expected as parameter 3.'
	GOTO ARGS_ERROR
END
--------------Validate client name ---------------------
DECLARE @clientId	INT
DECLARE @now		INT
DECLARE @componentId	INT
DECLARE @appTypeId	INT
SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = @clientName), 0)
IF @clientId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client [' + @clientName + '] Not found.'
	GOTO ARGS_ERROR
END
SET @appTypeId = ISNULL((SELECT DISTINCT type FROM APP_IDAType WHERE displayName = @idaType AND
			type IN (SELECT DISTINCT appTypeId FROM APP_Application WHERE clientId = @clientId)), 0)
IF @appTypeId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Application type [' + @idaType + '] Not found for client ['+@clientName+'].'
	GOTO ARGS_ERROR
END
SET @now = dbo.GetUnixTime (GetUTCdate())
SET @componentId = ISNULL((SELECT TOP 1 id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = @appTypeId), 0)
IF @componentId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Could not find appType ['+@idaType+'] for client ['+@clientName+'].'
	GOTO ARGS_ERROR
END
--------------SETP 1 ---------------------
BEGIN TRY
BEGIN TRAN
	IF EXISTS(SELECT * FROM APP_IDAProp WHERE attrName='IDA Version' AND componentNameId = @componentId AND modified = 0 )
	BEGIN	--DO UPDATE
		UPDATE APP_IDAProp SET modified = @now WHERE attrName='IDA Version' AND componentNameId IN (
		SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = @appTypeId
		) AND modified = 0
	END
	INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrVal, created, modified)
	VALUES (@componentId, 'IDA Version', 10, @idaVersion, @now, 0)
	set @lastError = @@ERROR
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not update property'
		GOTO TRANS_EXIT
	END
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	DECLARE @o_errorCode INT
	DECLARE @tmpErrorString NVARCHAR
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
	PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
	PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'
		ROLLBACK TRANSACTION;
	END
END CATCH;
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName+', '+@idaType+', '+@idaVersion+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetIDAVersion')
	delete from GxQscripts where name = 'QS_SetIDAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetIDAVersion')
	delete from GXDBVersions where aliasname = 'QS_SetIDAVersion'
GO

insert into GXDBVersions values(2, 'QS_SetIDAVersion',  '00000000000000000000', 'QS_SetIDAVersion', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetIDAVersion',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript sn SetIDAVersion.sql -si clientName -si ida type -si version
'
 + CHAR(10) + '--   script_name : SetIDAVersion'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetJobConfiguration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetJobConfiguration <<<'

IF EXISTS (select * from sysobjects where name='QS_SetJobConfiguration')
	drop procedure QS_SetJobConfiguration
IF EXISTS (select * from GxQscripts where name='QS_SetJobConfiguration')
	delete from GxQscripts where name = 'QS_SetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_SetJobConfiguration'
GO
print '... Creating Procedure: QS_SetJobConfiguration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetJobConfiguration
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s',
  @OPT varchar(512) = '%s',
  @VAL varchar(512) = '%s',
  @PWD varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @PARAM1 varchar(512)
--DECLARE @OPT    varchar(512)
--DECLARE @VAL    varchar(512)
--DECLARE @PWD	varchar(512)
--SET @PARAM1 = '%s'  			-- c=clientName, allclients
--SET @OPT = '%s'					-- what is to be set, DiskFullPercent, JMPriority, JobResultsThresholdMB, AgingDays, username, password
--SET @VAL = '%s'					-- new value
--SET @PWD = '%s'					-- optional encrypted password. only if username is being changed
--SET @PARAM1 =  'c=roman'
--SET @OPT =	'1'
--SET @VAL =	'80'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetJobConfiguration'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
---------------------- Validate Inputs -----------------------------
if(@PARAM1 = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
IF @OPT = @NoParameter OR (@OPT <> 1 AND @OPT <> 2 AND @OPT <>3 AND @OPT <>4 AND @OPT <>5 AND @OPT <>6)
BEGIN
	SET @localErrorMsg	='Error. Parameter2 must be refer to what option you want to set(1-6). Please read the script readme for more information.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @OPTNAME varchar(64)
SET @OPTNAME = (CASE @OPT
WHEN '1' THEN 'DiskFullPercent'
WHEN '2' THEN 'JMPriority'
WHEN '3' THEN 'JobResultsThresholdMB'
WHEN '4' THEN 'AgingDays'
WHEN '5' THEN 'Job Results Dir Username'
WHEN '6' THEN 'Job Results Dir Password'
ELSE ''
END)
DECLARE @OPTTYPE varchar(64)
SET @OPTTYPE = (CASE @OPT
WHEN '1' THEN '7' --integer
WHEN '2' THEN '7'
WHEN '3' THEN '7'
WHEN '4' THEN '7'
WHEN '5' THEN '1' --string
WHEN '6' THEN '1'
ELSE '1'
END)
IF @OPTNAME = ''
BEGIN
	SET @localErrorMsg	='Error. Unsupported option ['+@OPT+']. Please read the script readme for more information.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @VAL= @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Parameter3 must be the the new value. Please read the script readme for more information.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @OPTNAME = 'JMPriority' AND (@VAL < 0 OR @VAL > 9)
BEGIN
	SET @localErrorMsg	='Error. Job proprity must be in the range 0-9.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @OPTNAME = 'DiskFullPercent' AND (@VAL < 0 OR @VAL > 100)
BEGIN
	SET @localErrorMsg	='Error. Invalid input for "Prune Job results when Disk Capaicity reaches". This is a percentage value.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @OPTNAME = 'Job Results Dir Username' AND @PWD= @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Password was empty. Please propide the encrypted password for user ['+@VAL+'].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
	IF @clientId = 0
	BEGIN
		--if present already update it
		-- SKatz: This really should be a cursor so we can look at each client, one by one and determine
		--        whether or not to update the property.  This current method will potentially age properties
		--		  that really haven't changed!
		UPDATE APP_CLIENTPROP SET ATTRVAL =@VAL WHERE AttrName = @OPTNAME	AND MODIFIED = 0
		--insert it for all other clients
		INSERT INTO APP_CLIENTPROP (componentnameid, attrname, attrval, attrtype, created, modified)
				SELECT id, @OPTNAME, @VAL, @OPTTYPE, @nowTime, 0  FROM	APP_CLIENT
				WHERE id not in (SELECT Cli.id
					FROM APP_CLIENT Cli, APP_CLIENTPROP Prop
					WHERE Cli.id = Prop.componentnameid AND Prop.AttrName = @OPTNAME AND Prop.MODIFIED = 0)
	END
	ELSE
	BEGIN
		IF (exists(SELECT * FROM APP_CLIENTPROP WHERE AttrName = @OPTNAME AND componentNameId = @clientId AND MODIFIED = 0))
			UPDATE APP_CLIENTPROP SET ATTRVAL =@VAL WHERE AttrName = @OPTNAME AND componentNameId = @clientId AND MODIFIED = 0
		ELSE
			INSERT INTO APP_CLIENTPROP (componentnameid, attrname, attrval, attrtype, created, modified)
				VALUES (@clientId, @OPTNAME, @VAL, @OPTTYPE, @nowTime, 0)
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems updating Job Result Information ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: [ ' + @PARAM1 +', ' +@OPT+', ' +@VAL
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetJobConfiguration')
	delete from GxQscripts where name = 'QS_SetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_SetJobConfiguration'
GO

insert into GXDBVersions values(2, 'QS_SetJobConfiguration',  '00000000000000000000', 'QS_SetJobConfiguration', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetJobConfiguration',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn setJobConfiguration.sql -si c=clientName|allclients -si option -si new_value
'
 + CHAR(10) + '--   script_name : SetJobConfiguration'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetJobDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetJobDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_SetJobDescription')
	drop procedure QS_SetJobDescription
IF EXISTS (select * from GxQscripts where name='QS_SetJobDescription')
	delete from GxQscripts where name = 'QS_SetJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobDescription')
	delete from GXDBVersions where aliasname = 'QS_SetJobDescription'
GO
print '... Creating Procedure: QS_SetJobDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetJobDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @inJobId varchar(64) = '%s',
  @jobDescription varchar(4096) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @inJobId	varchar(64)
--SET @inJobId =	'%s'
--SET @inJobId = 10
--DECLARE @jobDescription	varchar(4096)
--SET @jobDescription =	'%s'
--SET @jobDescription =	'jayaram test'
-------------------------------------------
---- Convenience Definitions    -----------
-------------------------------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetJobDescription'
-------------------------------------------
-------- Local Variables    -------------
-------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
DECLARE @currDTime				datetime
DECLARE @inChangeTime			bigint
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0			-- Be optimistic
DECLARE @NoParameter varchar(4)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------------------------------------------
---- Input parameter validation -----------
-------------------------------------------
IF (@inJobId = @NoParameter) or (@jobDescription = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid jobId paramater value or description'
	Set @lastError = 1
	goto	ARGS_ERROR
END
IF NOT EXISTS(select *from JMJobStats where jobId = @inJobId)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid jobId.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-------------------------------------------
----- Procession Logic --------------------
-------------------------------------------
BEGIN TRY
BEGIN TRAN
	-- Getting the current UTC Data Time
	set @currDTime = GETUTCDATE()
	-- Converting the UTC Date Time into milli seconds
	set @inChangeTime =  dbo.getunixtime(@currDTime)*2147483648 + DATEPART(ms,@currDTime)
	IF EXISTS(select *from JMJobStats where jobId = @inJobId)
		update JMJobStats set jobDescription = @jobDescription where jobId = @inJobId and commCellId = 2
	IF EXISTS(select *from JMJobInfo where jobId = @inJobId)
		update JMJobInfo set jobDescription = @jobDescription, lastStateChangeTime = @inChangeTime
		 where jobId = @inJobId
COMMIT TRAN
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	ROLLBACK TRAN
	SET @localErrorMsg = 'Error.  Database error occured. Please retry'
	Set @lastError = 1
	goto   ARGS_ERROR
END CATCH
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetJobDescription')
	delete from GxQscripts where name = 'QS_SetJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetJobDescription')
	delete from GXDBVersions where aliasname = 'QS_SetJobDescription'
GO

insert into GXDBVersions values(2, 'QS_SetJobDescription',  '00000000000000000000', 'QS_SetJobDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetJobDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetJobDescription.sql -si jobId -si jobDescription
'
 + CHAR(10) + '--   script_name : SetJobDescription'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetKeyIntoGlobalParamTbl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetKeyIntoGlobalParamTbl <<<'

IF EXISTS (select * from sysobjects where name='QS_SetKeyIntoGlobalParamTbl')
	drop procedure QS_SetKeyIntoGlobalParamTbl
IF EXISTS (select * from GxQscripts where name='QS_SetKeyIntoGlobalParamTbl')
	delete from GxQscripts where name = 'QS_SetKeyIntoGlobalParamTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetKeyIntoGlobalParamTbl')
	delete from GXDBVersions where aliasname = 'QS_SetKeyIntoGlobalParamTbl'
GO
print '... Creating Procedure: QS_SetKeyIntoGlobalParamTbl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetKeyIntoGlobalParamTbl
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @key varchar(512) = '%s',
  @enabled varchar(64) = '%s',
  @value varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @key varchar(512)
--SET @key	=		'%s'
--DECLARE @enabled	varchar(64)
--SET @enabled =		'%s'
--DECLARE @value varchar(512)
--SET @value	=		'%s'
--------------------------------------------
-- Testing --
--------------------------------------------
--SET @key		=		'JMExtnRtnCombinedPriority'
--SET @enabled	=		'Y'
--SET @value	=		'066'
--------------------------------------------
-- Convenience Definitions --
--------------------------------------------
DECLARE @scriptName			varchar(32)
SET		@scriptName	=		'SetKeyIntoGlobalParamTbl'
DECLARE @transactionName	varchar(32)
SET @transactionName =		'SetKeyIntoGlobalParamTblTran'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--------------------------------------------
-- Local Variables --
--------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--------------------------------------------
--------------------------------------------
-- @enabled is compulsory param
if (@enabled = @noParameter) or (LOWER(@enabled) <> 'y' and LOWER(@enabled) <> 'n') or
   (@key = @noParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Invalid enabled or key paramater value. Enter [y] to enable and [n] to disable.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-- If @enabled is true, Validate @value
if (LOWER(@enabled) = 'y')
	if @value = @noParameter
	BEGIN
		SET @localErrorMsg = 'Error.  Invalid value parameter  value.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
BEGIN TRY
BEGIN TRANSACTION @transactionName
	DELETE from GxGlobalParam where name = @key
	if (@enabled ='y')
		INSERT INTO GxGlobalParam(name,value,created,modified) VALUES (@key, @value,dbo.GetUnixTime(GetUTCDate()),0)
COMMIT TRANSACTION @transactionName
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	ROLLBACK TRANSACTION @transactionName
	SET @localErrorMsg = 'Error.  Database error occured. Please retry'
	Set @lastError = 1
	goto   ARGS_ERROR
END CATCH
ARGS_ERROR:
	if (@lastError <> 0)
		Raiserror(@localErrorMsg,
				    15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetKeyIntoGlobalParamTbl')
	delete from GxQscripts where name = 'QS_SetKeyIntoGlobalParamTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetKeyIntoGlobalParamTbl')
	delete from GXDBVersions where aliasname = 'QS_SetKeyIntoGlobalParamTbl'
GO

insert into GXDBVersions values(2, 'QS_SetKeyIntoGlobalParamTbl',  '00000000000000000000', 'QS_SetKeyIntoGlobalParamTbl', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetKeyIntoGlobalParamTbl',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	To set the key "JMExtnRtnCombinedPriority" into gxglobalparam table
'
 + CHAR(10) + '	qoperation execscript -sn SetKeyIntoGlobalParamTbl.sql -si JMExtnRtnCombinedPriority -si y -si 066
'
 + CHAR(10) + '	To remove the key from gxglobalparam table
'
 + CHAR(10) + '	qoperation execscript -sn SetKeyIntoGlobalParamTbl.sql -si JMExtnRtnCombinedPriority -si n
'
 + CHAR(10) + '--   script_name : SetKeyIntoGlobalParamTbl'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetMSSQLCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetMSSQLcredentials <<<'

IF EXISTS (select * from sysobjects where name='QS_SetMSSQLcredentials')
	drop procedure QS_SetMSSQLcredentials
IF EXISTS (select * from GxQscripts where name='QS_SetMSSQLcredentials')
	delete from GxQscripts where name = 'QS_SetMSSQLcredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMSSQLcredentials')
	delete from GXDBVersions where aliasname = 'QS_SetMSSQLcredentials'
GO
print '... Creating Procedure: QS_SetMSSQLcredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetMSSQLcredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s',
  @PARAM2 varchar(512) = '%s',
  @PARAM3 varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER! 				 --
---------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--DECLARE @PARAM3     	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM2 = '%s'					-- encryptedpassworrd
--SET @PARAM3 = '%s'					-- username (optional)
DECLARE @HIDEPARAM2 	varchar(512)
SET		@HIDEPARAM2		=@PARAM2				-- COMMENT OUT THE NEXT LINE SO THAT PASSWORD IS DISPLAYED!
SET		@HIDEPARAM2		='XXXXXXX'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetMSSQLcredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--DECLARE @MAX_ENTITY_SIZE		smallint
--SET @MAX_ENTITY_SIZE			=100
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
---SET @PARAM1 =  'c=jewelfish_cn'
---SET @PARAM1 =  'allclients'
---SET @PARAM2 =  'QWERTY'
--SET @PARAM3 =	 'Stuk'
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
---------------------------------------
---  ENCRYPTED PASSWORD				---
---------------------------------------
IF @PARAM2 = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Encrypted password must specified as parameter2.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @Password = @PARAM2
---------------------------------------
---  USERNAME (OPTIONAL)			---
---------------------------------------
IF @PARAM3 = @NoParameter
	SET @USERNAME=''
ELSE
	SET @USERNAME = @PARAM3
IF LEN(@USERNAME) > 100
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. User name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1 +', ' +@HIDEPARAM2 +', ' +REPLACE(@PARAM3, @NoParameter, '[]')
IF @USERNAME =''
	PRINT '................. Username not specified. Existing Username(s) will be preserved.'
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
-- MS SQL SERVER --
	IF @clientId = 0
	BEGIN
		UPDATE APP_INSTANCEPROP
			SET ATTRVAL =@PASSWORD
			  WHERE AttrName = 'MSSQL password'
				AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE appTypeId in (4, 16, 70, 81))
				AND MODIFIED = 0
		IF @userName <> ''
			UPDATE APP_INSTANCEPROP
				SET ATTRVAL =@UserName
				  WHERE AttrName = 'MSSQL username'
					AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE appTypeId in (4, 16, 70, 81))
					AND MODIFIED = 0
	END
	ELSE
	BEGIN
		UPDATE APP_INSTANCEPROP
			SET ATTRVAL = @PASSWORD
			  WHERE AttrName = 'MSSQL password'
				AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE clientId = @clientID AND appTypeId in (4, 16, 70, 81))
				AND Modified = 0
		IF @userName <> ''
			UPDATE APP_INSTANCEPROP
				SET ATTRVAL =@UserName
				  WHERE AttrName = 'MSSQL username'
					AND componentNameId in (select DISTINCT instance from APP_APPLICATION WHERE clientId = @clientID AND appTypeId in (4, 16, 70, 81))
					AND MODIFIED = 0
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems updating Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + +REPLACE(@PARAM1, @NoParameter, '[]') +', ' +@HIDEPARAM2 +', ' +REPLACE(@PARAM3, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetMSSQLCredentials')
	delete from GxQscripts where name = 'QS_SetMSSQLCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetMSSQLCredentials')
	delete from GXDBVersions where aliasname = 'QS_SetMSSQLCredentials'
GO

insert into GXDBVersions values(2, 'QS_SetMSSQLCredentials',  '00000000000000000000', 'QS_SetMSSQLCredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetMSSQLCredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f SetMSSQLcredentials -i c=clientName|allclients  encryptedPassword [userName]
'
 + CHAR(10) + '--   script_name : SetMSSQLcredentials'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNetHostName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetNetHostName <<<'

IF EXISTS (select * from sysobjects where name='QS_SetNetHostName')
	drop procedure QS_SetNetHostName
IF EXISTS (select * from GxQscripts where name='QS_SetNetHostName')
	delete from GxQscripts where name = 'QS_SetNetHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostName')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostName'
GO
print '... Creating Procedure: QS_SetNetHostName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetNetHostName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @netHostName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
--DECLARE @netHostName varchar(1024)
--SET @netHostName = '%s'
--DECLARE @MAX_ENTITY_SIZE smallint
--SET @MAX_ENTITY_SIZE = 100
--------------------------------------
--SET @clientName  = 'bingo_cn'
--SET @netHostName = 'bingo.gp.cv.commvault.com'
--------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'SetNetHostName'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError	integer
DECLARE @localErrorMsg	varchar(512)
SET	@localErrorMsg	='Error Encountered when running script.'
SET     @lastError  = 0					-- Be optimistic
DECLARE @nowTime integer
SET @nowTime  = dbo.GetUnixTime (GetUTCdate())
----------- VAlidate inputs   -------------
if @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
if @netHostName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  NetHostName for Client ['+ @clientName +'] was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------- Check if client exists ---------------
if NOT EXISTS(select 1 from APP_Client C where C.name like @clientNAme)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------- Check for Duplicate netHostName ----------------
DECLARE @duplicateName			varchar(1024)
if EXISTS (Select 1 from APP_Client C where C.net_hostname = @netHostName)
BEGIN
	SET @duplicateNAme	 = (select C.name from APP_Client C where C.net_hostname = @netHostName)
	SET @localErrorMsg = 'Error.  HostName ['+@netHostName +']already exists for client ['+ @duplicateName+ '].'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF LEN(@netHostName ) > 100
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Host Name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
----------- Set netHostName  -------------
UPDATE APP_Client SET net_hostname = @netHostName, modified = @nowTime WHERE name like  @clientName
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
	 + ' with Parameters: netHostName = ['
         + @netHostName
         + '], client name = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNetHostName')
	delete from GxQscripts where name = 'QS_SetNetHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostName')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostName'
GO

insert into GXDBVersions values(2, 'QS_SetNetHostName',  '00000000000000000000', 'QS_SetNetHostName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetNetHostName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNetHostName.sql -si clientName -si netHostName
'
 + CHAR(10) + '--   script_name : SetNetHostName'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNetHostnameByID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetNetHostNameByID <<<'

IF EXISTS (select * from sysobjects where name='QS_SetNetHostNameByID')
	drop procedure QS_SetNetHostNameByID
IF EXISTS (select * from GxQscripts where name='QS_SetNetHostNameByID')
	delete from GxQscripts where name = 'QS_SetNetHostNameByID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostNameByID')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostNameByID'
GO
print '... Creating Procedure: QS_SetNetHostNameByID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetNetHostNameByID
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientId varchar(1024) = '%s',
  @netHostName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientId varchar(1024)
--SET @clientId = '%s'
--DECLARE @netHostName varchar(1024)
--SET @netHostName = '%s'
--------------------------------------
--SET @clientId = 2
--SET @netHostName = 'spark'
--------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetNetHostNameByID'
DECLARE @propName varchar(32)
SET @propName  = 'NetHost Name'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @duplicateID			varchar(1024)
DECLARE @duplicateClient		varchar(1024)
--DECLARE @MAX_ENTITY_SIZE	smallint
--SET @MAX_ENTITY_SIZE = 100
----------- VAlidate inputs   -------------
if @clientId = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  ClientId was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
if @netHostName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  NetHostName for Client ['+ @clientId +'] was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------- Check if client ID exists ---------------
if NOT EXISTS(select 1 from APP_Client C where C.id = @clientId)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientId + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------- Check for Duplicate netHostName ----------------
if EXISTS (Select 1 from APP_Client C where C.net_hostname = @netHostName)
BEGIN
	SET @duplicateID	 = (select C.id from APP_Client C where C.net_hostname = @netHostName)
	SET @duplicateClient = (select C.name from APP_Client C where C.net_hostname = @netHostName)
	SET @localErrorMsg = 'Error.  HostName already exists for clientId ['+ @duplicateID + '] and alias name ['+ @duplicateClient +']'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF(LEN(@netHostName) > 100 )
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Host name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
----------- Set netHostName  -------------
UPDATE APP_Client SET net_hostname = @netHostName WHERE id = @clientId
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: netHostName = ['
         + @netHostName
         + '], client = ['
         + @clientId
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNetHostnameByID')
	delete from GxQscripts where name = 'QS_SetNetHostnameByID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNetHostnameByID')
	delete from GXDBVersions where aliasname = 'QS_SetNetHostnameByID'
GO

insert into GXDBVersions values(2, 'QS_SetNetHostnameByID',  '00000000000000000000', 'QS_SetNetHostnameByID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetNetHostnameByID',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNetHostNameByID -si clientID -si netHostName
'
 + CHAR(10) + '--   script_name : SetNetHostNameByID'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetOracleCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetOraclecredentials <<<'

IF EXISTS (select * from sysobjects where name='QS_SetOraclecredentials')
	drop procedure QS_SetOraclecredentials
IF EXISTS (select * from GxQscripts where name='QS_SetOraclecredentials')
	delete from GxQscripts where name = 'QS_SetOraclecredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOraclecredentials')
	delete from GXDBVersions where aliasname = 'QS_SetOraclecredentials'
GO
print '... Creating Procedure: QS_SetOraclecredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetOraclecredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s',
  @PARAM2 varchar(512) = '%s',
  @PARAM3 varchar(512) = '%s',
  @PARAM4 varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--DECLARE @PARAM3     	varchar(512)
--DECLARE @PARAM4     	varchar(512)
DECLARE @HIDEPARAM3 	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM2 = '%s'					-- Type (Catalog, DB, (user) impersonate
--SET @PARAM3 = '%s'					-- encryptedpassworrd
--SET @PARAM4 = '%s'					-- username (optional)
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @PARAM1 =	'c=TESTRAC'
--SET @PARAM1 =	'allclients'
--SET @PARAM2 =	't=RAC'
--SET @PARAM3 =	'BadPassword'
--SET @PARAM4 =	'GALAXYLAB\administrator'
SET		@HIDEPARAM3		=@PARAM3				-- COMMENT OUT THE NEXT LINE SO THAT PASSWORD IS DISPLAYED!
SET		@HIDEPARAM3		='XXXXXXX'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetOraclecredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
-----
DECLARE @CV_ORACLE_CATALOG_CONNECT		varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT		= 'Catalog Connect'
DECLARE @CV_ORACLE_CATALOG_CONNECT_PWD	varchar(40)
SET		@CV_ORACLE_CATALOG_CONNECT_PWD	= 'Catalog Connect Password'
-----
DECLARE @CV_ORACLE_SQL_CONNECT			varchar(40)
SET		@CV_ORACLE_SQL_CONNECT			= 'SQL Connect'
DECLARE @CV_ORACLE_SQL_CONNECT_PWD		varchar(40)
SET		@CV_ORACLE_SQL_CONNECT_PWD		= 'SQL Connect Password'
-----
DECLARE @CV_ORACLE_DOMAIN_NAME			varchar(40)
SET		@CV_ORACLE_DOMAIN_NAME			= 'Domain Name'
DECLARE @CV_ORACLE_DOMAIN_USER_PASSWORD	varchar(40)
SET		@CV_ORACLE_DOMAIN_USER_PASSWORD	= 'Domain User Password'
DECLARE	@CV_ORACLE_USER_NAME			varchar(40)
SET		@CV_ORACLE_USER_NAME			='Oracle User'
DECLARE @MAX_ENTITY_SIZE smallint
SET @MAX_ENTITY_SIZE = 100
-----
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @password				nvarchar(1024)
DECLARE @userName				nvarchar(1024)
DECLARE @domainName				nvarchar(1024)
SET		@domainName				=''
DECLARE @useConnect				nvarchar(40)
SET		@useConnect				=''
DECLARE @usePassword			nvarchar(40)
SET		@usePassword			=''
DECLARE	@isOracleRAC			integer
SET		@isOracleRAC			= 0
DECLARE @SlashPosn				int
DECLARE @Domain					nvarchar(1024)
DECLARE @winOStype int = 0
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
---------------------------------------
---       CREDENTIALS TYPE			---
-- Type is one of:					---
--   Catalog, DB, user impersonate  ---
--   or Oracle RAC					---
---------------------------------------
IF @PARAM2 = 't=Catalog'
BEGIN
	SET		@useConnect				=@CV_ORACLE_CATALOG_CONNECT
	SET		@usePassword			=@CV_ORACLE_CATALOG_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=DB'
BEGIN
	SET		@useConnect				=@CV_ORACLE_SQL_CONNECT
	SET		@usePassword			=@CV_ORACLE_SQL_CONNECT_PWD
END
ELSE IF @PARAM2 = 't=Impersonate'
BEGIN
--	SET		@useConnect				=@CV_ORACLE_DOMAIN_NAME
	SET		@useConnect				=@CV_ORACLE_USER_NAME
	SET		@usePassword			=@CV_ORACLE_DOMAIN_USER_PASSWORD
	SET		@winOStype				=1
END
ELSE IF @PARAM2 = 't=RAC'
	SET		@isOracleRAC = 1
-----
ELSE
BEGIN
	SET @localErrorMsg	='Error. Parameter 2 must be specified as t=Catalog|DB|Impersonate|RAC.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
---------------------------------------
---  ENCRYPTED PASSWORD				---
---------------------------------------
IF @PARAM3 = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Encrypted password must be specified as parameter3.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
SET @Password = @PARAM3
---------------------------------------
---  USERNAME (OPTIONAL)				---
---------------------------------------
IF @PARAM4 = @NoParameter
	SET @USERNAME=''
ELSE IF LEN(@PARAM4 ) > @MAX_ENTITY_SIZE
BEGIN
	SET @localErrorMsg = 'Error. User name cannot be more than ' + CAST(@MAX_ENTITY_SIZE AS VARCHAR(3)) + ' characters.'
	SET @lastError = 1
	goto ARGS_ERROR
END
ELSE
BEGIN
IF @PARAM2 = 't=Impersonate'
BEGIN
	SET	@SlashPosn  = CHARINDEX('\', @PARAM4)
	IF @SlashPosn <> 0
	BEGIN
		SET @Domain		=SUBSTRING(@PARAM4, 1, @SLASHPOSN-1)
		SET @USERNAME	=SUBSTRING(@PARAM4, @SLASHPOSN+1, LEN(@PARAM4)-@SLASHPOSN)
--		select step='debug', domain=@Domain, userN=@USERNAME
	END
	ELSE
		SET @USERNAME = @PARAM4
END
ELSE
		SET @USERNAME = @PARAM4
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1 +', ' +@PARAM2+', ' +REPLACE(@HIDEPARAM3, @NoParameter, '[]') +', ' +REPLACE(@PARAM4, @NoParameter, '[]')
         + ')'
IF @USERNAME =''
	PRINT '................. Username not specified. Existing Username(s) will be preserved.'
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
DECLARE @instId int
DECLARE @instanceCur CURSOR
BEGIN TRAN
BEGIN TRY
	IF @IsOracleRAC = 0
	BEGIN
		IF object_id('tempdb.dbo.#tempInstancetbl') IS NOT null DROP TABLE #tempInstancetbl
		CREATE TABLE #tempInstancetbl (instanceId int)
		IF @winOStype = 0
		BEGIN
		INSERT into #tempInstancetbl
		SELECT distinct inst.id FROM APP_InstanceName inst JOIN APP_APPLICATION app ON  inst.id = app.instance WHERE appTypeId in (2, 22, 80) and inst.status & 16 = 0 and inst.status & 2048 = 0 and (clientId = @clientId or @clientId=0)
		END
		ELSE
		BEGIN
		INSERT into #tempInstancetbl
		SELECT distinct inst.id FROM APP_InstanceName inst JOIN APP_APPLICATION app ON  inst.id = app.instance JOIN APP_Client client on client.id = app.clientId  WHERE appTypeId in (2, 22, 80) and inst.status & 16 = 0 and inst.status & 2048 = 0 and (clientId = @clientId or @clientId=0) AND client.simOperatingSystemId in (select id from simOperatingSystem where Type = 'windows')
		END
		--IF @clientId = 0
		--BEGIN
			SET @instanceCur = CURSOR
			FOR (SELECT instanceId from #tempInstancetbl)
			OPEN @instanceCur
			FETCH NEXT FROM @instanceCur INTO @instId
			WHILE @@FETCH_STATUS = 0
			BEGIN
			--password
			IF EXISTS (select * from APP_InstanceProp where attrName = @usePassword and modified = 0 and componentNameId = @instId)
				UPDATE APP_InstanceProp SET attrVal = @PASSWORD WHERE attrName = @usePassword AND modified = 0 and componentNameId = @instId
			ELSE
				INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified) VALUES (@instId, @usePassword, 1, @PASSWORD, dbo.GetUnixTime (GetUTCdate()), 0)
			--userName
			IF @userName <> ''
			BEGIN
			IF EXISTS (select * from APP_InstanceProp where attrName = @useConnect and modified = 0 and componentNameId = @instId)
				UPDATE APP_InstanceProp SET attrVal = @UserName WHERE attrName = @useConnect AND modified = 0  and componentNameId = @instId
			ELSE
				INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified) VALUES (@instId, @useConnect, 1, @UserName, dbo.GetUnixTime (GetUTCdate()), 0)
			END
			IF @domain <> ''
			BEGIN
			IF EXISTS (select * from APP_InstanceProp where attrName = @CV_ORACLE_DOMAIN_NAME and modified = 0 and componentNameId = @instId)
				UPDATE APP_InstanceProp SET attrVal = @domain WHERE attrName = @CV_ORACLE_DOMAIN_NAME AND modified = 0  and componentNameId = @instId
			ELSE
				INSERT INTO APP_InstanceProp (componentnameid, attrname, attrType, attrVal, created, modified) VALUES (@instId, @CV_ORACLE_DOMAIN_NAME, 1, @domain, dbo.GetUnixTime (GetUTCdate()), 0)
			END
			FETCH NEXT FROM @instanceCur INTO @instId
			END--END cursor fetch loop
			DEALLOCATE @instanceCur
	--	END
		GOTO ALL_DONE						-- DONE WITH NON-ORACLE RAC
	END
---- FOR ORACLE RAC, WILL UPDATE APP_ORACLERACINSTANCE TABLE WHERE INSTANCEid=INSTANCE OF ORACLE RAC INSTANCE DERIVED FROM
---- APP_APPLICATION TABLE.  Columns to be updated are InstanceOraUser and InstanceOraPasswd. For now, all RAC Instances for the
---- Chosen instance will be updated (all clients or under pseudo client).  Future will be able to select a particular one by name? or clientId?
	IF @clientId = 0
	BEGIN
--		SELECT step='debug before:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
		IF @userName <> ''
			UPDATE APP_OracleRACInstance
				SET InstanceOraUser = @USERNAME, InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
		ELSE
			UPDATE APP_OracleRACInstance
				SET InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
--		SELECT step='debug after:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80)
	END
	ELSE
	BEGIN
--		SELECT step='debug before:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80 and clientId=@clientId)
		IF @userName <> ''
			UPDATE APP_OracleRACInstance
				SET InstanceOraUser = @USERNAME, InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80 and clientId=@clientId)
		ELSE
			UPDATE APP_OracleRACInstance
				SET InstanceOraPasswd = @password
				WHERE instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80and clientId=@clientId)
--		SELECT step='debug after:',  * from APP_OracleRACInstance where instaceId in (Select Distinct instance FROM app_application WHERE appTypeId = 80 and clientId=@clientId)
	END
END TRY
BEGIN CATCH
BEGIN
	
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems updating Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF object_id('tempdb.dbo.#tempInstancetbl') IS NOT null DROP TABLE #tempInstancetbl
IF (@lastError  = 0)
	commit   Tran
--	rollback Tran				-- For Debugging
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( '
		 +REPLACE(@PARAM1, @NoParameter, '[]') +', '
		 +REPLACE(@PARAM2, @NoParameter, '[]') +', '
		 +REPLACE(@HIDEPARAM3, @NoParameter, '[]') +', '
		 +REPLACE(@PARAM4, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetOracleCredentials')
	delete from GxQscripts where name = 'QS_SetOracleCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOracleCredentials')
	delete from GXDBVersions where aliasname = 'QS_SetOracleCredentials'
GO

insert into GXDBVersions values(2, 'QS_SetOracleCredentials',  '00000000000000000000', 'QS_SetOracleCredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetOracleCredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qscript -f setOraclecredentials -i c=clientName|allclients t=Catalog|DB|Impersonate|RAC	encryptedpassword [username]
'
 + CHAR(10) + '--   script_name : SetOraclecredentials'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetOracleRestoreRestart.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetOracleRestoreRestart <<<'

IF EXISTS (select * from sysobjects where name='QS_SetOracleRestoreRestart')
	drop procedure QS_SetOracleRestoreRestart
IF EXISTS (select * from GxQscripts where name='QS_SetOracleRestoreRestart')
	delete from GxQscripts where name = 'QS_SetOracleRestoreRestart'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOracleRestoreRestart')
	delete from GXDBVersions where aliasname = 'QS_SetOracleRestoreRestart'
GO
print '... Creating Procedure: QS_SetOracleRestoreRestart'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetOracleRestoreRestart
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @operation varchar(10) = '%s'
AS
Set NOCOUNT ON
--DECLARE @operation			varchar(10)
--SET		@operation			= '%s'
DECLARE @enable	varchar(10)
SET		@enable = 'enable'
DECLARE @disable	varchar(10)
SET		@disable = 'disable'
-----------------------error handling------------------------------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
-- Convenience Definitions ----------------------
DECLARE @scriptName	varchar(128)
set	@scriptName	= 'SetOracleRestoreRestart'
IF @operation = @enable
BEGIN
	update JMPhase set restartable = 1 where id in (
		select id from JMPhase where optableid in (select id from jmoptable where appTypeType in (2, 22, 23,80) and operation = 5) and phase in (2,3))
END
ELSE IF @operation = @disable
BEGIN
		update JMPhase set restartable = 0 where id in (
			select id from JMPhase where optableid in (select id from jmoptable where appTypeType in (2, 22, 23,80) and operation = 5) and phase in (2,3))
END
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Incorrect argument given.'
	GOTO ARGS_ERROR
END
ARGS_ERROR:
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetOracleRestoreRestart')
	delete from GxQscripts where name = 'QS_SetOracleRestoreRestart'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetOracleRestoreRestart')
	delete from GXDBVersions where aliasname = 'QS_SetOracleRestoreRestart'
GO

insert into GXDBVersions values(2, 'QS_SetOracleRestoreRestart',  '00000000000000000000', 'QS_SetOracleRestoreRestart', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetOracleRestoreRestart',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetOracleRestoreRestart.sql -si enable
'
 + CHAR(10) + '	qoperation execscript -sn SetOracleRestoreRestart.sql -si disable
'
 + CHAR(10) + '--   script_name : SetOracleRestoreRestart'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetQueueJobsIfOtherJobsRunning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setQueueJobsIfOtherJobsRunning <<<'

IF EXISTS (select * from sysobjects where name='QS_setQueueJobsIfOtherJobsRunning')
	drop procedure QS_setQueueJobsIfOtherJobsRunning
IF EXISTS (select * from GxQscripts where name='QS_setQueueJobsIfOtherJobsRunning')
	delete from GxQscripts where name = 'QS_setQueueJobsIfOtherJobsRunning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setQueueJobsIfOtherJobsRunning')
	delete from GXDBVersions where aliasname = 'QS_setQueueJobsIfOtherJobsRunning'
GO
print '... Creating Procedure: QS_setQueueJobsIfOtherJobsRunning'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_setQueueJobsIfOtherJobsRunning
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @ACTION varchar(512) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @ACTION     	varchar(512)
--SET @ACTION = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setQueueJobsIfOtherJobsRunning'
DECLARE @NT_ALERTTYPE_SRM_ADVISORY		integer
SET     @NT_ALERTTYPE_SRM_ADVISORY		= 49
DECLARE @NT_SNMP_ALERTNOTIF			    integer
SET     @NT_SNMP_ALERTNOTIF				= 4
--DECLARE @SC_STATUS_BITS        integer
--SET		@SC_STATUS_BITS        =  2+4+16					-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
--DECLARE @appTypeId				integer
--DECLARE @instanceId				integer
--DECLARE @backupSetId			integer
--DECLARE	@subClientId			integer
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @ACTION =  'enable'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @ACTION = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
	goto   ALL_DONE
END
------------------------------------------------
--- CHECK IF A PROPER REQUEST WAS MADE		 ---
------------------------------------------------
IF @ACTION <> 'enable' AND @ACTION <> 'disable'							-- Case Insensitive Check
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter specified incorrectly as ['+@action +'].'
	SET @lastError = 1
	GOTO   ALL_DONE
END
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameter: @ACTION = ['
         + @ACTION
         + ']'
--
IF @ACTION = 'disable'
BEGIN
	delete from GXGlobalParam where name='JobsQueuedIfJobsRunning'
	SET @lastError = @@error
	GOTO ALL_DONE
END
ELSE
BEGIN
	--------------------------------------------------------------------------
	-- ENABLE THE SNMP TRAP NOTIFICATION :									--
	--------------------------------------------------------------------------
	BEGIN TRAN
	delete from GXGlobalParam where name='JobsQueuedIfJobsRunning'
	insert into GXGlobalParam values ('JobsQueuedIfJobsRunning', '1',default,default)
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		GOTO ALL_DONE
	END
	COMMIT TRAN
END
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetQueueJobsIfOtherJobsRunning')
	delete from GxQscripts where name = 'QS_SetQueueJobsIfOtherJobsRunning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetQueueJobsIfOtherJobsRunning')
	delete from GXDBVersions where aliasname = 'QS_SetQueueJobsIfOtherJobsRunning'
GO

insert into GXDBVersions values(2, 'QS_SetQueueJobsIfOtherJobsRunning',  '00000000000000000000', 'QS_SetQueueJobsIfOtherJobsRunning', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetQueueJobsIfOtherJobsRunning',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f setQueueJobIfOtherJobsRunning.sql -i enable | disable
'
 + CHAR(10) + '--   script_name : setQueueJobsIfOtherJobsRunning'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSchedulePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSchedulePolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSchedulePolicy')
	drop procedure QS_SetSchedulePolicy
IF EXISTS (select * from GxQscripts where name='QS_SetSchedulePolicy')
	delete from GxQscripts where name = 'QS_SetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetSchedulePolicy'
GO
print '... Creating Procedure: QS_SetSchedulePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetSchedulePolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @taskName varchar(1024) = '%s',
  @AppIdString varchar(1024) = '%s',
  @OPT varchar(4) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @taskName	varchar(1024)
--SET		@taskName	= '%s'
--DECLARE @AppIdString	varchar(1024)
--SET		@AppIdString	= '%s'
--DECLARE @OPT 		varchar(4)
--SET		@OPT		= '%s'
---------------------------------------
--test
--SET		@taskName	= 'newsp'
--SET		@AppIdString = '5'
--SET		@OPT		= 'ADD'
--SET		@OPT		= 'REM'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetSchedulePolicy'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @optAdd	varchar(32)
SET		@optAdd	= 'ADD'
DECLARE @optRem	varchar(32)
SET		@optRem	= 'REM'
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @taskName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule policy name Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @AppIdString = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient id Expected as parameter 2.'
	GOTO ARGS_ERROR
END
-------------add/rem------------------
IF @OPT = @NoParameter
BEGIN
	SET @OPT = @optAdd
	PRINT 'Subclient with id ['+@AppIdString +'] will be associated with schedule policy ['+@taskName+'].'
END
IF @OPT <> @optAdd AND @OPT <> @optRem
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Unsupported operation ['+@OPT +'].'
	GOTO ARGS_ERROR
END
------------ validate subclient id ----------------
DECLARE @subclientId integer
SET @subclientId = convert(integer, @AppIdString)
IF (SELECT count(*) from APP_application where id = @subclientId) = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id ['+@AppIdString+'] not found.'
	GOTO ARGS_ERROR
END
DECLARE @subclientFlag integer
SET @subclientFlag = (SELECT subclientStatus from APP_Application where id = @subclientId)
IF ((@subclientFlag & 2 = 2) OR  (@subclientFlag & 4 = 4))
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id ['+@AppIdString+'] is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
---------------- Get other ids    -----------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
SELECT @ClientId = clientid, @AppTypeId = apptypeid, @InstanceId = instance, @BackupsetId = backupset
FROM APP_APPLICATION WHERE id = @subclientId
--------------STEP 1 ---------------------
--Get taskId using taskName From TM_Task
DECLARE @taskId integer
SET @taskId = ISNULL((Select taskId from TM_Task where taskName like @taskName ), 0)
IF @taskId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@taskName +'] not found.'
	GOTO ARGS_ERROR
END
--------------STEP 2 ---------------------
-- Type of policy must be backup.
DECLARE @schedType integer
Select @schedType = policyType from TM_Task where taskId = @taskId
IF @schedType <> 0 -- DATA_PROTECTION
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@taskName +'] is not for backups. It cannot be associated using this script.'
	GOTO ARGS_ERROR
END
--------------STEP 3 ---------------------
-- AppType must be compatible
DECLARE @appTypeTable TABLE (appType integer)
DECLARE @isAppTypeSupported int
	SET @isAppTypeSupported  = 0
Insert into @appTypeTable
Select filter_value from TM_AssocFilter where taskId = @taskId and filter_type = 2 -- AppType
Set @lastError = @@ERROR
IF @lastError <> 0
BEGIN
	SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
	GOTO TRANS_EXIT
END
-- Now insert all apptypes that are in this group to this table
Insert into @appTypeTable
Select appTypeId from APP_AppTypeGroupAssoc
where appGroupId in (Select filter_value from TM_AssocFilter where taskId = @taskId and filter_type = 1) -- AppGroup
Set @lastError = @@ERROR
IF @lastError <> 0
BEGIN
	SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
	GOTO TRANS_EXIT
END
Set @isAppTypeSupported = (Select COUNT(*) from @appTypeTable where appType = @apptypeid)
-- If no rows then it means all agents
IF (Select COUNT(*) from @appTypeTable) = 0
	Set @isAppTypeSupported = 1
IF @isAppTypeSupported = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@taskName +'] is not for this type of iDA. It cannot be associated with this subclient.'
	GOTO ARGS_ERROR
END
--------------STEP 4 ---------------------
BEGIN TRAN
-- ADD Option
IF @OPT = @optAdd
BEGIN
	-- Step 4.a --
	-- Check if subclient is already associated via parent node
	DECLARE @clientGroupTable TABLE (clientGroupId integer)
	Insert into @clientGroupTable
	Select clientGroupId  from APP_ClientGroupAssoc
	where clientId = @ClientId
	Set @lastError = @@ERROR
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
		GOTO TRANS_EXIT
	END
	IF ((Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientGroupId IN (Select clientGroupId from @clientGroupTable)
		and clientId = 0 and apptypeId = 0 and instanceId = 0 and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL clients in a clientgroup parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId
		and apptypeId = 0 and instanceId = 0 and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL iDAs in the client parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId and apptypeId = @AppTypeId
		and instanceId = 0 and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL instances in the iDA parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId and apptypeId = @AppTypeId  and instanceId = @InstanceId
		and backupsetId = 0 and subclientId = 0) > 0 OR -- ALL backupsets in the instance parent node.
		(Select COUNT(*) from TM_AssocEntity
		where taskId = @taskId
		and clientId = @ClientId and apptypeId = @AppTypeId and instanceId = @InstanceId and backupsetId = @BackupsetId
		and subclientId = 0) > 0 -- ALL subclients in the backupset parent node.
	    )
    BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Subclient is with this schedule policy through a parent node.'
		GOTO TRANS_EXIT
	END
	IF (Select COUNT(*) from TM_AssocEntity
	where taskId = @taskId and subclientId = @subclientId) > 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Subclient is already associated with this schedule policy.'
		GOTO TRANS_EXIT
	END
	-- Step 4.b --
	-- If not, add the association to the subclient
	DECLARE  @timeStamp int
		SET @timeStamp     = dbo.GetUnixTime (GetUTCdate())
	Insert into TM_AssocEntity	(assocType,			taskId,			flags,		created,		exclude,
								 clientGroupId,		clientId,		apptypeId,	instanceId,		backupsetId,
								 subclientId,		policyId,		copyId,		srmReportSet,	srmReportType,
								 trackingPolicyId,	MediaAgentId,	agentlessPolicyId, workflowId, sidbStoreId,
								 libraryId, logMonitoringPolicyId
								 )
	values						(7,		@taskId,		0,			@timeStamp,		0,
								 0,					@ClientId,		@AppTypeId, @InstanceId,	@BackupsetId,
								 @subclientId,		0,				0,			0,				0,
								 0,					0,				0,			0,				0,
								 0,					0
								 )
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not associate schedule policy.'
		GOTO TRANS_EXIT
	END
END
-- REM Option
ELSE
IF @OPT = @optRem
BEGIN
	Delete from TM_AssocEntity
	where taskId = @taskId
	and subclientId = @subclientId and assocType = 7 -- Subclient association
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg = 'Error. Could not remove association for schedule policy.'
		GOTO TRANS_EXIT
	END
END
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@taskName+', '+@AppIdString+', '+@OPT+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSchedulePolicy')
	delete from GxQscripts where name = 'QS_SetSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSchedulePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetSchedulePolicy'
GO

insert into GXDBVersions values(2, 'QS_SetSchedulePolicy',  '00000000000000000000', 'QS_SetSchedulePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSchedulePolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSchedulePolicy.sql -si schedulepolicy_name -si subclient_ID [-si ADD/REM]
'
 + CHAR(10) + '--   script_name : SetSchedulePolicy'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSPDBSubclientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSPDBSubclientContent <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSPDBSubclientContent')
	drop procedure QS_SetSPDBSubclientContent
IF EXISTS (select * from GxQscripts where name='QS_SetSPDBSubclientContent')
	delete from GxQscripts where name = 'QS_SetSPDBSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSPDBSubclientContent')
	delete from GXDBVersions where aliasname = 'QS_SetSPDBSubclientContent'
GO
print '... Creating Procedure: QS_SetSPDBSubclientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSPDBSubclientContent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName nvarchar(1030) = '%s',
  @subClientName nvarchar(1030) = '%s',
  @fileName nvarchar(1030) = '%s'
AS
SET QUOTED_IDENTIFIER ON
set nocount on
---------------command line inputs-------
--DECLARE @clientName  NVARCHAR(1030)
--SET @clientName = '%s'
--DECLARE @subclientName  NVARCHAR(1030)
--SET @subclientName = '%s'
--DECLARE @fileName  NVARCHAR(1030)
--SET @fileName = '%s'
-------------------Test-------------------------------
--SET @clientName = 'scowss01.directory.ssdnintra.net'
--SET @subclientName = 'gokul_check6'
--SET @fileName  = 'C:\Content2.txt'
--------------------------------------------------------
-----------insufficient parameters ---------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
---------------constants--------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetSPDBSubclientContent'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @delim		varchar(1)
SET		@delim = '|'
DECLARE @dataType varchar(64)
SET @dataType =  'Site Collection'
DECLARE @attrVal varchar(64)
SET @attrVal = 'Site+1Collection 1 nothing nothing'
DECLARE @placeHolder	varchar(64)
SET @placeHolder = 'Place Holder'
--------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
----------------Variables--------------------
DECLARE @clientId	INT
DECLARE @instanceId INT
DECLARE @backupSetId	INT
DECLARE @defSubclientId INT
DECLARE @subclientId	INT
CREATE TABLE #tempfile (line varchar(1024))
---------------------------------------------
IF @clientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No client name was given.'
	GOTO ARGS_ERROR
END
IF @subclientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No subclient name  was given.'
	GOTO ARGS_ERROR
END
IF @fileName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No content file name was given.'
	GOTO ARGS_ERROR
END
-- Check if file exists ---
EXEC ('bulk INSERT #tempfile FROM "' + @fileName + '"')
IF @@ERROR	<> 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Unable to open content file.'
	GOTO ARGS_ERROR
END
---------------------------------------------------
-- Get ClientID first
SELECT @clientId = ISNULL( id  , 0)
FROM APP_Client
WHERE name = @clientName
IF @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid client specified.'
	GOTO ARGS_ERROR
END
-- Get Instance ID and BackupSet ID from default subclient
SELECT @instanceId = instance , @backupSetId = backupSet, @defSubclientId = id
FROM APP_Application
WHERE clientId = @clientId AND appTypeId = 69 AND subclientStatus&0x8 = 0x8-- SharePoint DB default subclient
IF @instanceId = 0 OR @backupSetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Unable to get default instance and backupSet for the client.'
	GOTO ARGS_ERROR
END
-- Check if already a subclient is there
IF (SELECT COUNT(*) FROM APP_Application WHERE clientId = @clientId AND appTypeId = 69 AND backupSet = @backupSetId AND subclientName = @subClientName AND subclientStatus&0x4 <> 4) <> 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Another subclient with the same name exists.'
	GOTO ARGS_ERROR
END
BEGIN TRAN
-- Create the new Subclient
INSERT INTO APP_Application (clientId,		appTypeId,		instance,
							 backupSet,		appNumber,		dataArchGrpID,
							 logArchGrpID,	refTime,		modified,
							 subclientName,	subclientStatus)
VALUES						(@clientId,		69,				@instanceId,
							 @backupSetId,  0,				1,
							 1,				@nowTime,		0,
							 @subclientName,0)
SET @errorCode = @@ERROR
SET @subclientId = @@IDENTITY
IF @errorCode <> 0 OR @subclientId = 0
BEGIN
	SET @errorString = 'Error. Could not create subclient.'
	GOTO TRANS_EXIT
END
----------------------------------------------------------------------------------------
-- Now parse through the #tempFileTable and insert records into Subclient Content table
----------------------------------------------------------------------------------------
DECLARE @currentSite varchar(1024)
DECLARE @desc		 varchar(40)
DECLARE @virtualServer varchar(1024)
DECLARE @currentFileName varchar(1024)
DECLARE @position INT
DECLARE GetSubclientContent CURSOR
FOR SELECT ISNULL(line,'') FROM #tempfile
OPEN GetSubclientContent
FETCH GetSubclientContent INTO @currentSite
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @currentSite = '' OR @currentSite = NULL
	BEGIN
		PRINT 'Skipping empty Site Content...'
		FETCH GetSubclientContent INTO @currentSite
		CONTINUE
	END
	SET @position = 0
	SET @virtualServer = ''
	SET @position = CHARINDEX('/', @currentSite, 0)
	WHILE SUBSTRING(@currentSite, @position + 1, 1) = '/'
	BEGIN
		SET @position = CHARINDEX('/', @currentSite, @position + 2)
	END
	IF @position = LEN(@currentSite) OR @position = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	SET @virtualServer = ISNULL(SUBSTRING(@currentSite, 0, @position + 1), '')
	IF @virtualServer = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	SET @position = 0
	SET @desc = ''
	SET @position = CHARINDEX('|', @currentSite, 0)
	IF @position = LEN(@currentSite) OR @position = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	SET @desc = ISNULL(SUBSTRING(@currentSite, @position +1, 1024), '')
	SET @currentSite = ISNULL(SUBSTRING(@currentSite, 0,  @position), '')
	IF @desc = '' OR @currentSite = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	-- Form the File Name as required
	SET @currentFileName = @dataType + '\' + @virtualServer + @delim + @currentSite + @delim + @desc + @delim + ' ' + @delim + ' \' + @placeHolder
	INSERT INTO APP_ScFilterFile(componentNameId,	type,		fileName,
								  created,			modified)
	VALUES						(@subclientId,		1,			@currentFileName,
								 @nowTime,			0)
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	-- Form the File Name as required
	SET @currentFileName = @virtualServer + @delim + @currentSite + @delim + @desc + @delim + ' ' + @delim + ' \' + @placeHolder
	-- Remove from Default
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE componentNameId = @defSubclientId AND attrType = 115 AND attrName = @currentFileName
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	-- Check if already exists
	IF	(SELECT COUNT(*) FROM APP_SubClientProp
		 WHERE attrName = @currentFileName AND modified = 0 AND componentNameId IN (SELECT id FROM APP_Application
																				    WHERE backupSet = @backupSetId AND subclientStatus & 0x4 = 0)) <> 0
	BEGIN
		PRINT 'Skipping Site Content as it is part of another subclient.'
		FETCH GetSubclientContent INTO @currentSite
		CONTINUE
	END
	INSERT INTO APP_SubClientProp	(componentNameId,	attrName,			attrType,
									 attrVal,			created,			modified )
	VALUES							(@subclientId,		@currentFileName,	115,
									 @attrVal,			@nowTime,			0)
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorString = 'Error. Could not add site ['+@currentSite +'].'
		GOTO TRANS_EXIT
	END
	PRINT 'Added Content ['+@currentSite+'].'
	FETCH GetSubclientContent INTO @currentSite
END
---------------------------------------------------
TRANS_EXIT:
CLOSE GetSubclientContent
DEALLOCATE GetSubclientContent
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
	--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ARGS_ERROR:
 DROP TABLE #tempfile
 print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSPDBSubclientContent')
	delete from GxQscripts where name = 'QS_SetSPDBSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSPDBSubclientContent')
	delete from GXDBVersions where aliasname = 'QS_SetSPDBSubclientContent'
GO

insert into GXDBVersions values(2, 'QS_SetSPDBSubclientContent',  '00000000000000000000', 'QS_SetSPDBSubclientContent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSPDBSubclientContent',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSPDBSubclientContent.sql -si client_name -si subclient_name -si content_file_name
'
 + CHAR(10) + '--   script_name : SetSPDBSubclientContent'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetStoragePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetStoragePolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_SetStoragePolicy')
	drop procedure QS_SetStoragePolicy
IF EXISTS (select * from GxQscripts where name='QS_SetStoragePolicy')
	delete from GxQscripts where name = 'QS_SetStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetStoragePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetStoragePolicy'
GO
print '... Creating Procedure: QS_SetStoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetStoragePolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SpName varchar(1024) = '%s',
  @OPT varchar(1024) = '%s',
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @SpName	varchar(1024)
--SET		@SpName	= '%s'
--DECLARE @OPT	varchar(1024)
--SET		@OPT	= '%s'
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--test
--SET		@SpName	= 'maglib(navia)_(1)'
--SET		@OPT	= 'all'
--SET		@PARAM1 = 'c=linuxsan5'
--SET		@PARAM2	= 'a=Q_unix_DB2'
--SET		@PARAM3 = 'i=db2inst1'
--SET		@PARAM4 = 'b=SAMPLE'
--SET		@PARAM5 = 's=default'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetStoragePolicy'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @logOption		varchar(10)
SET		@logOption		='log'
DECLARE @dataOption		varchar(10)
SET		@dataOption		='data'
DECLARE @allOption		varchar(10)
SET		@allOption		='all'
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------Validata storage policy name  -----------
IF @SpName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. No input was given. Please refer to readme_'+@scriptName+'.txt for usage.'
	GOTO ARGS_ERROR
END
DECLARE @spId integer
SET @spId = ISNULL((Select id from ArchGroup where name like @SpName), 0)
IF @spId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Storage Policy by name [' +@SpName +'] not found.'
	GOTO ARGS_ERROR
END
-------------------data or log?------------------
DECLARE @option integer
SET @option  = (case @OPT WHEN @dataOption THEN 1
WHEN @logOption THEN 2
WHEN @allOption THEN 3
ELSE 0  ---- option is mandatory for this script.
END)
IF @option = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Parameter 2 must be log/data/all. '
	GOTO ARGS_ERROR
END
------------ Get ids    -----------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
IF  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
	@localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
DECLARE @cmdLineSC integer
SET @cmdLineSC = ((SELECT subclientStatus from APP_application Where id = @subclientId) & 64 )
----------------collect old ids for validation ------------------------------
DECLARE @dataArchGrpId integer
DECLARE @logArchGrpId integer
SELECT @logArchGrpId = logArchGrpId, @dataArchGrpId =dataArchGrpId
FROM App_application
where id = @subclientId
declare @SetAtSubclient integer
declare @SetAtBackupset integer
IF (@option & 2 = 2 )
BEGIN
	SET @SetAtSubclient = 0
	SET @SetAtBackupset = 0
	-- db apptypes: oracle, oracle rac, sql, db2, sybase, informix, mysql
	IF @apptypeId not in (2, 22, 23,   80, 81,  37, 62,   5,   3,   104)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Cannot set log storage policy for subclient. Unsupported iDA.'
		GOTO ARGS_ERROR
	END
	-- sql - log Sp is exposed at subclient.
	IF (@apptypeId in (81))
		SET @SetAtSubclient = 1
	-- db2 at backupset level
	IF (@apptypeId in (37, 62))
		SET @SetAtBackupset = 1
	-- all command line subclients shouldn't affect instance properties DEFECT 27481
	IF @cmdLineSC > 0
		SET @SetAtSubclient = 1
END
------------Job running?-------------------------
IF (select count(*) from JMBkpJobInfo where applicationId = @subclientId) >0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Cannot change Storage policy. Job running for this subclient.'
	GOTO ARGS_ERROR
END
------------ Set storage policy   -----------
BEGIN TRAN
--1) DATA SP
	IF @option & 1 = 1 AND @dataArchGrpId != @spId
	BEGIN
		--if data sp is set for non DB apptypes reset both log and data sp to the same value.
		--otherwise subclient will be duplicated in storagepolixy properties -> associated subclients of both subclients
		IF (@option & 2 <> 2 )and @apptypeId not in (2, 22, 23,   80, 81,  37, 62,   5,   3,   104)
			Update App_application set dataArchGrpId = @spId, logArchGrpId = @spId where id = @subclientId
		ELSE
			Update App_application set dataArchGrpId = @spId where id = @subclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not change storage policy.'
			GOTO TRANS_EXIT
		END
		----------------reset backup times if  sp changed -------------------------
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'last data SP' and componentnameid = @SubclientId
		Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
		Values (@SubclientId, 'last data SP', @dataArchGrpId, 7, @nowTime, 0)
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'sys:last full' and componentnameid = @SubclientId
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'sys:last incr' and componentnameid = @SubclientId
		IF  ( SELECT attrval FROM App_subclientprop
		where attrname like 'Reason last backup time cleared'
		 and componentnameid = @SubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
		BEGIN
			UPDATE App_subclientprop SET modified = @nowTime
			where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
			Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
			Values (@SubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
			--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
		END
		-- Reset backupset modified time
		UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
	END
--2) LOG SP
	IF @option & 2 = 2 AND @logArchGrpId != @spId
	BEGIN
		--LOG SP EXPOSED AT SUBCLIENT LEVEL
		IF	 @SetAtSubclient = 1 --SQL
		BEGIN
			Update App_application set logArchGrpId = @spId where id = @subclientId
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg = 'Error. Could not change log storage policy.'
				GOTO TRANS_EXIT
			END
			----------------reset backup times if  sp changed -------------------------
			UPDATE App_subclientprop SET modified = @nowTime
			where attrname like 'last log SP' and componentnameid = @SubclientId
			Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
			Values (@SubclientId, 'last log SP', @dataArchGrpId, 7, @nowTime, 0)
			IF  ( SELECT attrval FROM App_subclientprop
			where attrname like 'Reason last backup time cleared'
			 and componentnameid = @SubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
			BEGIN
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@SubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
				--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
			END
			-- Reset backupset modified time
			UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
		END
		ELSE IF @SetAtBackupset = 1--LOG SP EXPOSED AT BACKUPSET LEVEL
		BEGIN
			declare @nextSubclientId integer
			DECLARE BSetCursor CURSOR STATIC FOR
			SELECT id FROM App_application WHERE backupset = @BackupsetId
			OPEN BSetCursor
			FETCH NEXT FROM BSetCursor INTO @nextSubclientId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				Update App_application set logArchGrpId = @spId where id = @nextSubclientId
				SET @lastError = @@error
				IF @lastError <> 0
				BEGIN
					SET @localErrorMsg = 'Error. Could not change storage policy.'
					GOTO TRANS_EXIT
				END
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'last log SP' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'last log SP', @logArchGrpId, 7, @nowTime, 0)
				IF  ( SELECT attrval FROM App_subclientprop
				where attrname like 'Reason last backup time cleared'
				 and componentnameid = @nextSubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
				BEGIN
					UPDATE App_subclientprop SET modified = @nowTime
					where attrname like 'Reason last backup time cleared' and componentnameid = @nextSubclientId
					Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
					Values (@nextSubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
					--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
				END
				UPDATE App_backupsetprop SET modified = @nowTime
				where attrname like 'DB2 Default Index SP' and componentnameid = @BackupsetId
				Insert into App_backupsetprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@BackupsetId, 'DB2 Default Index SP', @logArchGrpId, 7, @nowTime, 0)
				-- Reset backupset modified time
				UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
				FETCH NEXT FROM BSetCursor INTO @nextSubclientId
			END	--Cursor
			close BSetCursor
			deallocate BSetCursor
		END
		ELSE--LOG SP EXPOSED AT INSTANCE LEVEL
		BEGIN
			declare @nextBackupsettId integer
			DECLARE InstanceCursor CURSOR STATIC FOR
			SELECT id, backupset FROM App_application WHERE instance = @InstanceId
			OPEN InstanceCursor
			FETCH NEXT FROM InstanceCursor INTO @nextSubclientId, @nextBackupsettId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				Update App_application set logArchGrpId = @spId where id = @nextSubclientId
				SET @lastError = @@error
				IF @lastError <> 0
				BEGIN
					SET @localErrorMsg = 'Error. Could not change storage policy.'
					GOTO TRANS_EXIT
				END
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'last log SP' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'last log SP', @logArchGrpId, 7, @nowTime, 0)
				IF  ( SELECT attrval FROM App_subclientprop
				where attrname like 'Reason last backup time cleared'
				 and componentnameid = @nextSubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
				BEGIN
					UPDATE App_subclientprop SET modified = @nowTime
					where attrname like 'Reason last backup time cleared' and componentnameid = @nextSubclientId
					Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
					Values (@nextSubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
					--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
				END
				-- Reset backupset modified time
				UPDATE APP_backupsetName set modified = @nowTime where id = @nextBackupsettId
				FETCH NEXT FROM InstanceCursor INTO @nextSubclientId, @nextBackupsettId
			END	--InstanceCursor
			close InstanceCursor
			deallocate InstanceCursor
		END -- ELSE LOG SP EXPOSED AT INSTANCE LEVEL
	END -- @option & 2 = 2 AND @logArchGrpId != @spId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@SpName+', '+@OPT+', '+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+', '+@PARAM5+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetStoragePolicy')
	delete from GxQscripts where name = 'QS_SetStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetStoragePolicy')
	delete from GXDBVersions where aliasname = 'QS_SetStoragePolicy'
GO

insert into GXDBVersions values(2, 'QS_SetStoragePolicy',  '00000000000000000000', 'QS_SetStoragePolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetStoragePolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetStoragePolicy.sql -si storage_policy_name -si data/log/all -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : SetStoragePolicy'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetStoragePolicyByID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetStoragePolicyById <<<'

IF EXISTS (select * from sysobjects where name='QS_SetStoragePolicyById')
	drop procedure QS_SetStoragePolicyById
IF EXISTS (select * from GxQscripts where name='QS_SetStoragePolicyById')
	delete from GxQscripts where name = 'QS_SetStoragePolicyById'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetStoragePolicyById')
	delete from GXDBVersions where aliasname = 'QS_SetStoragePolicyById'
GO
print '... Creating Procedure: QS_SetStoragePolicyById'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetStoragePolicyById
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SpName varchar(1024) = '%s',
  @AppIdString varchar(1024) = '%s',
  @OPT varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @SpName	varchar(1024)
--SET		@SpName	= '%s'
--DECLARE @AppIdString	varchar(1024)
--SET		@AppIdString = '%s'
--DECLARE @OPT	varchar(1024)
--SET		@OPT	= '%s'
---------------------------------------
--test
--SET		@SpName	= 'maglib(navia)_(1)'
--SET		@AppIdString = '72'
--SET		@OPT	= 'data'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetStoragePolicyById'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @logOption		varchar(10)
SET		@logOption		='log'
DECLARE @dataOption		varchar(10)
SET		@dataOption		='data'
DECLARE @allOption		varchar(10)
SET		@allOption		='all'
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------Validata storage policy name  -----------
IF @SpName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. No input was given. Please give storage policy name and subclientId'
	GOTO ARGS_ERROR
END
DECLARE @spId integer
SET @spId = ISNULL((Select id from ArchGroup where name like @SpName), 0)
IF @spId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Storage Policy by name [' +@SpName +'] not found.'
	GOTO ARGS_ERROR
END
------------Validate subclientId  -----------
IF @AppIdString = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. SubclientId was not given.'
	GOTO ARGS_ERROR
END
DECLARE @subclientId integer
SET @subclientId = convert(integer, @AppIdString)
IF (SELECT count(*) from APP_application where id = @subclientId) = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id [' +@AppIdString +'] not found.'
	GOTO ARGS_ERROR
END
DECLARE @subclientFlag integer
SET @subclientFlag = (SELECT subclientStatus from APP_Application where id = @subclientId)
IF ((@subclientFlag & 2 = 2) OR  (@subclientFlag & 4 = 4))
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id [' +@AppIdString +'] is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
-------------------data or log?------------------
DECLARE @option integer
SET @option  = (case @OPT WHEN @dataOption THEN 1
WHEN @logOption THEN 2
WHEN @allOption THEN 3
ELSE 3 -- both by default
END)
IF @option = 3
	SET @OPT = 'all' --for completed message at the end of script only
----------------collect old ids for validation ------------------------------
DECLARE @dataArchGrpId integer
DECLARE @logArchGrpId integer
DECLARE @apptypeId integer
DECLARE @instance integer
DECLARE @backupsetId integer
DECLARE @cmdLineSC integer
SELECT @logArchGrpId = logArchGrpId, @dataArchGrpId =dataArchGrpId, @backupsetId = backupset, @instance = instance, @apptypeId = apptypeid, @cmdLineSC = subclientStatus
FROM App_application
where id = @subclientId
SET @cmdLineSC = (@cmdLineSC & 64 )
declare @SetAtSubclient integer
declare @SetAtBackupset integer
IF (@option & 2 = 2 )
BEGIN
	SET @SetAtSubclient = 0
	SET @SetAtBackupset = 0
	-- db apptypes: oracle, oracle rac, sql, db2, sybase, informix, mysql
	IF @apptypeId not in (2, 22, 23,   80, 81,  37, 62,   5,   3,   104)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Cannot set log storage policy for subclient. Unsupported iDA.'
		GOTO ARGS_ERROR
	END
	-- sql - log Sp is exposed at subclient.
	IF (@apptypeId in (81))
		SET @SetAtSubclient = 1
	-- db2 at backupset level
	IF (@apptypeId in (37, 62))
		SET @SetAtBackupset = 1
	-- all command line subclients shouldn't affect instance properties DEFECT 27481
	IF @cmdLineSC > 0
		SET @SetAtSubclient = 1
END
------------Job running?-------------------------
IF (select count(*) from JMBkpJobInfo where applicationId = @subclientId) >0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Cannot change Storage policy. Job running for this subclient.'
	GOTO ARGS_ERROR
END
------------ Set storage policy   -----------
BEGIN TRAN
--1) DATA SP
	IF @option & 1 = 1 AND @dataArchGrpId != @spId
	BEGIN
		--if data sp is set for non DB apptypes reset both log and data sp to the same value.
		--otherwise subclient will be duplicated in storagepolixy properties -> associated subclients of both subclients
		IF (@option & 2 <> 2 )and @apptypeId not in (2, 22, 23,   80, 81,  37, 62,   5,   3,   104)
			Update App_application set dataArchGrpId = @spId, logArchGrpId = @spId where id = @subclientId
		ELSE
			Update App_application set dataArchGrpId = @spId where id = @subclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not change storage policy.'
			GOTO TRANS_EXIT
		END
		----------------reset backup times if  sp changed -------------------------
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'last data SP' and componentnameid = @SubclientId
		Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
		Values (@SubclientId, 'last data SP', @dataArchGrpId, 7, @nowTime, 0)
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'sys:last full' and componentnameid = @SubclientId
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'sys:last incr' and componentnameid = @SubclientId
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
		Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
		Values (@SubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
		--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
		-- Reset backupset modified time
		UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
	END
--2) LOG SP
	IF @option & 2 = 2 AND @logArchGrpId != @spId
	BEGIN
		--LOG SP EXPOSED AT SUBCLIENT LEVEL
		IF	 @SetAtSubclient = 1 --SQL
		BEGIN
			Update App_application set logArchGrpId = @spId where id = @subclientId
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg = 'Error. Could not change log storage policy.'
				GOTO TRANS_EXIT
			END
			----------------reset backup times if  sp changed -------------------------
			UPDATE App_subclientprop SET modified = @nowTime
			where attrname like 'last log SP' and componentnameid = @SubclientId
			Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
			Values (@SubclientId, 'last log SP', @dataArchGrpId, 7, @nowTime, 0)
			UPDATE App_subclientprop SET modified = @nowTime
			where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
			Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
			Values (@SubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
			--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
			-- Reset backupset modified time
			UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
		END
		ELSE IF @SetAtBackupset = 1--LOG SP EXPOSED AT BACKUPSET LEVEL
		BEGIN
			declare @nextSubclientId integer
			DECLARE BSetCursor CURSOR STATIC FOR
			SELECT id FROM App_application WHERE backupset = @BackupsetId
			OPEN BSetCursor
			FETCH NEXT FROM BSetCursor INTO @nextSubclientId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				Update App_application set logArchGrpId = @spId where id = @nextSubclientId
				SET @lastError = @@error
				IF @lastError <> 0
				BEGIN
					SET @localErrorMsg = 'Error. Could not change storage policy.'
					GOTO TRANS_EXIT
				END
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'last log SP' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'last log SP', @logArchGrpId, 7, @nowTime, 0)
				IF  ( SELECT attrval FROM App_subclientprop
				where attrname like 'Reason last backup time cleared'
				 and componentnameid = @nextSubclientId and modified = 0) <> 1 --CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED
				BEGIN
					UPDATE App_subclientprop SET modified = @nowTime
					where attrname like 'Reason last backup time cleared' and componentnameid = @nextSubclientId
					Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
					Values (@nextSubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
					--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
				END
				UPDATE App_backupsetprop SET modified = @nowTime
				where attrname like 'DB2 Default Index SP' and componentnameid = @BackupsetId
				Insert into App_backupsetprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@BackupsetId, 'DB2 Default Index SP', @logArchGrpId, 7, @nowTime, 0)
				-- Reset backupset modified time
				UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
				FETCH NEXT FROM BSetCursor INTO @nextSubclientId
			END	--Cursor
			close BSetCursor
			deallocate BSetCursor
		END
		ELSE--LOG SP EXPOSED AT INSTANCE LEVEL
		BEGIN
			declare @nextBackupsettId integer
			DECLARE InstanceCursor CURSOR STATIC FOR
			SELECT id, backupset FROM App_application WHERE instance = @Instance
			OPEN InstanceCursor
			FETCH NEXT FROM InstanceCursor INTO @nextSubclientId, @nextBackupsettId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				Update App_application set logArchGrpId = @spId where id = @nextSubclientId
				SET @lastError = @@error
				IF @lastError <> 0
				BEGIN
					SET @localErrorMsg = 'Error. Could not change storage policy.'
					GOTO TRANS_EXIT
				END
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'last log SP' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'last log SP', @logArchGrpId, 7, @nowTime, 0)
				UPDATE App_subclientprop SET modified = @nowTime
				where attrname like 'Reason last backup time cleared' and componentnameid = @nextSubclientId
				Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
				Values (@nextSubclientId, 'Reason last backup time cleared', 1, 7, @nowTime, 0)
				--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7
				-- Reset backupset modified time
				UPDATE APP_backupsetName set modified = @nowTime where id = @nextBackupsettId
				FETCH NEXT FROM InstanceCursor INTO @nextSubclientId, @nextBackupsettId
			END	--InstanceCursor
			close InstanceCursor
			deallocate InstanceCursor
		END -- ELSE LOG SP EXPOSED AT INSTANCE LEVEL
	END -- @option & 2 = 2 AND @logArchGrpId != @spId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@SpName+', '+@AppIdString+', '+@OPT
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetStoragePolicyByID')
	delete from GxQscripts where name = 'QS_SetStoragePolicyByID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetStoragePolicyByID')
	delete from GXDBVersions where aliasname = 'QS_SetStoragePolicyByID'
GO

insert into GXDBVersions values(2, 'QS_SetStoragePolicyByID',  '00000000000000000000', 'QS_SetStoragePolicyByID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetStoragePolicyByID',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetStoragePolicyById.sql -si storage_policy_name -si subclient_ID -si data/log/all 
'
 + CHAR(10) + '--   script_name : SetStoragePolicyById'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetSubclientPrePostProcess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetSubClientPrePostProcess <<<'

IF EXISTS (select * from sysobjects where name='QS_SetSubClientPrePostProcess')
	drop procedure QS_SetSubClientPrePostProcess
IF EXISTS (select * from GxQscripts where name='QS_SetSubClientPrePostProcess')
	delete from GxQscripts where name = 'QS_SetSubClientPrePostProcess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubClientPrePostProcess')
	delete from GXDBVersions where aliasname = 'QS_SetSubClientPrePostProcess'
GO
print '... Creating Procedure: QS_SetSubClientPrePostProcess'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetSubClientPrePostProcess
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @SubclientId nvarchar(10) = '%s',
  @AllScripts nvarchar(3999)  = '%s',
  @isLocalAccount nvarchar(10) = '%s',
  @UserName nvarchar(50) = '%s',
  @EncryptedPasswrd nvarchar(512) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs-------
--DECLARE @SubClientId NVARCHAR(10)
--SET @SubClientId = '%s'
--DECLARE @AllScripts NVARCHAR(3999)
--SET @AllScripts  = '%s'
--DECLARE @isLocalAccount NVARCHAR(10)
--SET @isLocalAccount = '%s'
--DECLARE @UserName NVARCHAR(50)
--SET @UserName = '%s'
--DECLARE @EncryptedPasswrd NVARCHAR(512)
--SET @EncryptedPasswrd = '%s'
------------------command line input format------------
-- 4 PreScan=E:\Batch\PreScan.bat,PostScan=E:\Batch\PostScan.bat,PreBackup=E:\Batch\PreBackup.bat,PostBackup=E:\Batch\PostBackup.bat YES/NO username encrytedPassword
------------------input prefixes----------------------
DECLARE @PrelfindPrefix NVARCHAR(50)
SET @PrelfindPrefix = 'PreScan='
DECLARE @PostlfindPrefix NVARCHAR(50)
SET @PostlfindPrefix = 'PostScan='
DECLARE @PreBackupPrefix NVARCHAR(50)
SET @PreBackupPrefix = 'PreBackup='
DECLARE @PostBackupPrefix NVARCHAR(50)
SET @PostBackupPrefix = 'PostBackup='
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'SetSubClientPrePostProcess'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @cPrelfindPrefix NVARCHAR(50)
SET @cPrelfindPrefix = 'sys:pre PreIfind'
DECLARE @cPostlfindPrefix NVARCHAR(50)
SET @cPostlfindPrefix = 'sys:post PostIfind'
DECLARE @cPreBackupPrefix NVARCHAR(50)
SET @cPreBackupPrefix = 'sys:pre PreBackup'
DECLARE @cPostBackupPrefix NVARCHAR(50)
SET @cPostBackupPrefix = 'sys:post PostBackup'
DECLARE @cUsePrePostUser  NVARCHAR(50)
SET @cUsePrePostUser = 'use prepost username'
DECLARE @cPrePostUser  NVARCHAR(50)
SET @cPrePostUser = 'prepost username'
DECLARE @cPrePostPassword  NVARCHAR(50)
SET @cPrePostPassword = 'prepost password'
DECLARE @end NVARCHAR(2)
SET @end = ','
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
BEGIN TRAN
IF @SubClientId = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No SubClient Id was given.'
	GOTO ARGS_ERROR
END
BEGIN TRY
IF NOT EXISTS(select *from APP_Application where id = @SubClientId)
BEGIN
	SET @errorString = 'Error.  Invalid SubClient Id.'
	Set @errorCode = 1
	goto	ARGS_ERROR
END
DECLARE @AttrName NVARCHAR(50)
SET @AttrName = ''
DECLARE @AttrType int
SET @AttrType = 1
DECLARE @AttrVal NVARCHAR(256)
SET @AttrVal = ''
IF(@AllScripts  = @noParameter)
BEGIN
	SET @errorString = 'Error. Pre Scan and Post Backup Path not given.'
	Set @errorCode = 1
	goto	ARGS_ERROR
END
IF @isLocalAccount <> @noParameter
BEGIN
	SET @isLocalAccount = UPPER(RTRIM(LTRIM(@isLocalAccount)))
END
IF ((@isLocalAccount = 'NO') AND (@UserName = @noParameter OR @EncryptedPasswrd = @noParameter))
BEGIN
	SET @errorString = 'Error. User name or Password not given'
	Set @errorCode = 1
	goto	ARGS_ERROR
END
DECLARE @Iterator int
SET @Iterator = 0
DECLARE @WatchFlag int
SET @WatchFlag = 0
DECLARE @startIndex int
DECLARE @endIndex int
DECLARE @Path NVARCHAR(2000)
DECLARE @PathLen int
DECLARE @Prefix NVARCHAR(50)
DECLARE @cPrefix NVARCHAR(50)
While @Iterator < 4
BEGIN
	IF @Iterator = 0
	BEGIN
		SET @Prefix  = @PrelfindPrefix
		SET @cPrefix = @cPrelfindPrefix
	END
	ELSE IF @Iterator = 1
	BEGIN
		SET @Prefix  = @PostlfindPrefix
		SET @cPrefix = @cPostlfindPrefix
	END
	ELSE IF @Iterator = 2
	BEGIN
		SET @Prefix  = @PreBackupPrefix
		SET @cPrefix = @cPreBackupPrefix
	END
	ELSE IF @Iterator = 3
	BEGIN
		SET @Prefix  = @PostBackupPrefix
		SET @cPrefix = @cPostBackupPrefix
	END
	SET @startIndex = 0
	SET @endIndex = 0
	SET @PathLen = 0
	SET @Path = ''
	SET @startIndex = CHARINDEX(@Prefix,@AllScripts ,0)
	IF @startIndex <> 0
	BEGIN
		SET @endIndex = CHARINDEX(@end,@AllScripts ,@startIndex)
		IF @endIndex = 0
		BEGIN
			SET @endIndex = LEN(@AllScripts)+1
		END
		SET @startIndex = @startIndex + LEN(@Prefix)
		SET @PathLen = @endIndex - @startIndex
		BEGIN TRY
			SET @Path = LTRIM(RTRIM(SUBSTRING(@AllScripts ,@startIndex,@PathLen)))
		END TRY
		BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

			SET @Path = ''
			SET @startIndex = 0
		END CATCH
	END
	IF @startIndex <> 0 and @Path <> ''
	BEGIN
		SET @WatchFlag = 1
		SET @AttrName = @cPrefix
		IF EXISTS(select * from APP_SubClientProp where attrType = @AttrType and componentNameId = @SubClientId and attrName = @AttrName)
			BEGIN
				update APP_SubClientProp set modified = @nowTime where attrType = @AttrType and componentNameId = @SubClientId and attrName = @AttrName and modified = 0
				insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@Path,@nowTime,0)
			END
		ELSE
			BEGIN
				insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@Path,@nowTime,0)
		END
		SET @errorCode = @@ERROR
		IF @errorCode = 0
		BEGIN
			PRINT @scriptName + ' Parameters '+ @Prefix +@Path + ' update success.'
		END
		ELSE
		BEGIN
			SET @errorString = ' Parameters '+ @Prefix +@Path + ' update failed.'
			goto	ARGS_ERROR
		END
	END
	SET @Iterator = @Iterator + 1
END
IF  @WatchFlag = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = ' Parameter [AllScripts: '+ @AllScripts + '] wrong syntax given.'
		goto	ARGS_ERROR
	END
IF (NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = @SubClientId AND attrType = 7 AND attrName = @cUsePrePostUser AND modified = 0) )AND @isLocalAccount = @noParameter
BEGIN
	SET @isLocalAccount = 'YES'
END
SET @Iterator = (SELECT CASE (@isLocalAccount) WHEN('NO') THEN 0 ELSE (CASE (@isLocalAccount) WHEN('YES') THEN 1  ELSE 4 END) END)
WHILE @Iterator < 3
BEGIN
	IF @Iterator = 0
	BEGIN
		SET @attrType = 1
		SET @AttrName =  @cPrePostUser
		SET @AttrVal =  @UserName
	END
	IF @Iterator = 1
	BEGIN
		SET @attrType = 1
		SET @AttrName =  @cPrePostPassword
		SET @AttrVal = 	(SELECT CASE (@isLocalAccount) WHEN('YES') THEN CAST(2 AS VARCHAR) ELSE @EncryptedPasswrd END)
	END
	IF @Iterator = 2
	BEGIN
		SET @attrType = 7
		SET @AttrName =  @cUsePrePostUser
		SET @AttrVal = 	(SELECT CASE (@isLocalAccount) WHEN('YES') THEN CAST(1 AS VARCHAR) ELSE CAST(2 AS VARCHAR)  END)
	END
	--SET @CCPId = (select ccpId from APP_Application where id = @SubClientId)
	IF NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = @SubClientId AND attrType = @attrType AND attrName = @AttrName AND modified = 0)
		BEGIN
			insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@AttrVal,@nowTime,0)
		END
	ELSE
		BEGIN
			update APP_SubClientProp set modified = @nowTime where attrType = @AttrType and componentNameId = @SubClientId and attrName = @AttrName and modified = 0
			insert into APP_SubClientProp (componentNameId,attrType,attrName,attrVal,created,modified) values (@SubClientId,@AttrType,@AttrName,@AttrVal,@nowTime,0)
		END
	SET @errorCode = @@ERROR
	IF @errorCode<> 0
	BEGIN
		SET @errorString = 'Insertion/Updation of User Name Info failed'
		goto ARGS_ERROR
	END
	SET @Iterator = @Iterator + 1
END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @errorCode = @@ERROR
	SET @errorString = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
IF @Iterator = 4
BEGIN
	print 'Info: no Accout Type Information given isLocalAccount(YES/NO)'
END
print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+ ' with Parameters:[ Subclient Id='
										+@SubClientId+' AllScripts=' + @AllScripts+'].'
ARGS_ERROR:
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetSubclientPrePostProcess')
	delete from GxQscripts where name = 'QS_SetSubclientPrePostProcess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetSubclientPrePostProcess')
	delete from GXDBVersions where aliasname = 'QS_SetSubclientPrePostProcess'
GO

insert into GXDBVersions values(2, 'QS_SetSubclientPrePostProcess',  '00000000000000000000', 'QS_SetSubclientPrePostProcess', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetSubclientPrePostProcess',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetSubClientPrePostProcess.sql -si subclientid -si ScriptsPaths -si isLocalAccount -si username -si encryptedPassword
'
 + CHAR(10) + '--   script_name : SetSubClientPrePostProcess'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetUseGlobalFilters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetUseGlobalFilters <<<'

IF EXISTS (select * from sysobjects where name='QS_SetUseGlobalFilters')
	drop procedure QS_SetUseGlobalFilters
IF EXISTS (select * from GxQscripts where name='QS_SetUseGlobalFilters')
	delete from GxQscripts where name = 'QS_SetUseGlobalFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseGlobalFilters')
	delete from GXDBVersions where aliasname = 'QS_SetUseGlobalFilters'
GO
print '... Creating Procedure: QS_SetUseGlobalFilters'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetUseGlobalFilters
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @NEWSTATE varchar(512) = '%s',
  @CLIENTNAME varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER				 --
-------------------------------------------
--DECLARE @NEWSTATE		varchar(512)
--DECLARE @CLIENTNAME     varchar(1024)
--SET @NEWSTATE   = '%s'
--SET @CLIENTNAME = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetUseGlobalFilters'
DECLARE @created			   integer
SET     @created				= 0
DECLARE @SC_STATUS_BITS        integer
SET		@SC_STATUS_BITS        =  2+4+16					-- 0x00002+0x00004+0x00010
DECLARE @CV_USE_GLOBAL_FILTERS  nvarchar(80)
SET		@CV_USE_GLOBAL_FILTERS  = 'use global filters'
DECLARE @CV_USE_CS_SETTING  nvarchar(80)
SET		@CV_USE_CS_SETTING  = 'use cs setting for global filters'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
DECLARE @appTypeId				integer
DECLARE @instanceId				integer
DECLARE @backupSetId			integer
DECLARE	@subClientId			integer
DECLARE @backupSetName			varchar(1024)
DECLARE @appTypeName			varchar(512)
DECLARE	@subclientName			varchar(1024)
DECLARE @SCdescription			varchar(2048)
DECLARE @currentPropId1 integer
DECLARE @currentPropId2 integer
DECLARE @newUseGF			integer
DECLARE @newUseCSVal			integer
DECLARE @oldUseGF			integer
DECLARE @oldUseCSVal			integer
DECLARE @lastError				integer
DECLARE @OldState				varchar(512)
DECLARE @NewStateName			varchar(128)
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @newState =  'on'
--Set @clientName = 'jewelfish_cn'
--Set @clientName = 'cocoa71'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @newState = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF (@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg	='Error. No Client Name Specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------------------------------------------------
-- "Normalize" new state to what Props Expect --
------------------------------------------------
IF (@newState = 'on' OR @newState = 'enable')
BEGIN
	SET @newUseGF = 1
	SET @newUseCSVal = 0
	Set @newStateName = 'enabled'
END
ELSE if  (@newState = 'off' OR @newState = 'disable')
BEGIN
	SET @newUseGF = 0
	SET @newUseCSVal = 0
	Set @newStateName = 'disabled'
END
else IF (@newState = 'use cell level policy')
BEGIN
	SET @newUseGF = 0
	SET @newUseCSVal = 1
	Set @newStateName = 'use cell level property'
END
else
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Invalid input : '+@newState
	GOTO ARGS_ERROR
END
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newStateName
         + '], client = ['
         + @clientName
         + '].'
--------------------------------------
-- Figure Out ClientId from name:	--
--------------------------------------
SET @clientId     = (Select id from APP_CLIENT where name = @CLIENTNAME)
IF @clientId is Null
BEGIN
	SET @localErrorMsg	='No Client with name ['+@ClientName+'] exists.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
------------------------------------------------
-- DO THE WORK (LOOP FOR ALL SUBCLIENTS)!	----
------------------------------------------------
begin tran
DECLARE subClientCursor CURSOR STATIC FOR
  SELECT distinct id, clientId, appTypeId, instance, backupSet, subclientName  from APP_APPLICATION
	WHERE clientId = @clientId
        AND (subClientStatus & @SC_STATUS_BITS) = 0
		AND appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
    WHILE @@FETCH_STATUS = 0
    BEGIN
		Set @appTypeName   = (Select name from APP_IDATYPE			Where type = @appTypeId)
		SET @backupSetName = (Select name from APP_BACKUPSETNAME	Where id = @backupSetId)
		SET @clientName	   = (Select name from APP_CLIENT			Where id = @clientId)				-- Fetching Again in case we ever "wildCard" client selection
		SET @SCdescription = '['+@clientName + '(' + @appTypeName + ')-->'+@backupSetName + '-->' + @subClientName + ']'
--		SEE IF PROPERTY ALREADY EXISTS FOR THIS SUBCLIENT, AND IF IT HAS CHANGED  ---
		SET @currentPropId1 =
			(SELECT id FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_GLOBAL_FILTERS
				AND   modified = 0
			)
		SET @currentPropId2 =
			(SELECT id FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_CS_SETTING
				AND   modified = 0
			)
		Set @oldUseCSVal = ISNULL((select attrVal from APP_SUBCLIENTPROP WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_CS_SETTING
				AND   modified = 0), 1)
		Set @oldUseGF = ISNULL((select attrVal from APP_SUBCLIENTPROP WHERE componentNameId = @subClientId
				AND   attrName = @CV_USE_GLOBAL_FILTERS
				AND   modified = 0), 0)
		--select @subClientId, @currentPropId1, @currentPropId2, 'old', @oldUseCSVal, @oldUseGF, 'new', @newUseCSVal, @newUseGF
		IF @oldUseCSVal <> @newUseCSVal OR @oldUseGF <> @newUseGF
		BEGIN
			IF @currentPropId1 IS NOT NULL AND @oldUseGF <> @newUseGF
			BEGIN
				Update APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @subClientId
						AND   attrName = @CV_USE_GLOBAL_FILTERS
						AND   modified = 0
				--select 'updated', @CV_USE_GLOBAL_FILTERS
			END
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @CV_USE_GLOBAL_FILTERS
							+ ' for subClient '
							+ @SCdescription
							+ 'All changes will be rolled back for this client.'
				GOTO TRAN_ERROR					--- FOR NOW, DEBUGGING! !@#!
			END
			IF @currentPropId2 IS NOT NULL AND @oldUseCSVal <> @newUseCSVal
			BEGIN
				Update APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @subClientId
						AND   attrName = @CV_USE_CS_SETTING
						AND   modified = 0
						--select 'updated', @CV_USE_CS_SETTING
			END
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @localErrorMsg	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @CV_USE_GLOBAL_FILTERS
							+ ' for subClient '
							+ @SCdescription
							+ 'All changes will be rolled back for this client.'
				GOTO TRAN_ERROR					--- FOR NOW, DEBUGGING! !@#!
			END
			IF @oldUseCSVal <> @newUseCSVal
			BEGIN
				--select 'inserting', @CV_USE_CS_SETTING, @newUseCSVal
				IF @newUseCSVal = '1'
					INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
							VALUES (@subclientId, @CV_USE_CS_SETTING, 2, '1', @nowTime, 0)
				ELSE INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
							VALUES (@subclientId, @CV_USE_CS_SETTING, 2, '0', @nowTime, 0)
			END
			IF @oldUseGF <> @newUseGF
			BEGIN
				--select 'inserting', @CV_USE_GLOBAL_FILTERS, @newUseCSVal
				IF @newUseGF = '1'
					INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@subclientId, @CV_USE_GLOBAL_FILTERS, 2, '1', @nowTime, 0)
				ELSE INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@subclientId, @CV_USE_GLOBAL_FILTERS, 2, '0', @nowTime, 0)
			END
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
					SET @localErrorMsg	= '    Error[' +convert(varchar(12), @lastError)
								+'] when attempting addition of property ['
								+ @CV_USE_GLOBAL_FILTERS
								+ ' for subClient '
								+ @SCdescription
								+ 'All changes will be rolled back for this client.'
				GOTO TRAN_ERROR
			END
			PRINT '   Property ['+@CV_USE_GLOBAL_FILTERS + '] is now ' + @newStateName + ' for ' +@SCdescription + '.'
		END
		ELSE
		BEGIN
			PRINT '    State for ' + @SCdescription + ' has not changed. Property is still ' +@newStateName + '.'
			FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
			CONTINUE
		END
    FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
    END
TRAN_ERROR:
    CLOSE       subClientCursor
    DEALLOCATE  subClientCursor
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newStateName
         + '], client = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetUseGlobalFilters')
	delete from GxQscripts where name = 'QS_SetUseGlobalFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseGlobalFilters')
	delete from GXDBVersions where aliasname = 'QS_SetUseGlobalFilters'
GO

insert into GXDBVersions values(2, 'QS_SetUseGlobalFilters',  '00000000000000000000', 'QS_SetUseGlobalFilters', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetUseGlobalFilters',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qscript -f SetUseGlobalFilters -i enable|disable  -i clientName
'
 + CHAR(10) + '--   script_name : SetUseGlobalFilters'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateNextEvent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateNextEvent <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateNextEvent')
	drop procedure QS_UpdateNextEvent
IF EXISTS (select * from GxQscripts where name='QS_UpdateNextEvent')
	delete from GxQscripts where name = 'QS_UpdateNextEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateNextEvent')
	delete from GXDBVersions where aliasname = 'QS_UpdateNextEvent'
GO
print '... Creating Procedure: QS_UpdateNextEvent'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateNextEvent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @nextEvent varchar(1024) = '%s',
  @taskId varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @nextEvent	varchar(1024)
--SET		@nextEvent	= '%s'
--DECLARE @taskId	varchar(1024)
--SET		@taskId	= '%s'
---------------------------------------
--test
--SET		@nextEvent		= '2010-06-19 08:50:00.000'
--SET		@taskId	= '22'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'UpdateNextEvent'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @nextEvent	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Next schedule event Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @nextEvent < getdate()
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Next schedule event cannot be in the past.'
	GOTO ARGS_ERROR
END
IF @taskId	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule policy name Expected as parameter 2.'
	GOTO ARGS_ERROR
END
--------------SETP 1 ---------------------
BEGIN TRAN
	IF EXISTS(SELECT * FROM TM_AssocEntity WHERE taskId=@taskId )
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Schedule instance ['+CAST(@taskId AS VARCHAR(10))+'] has associations will not be modified'
		GOTO TRANS_EXIT
	END
	IF EXISTS(SELECT * FROM TM_Task WHERE taskType=4 AND taskId=@taskId)
	BEGIN
		UPDATE TM_RunTime SET nextRunTime=@nextEvent, nextTime=dbo.getunixtime(@nextEvent) WHERE patternId IN (
				SELECT patternId FROM TM_PatternAssoc WHERE subTaskId IN (
					SELECT subTaskId FROM TM_SubTask WHERE taskId = @taskId
				)
			) AND processed = 0 AND firing = 0
		UPDATE TM_RunTimeAssoc SET nextRunTime=@nextEvent WHERE runTimeId IN (
				SELECT runTimeId From TM_RunTime WHERE patternId IN (
					SELECT patternId FROM TM_PatternAssoc WHERE subTaskId IN (
						SELECT subTaskId FROM TM_SubTask WHERE taskId = @taskId
					)
				) AND processed = 0 AND firing = 0
			) AND processed = 0 AND firing = 0
	END
	ELSE
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. No schedule template found for schedule policy instance ['+CAST(@taskId AS VARCHAR(10))+']'
		GOTO TRANS_EXIT
	END
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@nextEvent+', '+CAST(@taskId AS VARCHAR(10))+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateNextEvent')
	delete from GxQscripts where name = 'QS_UpdateNextEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateNextEvent')
	delete from GXDBVersions where aliasname = 'QS_UpdateNextEvent'
GO

insert into GXDBVersions values(2, 'QS_UpdateNextEvent',  '00000000000000000000', 'QS_UpdateNextEvent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateNextEvent',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn UpdateNextEvent.sql -si nextEvent -si task id
'
 + CHAR(10) + '--   script_name : UpdateNextEvent'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDataReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDataReaders <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDataReaders')
	drop procedure QS_SetDataReaders
IF EXISTS (select * from GxQscripts where name='QS_SetDataReaders')
	delete from GxQscripts where name = 'QS_SetDataReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDataReaders')
	delete from GXDBVersions where aliasname = 'QS_SetDataReaders'
GO
print '... Creating Procedure: QS_SetDataReaders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetDataReaders
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @dataReaders varchar(1024) = '%s',
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @dataReaders	varchar(1024)
--SET		@dataReaders  = '%s'
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
---------------------------------------
--SET		@dataReaders = '7'
--SET		@PARAM1= 'c=bingo'
--SET		@PARAM2= 'a=Q_WINNET_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'SetDataReaders'
DECLARE @propNameEx varchar(50)
SET @propNameEx = 'Num Streams'
DECLARE @propNameOther varchar(32)
SET @propNameOther = 'sys:nStreams'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
-------- Get ids  -------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames  @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
---LICENSE CHECK
DECLARE @optype varchar(16)
SET @optype = ''
DECLARE @eval integer
SET @eval = 0
DECLARE @expiryDateUTC datetime
SET @expiryDateUTC = 0
DECLARE @OptimeUTC datetime
SET @OpTimeUTC = 0
SELECT @expiryDateUTC = expiryDateUTC, @optype = optype, @OpTimeUTC = OpTimeUTC , @eval= eval FROM LicUsage WHERE CId = @ClientId AND LicType = 109 AND AppType = 1039
DECLARE @installed integer
IF @optype = 'Uninstall'
	SET @installed = 0
ELSE
	SET @installed = 1
DECLARE @expired integer
IF @expiryDateUTC < GETUTCDATE() AND  @expiryDateUTC > 0
	SET @expired = 1
ELSE
	SET @expired = 0
--SELECT  @OpTimeUTC, @expiryDateUTC, @installed, @eval, @expired
IF @installed = 0 Or @expired = 1
BEGIN
	SET @localErrorMsg = 'Error.  License for Advanced iDA has expired/is not installed.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--UPDATE THE NUMBER OF DATA READERS NOW
DECLARE @propName varchar(32)
SET @propName = ''
IF @AppTypeId in (27, 31) --UNUSED_CV_APPTYPE_27, UNUSED_CV_APPTYPE_31
	SET @propName = @propNameEx
ELSE
	SET @propName = @propNameOther
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
BEGIN TRAN
BEGIN TRY
UPDATE APP_SubclientProp SET modified = @nowTime WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName
INSERT INTO APP_SubclientProp (componentNameId, attrname, attrval, attrtype, created, modified) VALUES (@subclientId, @propName, @dataReaders, 2, @nowTime, 0)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

BEGIN
	ROLLBACK TRAN
    SET @lastError = ERROR_NUMBER()
    SET @localErrorMsg = 'Problems updating DataReaders ' +ERROR_MESSAGE()
END
END CATCH
if @lastError = 0
	COMMIT TRAN
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: Data Readers : '+@dataReaders+' SubClient : ['+@PARAM1+' '+@PARAM2+' '+@PARAM3+' '+@PARAM4+']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDataReaders')
	delete from GxQscripts where name = 'QS_SetDataReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDataReaders')
	delete from GXDBVersions where aliasname = 'QS_SetDataReaders'
GO

insert into GXDBVersions values(2, 'QS_SetDataReaders',  '00000000000000000000', 'QS_SetDataReaders', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDataReaders',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetDataReaders -si no_of_data_readers -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : SetDataReaders'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetCommcells.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetCommcells <<<'

IF EXISTS (select * from sysobjects where name='QS_GetCommcells')
	drop procedure QS_GetCommcells
IF EXISTS (select * from GxQscripts where name='QS_GetCommcells')
	delete from GxQscripts where name = 'QS_GetCommcells'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetCommcells')
	delete from GXDBVersions where aliasname = 'QS_GetCommcells'
GO
print '... Creating Procedure: QS_GetCommcells'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetCommcells
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-------------------------------------------
	--			NO INPUT			--
-------------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetCommcells'
-------- Local Variables    -------------
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @sqlString              nvarchar(512)
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
IF DB_Id('QNet') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Command cannot run.  QNet Database is either not installed or is offline.'
	goto ARGS_ERROR
END
SET @sqlString = 'USE QNET  SELECT DisplayName, InterfaceName FROM Child'
exec sp_executesql @sqlString
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetCommcells')
	delete from GxQscripts where name = 'QS_GetCommcells'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetCommcells')
	delete from GXDBVersions where aliasname = 'QS_GetCommcells'
GO

insert into GXDBVersions values(2, 'QS_GetCommcells',  '00000000000000000000', 'QS_GetCommcells', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetCommcells',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetCommcells.sql 
'
 + CHAR(10) + '--   script_name : GetCommcells'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetContentIndexingProperty.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetContentIndexingProperty <<<'

IF EXISTS (select * from sysobjects where name='QS_SetContentIndexingProperty')
	drop procedure QS_SetContentIndexingProperty
IF EXISTS (select * from GxQscripts where name='QS_SetContentIndexingProperty')
	delete from GxQscripts where name = 'QS_SetContentIndexingProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetContentIndexingProperty')
	delete from GXDBVersions where aliasname = 'QS_SetContentIndexingProperty'
GO
print '... Creating Procedure: QS_SetContentIndexingProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetContentIndexingProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @propertyName nvarchar(2048) = N'',
  @propertyValue nvarchar(2048) =N'',
  @AuthCode NVARCHAR(64) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_SetContentIndexingProperty'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
DECLARE @CommCellNumber		INTEGER = 0
DECLARE @Authenticate		INTEGER = 0
-----------------------invalid parameters------------------------------
IF(@propertyName = @NoParameter OR @propertyValue = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of Commcell---------------------
SELECT @CommCellNumber = number from APP_CommCell where id = 2
IF @AuthCode = @NoParameter --IF Authentication code is not passed
BEGIN
	SET @errorString = N'No Authorization code passed. Authorization code required.'
	SET @errorCode = 3
	GOTO SCRIPT_EXIT
END
ELSE
BEGIN
	SET @Authenticate = CONVERT(INTEGER, @AuthCode)
	IF ((CHECKSUM(HASHBYTES('SHA1', '<' + @scriptName + '><' + CAST(@propertyName AS VARCHAR(100)) + '><' + CAST(@propertyValue AS VARCHAR(100)) + '><' + CAST(@CommCellNumber AS VARCHAR(100)) + '><COMMVAULT>')) & 2147483646) <> @Authenticate)
	BEGIN
		SET @errorString = N'Wrong Authorization code passed [' + @AuthCode + '].'
		SET @errorCode = 4
		GOTO SCRIPT_EXIT
	END
END
-----------------Update conent indexing property into GXGlobalParam table--------------
BEGIN TRAN
	BEGIN TRY
		EXEC QS_SetKeyIntoGlobalParamTbl @propertyName, 'Y', @propertyValue
		IF @propertyName = 'CINumDocumentMaxLimit'
		begin
			SET @propertyName = 'CINumDocumentReachesLimit'
			SET @propertyValue = cast (0.8 * cast ( @propertyValue as bigint) as bigint)
			EXEC QS_SetKeyIntoGlobalParamTbl @propertyName, 'Y', @propertyValue
		end
	END TRY
	BEGIN CATCH
	
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO SCRIPT_EXIT
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@propertyName + ', '+@propertyValue +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetContentIndexingProperty')
	delete from GxQscripts where name = 'QS_SetContentIndexingProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetContentIndexingProperty')
	delete from GXDBVersions where aliasname = 'QS_SetContentIndexingProperty'
GO

insert into GXDBVersions values(2, 'QS_SetContentIndexingProperty',  '00000000000000000000', 'QS_SetContentIndexingProperty', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetContentIndexingProperty',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetContentIndexingProperty.sql -si ''propertyName'' -si ''propertyValue'' -si AuthenticationCode
'
 + CHAR(10) + '-- 	script_name: QS_SetContentIndexingProperty'
 + CHAR(10) + '-- 	 Qscript to set content indexing property.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_UpdateCIProxyClient.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateCIProxyClient <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateCIProxyClient')
	drop procedure QS_UpdateCIProxyClient
IF EXISTS (select * from GxQscripts where name='QS_UpdateCIProxyClient')
	delete from GxQscripts where name = 'QS_UpdateCIProxyClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCIProxyClient')
	delete from GXDBVersions where aliasname = 'QS_UpdateCIProxyClient'
GO
print '... Creating Procedure: QS_UpdateCIProxyClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateCIProxyClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_ciClientName nvarchar(2048) = N'',
  @i_fsClientName nvarchar(2048) = N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_UpdateCIProxyClient'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
-----------------------invalid parameters------------------------------
IF(@i_ciClientName = @NoParameter OR @i_fsClientName = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of client---------------------
DECLARE @ciClientId INT = 0
DECLARE @fsClientId INT = 0
SET @ciClientId = ISNULL((SELECT id FROM APP_Client WHERE name = @i_ciClientName), 0)
IF @ciClientId = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid CI client name [' + @i_ciClientName + '] specified.'
	GOTO SCRIPT_EXIT
END
SET @fsClientId = ISNULL((SELECT id FROM APP_Client WHERE name = @i_fsClientName), 0)
IF @fsClientId = 0
BEGIN
	SET @errorCode = 3
	SET @errorString = 'Error. Invalid proxy client name [' + @i_fsClientName + '] specified.'
	GOTO SCRIPT_EXIT
END
-----------------Insert/Update "Proxy Filesystem Client Id" into APP_ClientProp table--------------
DECLARE @nowtime as int
SET @nowtime = dbo.GetUnixTime (GetUTCDate())
DECLARE @PROXY_FILESYSTEM_CLIENT_ID VARCHAR(100) = 'Proxy Filesystem Client Id'
--If this property already exists, then update it--
IF EXISTS (SELECT *
			FROM APP_ClientProp
			WHERE componentNameId = @ciClientId AND attrName = @PROXY_FILESYSTEM_CLIENT_ID AND modified = 0)
BEGIN
		UPDATE APP_ClientProp
		SET attrval = @fsClientId
		WHERE componentNameId = @ciClientId and attrName = @PROXY_FILESYSTEM_CLIENT_ID and modified = 0
END
ELSE
BEGIN
	INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
		VALUES (@ciClientId, @PROXY_FILESYSTEM_CLIENT_ID, 2, @fsClientId, @nowtime, 0, 0)
END
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_ciClientName + ', '+@i_fsClientName
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateCIProxyClient')
	delete from GxQscripts where name = 'QS_UpdateCIProxyClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCIProxyClient')
	delete from GXDBVersions where aliasname = 'QS_UpdateCIProxyClient'
GO

insert into GXDBVersions values(2, 'QS_UpdateCIProxyClient',  '00000000000000000000', 'QS_UpdateCIProxyClient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateCIProxyClient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_UpdateCIProxyClient.sql -si ''ciClientName'' -si ''proxyClientName''
'
 + CHAR(10) + '-- 	script_name: QS_UpdateCIProxyClient'
 + CHAR(10) + '-- 	 Script to set proxy client for CI client'
 + CHAR(10) + '-- 	clientName - Name of the Client for which need to set the proxy'
 + CHAR(10) + '-- 	proxyClientName - proxy client name'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CommservAssociateBillableEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_CommServAssociateBillableEntity <<<'

IF EXISTS (select * from sysobjects where name='QS_CommServAssociateBillableEntity')
	drop procedure QS_CommServAssociateBillableEntity
IF EXISTS (select * from GxQscripts where name='QS_CommServAssociateBillableEntity')
	delete from GxQscripts where name = 'QS_CommServAssociateBillableEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommServAssociateBillableEntity')
	delete from GXDBVersions where aliasname = 'QS_CommServAssociateBillableEntity'
GO
print '... Creating Procedure: QS_CommServAssociateBillableEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_CommServAssociateBillableEntity
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @fileName nvarchar(MAX) = '%s'
AS
SET NOCOUNT ON
--DECLARE @filename NVARCHAR(MAX)   -- = 'c:\BE\MyBEAssocList.txt'
--SET  @filename ='%s'
EXECUTE ('
    USE CommServ
    -- Drop all Temporary tables that will be used in case a stale Temporary Table is still in memory
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalData'') IS NOT NULL DROP TABLE #tempBLExternalData
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataDirty'') IS NOT NULL DROP TABLE #tempBLExternalDataDirty
    --IF OBJECT_ID(''tempdb.dbo.#tempBLEntityMembers'') IS NOT NULL DROP TABLE #tempBLEntityMembers
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataSel'') IS NOT NULL DROP TABLE #tempBLExternalDataSel
    IF OBJECT_ID(''tempdb.dbo.#tempOPErrCodes'') IS NOT NULL DROP TABLE #tempOPErrCodes
    IF OBJECT_ID(''tempdb.dbo.#tempOPStatus'') IS NOT NULL DROP TABLE #tempOPStatus
	CREATE TABLE #tempOPErrCodes
	(
		ErrCode		INT,
		ErrString	VARCHAR(512)
	)
	CREATE TABLE #tempOPStatus
	(
       EntityName	NVARCHAR(512),
       ErrCode		INT
	)
    CREATE TABLE #tempBLExternalDataDirty
    (
        [Name]           NVARCHAR(512)                  NULL,
        [clientName]     NVARCHAR(512)                  NULL
    )
    CREATE TABLE #tempBLExternalDataDirtySel
    (
        [NameSel]           NVARCHAR(512)                  NULL,
        [clientNameSel]     NVARCHAR(512)                  NULL
    )
    CREATE TABLE #tempBLExternalData
    (
        [Name]           NVARCHAR(512)                  NULL,
        [clientName]     NVARCHAR(512)                  NULL,
        [IsAssocPresent] INTEGER						NULL,
        [BEID]			 INTEGER,
        [ClientID]		 INTEGER
    )
	INSERT INTO #tempOPErrCodes VALUES (1, ''Did not attempt to associate billable entity for the following non-existent clients'')
	INSERT INTO #tempOPErrCodes VALUES (2, ''Did not attempt to associate billable entity for the following non-existent billable entities'')
	INSERT INTO #tempOPErrCodes VALUES (3, ''Did not attempt to associate billable entity for the following clients since they already have previous associations'')
	INSERT INTO #tempOPErrCodes VALUES (4, ''Following clients had multiple associations defined on them. Only one association was honored'')
    -- load data into temporary table
    BULK
    INSERT  #tempBLExternalDataDirtySel
    FROM    ''' + @filename + '''
    WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','') --, KEEPNULLS)
     UPDATE  #tempBLExternalDataDirtySel
		SET     [NameSel]          = LTRIM(RTRIM([NameSel])),
            [clientNameSel]    = LTRIM(RTRIM([clientNameSel]))
     -- Filter out any multiple  billable  entity associations on the same client.
     INSERT INTO #tempBLExternalDataDirty ([clientName])
     SELECT DISTINCT [clientNameSel] FROM #tempBLExternalDataDirtySel
     UPDATE #tempBLExternalDataDirty
        SET [Name] = (SELECT TOP 1 [NameSel] FROM #tempBLExternalDataDirtySel WHERE [clientNameSel] = [clientName])
    -- select original entries only
    INSERT  INTO #tempBLExternalData ([Name],[clientName],[IsAssocPresent],[BEID],[ClientID])
    SELECT   BLEX.[Name], BLEX.[clientName],-1, BLE.EntityID,APC.Id
    FROM #tempBLExternalDataDirty as BLEX, App_Client AS APC, BLEntity AS	 BLE
    WHERE       BLEX.[Name] IS NOT NULL
            AND [clientName] IS NOT NULL
            AND LEN(BLEX.[Name]) > 0
            AND LEN([clientName]) > 0
            AND APC.name = BLEX.clientName
            AND BLE.DisplayName = BLEX.Name
	-- if the BE association is already present for a client then do not attempt that client.
	UPDATE  #tempBLExternalData SET  [IsAssocPresent] = 1
	WHERE EXISTS (SELECT * FROM BLEntityMembers WHERE ClientID = #tempBLExternalData.[ClientID])
	UPDATE  #tempBLExternalData SET  [IsAssocPresent] = 0  WHERE [IsAssocPresent] = -1
	-- SELECT * FROM #tempBLEntityMembers
	INSERT INTO BLEntityMembers (EntityID, AssocType, ClientID, AppTypeID, InstanceID, BackupSetID, AppID)
	SELECT  [BEID],2,[ClientId],0,0,0,0 FROM #tempBLExternalData WHERE [IsAssocPresent] = 0
    IF EXISTS (SELECT [clientNameSel] FROM #tempBLExternalDataDirtySel
				WHERE [clientNameSel] NOT IN (SELECT [clientName] FROM #tempBLExternalData) )
	BEGIN
	   --print ''Billable Entity association was not attempted for the following non-existent clients ''
	   INSERT INTO #tempOPStatus
	   SELECT [clientNameSel],1 as ClientName FROM #tempBLExternalDataDirtySel
				WHERE [clientNameSel] NOT IN (SELECT [clientName] FROM #tempBLExternalData)
	END
	IF EXISTS (SELECT [NameSel] FROM #tempBLExternalDataDirtySel WHERE [NameSel] NOT IN (
				SELECT DisplayName FROM BLEntity))
     BEGIN
       --print ''Associations for the following non-existent billable entities were not attempted ''
       INSERT INTO #tempOPStatus
       SELECT [NameSel],2 as BillableEntity FROM #tempBLExternalDataDirtySel WHERE [NameSel] NOT IN (
				SELECT DisplayName FROM BLEntity)
     END
     IF EXISTS (SELECT * FROM #tempBLExternalData WHERE [IsAssocPresent] = 1 )
     BEGIN
       --print ''The following clients already have associations defined and hence were not attempted''
       INSERT INTO #tempOPStatus
       SELECT [clientName],3 FROM #tempBLExternalData WHERE [IsAssocPresent] = 1
     END
	 IF EXISTS (SELECT [clientNameSel], COUNT(*) FROM #tempBLExternalDataDirtySel
			WHERE [clientNameSel] IN (SELECT [clientName] FROM  #tempBLExternalData WHERE [IsAssocPresent] = 0)
			GROUP BY  [clientNameSel]
			HAVING COUNT(*) > 1)
	 BEGIN
	--   print ''For the following clients, there were multiple associations defined. Only one was honored''
	   INSERT INTO #tempOPStatus
	   SELECT [clientNameSel],4 FROM #tempBLExternalDataDirtySel
			WHERE [clientNameSel] IN (SELECT [clientName] FROM  #tempBLExternalData WHERE [IsAssocPresent] = 0)
			GROUP BY  [clientNameSel]
			HAVING COUNT(*) > 1
	 END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode = 1)
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 1
	  SELECT EntityName as ClientName FROM #tempOPStatus WHERE ErrCode = 1
	END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode  = 2 )
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 2
	  SELECT EntityName as BillableEntity FROM #tempOPStatus WHERE ErrCode = 2  ORDER BY EntityName
	END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode = 3 )
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 3
	  SELECT EntityName as BillableEntity FROM #tempOPStatus WHERE ErrCode = 3  ORDER BY EntityName
	END
	IF EXISTS (SELECT * FROM #tempOPStatus WHERE ErrCode = 4)
	BEGIN
	  SELECT ''---- '' + ErrString + '' ----'' as '' '' FROM #tempOPErrCodes WHERE ErrCode = 4
	  SELECT EntityName as BillableEntity FROM #tempOPStatus WHERE ErrCode = 4 ORDER BY EntityName
	END
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalData'') IS NOT NULL DROP TABLE #tempBLExternalData
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataDirty'') IS NOT NULL DROP TABLE #tempBLExternalDataDirty
    IF OBJECT_ID(''tempdb.dbo.#tempBLExternalDataSel'') IS NOT NULL DROP TABLE #tempBLExternalDataSel
    --IF OBJECT_ID(''tempdb.dbo.#tempBLEntityMembers'') IS NOT NULL DROP TABLE #tempBLEntityMembers
    IF OBJECT_ID(''tempdb.dbo.#tempOPErrCodes'') IS NOT NULL DROP TABLE #tempOPErrCodes
    IF OBJECT_ID(''tempdb.dbo.#tempOPStatus'') IS NOT NULL DROP TABLE #tempOPStatus
    ')
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CommservAssociateBillableEntity')
	delete from GxQscripts where name = 'QS_CommservAssociateBillableEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CommservAssociateBillableEntity')
	delete from GXDBVersions where aliasname = 'QS_CommservAssociateBillableEntity'
GO

insert into GXDBVersions values(2, 'QS_CommservAssociateBillableEntity',  '00000000000000000000', 'QS_CommservAssociateBillableEntity', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CommservAssociateBillableEntity',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn CommServAssociateBillableEntity.sql -si Billable Entity/Client CSV File Path
'
 + CHAR(10) + '--   script_name : CommServAssociateBillableEntity'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetUseVSSGlobally.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetUseVSSGlobally <<<'

IF EXISTS (select * from sysobjects where name='QS_SetUseVSSGlobally')
	drop procedure QS_SetUseVSSGlobally
IF EXISTS (select * from GxQscripts where name='QS_SetUseVSSGlobally')
	delete from GxQscripts where name = 'QS_SetUseVSSGlobally'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseVSSGlobally')
	delete from GXDBVersions where aliasname = 'QS_SetUseVSSGlobally'
GO
print '... Creating Procedure: QS_SetUseVSSGlobally'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetUseVSSGlobally
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @ACTION varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER (DELETE IF NOT NEEDED)				 --
-------------------------------------------
--DECLARE @ACTION	varchar(512)
--SET @ACTION = '%s'
-----------------------
-- CONVENIENCE DEFS  --
-----------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setUseVssGlobally'
DECLARE @nowTime    integer
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
DECLARE @created			   integer
SET     @created				= 0
DECLARE @SC_STATUS_BITS        integer
SET		@SC_STATUS_BITS        =  4					-- 0x00004
DECLARE @USE_VSS_PROPNAME     varchar(50)
SET     @USE_VSS_PROPNAME     ='Use Shadow Copy'			-- GUI says "Use VSS" by checkbox, internally we use "Shadow Copy"
DECLARE @USE_VSS_OPTIONS		varchar(50)
SET		@USE_VSS_OPTIONS		='Use VSS Options'				-- From 10.0, this property is implemented as an enum. Old property will also be saved and the new property will also be used
DECLARE @USE_VSS_ENABLED		varchar(50)
SET		@USE_VSS_ENABLED		='Use VSS Enabled'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
DECLARE @appTypeId              integer
DECLARE @instanceId             integer
DECLARE @backupSetId			integer
DECLARE @subClientId			integer
DECLARE @subClientName			nvarchar(1024)
DECLARE @objectName				nvarchar(4000)
DECLARE @NEWVAL					int
DECLARE @OLDVAL					int
DECLARE @newVSSVal				int
DECLARE @oldVSSVal				int
DECLARE @releaseId				int
DECLARE @ACTION_TAKEN			nvarchar(512)
DECLARE @ERROR_COUNT			int
SET		@ERROR_COUNT			=0
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @ACTION =  'enable'
--SET @ACTION =  'disable'
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF @ACTION = @NoParameter
BEGIN
	SET @localErrorMsg	='Error. Enable/Disable parameter not specified.'
	Set @lastError = 1
    GOTO   ARGS_ERROR
END
------------------------------------------------
--- CHECK IF A PROPER REQUEST WAS MADE       ---
------------------------------------------------
IF @ACTION <> 'enable' AND @ACTION <> 'disable'                         -- Case Insensitive Check
BEGIN
    SET @localErrorMsg  ='Error. Enable/Disable parameter specified incorrectly as ['+@action +'].'
    SET @lastError = 1
    GOTO   ARGS_ERROR
END
IF @ACTION = 'enable'
BEGIN
	SET @NEWVAL = 1
END
ELSE
BEGIN
	SET @NEWVAL = 0
END
-------------------------------------------------------
-- DONE PROCESSING CMD ARGS, START THINGS GOING: ------
-------------------------------------------------------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + '].'
--  ===============================================================
--  LOOP FOR ALL THE SUBCLIENTS THAT NEED TO HAVE THE PROPERTY SET
--  ===============================================================
DECLARE SUBC_CURSOR CURSOR FOR
	SELECT id, clientId, appTypeId, instance, backupSet, subClientName from app_application
--		WHERE appTypeId in (11, 33, 34, 42, 43)				-- USE VSS Option Not supported in Win2K!
		WHERE appTypeId in (33, 34, 42, 43)
		  AND (subClientStatus & @SC_STATUS_BITS) = 0
	UNION
	SELECT id, clientId, appTypeId, instance, backupSet, subClientName from app_application
	 WHERE backupSet in( SELECT componentNAmeId
						 FROM app_backupsetProp
							WHERE AttrNAme = 'Associated subclient Policy Ida Type'
							  AND attrVal = 2
							  AND modified = 0 )
	   AND appTypeId = 1030
	   AND (subClientStatus & @SC_STATUS_BITS) = 0
	   ORDER BY clientId, appTypeId, backupset, subClientName
OPEN SUBC_CURSOR
FETCH SUBC_CURSOR INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subClientName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @releaseId = ISNULL((SELECT releaseId FROM APP_Client WHERE id = @clientId),0)
	SET @objectName = '  ['+ CONVERT(char(25), (select name from app_client where id = @clientId))				+ ']['
							   + CONVERT(char(25),(select name from app_idaType where type = @appTypeId))			+ ']['
							   + CONVERT(char(20), (select name from app_backupSetName where id = @backupSetId))	+ ']['
							   + CONVERT(char(20), @subClientName) + ']'
	SET @ACTION_TAKEN		= ''					-- "reset" at the top of ea. loop
	SET @lastError		= 0
	------------------------------------------------------
	-- WANT TO IGNORE THIS SUBCLIENT IF PART OF A SCP	--
	------------------------------------------------------
	IF @appTypeId <> 1030
	   AND EXISTS (SELECT * FROM APP_SubClientProp Where ComponentNameId =@subClientId AND attrName = 'Associated subclient Policy' AND modified = 0)
	BEGIN
			SET @ACTION_TAKEN = ' (Skipping. Part of a SubClient Policy)'
			GOTO REPORT_RESULTS
	END
	IF @releaseId < 15
	BEGIN
		SET @OLDVAL = ISNULL((Select CAST(attrVal AS INT) FROM app_subClientProp
							   Where componentNameId = @subClientId AND attrName = @USE_VSS_PROPNAME AND modified = 0)
							   , 0)
	END
	ELSE
	BEGIN
		IF (((SELECT attrVal FROM App_SubclientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = @USE_VSS_ENABLED) = '1')
			AND (((SELECT attrVal FROM App_SubclientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = @USE_VSS_OPTIONS) = '1')
			OR NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = @USE_VSS_OPTIONS)))
			SET @oldVal = 1				--Use shadow copy is ON
		ELSE
			SET @oldVal = 0				--Use shadow copy is OFF
	END
	------------------------------------------------------
	--	DON'T WANT TO AGE/MODIFY PROPERTY IF VALUE IS	--
	--  ALREADY SET AT CORRECT VALUE					--
	------------------------------------------------------
	IF @OLDVAL = @NEWVAL
	BEGIN
		SET @ACTION_TAKEN=' (already '+@ACTION + 'd)'
		GOTO REPORT_RESULTS
	END
	------------------------------------------------------
	--  PROP NEEDS TO CHANGE AGE EXISTING PROPERTY 1ST	--
	------------------------------------------------------
	BEGIN TRAN
	BEGIN TRY
		IF(@releaseId < 15)
			UPDATE APP_SUBCLIENTPROP
			SET  modified = @nowTime
			WHERE componentNameId = @subClientId
			  AND attrName = @USE_VSS_PROPNAME
			  AND modified = 0
		ELSE
		BEGIN
			IF(@ACTION = 'enable')
			BEGIN
				UPDATE APP_SubclientProp
				SET modified = @nowTime
				WHERE componentNameId = @subclientId
					AND	attrName = @USE_VSS_ENABLED
					AND modified = 0
				UPDATE App_Subclientprop
				SET modified = @nowTime
				WHERE componentNameId = @subclientId
					AND attrName = @USE_VSS_OPTIONS
					AND modified = 0
			END
			ELSE
			BEGIN
				UPDATE APP_SubclientProp
				SET modified = @nowTime
					WHERE componentNameId = @subclientId
					AND	attrName = @USE_VSS_ENABLED
					AND modified = 0
			END
		END
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		Set @lastError      = ERROR_NUMBER()
		SET @localErrorMsg  = ERROR_MESSAGE()
		SET @ERROR_COUNT = @ERROR_COUNT +1
		SET @ACTION_TAKEN = @ACTION_TAKEN + @localErrorMsg
		GOTO NEXT_FETCH
	END CATCH
			--	NOW CREATE THE NEW VALUE --
	BEGIN TRY
		IF(@releaseId < 15)
		BEGIN
			INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@subClientId, @USE_VSS_PROPNAME, 2, CAST(@NEWVAL AS NVARCHAR(10)), @nowTIme, 0)
		END
		ELSE
		BEGIN
			IF @action = 'enable'
			BEGIN
				INSERT INTO APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subclientId, @USE_VSS_ENABLED, 2, '1', @nowTIme, 0)
				INSERT INTO App_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subclientId, @USE_VSS_OPTIONS, 7, '1', @nowTime, 0)
			END
			ELSE
			BEGIN
				INSERT INTO APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subclientId, @USE_VSS_ENABLED, 2, '0', @nowTime, 0)
			END
		END
		SET @ACTION_TAKEN = @ACTION_TAKEN + ' Now ' + @ACTION + 'd.'
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		Set @lastError      = ERROR_NUMBER()
		SET @localErrorMsg  = ERROR_MESSAGE()
		SET @ERROR_COUNT = @ERROR_COUNT +1
		SET @ACTION_TAKEN = @ACTION_TAKEN + @localErrorMsg
		GOTO NEXT_FETCH
	END CATCH
	NEXT_FETCH:
    IF (@lastError = 0)
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
REPORT_RESULTS:
	PRINT @objectName+@ACTION_TAKEN
	FETCH SUBC_CURSOR INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subClientName	-- NEXT!
END
CLOSE		SUBC_CURSOR
DEALLOCATE	SUBC_CURSOR
--------------------------------------
-- ALL DONE, REPORT BACK TO CALLER	--
--------------------------------------
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: PARAM_01 = ['
         + @ACTION
         + ']. Errors/Warnings(' +convert(varchar(2), @ERROR_COUNT) + ').'
if @ERROR_COUNT <> 0
BEGIN
	SET @localErrorMsg = 'Script completed with [' + CONVERT(varchar(4), @ERROR_COUNT) + '] errors/warnings. Consult Script log for details'
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
RETURN
--------------------------------------------------------
-- ONLY COME HERE IF HAD PROBLEM WITH INPUT PARAMS	--
--------------------------------------------------------
ARGS_ERROR:
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetUseVSSGlobally')
	delete from GxQscripts where name = 'QS_SetUseVSSGlobally'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseVSSGlobally')
	delete from GXDBVersions where aliasname = 'QS_SetUseVSSGlobally'
GO

insert into GXDBVersions values(2, 'QS_SetUseVSSGlobally',  '00000000000000000000', 'QS_SetUseVSSGlobally', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetUseVSSGlobally',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn setUseVSSGlobally.sql -si enable | disable 
'
 + CHAR(10) + '--   script_name : SetUseVSSGlobally'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_modifysubclientpolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_modifysubclientpolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_modifysubclientpolicy')
	drop procedure QS_modifysubclientpolicy
IF EXISTS (select * from GxQscripts where name='QS_modifysubclientpolicy')
	delete from GxQscripts where name = 'QS_modifysubclientpolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_modifysubclientpolicy')
	delete from GXDBVersions where aliasname = 'QS_modifysubclientpolicy'
GO
print '... Creating Procedure: QS_modifysubclientpolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_modifysubclientpolicy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS NVARCHAR(512) = '',
  @param2 AS NVARCHAR(512) = '',
  @param3 AS NVARCHAR(512) = '',
  @param4 AS NVARCHAR(512) = ''
AS
--convenient defs--
declare @clientgroupid as int
declare @clientgroupname as nvarchar(100)
declare @clientid as int
declare @clientname as nvarchar(100)
declare @apptypeid as int
declare @backupsetid as int
declare @scpid as int
declare @subclientpolicyname as nvarchar(100)
declare @scptype as nvarchar(10)
declare @apptype as int
declare @errorcode as int = 0
declare @errorstring as nvarchar(1000) = 'Successful'
declare @currenttime as int = [dbo].getunixtime(GetUTCDate())
declare @backupsetname as  nvarchar(100)
declare @subclientid as int
declare @instanceid as int
declare @appnumberid as int
declare @dataarchid as int
declare @logarchid as int
declare @reftime as int
declare @modifiedtime as int
declare @scname as nvarchar(100)
declare @scstatus as int
declare @createdtime as int
declare @tempclients table ( clientid int)
declare @tempbackupsets table ( backupsetid int)
--input parameters verification--
if @param1 = '' or @param1 not in (N'associate',N'disassociate')
begin
	set @errorcode = 1
	set @errorstring = 'Error. First Parameter must be associate/disassociate'
	goto args_exit
end
if @param1 = 'associate'
begin
	--1. associate, cg=client group, scp=subclientpolicyname
	--2. associate, c=client, scp=subclientpolicyname
	--3. associate, c=client, b=backupset, scp=subclientpolicyname
	if @param2 not like 'cg=%' and @param2 not like 'c=%'
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Second parameter must be cg= client group name or c=client name'
		goto args_exit
	end
	if(@param2 like 'cg=%' and @param3 not like 'scp=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Second param is client group. Third param must be scp=subclient policy name'
		goto args_exit
	end
	if(@param2 like 'c=%' and @param3 not like 'scp=%' and @param3 not like 'b=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Second param is client. Third param must be scp=subclient policy name or b=backupsetname'
		goto args_exit
	end
	if(@param3 not like 'scp=%' and @param4 not like 'scp=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Subclient policy name must be specified as scp=subclient policy name'
		goto args_exit
	end
	--subclient policy
	if @param3 like 'scp=%'
		set @subclientpolicyname = SUBSTRING(@param3,(LEN('scp=')+1),(LEN(@param3)-LEN('scp=')))
	else
		set @subclientpolicyname = SUBSTRING(@param4,(LEN('scp=')+1),(LEN(@param4)-LEN('scp=')))
	select @scpid = bn.id, @scptype =
		case bp.attrVal
			when '2' then 'Windows'
			when '3' then 'Unix'
			when '4' then 'Netware'
		end
	from app_backupsetname bn inner join APP_BackupSetProp bp
	on bn.id = bp.componentNameId
	where bn.name = @subclientpolicyname and bp.attrName = 'Associated subclient Policy Ida Type' and bp.modified = 0
	if @scpid is null
	begin
		set @errorcode = 1
		set @errorstring = 'Error. subclient policy name ['+@subclientpolicyname +'] not valid'
		goto args_exit
	end
end
else
begin
	--disassociate,c=clientname,b=backupsetname
	if (@param2 not like 'c=%' or @param3 not like 'b=%')
	begin
		set @errorcode = 1
		set @errorstring = 'Error. c=Client name and b=backupset name must be specified'
		goto args_exit
	end
end
if @param2 like 'c=%'
begin
		set @clientname = SUBSTRING(@param2,(LEN('c=')+1),(LEN(@param2)-LEN('c=')))
		set @clientid = ISNULL((select id from APP_Client where name = @CLIENTNAME),0)
		if @clientid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Invalid client [' + @CLIENTNAME +'] passed'
			goto args_exit
		end
end
if @param3 like 'b=%'
begin
		--a. Filesystem bakcupset
		set @backupsetname = SUBSTRING(@param3,(LEN('b=')+1),LEN(@param3)-LEN('b='))
		set @backupsetid =  isnull((select distinct apl.backupSet
										from app_application apl inner join APP_BackupSetName bnm on bnm.id = apl.backupSet
										where apl.clientid = @clientid and bnm.name = @backupsetname and
										apl.appTypeId IN ( select apptypeid from app_idaname where clientid = @clientid and apptypeid in (select appTypeId  from APP_AppTypeGroupAssoc where appGroupId = 35))),0)
		if @backupsetid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Invalid backupset [' + @backupsetname +'] passed'
			goto args_exit
		end
end
if @param1 = 'associate'
begin
	--validation of input params--
	--2. Client group name/client name validity
	if @param2 like 'cg=%'
	begin
		set @CLIENTGROUPNAME = SUBSTRING(@param2,(LEN('cg=')+1),(LEN(@param2)-LEN('cg=')))
		set @clientgroupid = ISNULL((select id from APP_ClientGroup where name = @CLIENTGROUPNAME),0)
		if @clientgroupid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Invalid client group [' + @CLIENTGROUPNAME +'] passed'
			goto args_exit
		end
		--populate tempclients table with clients of this group
		insert into @tempclients (clientid)
				(select distinct clientid
				 from APP_ClientGroupAssoc
				 where clientGroupId = @clientgroupid)
	end
	else
		insert into @tempclients(clientid) values (@clientid)
	if not exists (select * from @tempclients)
	begin
		set @errorcode = 1
		set @errorstring = 'Error. Client group ['+ @clientgroupname +'] has no clients'
		goto args_exit
	end
	--Now in @tempclients table, delete all the clients for which the operatingsystemid is different from the @scptype
	declare clientcursor cursor static for
		select clientid from @tempclients
	open clientcursor
	fetch next from clientcursor into @clientid
	while @@FETCH_STATUS = 0
	begin
		if @scptype <> (select type from simOperatingSystem where id = (select simOperatingSystemId from APP_Client where id= @clientid))
			delete @tempclients where clientid = @clientid
		fetch next from clientcursor into @clientid
	end
	close clientcursor
	deallocate clientcursor
	if not exists (select * from @tempclients)
	begin
		if @param2 like 'c=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Client IDA does not match with subclient Policy type'
			goto args_exit
		end
		else
		begin
			set @errorcode = 1
			set @errorstring = 'Error. No client in the group specified has IDA same as that of subclient policy'
			goto args_exit
		end
	end
	--3. backupset name validity
	declare ccursor cursor static for
		select clientid from @tempclients
	open ccursor
	fetch next from ccursor into @clientid
	while @@FETCH_STATUS = 0
	begin
		if @param3 not like 'b=%'
		begin
			--Insert all the file system backupsets
			insert into @tempbackupsets (backupsetid)
				(select distinct apl.backupSet
				 from app_application apl inner join APP_BackupSetName bnm on bnm.id = apl.backupSet
				 where apl.clientid = @clientid and
					   apl.appTypeId IN ( select apptypeid from app_idaname where clientid = @clientid and apptypeid in (select appTypeId  from APP_AppTypeGroupAssoc where appGroupId = 35)))
		end
		else
			insert into @tempbackupsets (backupsetid) values (@backupsetid)
		fetch next from ccursor into @clientid
	end
	close ccursor
	deallocate ccursor
	if not exists (select * from @tempbackupsets)
	begin
		if @param2 like 'c=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Client has no file system backupsets'
			goto args_exit
		end
		if @param2 like 'cg=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Client group has no client with file system backupsets'
			goto args_exit
		end
	end
	--now form @tempbackupsets table, delete the invalid backupsets,i.e., those with subclient policy associated or those with user defined subclients
	declare bcursor cursor static for
		select backupsetid from @tempbackupsets
	open bcursor
	fetch next from bcursor into @backupsetid
	while @@FETCH_STATUS =0
	begin
		if exists (select * from APP_BackupSetProp where attrName = 'Associated subclient Policy' and componentNameId = @backupsetid and modified = 0) or
		exists (select * from APP_Application where backupSet = @backupsetid and subclientStatus = 0) or
		exists (select * from APP_BackupSetName where id = @backupsetid and ((status & 2 = 2) or (status & 128 = 128) or (status & 16 = 16))) or
		exists (select * from APP_BackupSetProp where componentNameId = @backupsetid and attrName = N'OnDemand Backupset' and attrVal = N'1' and modified = 0)
			delete @tempbackupsets where backupsetid = @backupsetid
		fetch next from bcursor into @backupsetid
	end
	close bcursor
	deallocate bcursor
	if not exists (select * from @tempbackupsets)
	begin
		if @param3 like 'b=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Backupset is either associated with a subclient policy or has user defined subclients or is deconfigured'
			goto args_exit
		end
		if @param2 like 'c=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error.All backupsets of this client are associated with either a subclient policy or has user defined subclients or deconfigured'
			goto args_exit
		end
		if @param2 like 'cg=%'
		begin
			set @errorcode = 1
			set @errorstring = 'Error. All backupsets of all clients in this group are associated with either a subclient policy or has user defined subclients or deconfigured'
			goto args_exit
		end
	end
	declare backupsetcursor cursor static for
		select backupsetid from @tempbackupsets
	open backupsetcursor
	fetch next from backupsetcursor into @backupsetid
	while @@FETCH_STATUS = 0
	begin
		exec AppAssocSubClientPolicy @backupsetid,@scpid,@currenttime
		set @backupsetname = (select name from app_backupsetname where id = @backupsetid)
		set @clientname = (select name from app_client where id = (select distinct clientid from app_application where backupset = @backupsetid))
		PRINT 'Associated backupset[' + @backupsetname
				+ '] of the client [' + @clientname
				+'] to the subclient policy [' + @subclientpolicyname +']'
		fetch next from backupsetcursor into @backupsetid
	end
end
--disassociation
else
begin
		set @scpid = isnull((select convert(int,attrval) from APP_BackupSetProp where componentNameId = @backupsetid and attrName = N'Associated Subclient Policy' and modified = 0),0)
		if @scpid = 0
		begin
			set @errorcode = 1
			set @errorstring = 'Error. Backupset [' + @backupsetname +']is not associated with any subclient policy'
			goto args_exit
		end
		set @subclientpolicyname = (select name from APP_BackupSetName where id = @scpid )
		--Create the subclient underneath the backupset
		DECLARE	GetSubclientsCursor CURSOR FOR
		SELECT id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus
		FROM APP_Application where backupset = @backupsetId
		OPEN GetSubclientsCursor
		FETCH next from GetSubclientsCursor INTO @subclientId, @ClientId, @AppTypeId ,@instanceId, @backupsetId, @appNumberId, @dataArchId,
									@logArchId, @refTime,   @modifiedTime, @scName, @scStatus
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			set @SCPId = 0
			set @createdTime  = 0
			Select @SCPId = convert(int,attrVal),  @createdTime = created from APP_SubClientProp where componentnameId = @subclientId and attrName = N'Associated subclient Policy' and modified = 0
			if (@SCPId > 0)
			BEGIN
					DECLARE @insertSCfile TABLE (type INTEGER, filename NVarChar(1024), created INTEGER, modified integer)
					DELETE @insertSCfile
					----Insert the subclient content into the associated subclient
 					Insert into @insertSCfile SELECT distinct  type, filename, created, modified from APP_scfilterfile where componentnameId = @SCPId and (modified = 0 OR created > @createdTime)
					update @insertSCfile set created = @createdTime where modified = 0 and created < @createdTime
					----Insert the subclient content into the associated subclient
 					INSERT into App_scfilterFile (componentNameId,type,fileName,created,modified)
						SELECT distinct @subclientId, type, filename, created, modified from @insertSCfile
					DECLARE @insertSCProp TABLE (attrName NVarChar(256), attrTYpe integer,  attrVal nvarchar(1024), created INTEGER, modified integer)
                    DELETE @insertSCProp
 					----Insert the subclient properties into the associated subclient
 					INSERT into @insertSCProp (attrName, attrType, attrVal, created, modified)
						SELECT distinct  attrName, attrType, attrVal, created, modified from APP_subclientprop where componentnameId = @SCPId  and (modified = 0 OR created > @createdTime)
					update @insertSCProp set created = @createdTime where modified = 0 and created < @createdTime
					/*****************************************************************************************************************
					If the properties are transferred to a 9.0 client, check for the property - Use VSS Options and Use VSS Enabled
					Based on these set the value Use Shadow Copy - Need to be removed once 9.0 is obsoleted'
					If Use VSS Enabled is 1 then set Use Shadow Copy to 1
					******************************************************************************************************************/
					IF (SELECT releaseId FROM APP_Client WHERE id = @ClientId) < 15
					BEGIN
						/*IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Enabled' AND modified = 0 AND attrVal = '0')
						BEGIN
							--Use VSS check box property is disabled. So 'Use shadow copy' is off irrespective of the 'Use VSS Options'
							UPDATE @insertSCProp
							SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '0'
							WHERE attrName = 'Use VSS Enabled' AND modified = 0
						END
						IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Enabled' AND modified = 0 AND attrVal = '1')
						BEGIN
							IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Options' AND modified = 0 AND attrVal = '1')
							BEGIN
								--Use Shadow Copy has been selected explicitly
								UPDATE @insertSCProp
								SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '1'
								WHERE attrName = 'Use VSS Options' AND modified = 0
							END
							ELSE IF NOT EXISTS(SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Options')
							BEGIN
								--By default also, if 'Use VSS Enabled' then 'Use For all files' is ON, meaning 'Use Shadow Copy' is ON
								UPDATE @insertSCProp
								SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '1'
								WHERE attrName = 'Use VSS Enabled' AND modified = 0
							END
							ELSE IF EXISTS (SELECT * FROM @insertSCProp WHERE attrName = 'Use VSS Options' AND modified = 0 AND attrVal <> '1')
							BEGIN
								--Some other value has been selected, with 'Use VSS Enabled' on, so Use shadow copy is off
								UPDATE @insertSCProp
								SET attrName = 'Use Shadow Copy', attrType = '2', attrVal = '0'
								WHERE attrName = 'Use VSS Options' AND modified = 0
							END
						END*/
						UPDATE @insertSCProp
						SET attrName = 'Use Shadow Copy'
						WHERE attrName = 'Use VSS Enabled' AND modified = 0
						--If Use VSS Enabled does not exist, then no need to do any change. Use Shadow Copy will be OFF by default.
						DELETE FROM @insertSCProp
						WHERE (attrName = 'Use VSS Enabled' OR attrName = 'Use VSS Options')
					END
					/***********************************************************************************************************************************/
 					Insert into APP_subclientProp(componentNameId,attrName,attrType,attrVal,created,modified)
						SELECT distinct @subclientId, attrName, attrType, attrVal, created, modified from @insertSCProp
					Update APP_SubClientProp set modified = @currenttime where componentnameId = @subclientid  and attrName = N'Associated subclient Policy' and modified = 0
			END
			FETCH next from GetSubclientsCursor INTO @subclientId, @ClientId, @AppTypeId ,@instanceId, @backupsetId, @appNumberId, @dataArchId,
									@logArchId, @refTime,   @modifiedTime, @scName, @scStatus
		END
		CLOSE GetSubclientsCursor
		DEALLOCATE GetSubclientsCursor
		--Remove the association in backupset prop
		Update APP_BackupSetProp set modified = @currenttime where componentnameId = @backupsetid  and attrName = N'Associated subclient Policy' and modified = 0
		PRINT 'Disassociated backupset ['+ @backupsetname +'] of client [' + @clientname + '] from subclient policy [' + @subclientpolicyname +'].'
END
args_exit:
delete @tempclients
delete @tempbackupsets
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_modifysubclientpolicy')
	delete from GxQscripts where name = 'QS_modifysubclientpolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_modifysubclientpolicy')
	delete from GXDBVersions where aliasname = 'QS_modifysubclientpolicy'
GO

insert into GXDBVersions values(2, 'QS_modifysubclientpolicy',  '00000000000000000000', 'QS_modifysubclientpolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_modifysubclientpolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	For Association
'
 + CHAR(10) + '	qoperation execscript sn modifysubclientpolicy si associate si cg=client_group_name -si scp=subclient_policy_name
'
 + CHAR(10) + '	qoperation execscript sn modifysubclientpolicy si associate si c=client_name -si scp=subclient_policy_name
'
 + CHAR(10) + '	qoperation execscript sn modifysubclientpolicy si associate si c=client_name -si b=backupsetname -si scp=subclient_policy_name
'
 + CHAR(10) + '	For disassociation
'
 + CHAR(10) + '	qoperation execscript sn modifysubclientpolicy si disassociate si c=client_name si b=backupsetname 
'
 + CHAR(10) + '-- 	script_name: modifysubclientpolicy'
 + CHAR(10) + '-- 	Associate or disassociate a subclient policy to backupset(s)'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateOperationWindowRule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_createoperationwindowrule <<<'

IF EXISTS (select * from sysobjects where name='QS_createoperationwindowrule')
	drop procedure QS_createoperationwindowrule
IF EXISTS (select * from GxQscripts where name='QS_createoperationwindowrule')
	delete from GxQscripts where name = 'QS_createoperationwindowrule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_createoperationwindowrule')
	delete from GXDBVersions where aliasname = 'QS_createoperationwindowrule'
GO
print '... Creating Procedure: QS_createoperationwindowrule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_createoperationwindowrule
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS NVARCHAR(512) = '',
  @param2 AS NVARCHAR(512) = '',
  @param3 AS NVARCHAR(512) = '',
  @param4 AS NVARCHAR(512) = '',
  @param5 AS NVARCHAR(512) = '',
  @param6 AS NVARCHAR(512) = '',
  @param7 AS NVARCHAR(512) = '',
  @param8 AS NVARCHAR(512) = '',
  @param9 AS NVARCHAR(512) = '',
  @param10 AS NVARCHAR(512) = ''
AS
DECLARE @clientOrGroupName		NVARCHAR(MAX) = ''
DECLARE @clientOrGroupNameValue	NVARCHAR(MAX) = ''
DECLARE @clientId				INT = 0
DECLARE @clientGroupId			INT = 0
DECLARE @opTypeId		INT = 0
DECLARE @daysOfWeekId	INT = 0
DECLARE @startDateValue	INT = 0
DECLARE @endDateValue	INT = 0
DECLARE @startTimeValue	INT = 0
DECLARE @endTimeValue	INT = 0
DECLARE @enableValue	INT = 0
DECLARE @utilization	INT	= 100
DECLARE @appTypeId		INT = 0
DECLARE @description	NVARCHAR(MAX) = ''
DECLARE @GMTTime		INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @clientTime		INT = 0
DECLARE @timeOffSet		INT = 0
DECLARE @clientTimeZone	NVARCHAR(MAX) = ''
DECLARE @errorcode as INT = 0
DECLARE @errorstring as NVARCHAR(MAX) = 'Successful'
IF @param1 NOT LIKE 'c=%' AND @param1 NOT LIKE 'cg=%' AND @param1 != 'commserve'
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is [' + @param1 + '], it must be ''c=client name'' OR ''cg=client group name'' OR ''commserve'' '
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		SET @clientOrGroupNameValue = SUBSTRING(@param1, (CHARINDEX('=', @param1) + 1 ), (LEN(@param1) - CHARINDEX('=', @param1)))
		IF @param1 LIKE 'c=%'
			BEGIN
				SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @clientOrGroupNameValue), 0)
				IF @clientId = 0
				BEGIN
					SET		@errorstring = 'Error: First parameter client name ''c=' + @clientOrGroupNameValue + ''' is not correct. Please give correct client name.'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
				SET @clientTimeZone	= dbo.GetClientTimeZone(@clientId)
			END
		ELSE IF @param1 LIKE 'cg=%'
			BEGIN
				SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup where name = @clientOrGroupNameValue), 0)
				IF @clientGroupId = 0
				BEGIN
					SET		@errorstring = 'Error: First parameter client group name ''cg=' + @clientOrGroupNameValue + ''' is not correct. Please give correct client group name.'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
				SET @clientTimeZone	= dbo.GetClientTimeZone(2)
			END
		ELSE IF @param1 = 'commserve'
			BEGIN
				SET @clientId = 2
				SET @appTypeId = 1000
				SET @clientTimeZone	= dbo.GetClientTimeZone(@clientId)
			END
	END
--@GMTTime means now time at GMT.
--@clientTime means now time at client machine.
SET @clientTime = dbo.getunixtime(dbo.UTCToLocalTime(dbo.getdatetime(@GMTTime), @clientTimeZone))
SET @timeOffSet = (@GMTTime - @clientTime)
--Validate second parameter of operation type
IF @param2 = 'all'
	SET @opTypeId = 57087
ELSE IF @param2 = 'backup'
	SET @opTypeId = 7
ELSE IF @param2 = 'restore'
	SET @opTypeId = 8
ELSE IF @param2 = 'admin'
	SET @opTypeId = 57072
ELSE
	BEGIN
		SET		@errorstring = 'Error: Second parameter [' + @param2 + '] is not correct. Valid operation names are [all / backup / restore / admin].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate third parameter, day of week
DECLARE @length INT = 0
DECLARE @pos INT = 0
DECLARE @daysOfWeekName NVARCHAR(MAX) = ''
DECLARE @OriginalParam3 NVARCHAR(MAX) = @param3
SET @daysOfWeekId = 0
SET @length = LEN(@param3)
WHILE @length > 0
BEGIN
	SET @pos = PATINDEX('%,%', @param3)
	IF (@pos <> 0)
		BEGIN
			SET @daysOfWeekName = SUBSTRING(@param3, 0, @pos)
			SET @param3 = SUBSTRING(@param3, @pos+1, @length)
			SET @length = LEN(@param3)
		END
	ELSE
		BEGIN
			SET @daysOfWeekName = SUBSTRING(@param3, @pos+1, @length)
			SET @length = 0
		END
	SET @daysOfWeekName = REPLACE( @daysOfWeekName, ' ', '')
	IF @daysOfWeekName = 'Sunday'
		SET @daysOfWeekId |= 1
	ELSE IF @daysOfWeekName = 'Monday'
		SET @daysOfWeekId |= 2
	ELSE IF @daysOfWeekName = 'Tuesday'
		SET @daysOfWeekId |= 4
	ELSE IF @daysOfWeekName = 'Wednesday'
		SET @daysOfWeekId |= 8
	ELSE IF @daysOfWeekName = 'Thursday'
		SET @daysOfWeekId |= 16
	ELSE IF @daysOfWeekName = 'Friday'
		SET @daysOfWeekId |= 32
	ELSE IF @daysOfWeekName = 'Saturday'
		SET @daysOfWeekId |= 64
	ELSE
		BEGIN
			SET		@errorstring = 'Error: Third parameter [' + @OriginalParam3 + '], has invalid day of the week[' + @daysOfWeekName + ']. Valid days of weeks are comma separated[Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday].'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
END
IF @daysOfWeekId = 0
BEGIN
	SET		@errorstring = 'Error: Third parameter [' + @OriginalParam3 + '] is not correct. Valid days of week are comma separated[Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday].'
	SET		@errorcode = 1
	GOTO	ARGS_ERROR
END
--Validate fourth parameter, start date
IF ISDATE (@param4) = 1
	SET @startDateValue = CAST( (SELECT dbo.GetUnixTime(@param4)) AS INT)
ELSE
	BEGIN
		SET		@errorstring = 'Error: Fourth parameter [' + @param4 + '] is not correct. Please give valid start date as[MM-DD-YYYY].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
SET @startDateValue = (@startDateValue + @timeOffSet)
--Validate fifth parameter, end date
IF ISDATE (@param5) = 1
BEGIN
	SET @endDateValue = CAST( (SELECT dbo.GetUnixTime(@param5)) AS INT)
	SET @endDateValue = @endDateValue + @timeOffSet
	IF @endDateValue < @startDateValue
	BEGIN
		SET		@errorstring = 'Error: End date[' + @param5 + '] must be greater than start date[' + @param4 + ']'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
END
ELSE
	BEGIN
		SET		@errorstring = 'Error: Fifth parameter [' + @param5 + '] is not correct. Please give valid end date as[MM-DD-YYYY].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate sixth parameter, start time
IF ISDATE(@param6) = 1
	BEGIN
		DECLARE @startTimeConverted DATETIME = CONVERT(datetime, @param6, 108)
		DECLARE @startHour	INT = DATEPART ( HOUR, @startTimeConverted )
		DECLARE @startMin	INT = DATEPART ( MINUTE, @startTimeConverted )
		SET @startTimeValue = CAST( (@startHour * 3600) + (@startMin * 60) AS INT)
	END
ELSE
	BEGIN
		SET		@errorstring = 'Error: Sixth parameter [' + @param6 + '] is not correct. Please give start time as [HH:MM] 24 hr format.'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate seventh parameter, end time
IF ISDATE(@param7) = 1
	BEGIN
		DECLARE @endTimeConverted DATETIME = CONVERT(datetime, @param7, 108)
		DECLARE @endHour	INT = DATEPART ( HOUR, @endTimeConverted )
		DECLARE @endMin		INT = DATEPART ( MINUTE, @endTimeConverted )
		SET @endTimeValue = CAST( (@endHour * 3600) + (@endMin * 60) AS INT)
	END
ELSE
	BEGIN
		SET		@errorstring = 'Error: Seventh parameter [' + @param7 + '] is not correct. Please give end time as [HH:MM] 24 hr format.'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate eighth parameter, enable
IF @param8 = 'true'
	SET @enableValue = 1
ELSE IF @param8 = 'false'
	SET @enableValue = 0
ELSE
	BEGIN
		SET		@errorstring = 'Error: Eighth parameter [' + @param8 + '] is not correct. Please give correct value of enable[true/false].'
		SET		@errorcode = 1
		GOTO	ARGS_ERROR
	END
--Validate ninth parameter, ApptypeName
IF @param1 = 'commserve'
	BEGIN
		SET @appTypeId = 1000
	END
ELSE IF @param9 = '' OR @clientId = 0
	BEGIN
		SET @appTypeId = 0
	END
ELSE
	BEGIN
		SET @appTypeId=(select type from app_IDAType where name=@param9 AND type IN (select appTypeId from APP_Application where clientId = @clientId))
		IF  @appTypeId IS NULL
		BEGIN
			SET @appTypeId = (SELECT appTypeId FROM app_idaname
										WHERE clientid = @clientId
												AND appTypeId IN (SELECT DISTINCT appTypeId FROM simAppTypeLicTypeMap
												WHERE display_name = @param9))
		END
		IF  @appTypeId IS NULL
		BEGIN
			SET @appTypeId = (SELECT DISTINCT TOP 1 appTypeId FROM simAppTypeLicTypeMap
												WHERE display_name = @param9)
		END
		IF @appTypeId IS NULL
		BEGIN
			SET		@errorstring = 'Error: Ninth parameter Application name [' + @param9 + '] is not correct. Please give correct application name.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
	END
--10th parameter
SET	@description = @param10
BEGIN TRAN
BEGIN TRY
	DECLARE @ruleId INT = ISNULL((Select MAX(id) from APP_OpWindowRule),0)
	IF @ruleId != 0
		SET @ruleId = @ruleId + 1
	ELSE
		SET @ruleId = 1
	INSERT APP_OpWindowRule (id, clientId,appTypeId, opType, daysOfWeek, startTime, endTime, enable, description, utilization, clientGroupId, instanceId, backupsetId, subclientId, startDate, endDate)
	VALUES (@ruleId, @clientId, @appTypeId, @opTypeId, @daysOfWeekId, @startTimeValue, @endTimeValue, @enableValue, @description, @utilization, @clientGroupId, 0, 0, 0, @startDateValue, @endDateValue)
	PRINT 'Successfully created operation window rule.'
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateOperationWindowRule')
	delete from GxQscripts where name = 'QS_CreateOperationWindowRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateOperationWindowRule')
	delete from GXDBVersions where aliasname = 'QS_CreateOperationWindowRule'
GO

insert into GXDBVersions values(2, 'QS_CreateOperationWindowRule',  '00000000000000000000', 'QS_CreateOperationWindowRule', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateOperationWindowRule',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ClientName/ClientGroupName/commserve -si OperationType -si DayofWeek -si Startdate -si Enddate -si StartTime -si EndTime -si Enable -si ApplicationName -si Description
'
 + CHAR(10) + '	Where 	(ClientName/ClientGroupName/commserve) would be ''c=testclient'' for client name OR ''cg=testGroup'' for client group name OR ''commserve''
'
 + CHAR(10) + '			OperationType	Operation types are ''all / backup / restore / admin''
'
 + CHAR(10) + '			DayOfWeek		Day of the week are comma separated[Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday]
'
 + CHAR(10) + '			StartDate		Format is MM-DD-YYYY
'
 + CHAR(10) + '			EndDate			Format is MM-DD-YYYY
'
 + CHAR(10) + '			StartTime		Format is 24 hrs HH:MM
'
 + CHAR(10) + '			EndTime			Format is 24 hrs HH:MM
'
 + CHAR(10) + '			Enable			true/false
'
 + CHAR(10) + '			ApplicationName	Optional parameter, Application name
'
 + CHAR(10) + '			Description		Optional parameter, Description of Operation Window
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''c=clientname'' -si ''backup'' -si ''Monday, Wednesday, Friday'' -si ''04-20-2012'' -si ''04-21-2013'' -si ''09:00'' -si ''18:00'' -si true -si '''' -si ''Test Description, client backup''
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''c=clientname'' -si ''restore'' -si ''Tuesday, Thursday, Saturday'' -si ''04-20-2012'' -si ''04-21-2013'' -si ''09:00'' -si ''18:00'' -si true -si ''File system'' -si ''Test Description, client restore''
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''commserve'' -si ''restore'' -si ''Tuesday, Thursday, Saturday'' -si ''04-20-2012'' -si ''04-21-2013'' -si ''09:00'' -si ''18:00'' -si true -si '''' -si ''Test Description, commserve restore''
'
 + CHAR(10) + '	qoperation execscript -sn createoperationwindowrule -si ''cg=clientgroupname'' -si ''all'' -si Saturday -si ''04-20-2012'' -si ''04-20-2013'' -si ''09:00'' -si ''18:00'' -si true -si '''' -si ''Test Description, client group all operation''
'
 + CHAR(10) + '-- 	script_name: createoperationwindowrule'
 + CHAR(10) + '-- 	Create operation window rule'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_CreateScheduleHoliday.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_createscheduleholiday <<<'

IF EXISTS (select * from sysobjects where name='QS_createscheduleholiday')
	drop procedure QS_createscheduleholiday
IF EXISTS (select * from GxQscripts where name='QS_createscheduleholiday')
	delete from GxQscripts where name = 'QS_createscheduleholiday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_createscheduleholiday')
	delete from GXDBVersions where aliasname = 'QS_createscheduleholiday'
GO
print '... Creating Procedure: QS_createscheduleholiday'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_createscheduleholiday
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @param1 AS NVARCHAR(512) = '',
  @param2 AS NVARCHAR(512) = '',
  @param3 AS NVARCHAR(512) = '',
  @param4 AS NVARCHAR(512) = ''
AS
DECLARE @clientId		INT = 0
DECLARE @groupId		INT = 0
DECLARE @vtPolicyId		INT = 0
DECLARE @vtPolicyName	VARCHAR(MAX) = ''
DECLARE @startYear		INT = 0
DECLARE @startMonth		INT = 0
DECLARE @startDay		INT = 0
DECLARE @startHour		INT = 0
DECLARE @startMinute	INT = 0
DECLARE @startSecond	INT = 0
DECLARE @endYear		INT = 0
DECLARE @endMonth		INT = 0
DECLARE @endDay			INT = 0
DECLARE @endHour		INT = 0
DECLARE @endMinute		INT = 0
DECLARE @endSecond		INT = 59
DECLARE @yearly			INT = 0
DECLARE @errorcode as INT = 0
DECLARE @errorstring as NVARCHAR(MAX) = 'Successful'
--Validate first parameter, client name
IF @param1 = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is empty, it must be client name/commserve.'
		GOTO ARGS_ERROR
	END
ELSE IF @param1 = 'commserve'
	BEGIN
		SET @clientId = 0
		SET @groupId = 0
		SET @vtPolicyId = 0
	END
ELSE IF @param1 LIKE 'pn=%'
	BEGIN
		SET @vtPolicyName = SUBSTRING(@param1, (CHARINDEX('=', @param1) + 1 ), (LEN(@param1) - CHARINDEX('=', @param1)))
		SET @vtPolicyId = ISNULL((SELECT PolicyId FROM VTPolicy where PolicyName = @vtPolicyName), 0)
		IF @vtPolicyId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter policy name ''' + @param1 + ''' is not correct. Please give correct policy name.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
		SET @clientId = 0
		SET @groupId = 0
	END
ELSE
	BEGIN
		SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @param1), 0)
		IF @clientId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter client name/commserve[' + @param1 + ']not correct. Please give valid client name/commserve.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
		--Identify Client Group id
		--SET @groupId = ISNULL((SELECT TOP(1) clientGroupId FROM APP_ClientGroupAssoc where clientId = @clientId), 0)
	END
--Validate second parameter, start date
IF @param2 = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: Second parameter start date is empty, please give valid start date [MM-DD-YYYY].'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF ISDATE(@param2) = 1
			BEGIN
				DECLARE @startDateConverted DATETIME = CONVERT(datetime, @param2, 110)
				SET @startYear = DATEPART ( YEAR, @startDateConverted )
				SET @startMonth = CAST( DATEPART ( MONTH, @startDateConverted ) - 1 AS INT)
				SET @startDay = DATEPART ( DAY, @startDateConverted )
				IF @startDateConverted < CONVERT(datetime, (SELECT CONVERT(char(10), GetDate(),126)), 110)
				BEGIN
					SET		@errorstring = 'Error: Second parameter start date[' + @param2 + '] is already passed. Please give valid start date.'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
			END
		ELSE
			BEGIN
				SET		@errorstring = 'Error: Second parameter start date[' + @param2 + '] is not correct or it is not in format[MM-DD-YYYY], please give valid start date.'
				SET		@errorcode = 1
				GOTO	ARGS_ERROR
			END
	END
--Validate third parameter, end date
IF @param3 = ''
	BEGIN
		SET @endYear = @startYear
		SET @endMonth = @startMonth
		SET @endDay = @startDay	+ 1
	END
ELSE
	BEGIN
		IF ISDATE(@param3) = 1
			BEGIN
				DECLARE @endDateConverted DATETIME = CONVERT(datetime, @param3, 110)
				SET @endYear = DATEPART ( YEAR, @endDateConverted )
				SET @endMonth = CAST( DATEPART ( MONTH, @endDateConverted ) - 1 AS INT)
				SET @endDay = DATEPART ( DAY, @endDateConverted )
				IF @endDateConverted < @startDateConverted
				BEGIN
					SET		@errorstring = 'Error: End date[' + @param3 + '] must be greater than start date[' + @param2 + ']'
					SET		@errorcode = 1
					GOTO	ARGS_ERROR
				END
			END
		ELSE
			BEGIN
				SET		@errorstring = 'Error: third parameter end date[' + @param3 + '] is not correct or it is not in format[MM-DD-YYYY], please give valid end date.'
				SET		@errorcode = 1
				GOTO	ARGS_ERROR
			END
	END
-- Validate fourth parameter, yearly input
IF @param4 = ''
	BEGIN
		-- Optional parameter, do nothing
		SET @yearly = 0
	END
ELSE
	BEGIN
		IF @param4 NOT IN ('true', 'false')
		BEGIN
			SET		@errorstring = 'Error: fourth parameter, yearly [' + @param4 + '] is not correct or it is not in format[true/false], please give correct input for yearly.'
			SET		@errorcode = 1
			GOTO	ARGS_ERROR
		END
		IF @param4 = 'true'
			BEGIN
				SET @startYear = 0
				SET @endYear = 0
			END
	END
----------------------------------------------
--Validation done, add operation window rule--
----------------------------------------------
BEGIN TRAN
BEGIN TRY
		IF EXISTS( SELECT * FROM SchedHoliday WHERE startYear = @startYear
												AND startMonth = @startMonth
												AND startDay = @startDay
												AND startHour = @startHour
												AND startMinute = @startMinute
												AND startSecond = @startSecond
												AND endYear = @endYear
												AND endMonth = @endMonth
												AND endDay = @endDay
												AND endHour = @endHour
												AND endMinute = @endMinute
												AND endSecond = @endSecond
												AND clientId = @clientId
												AND groupId = @groupId
												AND vtPolicyId = @vtPolicyId)
			BEGIN
				UPDATE SchedHoliday SET modified = dbo.GetUnixTime (GetUTCdate())
				WHERE startYear = @startYear
													AND startMonth = @startMonth
													AND startDay = @startDay
													AND startHour = @startHour
													AND startMinute = @startMinute
													AND startSecond = @startSecond
													AND endYear = @endYear
													AND endMonth = @endMonth
													AND endDay = @endDay
													AND endHour = @endHour
													AND endMinute = @endMinute
													AND endSecond = @endSecond
													AND clientId = @clientId
													AND groupId = @groupId
													AND vtPolicyId = @vtPolicyId
				PRINT 'Duplicate Schedule holiday is available.'
			END
		ELSE
			BEGIN
				INSERT SchedHoliday(startYear, startMonth, startDay, startHour, startMinute, startSecond, endYear, endMonth, endDay, endHour, endMinute, endSecond, modified, description, clientId, groupId, vtPolicyId)
				VALUES (@startYear, @startMonth, @startDay, @startHour, @startMinute, @startSecond, @endYear, @endMonth, @endDay, @endHour, @endMinute, @endSecond, dbo.GetUnixTime (GetUTCdate()),'', @clientId, @groupId, @vtPolicyId)
				PRINT 'Successfully created Schedule holiday.'
			END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_CreateScheduleHoliday')
	delete from GxQscripts where name = 'QS_CreateScheduleHoliday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_CreateScheduleHoliday')
	delete from GXDBVersions where aliasname = 'QS_CreateScheduleHoliday'
GO

insert into GXDBVersions values(2, 'QS_CreateScheduleHoliday',  '00000000000000000000', 'QS_CreateScheduleHoliday', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_CreateScheduleHoliday',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ClientName/commserve/pn=<PolicyName> -si Startdate -si Enddate -si Yearly
'
 + CHAR(10) + '	Where 	(ClientName/commserve/pn=<PolicyName>) would be ''NameOfClient'' for client name OR ''commserve'' OR Policy Name.
'
 + CHAR(10) + '			StartDate		Format is MM-DD-YYYY
'
 + CHAR(10) + '			EndDate			Optional parameter, format is MM-DD-YYYY
'
 + CHAR(10) + '			Yearly			Optional parameter, true/false
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''ClientName'' -si ''04-10-2012''
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''ClientName'' -si ''04-10-2012'' -si ''04-11-2012''
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''ClientName'' -si ''04-10-2012'' -si ''04-11-2012'' -si false
'
 + CHAR(10) + '	qoperation execscript -sn createscheduleholiday -si ''pn=<PolicyName>'' -si ''04-10-2012''
'
 + CHAR(10) + '-- 	script_name: createscheduleholiday'
 + CHAR(10) + '-- 	Create Schedule holiday'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetExchangeDBIDAProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetExchangeDBIDAProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetExchangeDBIDAProp')
	drop procedure QS_SetExchangeDBIDAProp
IF EXISTS (select * from GxQscripts where name='QS_SetExchangeDBIDAProp')
	delete from GxQscripts where name = 'QS_SetExchangeDBIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetExchangeDBIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetExchangeDBIDAProp'
GO
print '... Creating Procedure: QS_SetExchangeDBIDAProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetExchangeDBIDAProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @clientName AS NVARCHAR(MAX) = '',
  @userName AS NVARCHAR(MAX) = '',
  @password AS NVARCHAR(MAX) = '',
  @backupType AS NVARCHAR(MAX) = '',
  @useVss AS NVARCHAR(MAX) = '',
  @backupFromReplica AS NVARCHAR(MAX) = '',
  @backupOnActiveNode AS NVARCHAR(MAX) = '',
  @serverName AS NVARCHAR(MAX) = '',
  @copyBackup AS NVARCHAR(MAX) = ''
AS
DECLARE @errorcode		AS	INT = 0
DECLARE @errorstring	AS	NVARCHAR(MAX) = 'Successful'
DECLARE @TRUE			AS	INT = 1
DECLARE @FALSE			AS	INT = 0
DECLARE @clientId		AS	INT = 0
DECLARE @idaId			AS	INT = 0
DECLARE @subclientId	AS	INT = 0
DECLARE @instanceId		AS	INT = 0
DECLARE @ibackupType		AS	INT = 0
DECLARE @existingBackupType	AS INT = 0
DECLARE @iuseVSS			AS	INT = 0
DECLARE	@iBackupFromReplica	AS INT = 0
DECLARE @iBackupOnActiveNode	AS INT = 0
DECLARE @icopyBackup		AS	INT = 0
DECLARE @qs_resultTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
--Validate first parameter, client name
IF @clientName = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is empty, it must be client name.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @clientName), 0)
		IF @clientId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter client name[' + @clientName + '] not correct. Please give valid client name.'
			SET		@errorcode = 2
			GOTO	ARGS_ERROR
		END
		SET @idaId = ISNULL((SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = 53), 0)
		IF @idaId = 0
		BEGIN
			SET		@errorstring = 'Error: Exchange IDA is not installed on client [' + @clientName + '].'
			SET		@errorcode = 3
			GOTO	ARGS_ERROR
		END
		SET @subclientId = ISNULL((SELECT id from APP_Application WHERE clientId = @clientId AND appTypeId = 53 AND subclientName = 'default' AND (subclientStatus & 0x8) = 0x8), 0)
		SET @instanceId = ISNULL((SELECT instance from APP_Application WHERE clientId = @clientId AND appTypeId = 53 AND subclientName = 'default' AND (subclientStatus & 0x8) = 0x8), 0)
	END
--Validate second parameter, user name
IF @userName = ''
BEGIN
	SET @errorcode = 4
	SET @errorstring = 'Error: Second parameter user name is empty, please give user name.'
	GOTO ARGS_ERROR
END
--Validate third parameter, password
IF @password = ''
	BEGIN
		SET @errorcode = 5
		SET @errorstring = 'Error: Third parameter password is empty, please give password.'
		GOTO ARGS_ERROR
	END
--ELSE
--	BEGIN
--		IF SUBSTRING (@password, 1, 1) != '2'
--		BEGIN
--			SET @errorcode = 6
--			SET @errorstring = 'Error: Third parameter password is not in p2 format, please give thrid parameters as -p2 <password>.'
--			GOTO ARGS_ERROR
--		END
--	END
--Validate fourth parameter, Backup Type
IF @backupType = ''
	BEGIN
		SET @errorcode = 7
		SET @errorstring = 'Error: Fourth parameter backup type is empty, it must be(Incremental / Differential) .'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @backupType = 'Incremental'
			SET @ibackupType = 2
		ELSE IF @backupType = 'Differential'
			SET @ibackupType = 4
		ELSE
			BEGIN
				SET @errorcode = 8
				SET @errorstring = 'Error: Fourth parameter is [' + @backupType + '], it must be (Incremental / Differential) .'
				GOTO ARGS_ERROR
			END
	END
--Validate fifth parameter, Use Vss
IF @useVss = ''
	BEGIN
		SET @errorcode = 9
		SET @errorstring = 'Error: Fifth parameter Use Vss is empty, it must be true / false.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @useVss = 'true'
			SET @iuseVSS = @TRUE
		ELSE IF @useVss = 'false'
			SET @iuseVSS = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 10
				SET @errorstring = 'Error: Fifth parameter Use Vss is [' + @useVss + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
	END
--Validate sixth parameter, BackupFromReplica
IF @backupFromReplica = ''
	BEGIN
		SET @errorcode = 11
		SET @errorstring = 'Error: Sixth parameter BackupFromReplica is empty, it must be true / false.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @backupFromReplica = 'true'
			SET @iBackupFromReplica = @TRUE
		ELSE IF @backupFromReplica = 'false'
			SET @iBackupFromReplica = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 12
				SET @errorstring = 'Error: Sixth parameter BackupFromReplica is [' + @backupFromReplica + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
		IF @iuseVSS = @FALSE AND @iBackupFromReplica = @TRUE
		BEGIN
			SET @errorcode = 13
			SET @errorstring = 'Error: Fifth parameter UseVss is false, so sixth parameter BackupFromReplica should be false'
			GOTO ARGS_ERROR
		END
	END
--Validate seventh parameter, BackupOnActiveNode
IF @backupOnActiveNode = ''
	BEGIN
		SET @errorcode = 14
		SET @errorstring = 'Error: Seventh parameter BackupOnActiveNode is empty, it must be true / false.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @backupOnActiveNode = 'true'
			SET @iBackupOnActiveNode = @TRUE
		ELSE IF @backupOnActiveNode = 'false'
			SET @iBackupOnActiveNode = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 15
				SET @errorstring = 'Error: Seventh parameter BackupOnActiveNode is [' + @backupOnActiveNode + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
		IF ( @iuseVSS = @FALSE OR @iBackupFromReplica = @FALSE ) AND @iBackupOnActiveNode = @TRUE
		BEGIN
			SET @errorcode = 16
			SET @errorstring = 'Error: Fifth parameter UseVss is ' + @useVss + ' and sixth parameter BackupFromReplica is ' + @backupFromReplica + ', so seventh parameter BackupOnActiveNode should be false. BackupOnActiveNode can be true if both UseVss and BackupFromReplica are true.'
			GOTO ARGS_ERROR
		END
	END
--Validate eigth parameter, ServerName
IF @serverName = ''
	BEGIN
		SET @errorcode = 17
		SET @errorstring = 'Error: Eigth parameter ServerName is empty, please give valid server name.'
		GOTO ARGS_ERROR
	END
--Validate ninth parameter, Copy Backup
IF @copyBackup = ''
	BEGIN
		SET @errorcode = 18
		SET @errorstring = 'Error: Ninth parameter copy Backup is empty, it should be (true/false).'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		IF @copyBackup = 'true'
			SET @icopyBackup = @TRUE
		ELSE IF @copyBackup = 'false'
			SET @icopyBackup = @FALSE
		ELSE
			BEGIN
				SET @errorcode = 19
				SET @errorstring = 'Error: Nineth parameter Copy Backup is [' + @copyBackup + '], it must be true / false.'
				GOTO ARGS_ERROR
			END
	END
-----------------------------------------------
--Validation done, add User Name and Password--
-----------------------------------------------
BEGIN TRAN
BEGIN TRY
	--Set Server Name-------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertInstanceProp @instanceId, 0, 0, 'Server Name', 1, @serverName
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set User Name----------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertInstanceProp @instanceId, 0, 0, 'User Name', 1, @userName
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Password-----------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertInstanceProp @instanceId, 0, 0, 'User Password', 1, @password
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Use Vss------------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Use Snapshot Writer', 2, @iuseVSS
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set backup from replica------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Backup From Replica', 2, @iBackupFromReplica
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set backup on active node----------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Continue Backups From Replica After Failover', 2, @iBackupOnActiveNode
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Copy Backup--------------------------------------------------------------------------------------------------
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertIdaProp @idaId, 1, 0, 'Copy Backup Enabled', 2, @icopyBackup
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	--Set Backup Level-------------------------------------------------------------------------------------------------
	SET @existingBackupType = ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId  = @subclientId AND attrName = 'Backup Level' AND modified = 0), 0)
	INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertSubClientProp @subclientId, 1, 0, 'Backup Level', 7, @ibackupType
	SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
	IF @errorcode <> 0
	BEGIN
		SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
		GOTO SKIP
	END
	DELETE FROM @qs_resultTbl;
	-------------------------------------------------------------------------------------------------------------------
	IF @existingBackupType != @ibackupType
	BEGIN
		--Force next backup to full------------------------------------------------------------------------------------
		INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertSubClientProp @subclientId, 0, 0, 'turbo:last incr', 8, 0
		SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
		IF @errorcode <> 0
		BEGIN
			SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
			GOTO SKIP
		END
		DELETE FROM @qs_resultTbl;
		---------------------------------------------------------------------------------------------------------------
		--Force next backup to full------------------------------------------------------------------------------------
		INSERT INTO @qs_resultTbl EXEC	dbo.AppInsertSubClientProp @subclientId, 0, 0, 'turbo:last full', 8, 0
		SET @errorcode = ISNULL((SELECT errCode FROM @qs_resultTbl), 0)
		IF @errorcode <> 0
		BEGIN
			SET @errorstring = ISNULL((SELECT errString FROM @qs_resultTbl), '')
			GOTO SKIP
		END
		DELETE FROM @qs_resultTbl;
		---------------------------------------------------------------------------------------------------------------
	END
	print 'Successfully set properties.'
SKIP:
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetExchangeDBIDAProp')
	delete from GxQscripts where name = 'QS_SetExchangeDBIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetExchangeDBIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetExchangeDBIDAProp'
GO

insert into GXDBVersions values(2, 'QS_SetExchangeDBIDAProp',  '00000000000000000000', 'QS_SetExchangeDBIDAProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetExchangeDBIDAProp',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetExchangeDBIDAProp -si @clientName=''Client Name'' -si @userName=''User Name'' -p2 @password=''Password'' -si @backupType=''Incremental'' -si @useVss=''true'' -si @backupFromReplica=''true'' -si @backupOnActiveNode=''true'' -si @serverName=''Server Name'' -si @copyBackup=''true''
'
 + CHAR(10) + '	Where 	ClientName		would be client name.
'
 + CHAR(10) + '			UserName		User name to be set for IDA
'
 + CHAR(10) + '			Password		Password to be set for IDA.
'
 + CHAR(10) + '			BackupType		Incremental / Differential
'
 + CHAR(10) + '			UseVss			true / false
'
 + CHAR(10) + '			BackupFromReplica	true / false
'
 + CHAR(10) + '			BackupOnActiveNode	true / false
'
 + CHAR(10) + '			ServerName		Name of exchange server
'
 + CHAR(10) + '			CopyBackup		true / false
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn SetExchangeDBIDAProp -si @clientName=''Client Name'' -si @userName=''admin'' -p2 @password=''Password'' -si @backupType=''Incremental'' -si @useVss=''true'' -si @backupFromReplica=''true'' -si @backupOnActiveNode=''true'' -si @serverName=''E12SP3'' -si @copyBackup=''true''
'
 + CHAR(10) + '-- 	script_name: SetExchangeDBIDAProp'
 + CHAR(10) + '-- 	Set properties of ExchangeDB IDA.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetNasIDAProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetNasIDAProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetNasIDAProp')
	drop procedure QS_SetNasIDAProp
IF EXISTS (select * from GxQscripts where name='QS_SetNasIDAProp')
	delete from GxQscripts where name = 'QS_SetNasIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNasIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetNasIDAProp'
GO
print '... Creating Procedure: QS_SetNasIDAProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetNasIDAProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @clientName AS NVARCHAR(MAX) = '',
  @userName AS NVARCHAR(MAX) = '',
  @password AS NVARCHAR(MAX) = ''
AS
DECLARE @errorcode		AS	INT = 0
DECLARE @errorstring	AS	NVARCHAR(MAX) = 'Successful'
DECLARE @TRUE			AS	INT = 1
DECLARE @FALSE			AS	INT = 0
DECLARE @clientId		AS	INT = 0
DECLARE @idaId			AS	INT = 0
DECLARE @qs_resultTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
--Validate first parameter, client name
IF @clientName = ''
	BEGIN
		SET @errorcode = 1
		SET @errorstring = 'Error: First parameter is empty, it must be client name.'
		GOTO ARGS_ERROR
	END
ELSE
	BEGIN
		SET @clientId = ISNULL((SELECT id FROM APP_Client where name = @clientName), 0)
		IF @clientId = 0
		BEGIN
			SET		@errorstring = 'Error: First parameter client name[' + @clientName + '] not correct. Please give valid client name.'
			SET		@errorcode = 2
			GOTO	ARGS_ERROR
		END
		SET @idaId = ISNULL((SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId = 13), 0)
		IF @idaId = 0
		BEGIN
			SET		@errorstring = 'Error: NAS IDA is not installed on client [' + @clientName + '].'
			SET		@errorcode = 3
			GOTO	ARGS_ERROR
		END
	END
--Validate second parameter, user name
IF @userName = ''
BEGIN
	SET @errorcode = 4
	SET @errorstring = 'Error: Second parameter user name is empty, please give user name.'
	GOTO ARGS_ERROR
END
--Validate third parameter, password
IF @password = ''
	BEGIN
		SET @errorcode = 5
		SET @errorstring = 'Error: Third parameter password is empty, please give password.'
		GOTO ARGS_ERROR
	END
--ELSE
--	BEGIN
--		IF SUBSTRING (@password, 1, 1) != '2'
--		BEGIN
--			SET @errorcode = 6
--			SET @errorstring = 'Error: Third parameter password is not in p2 format, please give thrid parameters as -p2 <password>.'
--			GOTO ARGS_ERROR
--		END
--	END
-----------------------------------------------
--Validation done, add User Name and Password--
-----------------------------------------------
BEGIN TRAN
BEGIN TRY
	--Set User Name----------------------------------------------------------------------------------------------------
	IF EXISTS(SELECT * FROM MMNDMPHostInfo WHERE ClientId = @clientId)
		BEGIN
			UPDATE MMNDMPHostInfo
			SET Login = @userName, Password = @password
			WHERE ClientId = @clientId
			print 'Successfully set properties.'
		END
	ELSE
		BEGIN
			print 'Unable to set properties, Configure Nas client from GUI.'
		END
	-------------------------------------------------------------------------------------------------------------------
SKIP:
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	BEGIN
		SET @errorcode = ERROR_NUMBER()
		SET @errorstring = @errorstring + ERROR_MESSAGE()
	END
END CATCH
ALL_DONE:
	IF (@errorcode  = 0)
		commit Tran
	ELSE
		rollback Tran
ARGS_ERROR:
if @errorcode <> 0
		Raiserror(@errorstring,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetNasIDAProp')
	delete from GxQscripts where name = 'QS_SetNasIDAProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetNasIDAProp')
	delete from GXDBVersions where aliasname = 'QS_SetNasIDAProp'
GO

insert into GXDBVersions values(2, 'QS_SetNasIDAProp',  '00000000000000000000', 'QS_SetNasIDAProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetNasIDAProp',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetNasIDAProp -si @clientName=''Client Name'' -si @userName=''User Name'' -p2 @password=''Password''
'
 + CHAR(10) + '	Where 	ClientName		would be client name.
'
 + CHAR(10) + '			UserName		User name to be set for IDA
'
 + CHAR(10) + '			Password		Password to be set for IDA.
'
 + CHAR(10) + '	Example:
'
 + CHAR(10) + '	qoperation execscript -sn SetNasIDAProp -si @clientName=''Client Name'' -si @userName=''admin'' -p2 @password=''Password''
'
 + CHAR(10) + '-- 	script_name: SetNasIDAProp'
 + CHAR(10) + '-- 	Set properties of NAS IDA.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClient_Info.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClient_Info <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClient_Info')
	drop procedure QS_GetClient_Info
IF EXISTS (select * from GxQscripts where name='QS_GetClient_Info')
	delete from GxQscripts where name = 'QS_GetClient_Info'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClient_Info')
	delete from GXDBVersions where aliasname = 'QS_GetClient_Info'
GO
print '... Creating Procedure: QS_GetClient_Info'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClient_Info
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-------------------------------------------
 --				NO INPUT				--
-------------------------------------------
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetClient_Info'
DECLARE @propName varchar(32)
SET @propName = 'Active Physical Node'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
------------ No error handling ---------------
SELECT C.Name, ISNULL(C.net_hostName, 'Not Applicable') as 'Host Name', sSOS.name as 'OS',
			CASE(C.status & 2 )
			WHEN (2) THEN 'NO'
			ELSE (CASE(C.status & 4 ) WHEN(4) THEN 'NO' ELSE 'YES' END)END
			as 'ACTIVE' FROM APP_Client C
		 	join simOperatingSystem AS sSOS on sSOS.id = C.simOperatingSystemId
		 	WHERE C.simOperatingSystemId <> 0
 SET @lastError = @@error
 IF @lastError <> 0
 BEGIN
	SET @localErrorMsg = 'Error: Query Unsucess full'
	GOTO ARGS_ERROR
 END
--PRINT @scriptName + ' completed at '
--         + Convert(varchar(60), getdate()) + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClient_Info')
	delete from GxQscripts where name = 'QS_GetClient_Info'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClient_Info')
	delete from GXDBVersions where aliasname = 'QS_GetClient_Info'
GO

insert into GXDBVersions values(2, 'QS_GetClient_Info',  '00000000000000000000', 'QS_GetClient_Info', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClient_Info',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn GetClient_Info.sql
'
 + CHAR(10) + '--   script_name : GetClient_Info'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetRefCopyRefTimes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ResetRefCopyRefTimes <<<'

IF EXISTS (select * from sysobjects where name='QS_ResetRefCopyRefTimes')
	drop procedure QS_ResetRefCopyRefTimes
IF EXISTS (select * from GxQscripts where name='QS_ResetRefCopyRefTimes')
	delete from GxQscripts where name = 'QS_ResetRefCopyRefTimes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetRefCopyRefTimes')
	delete from GXDBVersions where aliasname = 'QS_ResetRefCopyRefTimes'
GO
print '... Creating Procedure: QS_ResetRefCopyRefTimes'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ResetRefCopyRefTimes
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s',
  @PARAM6 varchar(1024) = '%s',
  @PARAM7 varchar(1024) = '%s',
  @PARAM8 varchar(1024) = '%s',
  @PARAM9 varchar(1024) = '%s',
  @PARAM10 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
--DECLARE @PARAM6 varchar(1024)
--SET		@PARAM6 = '%s'
---------------------------------------
--test
--SET		@PARAM1= 'c=testRefCopy'
--SET		@PARAM2= 'a=Q_WINXP32_FS'
--SET		@PARAM3= 'i=DefaultInstanceName'
--SET		@PARAM4= 'b=defaultBackupSet'
--SET		@PARAM5= 's=refSc1'
--SET		@PARAM6= 'all'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ResetRefCopyRefTimes'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
--------------------- Get ids --------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
DECLARE @srcClientId int
DECLARE @srcAppTypeId int
DECLARE @srcInstanceId int
DECLARE @srcBackupsetId int
DECLARE @srcsubclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
IF @PARAM1 = '%s'
SET @PARAM1 = ''
IF @PARAM2 = '%s'
SET @PARAM2 = ''
IF @PARAM3 = '%s'
SET @PARAM3 = ''
IF @PARAM4 = '%s'
SET @PARAM4 = ''
IF @PARAM5 = '%s'
SET @PARAM5 = ''
IF @PARAM6 = '%s'
SET @PARAM6 = ''
IF @PARAM7 = '%s'
SET @PARAM7 = ''
IF @PARAM8 = '%s'
SET @PARAM8 = ''
IF @PARAM9 = '%s'
SET @PARAM9 = ''
IF @PARAM10 = '%s'
SET @PARAM10 = ''
IF @PARAM6 = 'all'
BEGIN
	Delete From JMReferenceCopy where refAppId = @subclientId
END
ELSE
BEGIN
	EXECUTE @lastError = QscriptGetAppIdsFromNames @PARAM6, @PARAM7, @PARAM8, @PARAM9, @PARAM10,
		@srcsubclientId OUTPUT, @srcBackupsetId OUTPUT, @srcInstanceId OUTPUT, @srcAppTypeId OUTPUT, @srcClientId OUTPUT,
		@localErrorMsg OUTPUT
	IF @lastError != 0
	BEGIN
		GOTO ARGS_ERROR
	END
	Delete From JMReferenceCopy where refAppId = @subclientId and srcAppId = @srcsubclientId
END
ARGS_ERROR:
/*PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@PARAM1+', '+@PARAM2+', '+@PARAM3+', '+@PARAM4+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'*/
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetRefCopyRefTimes')
	delete from GxQscripts where name = 'QS_ResetRefCopyRefTimes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetRefCopyRefTimes')
	delete from GXDBVersions where aliasname = 'QS_ResetRefCopyRefTimes'
GO

insert into GXDBVersions values(2, 'QS_ResetRefCopyRefTimes',  '00000000000000000000', 'QS_ResetRefCopyRefTimes', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ResetRefCopyRefTimes',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn ResetRefCopyRefTimes.sql -si c=client_name -si a=app_type_name -si i=instance_name -si b=backupset_name -si s=subclient_name -si all
'
 + CHAR(10) + ' qoperation execscript -sn ResetRefCopyRefTimes.sql -si c=client_name -si a=app_type_name -si i=instance_name -si b=backupset_name -si s=subclient_name -si c=srcclient_name -si a=srcapp_type_name -si i=srcinstance_name -si b=srcbackupset_name -si s=srcsubclient_name
'
 + CHAR(10) + '--   script_name : ResetRefCopyRefTimes'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ChangeCSHostNameAfterMigration.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ChangeCSHostNameAfterMigration <<<'

IF EXISTS (select * from sysobjects where name='QS_ChangeCSHostNameAfterMigration')
	drop procedure QS_ChangeCSHostNameAfterMigration
IF EXISTS (select * from GxQscripts where name='QS_ChangeCSHostNameAfterMigration')
	delete from GxQscripts where name = 'QS_ChangeCSHostNameAfterMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeCSHostNameAfterMigration')
	delete from GXDBVersions where aliasname = 'QS_ChangeCSHostNameAfterMigration'
GO
print '... Creating Procedure: QS_ChangeCSHostNameAfterMigration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ChangeCSHostNameAfterMigration
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_clientName VARCHAR(1024)
 DECLARE @i_newCsHostName VARCHAR(1024)
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'ChangeCSHostNameAfterMigration'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
BEGIN TRY
BEGIN TRAN
	IF(@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter) --Requires both clientName and destination cs host name
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_ChangeCSHostNameAfterMigration'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_clientName = @PARAM1
	SET @i_newCsHostName = @PARAM2
	DECLARE @l_clientId INT
	SELECT @l_clientId = id FROM App_Client WHERE name = @i_clientName
	--Validate client name
	IF @l_clientId IS NULL OR @l_clientId < 2
	BEGIN
		SET @localErrorMsg	=	'Error: Invalid client [' + @i_clientName + ']'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	ELSE IF 2 = @l_clientId
	BEGIN
		SET @localErrorMsg	=	'Error: Client  [' + @i_clientName + '] is a CommServer. It''s not allowed to change CommServer.'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	--Change csHostName and mark the client as not belongs to this commserver
	UPDATE 	App_Client
	SET		csHostName 			= @i_newCsHostName,
			specialClientFlags 	= (specialClientFlags | 0x20 | 0x2)
	WHERE	id = @l_clientId
	--Remove packages for this client
	DELETE 	SimInstalledPackages
	WHERE	clientId = @l_clientId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successfully changed csHostName of client[' + @i_clientName + '] to  [' + @i_newCsHostName + '].'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ChangeCSHostNameAfterMigration')
	delete from GxQscripts where name = 'QS_ChangeCSHostNameAfterMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ChangeCSHostNameAfterMigration')
	delete from GXDBVersions where aliasname = 'QS_ChangeCSHostNameAfterMigration'
GO

insert into GXDBVersions values(2, 'QS_ChangeCSHostNameAfterMigration',  '00000000000000000000', 'QS_ChangeCSHostNameAfterMigration', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ChangeCSHostNameAfterMigration',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn ChangeCSHostNameAfterMigration -si <Client Name> -si <Destination CommServer Host Name>'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_QueryDB2Backup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_QueryDB2Backup.sp,v $ $Id: QS_QueryDB2Backup.sp,v 1.8 2015/07/10 06:26:08 stelagamsetti Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_QueryDB2Backup <<<'

IF EXISTS (select * from sysobjects where name='QS_QueryDB2Backup')
	drop procedure QS_QueryDB2Backup
IF EXISTS (select * from GxQscripts where name='QS_QueryDB2Backup')
	delete from GxQscripts where name = 'QS_QueryDB2Backup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_QueryDB2Backup')
	delete from GXDBVersions where aliasname = 'QS_QueryDB2Backup'
GO
print '... Creating Procedure: QS_QueryDB2Backup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_QueryDB2Backup
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = '',
  @PARAM2 nvarchar(1024) = '',
  @PARAM3 nvarchar(1024) = '',
  @PARAM4 nvarchar(1024) = '',
  @PARAM5 nvarchar(256) = '',
  @PARAM6 nvarchar(256) = ''
AS
Set NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
      -------------------INPUTS all mandatory----------------------------------
DECLARE @client varchar(1024)
DECLARE @instanceName varchar(1024)
DECLARE @backupsetName varchar(1024)
DECLARE @queryLog varchar(1024)
DECLARE @fromTime varchar(256)
DECLARE @toTime varchar(256)
SET @client = @PARAM1
SET @instancename = @PARAM2
SET @backupsetName = @PARAM3
SET @queryLog = @PARAM4
SET @fromTime = @PARAM5
SET @toTime = @PARAM6
     -------------------------------
      --select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'QueryDB2Backup'
      DECLARE @nowTime integer
      SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
      DECLARE @instanceId integer
      SET @instanceId = 0
      DECLARE @backupsetId integer
      SET @backupsetId = 0
      DECLARE @userId integer
      SET @userId = 0
      DECLARE @browseCapMask bigint = POWER(2,13-1)
	  DECLARE @fromUnixTime integer
      SET @fromUnixTime = dbo.GetUnixTime('1970-01-01 00:00:00')
      DECLARE @toUnixTime integer
      SET @toUnixTime = @nowTime
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name = @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     DECLARE @DB2Apptype varchar(128)
     SET @DB2Apptype = ISNULL ((SELECT apptypeId FROM APP_IdaName WHERE clientid = @clientId and apptypeId in (37, 62, 103)), 0)
	IF @DB2Apptype = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have DB2 iDataAgent.'
     	GOTO ERROR_EXIT
     END
	 DECLARE @clTimeZone VARCHAR(256)
	 SET @clTimeZone = dbo.GetClientTimeZone(@clientId)
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters---------------
     IF
    	@backupsetName = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create subclient. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     END
     SET @instanceId =   ISNULL((SELECT distinct I.id
							from  APP_Application APP INNER JOIN  APP_InstanceName I
							ON APP.instance = I.id
							where APP.clientId = @clientId
							and APP.appTypeId = @DB2Apptype
							and I.name = @instanceName),0)
	IF (@instanceId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Instance ['+@instanceName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '].'
     	GOTO ERROR_EXIT
     END
     --get backupset id
    SET @backupsetId = ISNULL(( select distinct APP_BackupSetName.id
							from APP_BackupSetName, APP_Application, APP_Client, APP_InstanceName
							where APP_Application.clientId = APP_Client.id
							and APP_Application.appTypeId = @DB2Apptype
							and APP_Application.instance = APP_InstanceName.id
							and APP_BackupSetName.id = APP_Application.backupSet
							and APP_Client.name = @client
							and APP_InstanceName.name = @instanceName
							and APP_BackupSetName.name = @backupsetName), 0)
	IF (@backupsetId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Backupset ['+@backupsetName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '], instanceName [' +  @instanceName +'].'
     	GOTO ERROR_EXIT
     END
	SET @fromTime = RTRIM(LTRIM(@fromTime))
    SET @toTime = RTRIM(LTRIM(@toTime))
    IF @fromTime = N''
	BEGIN
	SET @fromTime = dbo.UTCToLocalTime('1970-01-01 00:00:00', @clTimeZone)
	END
	IF ISDATE(@fromTime) <> 1
	BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid from time ['+@fromTime+']. Please provide valid time MM-DD-YYYY  hh:mm:ss'
	GOTO ERROR_EXIT
	END
    IF @toTime = N''
	BEGIN
	SET @toTime = dbo.UTCToLocalTime(GetUTCdate(), @clTimeZone)
	END
	IF ISDATE(@toTime) <> 1
	BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid to time ['+@toTime+']. Please provide valid time MM-DD-YYYY  hh:mm:ss'
	GOTO ERROR_EXIT
	END
	DECLARE @timediff integer
	SET @timediff = dbo.GetUnixTime(@toTime) - dbo.GetUnixTime(@fromTime)
	IF @timediff < 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid time range. FROM time ['+@fromTime+'] should be less than TO time ['+@toTime+'].'
		GOTO ERROR_EXIT
	END
	SET @fromUnixTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@fromTime, @clTimeZone))
    SET @toUnixTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@toTime, @clTimeZone))
     -- get quser id
     SET @userId =  ISNULL( (select userId from #tempQSUser),0)
     IF (@userId = 0)
     BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error, no logged in user found'
		GOTO ERROR_EXIT
     END
     --validate user for cabailities
     IF object_id('tempdb.dbo.#tempDB2UtilObjects') IS NOT NULL
		DROP TABLE #tempDB2UtilObjects
create table  #tempDB2UtilObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	 ---- 2012 is backupset item
     EXEC sec_getUserObjects @userId,2012,0,#tempDB2UtilObjects
     -- delete no browse capable objects from temp table
     DELETE FROM #tempDB2UtilObjects where capabilities&@browseCapMask=0
	 DECLARE @userAllowed integer
	 SET @userAllowed=0
     ---- check the user has access to the backupset by checking at different levels
	 IF EXISTS (SELECT * FROM #tempDB2UtilObjects WHERE
	 ----  comm cell level capability
	 ((commCellId=2 AND clientGroupId=0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)
	 OR
	 ------ comm client group capability
	 (commCellId=2 AND clientGroupId in (select clientGroupId from APP_ClientGroupAssoc where clientId=@clientId) AND clientId=0 AND
	 appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)
	 OR
	 ----  client level capability
	 (commCellId=2 AND clientId=@clientId AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)
	 OR
	 ----  instance level capability
	 (commCellId=2 AND clientId=@clientId AND (appTypeId in (37,62,103)) AND instanceId=@instanceId AND backupsetId=0 AND subClientId=0)
	 OR
	 ----- backupset level capability
	 (commCellId=2 AND clientId=@clientId AND (appTypeId in (37,62,103) AND instanceId=@instanceId AND
	 backupsetId=@backupsetId AND subClientId=0))
	 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND
	 reviewSetId=0 AND querySetId=0 AND downloadSetId=0 AND ermId=0 AND legalHoldId=0 AND tagId=0 AND cdPolicyId=0 AND
	 complianceReportId=0 AND taskId=0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND
	 userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
     AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0))
	 BEGIN
		SET @userAllowed=1
	 END
	IF ( @userAllowed = 0)
	BEGIN
    	SET @errorCode = 1
    	SET @errorString = 'User does not have browse/view capabilities on the given entity.'
     	GOTO ERROR_EXIT
	END
    --query logs
    IF (@queryLog = 'LOGS')
    BEGIN
		IF object_id('tempdb.dbo.#temparchGetDB2LogByLogNumber') IS NOT Null DROP TABLE #temparchGetDB2LogByLogNumber
create table #temparchGetDB2LogByLogNumber (  r_afileId integer, r_afileName varchar(2048), r_appId integer, r_createTime integer, r_backupLevel integer, r_agroupId integer,  r_copyId integer,
			r_firstLogTime integer,
			r_lastLogTime integer,
			r_firstLogNumber integer,
			r_lastLogNumber integer,
			r_commCellId integer)
		insert into #temparchGetDB2LogByLogNumber
		execute archGetDB2LogByLogNumber 2,@clientId,@instanceId,@backupsetId,'%%',0,0,-1
		select af.jobId as 'JOB ID',
			SUBSTRING(r_afileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) , 8) as 'NODE NUMBER' ,
			SUBSTRING(r_afileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) +9 , 8)as 'CHAIN NUMBER',
			Left(CAST(r_firstLogNumber as char(15)) + '.'  , 16) as 'FIRST LOG NUMBER',
			Left(CAST(r_lastLogNumber as char(14)) + '.'  , 15)as 'LAST LOG NUMBER',
			CONVERT(varchar(19),dbo.UTCToLocalDateTimeConversionManaged(DATEADD(second, r_firstLogTime, '01/01/1970'), @clTimeZone), 120) as '   FIRST LOG TIME   ',
			CONVERT(varchar(19),dbo.UTCToLocalDateTimeConversionManaged(DATEADD(second, r_lastLogTime, '01/01/1970'), @clTimeZone), 120) as '   LAST LOG TIME   '
  from #temparchGetDB2LogByLogNumber temp
			INNER JOIN archFile af on temp.r_afileId = af.id
		where
			(temp.r_firstLogTime <= @fromUnixTime AND temp.r_lastLogTime >=@fromUnixTime) OR
			(temp.r_firstLogTime <= @toUnixTime AND temp.r_lastLogTime >=@toUnixTime) OR
			(temp.r_firstLogTime >= @fromUnixTime AND temp.r_lastLogTime <=@toUnixTime)
		IF object_id('tempdb.dbo.#temparchGetDB2LogByLogNumber') IS NOT Null DROP TABLE #temparchGetDB2LogByLogNumber
    END
    ELSE
    --query Data Backup
	BEGIN
		IF object_id('tempdb.dbo.#archFileForDB2Backupset') IS NOT Null DROP TABLE #archFileForDB2Backupset
		create table #archFileForDB2Backupset (
		   r_afileId integer,
		   r_commCellId integer,
		   r_fileName char(2048),
		   r_creationTime integer,
		   r_backupLevel integer,
		   r_numStreams integer,
		   r_initFrom integer,
		   r_attributes bigint,
		   r_afcFlags integer,
		   r_copyPrec integer,
		   r_physicalSize bigint)
insert into #archFileForDB2Backupset
		execute archFileForDB2Backupset @clientId,@DB2Apptype,@instanceId,@backupsetId,0,-1,0
		update #archFileForDB2Backupset set r_fileName=RTRIM(r_fileName)
		SELECT jobId as 'JOB ID',bkupLevel as 'BACKUP TYPE', NodeNumber as 'NODE NUMBER',timeStamp as '  TIMESTAMP   ', max(streams) as STREAMS  FROM (
			SELECT af.jobId,   case  r_backupLevel when 1 then 'Full' when 2 then 'Incr' else 'Delta' end + SPACE(4) +'.' AS bkupLevel,
			parsename(replace(
			SUBSTRING(
			   r_fileName,
				CHARINDEX('_', r_fileName) + 1,
				LEN(r_fileName) - CHARINDEX('_', r_fileName) - CHARINDEX('_', REVERSE(rtrim(r_fileName)))
			)
			, '_', '.'), 1) as timeStamp,
			 CONVERT(int, REVERSE(SUBSTRING(REVERSE(r_fileName),0,charindex('_',reverse(r_fileName))))) as streams,
			 SUBSTRING(r_fileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) , 8) as NodeNumber
			 FROM #archFileForDB2Backupset temp
			INNER JOIN archFile af on temp.r_afileId = af.id
			) A
		where
			dbo.GetUnixTime(dbo.LocalToUTCTime(SUBSTRING(A.timestamp,5,2)+'-'+SUBSTRING(A.timestamp,7,2)+'-'+SUBSTRING(A.timeStamp,1,4)+' '
			+SUBSTRING(A.timestamp,9,2)+':'+SUBSTRING(A.timestamp,11,2)+':'+SUBSTRING(A.timestamp,13,2), @clTimeZone))
			>= @fromUnixTime AND
			dbo.GetUnixTime(dbo.LocalToUTCTime(SUBSTRING(A.timestamp,5,2)+'-'+SUBSTRING(A.timestamp,7,2)+'-'+SUBSTRING(A.timeStamp,1,4)+' '
			+SUBSTRING(A.timestamp,9,2)+':'+SUBSTRING(A.timestamp,11,2)+':'+SUBSTRING(A.timestamp,13,2), @clTimeZone))
			<=@toUnixTime
		GROUP BY A.jobId,A.bkupLevel,A.NodeNumber,A.timeStamp
		DROP TABLE #archFileForDB2Backupset
    END
     ERROR_EXIT:
    -- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_QueryDB2Backup')
	delete from GxQscripts where name = 'QS_QueryDB2Backup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_QueryDB2Backup')
	delete from GXDBVersions where aliasname = 'QS_QueryDB2Backup'
GO

insert into GXDBVersions values(2, 'QS_QueryDB2Backup',  '00010008000000000000', 'QS_QueryDB2Backup', '00010008000000000000')
GO

insert into GxQscripts values(2+8,'QS_QueryDB2Backup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_QueryDB2Backup.sql -si clientname -si instancename  -si backupsetname -si DATA | LOGS -si fromtime -si totime
'
 + CHAR(10) + '-- 	script_name: QS_QueryDB2Backup.'
 + CHAR(10) + '-- 	Reports available Database and Log backups for the specified database(backupset) in Simpana catalog.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setRegisterClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetRegisterClient.sp,v $ $Id: QS_SetRegisterClient.sp,v 1.3 2014/06/30 19:06:58 anarde Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setRegisterClient <<<'

IF EXISTS (select * from sysobjects where name='QS_setRegisterClient')
	drop procedure QS_setRegisterClient
IF EXISTS (select * from GxQscripts where name='QS_setRegisterClient')
	delete from GxQscripts where name = 'QS_setRegisterClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setRegisterClient')
	delete from GXDBVersions where aliasname = 'QS_setRegisterClient'
GO
print '... Creating Procedure: QS_setRegisterClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_setRegisterClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @in_clientName varchar(255),
  @in_targetCC varchar(255),
  @in_userName varchar(255)=NULL,
  @in_password varchar(255)=NULL,
  @in_clientGroup varchar(255)=NULL,
  @in_subclientpolicy varchar(255)=NULL,
  @in_storagePolicy varchar(255)=NULL
AS
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
DECLARE	@targetCCId	INT = 0
DECLARE	@errorCode	INT = -1
DECLARE	@errorString	VARCHAR(256) = ''
DECLARE	@newEncPwd	VARCHAR(1024) = ''
BEGIN TRY
   IF @in_clientName IS NULL OR LEN(@in_clientName) = 0
   BEGIN
	SET @errorString = 'Invalid input client name'
	GOTO SP_EXIT
   END
   SELECT @targetCCId = ID FROM APP_CommCell WHERE aliasName = @in_targetCC
   IF @targetCCId = 0
   BEGIN
	SET @errorString = 'Invalid input CommCell name'
	GOTO SP_EXIT
   END
   IF NOT EXISTS (select * from APP_CommCellInfo where commcellId = @targetCCId)
   BEGIN
	SET @errorString = 'Input CommCell name [' + @in_targetCC + '] is not in destination CommCell list'
	GOTO SP_EXIT
   END
   IF @in_password IS NOT NULL AND LEN(@in_password) > 0
   BEGIN
	EXEC pswEncryptionManaged @in_password, @newEncPwd OUTPUT
   END
   IF EXISTS (select * from APP_RegisterClient where name = @in_clientName)
   BEGIN
	UPDATE	APP_RegisterClient
	SET	targetCCId	= @targetCCId,
		userName	= CASE @in_userName		WHEN NULL THEN userName		ELSE @in_userName END,
		password	= CASE @in_password		WHEN NULL THEN password		ELSE @newEncPwd END,
		clientGroup	= CASE @in_clientGroup		WHEN NULL THEN clientGroup	ELSE @in_clientGroup END,
		subclientPolicy	= CASE @in_subclientpolicy	WHEN NULL THEN subclientPolicy	ELSE @in_subclientpolicy END,
		storagePolicy	= CASE @in_storagePolicy	WHEN NULL THEN storagePolicy	ELSE @in_storagePolicy END
	WHERE	name = @in_clientName
	SET @errorString = 'Register client info is updated for client [' + @in_clientName + ']'
   END
   ELSE
   BEGIN
	INSERT INTO APP_RegisterClient
	SELECT	@in_clientName, @targetCCId,
		CASE @in_userName 		WHEN NULL THEN '' ELSE @in_userName		END,
		@newEncPwd,
		CASE @in_clientGroup		WHEN NULL THEN '' ELSE @in_clientGroup		END,
		CASE @in_subclientpolicy	WHEN NULL THEN '' ELSE @in_subclientpolicy	END,
		CASE @in_storagePolicy		WHEN NULL THEN '' ELSE @in_storagePolicy	END,
		0, dbo.GetUnixTime(GETDATE()), 0
	SET @errorString = 'Register client info is added for client [' + @in_clientName + ']'
   END
   SET @errorCode = 0
END TRY
BEGIN CATCH
   
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
SP_EXIT:
IF @errorCode <> 0 AND LEN(@errorString) = 0
	SET @errorString = 'Failed to set Register client info for client [' + @in_clientName + ']'
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setRegisterClient')
	delete from GxQscripts where name = 'QS_setRegisterClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setRegisterClient')
	delete from GXDBVersions where aliasname = 'QS_setRegisterClient'
GO

insert into GXDBVersions values(2, 'QS_setRegisterClient',  '00010003000000000000', 'QS_setRegisterClient', '00010003000000000000')
GO

insert into GxQscripts values(2,'QS_setRegisterClient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn setRegisterClient -si clientName -si targetCommCell [-si userName] [-si password] [-si clientGroup] [-si subclientPolicy] [-si storagePolicy]
'
 + CHAR(10) + '-- 	script_name: setRegisterClient'
 + CHAR(10) + '-- 	Set auto register client info'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetDeconfiguredClientsWithoutBkp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetDeconfiguredClientsWithoutBkp.sp,v $ $Id: QS_GetDeconfiguredClientsWithoutBkp.sp,v 1.3 2013/07/18 15:42:56 xsui Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetDeconfiguredClientsWithoutBkp <<<'

IF EXISTS (select * from sysobjects where name='QS_GetDeconfiguredClientsWithoutBkp')
	drop procedure QS_GetDeconfiguredClientsWithoutBkp
IF EXISTS (select * from GxQscripts where name='QS_GetDeconfiguredClientsWithoutBkp')
	delete from GxQscripts where name = 'QS_GetDeconfiguredClientsWithoutBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetDeconfiguredClientsWithoutBkp')
	delete from GXDBVersions where aliasname = 'QS_GetDeconfiguredClientsWithoutBkp'
GO
print '... Creating Procedure: QS_GetDeconfiguredClientsWithoutBkp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetDeconfiguredClientsWithoutBkp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @in_days INT		
AS
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
DECLARE @backupTime	INT
SET @backupTime = dbo.getUNIXTime(getDate()) - @in_days * 24 *60 * 60
SELECT	id, name
FROM	APP_Client C
WHERE	C.id > 2 AND (C.status & 0x2) > 0 AND NOT EXISTS (select * from JMBkpStats J, APP_Application A where A.clientID = C.id and A.id = J.appId and servStartDate > @backupTime)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetDeconfiguredClientsWithoutBkp')
	delete from GxQscripts where name = 'QS_GetDeconfiguredClientsWithoutBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetDeconfiguredClientsWithoutBkp')
	delete from GXDBVersions where aliasname = 'QS_GetDeconfiguredClientsWithoutBkp'
GO

insert into GXDBVersions values(2, 'QS_GetDeconfiguredClientsWithoutBkp',  '00010003000000000000', 'QS_GetDeconfiguredClientsWithoutBkp', '00010003000000000000')
GO

insert into GxQscripts values(2,'QS_GetDeconfiguredClientsWithoutBkp',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetDeconfiguredClientsWithoutBkp -si longerThanDays
'
 + CHAR(10) + '-- 	script_name: GetClientsWithoutBkp'
 + CHAR(10) + '-- 	Get a list of de-configured clients that have not been backed up longer than given days'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/saveCustomReportUserAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/saveCustomReportUserAssociation.sp,v $ $Id: saveCustomReportUserAssociation.sp,v 1.2 2013/07/19 18:04:04 sgupta Exp $";
--
--  +========================================================================+
--  | Stored Precedure: saveCustomReportUserAssociation
--  |
--  | Description:
--  |  Add custom report id to table UMUserandGroupEntityAssociation with the details of the user associated
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        schakka   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: saveCustomReportUserAssociation <<<'

IF EXISTS (select * from sysobjects where name='saveCustomReportUserAssociation')
	drop procedure saveCustomReportUserAssociation
IF EXISTS (select * from GxQscripts where name='saveCustomReportUserAssociation')
	delete from GxQscripts where name = 'saveCustomReportUserAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='saveCustomReportUserAssociation')
	delete from GXDBVersions where aliasname = 'saveCustomReportUserAssociation'
GO
print '... Creating Procedure: saveCustomReportUserAssociation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure saveCustomReportUserAssociation
  @i_customReportId INTEGER,
  @i_userId nVARCHAR(MAX),
  @i_groupId nVARCHAR(MAX),
  @i_providerId nVARCHAR(MAX),
  @i_ownerUserId INTEGER,
  @i_updateFlag INTEGER
AS
  DECLARE @o_retVal varchar(MAX);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ERRORSTR VARCHAR(MAX)=''
DECLARE @i_executeCapability BIGINT
select @i_executeCapability = CAST(POWER(2.0, 33-1) AS BIGINT)
BEGIN TRAN
IF @i_customReportId < 1
BEGIN
	SET @ERRORSTR = 'Invalid report id, failing..'
	GOTO PROC_EXIT;
END
IF @i_updateFlag = 1
BEGIN
	--Update flag is set, so we have to update the users of the custom report. so first we delete the entries, and then insert the new values
	DELETE FROM UMUserandGroupEntityAssociation
	WHERE entityType = 2900 AND objectId = @i_customReportId
END
IF @i_ownerUserId IS null OR @i_ownerUserId < 0
	SET	@i_ownerUserId = 0;
DECLARE @endIndex INTEGER =0
DECLARE @startIndex INTEGER =0
DECLARE @id integer
--2900 ->NEW EVENTTYPE FOR CUSTOM REPORT DEFINED IN Shared/CvLib/EvStatic.h
IF @i_userId IS NOT null AND @i_userId <> ''
BEGIN
	SET @i_userId = @i_userId + ',';
	SET @endIndex = CHARINDEX(',', @i_userId, @startIndex)
	WHILE(@endIndex IS NOT null AND @endIndex <> 0)
	BEGIN
		SET @id = CAST(SUBSTRING(@i_userId, @startIndex, @endIndex - @startIndex) AS INT)
		if(@id > 0)
		BEGIN
			IF NOT EXISTS(SELECT TOP 1 * FROM UMUserandGroupEntityAssociation
WHERE userId = @id AND groupId = 0 AND providerId = 0 AND capabilities = @i_executeCapability AND entityType = 2900 AND objectId = @i_customReportId)
				INSERT INTO UMUserandGroupEntityAssociation
				VALUES(@id, 0, 0, @i_executeCapability, 2900, @i_customReportId, @i_ownerUserId);
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @i_userId, @startIndex)
	END
END
SET @endIndex =0
SET @startIndex =0
SET @id = 0
IF @i_groupId IS NOT null AND @i_groupId <> ''
BEGIN
	SET @i_groupId = @i_groupId + ',';
	SET @endIndex = CHARINDEX(',', @i_groupId, @startIndex)
	WHILE(@endIndex IS NOT null AND @endIndex <> 0)
	BEGIN
		SET @id = CAST(SUBSTRING(@i_groupId, @startIndex, @endIndex - @startIndex) AS INT)
		if(@id > 0)
		BEGIN
			IF NOT EXISTS(SELECT TOP 1 * FROM UMUserandGroupEntityAssociation
WHERE userId = 0 AND groupId = @id AND providerId = 0 AND capabilities = @i_executeCapability AND entityType = 2900 AND objectId = @i_customReportId)
				INSERT INTO UMUserandGroupEntityAssociation
				VALUES(0, @id, 0, @i_executeCapability, 2900, @i_customReportId, @i_ownerUserId);
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @i_groupId, @startIndex)
	END
END
SET @endIndex =0
SET @startIndex =0
SET @id = 0
IF @i_providerId IS NOT null AND @i_providerId <> ''-- this clause needs to be SET properly(groupId should be retrieved)
BEGIN
	SET @i_providerId = @i_providerId + ',';
	SET @endIndex = CHARINDEX(',', @i_providerId, @startIndex)
	WHILE(@endIndex IS NOT null AND @endIndex <> 0)
	BEGIN
		SET @id = CAST(SUBSTRING(@i_providerId, @startIndex, @endIndex - @startIndex) AS INT)
		if(@id > 0)
		BEGIN
			IF NOT EXISTS(SELECT TOP 1 * FROM UMUserandGroupEntityAssociation
WHERE userId = 0 AND groupId = 0 AND providerId = @id AND capabilities = @i_executeCapability AND entityType = 2900 AND objectId = @i_customReportId)
				INSERT INTO UMUserandGroupEntityAssociation
				VALUES(0, 0, @id, @i_executeCapability, 2900, @i_customReportId, @i_ownerUserId);
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @i_providerId, @startIndex)
	END
END
DECLARE @error INT=0;
SELECT @error = @@ERROR
IF @error <> 0
BEGIN
    SET @errorStr = 'Error while INSERTING custom report related info into UMUserandGroupEntityAssociation'
    GOTO PROC_EXIT
END
IF @i_ownerUserId > 0
	exec sec_updateUserCredentials @i_ownerUserId, 1
PROC_EXIT:
	IF @ERRORSTR <> ''
	BEGIN
		SELECT @ERRORSTR
		ROLLBACK TRAN
	END
	ELSE
	BEGIN
		SELECT 'SUCCESS'
		COMMIT TRAN
	END
GO

IF EXISTS (select * from GxQscripts where name = 'saveCustomReportUserAssociation')
	delete from GxQscripts where name = 'saveCustomReportUserAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='saveCustomReportUserAssociation')
	delete from GXDBVersions where aliasname = 'saveCustomReportUserAssociation'
GO

insert into GXDBVersions values(2, 'saveCustomReportUserAssociation',  '00010002000000000000', 'saveCustomReportUserAssociation', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getCustomReportsOfUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getCustomReportsOfUser.sp,v $ $Id: getCustomReportsOfUser.sp,v 1.3 2015/01/22 18:11:19 rpolimera Exp $";
--
--  +========================================================================+
--  | Stored Precedure: getCustomReportsOfUser
--  |
--  | Description:
--  |  Get custom report id's related to userId
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        schakka   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getCustomReportsOfUser <<<'

IF EXISTS (select * from sysobjects where name='getCustomReportsOfUser')
	drop procedure getCustomReportsOfUser
IF EXISTS (select * from GxQscripts where name='getCustomReportsOfUser')
	delete from GxQscripts where name = 'getCustomReportsOfUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getCustomReportsOfUser')
	delete from GXDBVersions where aliasname = 'getCustomReportsOfUser'
GO
print '... Creating Procedure: getCustomReportsOfUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getCustomReportsOfUser
  @i_userId INTEGER
AS
  DECLARE @o_objectId INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
select objectId
from UMUserandGroupEntityAssociation
where (userId = @i_userId)
		and entityType = 2900 -->>>>--2900-->>>>custom report entitytype
UNION ALL
select objectId
from UMUserandGroupEntityAssociation  UGAssoc
      INNER JOIN UMUserGroup UG
      ON UGAssoc.groupId = UG.groupId
      and UG.userId = @i_userId
      and UGAssoc.entityType = 2900
UNION ALL
select objectId
from UMUserandGroupEntityAssociation  UGAssoc
      INNER JOIN UMDSUserGroup UG
      ON UGAssoc.providerId = UG.groupId
      and UG.userId = @i_userId
      and UGAssoc.entityType = 2900
UNION ALL
SELECT objectId
FROM UMUserandGroupEntityAssociation  UGAssoc
JOIN UMDSGroupMaps AS UDSM
ON  UDSM.umgroupId = UGAssoc.groupId
JOIN UMDSUserGroup AS UG
on UG.groupId = UDSM.umDSgroupId
AND UG.userId = @i_userId
AND UGAssoc.entityType = 2900
GO

IF EXISTS (select * from GxQscripts where name = 'getCustomReportsOfUser')
	delete from GxQscripts where name = 'getCustomReportsOfUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getCustomReportsOfUser')
	delete from GXDBVersions where aliasname = 'getCustomReportsOfUser'
GO

insert into GXDBVersions values(2, 'getCustomReportsOfUser',  '00010003000000000000', 'getCustomReportsOfUser', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getLoginForEmail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Imtiaz Mohammad
--	Date:   07/20/2013
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   sec_getLoginForEmail.sp - Given an email, returns the number of logins with that email-id. If only 1, returns the login too.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getLoginForEmail <<<'

IF EXISTS (select * from sysobjects where name='sec_getLoginForEmail')
	drop procedure sec_getLoginForEmail
IF EXISTS (select * from GxQscripts where name='sec_getLoginForEmail')
	delete from GxQscripts where name = 'sec_getLoginForEmail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLoginForEmail')
	delete from GXDBVersions where aliasname = 'sec_getLoginForEmail'
GO
print '... Creating Procedure: sec_getLoginForEmail'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getLoginForEmail
  @i_email nvarchar(255) = ''
AS
  DECLARE @o_n integer;
  DECLARE @o_usrLogin nvarchar(255);
  DECLARE @o_usrId integer;
BEGIN
	SET ANSI_NULLS ON
	SET NOCOUNT ON
	SET @o_usrLogin = ''
	SET @o_usrId = 0
	SET @o_n = (SELECT COUNT(*) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%')
	IF (@o_n = 1)
	BEGIN
		SELECT @o_usrLogin = ISNULL(login, ''), @o_usrId = ISNULL(id, 0) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%'
	END
	else if (exists( select id from UMUsers where login = @i_email and flags <> 0) and @o_n = 0)
	begin
		--New addition for supporting Email as a proper username.
		--We now allow an Email, say 'abc@commvault.com' to exist either as username or as an email for distinct user, not both
		--At this juncture, we know that there is no active user with email as one provided in the input. We will now check for username as the input email.
		 select @o_usrId = ISNULL(id, 0), @o_usrLogin = ISNULL(login, '') , @o_n = (case when id is null then 0 else 1 end)
		 from 	UMUsers where login = @i_email and flags <> 0
	end
	SELECT @o_n, @o_usrLogin,@o_usrId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getLoginForEmail')
	delete from GxQscripts where name = 'sec_getLoginForEmail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLoginForEmail')
	delete from GXDBVersions where aliasname = 'sec_getLoginForEmail'
GO

insert into GXDBVersions values(2, 'sec_getLoginForEmail',  '00000000000000000000', 'sec_getLoginForEmail', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_ValidateUsers.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_ValidateUsers()
--  | Description:  Validate users against UMUsers and if not found using APP_GUID and return UserGUID, loginName, primary SMTP, and display name for users given in input
--  | Input / Output: DM2ContentIndexing.CvEventUsers
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_ValidateUsers.sp,v $ $Id: sec_ValidateUsers.sp,v 1.5 2015/04/30 11:35:53 smujjiga Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_ValidateUsers <<<'

IF EXISTS (select * from sysobjects where name='sec_ValidateUsers')
	drop procedure sec_ValidateUsers
IF EXISTS (select * from GxQscripts where name='sec_ValidateUsers')
	delete from GxQscripts where name = 'sec_ValidateUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ValidateUsers')
	delete from GXDBVersions where aliasname = 'sec_ValidateUsers'
GO
print '... Creating Procedure: sec_ValidateUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_ValidateUsers
  @i_xmlText XML 
AS
BEGIN
--Declarations
DECLARE @csHostName nvarchar(255)
DECLARE @CV_APPGUID_STATUSBIT_PRIMARYSMTP    INT
DECLARE @CV_APPGUID_STATUSBIT_DOMAINALIAS    INT
DECLARE @CV_APPGUID_STATUSBIT_DISPLAYNAME	 INT
DECLARE @debug BIT = 0
--Intialize
SET @CV_APPGUID_STATUSBIT_PRIMARYSMTP = 0x08
SET @CV_APPGUID_STATUSBIT_DOMAINALIAS = 0x04
SET @CV_APPGUID_STATUSBIT_DISPLAYNAME = 0x01
--Create necessary temporary tables
IF OBJECT_ID('tempdb.dbo.#UsersTemp') is not null
DROP TABLE #UsersTemp
CREATE TABLE #UsersTemp ( inputName nvarchar(255),
loginName nvarchar(255),
UserGUID nvarchar(1024),
SmtpAddress nvarchar(255),
MatchFound BIT not null default 0,
IsMatchFromAppGuid BIT NOT NULL default 0,
displayName nvarchar(1024)
)
SELECT @csHostName = '@' + NET_HOSTNAME FROM APP_CLIENT
WHERE id = 2
--Populate temporary tables with input values
INSERT INTO #UsersTemp (inputName)
SELECT dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@aliasName', 'nvarchar(1024)'), '')) as inputName
FROM @i_xmlText.nodes('/DM2ContentIndexing_CvEventUsers/users') T(ref)
-- IF no inputs, nothing to find, just exit..
IF NOT EXISTS (SELECT * FROM #UsersTemp WHERE MatchFound = 0)
GOTO exitLine
--Find match from UMUsers and update temporary table
UPDATE T
SET T.UserGUID = U.userGuid,
T.SmtpAddress = (CASE WHEN U.umDSproviderId = 0 AND ISNULL(U.email,'') = '' THEN U.login + @csHostName ELSE U.email END),
T.loginName = U.login,
T.MatchFound = 1
FROM #UsersTemp T
JOIN UMUsers U ON ISNULL(U.userGuid, '') <> '' AND (T.inputName = U.name OR (isnull(u.email,'') <> '' and T.inputName = U.email) OR (U.umDSproviderId = 0 and isnull(u.email,'') = '' and T.inputName = U.login + @csHostName))
--Debug
IF @debug = 1
SELECT *, 'UMUserEntry' FromUMUsers FROM #UsersTemp
--Find match using APP_GUID and update user details as per matches found..
UPDATE T
SET T.UserGUID = A.GUID, T.MatchFound = 1, T.IsMatchFromAppGuid = 1
FROM #UsersTemp T
JOIN APP_GUID A ON T.inputName = A.name AND (A.status = @CV_APPGUID_STATUSBIT_PRIMARYSMTP OR A.status = @CV_APPGUID_STATUSBIT_DISPLAYNAME)
WHERE T.MatchFound = 0
--Now we have GUID from APP_GUID, so from the vertical table, we have to get and update smtp and login user name..
UPDATE T
SET T.SmtpAddress = A.name
FROM #UsersTemp T JOIN APP_GUID A ON T.UserGUID = A.GUID AND A.status = @CV_APPGUID_STATUSBIT_PRIMARYSMTP
WHERE T.IsMatchFromAppGuid = 1
UPDATE T
SET T.loginName = A.name
FROM #UsersTemp T
JOIN APP_GUID A ON UserGUID = GUID AND status = @CV_APPGUID_STATUSBIT_DOMAINALIAS
WHERE T.IsMatchFromAppGuid = 1
UPDATE T SET
T.displayName = A.name
FROM #UsersTemp T
JOIN APP_GUID A ON UserGUID = GUID AND status = @CV_APPGUID_STATUSBIT_DISPLAYNAME
WHERE T.IsMatchFromAppGuid = 1
--GUID has extra flower braces when result is from APP_GUID, So discard it here..
UPDATE T
SET T.UserGUID = REPLACE(REPLACE(T.UserGUID, '{', ''), '}', '')
FROM #UsersTemp T
WHERE IsMatchFromAppGuid = 1
--Return result from temporary table..
SELECT T.UserGUID AS '@userGuid', T.SmtpAddress AS '@smtpAddress', T.loginName AS '@loginName', T.inputName as '@aliasName', T.displayName as '@displayName'
FROM #UsersTemp T
FOR XML PATH('users'), ROOT('DM2ContentIndexing_CvEventUsers')
exitLine:
if @debug = 1
SELECT *, 'ResultEntry' FinalOutput FROM #UsersTemp
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_ValidateUsers')
	delete from GxQscripts where name = 'sec_ValidateUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ValidateUsers')
	delete from GXDBVersions where aliasname = 'sec_ValidateUsers'
GO

insert into GXDBVersions values(2, 'sec_ValidateUsers',  '00010005000000000000', 'sec_ValidateUsers', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetUserAndGroupSuggestions.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_GetUserAndGroupSuggestions()
--  | Description:
--  | Output: DM2ContentIndexing.CvEventUsers
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetUserAndGroupSuggestions.sp,v $ $Id: sec_GetUserAndGroupSuggestions.sp,v 1.4 2014/09/09 20:25:13 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_GetUserAndGroupSuggestions <<<'

IF EXISTS (select * from sysobjects where name='sec_GetUserAndGroupSuggestions')
	drop procedure sec_GetUserAndGroupSuggestions
IF EXISTS (select * from GxQscripts where name='sec_GetUserAndGroupSuggestions')
	delete from GxQscripts where name = 'sec_GetUserAndGroupSuggestions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetUserAndGroupSuggestions')
	delete from GXDBVersions where aliasname = 'sec_GetUserAndGroupSuggestions'
GO
print '... Creating Procedure: sec_GetUserAndGroupSuggestions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetUserAndGroupSuggestions
  @i_NamePattern nvarchar(100),
  @i_GetUsersFlag int = 1,
  @i_GetGroupsFlag int = 0,
  @i_PageSize int = 5,
  @i_SearchOnAlias int = 0,
  @i_SearchOnDisplayName int = 1,
  @i_SearchOnSmtp int = 1,
  @i_IgnoreSmtpRule int = 0
AS
BEGIN
	DECLARE @CCGroupEntityType INT
	DECLARE @CCUserEntityType INT
	DECLARE @csHostName NVARCHAR(255)
    --
	SELECT @CCGroupEntityType = EntryValue FROM DCReference WITH(NOLOCK)
	WHERE TypeName = 'SecuredEntity' AND EntryName = 'CommCellGroup'
    --
	SELECT @CCUserEntityType = EntryValue FROM DCReference WITH(NOLOCK)
	WHERE TypeName = 'SecuredEntity' AND EntryName = 'CommCellUser'
    --
	SELECT @csHostName = net_hostname FROM APP_CLIENT WITH(NOLOCK) WHERE id = 2
    --
	DECLARE @DynamicWhereConditions NVARCHAR(MAX) = ''
	DECLARE @FinalSQL NVARCHAR(MAX) = ''
	DECLARE @ArgDef NVARCHAR(MAX) = '@i_NamePattern nvarchar(100), @CCUserEntityType int, @CCGroupEntityType int, @i_PageSize int, @i_GetGroupsFlag int, @i_GetUsersFlag int, @csHostName NVARCHAR(255)'
	if @i_SearchOnDisplayName = 1
	BEGIN
		SET @DynamicWhereConditions = 'U.name LIKE @i_NamePattern'
	END
	if @i_SearchOnSmtp = 1
	BEGIN
		IF ISNULL(@DynamicWhereConditions,'') <> ''
			SET @DynamicWhereConditions += ' OR '
		SET @DynamicWhereConditions += 'U.email like @i_NamePattern'
	END
	if @i_SearchOnAlias = 1
	BEGIN
		IF ISNULL(@DynamicWhereConditions,'') <> ''
			SET @DynamicWhereConditions += ' OR '
		SET @DynamicWhereConditions += 'U.login like @i_NamePattern'
	END
	IF ISNULL(@DynamicWhereConditions,'') = ''
	BEGIN
		--if caller not supplied what to search on, then we won't return any data.
		SET @DynamicWhereConditions = '(1 = 2)'
	END
	ELSE
	BEGIN
		SET @DynamicWhereConditions = '(' + @DynamicWhereConditions + ')' + CASE WHEN @i_IgnoreSmtpRule = 0 THEN ' AND ISNULL(U.email,'''') <> '''' ' ELSE '' END
	END
	SET @FinalSQL = '
		SELECT
		(
			SELECT userGuid ''@userGuid'', aliasName ''@aliasName'', loginName ''@loginName'', displayName ''@displayName'', smtpAddress ''@smtpAddress'',
			entityType ''@entityType'', userId ''@userId'', id ''@groupId'', objectGuid ''@groupGuid''
			FROM
			(
				SELECT TOP (@i_PageSize) '''' userGuid, G.name aliasName, G.name loginName, G.name displayName, '''' smtpAddress,
				@CCGroupEntityType entityType, 0 userId, G.id id, CONVERT(NVARCHAR(256), G.GUID) objectGuid
				FROM UMGroups G WITH(NOLOCK)
				WHERE @i_GetGroupsFlag = 1 AND name like @i_NamePattern
			UNION
				SELECT TOP (@i_PageSize) U.userGuid userGuid, U.login aliasName, U.login loginName, U.name displayName,
				(CASE WHEN ISNULL(U.email,'''') = '''' THEN U.login + ''@'' + @csHostName ELSE U.email END) smtpAddress,
				@CCUserEntityType as entityType, U.id userId, 0 id, U.userGuid objectGuid
				FROM UMUsers U WITH(NOLOCK)
				JOIN UMDSProviders UP WITH(NOLOCK) ON U.umDSproviderId = UP.id
				WHERE @i_GetUsersFlag = 1 AND U.umDSproviderId = 0 AND U.id > 0 AND U.enabled = 1 AND ' + @DynamicWhereConditions  + '
			) UT
			FOR XML PATH(''users''), TYPE, ROOT(''DM2ContentIndexing_CvEventUsers'')
		) AS OutputXML
	'
	-- PRINT (@FinalSQL)
	exec sp_executesql @FinalSQL, @ArgDef,
	@i_NamePattern = @i_NamePattern,
	@CCUserEntityType = @CCUserEntityType,
	@CCGroupEntityType = @CCGroupEntityType,
	@i_PageSize = @i_PageSize,
	@i_GetGroupsFlag = @i_GetGroupsFlag,
	@i_GetUsersFlag = @i_GetUsersFlag,
	@csHostName = @csHostName
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetUserAndGroupSuggestions')
	delete from GxQscripts where name = 'sec_GetUserAndGroupSuggestions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetUserAndGroupSuggestions')
	delete from GXDBVersions where aliasname = 'sec_GetUserAndGroupSuggestions'
GO

insert into GXDBVersions values(2, 'sec_GetUserAndGroupSuggestions',  '00010004000000000000', 'sec_GetUserAndGroupSuggestions', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_OraMultiDBCGSnapConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_OraMultiDBCGSnapConfig <<<'

IF EXISTS (select * from sysobjects where name='QS_OraMultiDBCGSnapConfig')
	drop procedure QS_OraMultiDBCGSnapConfig
IF EXISTS (select * from GxQscripts where name='QS_OraMultiDBCGSnapConfig')
	delete from GxQscripts where name = 'QS_OraMultiDBCGSnapConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_OraMultiDBCGSnapConfig')
	delete from GXDBVersions where aliasname = 'QS_OraMultiDBCGSnapConfig'
GO
print '... Creating Procedure: QS_OraMultiDBCGSnapConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_OraMultiDBCGSnapConfig
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientGroupName NVARCHAR(1024) = '%s',
  @hourlySchedPolicyName NVARCHAR(1024) = '%s',
  @dailySchedPolicyName NVARCHAR(1024) = '%s',
  @fullScan NVARCHAR(1024) = '%s'
AS
------------------input prefixes-----------------------------------------
DECLARE @clientGroupId			INT
DECLARE @hourlySchePolicyId		INT
DECLARE @dailySchePolicyId		INT
DECLARE @full					INT
----------------------constants------------------------------------------
DECLARE @scriptName nvarchar(128) = 'OraMultiDBCGSnapConfig'
DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @oracleApptype integer = 22
DECLARE @lastCheckTimeProp nvarchar(128) = 'OraInstanceScanTime'
DECLARE @lastCheckTime	INT = 0
DECLARE @descriptName nvarchar(128) ='User Description'
DECLARE @excludeDescription nvarchar(128) = '%exclude from cvsnap schedule%'
DECLARE @cloneDbSnapName nvarchar(128) = '_clone'
DECLARE @dbSnapName nvarchar(128) = '_snap'
DECLARE @ignorASM nvarchar(128) = '+ASM'
DECLARE @assocType INT = 7 --ENTITY_TYPE_SUBCLIENT_ENTITY
---TEST----
--SET @clientGroupName='Ying'
--SET @hourlySchedPolicyName='cluster_AMFAM'
--SET @dailySchedPolicyName='AMFAM'
--SET @fullScan='y'
-----------------------error handling------------------------------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters -----------------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @clientGroupName = @noParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Client group name was not supplied as an input.'
    GOTO ERROR_EXIT
END
SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name like @clientGroupName), 0)
IF @clientGroupId = 0
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Client group ['+@clientGroupName+'] not found.'
    GOTO ERROR_EXIT
END
IF @hourlySchedPolicyName = @noParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Hourly schedule policy name was not supplied as an input.'
    GOTO ERROR_EXIT
END
SET @hourlySchePolicyId = ISNULL((SELECT taskId FROM TM_Task WHERE taskName like @hourlySchedPolicyName), 0)
IF @hourlySchePolicyId = 0
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Schedule policy ['+@hourlySchedPolicyName+'] not found.'
    GOTO ERROR_EXIT
END
IF @dailySchedPolicyName = @noParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Hourly schedule policy name was not supplied as an input.'
    GOTO ERROR_EXIT
END
SET @dailySchePolicyId = ISNULL((SELECT taskId FROM TM_Task WHERE taskName like @dailySchedPolicyName), 0)
IF @dailySchePolicyId = 0
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Schedule policy ['+@dailySchedPolicyName+'] not found.'
    GOTO ERROR_EXIT
END
IF @fullScan <> 'y' OR @fullScan <> 'Y'
BEGIN
	SET @lastCheckTime = ISNULL((SELECT CAST(value AS VARCHAR(100)) FROM GXGlobalParam where name=@lastCheckTimeProp), 0)
END
-------------------------------------------------------------------------------
DECLARE @clientId		INT
DECLARE @appTypeId		INT
DECLARE @instanceId		INT
DECLARE @backupSetId	INT
DECLARE @dataArchGrpId	INT
DECLARE @logArchGrpId	INT
--DECLARE @subclientId	INT
DECLARE @snapSCId		INT
DECLARE @cloneSnapSCId	INT
DECLARE @clientName		nvarchar(128)
DECLARE @instanceName	nvarchar(128)
DECLARE @messageText	nvarchar(max)='Created snap subclients for:' + CHAR(10)
BEGIN TRAN
	DECLARE curInstanceFound CURSOR FOR
	SELECT DISTINCT APP.clientId, C.name, APP.appTypeId, APP.instance, INS.name, APP.backupSet, APP. dataArchGrpID, APP.logArchGrpID
	FROM APP_Application APP WITH (NOLOCK)
	JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id=APP.instance AND (INS.refTime > @lastCheckTime OR @lastCheckTime = 0) AND INS.name <> @ignorASM
	JOIN APP_Client C ON C.id = APP.clientId
	JOIN APP_InstanceProp INP WITH (NOLOCK) ON INP.componentNameId=INS.id
	JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id=APP.backupSet
	WHERE APP.clientId in (
		SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId=@clientGroupId
	)
	AND APP.appTypeId=@oracleApptype	--ONLY FOR ORACLE APPTYPE
	AND	APP.subclientStatus&8=8			--ONLY GET ONE SUBCLIENT
	AND INS.status&16=0					--IGNORE defaultDummyInstanceForOracle
	AND NOT EXISTS(SELECT 1 FROM APP_Application AP WHERE AP.clientId=APP.clientId AND AP.instance=APP.instance AND (AP.subclientName=(INS.name+@cloneDbSnapName) OR AP.subclientName=(INS.name+@dbSnapName)))
	AND
	(
		(INP.attrName=@descriptName AND INP.modified=0 AND INP.attrVal not like @excludeDescription)
		OR
		NOT EXISTS (SELECT 1 FROM APP_InstanceProp WHERE componentNameId=INS.id AND attrName=@descriptName)
	)
	OPEN curInstanceFound
	FETCH NEXT FROM curInstanceFound INTO @clientId, @clientName, @appTypeId, @instanceId, @instanceName, @backupSetId, @dataArchGrpId, @logArchGrpId
	WHILE   @@FETCH_STATUS = 0
	BEGIN
		--CREATE SNAP SUBCLIENT
		INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
			VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @dataArchGrpId , @logArchGrpId , @nowTime, 0, @instanceName+@dbSnapName, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to create '+@instanceName+@dbSnapName+' subclient for client['+@clientName+'] instance['+@instanceName +'].'
			GOTO TRANS_EXIT
		END
		SET @snapSCId = @@IDENTITY
		--CREATE SNAP SUBCLIENT PROPERTIES
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Arch per bfs', 8, 32, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Archive Log Deleting', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Backup Archive Log', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Encrypt: encryption', 10, 2, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'force differential backup', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Single Instancing Option', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'last data SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'last log SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Enable Snap Backups', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Oracle Backup Archive Log Destinations', 1, '`', @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Oracle Log backup streams', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Oracle Data backup streams', 7, 3, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'sys: pre post option', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Use RMAN for Tape Movement', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Snap Engine', 10, 5, @nowTime , 0)	--SM_SNAPSHOT_ENGINE_SYMMETRIX_SNAP
		--ADD SUBCLIENT TO HOURLY SCHEDULE
		INSERT INTO TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId,
		sidbStoreId, libraryId, logMonitoringPolicyId)
		VALUES(@assocType, @hourlySchePolicyId, 0, @nowTime, 0, @clientId, @appTypeId, @instanceId, @backupSetId, @snapSCId, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to add subclient '+@snapSCId+' for client['+@clientName+'] instance['+@instanceName +'] to schedule policy ['+@hourlySchedPolicyName+'].'
			GOTO TRANS_EXIT
		END
		--CREATE CLONE SNAP SUBCLIENT
		INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
			VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @dataArchGrpId , @logArchGrpId , @nowTime, 0, @instanceName+@cloneDbSnapName, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to create '+@instanceName+@cloneDbSnapName+' subclient for client['+@clientName+'] instance['+@instanceName +'].'
			GOTO TRANS_EXIT
		END
		SET @cloneSnapSCId = @@IDENTITY
		--CREATE SNAP CLONE SUBCLIENT PROPERTIES
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Arch per bfs', 8, 32, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Archive Log Deleting', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Backup Control Files', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Encrypt: encryption', 10, 2, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'force differential backup', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Single Instancing Option', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'last data SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'last log SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Enable Snap Backups', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Oracle Backup Archive Log Destinations', 1, '`', @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Oracle Log backup streams', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Oracle Data backup streams', 7, 3, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'sys: pre post option', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Use RMAN for Tape Movement', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Snap Engine', 10, 28, @nowTime , 0)	--SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE
		--ADD SUBCLIENT TO DAILY SCHEDULE
		INSERT INTO TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId,
		sidbStoreId, libraryId, logMonitoringPolicyId)
		VALUES(@assocType, @dailySchePolicyId, 0, @nowTime, 0, @clientId, @appTypeId, @instanceId, @backupSetId, @cloneSnapSCId, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to add subclient '+@cloneDbSnapName+' for client['+@clientName+'] instance['+@instanceName +'] to schedule policy ['+@dailySchePolicyId+'].'
			GOTO TRANS_EXIT
		END
		SET @messageText = @messageText + ' Client ['+@clientName+'] Instance ['+@instanceName+']' + CHAR(10)
		FETCH NEXT FROM curInstanceFound INTO @clientId, @clientName, @appTypeId, @instanceId, @instanceName, @backupSetId, @dataArchGrpId, @logArchGrpId
	END
	CLOSE curInstanceFound
	DEALLOCATE curInstanceFound
	IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name=@lastCheckTimeProp)
		UPDATE GXGlobalParam SET value=CAST(@nowTime AS NVARCHAR(100)) WHERE name=@lastCheckTimeProp
	ELSE
		INSERT INTO GXGlobalParam (name, value, created, modified)
		VALUES(@lastCheckTimeProp, CAST(@nowTime AS NVARCHAR(100)), @nowTime, 0)
TRANS_EXIT:
IF @errorCode <> 0
BEGIN
    ROLLBACK TRAN
	PRINT 'Nothing created'
END
ELSE
BEGIN
    COMMIT TRAN
	PRINT @messageText
END
ERROR_EXIT:
Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+  Convert(varchar(10), @errorCode) +').'
    --Close cursor
    IF ( CURSOR_STATUS('global', 'curInstanceFound') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'curInstanceFound') >= 0 )
        CLOSE curInstanceFound
    IF ( CURSOR_STATUS('global','curInstanceFound') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','curInstanceFound') = -1 )
        DEALLOCATE curInstanceFound
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_OraMultiDBCGSnapConfig')
	delete from GxQscripts where name = 'QS_OraMultiDBCGSnapConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_OraMultiDBCGSnapConfig')
	delete from GXDBVersions where aliasname = 'QS_OraMultiDBCGSnapConfig'
GO

insert into GXDBVersions values(2, 'QS_OraMultiDBCGSnapConfig',  '00000000000000000000', 'QS_OraMultiDBCGSnapConfig', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_OraMultiDBCGSnapConfig',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn OraMultiDBCGSnapConfig.sql -i [client group name] [hourly schedule policy name daily] [schedule policy name] [y/n (full scan)]
'
 + CHAR(10) + '--   script_name : OraMultiDBCGSnapConfig'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ConfigureRemoteCache.sp] ---------- 

-------------------------------------------
--         Name:   QS_ConfigureRemoteCache.sp
--         Date:   05/29/2013
--       Author:   Shravani Chepuri
--  Description:   Configure the remote software cache.
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ConfigureRemoteCache <<<'

IF EXISTS (select * from sysobjects where name='QS_ConfigureRemoteCache')
	drop procedure QS_ConfigureRemoteCache
IF EXISTS (select * from GxQscripts where name='QS_ConfigureRemoteCache')
	delete from GxQscripts where name = 'QS_ConfigureRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_ConfigureRemoteCache'
GO
print '... Creating Procedure: QS_ConfigureRemoteCache'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ConfigureRemoteCache
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName NVARCHAR(1024),
  @swCachePath NVARCHAR(1024),
  @clGroupName NVARCHAR(1024)= ' ',
  @isNetworkShare INTEGER = 0,
  @userName NVARCHAR(1024) = ' ',
  @passWord NVARCHAR(1024) = ' '
AS
SET NOCOUNT ON
DECLARE @localErrorMsg	varchar(512)
DECLARE @clientId   INTEGER
DECLARE @clGroupId   INTEGER
DECLARE @uaId	INTEGER
DECLARE @lastError	INTEGER
DECLARE @remoteCacheConfigured INTEGER
SET	@lastError	= 0
SET @clientId=0
SET @clGroupId=0
SET @uaId=0
SET	@remoteCacheConfigured	= 0
SELECT @clientId=id from APP_Client where name like @clientName
SELECT @clGroupId=id from APP_ClientGroup where name like @clGroupName
IF @clientId=0
BEGIN
	SET @localErrorMsg = 'Input clientName ' + @clientName +' is incorrect.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
ELSE
BEGIN
	IF  NOT EXISTS (SELECT * FROM PatchUpdateAgentInfo PI WHERE PI.clientId=@clientId )
	BEGIN
		insert into PatchUpdateAgentInfo Values(@clientId,1,@swCachePath,'','',1,1,0,0,0,'')
		SET	@remoteCacheConfigured	= 1
		SET @localErrorMsg = 'Remote Cache is Configured.'
	END
	ELSE IF EXISTS (SELECT * FROM PatchUpdateAgentInfo PI WHERE PI.clientId=@clientId and PI.isDeleted=1)
	BEGIN
		UPDATE PatchUpdateAgentInfo SET cachePath=@swCachePath, isLocalDrive=1,isDeleted=0,isEnabled=1,autoSyncWithCS=1,inSyncWithCS=0,packageStatus=0 where clientId=@clientId
		SET	@remoteCacheConfigured	= 1
		SET @localErrorMsg = 'Remote Cache is Configured.'
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Remote Cache already exists.'
	END
	if object_id('CommServ.dbo.PatchUAContentConfig') IS NOT null
	BEGIN
              DECLARE @csRelId INT
	      SET @csRelId = (SELECT releaseId FROM  APP_Client WHERE id = 2)
	      DECLARE @uaRelId INT
              SET @uaRelId = (SELECT releaseId FROM  APP_Client WHERE id = @clientId)
              IF NOT EXISTS (SELECT * FROM PatchUAContentConfig WHERE UAClientId = @clientId and ReleaseId = @csRelId)
              BEGIN
                   IF @csRelId = @uaRelId
		   BEGIN
			--insert the default values in PatchUAContentConfig table
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,1,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,3,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,14,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,15,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,16,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,17,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,18,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,20,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,22,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,23,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,24,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,25,1,1,'','')
			INSERT INTO PatchUAContentConfig(UAClientId,ReleaseId,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesinCache) values(@clientId, @csRelId,26,1,1,'','')
		   END
              END
	END
	SELECT @uaId=id from PatchUpdateAgentInfo where clientId=@clientId
	IF @uaId <> 0
	BEGIN
		IF @remoteCacheConfigured = 1
		BEGIN
			--If already exists, Clear it
			IF EXISTS (SELECT * FROM app_clientProp where componentNameId=@clientId and attrName='UPDATE CACHE AGENT ID')
			BEGIN
				delete from app_clientProp where componentNameId=@clientId and attrName='UPDATE CACHE AGENT ID'
			END
			insert into app_clientProp Values(@clientId,'UPDATE CACHE AGENT ID',7,@uaId,0,0,0)
			IF @isNetworkShare <> 0
			BEGIN
				UPDATE PatchUpdateAgentInfo SET isLocalDrive=0, username=@userName, passwd=@passWord where clientId=@clientId
			END
		END
		IF @clGroupName NOT LIKE ' '
		BEGIN
			IF @clGroupId = 0
			BEGIN
				SET @localErrorMsg = @localErrorMsg + 'Incorrect clientgroup name ' + @clGroupName + ' has been given to associate with it'
				Set @lastError = 1
				goto   ARGS_ERROR
			END
			ELSE
			BEGIN
				--If already exists, Clear it
				IF EXISTS (SELECT * FROM APP_ComponentProp where componentType=8 and componentId=@clGroupId and propertyTypeId=1300)
				BEGIN
					delete from APP_ComponentProp where componentType=8 and componentId=@clGroupId and propertyTypeId=1300
				END
				insert into APP_ComponentProp Values( 8,@clGroupId,1300,10,@uaId,0,'',0,0)
				SET @localErrorMsg = @localErrorMsg + 'Associated the specified client group to the Remote Cache.'
			END
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Failed to configure the Remote cache for the given client ' + @clientName
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
ARGS_ERROR:
	PRINT @localErrorMsg
	if @lastError <> 0
	BEGIN
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ConfigureRemoteCache')
	delete from GxQscripts where name = 'QS_ConfigureRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ConfigureRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_ConfigureRemoteCache'
GO

insert into GXDBVersions values(2, 'QS_ConfigureRemoteCache',  '00000000000000000000', 'QS_ConfigureRemoteCache', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ConfigureRemoteCache',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        Script to configure the remote software cache and associate the input client group with the configured remote cache.
'
 + CHAR(10) + '        Usage: Qoperation execscript sn QS_ConfigureRemoteCache -si ''Clientname'' -si ''SoftwareCachePath'' -si ''ClientGroupName'' -si ''1 or 0 (isNetworkShare)'' -si ''cachePathUserName'' -si ''encryptedPasswd''
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCache -si myClient -si C:\SWCache
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCache -si myClient -si C:\SWCache -si mygroup
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_ConfigureRemoteCache -si myClient -si \\xxx\SWCache -si mygroup -si 1 -si ''domainusername'' -si ''Password''
'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientOwnersList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  GetClientOwners()
--  | Description:  Get user information given username
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetClientOwnersList.sp,v $ $Id: GetClientOwnersList.sp,v 1.3 2014/12/08 15:40:56 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientOwnersList <<<'

IF EXISTS (select * from sysobjects where name='GetClientOwnersList')
	drop procedure GetClientOwnersList
IF EXISTS (select * from GxQscripts where name='GetClientOwnersList')
	delete from GxQscripts where name = 'GetClientOwnersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientOwnersList')
	delete from GXDBVersions where aliasname = 'GetClientOwnersList'
GO
print '... Creating Procedure: GetClientOwnersList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientOwnersList
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML	
BEGIN
SET @o_xmlText = '<EVGui_GetClientOwnersResp />'
DECLARE @i_clientId     INT
SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int') FROM @i_xmlText.nodes('EVGui_GetClientOwners/client') R ( ref ) ), 0)
IF @i_clientId = 0
BEGIN
        SET @o_ErrorCode = 2
        SET @o_ErrorString = 'Client Id Not Found'
        GOTO EXIT_PROC
END
set @o_xmlText=(select (select case when CHARINDEX('\',t2.login)>0 then '1' else '0' end as "@isExternal"
,t1.userid as "user/@userId" ,t2.login as "user/@userName"
from sec_getCLientOwners (1) t1, UMUsers t2 where
t1.clientId = @i_clientId
and t1.userId=t2.id for xml path('Owner'),type )
for xml path('EVGui_GetClientOwnersResp'),type)
EXIT_PROC:
IF @o_ErrorCode > 0
BEGIN
    SET @o_xmlText =
       (
           SELECT @o_ErrorCode '@errorCode',
                  @o_ErrorString '@errorMessage'
           FOR XML PATH ('error'), ROOT('EVGui_GetClientOwnersResp')
       )
    END
	SELECT @o_xmlText
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetClientOwnersList')
	delete from GxQscripts where name = 'GetClientOwnersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientOwnersList')
	delete from GXDBVersions where aliasname = 'GetClientOwnersList'
GO

insert into GXDBVersions values(2, 'GetClientOwnersList',  '00010003000000000000', 'GetClientOwnersList', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ListMAForIndexCacheProfile.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ListMAForIndexCacheProfile <<<'

IF EXISTS (select * from sysobjects where name='QS_ListMAForIndexCacheProfile')
	drop procedure QS_ListMAForIndexCacheProfile
IF EXISTS (select * from GxQscripts where name='QS_ListMAForIndexCacheProfile')
	delete from GxQscripts where name = 'QS_ListMAForIndexCacheProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListMAForIndexCacheProfile')
	delete from GXDBVersions where aliasname = 'QS_ListMAForIndexCacheProfile'
GO
print '... Creating Procedure: QS_ListMAForIndexCacheProfile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ListMAForIndexCacheProfile
  @catalogServerName VARCHAR(1024) = '%s'
AS
SET NOCOUNT ON
IF NOT EXISTS(SELECT IdxCacheId FROM IdxCache WHERE CatalogServerClientId <> 0 AND Description = @catalogServerName)
BEGIN
	PRINT 'An index cache profile with the given name does not exist'
	RETURN (-1)
END
SELECT Client.name AS 'ClientName', Client.net_hostname AS 'HostName' FROM IdxAccessPath AccessPath, App_Client Client
WHERE
IdxCacheId IN (SELECT IdxCacheId FROM IdxCache WHERE CatalogServerClientId <> 0 AND Description = @catalogServerName)
AND AccessPath.ClientId = Client.id
IF @@ROWCOUNT = 0
BEGIN
PRINT 'No MediaAgents associated with the given index cache profile'
END
RETURN (0)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ListMAForIndexCacheProfile')
	delete from GxQscripts where name = 'QS_ListMAForIndexCacheProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ListMAForIndexCacheProfile')
	delete from GXDBVersions where aliasname = 'QS_ListMAForIndexCacheProfile'
GO

insert into GXDBVersions values(2, 'QS_ListMAForIndexCacheProfile',  '00000000000000000000', 'QS_ListMAForIndexCacheProfile', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ListMAForIndexCacheProfile',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn QS_ListMAForIndexCacheProfile.sql -si <indexcache-profile-name>
'
 + CHAR(10) + ' If the index cache profile name has unicode or special characters, use double quotes around the index cache profile name
'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GranularConfigRemoteCache.sp] ---------- 

-------------------------------------------
--         Name:   QS_GranularConfigRemoteCache.sp
--         Date:   12/04/2013
--       Author:   Praveen Kuttappan
--  Description:   configure the packages in remote cache to support granular sync.
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GranularConfigRemoteCache <<<'

IF EXISTS (select * from sysobjects where name='QS_GranularConfigRemoteCache')
	drop procedure QS_GranularConfigRemoteCache
IF EXISTS (select * from GxQscripts where name='QS_GranularConfigRemoteCache')
	delete from GxQscripts where name = 'QS_GranularConfigRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GranularConfigRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_GranularConfigRemoteCache'
GO
print '... Creating Procedure: QS_GranularConfigRemoteCache'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GranularConfigRemoteCache
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName NVARCHAR(max),
  @syncOption NVARCHAR(100),
  @platform1 NVARCHAR(1024)= '',
  @packages1 NVARCHAR(1024)= '',
  @platform2 NVARCHAR(1024)= '',
  @packages2 NVARCHAR(1024)= ''
AS
SET NOCOUNT ON
DECLARE @localErrorMsg	varchar(max)
DECLARE @clientId   INTEGER
DECLARE @lastError	INTEGER
DECLARE @invalidWinPlatform varchar(1024)
DECLARE @invalidUnixPlatform varchar(1024)
DECLARE @invalidWinPackages varchar(1024)
DECLARE @invalidUnixPackages varchar(1024)
DECLARE @invalidUANames varchar(max)
DECLARE @synPackage INTEGER
DECLARE @oTempRCName table ( UANAme varchar(1024))
DECLARE @oTempOsID  INTEGER
DECLARE @tempPlatforms varchar(100)
DECLARE @PackagesList varchar(1024)
DECLARE @currentPackages varchar(1024)
DECLARE @csRelId INT
DECLARE @winPlatform NVARCHAR(1024)= ''
DECLARE @winPackages NVARCHAR(1024)= ''
DECLARE @unixPlatform NVARCHAR(1024)= ''
DECLARE @unixPackages NVARCHAR(1024)= ''
SET	@lastError	= 0
SET @clientId=0
SET @synPackage =0
--Setting CS release version
SET @csRelId = (SELECT releaseId FROM  APP_Client WHERE id = 2)
IF object_id('tempdb.dbo.#ApplicablePlatform') IS NOT null
DROP TABLE #ApplicablePlatform
create table #ApplicablePlatform
(
     OSId	integer,
     isWindows  integer
)
--Temporary table is created to store all valid remote cache UA ID
if object_id('tempdb.dbo.#UA_RCID') IS NOT null DROP TABLE #UA_RCID
create table #UA_RCID
(
	UAId [INTEGER],
	isSyncRequired [INTEGER]
)
insert into #ApplicablePlatform(OSId,isWindows) values(1,1);
insert into #ApplicablePlatform(OSId,isWindows) values(3,1);
insert into #ApplicablePlatform(OSId,isWindows) values(14,0);
insert into #ApplicablePlatform(OSId,isWindows) values(15,0);
insert into #ApplicablePlatform(OSId,isWindows) values(16,0);
insert into #ApplicablePlatform(OSId,isWindows) values(17,0);
insert into #ApplicablePlatform(OSId,isWindows) values(18,0);
insert into #ApplicablePlatform(OSId,isWindows) values(20,0);
insert into #ApplicablePlatform(OSId,isWindows) values(22,0);
insert into #ApplicablePlatform(OSId,isWindows) values(23,0);
insert into #ApplicablePlatform(OSId,isWindows) values(24,0);
insert into #ApplicablePlatform(OSId,isWindows) values(25,0);
insert into #ApplicablePlatform(OSId,isWindows) values(26,0);
--PatchUAContentConfig table is added in V10 SP5 to support granular sync. Validating CS version and return error if version is below V10 SP5
IF object_id('CommServ.dbo.PatchUAContentConfig') IS  null or @csRelId < 15
BEGIN
      SET @localErrorMsg = 'This feature is not supported on version below V10 SP5'
      Set @lastError = 1
      goto   ARGS_ERROR
END
--Setting sync up value according to input. This will be used to insert/update in PatchUaContentConfig table
IF @syncOption like 'SyncAll'
BEGIN
      --Sync all packages for all OS
      SET @synPackage = 1
END
ELSE IF @syncOption like 'SyncNone'
BEGIN
      --Sync updates only for all OS
      SET @synPackage = 0
END
ELSE IF @syncOption like 'SyncCustom'
BEGIN
      --Sync Packages according to list of packages in input
    SET @synPackage = 3
      IF @platform1 = '' or exists (Select _ID from dbo.SplitIDString(@platform1) where _Id in (select OSId from #ApplicablePlatform where isWindows = 1))
      BEGIN
            set @winPlatform  = @platform1
	    set @winPackages = @packages1
	    set @unixPlatform = @platform2
	    set @unixPackages = @packages2
      END
      ELSE
      BEGIN
	    set @winPlatform  = @platform2
	    set @winPackages = @packages2
	    set @unixPlatform = @platform1
	    set @unixPackages = @packages1
      END
      --Platform ID validation: returns error and invalid platform list as error string if given platform ID is not part of defined platform set
      select @invalidWinPlatform = stuff((select ',' +  _ID from dbo.SplitIDString(@winPlatform) where _ID  not in (select CAST(OSId as varchar) from #ApplicablePlatform where isWindows = 1)
                                   for xml path('')),1,1,'')
      select @invalidUnixPlatform = stuff((select ',' +  _ID from dbo.SplitIDString(@unixPlatform)  where _ID  not in (select CAST(OSId as varchar) from #ApplicablePlatform where isWindows = 0)
				   for xml path('')),1,1,'')
      --Package ID verification
      select @invalidWinPackages = stuff((select ',' +  _ID from (SELECT _ID from dbo.SplitIDString(@winPackages) EXCEPT
                                                                  SELECT cast(id as varchar) from simPackage where InstallableFromGUI = 1  and id < 1001) temp
				   for xml path('')),1,1,'')
      --Package ID verification
      select @invalidUnixPackages = stuff((select ',' +  _ID from (SELECT _ID from dbo.SplitIDString(@unixPackages) EXCEPT
								   SELECT cast(id as varchar) from simPackage where InstallableFromGUI = 1  and id > 1001 and id < 2000) temp
				    for xml path('')),1,1,'')
END
ELSE
BEGIN
      SET @localErrorMsg = 'Invalid sync option. Valid option is one of the following[SyncAll/SyncNone/SyncCustom]'
      SET @lastError = 1
      goto   ARGS_ERROR
END
--Platform and Packages list must be blank if sync option is either SyncAll or SyncNone
IF (@synPackage =1 or @synPackage =0) and (@platform1 not like '' or @packages1 not like '' or @platform2 not like '' or @packages2 not like '')
BEGIN
      SET @localErrorMsg = 'Invalid Input:Platform or package list are not required if sync option  is SyncAll and SyncNone'
      SET @lastError = 1
      goto  ARGS_ERROR
END
IF LEN(@invalidWinPlatform) > 0
BEGIN
      SET @localErrorMsg = 'Invalid Windows Platforms list:[' + @invalidWinPlatform + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF  LEN(@invalidUnixPlatform) > 0
BEGIN
      SET @localErrorMsg = 'Invalid Unix Platforms list:[' +  @invalidUnixPlatform + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF LEN(@invalidWinPackages) > 0
BEGIN
      SET @localErrorMsg = 'Invalid Windows Packages list:[' + @invalidWinPackages + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF  LEN(@invalidUnixPackages) > 0
BEGIN
      SET @localErrorMsg =  'Invalid Unix Packages list:[' +  @invalidUnixPackages + ']'
      Set @lastError = 1
      goto  ARGS_ERROR
END
IF @clientName like 'All'
BEGIN
      --Get all existing remote cache and insert into temporary table
      INSERT  INTO #UA_RCID
(UAId,isSyncRequired )
      SELECT clientId,0 FROM PatchUpdateAgentInfo PI inner join APP_Client UA on UA.id = PI.clientId
 WHERE PI.isDeleted =0 and UA.releaseId = @csRelId and PI.clientId <> 2
END
ELSE IF @clientName  not like '' and @clientName  not like ' '
BEGIN
      INSERT  INTO  @oTempRCName SELECT distinct data FROM dbo.SplitString(@clientName,',')
      --Insert UA ID for all valid UA names in input
      INSERT  INTO #UA_RCID
(UAId,isSyncRequired )
      SELECT PI.clientId,0 FROM PatchUpdateAgentInfo PI inner join APP_Client UA  on UA.id = PI.clientId
      WHERE UA.name in (select UANAme from @oTempRCName) and PI.isDeleted = 0 and
UA.releaseId = @csRelId and
 PI.clientId <> 2
		      --Find and assign any Invalid UA name
      select @invalidUANames = stuff((select ',' +  name from (SELECT data as name FROM dbo.SplitString(@clientName,',')
EXCEPT
                                                               SELECT  name from APP_Client UA	where UA.id in (select UAId from #UA_RCID)) temp
				       for xml path('')),1,1,'')
      if LEN(@invalidUANames) > 0
      BEGIN
            SET @localErrorMsg = 'Following Remote Cache names are not valid:[' + @invalidUANames + ']'
            Set @lastError = 1
				    goto  ARGS_ERROR
      END
END
ELSE
BEGIN
      SET @localErrorMsg = 'Remote Cache Name cannot be blank'
      Set @lastError = 1
      goto   ARGS_ERROR
END
DECLARE remoteCacheCur CURSOR FOR SELECT UAId,OSId FROM #UA_RCID cross join #ApplicablePlatform
OPEN remoteCacheCur
FETCH NEXT FROM remoteCacheCur INTO @clientId,@oTempOsID
WHILE @@FETCH_STATUS = 0
BEGIN
      IF @synPackage = 1 or @synPackage = 0
            SET @PackagesList = ''
      ELSE
      BEGIN
            SET @PackagesList = ''
            IF exists (SELECT _ID from dbo.SplitIDString(@winPlatform) where _ID = @oTempOsID)
            BEGIN
		  IF @winPackages like ''
                       SET @synPackage = 2
		  ELSE
                       SET @synPackage =3
                 SET @PackagesList =  @winPackages
            END
            ELSE IF exists (SELECT _ID from dbo.SplitIDString (@unixPlatform) where _ID = @oTempOsID)
            BEGIN
                  IF @unixPackages like ''
                       SET @synPackage = 2
                  ELSE
                       SET @synPackage =3
                 SET @PackagesList =  @unixPackages
            END
            ELSE IF @winPlatform = '' and @unixPlatform = ''
	        BEGIN
                 SET @synPackage = 2
            END
            ELSE
                 GOTO NEXTUA
      END
      IF exists (select * from PatchUAContentConfig PUA where PUA.UACLientId =  @clientId and PUA.releaseId = @csRelId and PUA.OSId = @oTempOsID)
      BEGIN
            select @currentPackages = SelectedPackageList from PatchUAContentConfig PUA where PUA.UACLientId =  @clientId and PUA.releaseId =  @csRelId and PUA.OSId = @oTempOsID
            select @PackagesList = stuff((select ',' +  _ID from (select _ID from dbo.SplitIDString(@PackagesList) EXCEPT select _ID from dbo.SplitIDString(@currentPackages)) temp
                                   for xml path('')),1,1,'')
					    IF LEN(@PackagesList) > 0 and LEN(@currentPackages) > 0
                 SET @PackagesList = @currentPackages + ',' + @PackagesList
			            ELSE IF LEN(@PackagesList) > 0
                 SET @PackagesList = @PackagesList
            ELSE
                 SET @PackagesList = @currentPackages
            if 	@synPackage <> 3
                SET @PackagesList = ''
            update #UA_RCID set isSyncRequired = 1 where UAId = @clientId and not exists
             (select * from PatchUAContentConfig  where UAClientId =  @clientId and releaseId =  @csRelId and OSId = @oTempOsID and syncPackages = @synPackage and SelectedPackageList = @PackagesList)
            update PatchUAContentConfig  set syncPackages = @synPackage,SelectedPackageList = @PackagesList
            where UAClientId =  @clientId and releaseId =  @csRelId and OSId = @oTempOsID
     END
     ELSE
     BEGIN
	    insert into PatchUAContentConfig(UaClientId,ReleaseID,OSId,SyncPackages,SyncUpdates,SelectedPackageList,PackagesInCache)
            values(@clientId,@csRelId,@oTempOsID,@synPackage,1,@PackagesList,'')
            update #UA_RCID set isSyncRequired = 1 where UAId = @clientId
     END
     NEXTUA: fetch next from remoteCacheCur into @clientId,@oTempOsID
END
CLOSE remoteCacheCur
deallocate remoteCacheCur
--Following block will set syncPackages column to 2 for all other rows if previous selection was to sync all or syunc none and current option is syncCustom
--This is required to display configuration correctly in GUI(AS per the initial design of GRanular sync)
if @synPackage <> 1 and @synPackage <> 0
BEGIN
     update PatchUAContentConfig set SyncPackages = 2 , SelectedPackageList =''
     where SyncPackages in (1,0) and UAClientId in (select UAId from #UA_RCID) and UAClientId in (select distinct UA1.UAClientId from PatchUAContentConfig UA1 where UA1.SyncPackages in(2,3))
END
UPDATE PatchUpdateAgentInfo SET inSyncWithCS =0,packageStatus=0  WHERE clientId IN (select UAId from #UA_RCID where isSyncRequired =1)
DROP TABLE #ApplicablePlatform
DROP TABLE #UA_RCID
ARGS_ERROR:
 PRINT @localErrorMsg
            if @lastError <> 0
            BEGIN
                  Raiserror(@localErrorMsg,
15, --Severity (> 10 to force DOS Error Code = 1)
				    1	 --State
					)
            END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GranularConfigRemoteCache')
	delete from GxQscripts where name = 'QS_GranularConfigRemoteCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GranularConfigRemoteCache')
	delete from GXDBVersions where aliasname = 'QS_GranularConfigRemoteCache'
GO

insert into GXDBVersions values(2, 'QS_GranularConfigRemoteCache',  '00000000000000000000', 'QS_GranularConfigRemoteCache', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GranularConfigRemoteCache',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        Usage: Qoperation execscript sn QS_GranularConfigRemoteCache -si ''RemoteCachesName'' -si ''SyncOption'' -si ''Windows platform IDs'' -si ''Windows package IDs'' -si ''Unix platform IDs'' -si ''Unix package IDs''
'
 + CHAR(10) + '	RemoteCachesName will be either ''All'' or comma seperated remote caches name
'
 + CHAR(10) + '	Following are the valid sync options [SyncAll/SyncNone/SyncCustom]
'
 + CHAR(10) + '	SyncAll    : Sync all packages for all platforms
'
 + CHAR(10) + '	SyncNone   : Do not synchronize any packages
'
 + CHAR(10) + '	SyncCustom : sync only selected packages for selected platforms
'
 + CHAR(10) + '	Following are the valid platform ID for each platforms [Windows(32)=1, Windows(X64)=3,Aix PPC=14,Darwin X86=24,Freebsd X86=25,Freebsd X86_64=26,Hp IA64=20,Linux X86=15,Linux X86_64=16,Linux PPC64=17,Linux 390=18,Solaris SPARC=22,Solaris X86_64=23]
'
 + CHAR(10) + '        Please refer SimPackage table for package IDs
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si All -si SyncAll
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si All -si SyncNone
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''myClient1,myClient2'' -si SyncAll
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''myClient1,myClient2'' -si SyncNone
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''All'' -si SyncCustom -si ''1,3'' -si ''1,702''
'
 + CHAR(10) + '	Example: qoperation execscript -sn QS_GranularConfigRemoteCache -si ''All'' -si SyncCustom -si ''1,3'' -si ''1,702'' -si ''24,25'' -si ''1002''
'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetWormCopyToRegularCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ResetWormCopyToRegularCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_ResetWormCopyToRegularCopy')
	drop procedure QS_ResetWormCopyToRegularCopy
IF EXISTS (select * from GxQscripts where name='QS_ResetWormCopyToRegularCopy')
	delete from GxQscripts where name = 'QS_ResetWormCopyToRegularCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetWormCopyToRegularCopy')
	delete from GXDBVersions where aliasname = 'QS_ResetWormCopyToRegularCopy'
GO
print '... Creating Procedure: QS_ResetWormCopyToRegularCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ResetWormCopyToRegularCopy
-- Qscript is enabled
-- Set to low audit level
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_StoragePolicy nvarchar(2048)='',
  @i_StoragePolicyCopy nvarchar(2048)='',
  @i_authCode nvarchar(1024)=''
AS
SET NOCOUNT ON
DECLARE  @errorCode 	INTEGER = 0
DECLARE	 @errorString  	VARCHAR(1024)
-- Reset the WORM COPY as regular copy to allow the copy deletion
--SET @i_StoragePolicy = N'Exchange Data Protection 1-2 (commvaultsrv1)-DP(11)'
--SET @i_StoragePolicyCopy = N'Secondary'
DECLARE @i_SPId INTEGER
SET     @i_SPId = -1
DECLARE @i_SPCId INTEGER
SET     @i_SPCId = -1
DECLARE @i_Authenticate    INTEGER
DECLARE @l_commCellNumber  INTEGER
SELECT @i_SPId = Id
FROM archGroup WITH (NOLOCK)
WHERE name = @i_StoragePolicy
SET @errorCode = @@ERROR
IF  @errorCode <> 0 GOTO CX_EXIT
IF @i_SPId = -1
BEGIN
    SET @errorCode = -1
    SET @errorString = 'Error: Invalid Storage Policy Name [' + @i_StoragePolicy + ']'
    GOTO CX_EXIT
END
SELECT @i_SPCId = id
FROM archGroupCopy WITH (NOLOCK)
WHERE   name = @i_StoragePolicyCopy
        AND archGroupId = @i_SPId
SET @errorCode = @@ERROR
IF  @errorCode <> 0 GOTO CX_EXIT
IF @i_SPCId = -1
BEGIN
    SET @errorCode = -2
    SET @errorString = 'Error: Invalid Storage Policy Copy Name [' + @i_StoragePolicyCopy + ']'
    GOTO CX_EXIT
END
IF EXISTS (SELECT * FROM archGroupCopy WHERE id = @i_SPCId AND archGroupId = @i_SPId AND ((flags & 16777216) = 0))
BEGIN
    SET @errorCode = -3
    SET @errorString = 'Error: Storage Policy Copy [' + @i_StoragePolicyCopy + '] is not worm copy'
    GOTO CX_EXIT
END
SELECT @l_commCellNumber = number
FROM APP_CommCell
WHERE id = 2
SELECT  @errorCode = @@ERROR, @errorString = ERROR_MESSAGE()
IF  @errorCode <> 0 GOTO CX_EXIT
----Test for authentication
-- SET @i_authCode = CAST((CHECKSUM(HASHBYTES('SHA1', '<' + CAST(@l_commCellNumber AS VARCHAR(100)) + '><ResetWORMCopyToRegularCopy-COMMVAULT><Copy' + CAST
IF(@i_authCode = '' OR @i_authCode = '%s') --IF Authentication code is not passed
BEGIN
    SET @errorCode = -4
    SET @errorString = 'Need Auth code to execute this script, please contact customer support for auth code.'
    GOTO CX_EXIT
END
ELSE
BEGIN
    SET @i_Authenticate = CONVERT(INTEGER, @i_authCode)
    IF ((CHECKSUM(HASHBYTES('SHA1', '<' + CAST(@l_commCellNumber AS VARCHAR(100)) + '><ResetWORMCopyToRegularCopy-COMMVAULT><Copy' + CAST(@i_SPCId AS VARCHAR(100)) + '>')) & 2147483646) <> @i_Authenticate)
    BEGIN
        SET @errorCode = -5
        SET @errorString = 'Error: Invalid Auth code, please contact customer support for valid auth code.'
        GOTO CX_EXIT
    END
END;
-- Disable Trigger
DISABLE TRIGGER ArchGroupCopyUpgTrigger ON archgroupcopy;
UPDATE  archGroupCopy
SET     flags = flags & ~16777216
WHERE   Id = @i_SPCId
        AND (flags & 16777216) <> 0
SELECT  @errorCode = @@ERROR, @errorString = ERROR_MESSAGE()
IF  @errorCode <> 0 GOTO CX_EXIT
CX_EXIT:
-- Re enable Trigger
ENABLE TRIGGER ArchGroupCopyUpgTrigger ON archgroupcopy;
    IF (@errorCode <> 0)
    BEGIN
        Raiserror(@errorString,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
    END
RETURN @errorCode -- return the error code as well
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetWormCopyToRegularCopy')
	delete from GxQscripts where name = 'QS_ResetWormCopyToRegularCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetWormCopyToRegularCopy')
	delete from GXDBVersions where aliasname = 'QS_ResetWormCopyToRegularCopy'
GO

insert into GXDBVersions values(2, 'QS_ResetWormCopyToRegularCopy',  '00000000000000000000', 'QS_ResetWormCopyToRegularCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ResetWormCopyToRegularCopy',  2, GETDATE(), GETDATE(), '' + CHAR(10) + ' Qscript to update the device access path for a given library name and media agent client name.
'
 + CHAR(10) + ' Usage:
'
 + CHAR(10) + '--  qoperation execscript -sn ResetWormCopyToRegularCopy -si Storage_Policy_Name -si Storage_Policy_Copy_Name -si Auth_Code'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetFlushBlockSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetFlushBlockSize.sp,v $ $Id: QS_SetFlushBlockSize.sp,v 1.5 2015/03/11 05:00:10 kbora Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetFlushBlockSize <<<'

IF EXISTS (select * from sysobjects where name='QS_SetFlushBlockSize')
	drop procedure QS_SetFlushBlockSize
IF EXISTS (select * from GxQscripts where name='QS_SetFlushBlockSize')
	delete from GxQscripts where name = 'QS_SetFlushBlockSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetFlushBlockSize')
	delete from GXDBVersions where aliasname = 'QS_SetFlushBlockSize'
GO
print '... Creating Procedure: QS_SetFlushBlockSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetFlushBlockSize
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @option NVARCHAR(64),
  @RecordingFormat NVARCHAR(MAX),
  @FlushBlockSize INT = 0
AS
SET NOCOUNT ON
DECLARE @Str VARCHAR(1024)
DECLARE @CurFlushBlockSize INT
IF @option <> 'SET' AND @option <> 'VIEW'
BEGIN
	SET @Str = 'Error. Invalid option parameter [' + @option + '] specified.'
	GOTO PROC_ERROR
END
IF @option = 'SET' AND (@FlushBlockSize%32 <> 0 OR @FlushBlockSize>2048 OR @FlushBlockSize<=0)
BEGIN
	SET @Str = 'Invalid flush block size, please enter valid flush block size [32,64..2048]'
	GOTO PROC_ERROR
END
SET @CurFlushBlockSize = ISNULL ((SELECT FlushBlockSizeKB FROM MMRecordingFormats WHERE RecordingFormatName = @RecordingFormat),0)
IF @CurFlushBlockSize = 0
BEGIN
	SET @Str = 'Invalid recfmtname, please enter valid recfmtname...'
	GOTO PROC_ERROR
END
IF @option = 'SET'
BEGIN
	UPDATE MMRecordingFormats
	SET FlushBlockSizeKB = @FlushBlockSize
	WHERE RecordingFormatName = @RecordingFormat
	IF @@ERROR>0
	BEGIN
		SET @Str = 'Failed to update the MMRecordingFormats table'
		GOTO PROC_ERROR
	END
	SET @Str = 'Successfully updated flush block size from '+ CAST (@CurFlushBlockSize AS VARCHAR(1024))+' to '+CAST(@FlushBlockSize AS VARCHAR(1024))
	PRINT @Str
	RETURN
END
ELSE IF @option = 'VIEW'
BEGIN
	SET @Str = 'Current Flush Block Size for given recordmat is : '+ CAST(@CurFlushBlockSize AS VARCHAR(1024))
	PRINT @Str
	RETURN
END
PROC_ERROR:
	PRINT @Str
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetFlushBlockSize')
	delete from GxQscripts where name = 'QS_SetFlushBlockSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetFlushBlockSize')
	delete from GXDBVersions where aliasname = 'QS_SetFlushBlockSize'
GO

insert into GXDBVersions values(2, 'QS_SetFlushBlockSize',  '00010005000000000000', 'QS_SetFlushBlockSize', '00010005000000000000')
GO

insert into GxQscripts values(2,'QS_SetFlushBlockSize',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '--    qoperation execscript -sn QS_SetFlushBlockSize -si <SET\VIEW> -si <Recording format name> -si <New flush block size>'
 + CHAR(10) + '--    RecordingFormat: Recording format name, FlushBlockSize: New flush block size'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DataInterfacePairSwitch.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DataInterfacePairSwitch <<<'

IF EXISTS (select * from sysobjects where name='QS_DataInterfacePairSwitch')
	drop procedure QS_DataInterfacePairSwitch
IF EXISTS (select * from GxQscripts where name='QS_DataInterfacePairSwitch')
	delete from GxQscripts where name = 'QS_DataInterfacePairSwitch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataInterfacePairSwitch')
	delete from GXDBVersions where aliasname = 'QS_DataInterfacePairSwitch'
GO
print '... Creating Procedure: QS_DataInterfacePairSwitch'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DataInterfacePairSwitch
  @client varchar(1024) = '',
  @operation varchar(10)   = ''
AS
Set NOCOUNT ON
DECLARE @Clid          integer
DECLARE @lastError     integer
SET            @lastError       = 0
DECLARE        @localErrorMsg   varchar(512)
SET            @localErrorMsg   = 'Error Encountered when running script.'
IF @client = ''
BEGIN
SET @lastError = 1
SET @localErrorMsg= 'Error. Client Name Empty'
GOTO ERROR_EXIT
END
SET @clid = ( SELECT id FROM APP_Client WHERE name = @client)
IF @clid is NUll
BEGIN
SET @lastError = 2
SET @localErrorMsg = 'Error. Invalid Client Name ' + @client
GOTO ERROR_EXIT
END
IF exists(SELECT 1 FROM archPipeline WHERE srcClientId = @Clid OR destClientId = @Clid )
BEGIN
	IF @operation = 'Enable'
		UPDATE archpipeline SET isActive = 1 WHERE srcClientId = @clid or destClientId = @clid
	ELSE IF @operation = 'Disable'
		UPDATE archPipeline SET isActive = 0 WHERE srcClientId = @clid or destClientId = @clid
	ELSE
		BEGIN
			SET @lastError = 3
			SET @localErrorMsg = 'Error. Invalid Operation '
			GOTO ERROR_EXIT
		END
END
ElSE
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg = 'Error. NO Dip Entry for Client ' + @client
		GOTO ERROR_EXIT
	END
ERROR_EXIT:
if @lastError <> 0
    Raiserror(@localErrorMsg,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DataInterfacePairSwitch')
	delete from GxQscripts where name = 'QS_DataInterfacePairSwitch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DataInterfacePairSwitch')
	delete from GXDBVersions where aliasname = 'QS_DataInterfacePairSwitch'
GO

insert into GXDBVersions values(2, 'QS_DataInterfacePairSwitch',  '00000000000000000000', 'QS_DataInterfacePairSwitch', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DataInterfacePairSwitch',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn QS_DataInterfacePairSwitch -si clientName -si Enable|Disable'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableOrDisableCCM.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableOrDisableCCM <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableOrDisableCCM')
	drop procedure QS_EnableOrDisableCCM
IF EXISTS (select * from GxQscripts where name='QS_EnableOrDisableCCM')
	delete from GxQscripts where name = 'QS_EnableOrDisableCCM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableOrDisableCCM')
	delete from GXDBVersions where aliasname = 'QS_EnableOrDisableCCM'
GO
print '... Creating Procedure: QS_EnableOrDisableCCM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableOrDisableCCM
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @option NVARCHAR(64) =N'',
  @AuthCode NVARCHAR(1024) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	NVARCHAR(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_EnableOrDisableCCM'
DECLARE @errorCode INT
SET @errorCode = 0
DECLARE @decryptedAuthCode NVARCHAR(1024)
DECLARE @errorString NVARCHAR(1024)
-----------------------invalid parameters------------------------------
SET @option = LTRIM(RTRIM(@option))
SET @AuthCode = LTRIM(RTRIM(@AuthCode))
IF @option = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
IF @option <> 'ENABLE' AND @option <> 'DISABLE'
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid option parameter [' + @option + '] specified.'
	GOTO SCRIPT_EXIT
END
-- Get GUID from DB
DECLARE @csDbGUID VARCHAR(256)
SET @csDbGUID = (SELECT RIGHT(csGUID,10) FROM APP_CommCell where id=2)
-- form GUID as user see XXX-XXX-XXXX
SET @csDbGUID = ( SELECT (LEFT(@csDbGUID,3) + '-' + SUBSTRING(@csDbGUID, 4, 3) + '-' + RIGHT(@csDbGUID,4)))
SET @csDbGUID = 'Allow_CCM_'+@csDbGUID
IF @AuthCode = @NoParameter --IF Authentication code is not passed
BEGIN
	SET @errorString = N'No Authorization code passed. Authorization code required.'
	SET @errorCode = 3
	GOTO SCRIPT_EXIT
END
ELSE
BEGIN
	EXEC miscProc2 @AuthCode, @decryptedAuthCode OUTPUT
	IF @csDbGUID <> @decryptedAuthCode
	BEGIN
		SET @errorString = N'Wrong Authorization code passed [' + @AuthCode + '].'
		SET @errorCode = 4
		GOTO SCRIPT_EXIT
	END
END
----------------- Enable or Disable CCM --------------
	UPDATE MMConfigs
	SET value = CASE WHEN @option = 'ENABLE' THEN 1
					 WHEN @option = 'DISABLE' THEN 0
				END
	WHERE name LIKE 'CCM_CONFIG_ENABLE_CCM_FEATURE'
------------------------------------------------------
	SET @errorString = 'Successfully ' + lower(@option) +'d CCM Feature'
	PRINT @errorString
	RETURN
SCRIPT_EXIT:
	SET @errorString = @errorString + '. Error Code [' + CAST(@errorCode AS NVARCHAR(64)) + ']'
	PRINT @errorString
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableOrDisableCCM')
	delete from GxQscripts where name = 'QS_EnableOrDisableCCM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableOrDisableCCM')
	delete from GXDBVersions where aliasname = 'QS_EnableOrDisableCCM'
GO

insert into GXDBVersions values(2, 'QS_EnableOrDisableCCM',  '00000000000000000000', 'QS_EnableOrDisableCCM', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EnableOrDisableCCM',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_EnableOrDisableCCM.sql -si <ENABLE\DISABLE> -si <Authentication_Code>
'
 + CHAR(10) + '-- 	script_name: QS_EnableOrDisableCCM'
 + CHAR(10) + '-- 	 Qscript to enable CCM feature on CommServer'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetUseInstanceGUID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetUseInstanceGUID <<<'

IF EXISTS (select * from sysobjects where name='QS_SetUseInstanceGUID')
	drop procedure QS_SetUseInstanceGUID
IF EXISTS (select * from GxQscripts where name='QS_SetUseInstanceGUID')
	delete from GxQscripts where name = 'QS_SetUseInstanceGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseInstanceGUID')
	delete from GXDBVersions where aliasname = 'QS_SetUseInstanceGUID'
GO
print '... Creating Procedure: QS_SetUseInstanceGUID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetUseInstanceGUID
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- Stored Procedure Inputs
  @clientName nvarchar(MAX)=N'',
  @instanceName nvarchar(MAX)=N'',
  @val NVARCHAR(2) = N''
AS
Set NOCOUNT ON
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetUseInstanceGUID'
-------- Local Variables    -------------
DECLARE @lastError				integer=0
DECLARE @localErrorMsg			varchar(MAX)=N''
-- for test
--SET @val = '1'
-- Local variables
DECLARE @clientId   INT = 0
DECLARE @instanceId INT = 0
-- Validate inputs
IF @clientName = N'' OR @instanceName = N''
BEGIN
    SET @localErrorMsg = N'Client Name or Instance Name  not passed. Please check the usage of the script..'
    SET @lastError = 1
    GOTO    ARGS_ERROR
END
IF (@val <> N'0' AND @val <> N'1')
  BEGIN
      SET @localErrorMsg = N'Property Value can be 0 or 1. Please check the usage of the script.'
      SET @lastError = 1
      GOTO    ARGS_ERROR
  END
IF @clientName = N'ALL' AND @instanceName = N'ALL'
BEGIN
	MERGE APP_InstanceProp P
	USING
	(
				SELECT distinct App.instance
				FROM App_Application App WHERE App.appTypeId = 106
	) AS T ON T.instance = P.componentNameId
	WHEN MATCHED AND P.attrName='Use VM Instance GUID' AND P.modified = 0 THEN
				UPDATE SET attrVal = @val
	WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES (T.instance, 'Use VM Instance GUID', 2, @val, dbo.GetUnixTime(GETDATE()), 0, 0)
				;
END
ELSE
BEGIN
	-- Check client
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = @clientName), 0)
	IF @clientId = 0
			BEGIN
					SET @localErrorMsg = 'Cannot find client [' + @clientName + '] in CS DB'
					SET @lastError =1
					GOTO    ARGS_ERROR
			END
	SET @instanceId = ISNULL((SELECT distinct App.instance FROM APP_INSTANCENAME I,App_Application App
	WHERE I.name = @instanceName and App.clientId = @clientId and App.appTypeId = 106 and App.instance=I.id), 0)
	IF @instanceId = 0
			BEGIN
					SET @localErrorMsg = 'Cannot find instance [' + @instanceName + '] in CS DB'
					SET @lastError =1
					GOTO    ARGS_ERROR
			END
	-- Insert/Update
	IF NOT EXISTS (	select * from APP_INSTANCEPROP where componentNameId = @instanceId
									AND attrName = 'Use VM Instance GUID' and modified=0 )
	BEGIN
			INSERT INTO APP_INSTANCEPROP VALUES (@instanceId, 'Use VM Instance GUID', 2, @val, dbo.GetUnixTime(GETDATE()), 0, 0)
	END
	ELSE
			BEGIN
					UPDATE APP_INSTANCEPROP set attrVal = @val  where componentNameId = @instanceId AND attrName = 'Use VM Instance GUID' and modified = 0
			END
END
SET @lastError = @@error
IF @lastError <> 0
BEGIN
SET @localErrorMsg = 'Error: Query Unsucess full'
GOTO ARGS_ERROR
END
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetUseInstanceGUID')
	delete from GxQscripts where name = 'QS_SetUseInstanceGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetUseInstanceGUID')
	delete from GXDBVersions where aliasname = 'QS_SetUseInstanceGUID'
GO

insert into GXDBVersions values(2, 'QS_SetUseInstanceGUID',  '00000000000000000000', 'QS_SetUseInstanceGUID', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetUseInstanceGUID',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn SetUseInstanceGUID -si clientname -si instancename -si ''0/1''
'
 + CHAR(10) + '--   script_name : SetUseInstanceGUID'
 + CHAR(10) + '--   Qscript to enable or disable the use of VM Instance UUIDs to identify virtual machines for a virtual server instance or all virtual server instances in a CommCell hierarchy. '
 + CHAR(10) + '--   To enable/disable on an instance:'
 + CHAR(10) + '--   qoperation execscript -sn SetUseInstanceGUID -si "cname" -si "iname" -si 1/0'
 + CHAR(10) + '--   To enable/disable on all instances:'
 + CHAR(10) + '--   qoperation execscript -sn SetUseInstanceGUID -si "ALL" -si "ALL" -si 1/0'
)
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPruneVolSnaps.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPruneVolSnaps.sp,v $ $Id: archPruneVolSnaps.sp,v 1.18 2015/05/11 22:21:49 gsurendrakumar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPruneVolSnaps <<<'

IF EXISTS (select * from sysobjects where name='archPruneVolSnaps')
	drop procedure archPruneVolSnaps
IF EXISTS (select * from GxQscripts where name='archPruneVolSnaps')
	delete from GxQscripts where name = 'archPruneVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneVolSnaps')
	delete from GXDBVersions where aliasname = 'archPruneVolSnaps'
GO
print '... Creating Procedure: archPruneVolSnaps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archPruneVolSnaps
  @i_ArchGroupId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
	CREATE TABLE #ToBeDeletedVols (
			SMVolumeId integer,
			ArchFileId integer,
			CommCellId integer,
			CopyId integer,
			primary key (SMVolumeId, ArchFileId, CommCellId, CopyId)
		)
	DECLARE @tblSnapCopy TABLE (
			CopyId integer
		)
	SET @retVal = 0
	INSERT	INTO @tblSnapCopy
	SELECT	id
	FROM	ArchGroupCopy WITH (NOLOCK)
	WHERE	isSnapCopy = 1
			AND	( @i_ArchGroupId = archGroupId OR @i_copyId = id )
	IF	object_id('tempdb.dbo.#ToBeAgedAFC') is null AND NOT EXISTS(SELECT * FROM @tblSnapCopy)
		GOTO FINISH
	-- We get list of archive files pruned from parent SP
	IF	object_id('tempdb.dbo.#ToBeAgedAFC') is not null
	BEGIN
		INSERT INTO #ToBeDeletedVols
		SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
		FROM SMVolume A WITH (NOLOCK), #ToBeAgedAFC B
		WHERE (A.MountStatus = 99 OR
				EXISTS (SELECT id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = A.CopyId AND isSnapCopy = 1 AND isMirrorCopy = 1 AND
															((flags & 1073741824) = 1073741824))
			  )
		AND A.ArchFileId = B.ArchFileId
		AND A.CommCellId = B.CommCellId
		AND A.CopyId = B.ArchCopyId
	END
	ELSE
	BEGIN
		-- Prune EDC prepared
		INSERT INTO #ToBeDeletedVols
		SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
		FROM SMVolume A WITH (NOLOCK), JMPreparedJob B WITH (NOLOCK)
		WHERE A.JobId = B.JobId
		AND A.CommCellId = B.CommCellId
		AND (A.CopyId IN (SELECT CopyId FROM @tblSnapCopy))
		DELETE #ToBeDeletedVols
		FROM #ToBeDeletedVols A, ArchFileCopy B WITH (NOLOCK)
		WHERE A.ArchFileId = B.ArchFileId
		AND A.CommCellId = B.CommCellId
		AND A.CopyId = B.ArchCopyId
		INSERT INTO #ToBeDeletedVols
		SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
		FROM SMVolume A WITH (NOLOCK)
		WHERE (A.MountStatus = 99 OR
				EXISTS (SELECT id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = A.CopyId AND isSnapCopy = 1 AND isMirrorCopy = 1 AND
															((flags & 1073741824) = 1073741824))
			  )
		AND A.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
		AND (A.CopyId IN (SELECT CopyId FROM @tblSnapCopy))
		INSERT	INTO #ToBeDeletedVols
		SELECT	DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
		FROM	SMVolume VOL WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
				INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
		WHERE	SNAP.ControlHostId = 0
				AND SNAP.SnapShotEngineId NOT IN ( 1 /*SM_VENDOR_NATIVE_ID*/ )
				AND VOL.JobId NOT IN (SELECT JobId FROM JMJobInfo WITH (NOLOCK))
				AND VOL.PruneFlags <> 1
				AND ( VOL.MountStatus < 39 /*SM_VS_CRT_CREATED*/ OR VOL.MountStatus = 98 /*SM_VS_DEL_FAILED*/ )
				AND	VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
				AND (VOL.CopyId IN (SELECT CopyId FROM @tblSnapCopy))
	END
	-- Get the linked cloned DFM volumes set through SMVolSnapInfo::clone()
	-- Get all the mirrored copies for the source snaps which are going to be deleted
    WHILE EXISTS 	(SELECT T.SMVolumeId
					FROM #ToBeDeletedVols T, SMVolume S WITH (NOLOCK), ArchGroupCopy AGC  WITH (NOLOCK)
					WHERE T.SMVolumeId = S.ReserveField1
						AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
						AND S.CopyID = AGC.id
						AND AGC.IsSnapCopy = 1
						AND AGC.IsMirrorCopy = 1)
    BEGIN
		INSERT INTO #ToBeDeletedVols
		SELECT S.SMVolumeId, S.ArchFileId, S.CommCellId, S.CopyId
		FROM #ToBeDeletedVols T, SMVolume S WITH (NOLOCK), ArchGroupCopy AGC WITH (NOLOCK)
		WHERE T.SMVolumeId = S.ReserveField1
			AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
			AND S.CopyID = AGC.id
			AND AGC.IsSnapCopy = 1
			AND AGC.IsMirrorCopy = 1
	END
	IF EXISTS (SELECT * FROM #ToBeDeletedVols)
	BEGIN
		EXEC @retVal = MM_SMDeleteVolSnaps 0, 0
		IF @retVal <> 0
			GOTO FINISH
	END
FINISH:
DROP TABLE #ToBeDeletedVols
SELECT	@retVal
RETURN	@retVal
END
GO

IF EXISTS (select * from GxQscripts where name = 'archPruneVolSnaps')
	delete from GxQscripts where name = 'archPruneVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneVolSnaps')
	delete from GXDBVersions where aliasname = 'archPruneVolSnaps'
GO

insert into GXDBVersions values(2, 'archPruneVolSnaps',  '00010018000000000000', 'archPruneVolSnaps', '00010018000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileDeleteViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileDeleteViaTable.sp,v $ $Id: archFileDeleteViaTable.sp,v 1.49 2015/06/09 17:16:05 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileDeleteViaTable <<<'

IF EXISTS (select * from sysobjects where name='archFileDeleteViaTable')
	drop procedure archFileDeleteViaTable
IF EXISTS (select * from GxQscripts where name='archFileDeleteViaTable')
	delete from GxQscripts where name = 'archFileDeleteViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileDeleteViaTable')
	delete from GXDBVersions where aliasname = 'archFileDeleteViaTable'
GO
print '... Creating Procedure: archFileDeleteViaTable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileDeleteViaTable
  @i_dummy integer,
  @magneticBytes bigint	OUTPUT
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
DECLARE	@hasMagnetic INT
SET		@hasMagnetic = 0
DECLARE	@currentTime INT
SET		@currentTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @oneConstReal REAL
SET			@oneConstReal = 1.0
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
*/
CREATE TABLE #ToBeAgedAFCOnTransitiveCopy (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, acCommcellId INT, archFileId INT, afCommCellId INT, archCopyId INT, physicalSize BIGINT, isAged INT, dedupSize BIGINT, JobId INT, appSizeFreedBytes BIGINT,
	PRIMARY KEY (archChunkId, acCommcellId, archFileId, afCommCellId, archCopyId))
CREATE TABLE #ToBeAgedAC (
	archChunkId BIGINT, commCellId INT, archCopyId INT, volumeId INT, version INT,
	cclip varchar(65), physicalSize BIGINT, isAged INT,
	SIDBStoreId INT, isMagnetic INT, MountPathId INT, allAFsAged INT,
 	PRIMARY KEY (archChunkId, commCellId, archCopyId))
CREATE TABLE #NotAgedAC (archChunkId BIGINT, commCellId INT, isAged INT)
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
CREATE TABLE #ToBeAgedAFCWithoutChunks (
	archFileId INT, commCellId INT, archCopyId INT, SIDBStoreId INT, isAged INT
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE INDEX Idx_tmpToBeAgedAFCWithoutChunks_1 ON #ToBeAgedAFCWithoutChunks (SIDBStoreId)
--BEGIN TRY
	-- Prune the corresponding archive files on transitive copy
	INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			--AND AFC.flags & CVA_AGED_DATA_FLAG = 0
	INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archGroupCopy AGC WITH (NOLOCK), archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = AGC.id
			AND AGC.destMediaCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			AND AGC.destMediaCopyId > 0
	-- Get chunks of pruneable archive files
	INSERT	INTO #ToBeAgedACM
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, (ACM.flags & 256), ACM.dedupedSize, ACM.JobId, 0
	FROM	#ToBeAgedAFC T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
	UNION
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, (ACM.flags & 256), ACM.dedupedSize, ACM.JobId, 0
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
	IF (@i_dummy != 1)
	BEGIN
		--Get all archive files without any chunks to populate MMDeletedAF table
		INSERT INTO #ToBeAgedAFCWithoutChunks
		SELECT T.archFileId, T.commCellId, T.archCopyId, 0, 0
		FROM #ToBeAgedAFC T LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
		ON 	T.archFileId = ACM.archFileId
		AND	T.commCellId = ACM.commCellId
		AND 	T.archCopyId = ACM.archCopyId
		WHERE	ACM.archFileId IS NULL
		--Get the SIDBStoreId for archive files
		UPDATE #ToBeAgedAFCWithoutChunks
		SET	SIDBStoreId = AFCD.SIDBStoreId
		FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopyDedup AFCD WITH (NOLOCK)
		WHERE	T.archFileId = AFCD.archFileId
		AND	T.commCellId = AFCD.commCellId
		AND 	T.archCopyId = AFCD.archCopyId
		--Get AGED status of archive files
		UPDATE #ToBeAgedAFCWithoutChunks
		SET	isAged = (AFC.flags & 256)
		FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopy AFC WITH (NOLOCK)
		WHERE	T.archFileId = AFC.archFileId
		AND	T.commCellId = AFC.commCellId
		AND 	T.archCopyId = AFC.archCopyId
	END
	INSERT	INTO #ToBeAgedAC
	SELECT	AC.id, AC.commCellId, T.archCopyId, AC.volumeId, AC.version, AC.cclip, AC.physicalSize, (AC.flags & 256),
			0, 0, 0, (1 + 256)
	FROM	(SELECT DISTINCT archChunkId, acCommCellId, archCopyId FROM #ToBeAgedACM) T,
			archChunk AC WITH(NOLOCK)
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.acCommCellId
	IF (@i_dummy = 1)
	BEGIN
		UPDATE	archFileSubStore
		SET		flags = FS.flags | 8
		FROM	archFileSubStore FS, archCopySIDBStore AGC WITH (NOLOCK), #ToBeAgedAFC C
		WHERE	FS.archFileId = C.archFileId
				AND FS.CommCellId = C.CommCellId
				AND FS.SIDBStoreId = AGC.SIDBStoreId
				AND AGC.CopyId = C.archCopyId
    	INSERT INTO archFileMarkedForRecopy
	    SELECT A.archFileId, A.commCellId, A.archCopyId, A.flags, 0, A.physicalSize, A.logicalSize, A.mediaType, @currentTime, 0, 0, ''
	    FROM	#ToBeAgedAFC T, archFileCopy A WITH (NOLOCK)
		    	INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = A.archCopyId
			LEFT OUTER JOIN archFileMarkedForRecopy AFMR WITH (NOLOCK) ON AFMR.archFileId = A.archFileId AND AFMR.archCopyId = A.archCopyId AND AFMR.commCellId = A.commCellId
	    WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
		    	AND (((AGC.dedupeFlags & 524288) > 0) OR ((AGC.dedupeFlags & 8388608) > 0))
			AND (AGC.dedupeFlags & 1073741824) > 0
			AND AFMR.archFileId = null
	END
	-- Delete archFileCopy and archChunkMapping entries
	DELETE	archFileCopy
	FROM	#ToBeAgedAFC T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
	DELETE	archFileCopy
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
/*	-- Filter out archive files which still exist in some copy
	DELETE	#ToBeAgedAFC
	FROM	#ToBeAgedAFC T, archFileCopy A WITH (NOLOCK)
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId */
	--Delete archive files from archVSAAppAFLink table before deleting from archFile table
	DELETE	archVSAAppAFLink
	FROM	#ToBeAgedAFC T, archVSAAppAFLink A
	WHERE	A.childAFId = T.archFileId AND A.commCellId = T.commCellId
	AND NOT EXISTS (SELECT * FROM archFileCopy C WITH (NOLOCK)
					WHERE	C.archFileId = T.archFileId AND C.commCellId = T.commCellId)
	DELETE	archVSAAppAFLink
	FROM	#ToBeAgedAFC T, archVSAAppAFLink A
	WHERE	A.ParentIndexAFId = T.archFileId AND A.commCellId = T.commCellId
	AND NOT EXISTS (SELECT * FROM archFileCopy C WITH (NOLOCK)
					WHERE	C.archFileId = T.archFileId AND C.commCellId = T.commCellId)
	-- Remove archive files which do not exist in any copy from archFile table.
	DELETE	archFile
	FROM	#ToBeAgedAFC T, archFile A
	WHERE	A.id = T.archFileId AND A.commCellId = T.commCellId
	AND NOT EXISTS (SELECT * FROM archFileCopy C WITH (NOLOCK)
					WHERE	C.archFileId = T.archFileId AND C.commCellId = T.commCellId)
	---------------------------------------------------------
	-- Prune snap records after archfilecopy table is pruned
	---------------------------------------------------------
	declare @tblRtn table (retVal int)
	insert into @tblRtn
	EXEC @retVal = archPruneVolSnaps 0, 0
	if @retVal <> 0 GOTO CX_EXIT
	---------------------------------------------------------
	-- Flag magnetic chunks
	UPDATE	#ToBeAgedAC
	SET 	isMagnetic = 1, SIDBStoreId = V.SIDBStoreId, MountPathId = MP.MountPathId
	FROM	#ToBeAgedAC T, MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	T.volumeId = V.VolumeId
		AND V.RecordingFormatId = 10001
		AND V.MediaSideId = MP.MediaSideId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
		SET @hasMagnetic = 1
	-- Calculate appSizeFreedBytes ONLY for dedupe data
	INSERT INTO #tmpJobSizeInfo
	SELECT DISTINCT ACM.JobId, ACM.afCommcellId, 0, 0, 0
	FROM	#ToBeAgedACM ACM, #ToBeAgedAC AC
	WHERE	ACM.archChunkId = AC.archChunkId
	AND 	ACM.acCommcellId = AC.commCellId
	AND 	AC.SIDBStoreId > 0
	-- Get totalBackupSize, totalAppSize, totalIndexSize for dedupe jobs
	EXEC archGetJobSizeInfo 0
	UPDATE #ToBeAgedACM
	SET		appSizeFreedBytes = (CASE WHEN JI.totalBackupSize > 0
																	THEN CAST(((@oneConstReal * (JI.totalAppSize + JI.totalIndexSize) * ACM.physicalSize) / JI.totalBackupSize) AS BIGINT)
																	ELSE ACM.physicalSize
															END)
	FROM	#ToBeAgedACM ACM, #tmpJobSizeInfo JI
	WHERE ACM.JobId = JI.JobId
	AND  	ACM.afCommcellId = JI.CommCellId
	-- For archive files prior to 5.0
	-- Keep appSizeFreedBytes = 0 since these are older version archive files without dedupe
	IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, SUM(A.physicalSize),
			0, B.MountPathId, 0, A.afCommCellId, @currentTime, 0, 0, 0, 0, 0, A.acCommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommCellId = B.commCellId
		AND A.isAged = 0
		AND B.isMagnetic = 1
		AND B.version < 3
	GROUP	BY A.archFileId, B.volumeId, A.archCopyId, B.cclip, A.afCommCellId, B.MountPathId, A.acCommCellId
	-- For CV-Single-Instanced archive files
	-- Set appSizeFreedBytes only for dedupe chunks
	INSERT	INTO MMDeletedAF
	SELECT	(case when @i_dummy = 1 then 0x7FFFFFFF else A.archFileId end), B.volumeId, 0, 0, A.archCopyId, B.cclip, A.dedupSize,
			A.archChunkId, B.MountPathId, B.SIDBStoreId, (case when @i_dummy = 1 then 0 else A.afCommCellId end), @currentTime, 0, 0, 0, A.appSizeFreedBytes, 0, A.acCommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommCellId = B.commCellId
		AND A.isAged = 0
		AND B.SIDBStoreId > 0
	INSERT INTO MMDeletedAF
	SELECT	archFileId, 0, 0, 0, archCopyId, 0, 0, 0, 0, SIDBStoreId, commCellId, @currentTime, 0, 0, 0, 0, 0, 0
	FROM 	#ToBeAgedAFCWithoutChunks
	WHERE	SIDBStoreId > 0
	AND	isAged = 0
	-- Flag if remaining archive files are all aged:
	-- allAFsAged = LOCAL_NO_AF_REMAIN_FLAG if no entry remain in archChunkMapping table for a chunk.
	-- allAFsAged = CVA_AGED_DATA_FLAG if all remaning archChunkMapping table entries are aged.
	-- allAFsAged = 0 if some remaining archChunkMapping table entries are not aged.
	INSERT	INTO #NotAgedAC
	SELECT	A.archChunkId, A.chunkCommCellId, MIN(A.flags & 256)
	FROM	#ToBeAgedAC T, archChunkMapping A WITH (NOLOCK)
	WHERE	A.archChunkId = T.archChunkId AND A.chunkCommCellId = T.commCellId
	GROUP BY A.archChunkId, A.chunkCommCellId
	UPDATE	#ToBeAgedAC
	SET		allAFsAged = (T.allAFsAged & N.isAged)
	FROM	#ToBeAgedAC T, #NotAgedAC N
	WHERE	T.archChunkId = N.archChunkId AND T.commCellId = N.commCellId
	-- Filter out chunks which still have non-aged archive files.
	DELETE	#ToBeAgedAC
	WHERE	allAFsAged = 0
	-- Delete chunks which have no more archive files.
	DELETE	archChunk
	FROM	#ToBeAgedAC T, archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
		AND	T.allAFsAged & 1 <> 0
	-- Set aged flag if only aged archive files remain in a chunk.
	UPDATE	archChunk
	SET		flags = (A.flags | 256), agedBy = (agedBy | 2048), modifiedTime = @currentTime
	FROM	#ToBeAgedAC T, archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
		AND	A.flags & 256 = 0
		AND	T.allAFsAged = 256
	-- Keep appSizeFreedBytes = 0 for non dedupe chunks
	IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize,
			archChunkId, #ToBeAgedAC.MountPathId, 0, 0, @currentTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isAged = 0
		AND isMagnetic = 1
		AND version >= 3
		AND SIDBStoreId = 0
	-- Keep appSizeFreedBytes = 0 for non magnetic chunks
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, '', SUM(physicalSize),
			0, 0, 0, 0, @currentTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isAged = 0
		AND isMagnetic = 0
		AND SIDBStoreId = 0
	GROUP BY volumeId, archCopyId, commCellId
	SET @magneticBytes = (
		SELECT	SUM(physicalSize)
		FROM	#ToBeAgedAC
		WHERE	isAged = 0
			AND isMagnetic = 1)
--Try catch is disable to figure which query failed. MR 42524.
--END TRY
--BEGIN CATCH
--	SET @retVal = (SELECT ERROR_NUMBER())
--END CATCH
CX_EXIT:
DROP TABLE #ToBeAgedAFCOnTransitiveCopy
DROP TABLE #ToBeAgedACM
DROP TABLE #ToBeAgedAC
DROP TABLE #NotAgedAC
DROP TABLE #tmpJobSizeInfo
DROP TABLE #ToBeAgedAFCWithoutChunks
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileDeleteViaTable')
	delete from GxQscripts where name = 'archFileDeleteViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileDeleteViaTable')
	delete from GXDBVersions where aliasname = 'archFileDeleteViaTable'
GO

insert into GXDBVersions values(2, 'archFileDeleteViaTable',  '00010049000000000000', 'archFileDeleteViaTable', '00010049000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSetAgedViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSetAgedViaTable.sp,v $ $Id: archFileSetAgedViaTable.sp,v 1.29 2014/11/25 12:55:54 syadav Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileSetAgedViaTable <<<'

IF EXISTS (select * from sysobjects where name='archFileSetAgedViaTable')
	drop procedure archFileSetAgedViaTable
IF EXISTS (select * from GxQscripts where name='archFileSetAgedViaTable')
	delete from GxQscripts where name = 'archFileSetAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSetAgedViaTable')
	delete from GXDBVersions where aliasname = 'archFileSetAgedViaTable'
GO
print '... Creating Procedure: archFileSetAgedViaTable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileSetAgedViaTable
  @i_agedByFlag bigint,
  @i_agedTime integer
AS
DECLARE @retVal	integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
DECLARE	@hasMagnetic INT
SET		@hasMagnetic = 0
DECLARE @oneConstReal REAL
SET			@oneConstReal = 1.0
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
*/
CREATE TABLE #ToBeAgedAFCOnTransitiveCopy (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, acCommcellId INT, archFileId INT, afCommcellId INT, archCopyId INT, physicalSize BIGINT, dedupSize BIGINT, JobId INT, appSizeFreedBytes BIGINT,
	PRIMARY KEY (archChunkId, acCommcellId, archFileId, afCommCellId, archCopyId))
CREATE TABLE #ToBeAgedAC (
	archChunkId BIGINT, commCellId INT, archCopyId INT, volumeId INT, version INT,
	cclip varchar(65), physicalSize BIGINT, SIDBStoreId INT, isMagnetic INT, MountPathId INT,
 	PRIMARY KEY (archChunkId, commCellId, archCopyId))
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
CREATE TABLE #ToBeAgedAFCWithoutChunks (
	archFileId INT, commCellId INT, archCopyId INT, SIDBStoreId INT
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE INDEX Idx_tmpToBeAgedAFCWithoutChunks_1 ON #ToBeAgedAFCWithoutChunks (SIDBStoreId)
BEGIN TRY
	-- Prune the corresponding archive files on transitive copy
	INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			AND AFC.flags & 256 = 0
  INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archGroupCopy AGC WITH (NOLOCK), archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = AGC.id
			AND AGC.destMediaCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			AND AGC.destMediaCopyId > 0
			AND AFC.flags & 256 = 0
	-- Get chunks of pruneable archive files
	INSERT	INTO #ToBeAgedACM
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, ACM.dedupedSize, ACM.JobId, 0
	FROM	#ToBeAgedAFC T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
		AND ACM.flags & 256 = 0
	UNION
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, ACM.dedupedSize, ACM.JobId, 0
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
		AND ACM.flags & 256 = 0
	--Get all archive files without any chunks to populate MMDeletedAF table
	INSERT INTO #ToBeAgedAFCWithoutChunks
	SELECT T.archFileId, T.commCellId, T.archCopyId, 0
	FROM #ToBeAgedAFC T LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
	ON 	T.archFileId = ACM.archFileId
	AND	T.commCellId = ACM.commCellId
	AND 	T.archCopyId = ACM.archCopyId
	WHERE	ACM.archFileId IS NULL
	--Get the SIDBStoreId for archive files
	UPDATE #ToBeAgedAFCWithoutChunks
	SET	SIDBStoreId = AFCD.SIDBStoreId
	FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopyDedup AFCD WITH (NOLOCK)
	WHERE	T.archFileId = AFCD.archFileId
	AND	T.commCellId = AFCD.commCellId
	AND 	T.archCopyId = AFCD.archCopyId
	INSERT	INTO #ToBeAgedAC
	SELECT	AC.id, AC.commCellId, T.archCopyId, AC.volumeId, AC.version, AC.cclip, AC.physicalSize, 0, 0, 0
	FROM	(SELECT DISTINCT archChunkId, acCommcellId, archCopyId FROM #ToBeAgedACM) T,
			archChunk AC WITH(NOLOCK)
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.acCommcellId
		AND AC.flags & 256 = 0
	-- Mark SMVolume as prunable
	UPDATE	SMVolume
	SET		PruneFlags = 3
	FROM	#ToBeAgedAFC T, SMVolume A
	WHERE	A.archFileId = T.archFileId
		AND A.commCellId = T.commCellId
		AND A.CopyId = T.archCopyId
		AND A.PruneFlags IN (0, 1, 2)
	-- Mark archive files and chunks as aged
	UPDATE	archChunkMapping WITH (PAGLOCK)
	SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAFC T, archChunkMapping A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
		AND A.flags & 256 = 0
	UPDATE	archChunkMapping WITH (PAGLOCK)
	SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = (@i_agedByFlag | CAST(4294967296 AS BIGINT))
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archChunkMapping A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
		AND A.flags & 256 = 0
	UPDATE	archFileCopy WITH (PAGLOCK)
	SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAFC T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
		AND A.flags & 256 = 0
	UPDATE	archFileCopy WITH (PAGLOCK)
	SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = (@i_agedByFlag | CAST(4294967296 AS BIGINT))
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
		AND A.flags & 256 = 0
	-- Flag magnetic chunks
	UPDATE	#ToBeAgedAC
	SET		isMagnetic = 1, SIDBStoreId = V.SIDBStoreId, MountPathId = MP.MountPathId
	FROM	#ToBeAgedAC T, MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	T.volumeId = V.VolumeId AND V.RecordingFormatId = 10001
		AND	V.MediaSideId = MP.MediaSideId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
		SET @hasMagnetic = 1
	-- Calculate appSizeFreedBytes ONLY for dedupe data
	INSERT INTO #tmpJobSizeInfo
	SELECT DISTINCT ACM.JobId, ACM.afCommcellId, 0, 0, 0
	FROM	#ToBeAgedACM ACM, #ToBeAgedAC AC
	WHERE	ACM.archChunkId = AC.archChunkId
	AND 	ACM.acCommcellId = AC.commCellId
	AND 	AC.SIDBStoreId > 0
	-- Get totalBackupSize, totalAppSize, totalIndexSize for dedupe jobs
	EXEC archGetJobSizeInfo 0
	UPDATE #ToBeAgedACM
	SET		appSizeFreedBytes = (CASE WHEN JI.totalBackupSize > 0
																	THEN CAST(((@oneConstReal * (JI.totalAppSize + JI.totalIndexSize) * ACM.physicalSize) / JI.totalBackupSize) AS BIGINT)
																	ELSE ACM.physicalSize
															END)
	FROM	#ToBeAgedACM ACM, #tmpJobSizeInfo JI
	WHERE ACM.JobId = JI.JobId
	AND  	ACM.afCommcellId = JI.CommCellId
	-- For archive files prior to 5.0
	-- Keep appSizeFreedBytes = 0 since these are older version archive files without dedupe
	IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, SUM(A.physicalSize),
			0, B.MountPathId, 0, A.afCommcellId, @i_agedTime, 0, 0, 0, 0, 0, 0
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommcellId = B.commCellId
		AND B.version < 3 AND B.isMagnetic = 1
	GROUP	BY A.archFileId, B.volumeId, A.archCopyId, B.cclip, A.afCommcellId, B.MountPathId
	-- For CV-Single-Instanced archive files
	-- Set appSizeFreedBytes only for dedupe chunks
	INSERT	INTO MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, A.dedupSize,
			A.archChunkId, B.MountPathId, B.SIDBStoreId, A.afCommcellId, @i_agedTime, 0, 0, 0, A.appSizeFreedBytes, 0, A.acCommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommcellId = B.commCellId
		AND B.SIDBStoreId > 0
	INSERT INTO MMDeletedAF
	SELECT	archFileId, 0, 0, 0, archCopyId, 0, 0, 0, 0, SIDBStoreId, commCellId, @i_agedTime, 0, 0, 0, 0, 0, 0
	FROM #ToBeAgedAFCWithoutChunks
	WHERE	SIDBStoreId > 0
	-- Filter out chunks having non-aged archive files
	DELETE	#ToBeAgedAC
	FROM	#ToBeAgedAC T, archChunkMapping A WITH (NOLOCK)
	WHERE	A.archChunkId = T.archChunkId AND A.chunkCommCellId = T.commCellId
		AND A.flags & 256 = 0
	UPDATE	archChunk WITH (PAGLOCK)
	SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAC T, archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
		AND A.flags & 256 = 0
	-- Keep appSizeFreedBytes = 0 for non dedupe chunks
	IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize,
			archChunkId, #ToBeAgedAC.MountPathId, 0, 0, @i_agedTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isMagnetic = 1 AND SIDBStoreId = 0 AND version >= 3
	-- Keep appSizeFreedBytes = 0 for non magnetic chunks
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, '', SUM(physicalSize),
			0, 0, 0, 0, @i_agedTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isMagnetic = 0 AND SIDBStoreId = 0
	GROUP BY volumeId, archCopyId, commCellId
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SET @retVal = (SELECT ERROR_NUMBER())
END CATCH
DROP TABLE #ToBeAgedAFCOnTransitiveCopy
DROP TABLE #ToBeAgedACM
DROP TABLE #ToBeAgedAC
DROP TABLE #tmpJobSizeInfo
DROP TABLE #ToBeAgedAFCWithoutChunks
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSetAgedViaTable')
	delete from GxQscripts where name = 'archFileSetAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSetAgedViaTable')
	delete from GXDBVersions where aliasname = 'archFileSetAgedViaTable'
GO

insert into GXDBVersions values(2, 'archFileSetAgedViaTable',  '00010029000000000000', 'archFileSetAgedViaTable', '00010029000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetJobsAgedViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetJobsAgedViaTable.sp,v $ $Id: archSetJobsAgedViaTable.sp,v 1.13 2015/07/09 08:51:17 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archSetJobsAgedViaTable <<<'

IF EXISTS (select * from sysobjects where name='archSetJobsAgedViaTable')
	drop procedure archSetJobsAgedViaTable
IF EXISTS (select * from GxQscripts where name='archSetJobsAgedViaTable')
	delete from GxQscripts where name = 'archSetJobsAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetJobsAgedViaTable')
	delete from GXDBVersions where aliasname = 'archSetJobsAgedViaTable'
GO
print '... Creating Procedure: archSetJobsAgedViaTable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archSetJobsAgedViaTable
  @i_agedByFlag bigint,
  @i_agedTime integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
*/
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
-- SAFETY CHECK --
-- DO NOT PRUNE any jobs for SILO AppId except for Failed/Killed Jobs --
DELETE 	#ToBeAgedJob
FROM 		#ToBeAgedJob T,JMJobDataStats JDS WITH (NOLOCK)
WHERE 	T.JobId = JDS.JobId
AND 		T.archGrpId = JDS.archGrpId
AND			T.archGrpCopyId = JDS.archGrpCopyId
AND 		T.commCellId = JDS.commCellId
AND 		JDS.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
AND			JDS.status NOT IN (2, 3)
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Get archive files of pruneable jobs
INSERT	INTO #ToBeAgedAFC
SELECT	AF.id, AF.commCellId, T.archGrpCopyId
FROM	#ToBeAgedJob T, archFile AF WITH(NOLOCK)
WHERE	AF.jobId = T.jobId
	AND AF.commCellId = T.commCellId
	AND AF.fileType = T.dataType
	AND AF.archGroupId = T.archGrpId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DECLARE	@l_dateTime datetime
SET @l_dateTime = dbo.GetDateTime(@i_agedTime)
DECLARE	@retCode	INT
EXEC @retCode = archFileSetAgedViaTable @i_agedByFlag, @i_agedTime
SET	@retVal = @@ERROR
IF	@retVal = 0	SET	@retVal = @retCode
IF	@retVal <> 0 GOTO FINISH
-- Mark jobs as aged
UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		disabled = (J.disabled | 256), agedTime = @i_agedTime, modifiedTime = @i_agedTime, agedBy = (agedBy | @i_agedByFlag)
FROM	#ToBeAgedJob T, JMJobDataStats J
WHERE	J.jobId = T.jobId AND J.dataType = T.dataType
	AND J.archGrpCopyId = T.archGrpCopyId AND J.commCellId = T.commCellId
	AND J.disabled & 256 = 0
--If any of the jobs are marked aged above, find if the job is aged in catalog source and disable the job for cataloging
IF @@ROWCOUNT > 0
BEGIN
	DECLARE @tblMatSrcCopy TABLE ( archGroupId INT, sourceCopyId INT)
	INSERT INTO @tblMatSrcCopy
	SELECT a.id, (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	FROM    archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE   a.id = b.archGroupId
	AND     a.id = c.archGroupId
	AND     c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	AND     c.isSnapCopy > 0
	-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
	 WHILE EXISTS(SELECT T.sourceCopyId FROM @tblMatSrcCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	 BEGIN
		 UPDATE @tblMatSrcCopy
		 SET sourceCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
		 FROM    @tblMatSrcCopy T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		 WHERE   T.sourceCopyId = AGC.id
		 AND     T.archGroupId = AGC.archGroupId
		 AND     AGC.archGroupId = AG.id
		 AND     AGC.isSnapCopy > 0
		 AND     AGC.isMirrorCopy > 0
		 SET @retVal = @@ERROR
		 IF  @retVal <> 0 GOTO FINISH
	 END
	UPDATE JMJobSnapshotStats WITH (PAGLOCK)
	SET 	Disabled = JS.Disabled | 1, unPickReason = 4
	FROM JMJobSnapshotStats JS, #ToBeAgedJob T, @tblMatSrcCopy SC
	WHERE T.jobId = JS.jobId
	AND		T.commCellId = JS.commCellId
	AND		T.archGrpCopyId = SC.sourceCopyId
	AND  	(JS.Disabled & 1) = 0
	AND 	JS.materializationStatus in (101, 102, 103)
	AND JS.flags &  1 > 0
	AND T.dataType = 1
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
-- DELETE the pruned jobs from JMCompliancePolicyQualifiedjobs --
DELETE 	JMCompliancePolicyQualifiedJobs
FROM 	JMCompliancePolicyQualifiedJobs JMCQ, #ToBeAgedJob T WITH (NOLOCK)
WHERE 	JMCQ.JobId = T.JobId
AND 	JMCQ.commCellId = T.commCellId
SET @retVal = @@ERROR
FINISH:
DROP TABLE #ToBeAgedAFC
-- Added condition to insert value into temp table, if this stored procedure called for pruning volume reconciliation dangled jobs
IF OBJECT_ID('tempdb.dbo.#TblArchSetJobsAgedViaTableResult') IS NOT NULL
	INSERT INTO #TblArchSetJobsAgedViaTableResult SELECT @retVal
ELSE
	SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archSetJobsAgedViaTable')
	delete from GxQscripts where name = 'archSetJobsAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetJobsAgedViaTable')
	delete from GXDBVersions where aliasname = 'archSetJobsAgedViaTable'
GO

insert into GXDBVersions values(2, 'archSetJobsAgedViaTable',  '00010013000000000000', 'archSetJobsAgedViaTable', '00010013000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchAddSiloDataPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchAddSiloDataPath.sp,v $ $Id: ArchAddSiloDataPath.sp,v 1.1 2008/03/07 06:05:52 ylu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchAddSiloDataPath <<<'

IF EXISTS (select * from sysobjects where name='ArchAddSiloDataPath')
	drop procedure ArchAddSiloDataPath
IF EXISTS (select * from GxQscripts where name='ArchAddSiloDataPath')
	delete from GxQscripts where name = 'ArchAddSiloDataPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchAddSiloDataPath')
	delete from GXDBVersions where aliasname = 'ArchAddSiloDataPath'
GO
print '... Creating Procedure: ArchAddSiloDataPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchAddSiloDataPath
  @i_appId integer,
  @i_dataPathId integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @dataPathPrecedence INTEGER
DECLARE @errCode INTEGER
SET @errCode = 0
SET @dataPathPrecedence = ISNULL((SELECT MAX(precedence) FROM APP_AppToDataPath WHERE componentNameId = @i_appId), 0)
IF NOT EXISTS (SELECT * FROM APP_AppToDataPath WHERE componentNameId = @i_appId AND dataPathId = @i_dataPathId)
BEGIN
	INSERT INTO APP_AppToDataPath
	SELECT @i_appId, 1, @i_dataPathId, @dataPathPrecedence + 1, 0, 1
	SELECT @errCode = @@ERROR
END
SELECT @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'ArchAddSiloDataPath')
	delete from GxQscripts where name = 'ArchAddSiloDataPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchAddSiloDataPath')
	delete from GXDBVersions where aliasname = 'ArchAddSiloDataPath'
GO

insert into GXDBVersions values(2, 'ArchAddSiloDataPath',  '00010001000000000000', 'ArchAddSiloDataPath', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAgingRuleExtendedUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAgingRuleExtendedUpdate.sp,v $ $Id: archAgingRuleExtendedUpdate.sp,v 1.3 2012/03/17 18:04:49 smekala Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archAgingRuleExtendedUpdate <<<'

IF EXISTS (select * from sysobjects where name='archAgingRuleExtendedUpdate')
	drop procedure archAgingRuleExtendedUpdate
IF EXISTS (select * from GxQscripts where name='archAgingRuleExtendedUpdate')
	delete from GxQscripts where name = 'archAgingRuleExtendedUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAgingRuleExtendedUpdate')
	delete from GXDBVersions where aliasname = 'archAgingRuleExtendedUpdate'
GO
print '... Creating Procedure: archAgingRuleExtendedUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archAgingRuleExtendedUpdate
  @i_copyId INTEGER,
  @i_ruleXml XML
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE	TABLE #ExtAgingRule (RetentionRule INT, RetentionDays INT, GraceDays INT, EveryXHours INT)
INSERT	INTO #ExtAgingRule
SELECT	T.item.value('@Rule', 'INT'),
		T.item.value('@RetentionDays', 'INT'),
		T.item.value('@GraceDays', 'INT'),
		T.item.value('@EveryXHours', 'INT')
FROM	@i_ruleXml.nodes('/GalaxyOperations_AgingRules/Extended') T(item)
DECLARE	@errorCode		INT
DECLARE	@copyFlags		INT
SET		@errorCode = 0
SELECT	@copyFlags = flags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
IF	((@copyFlags & 16777216) <> 0)
BEGIN
	DECLARE	@OldRule TABLE (RetentionRule INT, RetentionDays INT, GraceDays INT , EveryXHours INT)
	INSERT	INTO @OldRule
	SELECT	RetentionRule, RetentionDays, GraceDays ,EveryXHours
	FROM	archAgingRuleExtended
	WHERE	copyId = @i_copyId
	IF	EXISTS (
		SELECT *
		FROM	@OldRule R, #ExtAgingRule T
		WHERE	R.RetentionRule = T.RetentionRule
			AND T.RetentionDays > 0 AND (R.RetentionDays < 0 OR T.RetentionDays < R.RetentionDays)
		)
	BEGIN
		SET	@errorCode = 93
	END
	ELSE
	IF	EXISTS (
		SELECT *
		FROM	@OldRule
		WHERE	RetentionRule NOT IN (SELECT RetentionRule FROM #ExtAgingRule)
		)
	BEGIN
		SET	@errorCode = 94
	END
	ELSE
	BEGIN
		UPDATE	archAgingRuleExtended
		SET		retentionDays = T.RetentionDays, GraceDays = T.GraceDays , EveryXHours = T.EveryXHours
		FROM	archAgingRuleExtended R, #ExtAgingRule T
		WHERE	R.copyId = @i_copyId AND R.RetentionRule = T.RetentionRule
			AND (R.retentionDays <> T.RetentionDays OR R.GraceDays <> T.GraceDays OR R.EveryXHours <> T.EveryXHours)
		INSERT	INTO archAgingRuleExtended
		SELECT	@i_copyId, RetentionDays, RetentionRule, 0, 0, 0, 0, GraceDays,EveryXHours
		FROM	#ExtAgingRule
		WHERE	RetentionRule NOT IN (SELECT RetentionRule FROM @OldRule)
	END
END
ELSE
BEGIN
	DELETE	archAgingRuleExtended
	WHERE	copyId = @i_copyId
	INSERT	INTO archAgingRuleExtended
	SELECT	@i_copyId, RetentionDays, RetentionRule, 0, 0, 0, 0, GraceDays, EveryXHours
	FROM	#ExtAgingRule
END
CX_EXIT:
DROP TABLE #ExtAgingRule
SELECT	@errorCode
RETURN	@errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archAgingRuleExtendedUpdate')
	delete from GxQscripts where name = 'archAgingRuleExtendedUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAgingRuleExtendedUpdate')
	delete from GXDBVersions where aliasname = 'archAgingRuleExtendedUpdate'
GO

insert into GXDBVersions values(2, 'archAgingRuleExtendedUpdate',  '00010003000000000000', 'archAgingRuleExtendedUpdate', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAllowJobForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAllowJobForCopy.sp,v $ $Id: archAllowJobForCopy.sp,v 1.52 2015/02/06 05:25:06 syadav Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archAllowJobForCopy <<<'

IF EXISTS (select * from sysobjects where name='archAllowJobForCopy')
	drop procedure archAllowJobForCopy
IF EXISTS (select * from GxQscripts where name='archAllowJobForCopy')
	delete from GxQscripts where name = 'archAllowJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAllowJobForCopy')
	delete from GXDBVersions where aliasname = 'archAllowJobForCopy'
GO
print '... Creating Procedure: archAllowJobForCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAllowJobForCopy
  @i_jobId integer,
  @i_commCellId integer,
  @i_copyId integer,
  @i_recopy integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@AGED_DONOTCOPY INT
SET @AGED_DONOTCOPY = 1 + 256
DECLARE	@tblJobDataStats TABLE (
	jobId int, archGrpId int, archGrpCopyId int, dataType int, status int, disabled int, appId int, commCellId int)
DECLARE @l_now integer
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
SET @retVal = -1
DECLARE	@l_archGrpId	int
DECLARE	@l_defCopyId	int
DECLARE	@l_srcCopyId	int
DECLARE	@l_SIDBStoreId	int
DECLARE	@l_dedupeFlags	int
DECLARE	@l_isSnapCopy	int
DECLARE	@l_isMirrorCopy	int
DECLARE	@magneticBytes	bigint
DECLARE @l_SelectDDBBackupJobForAuxCopy INTEGER = 0
IF EXISTS (SELECT * from MMConfigs  WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_SELECT_DDB_BACKUP_JOB_FOR_AUXCOPY' AND value > 0)
	SET @l_SelectDDBBackupJobForAuxCopy = 1
-- For DDB Backups do not insert into any destination copy for auxcopy
IF EXISTS (	SELECT	*
			FROM	APP_SubClientProp S WITH (NOLOCK), JMBkpStats J WITH (NOLOCK)
			WHERE	J.JobId = @i_jobId
					AND J.CommCellid  = @i_commCellId
					AND S.componentNameId = J.AppId
					AND S.attrName = 'DDB Backup'
						AND S.attrVal = N'1'
						AND S.modified = 0)
	AND (@l_SelectDDBBackupJobForAuxCopy = 0)
BEGIN
	SET @retVal = 9
	GOTO FINISH
END
SELECT	@l_archGrpId = archGroupId, @l_srcCopyId = sourceCopyId, @l_SIDBStoreId = SIDBStoreId, @l_dedupeFlags = dedupeFlags, @l_isSnapCopy = isSnapCopy, @l_isMirrorCopy = isMirrorCopy
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
SELECT	@l_defCopyId = (case when @l_isSnapCopy = 0 then defaultCopy else defaultSnapCopy end)
FROM	archGroup WITH (NOLOCK)
WHERE	id = @l_archGrpId
IF	@i_recopy <> 0
BEGIN
	IF	@l_defCopyId = @i_copyId
	BEGIN
		SET @retVal = 5
		GOTO FINISH
	END
	IF	@l_isSnapCopy <> 0
	BEGIN
		SET @retVal = 6
		GOTO FINISH
	END
	IF EXISTS (	SELECT	*
				FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
				WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId and AF.archGroupId = @l_archGrpId AND (AF.flags & 2) = 2 AND AF.isValid = 1
						AND AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId AND AFC.archCopyId = @i_copyId)
	BEGIN
		SET @retVal = 10
		GOTO FINISH
	END
END
IF @l_defCopyId = @i_copyId
	SET @l_srcCopyId = 0
ELSE
IF @l_srcCopyId = 0
	SET @l_srcCopyId = @l_defCopyId
IF @i_recopy <> 0
BEGIN
		DECLARE	@tblOpType TABLE (opType INT)
		INSERT	INTO @tblOpType
		SELECT	DISTINCT B.opType
		FROM	JMAdminJobInfoTable B WITH (NOLOCK)
		WHERE	B.opType IN (13, 104, 74)
		AND 	B.commCellId = @i_commCellId
		AND 	(B.archGrpCopyID > 0  AND (B.archGrpCopyId = @i_copyId OR ( B.opType = 74 AND B.archGrpCopyID = (SELECT destMediaCopyId FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId AND destMediaCopyId > 0))) )
				OR ( B.archGrpCopyId = 0
				    AND (B.archGrpid = @l_archGrpId OR ( B.opType = 74 AND B.archGrpID = (SELECT AG.id FROM archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK) WHERE AGC.id = @i_copyId AND AG.defaultCopy = AGC.destMediaCopyId AND AGC.destMediaCopyId > 0))) )
		IF 	(EXISTS (SELECT * FROM @tblOpType WHERE opType IN (13, 104))
					AND	EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
										WHERE	jobId = @i_jobId
										AND 	commCellId = @i_commCellId
										AND 	status IN (101, 102, 103)
										AND		 archGrpCopyId =  @i_copyId
										AND 	(disabled & (1|256)) = 0
									))
			OR	(EXISTS (SELECT * FROM @tblOpType WHERE opType = 74)
					AND	EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
										WHERE	jobId = @i_jobId
										AND 	commCellId = @i_commCellId
										AND 	archGrpCopyId  = @i_copyId
										AND 	(disabled & 256) = 0
									))
		BEGIN
			SET @retVal = 8
			GOTO FINISH
		END
END
INSERT	INTO @tblJobDataStats
SELECT	jobId, archGrpId, archGrpCopyId, dataType, status, disabled, appId, commCellId
FROM	JMJobDataStats WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
	AND (archGrpCopyId = @i_copyId OR @l_defCopyId <> @i_copyId AND archGrpCopyId = @l_srcCopyId)
--	AND appId <> @l_siloAppId
IF @i_recopy = 0 AND @l_SIDBStoreId > 0
	AND EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId
				AND status IN (102, 103) AND (disabled & @AGED_DONOTCOPY) = 1)
BEGIN
	DECLARE	@tblAF TABLE (archFileId int)
	INSERT	INTO @tblAF
	SELECT	AFC.archFileId
	FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1 AND (AF.flags & 2) = 0
		AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = @i_copyId
		AND AFC.isValid = 0 AND AFC.physicalSize > 0
	IF	EXISTS (SELECT	AF.archFileId
				FROM	@tblAF AF, archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
				WHERE	ACM.archFileId = AF.archFileId AND ACM.commCellId = @i_commCellId AND ACM.archCopyId = @i_copyId
					AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
					AND V.VolumeId = AC.volumeId AND V.SIDBStoreId <> @l_SIDBStoreId)
	BEGIN
		SET @retVal = 4
		GOTO FINISH
	END
END
IF NOT EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId)
BEGIN
	INSERT	INTO JMJobDataStats
	SELECT	jobId, archGrpId, @i_copyId, dataType, 13, 0, 101, 0, appId, commCellId, 0, 0, 0, 0, 0, 0, 0, @l_now, 0, 0, 0
	FROM	@tblJobDataStats
	WHERE	jobId = @i_jobId AND archGrpCopyId = @l_srcCopyId AND commCellId = @i_commCellId
		AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 0
	SET @retVal = 0
	if (@l_isSnapCopy = 1 AND @l_isMirrorCopy = 0 AND (EXISTS (SELECT * FROM archGroupCopy WHERE sourceCopyId = @i_copyId AND isMirrorCopy = 1)))
	BEGIN
		INSERT	INTO JMJobDataStats
		SELECT	jobId, archGrpId, AGC.id, dataType, 13, 0, 101, 0, appId, commCellId, 0, 0, 0, 0, 0, 0, 0, @l_now, 0, 0, 0
		FROM	@tblJobDataStats, archGroupCopy AGC
		WHERE	jobId = @i_jobId AND archGrpCopyId = @l_srcCopyId AND commCellId = @i_commCellId
			AND status = 100 AND (disabled & @AGED_DONOTCOPY) = 0
			AND AGC.sourceCopyId = @i_copyId AND isMirrorCopy = 1
	END
END
ELSE
IF @i_recopy = 0 AND EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId
			AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 1)
BEGIN
	-- This below condition is for pick for copy when we want to pick job for copying , not the allow copy on source copy where data is available.
	IF @l_srcCopyId <> 0 AND EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId AND status IN (101, 102, 103) )
			AND NOT EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @l_srcCopyId AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 0)
	BEGIN
		SET @retVal = 1
		GOTO FINISH
	END
	DECLARE @tblJobCopyToSet TABLE (jobId INT, archGrpCopyId INT, commCellId INT, sourceCopyId INT, toBeSet INT)
	DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT)
	INSERT INTO @tblCopyToSet
	EXEC ArchDestinationCopyList @i_copyId
	INSERT	INTO @tblJobCopyToSet
	SELECT	DISTINCT J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId, 0
	FROM	JMJobDataStats J, @tblCopyToSet C
	WHERE	J.jobId = @i_jobId AND J.archGrpCopyId = C.copyId AND J.commCellId = @i_commCellId
		AND status IN (100, 101, 102, 103) AND J.status <> 100 AND (J.disabled & @AGED_DONOTCOPY) = 1
	INSERT	INTO @tblJobCopyToSet
	SELECT	@i_jobId, @i_copyId, @i_commCellId, 0, 1
	WHILE @@ROWCOUNT > 0
		UPDATE	@tblJobCopyToSet SET toBeSet = 1
		WHERE	toBeSet = 0 AND sourceCopyId IN (SELECT archGrpCopyId FROM @tblJobCopyToSet WHERE toBeSet = 1)
	UPDATE 	JMJobDataStats
	SET		disabled =  (J.disabled & ~1), modifiedTime = @l_now
	FROM	JMJobDataStats J, @tblJobCopyToSet T
	WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archGrpCopyId AND J.commCellId = T.commCellId
		AND (J.disabled & @AGED_DONOTCOPY) = 1 AND T.toBeSet = 1
	SET @retVal = 0
END
ELSE
IF @l_defCopyId <> @i_copyId
BEGIN
	IF NOT EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @l_srcCopyId AND status IN (100, 101, 102, 103) AND (disabled & @AGED_DONOTCOPY) = 0)
		SET @retVal = 1
	ELSE
	IF EXISTS (SELECT * FROM @tblJobDataStats WHERE archGrpCopyId = @i_copyId AND (@i_recopy <> 0 OR status = 1000 OR disabled & 256 <> 0))
	BEGIN
		CREATE TABLE #ToBeAgedAFC (
			archFileId INT, commCellId INT, archCopyId INT, fileType INT,
			PRIMARY KEY (archFileId, commCellId, archCopyId))
		SET @retVal = 0
		INSERT	INTO #ToBeAgedAFC
		SELECT	id, commCellId, @i_copyId, fileType
		FROM	archFile WITH (NOLOCK)
		WHERE	jobId = @i_jobId AND commCellId = @i_commCellId and archGroupId = @l_archGrpId AND (flags & 2) = 0 AND isValid = 1
		-- Can't recopy pruned archive files on a spool copy
		IF EXISTS (SELECT copyId FROM archAgingRule WHERE copyId = @l_srcCopyId AND retentionDays = 0 AND fullCycles = 0)
			DELETE	#ToBeAgedAFC
			FROM	#ToBeAgedAFC T LEFT OUTER JOIN archFileCopy AFC
				ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = @l_srcCopyId
			WHERE	AFC.archFileId Is Null OR (AFC.flags & 256) <> 0
		ELSE
			DELETE	#ToBeAgedAFC
			WHERE	fileType IN
				(
					SELECT	DISTINCT T.fileType
					FROM	#ToBeAgedAFC T LEFT OUTER JOIN archFileCopy AFC
						ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = @l_srcCopyId
					WHERE	AFC.archFileId Is Null OR (AFC.flags & 256) <> 0
				)
		IF NOT EXISTS (SELECT * FROM #ToBeAgedAFC)
		BEGIN
			SET @retVal = 1
			GOTO FINISH
		END
		UPDATE	JMJobDataStats
		SET 	status = 101, disabled = 0, archCheckEndTime = 0, archCheckStatus = 0,
				copiedTime = 0, agedTime = 0, mediaDeletedTime = 0, modifiedTime = @l_now
		FROM	JMJobDataStats J, (SELECT DISTINCT fileType FROM #ToBeAgedAFC) AS T
		WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId AND J.archGrpCopyId = @i_copyId AND J.dataType = T.fileType
			AND (@i_recopy <> 0 OR status = 1000 OR (J.disabled & 256) <> 0)
		--
		-- Jai - Form 10971
		-- If recopy for dedup copy, set dummy param as below
		-- so that archFileDeleteViaTable puts large AFId in mmdeletedaf table
		--
		declare @i_dummyParam integer
		set @i_dummyParam	=	0
		if (@i_recopy <> 0)
		begin
			set @i_dummyParam	=	1
		end
		EXEC @retVal = archFileDeleteViaTable @i_dummyParam, @magneticBytes OUTPUT
		IF @@ERROR <> 0 OR @retVal <> 0
			SET @retVal = 2
		DROP TABLE #ToBeAgedAFC
	END
END
FINISH:
IF OBJECT_ID('tempdb..#tmpResutSetForArchAllowJobForCopy') IS NOT NULL
BEGIN
	INSERT INTO #tmpResutSetForArchAllowJobForCopy
	SELECT @retVal
END
ELSE
	SELECT @retVal
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archAllowJobForCopy')
	delete from GxQscripts where name = 'archAllowJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAllowJobForCopy')
	delete from GXDBVersions where aliasname = 'archAllowJobForCopy'
GO

insert into GXDBVersions values(2, 'archAllowJobForCopy',  '00010052000000000000', 'archAllowJobForCopy', '00010052000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAutoCopyTaskToBeRun.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAutoCopyTaskToBeRun.sp,v $ $Id: archAutoCopyTaskToBeRun.sp,v 1.11 2015/03/09 10:20:07 chandru Exp $";
--
--  +========================================================================+
--  | Stored Procedure:  archAutoCopyTaskToBeRun
--	| Author:	Jun Lu
--  |
--  | Description:  For a given task ID, check if there are to be copied jobs.
--	|				Then check if there is already a running auxiliary copy job
--	|				for the the storage policy/copy.
--	| Input:		task ID
--	| Output:		o_archGrpId, o_archGrpCopyId, o_errorCode
--	|
--	|	o_errorCode									Action needed
--	|	---------------------------------------------------------------------
--	|  	E_ARCH_INVALID_AUXCOPY_TASK_ID				Invalidate task
--	|  	E_ARCH_NO_SP_COPY_FROM_ADMINTASK			Invalidate task
--	|	E_ARCH_COPY_IS_PRIMARY						Invalidate task
--	|	E_ARCH_INVALID_COPY_ID						Invalidate task
--	|	E_ARCH_NO_SECONDARY_COPY					Disable task?
--	|	E_ARCH_AUTOCOPY_FOR_RECENT_FULL_COPY		Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE						Disable task?
--	|	E_ARCH_COPY_NOT_EFFECTIVE					Disable task?
--	|	E_ARCH_COPY_NOT_ACTIVE_EFFECTIVE			Disable task?
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_SP				No action
--	|	E_ARCH_JOBS_ARE_RUNNING_FOR_COPY			No action
--	|	E_ARCH_NO_TO_BE_COPIED_DATA					No action
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archAutoCopyTaskToBeRun <<<'

IF EXISTS (select * from sysobjects where name='archAutoCopyTaskToBeRun')
	drop procedure archAutoCopyTaskToBeRun
IF EXISTS (select * from GxQscripts where name='archAutoCopyTaskToBeRun')
	delete from GxQscripts where name = 'archAutoCopyTaskToBeRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoCopyTaskToBeRun')
	delete from GXDBVersions where aliasname = 'archAutoCopyTaskToBeRun'
GO
print '... Creating Procedure: archAutoCopyTaskToBeRun'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAutoCopyTaskToBeRun
  @i_taskId integer,
  @i_today integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archGrpId integer
  DECLARE @o_archGrpCopyId integer
  DECLARE @o_errorCode integer
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
DECLARE @tblCopy	TABLE (
	id				int,
	archGroupId		int,
	isActive		int,
	type			int,
	startTime		int,
	sourceCopyId	int,
	delayedDays		int)
DECLARE @tblJobCopy	TABLE (
	jobId			int,
	archGrpCopyId	int,
	dataType		int,
	commCellId		int,
	primary key (jobid, commCellId, archGrpCopyId, dataType)
	)
DECLARE @l_archGroupId	int
DECLARE @l_archCopyId	int
DECLARE @l_error		int
DECLARE @l_rowcount		int
-- AUXILIARY_COPY_ITEM = 7330
IF NOT EXISTS (SELECT * FROM TM_SubTask WITH (NOLOCK) WHERE taskId = @i_taskId AND operationType = 4003)
BEGIN
	SET @l_error = 37
	GOTO FINISH
END
SELECT	@l_archCopyId = ISNULL(CONVERT(INT, A.copyId), 0),
		@l_archGroupId = ISNULL(CONVERT(INT, A.policyId), 0)
FROM	TM_AssocEntity A WITH (NOLOCK)
WHERE	A.taskId = @i_taskId
--SELECT	@l_archGroupId = ISNULL(CONVERT(INT, B.value), 0)
--FROM	TM_SubTask A WITH (NOLOCK), TM_SubTaskOptions B WITH (NOLOCK)
--WHERE	A.taskId = @i_taskId AND B.subTaskId = A.subTaskId AND optionId = COM_POLICY_ID
--SELECT	@l_archCopyId = ISNULL(CONVERT(INT, B.value), 0)
--FROM	TM_SubTask A WITH (NOLOCK), TM_SubTaskOptions B WITH (NOLOCK)
--WHERE	A.taskId = @i_taskId AND B.subTaskId = A.subTaskId AND optionId = COM_COPY_ID
IF	@l_archCopyId = 0 AND @l_archGroupId = 0
BEGIN
	SET @l_error = 38
	GOTO FINISH
END
ELSE
IF	@l_archCopyId > 0
BEGIN
	IF EXISTS (	SELECT	*
				FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
				WHERE	AGC.id = @l_archCopyId AND AG.id = AGC.archGroupId
					AND (AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy))
	BEGIN
		SET	@l_error = 16
		GOTO FINISH
	END
	INSERT	INTO @tblCopy
	SELECT	AGC.id, AGC.archGroupId, AGC.isActive, AGC.type, AGC.startTime,
			(case when AGC.sourceCopyId > 0 then AGC.sourceCopyId when AGC.isSnapCopy = 1 then AG.defaultSnapCopy else AG.defaultCopy end),
			AGC.delayedDays
	FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE	AGC.id = @l_archCopyId AND AG.id = AGC.archGroupId
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
	SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
	IF	@l_error = 0 AND @l_rowcount = 0
		SET	@l_error = 9
END
ELSE
IF	@l_archGroupId > 0
BEGIN
	INSERT	INTO @tblCopy
	SELECT	AGC.id, AGC.archGroupId, AGC.isActive, AGC.type, AGC.startTime,
			(case when AGC.sourceCopyId > 0 then AGC.sourceCopyId when AGC.isSnapCopy = 1 then AG.defaultSnapCopy else AG.defaultCopy end),
			AGC.delayedDays
	FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE	AGC.archGroupId = @l_archGroupId AND AG.id = AGC.archGroupId
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
	SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
	IF	@l_error = 0 AND @l_rowcount = 0
		SET	@l_error = 8
END
IF	@l_error <> 0 GOTO FINISH
IF	NOT EXISTS (SELECT * FROM @tblCopy WHERE isActive = 1)
	SET	@l_error = 12
ELSE
IF	NOT EXISTS (SELECT * FROM @tblCopy WHERE startTime <= @i_today)
	SET	@l_error = 13
ELSE
IF	NOT EXISTS (SELECT * FROM @tblCopy WHERE isActive = 1 AND startTime <= @i_today)
	SET	@l_error = 14
IF	@l_error <> 0 GOTO FINISH
-- when we get to here, at least one copy is active and effective.
DELETE	@tblCopy
WHERE	isActive = 0 OR startTime > @i_today
-- if there is already a running aux copy job for the storage policy or copy
IF	EXISTS (SELECT * FROM JMAdminJobInfoTable WITH (NOLOCK)
			WHERE	opType IN (13, 104) AND archGrpID = @l_archGroupId AND archGrpCopyID = 0)
BEGIN
	SET	@l_error = 26
	GOTO FINISH
END
ELSE
BEGIN
	DELETE	@tblCopy
	FROM	@tblCopy A, JMAdminJobInfoTable B WITH (NOLOCK)
	WHERE	opType IN (13, 104) AND B.archGrpCopyID = A.id
	IF	@@ROWCOUNT > 0 AND NOT EXISTS (SELECT * FROM @tblCopy)
	BEGIN
		SET	@l_error = 27
		GOTO FINISH
	END
END
INSERT	INTO @tblJobCopy
SELECT	a.jobId, a.archGrpCopyId, a.dataType, a.commCellId
FROM	JMJobDataStats a WITH (NOLOCK), @tblCopy b
WHERE	a.archGrpCopyId = b.id
	AND a.status IN (101, 102, 103) AND (a.disabled & (1 + 256)) = 0
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
-- delete jobs on delayed copies if they are not older than delayedDays
DELETE	@tblJobCopy
FROM	@tblJobCopy a, @tblCopy b, JMBkpStats c WITH (NOLOCK)
WHERE	a.archGrpCopyId = b.id AND b.delayedDays > 0
	AND c.jobId = a.jobId AND c.commCellId = a.commCellId
	AND (@i_today - c.servStartDate ) < b.delayedDays*86400
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
-- delete jobs that are not available on source copy
DELETE  @tblJobCopy
FROM    @tblJobCopy AS T
		INNER JOIN @tblCopy b ON T.archGrpCopyId = b.id
        LEFT JOIN JMJobDataStats c WITH (NOLOCK)
			ON     c.dataType = T.dataType
                    AND b.sourceCopyId = c.archGrpCopyId
                    AND c.jobId = T.jobId
                    AND c.commCellId = T.commCellId
                    AND c.status = 100
                    AND c.disabled & (1 + 256) = 0
WHERE  c.jobId IS NULL
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0 GOTO FINISH
IF	NOT EXISTS (SELECT * FROM @tblJobCopy)
	SET	@l_error = 31
FINISH:
SELECT	@l_archGroupId, @l_archCopyId, @l_error
GO

IF EXISTS (select * from GxQscripts where name = 'archAutoCopyTaskToBeRun')
	delete from GxQscripts where name = 'archAutoCopyTaskToBeRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAutoCopyTaskToBeRun')
	delete from GXDBVersions where aliasname = 'archAutoCopyTaskToBeRun'
GO

insert into GXDBVersions values(2, 'archAutoCopyTaskToBeRun',  '00010011000000000000', 'archAutoCopyTaskToBeRun', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archAuxCopyFallenBehindAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archAuxCopyFallenBehindAlert.sp,v $ $Id: archAuxCopyFallenBehindAlert.sp,v 1.20 2015/05/08 15:16:07 syadav Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archAuxCopyFallenBehindAlert <<<'

IF EXISTS (select * from sysobjects where name='archAuxCopyFallenBehindAlert')
	drop procedure archAuxCopyFallenBehindAlert
IF EXISTS (select * from GxQscripts where name='archAuxCopyFallenBehindAlert')
	delete from GxQscripts where name = 'archAuxCopyFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAuxCopyFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'archAuxCopyFallenBehindAlert'
GO
print '... Creating Procedure: archAuxCopyFallenBehindAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archAuxCopyFallenBehindAlert
  @i_dummy int
AS
--JobId is removed
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(255)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(255)
  DECLARE @o_bytesNotCopied bigint
  DECLARE @o_nMediaNotCopied integer
  DECLARE @o_nJobsNotCopied integer
  DECLARE @o_oldestJobEndTime integer
  DECLARE @o_hoursForCopy integer
  DECLARE @o_nSubClients integer
  DECLARE @o_alertReason integer
  DECLARE @o_onlyEvent integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- We are also using this stored proc for the default event generation where alert in not enabled on copy
-- and there are jobs which are more than 90 days old and not yet copied.
-- We are storing Data Copied criteria in TB corresponding to the property name  "AuxCopyAlertGB".
-- so we put the column name in table @tblAGC1 AuxCopyAlertGB which is used for storing values in TB.
-- Table having copy data with alert configuration.
DECLARE @tblAGC1 TABLE (archCopyId INT, archGroupId INT, commCellId INT, AuxCopyAlertGB INT, AuxCopyAlertDays INT, AuxCopyAlertHours INT, sourceCopyId INT, onlyEvent  INT)
-- Table for having the aggregate data per copy for alert .
DECLARE @tblAGC2 TABLE (archGrpId INT, archGrpCopyId INT, numOfJobs INT, oldestJobEndTime INT, toBeCopiedBytes BIGINT, thPut BIGINT, subClients INT, alertReason INT, onlyEvent INT)
-- Table for having To Be Copied Job Data for each data type.
IF (OBJECT_ID('tempdb.dbo.#tblJobDataType') IS NOT NULL) DROP TABLE #tblJobDataType
CREATE TABLE #tblJobDataType (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT, status INT, toBeCopiedBytes BIGINT, toBeCopiedPhysicalBytes BIGINT
					PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
-- Table for having aggregate To Be copied Job Data.
IF (OBJECT_ID('tempdb.dbo.#tblJob') IS NOT NULL) DROP TABLE #tblJob
CREATE TABLE #tblJob (jobId INT, commCellId INT, archGrpCopyId INT, jobEndTime INT, toBeCopiedBytes BIGINT, toBeCopiedPhysicalBytes BIGINT
					PRIMARY KEY (jobId, commCellId, archGrpCopyId))
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo ( JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
					PRIMARY KEY (JobId, CommCellId))
-- Table used for having the last auxiliary copy jobs for throughput calculation.
DECLARE @lastAuxJobs TABLE( archCopyId INT, jobId INT, bytesCopied BIGINT, writeTime INT)
DECLARE @l_now	INT
DECLARE @l_lastjobs INT = 10
DECLARE @l_REAL FLOAT
SET @l_REAL = 1.0
SET @l_now = dbo.GetUnixTime(GETDATE())
--Minimum jobs for to be copied throughput from MMConfig table
SELECT @l_lastjobs = ISNULL(value,10)
FROM MMConfigs  WITH (NOLOCK)
WHERE name = 'MMCONFIG_AUXCOPY_FALLEN_BEHIND_ALERT_NUMBER_OF_JOBS_FOR_THROUGHPUT'
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId, onlyEvent)
SELECT MMEP.EntityId, AGC.archGroupid, MMEP.CommCellId, CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END, 0
FROM MMEntityProp MMEP WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE MMEP.EntityId = AGC.id AND AG.id = AGC.archGroupId
	AND MMEP.EntityType = 2
	AND MMEP.propertyName = 'auxCopyAlertEnabled'
	AND MMEP.intVal = 1
-- Populating Copies data on which alert is not enabled on copy and available in MMEntityProp.
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId, onlyEvent)
SELECT MMEP.EntityId, AGC.archGroupid, MMEP.CommCellId, CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END, 1
FROM MMEntityProp MMEP WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE MMEP.EntityId = AGC.id AND AG.id = AGC.archGroupId
	AND MMEP.EntityType = 2
	AND MMEP.propertyName = 'auxCopyAlertEnabled'
	AND MMEP.intVal = 0
	AND AGC.type IN (1, 2)
	AND AGC.id <> AG.defaultCopy
	AND AGC.flags & 524288  = 0
	AND AGC.extendedFlags & 8 = 0
-- Populating Copies data on which alert is not enabled on copy and not available in MMEntityProp.
INSERT INTO @tblAGC1 (archCopyid, archGroupId, commCellId, sourceCopyId, onlyEvent)
SELECT AGC.id, AGC.archGroupid, CASE WHEN AGC.origCCcommCellID = 0 THEN 2 ELSE AGC.origCCcommCellID END, CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END, 1
FROM archGroupCopy AGC WITH (NOLOCK)
	INNER JOIN archGroup AG WITH (NOLOCK)
		ON AG.id = AGC.archGroupId
		AND AGC.type IN (1, 2)
		AND AGC.id <> AG.defaultCopy
		AND AGC.flags & 524288  = 0
		AND AGC.extendedFlags & 8 = 0
	LEFT OUTER JOIN MMEntityProp MMEP WITH (NOLOCK)
		ON MMEP.EntityId = AGC.id AND MMEP.propertyName = 'auxCopyAlertEnabled' AND MMEP.EntityType = 2
	WHERE MMEP.EntityId IS NULL
--Getting configuration values from MMEntityprop table for each copy
UPDATE AGC
SET AGC.AuxCopyAlertGB = MMEP1.longlongVal,
	AGC.AuxCopyAlertDays = MMEP2.intVal,
	AGC.AuxCopyAlertHours = MMEP3.intVal
FROM @tblAGC1 AGC, MMEntityProp MMEP1 WITH (NOLOCK),
	MMEntityProp MMEP2 WITH (NOLOCK),
	MMEntityProp MMEP3 WITH (NOLOCK)
WHERE 	AGC.archCopyid = MMEP1.EntityId AND AGC.commCellId = MMEP1.CommCellId AND MMEP1.EntityType = 2
	AND AGC.archCopyid = MMEP2.EntityId AND AGC.commCellId = MMEP2.CommCellId AND MMEP2.EntityType = 2
	AND AGC.archCopyid = MMEP3.EntityId AND AGC.commCellId = MMEP3.CommCellId AND MMEP3.EntityType = 2
	AND MMEP1.propertyName  = 'AuxCopyAlertGB'
	AND MMEP2.propertyName  = 'AuxCopyAlertDays'
	AND MMEP3.propertyName  = 'AuxCopyAlertHours'
	AND AGC.onlyEvent = 0
-- updating default event generation criteria to 90 days
UPDATE AGC
SET AGC.AuxCopyAlertGB = 0,
	AGC.AuxCopyAlertDays = 90,
	AGC.AuxCopyAlertHours = 0
FROM @tblAGC1 AGC
	WHERE AGC.onlyEvent = 1
-- Getting all the to be copied Job with data types per copy
-- Data type is considered because we have individual retention criteria for data types ( eg. data, log ...)
-- So for alert about exact to be copied we have to consider each data type to be copied size.
INSERT #tblJobDataType
SELECT JD.jobId, JD.commCellId, JD.archGrpCopyId, JD.dataType, JD.status, 0, 0
FROM JMJobDataStats JD WITH (NOLOCK), JMJobDataStats JS WITH (NOLOCK), @tblAGC1 AGC
WHERE  JD.archGrpId = JS.archGrpId
	AND JD.jobId = JS.jobId
	AND JD.dataType = JS.dataType
	AND JD.commCellId = JS.commCellId
	AND (JS.disabled & (1  + 256) = 0)
	AND (JD.disabled & (1  + 256) = 0)
	AND JS.status = 100
	AND JD.status IN (101,102,103)
	AND JD.archGrpCopyId = AGC.archCopyId
	AND JS.archGrpCopyId = AGC.sourceCopyId
-- Populating UnCompSize and physicalSize for each Job data type from source copy
UPDATE	JT
SET		JT.toBeCopiedBytes = JS.UnCompSize, JT.toBeCopiedPhysicalBytes = JS.physicalSize
FROM	#tblJobDataType JT, ( SELECT J.archGrpCopyId, J.commCellId, J.jobId, J.dataType, CASE WHEN MIN(ACM.unCompSize) <= 0 THEN -1 ELSE SUM(ACM.unCompSize) END UnCompSize, SUM(physicalSize) physicalSize
FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), #tblJobDataType J, @tblAGC1 AGC
WHERE ACM.archFileId = AF.id
	AND ACM.commCellId = AF.commcellId
	AND ACM.jobId = AF.jobId
	AND ACM.commCellId = AF.commCellId
	 AND AF.jobId = J.jobId
	 AND AF.commCellId =  J.commCellId
	 AND  AF.fileType = J.dataType
	  AND J.archGrpCopyId = AGC.archCopyId
	  AND ACM.archCopyId = AGC.sourceCopyId
	  AND AF.isvalid = 1
	GROUP BY J.archGrpCopyId, J.jobId, J.commCellId, J.dataType ) JS
WHERE JT.jobId = JS.jobId
	AND JT.commCellId = JS.commCellId
	AND JT.dataType = JS.dataType
	AND JT.archGrpCopyId = JS.archGrpCopyId
-- Two Cases where we cannot do any partial data copied subtraction
-- 1. When UnCompSize on Source is -ve or 0, we cannot subtract anything from source.
-- 2. When UnCompSize on Dest is -ve or 0, we do not have any correct value for subtraction.
-- In these above cases we are dependent on physical size which later converted into unCompSize using archGetJobSizeInfo.sp .
UPDATE	JT
SET JT.toBeCopiedBytes =  CASE WHEN JT.toBeCopiedBytes = -1 OR ISNULL(S.UnCompCopiedBytes,0) = -1 THEN -1 ELSE JT.toBeCopiedBytes - ISNULL(S.UnCompCopiedBytes,0) END , JT.toBeCopiedPhysicalBytes = JT.toBeCopiedPhysicalBytes - ISNULL(S.physicalCopiedBytes, 0)
FROM #tblJobDataType JT
   LEFT OUTER JOIN
		(SELECT	J.JobId, J.commCellId, J.archGrpCopyId, J.dataType, CASE WHEN MIN(ACM.unCompSize) <= 0 THEN -1 ELSE SUM(ACM.unCompSize) END UnCompCopiedBytes, SUM(ACM.physicalSize) physicalCopiedBytes
		FROM archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK), #tblJobDataType J
		WHERE ACM.archFileId = AF.Id
			AND ACM.commCellId = AF.commCellId
			AND AF.jobId = J.jobId
			AND AF.fileType  = J.dataType
			AND ACM.archCopyId = J.archGrpCopyId
			AND ACM.commCellId = J.commCellId
		    AND J.status <> 101
		GROUP BY J.JobId, J.commCellId, J.archGrpCopyId, J.dataType) S
  ON JT.jobId = S.jobId
	AND JT.commCellId = S.commCellId
	AND JT.archGrpCopyId = S.archGrpCopyId
	AND JT.dataType = S.dataType
-- If for any data type for each job, we get -ve or 0 uncompsize then we will use physical size for unCompSize.
INSERT #tblJob
SELECT	jobId, commCellId, archGrpCopyId, 0 'jobEndTime', CASE WHEN MIN(J.toBeCopiedBytes) <= 0 THEN -1 ELSE SUM(J.toBeCopiedBytes) END, SUM(J.toBeCopiedPhysicalBytes)
FROM #tblJobDataType J
GROUP BY archGrpCopyId, jobId, commCellId
UPDATE	J
SET		J.jobEndTime = B.servEndDate
FROM	#tblJob J, JMBkpStats B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
UPDATE	J
SET		J.jobEndTime = B.servEnd
FROM	#tblJob J, JMadminJobStatsTable B WITH (NOLOCK)
WHERE J.jobId = B.jobId AND J.commCellId = B.commCellId
INSERT #tmpJobSizeInfo
SELECT DISTINCT jobId, commCellId, 0, 0, 0 FROM  #tblJob
WHERE toBeCopiedBytes <= 0
EXEC archGetJobSizeInfo 0
UPDATE T
SET T.toBeCopiedBytes = CASE WHEN TS.totalBackupSize > 0 THEN  T.toBeCopiedPhysicalBytes*1.00*(TS.totalAppSize + TS.totalIndexSize)/TS.totalBackupSize ELSE (TS.totalAppSize + TS.totalIndexSize) END
FROM #tblJob T , #tmpJobSizeInfo TS
WHERE T.jobId = TS.JobId AND T.commCellId = TS.CommCellId
	AND toBeCopiedBytes <= 0
INSERT @lastAuxJobs
SELECT RN.archGrpCopyId, RN.jobId, RN.BytesXferred,  RN.totalWriteTime*@l_REAL*RN.BytesXferred / RN.EX_TotalSuccess
FROM   @tblAGC1 A
		CROSS APPLY
	(SELECT TOP(@l_lastjobs) J.*, JA.totalWriteTime, JA.EX_TotalSuccess
	FROM JMDataCopiedStatsTable J WITH (NOLOCK), JMAdminJobStatsTable JA WITH (NOLOCK)
	WHERE J.archGrpCopyId = A.archCopyId
	AND J.jobId = JA.jobId
	AND JA.commCellId = J.commCellId
	AND J.commCellId = A.commCellId
	AND JA.opType IN (13, 104)
	AND JA.EX_TotalSuccess > 0
	ORDER BY J.jobId DESC) RN
	WHERE A.onlyEvent = 0
-- Getting the running auxiliary copy jobs throughput.
INSERT @lastAuxJobs
SELECT J.archGrpCopyId, J.jobId, J.BytesXferred, elapsedTime*@l_REAL*J.BytesXferred/RAJ.ObjectsDone
FROM JMDataCopiedStatsTable J WITH (NOLOCK), @tblAGC1 A, RunningAdminJobs RAJ, @lastAuxJobs LA
WHERE J.jobId = RAJ.jobId
	AND J.commCellId = RAJ.commCellId
	AND A.archCopyId = J.archGrpCopyId
	AND RAJ.opType IN (13, 104)
	AND RAJ.ObjectsDone  > 0
	AND J.archGrpCopyId NOT IN (SELECT DISTINCT archCopyId FROM @lastAuxJobs)
	AND A.onlyEvent = 0
-- Aggregating the data from #tblJob and @lastAuxJobs table.
INSERT INTO @tblAGC2
SELECT AG.archGroupId, J.archGrpCopyId, J.numofToBeCopiedJobs, J.jobEndTime, J.toBeCopiedBytes,
(CASE WHEN TP.wTime > 0 THEN  TP.BytesTransfer / TP.wTime ELSE  0 END), 0, 0, AG.onlyEvent
FROM @tblAGC1 AG
JOIN (SELECT archGrpCopyId, COUNT(jobId) as numofToBeCopiedJobs, MIN(jobEndTime) as jobEndTime, SUM(toBeCopiedBytes) as toBeCopiedBytes
	FROM #tblJob GROUP BY archGrpCopyId, commCellId) J
	ON AG.archCopyid = J.archGrpCopyId
LEFT OUTER JOIN
( SELECT archCopyId, SUM(bytesCopied) BytesTransfer, SUM(writeTime) wTime
FROM @lastAuxJobs
GROUP BY archCopyId ) TP
ON  AG.archCopyId = TP.archCopyId
UPDATE AG
SET AG.subClients = SC.subclients
FROM @tblAGC2 AG,
(SELECT J.archGrpCopyId , COUNT(DISTINCT J.appId) 'subclients'
FROM JMJobDataStats J WITH (NOLOCK), @tblAGC2 A
WHERE J.archGrpCopyId = A.archGrpCopyId and J.disabled & (256 + 1) = 0 AND J.status IN (100, 101, 102, 103)
GROUP BY J.archGrpCopyId ) SC
WHERE AG.archGrpCopyId = SC.archGrpCopyId
	AND AG.onlyEvent = 0
--Updating the alert reason for each criteria.
UPDATE @tblAGC2
SET alertReason = alertReason | 1
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertDays > 0 AND (@l_now - AGC2.oldestJobEndTime)/24/3600 > AGC1.AuxCopyAlertDays)
UPDATE @tblAGC2
SET alertReason = alertReason | 2
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertGB > 0 AND AGC2.toBeCopiedBytes*@l_REAL/1024/1024/1024/1024 > AGC1.AuxCopyAlertGB)
	 AND AGC2.onlyEvent = 0
UPDATE @tblAGC2
SET alertReason = alertReason | 4
FROM @tblAGC1 AGC1, @tblAGC2 AGC2
WHERE	AGC2.archGrpCopyId = AGC1.archCopyid
	AND (AGC1.AuxCopyAlertHours > 0 AND (AGC2.thPut > 0 AND
	 (AGC1.AuxCopyAlertHours*3600 < AGC2.toBeCopiedBytes/AGC2.thPut)))
	 AND AGC2.onlyEvent = 0
-- Deleting the copies data where it do not satisfy the alert or event criteria.
DELETE @tblAGC2
WHERE alertReason = 0
IF OBJECT_ID('tempdb.dbo.#UncopiedMediaAuxCopyFallenBehindAlert') IS NOT NULL DROP TABLE #UncopiedMediaAuxCopyFallenBehindAlert
CREATE TABLE #UncopiedMediaAuxCopyFallenBehindAlert (
		policyId		integer,
		policyName 		NVARCHAR(256),
		copyId			integer,
		copyName		NVARCHAR(64),
		streamNum		integer,
		mediaGroupId 	integer,
		mediaId			integer,
		uniqueId		char(300),
		barCode 		char(256),
		attributes	 	integer,
		guiAttributes	integer,
		libraryId		integer,
		libraryName		NVARCHAR(128),
		locationType	integer,
		locationId 		integer,
		location		NVARCHAR(1024),
		uncopiedBytes	bigint,
		reason			integer)
DECLARE getSPCur CURSOR FOR SELECT DISTINCT archGrpId FROM @tblAGC2
OPEN	getSPCur
DECLARE @l_archGrpId int
FETCH NEXT FROM getSPCur INTO @l_archGrpId
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT	INTO #UncopiedMediaAuxCopyFallenBehindAlert
	EXEC	archUncopiedMedia  @l_archGrpId, 0
	FETCH NEXT FROM getSPCur INTO @l_archGrpId
END
CLOSE	getSPCur
DEALLOCATE getSPCur
SELECT	S.policyId, S.policyName, S.copyId, S.copyName, T.toBeCopiedBytes, S.numOfMedia, T.numOfJobs, T.oldestJobEndTime, (CASE WHEN T.thPut  <> 0 THEN ROUND((T.toBeCopiedBytes*@l_REAL/T.thPut/3600),0) ELSE 0 END), T.subClients, T.alertReason, T.onlyEvent
FROM	@tblAGC2 T,
		(SELECT	policyId, policyName, copyId, copyName, SUM(uncopiedBytes) AS uncopiedBytes, COUNT(*) AS numOfMedia
		FROM	#UncopiedMediaAuxCopyFallenBehindAlert
		GROUP BY policyId, policyName, copyId, copyName) S
WHERE	S.copyId = T.archGrpCopyId
IF (OBJECT_ID('tempdb.dbo.#tblJobDataType') IS NOT NULL) DROP TABLE #tblJobDataType
IF (OBJECT_ID('tempdb.dbo.#tblJob') IS NOT NULL) DROP TABLE #tblJob
IF (OBJECT_ID('tempdb.dbo.#UncopiedMediaAuxCopyFallenBehindAlert') IS NOT NULL) DROP TABLE #UncopiedMediaAuxCopyFallenBehindAlert
IF (OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL) DROP TABLE #tmpJobSizeInfo
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archAuxCopyFallenBehindAlert')
	delete from GxQscripts where name = 'archAuxCopyFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archAuxCopyFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'archAuxCopyFallenBehindAlert'
GO

insert into GXDBVersions values(2, 'archAuxCopyFallenBehindAlert',  '00010020000000000000', 'archAuxCopyFallenBehindAlert', '00010020000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archBackupContentIndexInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archBackupContentIndexInfo.sp,v $ $Id: archBackupContentIndexInfo.sp,v 1.2 2007/03/27 23:37:11 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archBackupContentIndexInfo <<<'

IF EXISTS (select * from sysobjects where name='archBackupContentIndexInfo')
	drop procedure archBackupContentIndexInfo
IF EXISTS (select * from GxQscripts where name='archBackupContentIndexInfo')
	delete from GxQscripts where name = 'archBackupContentIndexInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupContentIndexInfo')
	delete from GXDBVersions where aliasname = 'archBackupContentIndexInfo'
GO
print '... Creating Procedure: archBackupContentIndexInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archBackupContentIndexInfo
  @i_jobId int,
  @i_commCellId int
AS
  DECLARE @o_CIFlags integer;
  DECLARE @o_CITime integer;
  DECLARE @o_cloudId integer;
  DECLARE @o_cloudName varchar(255);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SELECT	@o_CIFlags	= MAX(flags & 496),
		@o_CITime	= MAX(contentIndexTime),
		@o_cloudId	= MAX(cloudId)
FROM	archFile WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
	AND fileType = 1
IF	@o_cloudId IS NOT Null
	SELECT	@o_CIFlags, @o_CITime, @o_cloudId,
			(SELECT	stringVal FROM APP_ComponentProp WITH (NOLOCK)
			WHERE	componentType = 1
				AND propertyTypeId = 1
				AND componentId = @o_cloudId
				AND modified = 0)
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archBackupContentIndexInfo')
	delete from GxQscripts where name = 'archBackupContentIndexInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupContentIndexInfo')
	delete from GXDBVersions where aliasname = 'archBackupContentIndexInfo'
GO

insert into GXDBVersions values(2, 'archBackupContentIndexInfo',  '00010002000000000000', 'archBackupContentIndexInfo', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archBackupEncryptionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archBackupEncryptionInfo.sp,v $ $Id: archBackupEncryptionInfo.sp,v 1.17 2008/10/30 21:58:23 junlu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archBackupEncryptionInfo <<<'

IF EXISTS (select * from sysobjects where name='archBackupEncryptionInfo')
	drop procedure archBackupEncryptionInfo
IF EXISTS (select * from GxQscripts where name='archBackupEncryptionInfo')
	delete from GxQscripts where name = 'archBackupEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archBackupEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archBackupEncryptionInfo'
GO
print '... Creating Procedure: archBackupEncryptionInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archBackupEncryptionInfo
  @i_appId int,
  @i_archCopyId int
AS
  DECLARE @o_clientId int;
  DECLARE @o_appTypeId int;
  DECLARE @o_encryption int;
  DECLARE @o_restoreAccess int;
  DECLARE @o_drToolAccess int;
  DECLARE @o_subclientEnc int;
  DECLARE @o_encType int;
  DECLARE @o_encKeyLen int;
  DECLARE @o_SIDBStoreId int;
  DECLARE @o_RSAPubKey varchar(1024);
  DECLARE @o_RSAPriKeyBPF varchar(1024);
  DECLARE @o_RSAPriKeyUPF varchar(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@o_encryption	= 0
SET	@o_drToolAccess	= 0
SET	@o_subclientEnc	= 0
SET	@o_encType		= 0
SET	@o_encKeyLen	= 0
SET	@o_SIDBStoreId	= 0
SET	@o_RSAPubKey	= ''
SET	@o_RSAPriKeyBPF	= ''
SET	@o_RSAPriKeyUPF	= ''
DECLARE @l_subclientEnc		int
DECLARE @l_associatedAppId	int
SET	@l_subclientEnc		= -1
SET	@l_associatedAppId	= 0
SELECT	@o_clientId = clientId, @o_appTypeId = appTypeId
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @i_appId
SELECT	@o_SIDBStoreId = SIDBStoreId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_archCopyId
SELECT	@l_subclientEnc = CONVERT(int, attrVal)
FROM	APP_SubClientProp WITH (NOLOCK)
WHERE	ComponentNameId = @i_appId
	AND attrName = N'Encrypt: encryption' AND modified = 0
IF	@l_subclientEnc = -1
BEGIN
	SELECT	@l_associatedAppId = CONVERT(int, attrVal)
	FROM	APP_SubClientProp WITH (NOLOCK)
	WHERE	ComponentNameId = @i_appId AND attrName = N'Associated subclient Policy' AND modified = 0
	IF	@l_associatedAppId > 0
		SELECT	@l_subclientEnc = CONVERT(int, attrVal)
		FROM	APP_SubClientProp WITH (NOLOCK)
		WHERE	ComponentNameId = @l_associatedAppId
			AND attrName = N'Encrypt: encryption' AND modified = 0
END
IF	@l_subclientEnc > 0
	SET @o_subclientEnc = @l_subclientEnc
DECLARE	@tblClientEnc TABLE (encryption int, restoreAccess int, drToolAccess int, dataEncType int, dataKeyLen int,
		rsaPubKey varchar(1024), rsaPriKeyUPF varchar(1024), rsaPriKeyBPF varchar(1024))
INSERT	INTO @tblClientEnc
SELECT	(case when attrName = N'Encrypt: encryption'	then CONVERT(int, attrVal) else 0 end),
		(case when attrName = N'Encrypt: restoreAccess'	then CONVERT(int, attrVal) else 0 end),
		(case when attrName = N'Encrypt: drTool