

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simValidateVMClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  simValidateVMClients
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: Validate existence of VM UUID in the CS db and populated the client id for it in response
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Praveen Kuttappan  Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simValidateVMClients')
BEGIN
	print '>>> Drop Stored Procedure: simValidateVMClients <<<'
	drop procedure simValidateVMClients
END
IF EXISTS (select * from GxQscripts where name='simValidateVMClients')
	delete from GxQscripts where name = 'simValidateVMClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simValidateVMClients')
	delete from GXDBVersions where aliasname = 'simValidateVMClients'
GO
print '... Creating Procedure: simValidateVMClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simValidateVMClients
  @input xml
AS
  DECLARE @output xml
SET NOCOUNT ON
BEGIN
	IF object_id('tempdb.dbo.#InputVMUUIDToVerify') IS NOT null DROP TABLE #InputVMUUIDToVerify
	create table #InputVMUUIDToVerify(
					id						int IDENTITY(1,1) NOT NULL,
					vmguidinReq				nvarchar(255),
					displayName				nvarchar(255),
					appClientId				int,
					vmguid					nvarchar(255),
					vmDeletiontime			int
	)
	declare @inxml xml
	DECLARE @virtualServerInstanceId int
	DECLARE @vmNameMatch int = 0
	IF @input.exist('App_GetVMClientInfoFromUUID' ) = 1
	BEGIN
		 SET @inxml=ISNULL( (SELECT  CAST(T.c.value('@inXml', 'varchar(MAX)') as XML) FROM   @input.nodes('App_GetVMClientInfoFromUUID') T(c)), '')
	END
	ELSE
	BEGIN
		SET @inxml = @input
		SET @vmNameMatch = 1
	END
	SET @virtualServerInstanceId = @inxml.value('(/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps/@vmInstanceId)[1]','int')
	-- Populate the VM guid from the XML into temp table
	INSERT INTO #InputVMUUIDToVerify
	SELECT SUBSTRING (T.cc.value('clientProps[1]/@vmguid', 'nvarchar(255)'), 0, 255),
	 SUBSTRING (T.cc.value('client[1]/clientEntity[1]/@displayName', 'nvarchar(255)'), 0, 255),0,'',0
		FROM @inxml.nodes('/CVInstallManager_ClientSetup/clientComposition/clientInfo') T(cc)
	-- Populate all VM UUID matching input form app_clientprop
	IF object_id('tempdb.dbo.#VMUUIDToClientId') IS NOT null DROP TABLE #VMUUIDToClientId
    create table #VMUUIDToClientId(
                    ClientId             int,
                    uuid                 nvarchar(255) ,
					displayName				nvarchar(255)
    )
	insert into #VMUUIDToClientId SELECT distinct componentNameId, attrval,displayName FROM APP_ClientProp clProp WITH (NOLOCK)
	INNER JOIN App_Client cl ON cl.id=componentNameId
	WHERE attrName = 'Virtual Machine Instance UUID'
	-- delete the duplicate vmguid from table #VMUUIDToClientId.
	-- There are certain cases during client creation where duplicate guids will be there in app_clientprop table. (ie ) 2 different client id for same Vm guids.
	delete from #VMUUIDToClientId where uuid in (select uuid from #VMUUIDToClientId group by uuid having count(*) > 1)
	-- Bulk update the client id from appclient_prop table into temp input table
	update #InputVMUUIDToVerify set appClientId = ISNULL((select ClientId from #VMUUIDToClientId where uuid = #InputVMUUIDToVerify.vmguidinReq),0), vmguid = vmguidinReq
	IF @vmNameMatch = 1
	BEGIN
		update Input set
			Input.appClientId = clProp.componentNameId,
			Input.vmguid = clProp1.attrval,
			Input.vmDeletiontime = ISNULL(CAST(clProp3.attrVal As INT),0)
			from #InputVMUUIDToVerify Input
			INNER JOIN APP_ClientProp clProp WITH (NOLOCK) ON clProp.attrName = 'Virtual Machine Name' AND clProp.modified = 0 AND clProp.attrVal=Input.displayName
			INNER JOIN APP_ClientProp clProp1 WITH (NOLOCK) ON clProp1.componentNameId=clProp.componentNameId and clProp1.attrName = 'Virtual Machine Instance UUID' AND clProp1.modified = 0
			INNER JOIN APP_ClientProp clProp2 WITH (NOLOCK) ON clProp2.componentNameId=clProp.componentNameId and clProp2.attrName = 'Virtual Machine Instance ID' AND clProp2.modified = 0 AND ISNULL(CAST(clProp2.attrVal As INT),0)=@virtualServerInstanceId
			LEFT JOIN APP_ClientProp clProp3 WITH (NOLOCK) ON clProp3.componentNameId=clProp.componentNameId and clProp3.attrName = 'Virtual Machine Deletion Time' AND clProp3.modified = 0
		WHERE appClientId=0
	END
	SELECT @output = (
	(select
		(select
			(select
				( SELECT isnull(T1.appClientId,0) as  '@clientId'
				FOR XML PATH('clientEntity'),TYPE)
			FOR XML PATH('client'),TYPE),
			(SELECT T1.vmguid as '@vmguid', T1.vmguidinReq as '@vmguidinReq',T1.vmDeletiontime as '@vmDeletionTime'
				FOR XML PATH('clientProps'),TYPE)
		FOR XML PATH('clientInfo'),TYPE)
	from #InputVMUUIDToVerify T1
	FOR XML PATH('clientComposition'),TYPE, Root ('CVInstallManager_ClientSetup')))
	IF object_id('tempdb.dbo.#InputVMUUIDToVerify') IS NOT null DROP TABLE #InputVMUUIDToVerify
	IF object_id('tempdb.dbo.#VMUUIDToClientId') IS NOT null DROP TABLE #VMUUIDToClientId
	SELECT @output
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simValidateVMClients')
	delete from GxQscripts where name = 'simValidateVMClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simValidateVMClients')
	delete from GXDBVersions where aliasname = 'simValidateVMClients'
GO

insert into GXDBVersions values(2, 'simValidateVMClients',  '00000000000000000000', 'simValidateVMClients', '00000000000000000000')
GO

