

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simValidLicenseCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/28/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simValidLicenseCheck.sp,v $ $Id: simValidLicenseCheck.sp,v 1.22.2.14 2019/05/31 19:48:29 leiwang Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simValidLicenseCheck')
BEGIN
	print '>>> Drop Stored Procedure: simValidLicenseCheck <<<'
	drop procedure simValidLicenseCheck
END
IF EXISTS (select * from GxQscripts where name='simValidLicenseCheck')
	delete from GxQscripts where name = 'simValidLicenseCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simValidLicenseCheck')
	delete from GXDBVersions where aliasname = 'simValidLicenseCheck'
GO
print '... Creating Procedure: simValidLicenseCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simValidLicenseCheck
  @i_clientId integer,
  @i_appType integer,
  @i_licType integer
AS
  DECLARE @o_isValid integer
  DECLARE @o_expTime integer
  DECLARE @o_errorStr varchar(MAX)
	DECLARE	@o_expTimeBig	bigint
	DECLARE @encLicense		varchar(8000) = ''
	DECLARE @localeIPs		nvarchar(MAX)
	DECLARE @sLicEncID		varchar(1024)
	DECLARE @ccIdDec		varchar(1024)
	DECLARE @bIsValid		int
	DECLARE @ccIdInCCTbl		int
	DECLARE @machineId		int
	DECLARE @DRMachineId		int
	DECLARE @isEval			int
	DECLARE @isStaicIP 		int
	DECLARE @leasedCSExpTime	int
	SET @o_isValid = 0
	SET @o_expTimeBig = 0
	SET @o_expTime = 0
	SET @o_errorStr = ''
	-- If license is -1 it is not in use
	-- Or license is 0 and there is no entry in simapptypelictypemap table the apptype does not require a license
	-- In both cases return success
	IF @i_licType = -1 OR @i_licType = 0 AND NOT EXISTS (SELECT * FROM simAppTypeLicTypeMap WITH (NOLOCK) WHERE appTypeId = @i_appType)
	BEGIN
		set @o_isValid = 1
		set @o_expTime = 0
		goto SP_EXIT
	END
	-- Skip license check for index server during backup job
	-- but do not skip license check during client deletion
IF EXISTS (SELECT TOP 1 1 FROM APP_Clientprop WITH (NOLOCK) WHERE componentNameId = @i_clientId AND attrName = 'Index Server Type' and attrval = 15)
	AND @i_licType = 0
	BEGIN
		set @o_isValid = 1
		set @o_expTime = 0
		goto SP_EXIT
	END
	-- check CS License
	-- 1) validate CC ID
	SELECT @ccIdInCCTbl = number FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	SELECT @sLicEncID = value FROM GxGlobalParam WITH (NOLOCK) WHERE name = 'CSLicenseId'
	IF LEN(@sLicEncID) > 0
		EXEC miscProc2 @sLicEncID, @ccIdDec OUTPUT
	ELSE
		SELECT @ccIdDec = commcellId FROM LicCSL WITH (NOLOCK) WHERE id = (select max(id) from LicCSL WITH (NOLOCK))
	IF @ccIdInCCTbl <> CAST(@ccIdDec as INT)
	BEGIN
		SET @o_errorStr = 'Mismatch detected between Commcell ID: ' + @ccIdDec + ' in License Key and commserv database ' + cast(@ccIdInCCTbl as varchar(64)) + '. EncryptedField: ' + @sLicEncID
		goto SP_EXIT
	END
	-- 2) validate IP
	SELECT @encLicense = EncLicKey
	FROM	LicCsl WITH (NOLOCK)
	WHERE	id = (SELECT MAX(id) FROM LicCsl WITH (NOLOCK))
	EXEC dbo.xp_getCSInfoByLicKey @encLicense, @isEval OUTPUT, @isStaicIP OUTPUT, @machineId OUTPUT, @DRMachineId OUTPUT, @leasedCSExpTime OUTPUT
	IF @isEval = 0
	BEGIN
		IF @leasedCSExpTime > 1155623994 AND @leasedCSExpTime < dbo.GetUnixTime(getUTCDate())
		BEGIN
			SET @o_errorStr = 'The leased CS license was expired on ' + cast(dbo.GetDateTime(@leasedCSExpTime) as varchar(64))
			goto SP_EXIT
		END
		/*IF @isStaicIP > 0
		BEGIN
			EXEC GetLocalIPManaged @localeIPs OUTPUT, 0
			IF @machineId NOT IN (SELECT _ID from SplitIDs(@localeIPs)) AND @DRMachineId NOT IN (SELECT _ID from SplitIDs(@localeIPs))
			BEGIN
				SET @o_errorStr = 'Invalid CS IP: local IP is [' + @localeIPs + '] while the license key has [' + cast(@machineId as varchar(64)) + '] and DR [' + cast(@DRMachineId as varchar(64)) + ']'
				goto SP_EXIT
			END
		END*/
	END
	DECLARE @nIpValidStatusAttrVal varchar(2048)
	DECLARE @isIPStatusValid varchar(512) =''
	SELECT @nIpValidStatusAttrVal = attrVal FROM LicUsageBasedConfig WITH (readuncommitted) WHERE attrName = 'IpValidStatus' -- SZ_IP_VALID_STAUTS
	-- If row is not present than treat it as invalid scenario.
	IF @nIpValidStatusAttrVal IS NOT NULL
	BEGIN
		EXEC miscProc2 @nIpValidStatusAttrVal, @isIPStatusValid OUTPUT
	END
	IF @isIPStatusValid = ''
	BEGIN
		SET @o_isValid = -1
		SET @o_errorStr = 'IP address validation failed'
		GOTO SP_EXIT
	END
	ELSE
	BEGIN
		DECLARE @CsIpList TABLE (t_id int,t_val VARCHAR(512), t_ipstring varchar(512))
		INSERT INTO @CsIpList
		SELECT Id,Data,'' FROM dbo.SplitString(@isIPStatusValid,':-')
		IF '0'=(SELECT t_val FROM @CsIpList WHERE t_id = 1)
		BEGIN
			DECLARE @MachineIPAddress VARCHAR(1024)
			DECLARE @CSIPAddress VARCHAR(1024)
			UPDATE @CsIpList SET t_ipstring = SUBSTRING(t_val,2,LEN(t_val)) WHERE  t_id > 1
			SELECT @CSIPAddress = t_ipstring FROM @CsIpList WHERE t_id = 2
			SELECT @MachineIPAddress = t_ipstring FROM @CsIpList WHERE t_id = 3
			SET @o_isValid = -1
			SET @o_errorStr = 'Commserver IP address [' +@CSIPAddress+ '] doesn''t match with the system''s IP address [' + @MachineIPAddress +']'
			GOTO SP_EXIT
		END
	END
DECLARE @isACVCheckValid INT = 0
DECLARE @licInheritedType INT = 0
DECLARe @bIsLicInherited INT = 0
SELECT @licInheritedType = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'InheritedLicType'--SZ_INHERITED_LI_TYPE
IF @licInheritedType = 1 OR @licInheritedType = (2|1)
	SET @bIsLicInherited = 1
IF @bIsLicInherited = 1
BEGIN
		IF EXISTS(select * FROM RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType in (100027,100032,100033)) AND
		EXISTS(select * from RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType IN (100002, 100004, 100005, 100006, 100018, 100019))
			SELECT @isACVCheckValid = 1
END
ELSE
BEGIN
	IF EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId in (100027,100032,100033)) AND
	EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100002, 100004, 100005, 100006, 100018, 100019))
		SELECT @isACVCheckValid = 1
END
	-- check App class virtual license
	IF @isACVCheckValid = 1 AND
		(@i_licType = 3 OR @i_licType = 0 AND @i_appType IN (SELECT appTypeId from simAppTypeLicTypeMap where simlicAppType = 3))
	BEGIN
		EXEC LicGetVMAppcalss1 '', 0, @i_clientId, @i_appType, 0, 0, @o_isValid OUTPUT
		IF @o_isValid > 0
		BEGIN
			SET @o_isValid = 1
			SET @o_expTime = 0
			goto SP_EXIT
		END
	END
	-- check client/agent license
	SET @encLicense = ''
	IF @i_clientId = 0	SET @i_clientId = 2
	SELECT TOP 1 @encLicense = EncryptedField
	FROM	LicUsage WITH (NOLOCK)
	WHERE	CId = @i_clientId AND @i_appType IN (0, appType) AND @i_licType IN (0, LicType) AND opType = 'Install'
	ORDER BY id DESC
	IF @encLicense <> ''
	BEGIN
		--EXEC dbo.xp_license_isvalid @encLicense, @o_isValid OUTPUT, @o_expTime OUTPUT
		SET @o_isValid = 0
		SET @o_expTimeBig = 0
		SET @o_expTime = 0
		SET @o_errorStr = ''
		EXEC isLicenseValidManaged @encLicense, @o_expTimeBig OUTPUT, @o_isValid OUTPUT, @o_errorStr OUTPUT
		SET @o_expTime = CAST(@o_expTimeBig as int)
		IF @o_isValid = 0
			SET @o_errorStr = 'xp_license_isvalid check failed'
	END
	ELSE
	BEGIN
		SET @o_errorStr = 'The license is not consumed by client/agent'
		goto SP_EXIT
	END
SP_EXIT:
	IF @o_isValid > 0
		SET @o_errorStr = ''
	IF OBJECT_ID('tempdb..#tempResSet') IS NOT NULL --For AppCheckIsValidLicense SP
	BEGIN
		TRUNCATE TABLE #tempResSet
		INSERT INTO #tempResSet SELECT @o_isValid, @o_expTime, @o_errorStr
	END
	ELSE
		SELECT @o_isValid, @o_expTime, @o_errorStr
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'simValidLicenseCheck')
	delete from GxQscripts where name = 'simValidLicenseCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simValidLicenseCheck')
	delete from GXDBVersions where aliasname = 'simValidLicenseCheck'
GO

insert into GXDBVersions values(2, 'simValidLicenseCheck',  '00010022000200140000', 'simValidLicenseCheck', '00010022000200140000')
GO

