

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simUpdateUPVersion.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simUpdateUPVersion.sp,v $ $Id: simUpdateUPVersion.sp,v 1.1.2.10 2020/12/19 05:07:11 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  simUpdateUPVersion()
--  |
--  | Description: Insert into PatchUPVersion for CumulativeUpdatePack info
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simUpdateUPVersion')
BEGIN
	print '>>> Drop Stored Procedure: simUpdateUPVersion <<<'
	drop procedure simUpdateUPVersion
END
IF EXISTS (select * from GxQscripts where name='simUpdateUPVersion')
	delete from GxQscripts where name = 'simUpdateUPVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdateUPVersion')
	delete from GXDBVersions where aliasname = 'simUpdateUPVersion'
GO
print '... Creating Procedure: simUpdateUPVersion'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simUpdateUPVersion
  @inXML XML,
  @inUseNewConfig INT
AS
  DECLARE @nRowsUpdated INT 
SET NOCOUNT ON
DECLARE @relNum INT = 0
DECLARE @buildNum INT = 0
DECLARE @SPMajor INT = 0
DECLARE @SPMinor INT = 0
DECLARE @TransactionId INT = 0
DECLARE @RevisionId INT = 0
DECLARE @Timestamp INT = 0
DECLARE @SPVersionIdTbl TABLE(id INT)
DECLARE @SPVersionId INT = 0
DECLARE @tmpCUNum TABLE(num INT, transId INT, friendlyName VARCHAR(256), ts BIGINT, nBTDelay INT, nGDDelay INT)
DECLARE @pendingCUNum TABLE(num INT, transId INT, friendlyName VARCHAR(256), ts BIGINT, nBTDelay INT, nGDDelay INT)
DECLARE @localVisibilityLevel INT = 0
SELECT @localVisibilityLevel = value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Patch Visibility Level' AND modified = 0
SELECT @relNum = x.ref.value('(@ReleaseId)[1]', 'INT'),
	   @buildNum = x.ref.value('(@Build)[1]', 'INT'),
	   @SPMajor = x.ref.value('(@Major)[1]', 'INT'),
	   @SPMinor = x.ref.value('(@Minor)[1]', 'INT'),
	   @TransactionId = x.ref.value('(@TransactionId)[1]', 'INT'),
	   @RevisionId = x.ref.value('(@RevisionId)[1]', 'INT')
	FROM @inXML.nodes('/UpdatePatches_AvailableCumulativeUpdatePacks/AvailableCUs/SPVersion') AS x(ref)
INSERT INTO @tmpCUNum(num, transId, friendlyName, ts, nBTDelay, nGDDelay)
SELECT x.ref.value('(@Number)[1]', 'INT'),
	x.ref.value('(@TransactionId)[1]','INT'),
	x.ref.value('(@FriendlyName)[1]','VARCHAR(256)'),
	x.ref.value('(@Timestamp)[1]','BIGINT'),
	ISNULL(x.ref.value('(@BootstrapperDelayDays)[1]', 'INT'), 0),
	ISNULL(x.ref.value('(@GUIDownloadDelayDays)[1]', 'INT'), 0)
FROM @inXML.nodes('/UpdatePatches_AvailableCumulativeUpdatePacks/AvailableCUs/CUPackEntries') AS x(ref)
WHERE @inUseNewConfig = 0 OR (ISNULL(x.ref.value('(@VisibilityFlag)[1]', 'INT'), 0) = 0)
	OR ((ISNULL(x.ref.value('(@VisibilityFlag)[1]', 'INT'), 0) & @localVisibilityLevel) <> 0)
-- Get/insert the SPVersionId
INSERT @SPVersionIdTbl
EXEC simGetSPVersionId @relNum, @buildNum, @spMajor, @SPMinor, @TransactionId, @RevisionId, '', 0, 0
SELECT TOP 1 @SPVersionId = id FROM @SPVersionIdTbl
IF @SPVersionId > 0 AND @relNum > 0 AND @buildNum > 0
BEGIN
	-- 1. mark all CU entries belongs to this Release, Build, SPMajor & SPMinor invalid
	UPDATE PatchUPVersion SET bIsAvailableForDownload = 0, bShowInGui = 0
		FROM PatchSPVersion psp WITH(NOLOCK) WHERE SPVersionId = psp.id AND psp.Release = @relNum AND psp.Build = @buildNum AND psp.SPMajor = @SPMajor AND psp.SPMinor = @SPMinor
	INSERT INTO @pendingCUNum(num, transId, friendlyName, ts, nBTDelay, nGDDelay)
	SELECT P.num, P.transId, P.friendlyName, P.ts, P.nBTDelay, P.nGDDelay
		FROM @tmpCUNum P LEFT JOIN PatchUPVersion U WITH(NOLOCK) ON P.num = U.UPNumber AND P.transId = U.MaxTransactionId
	    WHERE U.UPNumber IS NULL OR (NOT EXISTS
			(SELECT 1 FROM PatchSPVersion S1 WITH(NOLOCK) JOIN PatchSPVersion S2 WITH(NOLOCK)
				ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor AND S1.SPMinor = S2.SPMinor AND S1.TransactionId = S2.TransactionId
				WHERE S1.Id = @SPVersionId AND S2.Id = U.SPVersionId))
	-- 2. Only insert those which does not exist and mark them valid
	INSERT INTO PatchUPVersion
	SELECT @SPVersionId, num, transId, 1, 1, friendlyName, ts, nBTDelay, nGDDelay
	FROM @pendingCUNum
	WHERE NOT EXISTS (SELECT UPVersionID FROM PatchUPVersion WHERE SPVersionId = @SPVersionId AND UPNumber = num)
	-- Overwrite the invalid transaction Id using the input xml's value
	UPDATE PatchUPVersion
	SET MaxTransactionId = tcn.transId
		FROM @tmpCUNum tcn WHERE tcn.num = UPNumber AND SPVersionId = @SPVersionId AND (MaxTransactionId = 0 OR MaxTransactionId = @TransactionId)
	-- 3. Update the timestamp & delay days field always
	UPDATE PatchUPVersion SET Timestamp = tcn.ts, nBootstrapperDelayDays = tcn.nBTDelay, nGUIDownloadDelayDays = tcn.nGDDelay
	FROM @tmpCUNum tcn WHERE UPNumber = tcn.num AND MaxTransactionId = tcn.transId
	-- 3. Mark all available entries valid
	UPDATE PatchUPVersion SET bIsAvailableForDownload = 1, bShowInGui = 1
		FROM @tmpCUNum pcn WHERE pcn.num = UPNumber AND pcn.transId = MaxTransactionId AND SPVersionId = @SPVersionId
END
SELECT @@rowcount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simUpdateUPVersion')
	delete from GxQscripts where name = 'simUpdateUPVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdateUPVersion')
	delete from GXDBVersions where aliasname = 'simUpdateUPVersion'
GO

insert into GXDBVersions values(2, 'simUpdateUPVersion',  '00010001000200100000', 'simUpdateUPVersion', '00010001000200100000')
GO

