

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simUpdateSharedInstallLocation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simUpdateSharedInstallLocation.sp,v $ $Id: simUpdateSharedInstallLocation.sp,v 1.1.2.5 2018/03/27 08:42:59 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simUpdateSharedInstallLocation
--  |
--  | Description:	This stored procedure updates shared install location for UNIX clients
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simUpdateSharedInstallLocation <<<'

IF EXISTS (select * from sysobjects where name='simUpdateSharedInstallLocation')
	drop procedure simUpdateSharedInstallLocation
IF EXISTS (select * from GxQscripts where name='simUpdateSharedInstallLocation')
	delete from GxQscripts where name = 'simUpdateSharedInstallLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdateSharedInstallLocation')
	delete from GXDBVersions where aliasname = 'simUpdateSharedInstallLocation'
GO
print '... Creating Procedure: simUpdateSharedInstallLocation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simUpdateSharedInstallLocation
  @i_clientID INTEGER,
  @i_isServer INTEGER,
  @i_mountPath VARCHAR(MAX)
AS
-- Output variables of the stored procedure
  DECLARE @o_error INTEGER
SET NOCOUNT ON
IF @i_isServer > 0
BEGIN
IF NOT EXISTS (SELECT id FROM APP_ClientProp WITH(NOLOCK) WHERE modified = 0 AND componentNameID = @i_clientID AND attrName = 'Hosted Mount Path' AND attrVal = @i_mountPath)
		INSERT INTO APP_CLientProp
SELECT @i_clientID, 'Hosted Mount Path', 1, @i_mountPath, dbo.GetUnixTime(GETUTCDATE()), 0, 0
END
IF EXISTS (SELECT id FROM APP_ClientProp WITH(NOLOCK) WHERE modified = 0 AND componentNameID = @i_clientID AND attrName = 'Current Mount Path')
UPDATE APP_CLientProp SET attrVal = @i_mountPath WHERE modified = 0 AND componentNameID = @i_clientID AND attrName = 'Current Mount Path'
ELSE
INSERT INTO APP_CLientProp SELECT @i_clientID, 'Current Mount Path', 1, @i_mountPath, dbo.GetUnixTime(GETUTCDATE()), 0, 0
SELECT @@ERROR
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simUpdateSharedInstallLocation')
	delete from GxQscripts where name = 'simUpdateSharedInstallLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdateSharedInstallLocation')
	delete from GXDBVersions where aliasname = 'simUpdateSharedInstallLocation'
GO

insert into GXDBVersions values(2, 'simUpdateSharedInstallLocation',  '00010001000200050000', 'simUpdateSharedInstallLocation', '00010001000200050000')
GO

