

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simUpdateAssociatedMiscDBEntriesForReleaseLicOper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simUpdateAssociatedMiscDBEntriesForReleaseLicOper.sp,v $ $Id: simUpdateAssociatedMiscDBEntriesForReleaseLicOper.sp,v 1.4.60.2 2018/03/27 08:56:47 jiechen Exp $";
--
--  +========================================================================+
--  |	Procedure:  simUpdateAssociatedMiscDBEntriesForReleaseLicOper
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |	1.1       hmishra  Updates the associated misc tables (apart from idaname/clientprop table)
--  |             for given license type at the time of Release license operation.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simUpdateAssociatedMiscDBEntriesForReleaseLicOper <<<'

IF EXISTS (select * from sysobjects where name='simUpdateAssociatedMiscDBEntriesForReleaseLicOper')
	drop procedure simUpdateAssociatedMiscDBEntriesForReleaseLicOper
IF EXISTS (select * from GxQscripts where name='simUpdateAssociatedMiscDBEntriesForReleaseLicOper')
	delete from GxQscripts where name = 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdateAssociatedMiscDBEntriesForReleaseLicOper')
	delete from GXDBVersions where aliasname = 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper'
GO
print '... Creating Procedure: simUpdateAssociatedMiscDBEntriesForReleaseLicOper'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simUpdateAssociatedMiscDBEntriesForReleaseLicOper
  @i_clientId integer,
  @i_apptypeId integer,
  @i_lictypeId integer
AS
  DECLARE @o_errorCode integer
  DECLARE @o_infoString nvarchar(255)
SET NOCOUNT ON
BEGIN TRY
SET @o_infoString	=  ''
SET @o_errorCode    =  0
-- case (1) => OCS
IF @i_lictypeId = 3
BEGIN
	DECLARE	@iDANameID integer
	SET @iDANameID = (select TOP 1 ID from APP_IDANAME where clientid = @i_clientId and
apptypeId in (select distinct apptype  from simPackageMap where simPackageId = 702)
						order by status, modified desc)
	-- Updating idaProp table.
	Update app_idaProp Set attrVal = 0 where componentNameId = @iDANameID AND attrName = 'Enable OCS' and modified = 0
END
ELSE IF @i_lictypeId = 63
BEGIN
	UPDATE	APP_IDAProp
	SET	attrVal = '0'
	WHERE	attrName = 'Enable Archive' AND modified = 0 AND componentNameId IN
(select id from APP_IDAName where clientId = @i_clientId and @i_apptypeId IN (66, appTypeId)
			and appTypeId in (select type from APP_iDAType where displayname = 'File System') )
	UPDATE	APP_ClientProp
	SET	attrVal = '0'
WHERE	componentNameId = @i_clientId AND attrName = dbo.GetLicensePropName(66) AND modified = 0 AND
		EXISTS (select * from APP_iDAType where displayname = 'File System' and type = @i_apptypeId)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @o_errorCode = ERROR_NUMBER()
		set @o_infoString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message ['
		+ERROR_MESSAGE() + '].'
END CATCH
SELECT @o_errorCode, @o_infoString
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper')
	delete from GxQscripts where name = 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdateAssociatedMiscDBEntriesForReleaseLicOper')
	delete from GXDBVersions where aliasname = 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper'
GO

insert into GXDBVersions values(2, 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper',  '00010004006000020000', 'simUpdateAssociatedMiscDBEntriesForReleaseLicOper', '00010004006000020000')
GO

