

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simUpdNASClientsNDelProxyProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simUpdNASClientsNDelProxyProp.sp,v $ $Id: simUpdNASClientsNDelProxyProp.sp,v 1.3.294.1 2018/03/22 01:37:16 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simUpdNASClientsNDelProxyProp
--  |
--  | Description:	During the MA reinstalls or upgrades, delete the proxy host
--	|				property in APP_Client prop table and also update the release id
--	|				for all NAS clients pointing to that MA to current release
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        M J Venkatesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simUpdNASClientsNDelProxyProp <<<'

IF EXISTS (select * from sysobjects where name='simUpdNASClientsNDelProxyProp')
	drop procedure simUpdNASClientsNDelProxyProp
IF EXISTS (select * from GxQscripts where name='simUpdNASClientsNDelProxyProp')
	delete from GxQscripts where name = 'simUpdNASClientsNDelProxyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdNASClientsNDelProxyProp')
	delete from GXDBVersions where aliasname = 'simUpdNASClientsNDelProxyProp'
GO
print '... Creating Procedure: simUpdNASClientsNDelProxyProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simUpdNASClientsNDelProxyProp
  @maClientId INTEGER,
  @curRelId INTEGER,
  @buildIdStr VARCHAR(32)
AS
  DECLARE @retVal INTEGER;
	SET NOCOUNT ON
	DECLARE		@nasClientId		integer
	DECLARE		@maHostName			nvarchar(255)
	DECLARE		@NAS_APPTYPE		integer
	SET @NAS_APPTYPE = 13
	SET @maHostName = ( SELECT net_hostname FROM APP_Client WHERE id = @maClientId )
	DECLARE GetNASClientList CURSOR FOR
		SELECT componentnameid FROM APP_ClientProp WHERE attrName = N'proxy host name' AND attrVal = @maHostName
	OPEN GetNASClientList
	FETCH GetNASClientList INTO @nasClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		UPDATE patchInfo SET ReleaseId = @curRelId, BuildIdString = @buildIdStr WHERE clientId = @nasClientId AND AppTypeId = @NAS_APPTYPE
		DELETE FROM APP_ClientProp WHERE attrName = N'proxy host name' AND attrVal = @maHostName AND componentnameid = @nasClientId
		FETCH GetNASClientList INTO @nasClientId
	END
	CLOSE GetNASClientList
	DEALLOCATE GetNASClientList
   SET @retVal = @@ERROR
   SELECT @retVal
   RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'simUpdNASClientsNDelProxyProp')
	delete from GxQscripts where name = 'simUpdNASClientsNDelProxyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUpdNASClientsNDelProxyProp')
	delete from GXDBVersions where aliasname = 'simUpdNASClientsNDelProxyProp'
GO

insert into GXDBVersions values(2, 'simUpdNASClientsNDelProxyProp',  '00010003029400010000', 'simUpdNASClientsNDelProxyProp', '00010003029400010000')
GO

