

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simUnInstallPkgDependencyCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simUnInstallPkgDependencyCheck.sp,v $ $Id: simUnInstallPkgDependencyCheck.sp,v 1.4.276.2 2019/02/25 16:17:42 kvankadaru Exp $";
--
--  +========================================================================+
--  |      Name	 :  simUnInstallPkgDependencyCheck()
--  |
--  | Description:  It checks whether a given package can be uninstalled on the given client based on
--	|				Package Dependency criteria.
--	|
--  |	   Input :  ClientID/PackageID/ReleaseID
--	|
--  |      Output:  It returns o_unInstallAllowed as TRUE if the Package can be uninstalled from the given client.
--	|				Else it returns FALSE and return the names of (o_dependentPackages) of the packages
--	|				which caused this uninstallation failure.
--	|
--  |		 Note:  Currently we are not using ReleaseID. It may be used later.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  SIM Package UnInstall Dependency criteria
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simUnInstallPkgDependencyCheck')
BEGIN
	print '>>> Drop Stored Procedure: simUnInstallPkgDependencyCheck <<<'
	drop procedure simUnInstallPkgDependencyCheck
END
IF EXISTS (select * from GxQscripts where name='simUnInstallPkgDependencyCheck')
	delete from GxQscripts where name = 'simUnInstallPkgDependencyCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUnInstallPkgDependencyCheck')
	delete from GXDBVersions where aliasname = 'simUnInstallPkgDependencyCheck'
GO
print '... Creating Procedure: simUnInstallPkgDependencyCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simUnInstallPkgDependencyCheck
  @i_clientID integer,
  @i_packageID integer,
  @i_releaseID integer
AS
  DECLARE @o_unInstallAllowed integer
  DECLARE @o_dependentPackages nvarchar(MAX)
SET NOCOUNT ON
SET @o_unInstallAllowed = 1
SET @o_dependentPackages = ''
DECLARE  @DepdendentPackageIDs TABLE(t_DepdendentPackageID INT, t_DependentPackageName varchar(1024), t_bInstalled int, t_releaseId int, t_configstatus int)
-- Get the list of installed packages
INSERT INTO @DepdendentPackageIDs
EXEC simGetInstalledPackages @i_clientID
-- Filtering un releated packages.
DELETE FROM @DepdendentPackageIDs
WHERE t_DepdendentPackageID NOT IN (select simDependentPackageId from simPackageDependency where simpackageId = @i_packageID AND dependencyType = 1)
IF EXISTS(select * from @DepdendentPackageIDs)
BEGIN
	SET @o_unInstallAllowed = 0
	select
	@o_dependentPackages = @o_dependentPackages + t_DependentPackageName +  ','
	from @DepdendentPackageIDs
END
select @o_unInstallAllowed, @o_dependentPackages
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simUnInstallPkgDependencyCheck')
	delete from GxQscripts where name = 'simUnInstallPkgDependencyCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUnInstallPkgDependencyCheck')
	delete from GXDBVersions where aliasname = 'simUnInstallPkgDependencyCheck'
GO

insert into GXDBVersions values(2, 'simUnInstallPkgDependencyCheck',  '00010004027600020000', 'simUnInstallPkgDependencyCheck', '00010004027600020000')
GO

