

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simUnInstallDependencyCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simUnInstallDependencyCheck.sp,v $ $Id: simUnInstallDependencyCheck.sp,v 1.5.290.1 2018/03/22 01:47:35 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simUnInstallDependencyCheck()
--  |
--  | Description:  It checks whether a given apptype can be uninstalled on the given client or not
--	|
--  |	   Input :  ClientID/Apptype/ReleaseID/IsVirtual
--	|
--  |      Output:  It returns o_unInstallAllowed as TRUE if the apptype can be uninstalled on the given client.
--	|				Else it returns FALSE and return the ID (in o_groupID) and Name (in o_groupName) of the group
--	|				which caused this uninstallation failure.
--	|
--  |		 Note:  Currently we are not using ReleaseID/IsVirtual. It may be used in the future releases.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  SIM Apptype UnInstall Dependency criteria
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simUnInstallDependencyCheck <<<'

IF EXISTS (select * from sysobjects where name='simUnInstallDependencyCheck')
	drop procedure simUnInstallDependencyCheck
IF EXISTS (select * from GxQscripts where name='simUnInstallDependencyCheck')
	delete from GxQscripts where name = 'simUnInstallDependencyCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUnInstallDependencyCheck')
	delete from GXDBVersions where aliasname = 'simUnInstallDependencyCheck'
GO
print '... Creating Procedure: simUnInstallDependencyCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simUnInstallDependencyCheck
  @i_clientID integer,
  @i_appTypeID integer,
  @i_isVirtual integer,
  @i_releaseID integer
AS
  DECLARE @o_unInstallAllowed integer
  DECLARE @o_groupID integer
  DECLARE @o_groupName nvarchar(255)
SET NOCOUNT ON
DECLARE @appGroupID INTEGER
SET @o_unInstallAllowed = 1
SET @o_groupID = 0
DECLARE Groups CURSOR
FOR
select GroupID from simApptypeGroupIDMap where ApptypeID=@i_appTypeID
OPEN Groups
FETCH NEXT FROM Groups INTO @appGroupID
WHILE @@FETCH_STATUS = 0
BEGIN
		IF EXISTS(select S.ApptypeID from simApptypeGroupIDMap S, Licusage L where S.GroupID=@appGroupID AND
		S.ApptypeID <> @i_appTypeID AND L.apptype = S.ApptypeID AND L.cid = @i_clientID AND L.optype = 'Install')
		BEGIN
			-- There are no issues with this group. Checking the next group.
			FETCH NEXT FROM Groups INTO @appGroupID
			CONTINUE
		END
		ELSE
		BEGIN
			IF EXISTS(select S2.ApptypeID from simAppTypeDependency S2, Licusage L2 where S2.GroupID = @appGroupID AND
			L2.apptype = S2.ApptypeID AND L2.cid = @i_clientID AND L2.optype = 'Install')
			BEGIN
				-- There are issues with this group.Failing the uninstall check.
				SET @o_unInstallAllowed = 0
				SET @o_groupID = @appGroupID
				BREAK
			END
			ELSE
			BEGIN
				-- There are no issues with this group. Checking the next group.
				FETCH NEXT FROM Groups INTO @appGroupID
				CONTINUE
			END
		END
		FETCH NEXT FROM Groups INTO @appGroupID
END
IF(@o_unInstallAllowed = 0)
	 SET @o_groupName = (select DISTINCT GroupName from simApptypeGroupIDMap where GroupId=@o_groupID)
select @o_unInstallAllowed, @o_groupID, @o_groupName
CLOSE      Groups
DEALLOCATE Groups
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simUnInstallDependencyCheck')
	delete from GxQscripts where name = 'simUnInstallDependencyCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simUnInstallDependencyCheck')
	delete from GXDBVersions where aliasname = 'simUnInstallDependencyCheck'
GO

insert into GXDBVersions values(2, 'simUnInstallDependencyCheck',  '00010005029000010000', 'simUnInstallDependencyCheck', '00010005029000010000')
GO

