

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simSortPackagesBasedOnDependency.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simSortPackagesBasedOnDependency.sp,v $ $Id: simSortPackagesBasedOnDependency.sp,v 1.5.50.3 2019/02/25 16:18:15 kvankadaru Exp $";
--
--  +========================================================================+
--  |      Name	 :  simSortPackagesBasedOnDependency()
--  |
--  | Description:  It sorts ALL SIM packages  based on Package Dependency criteria and assign Rank to each package.
--	|				The independent packages will have the lowest Rank.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  SIM Package Dependency sort criteria
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simSortPackagesBasedOnDependency')
BEGIN
	print '>>> Drop Stored Procedure: simSortPackagesBasedOnDependency <<<'
	drop procedure simSortPackagesBasedOnDependency
END
IF EXISTS (select * from GxQscripts where name='simSortPackagesBasedOnDependency')
	delete from GxQscripts where name = 'simSortPackagesBasedOnDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSortPackagesBasedOnDependency')
	delete from GXDBVersions where aliasname = 'simSortPackagesBasedOnDependency'
GO
print '... Creating Procedure: simSortPackagesBasedOnDependency'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simSortPackagesBasedOnDependency
AS
SET NOCOUNT ON
	DECLARE	@o_errorCode	INT= 0
BEGIN TRY
	-- 0) init
	UPDATE simPackage SET RANK = -1
	-- 1) a list of packages not in dependent list --> rank = 0
	UPDATE simPackage SET RANK = 0 WHERE id NOT IN (select simdependentPackageId from simPackageDependency where dependencyType = 1)
	-- 2) calculate dependency
	DECLARE @pkgDepToCheck	TABLE (t_pkg INT, t_dependent INT, t_rank INT)
	INSERT INTO @pkgDepToCheck
	SELECT	simPackageId, simDependentPackageId, 0
	FROM	simPackageDependency
	WHERE	dependencyType = 1
	WHILE EXISTS (select * from @pkgDepToCheck where t_rank = 0)
	BEGIN
		UPDATE @pkgDepToCheck
		SET	t_rank = RANK + 1
		FROM	simPackage
		WHERE	id = t_pkg AND t_rank = 0 AND RANK > -1
		UPDATE simPackage
		SET	RANK = (select MAX(t_rank) from @pkgDepToCheck where id = t_dependent)
		WHERE	RANK = -1 AND NOT EXISTS (select * from @pkgDepToCheck WHERE id = t_dependent AND t_rank = 0)
	END
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER()
END CATCH;
EXIT_PROC:
	SELECT @o_errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simSortPackagesBasedOnDependency')
	delete from GxQscripts where name = 'simSortPackagesBasedOnDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSortPackagesBasedOnDependency')
	delete from GXDBVersions where aliasname = 'simSortPackagesBasedOnDependency'
GO

insert into GXDBVersions values(2, 'simSortPackagesBasedOnDependency',  '00010005005000030000', 'simSortPackagesBasedOnDependency', '00010005005000030000')
GO

