

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simSetXMLRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simSetXMLRequest.sp,v $ $Id: simSetXMLRequest.sp,v 1.1.2.1 2018/03/20 15:47:08 xsui Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simSetXMLRequest()
--  |
--  | Description: Wrapper for cpp code to call simSetInstalledPackage when using UNIX timestamp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simSetXMLRequest <<<'

IF EXISTS (select * from sysobjects where name='simSetXMLRequest')
	drop procedure simSetXMLRequest
IF EXISTS (select * from GxQscripts where name='simSetXMLRequest')
	delete from GxQscripts where name = 'simSetXMLRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetXMLRequest')
	delete from GXDBVersions where aliasname = 'simSetXMLRequest'
GO
print '... Creating Procedure: simSetXMLRequest'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simSetXMLRequest
  @i_clientID integer,
  @i_reqXML XML,
  @i_bWQReq integer = 0
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_reqID integer = 0
SET NOCOUNT ON
IF @i_bWQReq > 0
BEGIN
	SET @o_reqID = ISNULL((select max(id) from SimXMLRequest NOLOCK where clientID = @i_clientID), 0)
	IF NOT EXISTS (select id from SimXMLRequest NOLOCK where id = @o_reqID and checksum(CAST(xmlBlob AS VARCHAR(MAX))) = checksum(CAST(@i_reqXML AS VARCHAR(MAX))))
		SET @o_reqID = 0
END
IF @o_reqID = 0
BEGIN
	INSERT INTO SimXMLRequest
	SELECT @i_clientID, GetUTCDate(), @i_reqXML, NULL
	SET @o_reqID = @@IDENTITY
END
SELECT @o_reqID
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simSetXMLRequest')
	delete from GxQscripts where name = 'simSetXMLRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetXMLRequest')
	delete from GXDBVersions where aliasname = 'simSetXMLRequest'
GO

insert into GXDBVersions values(2, 'simSetXMLRequest',  '00010001000200010000', 'simSetXMLRequest', '00010001000200010000')
GO

