

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simSetThirdPartyPatches.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simSetThirdPartyPatches.sp,v $ $Id: simSetThirdPartyPatches.sp,v 1.1.2.7 2020/05/01 18:18:29 kgao Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simSetThirdPartyPatches
--  |
--  | Description: Wrapper for cpp code to call simSetInstalledPackage when using UNIX timestamp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simSetThirdPartyPatches')
BEGIN
	print '>>> Drop Stored Procedure: simSetThirdPartyPatches <<<'
	drop procedure simSetThirdPartyPatches
END
IF EXISTS (select * from GxQscripts where name='simSetThirdPartyPatches')
	delete from GxQscripts where name = 'simSetThirdPartyPatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetThirdPartyPatches')
	delete from GXDBVersions where aliasname = 'simSetThirdPartyPatches'
GO
print '... Creating Procedure: simSetThirdPartyPatches'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simSetThirdPartyPatches
  @i_clientId INT,
  @i_ThirdPartyPatches XML
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr varchar(MAX)
SET NOCOUNT ON
BEGIN TRY
	SET @o_errorCode = 0
	SET @o_errorStr = ''
	DECLARE @TPCUID		INT = 0
	DECLARE @type       	INT = 0
	DECLARE @optime		DATETIME = GETUTCDATE()
	DECLARE @version	VARCHAR(MAX) = ''
	DECLARE @patches	VARCHAR(MAX) = ''
	DECLARE @clientID	INT = ISNULL((	select CAST(attrVal AS INT) from APP_ClientProp NOLOCK
						where componentNameId = @i_clientId and attrName = 'Active Physical Node' and modified = 0), @i_clientId)
	SELECT  @type = ISNULL(ref.value('@type', 'varchar(MAX)'), ''), @version = ISNULL(ref.value('@version', 'varchar(MAX)'), ''), @patches = ISNULL(ref.value('@patches', 'varchar(MAX)'), '')
	FROM    @i_ThirdPartyPatches.nodes('CVInstallManager_ThirdPartyCU') R(ref)
	IF @type = 0
	BEGIN
		SET @o_errorCode = -1
		SET @o_errorStr = 'Unable to get third party CU type'
		GOTO SP_EXIT
	END
	SELECT @TPCUID = id FROM SimInstalledThirdPartyCU WHERE clientID = @clientID AND type = @type
	IF @TPCUID > 0
	BEGIN
		UPDATE SimInstalledThirdPartyCU SET opTime = @optime, version = @version, updates = @patches WHERE id = @TPCUID
	END
	ELSE
	BEGIN
		DECLARE @isEligible INT = 0
		DECLARE @isEnabled INT = 0
		DECLARE @HyperScaleApplianceClientID INT = 2
		IF EXISTS (SELECT 1 FROM patchApplianceOS WITH(NOLOCK) WHERE name = @version AND clientId = @HyperScaleApplianceClientID)
			SET @isEligible = 1
		IF EXISTS (SELECT 1 from APP_ClientProp (NOLOCK) where componentNameID = @clientID and attrName = 'Appliance Client' and attrVal = '1' and modified = 0) OR
		   EXISTS (SELECT 1 from MMEntityProp (NOLOCK) where entityID = @clientID and propertyName = 'MediaAgentApplianceType' and EntityType = 10 and intVal = 4) OR
		   EXISTS (SELECT 1 from GXGlobalParam (NOLOCK) where name = 'CSApplianceVM' and value = 1 and @HyperScaleApplianceClientID = @clientID)
			SET @isEnabled = 1
		INSERT INTO SimInstalledThirdPartyCU
		SELECT @clientID, @type, @optime, @version, @patches, @isEligible, @isEnabled
		SET @TPCUID = @@IDENTITY
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER();
	SET @o_errorStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
SP_EXIT:
	SELECT @o_errorCode, @o_errorStr
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simSetThirdPartyPatches')
	delete from GxQscripts where name = 'simSetThirdPartyPatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetThirdPartyPatches')
	delete from GXDBVersions where aliasname = 'simSetThirdPartyPatches'
GO

insert into GXDBVersions values(2, 'simSetThirdPartyPatches',  '00010001000200070000', 'simSetThirdPartyPatches', '00010001000200070000')
GO

