

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simSetInstalledPackage2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simSetInstalledPackage2.sp,v $ $Id: simSetInstalledPackage2.sp,v 1.1.2.7 2018/03/27 08:40:13 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simSetInstalledPackage2()
--  |
--  | Description: Wrapper for cpp code to call simSetInstalledPackage when using UNIX timestamp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simSetInstalledPackage2 <<<'

IF EXISTS (select * from sysobjects where name='simSetInstalledPackage2')
	drop procedure simSetInstalledPackage2
IF EXISTS (select * from GxQscripts where name='simSetInstalledPackage2')
	delete from GxQscripts where name = 'simSetInstalledPackage2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetInstalledPackage2')
	delete from GXDBVersions where aliasname = 'simSetInstalledPackage2'
GO
print '... Creating Procedure: simSetInstalledPackage2'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simSetInstalledPackage2
  @inCreateIfNotExists integer,
  @inClientId integer, 
  @inPackageID integer, 
  @inOpTime integer,
  @inOpType char(25),
  @inUserID integer, 
  @inHighestSP integer,
  @inAdditionalPatches ntext, 
  @inMissingPatches ntext, 
  @inNode nvarchar(255), 
  @inIsActive integer, 
  @inSpMinorVersion integer, 
  @inBaseline integer, 
  @inBaselineDeltaSP ntext, 
  @inBaselineDeltaUpdate ntext, 
  @inTransactionID integer = 0,
  @inRevisionID integer = 0,
  @inFriendlyName varchar(256)
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr varchar(MAX)
SET NOCOUNT ON
BEGIN TRY
	SET @o_errorCode = 0
	SET @o_errorStr = ''
	DECLARE @ssipCreateIfNotExists integer = @inCreateIfNotExists
	DECLARE @ssipClientId integer = @inClientId
	DECLARE @ssipPackageID integer = @inPackageID
	DECLARE @ssipOpType char(25) = @inOpType
	DECLARE @ssipOpTime datetime = CONVERT(datetime, dbo.GetDateTime(@inOpTime))
	DECLARE @ssipUserID integer = @inUserID
	DECLARE @ssipHighestSP integer = @inHighestSP
	DECLARE @ssipAdditionalPatches nvarchar(MAX) = CONVERT(nvarchar(MAX),@inAdditionalPatches)
	DECLARE @ssipMissingPatches nvarchar(MAX) = CONVERT(nvarchar(MAX),@inMissingPatches)
	DECLARE @ssipNode nvarchar(255) = @inNode
	DECLARE @ssipIsActive integer = @inIsActive
	DECLARE @ssipSpMinorVersion integer = @inSpMinorVersion
	DECLARE @ssipBaseline integer = @inBaseline
	DECLARE @ssipBaselineDeltaSP nvarchar(MAX) = CONVERT(nvarchar(MAX),@inBaselineDeltaSP)
	DECLARE @ssipBaselineDeltaUpdate nvarchar(MAX) = CONVERT(nvarchar(MAX),@inBaselineDeltaUpdate)
	DECLARE @ssipTransactionID integer = @inTransactionID
	DECLARE @ssipRevisionID integer = @inRevisionID
	DECLARE @ssipFriendlyName varchar(256) = @inFriendlyName
--- CODE BELOW HERE IS FROM simSetInstalledPackage.spb  ----------
-- in order to use, variables to be declared are...
-- INPUT : @ssipCreateIfNotExists integer, @ssipClientId integer, @ssipPackageID integer, @ssipOpTime datetime, @ssipOpType char(25), @ssipUserID integer, @ssipHighestSP integer,ssipAdditionalPatches ntext, @ssipMissingPatches ntext, @ssipNodenvarchar(255), @ssipIsActive integer, @ssipSpMinorVersion integer, @ssipBaseline integer, @ssipBaselineDeltaSP ntext, @ssipBaselineDeltaUpdate ntext, @ssipTransactionID integer = 0, @ssipRevisionID integer = 0
DECLARE @releaseId integer
SELECT @releaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = @ssipClientId
DECLARE @isCSSPUpgrade INTEGER = 0
DECLARE @oldCSRelease INTEGER = 0
DECLARE @oldCSSPMajor INTEGER = 0
DECLARE @oldCSSPMinor INTEGER = 0
DECLARE @oldCSSPTransId INTEGER = 0
-- Check PatchSPVersion table for entry
DECLARE @spVersionInfo TABLE ( id int )
DECLARE @buildNum INT = dbo.GetBuildNum(@releaseId)
INSERT @spVersionInfo
EXEC simGetSPVersionID @releaseId, @buildNum, @ssipHighestSP, @ssipSpMinorVersion, @ssipTransactionId, @ssipRevisionId, @ssipFriendlyName
DECLARE @patchSPVersionId integer
SELECT @patchSPVersionId = id FROM @spVersionInfo
IF EXISTS (SELECT 1 FROM simInstalledPackages WITH (NOLOCK) WHERE ClientId = @ssipClientId AND simPackageID = @ssipPackageId)
BEGIN
IF @ssipClientId = 2 AND @ssipPackageID = 20
	BEGIN
		SELECT @oldCSRelease = P.Release, @oldCSSPMajor = P.SPMajor, @oldCSSPMinor = P.SPMinor, @oldCSSPTransId = P.TransactionId
		FROM simInstalledPackages S WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON S.SPVersionID = P.Id WHERE S.ClientId = @ssipClientId AND S.simPackageID = @ssipPackageID
IF @oldCSRelease > 0 AND ((dbo.CompareServicePackLevel(@ssipHighestSP, @ssipSpMinorVersion, @ssipTransactionID, @oldCSSPMajor, @oldCSSPMinor, @oldCSSPTransId) > 0) OR (@oldCSRelease < 16))  -- ServicePack upgrade
		BEGIN
			SET @isCSSPUpgrade = 1
		END
	END
	UPDATE simInstalledPackages
	SET OpTime = CASE WHEN @ssipOpTime <> 0 THEN @ssipOpTime ELSE OpTime END,
		OpType = CASE WHEN @ssipOpType <> '' THEN @ssipOpType ELSE OpType END,
		UserID = @ssipUserID,
		HighestSP = @ssipHighestSP,
		AdditionalPatches = @ssipAdditionalPatches,
		MissingPatches = @ssipMissingPatches,
		Node = @ssipNode,
		IsActive = @ssipIsActive,
		SpMinorVersion = @ssipSpMinorVersion,
		Baseline = @ssipBaseline,
		BaselineDeltaSP = @ssipBaselineDeltaSP,
		BaselineDeltaUpdate = @ssipBaselineDeltaUpdate,
		SPVersionID = @patchSPVersionId
	WHERE ClientId = @ssipClientId AND simPackageID = @ssipPackageId
	-- Invalidate all RCs which did not have latest media
	IF @isCSSPUpgrade = 1
	BEGIN
		UPDATE PatchUpdateAgentInfo
		SET inSyncWithCS = 0, packageStatus = 0
		WHERE isDeleted = 0 AND clientId <> 2
			AND NOT EXISTS (SELECT * FROM PatchMultiCache M WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON M.SPVersionID = P.Id
WHERE P.Release = 16 AND M.ClientId = PatchUpdateAgentInfo.ClientId AND P.SPMajor = @ssipHighestSP AND P.SPMinor = @ssipSpMinorVersion AND P.TransactionId = @ssipTransactionID)
	END
END
ELSE IF @ssipCreateIfNotExists = 1
BEGIN
	INSERT INTO simInstalledPackages(ClientId,simPackageID,OpTime,OpType,UserID,HighestSP,AdditionalPatches,MissingPatches,Node,IsActive,SpMinorVersion,Baseline,BaselineDeltaSP,BaselineDeltaUpdate,SPVersionID)
	VALUES(@ssipClientId, @ssipPackageID, @ssipOpTime, @ssipOpType, @ssipUserID, @ssipHighestSP, @ssipAdditionalPatches, @ssipMissingPatches, @ssipNode, @ssipIsActive, @ssipSpMinorVersion, @ssipBaseline, @ssipBaselineDeltaSP, @ssipBaselineDeltaUpdate, @patchSPVersionId)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER();
	SET @o_errorStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
SELECT @o_errorCode, @o_errorStr
RETURN @o_errorCode
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simSetInstalledPackage2')
	delete from GxQscripts where name = 'simSetInstalledPackage2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetInstalledPackage2')
	delete from GXDBVersions where aliasname = 'simSetInstalledPackage2'
GO

insert into GXDBVersions values(2, 'simSetInstalledPackage2',  '00010001000200070000', 'simSetInstalledPackage2', '00010001000200070000')
GO

