

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simSetClientFirewallConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simSetClientFirewallConfig.sp,v $ $Id: simSetClientFirewallConfig.sp,v 1.1.2.2 2019/06/29 15:36:10 kgao Exp $";
--  +========================================================================+
--  | Stored Proc: simSetClientFirewallConfig()
--  |
--  | Description: Set the firewall client property of a given client Id.
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simSetClientFirewallConfig')
BEGIN
	print '>>> Drop Stored Procedure: simSetClientFirewallConfig <<<'
	drop procedure simSetClientFirewallConfig
END
IF EXISTS (select * from GxQscripts where name='simSetClientFirewallConfig')
	delete from GxQscripts where name = 'simSetClientFirewallConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetClientFirewallConfig')
	delete from GXDBVersions where aliasname = 'simSetClientFirewallConfig'
GO
print '... Creating Procedure: simSetClientFirewallConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simSetClientFirewallConfig
  @inClientId INT
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @oMessageStr VARCHAR(255) = ''
SET NOCOUNT OFF
DECLARE @attrEntryName VARCHAR(255) = 'Include in Firewall Config'
DECLARE	@currentTimestamp INTEGER = DATEDIFF(s, '1970-01-01', GETUTCDATE())
DECLARE @nIsVirutalDiscoveredClient INT = 0
DECLARE @strMessage VARCHAR(255) = ''
DECLARE @wqOutputErrCode INT = 0
DECLARE @wqOutputErrStr NVARCHAR(1024) = ''
DECLARE @workQOutPutTbl TABLE (errCode INT, errString NVARCHAR(MAX))
SELECT @nIsVirutalDiscoveredClient = 1 FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0 AND componentNameId = @inClientId
IF @nIsVirutalDiscoveredClient = 1
BEGIN
	IF EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @inClientId AND attrName = @attrEntryName)
		UPDATE APP_ClientProp SET attrVal = '1' WHERE componentNameId = @inClientId AND attrName = @attrEntryName
	ELSE
		INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId) VALUES(@inClientId, @attrEntryName, 7, '1', @currentTimestamp, 0, 0)
	-- WORK_TOKEN_NETWORK
	INSERT INTO @workQOutPutTbl
	EXEC AppWorkQueueSubmitRequest 5, 0, 0, 2, 0, ''
	SELECT @wqOutputErrCode = errCode, @wqOutputErrStr = errString FROM @workQOutPutTbl
	IF @wqOutputErrCode = 0
		SET @strMessage = 'Successfully set firewall config flag and submitted work queue request'
	ELSE
		SET @strMessage = 'Cannot submit work queue request to CommServer, error [' + @wqOutputErrCode + ':' + @wqOutputErrStr + ']'
END
ELSE
	SET @strMessage = 'Skip setting firewall config flag'
SELECT @strMessage
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simSetClientFirewallConfig')
	delete from GxQscripts where name = 'simSetClientFirewallConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetClientFirewallConfig')
	delete from GXDBVersions where aliasname = 'simSetClientFirewallConfig'
GO

insert into GXDBVersions values(2, 'simSetClientFirewallConfig',  '00010001000200020000', 'simSetClientFirewallConfig', '00010001000200020000')
GO

