

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simSetCSRemoteCacheStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simSetCSRemoteCacheStatus.sp,v $ $Id: simSetCSRemoteCacheStatus.sp,v 1.1.2.2 2018/06/08 18:52:20 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  simSetCSRemoteCacheStatus()
--  |
--  | Description: Set the baseline status as well as validity flag for CS and RCs
--		ClientType 0 - All Remote Caches as well as CS
--		ClientType 1 - All Remote Caches, no CS
--		ClientType 2 - CS only
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simSetCSRemoteCacheStatus <<<'

IF EXISTS (select * from sysobjects where name='simSetCSRemoteCacheStatus')
	drop procedure simSetCSRemoteCacheStatus
IF EXISTS (select * from GxQscripts where name='simSetCSRemoteCacheStatus')
	delete from GxQscripts where name = 'simSetCSRemoteCacheStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetCSRemoteCacheStatus')
	delete from GXDBVersions where aliasname = 'simSetCSRemoteCacheStatus'
GO
print '... Creating Procedure: simSetCSRemoteCacheStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simSetCSRemoteCacheStatus
  @clientType INT,
  @baselineStatus INT,
  @cacheStatus INT
AS
  DECLARE @nRowsUpdated INT 
SET NOCOUNT ON
IF @clientType = 0
BEGIN
	UPDATE PatchUpdateAgentInfo SET inSyncWithCS = @baselineStatus, packageStatus = @cacheStatus WHERE isDeleted = 0
END
ELSE IF @clientType = 1
BEGIN
	UPDATE PatchUpdateAgentInfo SET inSyncWithCS = @baselineStatus, packageStatus = @cacheStatus WHERE isDeleted = 0 AND clientId <> 2
END
ELSE IF @clientType = 2
BEGIN
	UPDATE PatchUpdateAgentInfo SET inSyncWithCS = @baselineStatus, packageStatus = @cacheStatus WHERE isDeleted = 0 AND clientId = 2
END
SELECT @@rowcount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simSetCSRemoteCacheStatus')
	delete from GxQscripts where name = 'simSetCSRemoteCacheStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simSetCSRemoteCacheStatus')
	delete from GXDBVersions where aliasname = 'simSetCSRemoteCacheStatus'
GO

insert into GXDBVersions values(2, 'simSetCSRemoteCacheStatus',  '00010001000200020000', 'simSetCSRemoteCacheStatus', '00010001000200020000')
GO

