

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simServicePackUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simServicePackUpgrade.sp,v $ $Id: simServicePackUpgrade.sp,v 1.1.2.5 2020/05/06 15:44:06 spakhare Exp $";
--
--  +==========================================================================================================+
--  |	Procedure:  simServicePackUpgrade
--  |
--  |   Revision  Author         Description
--  |   --------- -------------  ------------------------------------------------------------------------------
--  |	1.0       Philip Miller  Modifies client configuration based on Service Pack specific changes
--  +==========================================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simServicePackUpgrade')
BEGIN
	print '>>> Drop Stored Procedure: simServicePackUpgrade <<<'
	drop procedure simServicePackUpgrade
END
IF EXISTS (select * from GxQscripts where name='simServicePackUpgrade')
	delete from GxQscripts where name = 'simServicePackUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simServicePackUpgrade')
	delete from GXDBVersions where aliasname = 'simServicePackUpgrade'
GO
print '... Creating Procedure: simServicePackUpgrade'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simServicePackUpgrade
  @i_clientId INT,
  @i_newSPMajor INT
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up WITH the result set in terms of type, size,
--  and order!
  DECLARE @o_changesMade varchar(MAX)
-- These lines represent the actual SQL code that will get executed.
CREATE TABLE #tempClientSPVersion (
    release          INT,
	build            INT,
	majorSP          INT,
	minorSP          INT,
	revisionId       INT,
	timestamp        INT,
	transactionId    INT,
	friendlyName     VARCHAR(MAX)
	)
INSERT INTO #tempClientSPVersion EXEC simGetClientPackageSPVersion @i_clientId
DECLARE @oldSPMajor INT=0
SELECT @oldSPMajor = majorSP FROM #tempClientSPVersion
DROP TABLE #tempClientSPVersion
SET @o_changesMade = ''
IF  @oldSPMajor < 12 AND @i_newSPMajor >= 12
BEGIN
	IF EXISTS (	SELECT 1 FROM simInstalledPackages
				WHERE clientId = @i_clientId
AND simPackageId IN ( 151,
152,
153,
155,
157,
171) )
	BEGIN
		SET @o_changesMade = @o_changesMade + 'Exchange Package property changes. '
		-- Create new client prop entry
		DECLARE @newExchangePackageProperty VARCHAR(32) = 'PackageStateForId 151'
		IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrname = @newExchangePackageProperty)
			INSERT INTO APP_ClientProp SELECT @i_clientId, @newExchangePackageProperty, 2, 1, dbo.GetUnixTime(GETDATE()), 0, 0
		-- Remove old client prop entries
		DELETE APP_ClientProp FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrname IN ('PackageStateForId 152', 'PackageStateForId 155', 'PackageStateForId 171')
	END
END
-- Upgrade Test Automation package
IF @oldSPMajor <= 21 OR @oldSPMajor < @i_newSPMajor
BEGIN
	IF (SELECT 1 FROM simInstalledPackages WITH (NOLOCK) WHERE simPackageID IN (719, 1153) AND ClientId = @i_clientId) IS NOT NULL
	BEGIN
		IF DB_ID('HistoryDB') IS NULL
		BEGIN
			SET @o_changesMade = CONCAT(@o_changesMade, 'HistoryDB not found. Skipped updating tables for Service Pack: ', @i_newSPMajor)
		END
		ELSE
		BEGIN
			DECLARE @lastUpdatedSP VARCHAR(10)
			DECLARE @automationLastUpdated VARCHAR(50) = 'AutomationLastUpdatedSP'
			SELECT @lastUpdatedSP=value FROM GXGlobalParam WITH (NOLOCK) WHERE name = @automationLastUpdated AND modified = 0
			-- check if automation tables were updated for installed Service Pack
			IF @lastUpdatedSP IS NULL OR @lastUpdatedSP < @i_newSPMajor
			BEGIN
				DECLARE @csClientId INT = 2 -- default commcell id
				DECLARE @patchLocation NVARCHAR(512) -- CommServer installation path
				SELECT @patchLocation=attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @csClientId
				AND attrName = 'Patch Local Location' AND modified = 0
				IF @patchLocation IS NOT NULL
				BEGIN
					DECLARE @csSIMPkgId INT
					DECLARE @i_FileName NVARCHAR(512)
					-- check for windows or linux CS
					SELECT @csSIMPkgId=simPackageID FROM simInstalledPackages WITH (NOLOCK) WHERE ClientId=@csClientId AND simPackageID IN (801, 851)
					IF @csSIMPkgId = 801
						SET @i_FileName = @patchLocation + '\Base\DBUpgrade\HistoryDB\CV_AutomationDB.xml'
					IF @i_FileName IS NOT NULL
					BEGIN
						DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())
						DECLARE @output INT
						DECLARE @outputTable TABLE(errorCode INT)
						INSERT INTO @outputTable(errorCode)
						EXEC [HistoryDB].[dbo].[AUTOAddStaticList]
								@i_FileName = @i_FileName
						SELECT @output=errorCode FROM @outputTable
						IF @output <> 0
						BEGIN
							SET @o_changesMade = CONCAT(@o_changesMade, 'Failed to update automation tables for ServicePack: ', @i_newSPMajor)
						END
						ELSE IF @lastUpdatedSP IS NULL
						BEGIN
							INSERT INTO GXGlobalParam(name, value, created, modified)
							VALUES (@automationLastUpdated, @i_newSPMajor, @nowTime, 0)
							SET @o_changesMade = CONCAT(@o_changesMade, 'Automation tables updated for current ServicePack: ', @i_newSPMajor)
						END
						ELSE
						BEGIN
							UPDATE GXGlobalParam
							SET value = @i_newSPMajor
							WHERE name = @automationLastUpdated
							SET @o_changesMade = CONCAT(@o_changesMade, 'Automation tables updated for current ServicePack: ', @i_newSPMajor)
						END
					END
					ELSE
						SET @o_changesMade = CONCAT(@o_changesMade, 'Updating automation tables is not yet supported')
				END
				ELSE
					SET @o_changesMade = CONCAT(@o_changesMade, 'Unable to find patch location for client: [', @i_clientId, ']. Skipped updating Automation tables for ServicePack: ', @i_newSPMajor)
			END
			ELSE
				SET @o_changesMade = CONCAT(@o_changesMade, 'Automation tables already updated for ServicePack: ', @i_newSPMajor)
		END
	END
END
SELECT @o_changesMade
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simServicePackUpgrade')
	delete from GxQscripts where name = 'simServicePackUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simServicePackUpgrade')
	delete from GXDBVersions where aliasname = 'simServicePackUpgrade'
GO

insert into GXDBVersions values(2, 'simServicePackUpgrade',  '00010001000200050000', 'simServicePackUpgrade', '00010001000200050000')
GO

