

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simPrePushCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simPrePushCheck.sp,v $ $Id: simPrePushCheck.sp,v 1.1.2.7 2019/03/25 18:37:07 xsui Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simPrePushCheck')
BEGIN
	print '>>> Drop Stored Procedure: simPrePushCheck <<<'
	drop procedure simPrePushCheck
END
IF EXISTS (select * from GxQscripts where name='simPrePushCheck')
	delete from GxQscripts where name = 'simPrePushCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPrePushCheck')
	delete from GXDBVersions where aliasname = 'simPrePushCheck'
GO
print '... Creating Procedure: simPrePushCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simPrePushCheck
  @i_PhysicalClientId INTEGER,
  @i_ReleaseId INTEGER
AS
  DECLARE @o_isBlocked INT
  DECLARE @o_nReason INT
DECLARE @PseudoClients		TABLE (t_clientID INT, t_appType INT)
DECLARE @version INT
DECLARE @spVer	 INT
DECLARE @spMajor INT
DECLARE @hasSAPPackage INT = 0
SET @o_isBlocked = 0
SET @o_nReason = 0
-- only do such check if user want to update to v11
IF @i_ReleaseId >= 16
BEGIN
-- If the key is set, just return
IF NOT EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'Patch Allow SAP Archive Link Upgrade' AND value <> '0' AND value <> '')
BEGIN
-- OBJECT_LINK
INSERT INTO @PseudoClients
SELECT DISTINCT P.componentNameId, 124
FROM	APP_ClientProp P WITH (NOLOCK) CROSS APPLY dbo.SplitIDString(replace(P.attrVal,':',',')) T
WHERE	P.attrName = 'Object Server Member Servers List' AND P.modified = 0 AND T._ID = @i_PhysicalClientId
IF EXISTS (SELECT * FROM @PseudoClients)
BEGIN
	SELECT @spVer = MAX(SPVersionId) FROM simInstalledPackages WHERE clientId = @i_PhysicalClientId
SELECT @hasSAPPackage = 1 FROM simInstalledPackages WHERE clientId = @i_PhysicalClientId AND simPackageID = 1129
	SELECT @version = Release, @spMajor = SPMajor FROM PatchSPVersion WHERE id = @spVer
IF (@hasSAPPackage > 0) AND ((@version < 16) OR ((@version = 16 AND @spMajor < 7)))
	BEGIN
		SET @o_isBlocked = 1
		IF @version = @i_ReleaseId
SET @o_nReason  = (515 | (CAST(POWER(2, 24) AS BIGINT) * 68))
		ELSE
SET @o_nReason = (516 | (CAST(POWER(2, 24) AS BIGINT) * 68))
	END
END
END
--Block Service Pack upgrade / client upgrade when MySQL 5.4.x instance is present on the client.
IF EXISTS (SELECT 1 FROM APP_iDAName NOLOCK WHERE clientID = @i_PhysicalClientId AND appTypeID = 104)
BEGIN
	DECLARE @agentStatus TABLE(bAgentIsInstalled INT, bAgentCanBeUpgraded INT)
	INSERT INTO @agentStatus
EXEC simCanAgentBeUpgraded @i_PhysicalClientId, 104, @i_ReleaseId
	IF EXISTS (SELECT 1 FROM @agentStatus WHERE bAgentCanBeUpgraded = 0)
	BEGIN
		SET @o_isBlocked = 1
SET @o_nReason = (539 | (CAST(POWER(2, 24) AS BIGINT) * 68))
	END
END
END
EXIT_HERE:
SELECT @o_isBlocked, @o_nReason
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'simPrePushCheck')
	delete from GxQscripts where name = 'simPrePushCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPrePushCheck')
	delete from GXDBVersions where aliasname = 'simPrePushCheck'
GO

insert into GXDBVersions values(2, 'simPrePushCheck',  '00010001000200070000', 'simPrePushCheck', '00010001000200070000')
GO

