

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simPopulatePkgDependency.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simPopulatePkgDependency.sp,v $ $Id: simPopulatePkgDependency.sp,v 1.7.12.3 2020/06/26 03:41:18 mnalamothu Exp $";
--
--  +========================================================================+
--  |      Name	 :  simPopulatePkgDependency()
--  |
--  | Description:  It poulates Package dependencies for given OS  (Windows/Unix)
--	|
--  |	   Input :	i_FileName  =>	Dependency XML file	name with complete path
--	|				i_OSType	=>  0 for Windows
--	|								1 for UNIX
--  |      Output:  No Output parameters
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  poulates Package dependencies for given OS.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simPopulatePkgDependency')
BEGIN
	print '>>> Drop Stored Procedure: simPopulatePkgDependency <<<'
	drop procedure simPopulatePkgDependency
END
IF EXISTS (select * from GxQscripts where name='simPopulatePkgDependency')
	delete from GxQscripts where name = 'simPopulatePkgDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPopulatePkgDependency')
	delete from GXDBVersions where aliasname = 'simPopulatePkgDependency'
GO
print '... Creating Procedure: simPopulatePkgDependency'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simPopulatePkgDependency
  @i_FileName nvarchar(max),
  @i_OSType integer
AS
-- print @i_FileName
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#PkgDependencyTemp') is not null DROP TABLE #PkgDependencyTemp
	CREATE TABLE #PkgDependencyTemp(XmlCol xml)
DECLARE @InputXML XML
DECLARE @xmlText VARCHAR(max)
DECLARE @xmlText1 VARCHAR(max)
DECLARE @handle INT
DECLARE @handle1 INT
DECLARE @SQLString nvarchar(max) = N'INSERT INTO #PkgDependencyTemp(XmlCol) SELECT * FROM OPENROWSET ( BULK ''' + @i_FileName + ''', SINGLE_BLOB ) AS xmlData';
EXECUTE sp_executesql @SQLString;
SET @InputXML= (SELECT XmlCol from #PkgDependencyTemp)
SET @xmlText = CAST(@InputXML as nvarchar(max))
SET @xmlText1 = @xmlText
EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
EXEC sp_xml_preparedocument @handle1 OUTPUT, @xmlText1
IF @i_OSType = 0
BEGIN
	-- inserting data in package dependency table.
	INSERT INTO simPackageDependency ( simDependentPackageId, simPackageId, releaseId, dependencyType)
	SELECT DISTINCT simDependentPackageId, simPackageId, 0 AS releaseid, 1
	FROM OPENXML (@handle, 'UpdatePatches_PackageDetails/PackageInfoList/pkginfo/RequiresHard/@pkgID')
		WITH (	simDependentPackageId int '../../@pkgID',
				simPackageId int	'.')
	WHERE simPackageId IN (select id from SimPackage WITH (NOLOCK)) AND simDependentPackageId IN (select id from SimPackage WITH (NOLOCK))
	INSERT INTO simPackageDependency ( simDependentPackageId, simPackageId, releaseId, dependencyType)
	SELECT DISTINCT simDependentPackageId, simPackageId, 0 AS releaseid, 2
	FROM OPENXML (@handle, 'UpdatePatches_PackageDetails/PackageInfoList/pkginfo/RequiresSoft/@pkgID')
		WITH (	simDependentPackageId int '../../@pkgID',
				simPackageId int	'.')
	WHERE simPackageId IN (select id from SimPackage WITH (NOLOCK)) AND simDependentPackageId IN (select id from SimPackage WITH (NOLOCK))
	-- updating name in simpackage table.
	-- UPDATE simPackage
	-- set simPackage.Name = record.name1
	-- FROM OPENXML (@handle1, '/UpdatePatches_WinPackageDetails/PackageDependsList/PackageDepends/@pkgID')
	--	WITH (	pkgID int		'.',
	--			name1 varchar(256) './../@desc') record
	--	where simPackage.id = record.pkgID
END
ELSE IF @i_OSType = 1
BEGIN
	-- inserting data in package dependency table.
	INSERT INTO simPackageDependency ( simDependentPackageId, simPackageId, releaseId, dependencyType)
	SELECT DISTINCT simDependentPackageId, simPackageId, 0 AS releaseid, 1
	FROM OPENXML (@handle, '/UpdatePatches_PackageDetails/PackageInfoList/pkginfo/RequiresHard/@pkgID')
		WITH (	simDependentPackageId int '../../@pkgID',
				simPackageId int	'.')
	WHERE simPackageId IN (select id from SimPackage WITH (NOLOCK)) AND simDependentPackageId IN (select id from SimPackage WITH (NOLOCK))
	INSERT INTO simPackageDependency ( simDependentPackageId, simPackageId, releaseId, dependencyType)
	SELECT DISTINCT simDependentPackageId, simPackageId, 0 AS releaseid, 2
	FROM OPENXML (@handle, '/UpdatePatches_PackageDetails/PackageInfoList/pkginfo/RequiresSoft/@pkgID')
		WITH (	simDependentPackageId int '../../@pkgID',
				simPackageId int	'.')
	WHERE simPackageId IN (select id from SimPackage WITH (NOLOCK)) AND simDependentPackageId IN (select id from SimPackage WITH (NOLOCK))
	-- updating name in simpackage table.
	--UPDATE simPackage
	--set simPackage.Name = record.name1
	--FROM OPENXML (@handle1, '/UpdatePatches_UnixPackageDetails/PackageDependsList/PackageDepends/@pkgID')
	--	WITH (	pkgID int		'.',
	--			name1 varchar(256) './../@desc') record
	--	where simPackage.id = record.pkgID
END
EXEC sp_xml_removedocument @handle
EXEC sp_xml_removedocument @handle1
DROP TABLE #PkgDependencyTemp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simPopulatePkgDependency')
	delete from GxQscripts where name = 'simPopulatePkgDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPopulatePkgDependency')
	delete from GXDBVersions where aliasname = 'simPopulatePkgDependency'
GO

insert into GXDBVersions values(2, 'simPopulatePkgDependency',  '00010007001200030000', 'simPopulatePkgDependency', '00010007001200030000')
GO

