

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simPopulatePkgDependenciesForAllOS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simPopulatePkgDependenciesForAllOS.sp,v $ $Id: simPopulatePkgDependenciesForAllOS.sp,v 1.4.60.5 2020/03/30 19:22:15 chandru Exp $";
--
--  +========================================================================+
--  |      Name	 :  simPopulatePkgDependenciesForAllOS()
--  |
--  | Description:  It populates the package dependencies for Windows and UNIX OS.
--	|
--  |	   Input :	i_BaseFolderPath	(Base folder path of winpackage.xml/unixpackage.xml)
--	|
--  |      Output:  No output
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  populates the package dependencies.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simPopulatePkgDependenciesForAllOS')
BEGIN
	print '>>> Drop Stored Procedure: simPopulatePkgDependenciesForAllOS <<<'
	drop procedure simPopulatePkgDependenciesForAllOS
END
IF EXISTS (select * from GxQscripts where name='simPopulatePkgDependenciesForAllOS')
	delete from GxQscripts where name = 'simPopulatePkgDependenciesForAllOS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPopulatePkgDependenciesForAllOS')
	delete from GXDBVersions where aliasname = 'simPopulatePkgDependenciesForAllOS'
GO
print '... Creating Procedure: simPopulatePkgDependenciesForAllOS'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simPopulatePkgDependenciesForAllOS
  @i_BaseFolderPath nvarchar(max)
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRY
	DECLARE	@o_errorCode		integer = 0
	DECLARE	@o_errorString		nvarchar(1024)
	DECLARE @dependencyCheck	integer = 0
	DECLARE @WinFileName NVARCHAR(255)
	DECLARE @UnixFileName NVARCHAR(255)
	SET @WinFileName = @i_BaseFolderPath + 'WinPackages.xml'
	SET @UnixFileName = @i_BaseFolderPath + 'UnixPackages.xml'
	-- Deleting all rows from Dependency table.
	Delete simPackageDependency
	-- Populating Windows Dependencies.
	EXEC simPopulatePkgDependency @WinFileName,0
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	-- Populating UNIX Dependencies.
	EXEC simPopulatePkgDependency @UnixFileName,1
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	-- Validate no recursive dependencies exist up to 5 levels
	SELECT @dependencyCheck = COUNT(*) from simPackageDependency spd1
	INNER JOIN simPackageDependency spd2
	ON spd2.simDependentPackageId = spd1.simPackageId
	WHERE spd2.simPackageId = spd1.simDependentPackageId
	AND spd1.dependencyType = 1 AND spd2.dependencyType = 1
	IF @dependencyCheck > 0 GOTO RECURSIVE_DEPENDENCY
	SELECT @dependencyCheck = COUNT(*) from simPackageDependency spd1
	INNER JOIN simPackageDependency spd2
	ON spd2.simDependentPackageId = spd1.simPackageId
	INNER JOIN simPackageDependency spd3
	ON spd3.simDependentPackageId = spd2.simPackageId
	WHERE spd3.simPackageId = spd1.simDependentPackageId
	AND spd1.dependencyType = 1 AND spd2.dependencyType = 1
	AND spd3.dependencyType = 1
	IF @dependencyCheck > 0 GOTO RECURSIVE_DEPENDENCY
	SELECT @dependencyCheck = COUNT(*) from simPackageDependency spd1
	INNER JOIN simPackageDependency spd2
	ON spd2.simDependentPackageId = spd1.simPackageId
	INNER JOIN simPackageDependency spd3
	ON spd3.simDependentPackageId = spd2.simPackageId
	INNER JOIN simPackageDependency spd4
	ON spd4.simDependentPackageId = spd3.simPackageId
	WHERE spd4.simPackageId = spd1.simDependentPackageId
	AND spd1.dependencyType = 1 AND spd2.dependencyType = 1
	AND spd3.dependencyType = 1 AND spd4.dependencyType = 1
	IF @dependencyCheck > 0 GOTO RECURSIVE_DEPENDENCY
	SELECT @dependencyCheck = COUNT(*) from simPackageDependency spd1
	INNER JOIN simPackageDependency spd2
	ON spd2.simDependentPackageId = spd1.simPackageId
	INNER JOIN simPackageDependency spd3
	ON spd3.simDependentPackageId = spd2.simPackageId
	INNER JOIN simPackageDependency spd4
	ON spd4.simDependentPackageId = spd3.simPackageId
	INNER JOIN simPackageDependency spd5
	ON spd5.simDependentPackageId = spd4.simPackageId
	WHERE spd5.simPackageId = spd1.simDependentPackageId
	AND spd1.dependencyType = 1 AND spd2.dependencyType = 1
	AND spd3.dependencyType = 1 AND spd4.dependencyType = 1
	AND spd5.dependencyType = 1
	IF @dependencyCheck > 0 GOTO RECURSIVE_DEPENDENCY
	ELSE GOTO EXIT_PROC
RECURSIVE_DEPENDENCY:
	SET @o_errorCode = 50000
	SET @o_errorString = 'Recursive dependency found in simPackageDependency';
	THROW @o_errorCode, @o_errorString, 1;
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
END CATCH;
EXIT_PROC:
	SELECT @o_errorCode
	IF @o_errorCode <> 0
		RAISERROR (@o_errorString, 16, 1);
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simPopulatePkgDependenciesForAllOS')
	delete from GxQscripts where name = 'simPopulatePkgDependenciesForAllOS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPopulatePkgDependenciesForAllOS')
	delete from GXDBVersions where aliasname = 'simPopulatePkgDependenciesForAllOS'
GO

insert into GXDBVersions values(2, 'simPopulatePkgDependenciesForAllOS',  '00010004006000050000', 'simPopulatePkgDependenciesForAllOS', '00010004006000050000')
GO

