

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simPackageDetailsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simPackageDetailsInfo.sp,v $ $Id: simPackageDetailsInfo.sp,v 1.32.2.6 2020/06/26 03:41:09 mnalamothu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simPackageDetailsInfo')
BEGIN
	print '>>> Drop Stored Procedure: simPackageDetailsInfo <<<'
	drop procedure simPackageDetailsInfo
END
IF EXISTS (select * from GxQscripts where name='simPackageDetailsInfo')
	delete from GxQscripts where name = 'simPackageDetailsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPackageDetailsInfo')
	delete from GXDBVersions where aliasname = 'simPackageDetailsInfo'
GO
print '... Creating Procedure: simPackageDetailsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simPackageDetailsInfo
  @xmlText XML,
  @i_localeId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	declare		@i_clientId			INT
	declare		@i_clientGroupId	INT
	declare		@i_installOSType	INT
	declare		@i_requestForUninstall	INT
	declare		@reservedClientIdTbl	TABLE (t_clientId INT)
	declare		@b_virtualMachine	INT
	declare		@i_inclOnlyAddPkgs	INT
	declare		@i_includeDependentPackages	INT
	declare		@i_includeOnlyInstalledPackages	INT
	SET @i_installOSType = ISNULL(( SELECT ref.value('@installOSType', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq') R ( ref ) ),
							0)
	SET @i_clientId	 = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq/clientEntity') R ( ref ) ),
							0)
	SET @i_clientGroupId = ISNULL(( SELECT ref.value('@clientGroupId', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq/clientGroupEntity') R ( ref ) ),
							0)
	SET @i_requestForUninstall = 0
	SET @i_requestForUninstall = ISNULL(( SELECT ref.value('@requestForUninstall', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq') R ( ref ) ),
							0)
	SET @i_inclOnlyAddPkgs = 0
	SET @i_inclOnlyAddPkgs = ISNULL(( SELECT ref.value('@includeOnlyAdditionalPackages', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq') R ( ref ) ),
							0)
	SET @i_includeDependentPackages = 0
	SET @i_includeDependentPackages = ISNULL(( SELECT ref.value('@includeDependentPackages', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq') R ( ref ) ),
							0)
	SET @i_includeOnlyInstalledPackages = ISNULL(( SELECT ref.value('@includeOnlyInstalledPackages', 'int')
							FROM @xmlText.nodes('TMMsg_InstallPackageListReq') R ( ref ) ),
							0)
	-- Get Packages for Client Group
	IF @i_clientGroupId > 0
	BEGIN
		INSERT INTO @reservedClientIdTbl
		SELECT clientId FROM APP_ClientGroupAssoc WHERE
		clientGroupId = @i_clientGroupId AND clientId > 0
		DECLARE @totalClients INT
		SET @totalClients = ISNULL((SELECT COUNT(*) FROM @reservedClientIdTbl), 0)
		IF @i_includeOnlyInstalledPackages = 1
		BEGIN
			SET @xmlText =
				ISNULL((SELECT S.id AS '@packageId', S.Name AS '@packageName',
				 S.DisplayName AS '@displayName',
				(dbo.fn_EvFormatEventMsgText(0, 0, S.[DescriptionID], 0,2)) AS '@description'
				FROM simPackage  S
				INNER JOIN simInstalledPackages SP
					ON SP.simPackageID = S.id
				INNER JOIN @reservedClientIdTbl C
					ON C.t_clientId = SP.ClientId group by S.id, S.Name, S.DisplayName, S.descriptionID having count(*) = @totalClients
			FOR XML PATH('installPackageInfo'), ROOT('TMMsg_InstallPackageListResp')), '<TMMsg_InstallPackageListResp/>')
		END
		ELSE
		BEGIN
			SET @xmlText = '<TMMsg_InstallPackageListResp/>'
		END
	END
	ELSE
	BEGIN
		-- Get Packages for client
		-- if the request is for virtual machine get the list of packages that are installed on the physical machine
		IF @i_clientId = 0
			INSERT INTO @reservedClientIdTbl
			SELECT id FROM APP_Client WHERE id > 0
		ELSE
			INSERT INTO @reservedClientIdTbl VALUES (@i_clientId)
		SET @b_virtualMachine = ISNULL((select attrVal from app_clientProp where attrName = 'Virtual Client' AND componentNameId = @i_clientId ), 0)
		if (@b_virtualMachine = 1)
			INSERT INTO @reservedClientIdTbl (t_clientId)
				select PMClientId from APP_VMToPMMap where VMClientId = @i_clientId
		IF @i_includeOnlyInstalledPackages = 1
		BEGIN
			SET @xmlText =
				(SELECT
					SP.[Id] AS '@packageId', SP.[Name] AS '@packageName', SP.[DisplayName] AS '@displayName', SP.[Hierarchy] AS '@parentPath',
					(dbo.fn_EvFormatEventMsgText(0, @i_localeId, SP.[DescriptionID], 0,2)) AS '@description',
						--(select count(*) from siminstalledPackages where clientid in  (select t_clientId from @reservedClientIdTbl) and simPackageID=SP.[Id]) AS '@isPackageAlreadyInstalled',
					(SELECT 1 ) AS '@isPackageAlreadyInstalled',
					(SELECT
						[SimDependentPackageId] AS '@val'
						FROM simpackageDependency
						WHERE SimPackageId = SP.[Id] AND dependencyType = 1
						FOR XML PATH('requiredPackageIds'), TYPE)
				FROM simPackage SP INNER JOIN simInstalledPackages SIP ON SP.[id] = SIP.simPackageID INNER JOIN @reservedClientIdTbl temp ON SIP.ClientId = temp.t_clientId
				ORDER BY SP.SortID
				FOR XML PATH('installPackageInfo'), ROOT('TMMsg_InstallPackageListResp'))
		END
		ELSE IF @i_requestForUninstall = 0
		BEGIN
			SET @xmlText =
				(SELECT
					SP.[Id] AS '@packageId', SP.[Name] AS '@packageName', SP.[DisplayName] AS '@displayName', SP.[Hierarchy] AS '@parentPath',
					(dbo.fn_EvFormatEventMsgText(0, @i_localeId, SP.[DescriptionID], 0,2)) AS '@description',
					(select count(*) from siminstalledPackages where clientid=@i_clientId and simPackageID=SP.[Id]) AS '@isPackageAlreadyInstalled',
					(SELECT
						[SimpackageID] AS '@val'
						FROM simpackageDependency
						WHERE simdependentpackageid = SP.[Id] AND @i_includeDependentPackages = 1 AND dependencyType = 1
						FOR XML PATH('requiredPackageIds'), TYPE),
					(SELECT
						  CASE SP.[Id]
							 WHEN 257 THEN 261
							 WHEN 261 THEN 257
						  END
						 AS '@val'
						 WHERE SP.[Id] in (257,261)
						 FOR XML PATH('mutuallyExclusivePackageIds'), TYPE),
					(SELECT
						[SimpackageID] AS '@val'
						FROM simpackageDependency
						WHERE simdependentpackageid = SP.[Id] AND dependencyType = 2
						FOR XML PATH('softRequiredPackageIds'), TYPE)
				FROM simPackage SP
WHERE ((@i_inclOnlyAddPkgs = 1 AND SP.Id >=6000 AND SP.Id <= 7000)
OR (@i_inclOnlyAddPkgs = 0 AND (@i_installOSType = 100 OR @i_installOSType = 0 AND SP.Id < 1001 OR @i_installOSType = 1 and SP.Id > 1001 and SP.Id < 2000))) AND SP.InstallableFromGUI = 1
				ORDER BY SP.SortID
				FOR XML PATH('installPackageInfo'), ROOT('TMMsg_InstallPackageListResp'))
		END
		ELSE
		BEGIN
			SET @xmlText =
				(SELECT
					SP.[Id] AS '@packageId', SP.[Name] AS '@packageName', SP.[DisplayName] AS '@displayName', SP.[Hierarchy] AS '@parentPath',
					(dbo.fn_EvFormatEventMsgText(0, @i_localeId, SP.[DescriptionID], 0,2)) AS '@description',
						--(select count(*) from siminstalledPackages where clientid in  (select t_clientId from @reservedClientIdTbl) and simPackageID=SP.[Id]) AS '@isPackageAlreadyInstalled',
					(SELECT (CASE WHEN EXISTS (SELECT * from siminstalledPackages where clientid in  (select t_clientId from @reservedClientIdTbl) and simPackageID=SP.[Id])
								  THEN 1
								  ELSE 0
							END)) AS '@isPackageAlreadyInstalled',
					(SELECT
						[SimDependentPackageId] AS '@val'
						FROM simpackageDependency
						WHERE SimPackageId = SP.[Id] AND dependencyType = 1
						FOR XML PATH('requiredPackageIds'), TYPE)
				FROM simPackage SP
WHERE @i_installOSType = 100 and SP.Id NOT IN (1003, 1112, 1113) OR @i_installOSType = 0 AND @i_clientId > 2 AND (SP.Id < 1001 OR (SP.Id >=6000 AND SP.Id <= 7000))  OR @i_installOSType = 0 AND @i_clientId = 2 AND SP.Id NOT IN (701, 801, 1) AND (SP.Id < 1001 OR (SP.Id >=6000 AND SP.Id <= 7000)) OR @i_installOSType = 1 and SP.Id > 1001 and SP.Id < 2000 and SP.Id NOT IN (1003, 1112, 1113)
				ORDER BY SP.SortID
				FOR XML PATH('installPackageInfo'), ROOT('TMMsg_InstallPackageListResp'))
		END
	END
	SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simPackageDetailsInfo')
	delete from GxQscripts where name = 'simPackageDetailsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simPackageDetailsInfo')
	delete from GXDBVersions where aliasname = 'simPackageDetailsInfo'
GO

insert into GXDBVersions values(2, 'simPackageDetailsInfo',  '00010032000200060000', 'simPackageDetailsInfo', '00010032000200060000')
GO

