

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simIsUserMemberOfGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   simIsUserMemberOfGroup.SP   - Check if user is a member of a group
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simIsUserMemberOfGroup')
BEGIN
	print '>>> Drop Stored Procedure: simIsUserMemberOfGroup <<<'
	drop procedure simIsUserMemberOfGroup
END
IF EXISTS (select * from GxQscripts where name='simIsUserMemberOfGroup')
	delete from GxQscripts where name = 'simIsUserMemberOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsUserMemberOfGroup')
	delete from GXDBVersions where aliasname = 'simIsUserMemberOfGroup'
GO
print '... Creating Procedure: simIsUserMemberOfGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simIsUserMemberOfGroup
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @UserName nvarchar(MAX),
  @GroupName nvarchar(MAX)
AS
  DECLARE @IsMemberOfGroup integer
SET NOCOUNT ON
DECLARE @GroupId integer
DECLARE @UserId  integer
SET @IsMemberOfGroup = 0
-- The actual purpose of this stored procedure is to find if a user belongs to a group given username and group name.
-- But this procedure is only used by installer while adding owner of device, and finding if the user belongs to a blacklisted usergroup
SET @UserId = (SELECT ID
               FROM UMUsers
			   WHERE login = @UserName)
IF @UserId IS NOT NULL --We actually don't need to check if group is present as the sec_isBlacklistedUser below checks for all blacklisted groups
BEGIN
	EXECUTE sec_isBlackListedUser @UserId, @IsMemberOfGroup OUTPUT
END
SELECT @IsMemberOfGroup
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simIsUserMemberOfGroup')
	delete from GxQscripts where name = 'simIsUserMemberOfGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsUserMemberOfGroup')
	delete from GXDBVersions where aliasname = 'simIsUserMemberOfGroup'
GO

insert into GXDBVersions values(2, 'simIsUserMemberOfGroup',  '00000000000000000000', 'simIsUserMemberOfGroup', '00000000000000000000')
GO

