

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simIsOEMUpgraded.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simIsOEMUpgraded.sp,v $ $Id: simIsOEMUpgraded.sp,v 1.3.294.1 2018/03/22 01:44:33 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simIsOEMUpgraded()
--  |
--  | Description:  It checks whether the CS has ever been on token based OEM.
--  | 		  If yes then it returns the old token based OEM id
--  |
--  |      Output:  It returns the old token based OEM id
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  OEM upgrade criteria
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simIsOEMUpgraded <<<'

IF EXISTS (select * from sysobjects where name='simIsOEMUpgraded')
	drop procedure simIsOEMUpgraded
IF EXISTS (select * from GxQscripts where name='simIsOEMUpgraded')
	delete from GxQscripts where name = 'simIsOEMUpgraded'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsOEMUpgraded')
	delete from GXDBVersions where aliasname = 'simIsOEMUpgraded'
GO
print '... Creating Procedure: simIsOEMUpgraded'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simIsOEMUpgraded
AS
  DECLARE @oldOEMID integer
SET NOCOUNT ON
SET @oldOEMID = 0
IF EXISTS (	SELECT * FROM   LicCsl L INNER JOIN simOEM O ON L.OemId = O.OEMId and O.ExpressFlag = 1)
BEGIN
	IF EXISTS (	SELECT * FROM   LicCsl L1 INNER JOIN simOEM O1 ON L1.OemId = O1.OEMId and O1.ExpressFlag = 0 and L1.id = (select max(Id) from LicCsl))
	BEGIN
		set @oldOEMID = (select top(1) L2.OEMId  from LicCsl L2 INNER JOIN simOEM O2
					ON L2.OemId = O2.OEMId and O2.ExpressFlag =1
					order by L2.LicUpdateTime desc)
	END
END
select @oldOEMID
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simIsOEMUpgraded')
	delete from GxQscripts where name = 'simIsOEMUpgraded'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsOEMUpgraded')
	delete from GXDBVersions where aliasname = 'simIsOEMUpgraded'
GO

insert into GXDBVersions values(2, 'simIsOEMUpgraded',  '00010003029400010000', 'simIsOEMUpgraded', '00010003029400010000')
GO

