

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simIsClientFreshlyInstalledOnOrBeforeRelease.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simIsClientFreshlyInstalledOnOrBeforeRelease.sp,v $ $Id: simIsClientFreshlyInstalledOnOrBeforeRelease.sp,v 1.3.60.5 2020/10/04 01:02:36 abilbrey Exp $";
--
--  +========================================================================+
--  |	Procedure:  simIsClientFreshlyInstalledOnOrBeforeRelease
--	|
--  |	input parameter - i_clientID ( Given Client ID)
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |	1.1       hmishra  1) It returns the o_Flag as true in following conditions
--	|							a) if the given client is currently at a release on or before given release.
--	|							b) if the given client was ever upgraded from a release on or before given release.
--  |					   2) If o_Flag is true then
--	|							a) it sets  o_TimeOfUpgrade as 0 if the given client is currently at a release on or before given release.
--	|							b) else it sets  o_TimeOfUpgrade based on time of upgrade to either i_releaseID+1/i_releaseID+2 (whichever comes first) release.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simIsClientFreshlyInstalledOnOrBeforeRelease')
BEGIN
	print '>>> Drop Stored Procedure: simIsClientFreshlyInstalledOnOrBeforeRelease <<<'
	drop procedure simIsClientFreshlyInstalledOnOrBeforeRelease
END
IF EXISTS (select * from GxQscripts where name='simIsClientFreshlyInstalledOnOrBeforeRelease')
	delete from GxQscripts where name = 'simIsClientFreshlyInstalledOnOrBeforeRelease'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsClientFreshlyInstalledOnOrBeforeRelease')
	delete from GXDBVersions where aliasname = 'simIsClientFreshlyInstalledOnOrBeforeRelease'
GO
print '... Creating Procedure: simIsClientFreshlyInstalledOnOrBeforeRelease'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simIsClientFreshlyInstalledOnOrBeforeRelease
  @i_clientID integer,
  @i_releaseID integer
AS
  DECLARE @o_Flag integer
  DECLARE @o_TimeOfUpgrade integer
  DECLARE @o_errorCode integer
  DECLARE @o_infoString nvarchar(255)
SET NOCOUNT ON
BEGIN TRY
SET @o_infoString	 = ''
SET @o_errorCode     = 0
SET @o_Flag			 = 0
SET @o_TimeOfUpgrade = 0
SET QUOTED_IDENTIFIER ON
DECLARE @attrNameRel	VARCHAR(10) = 'Release '
DECLARE @upgradeHistory	TABLE (t_relStr VARCHAR(10), t_relId INT, t_time INT)
INSERT INTO @upgradeHistory
SELECT SUBSTRING(attrName, 9, LEN(attrName)), 0, attrVal
FROM APP_ClientProp NOLOCK WHERE componentNameID = @i_clientID and attrName like @attrNameRel+'%'
UPDATE @upgradeHistory SET t_relId = id FROM simAllGalaxyRel NOLOCK WHERE release = t_relStr
IF EXISTS (select 1 from @upgradeHistory where t_relId <= @i_releaseID)
BEGIN
	SET @o_Flag = 1
	SELECT @o_TimeOfUpgrade = MIN(t_time) FROM @upgradeHistory WHERE t_relId > @i_releaseID
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @o_errorCode = ERROR_NUMBER()
		set @o_infoString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message ['
		+ERROR_MESSAGE() + '].'
END CATCH
SELECT @o_Flag, @o_TimeOfUpgrade, @o_errorCode, @o_infoString
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simIsClientFreshlyInstalledOnOrBeforeRelease')
	delete from GxQscripts where name = 'simIsClientFreshlyInstalledOnOrBeforeRelease'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsClientFreshlyInstalledOnOrBeforeRelease')
	delete from GXDBVersions where aliasname = 'simIsClientFreshlyInstalledOnOrBeforeRelease'
GO

insert into GXDBVersions values(2, 'simIsClientFreshlyInstalledOnOrBeforeRelease',  '00010003006000050000', 'simIsClientFreshlyInstalledOnOrBeforeRelease', '00010003006000050000')
GO

