

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simIsBackupDoneForFSClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simIsBackupDoneForFSClient.sp,v $ $Id: simIsBackupDoneForFSClient.sp,v 1.2.210.1 2018/03/27 09:12:16 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simIsBackupDoneForFSClient()
--  |
--  | Description:  Checks if backup is run for clients with FS
--  |
--  |       Input:  ClientID
--	|
--  |      Output:  Returns the count of FS backup job for the input client
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simIsBackupDoneForFSClient <<<'

IF EXISTS (select * from sysobjects where name='simIsBackupDoneForFSClient')
	drop procedure simIsBackupDoneForFSClient
IF EXISTS (select * from GxQscripts where name='simIsBackupDoneForFSClient')
	delete from GxQscripts where name = 'simIsBackupDoneForFSClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsBackupDoneForFSClient')
	delete from GXDBVersions where aliasname = 'simIsBackupDoneForFSClient'
GO
print '... Creating Procedure: simIsBackupDoneForFSClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simIsBackupDoneForFSClient
  @ClientId integer
AS
  DECLARE @nCountBackupJobs integer
SET NOCOUNT ON
BEGIN
DECLARE	@tempFSAppTypes		TABLE(t_appNumber INT)
SET @nCountBackupJobs = 0
--Get the list of installed FS apptypes for the input client id
INSERT INTO @tempFSAppTypes
SELECT DISTINCT id  from APP_Application
WHERE appTypeId in (SELECT DISTINCT apptype   from simPackageMap where simPackageId in (702, 1101))
AND clientId = @ClientId
--For the FS apptypes/subclients get the count of backup job done
SET @nCountBackupJobs = (SELECT COUNT(*) FROM JMBkpStats, @tempFSAppTypes
WHERE appId = t_appNumber
AND status in (1, 3, 14) AND dataStatus = 0 AND totalUncompBytes > 0)
SELECT @nCountBackupJobs
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simIsBackupDoneForFSClient')
	delete from GxQscripts where name = 'simIsBackupDoneForFSClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simIsBackupDoneForFSClient')
	delete from GXDBVersions where aliasname = 'simIsBackupDoneForFSClient'
GO

insert into GXDBVersions values(2, 'simIsBackupDoneForFSClient',  '00010002021000010000', 'simIsBackupDoneForFSClient', '00010002021000010000')
GO

