

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simInstalledPackageUpdateForClusterCS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simInstalledPackageUpdateForClusterCS.sp,v $ $Id: simInstalledPackageUpdateForClusterCS.sp,v 1.2.276.3 2018/07/06 01:38:16 xsui Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simInstalledPackageUpdateForClusterCS
--  |
--  | Description:	Update simInstalledPackages table for cluster CS during DBUpgrade
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        Xuemei	    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simInstalledPackageUpdateForClusterCS <<<'

IF EXISTS (select * from sysobjects where name='simInstalledPackageUpdateForClusterCS')
	drop procedure simInstalledPackageUpdateForClusterCS
IF EXISTS (select * from GxQscripts where name='simInstalledPackageUpdateForClusterCS')
	delete from GxQscripts where name = 'simInstalledPackageUpdateForClusterCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simInstalledPackageUpdateForClusterCS')
	delete from GXDBVersions where aliasname = 'simInstalledPackageUpdateForClusterCS'
GO
print '... Creating Procedure: simInstalledPackageUpdateForClusterCS'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simInstalledPackageUpdateForClusterCS
  @i_clientId INTEGER
AS
-- Output variables of the stored procedure
  DECLARE @o_status INTEGER
SET NOCOUNT ON
DECLARE	@packageTbl	TABLE (t_pkgId INT, t_isDB INT)
DECLARE	@pmPkgTbl	TABLE (t_clId INT, t_pkgId INT)
DECLARE	@isDBTbl	TABLE (bIsDB INT)
INSERT INTO @packageTbl
SELECT	DISTINCT simpackageId, 0
FROM	simInstalledPackages
WHERE	clientId = @i_clientId
DECLARE	@pkgId	INT
DECLARE curGetIsDBPackage CURSOR FOR SELECT t_pkgId FROM @packageTbl
OPEN curGetIsDBPackage
FETCH NEXT FROM curGetIsDBPackage INTO @pkgId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE @isDBTbl
	INSERT INTO @isDBTbl
	EXEC simIsDBPackage @pkgId
	UPDATE	@packageTbl
	SET	t_isDB = (SELECT bIsDB FROM @isDBTbl)
	WHERE	t_pkgId = @pkgId
	FETCH NEXT FROM curGetIsDBPackage INTO @pkgId
END
INSERT INTO @pmPkgTbl
SELECT DISTINCT PMClientId, t_pkgId
FROM	APP_VMTOPMMap, @packageTbl
WHERE	VMClientId = @i_clientId AND t_isDB = 0
INSERT INTO simInstalledPackages
SELECT	t_clId, t_pkgId, P.OpTime, P.OpType, P.UserID, P.HighestSP, P.AdditionalPatches, P.MissingPatches, P.Node, 	P.IsActive, P.SpMinorVersion, P.Baseline, P.BaselineDeltaSP, P.BaselineDeltaUpdate, P.SPVersionID, P.UPNumber
FROM	simInstalledPackages P, @pmPkgTbl
WHERE	clientId = @i_clientId AND simpackageId = t_pkgId AND
	NOT EXISTS (select * from simInstalledPackages P2 where P2.clientId = t_clId and P2.simPackageId = t_pkgId)
DELETE simInstalledPackages
WHERE	clientId = @i_clientId AND simPackageId IN (select t_pkgId from @packageTbl where t_isDB = 0)
SELECT @@ERROR
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simInstalledPackageUpdateForClusterCS')
	delete from GxQscripts where name = 'simInstalledPackageUpdateForClusterCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simInstalledPackageUpdateForClusterCS')
	delete from GXDBVersions where aliasname = 'simInstalledPackageUpdateForClusterCS'
GO

insert into GXDBVersions values(2, 'simInstalledPackageUpdateForClusterCS',  '00010002027600030000', 'simInstalledPackageUpdateForClusterCS', '00010002027600030000')
GO

