

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simInstallDependencyCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simInstallDependencyCheck.sp,v $ $Id: simInstallDependencyCheck.sp,v 1.4.290.1 2018/03/22 01:30:02 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simInstallDependencyCheck()
--  |
--  | Description:  It checks whether a given apptype can be installed on the given client or not
--	|
--  |	   Input :  ClientID/Apptype/ReleaseID/IsVirtual
--	|
--  |      Output:  It returns o_installAllowed as TRUE if the apptype can be installed on the given client.
--	|				Else it returns FALSE and return the ID (in o_groupID) and Name (in o_groupName) of the group
--	|				which caused this installation failure.
--	|
--  |		 Note:  Currently we are not using ReleaseID/IsVirtual. It may be used in the future releases.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  SIM Apptype Install Dependency criteria
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simInstallDependencyCheck <<<'

IF EXISTS (select * from sysobjects where name='simInstallDependencyCheck')
	drop procedure simInstallDependencyCheck
IF EXISTS (select * from GxQscripts where name='simInstallDependencyCheck')
	delete from GxQscripts where name = 'simInstallDependencyCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simInstallDependencyCheck')
	delete from GXDBVersions where aliasname = 'simInstallDependencyCheck'
GO
print '... Creating Procedure: simInstallDependencyCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simInstallDependencyCheck
  @i_clientID integer,
  @i_appTypeID integer,
  @i_isVirtual integer,
  @i_releaseID integer
AS
  DECLARE @o_installAllowed integer
  DECLARE @o_groupID integer
  DECLARE @o_groupName nvarchar(255)
SET NOCOUNT ON
DECLARE @appGroupID INTEGER
SET @o_installAllowed = 1
SET @o_groupID = 0
DECLARE Groups CURSOR
FOR
select GroupID from simAppTypeDependency where ApptypeID=@i_appTypeID AND isVirtual=@i_isVirtual
OPEN Groups
FETCH NEXT FROM Groups INTO @appGroupID
WHILE @@FETCH_STATUS = 0
BEGIN
		IF EXISTS(select * from simApptypeGroupIDMap S, Licusage L Where S.GroupID=@appGroupID
		AND L.apptype = S.ApptypeID AND L.cid = @i_clientID AND L.optype = 'Install')
		BEGIN
			-- There are no issues with this group. Checking the next group.
			FETCH NEXT FROM Groups INTO @appGroupID
			CONTINUE
		END
		ELSE
		BEGIN
			-- Checking for the dummy apptypes present in this group
			IF EXISTS(select * from simApptypeGroupIDMap S, Patchinfo P Where S.GroupID=@appGroupID
			AND P.ApptypeId = S.ApptypeID AND P.clientid = @i_clientID)
			BEGIN
				-- There are no issues with this group. Checking the next group.
				FETCH NEXT FROM Groups INTO @appGroupID
				CONTINUE
			END
			ELSE
			BEGIN
				-- There are issues with this group.Failing the install check.
				SET @o_installAllowed = 0
				SET @o_groupID = @appGroupID
				BREAK
			END
		END
		FETCH NEXT FROM Groups INTO @appGroupID
END
IF(@o_installAllowed = 0)
	 SET @o_groupName = (select DISTINCT GroupName from simApptypeGroupIDMap where GroupId=@o_groupID)
SET @o_installAllowed = 1
select @o_installAllowed, @o_groupID, @o_groupName
CLOSE      Groups
DEALLOCATE Groups
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simInstallDependencyCheck')
	delete from GxQscripts where name = 'simInstallDependencyCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simInstallDependencyCheck')
	delete from GXDBVersions where aliasname = 'simInstallDependencyCheck'
GO

insert into GXDBVersions values(2, 'simInstallDependencyCheck',  '00010004029000010000', 'simInstallDependencyCheck', '00010004029000010000')
GO

