

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simInstallBaseClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simInstallBaseClient.sp,v $ $Id: simInstallBaseClient.sp,v 1.5.278.1 2018/03/22 01:46:39 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simInstallBaseClient()
--  |
--  | Description:  It makes database changes corresponding to Base client Install.
--	|				It is required because user may install baseclient+CS separately and drop in Dbupgraded DB.
--	|
--  |	   Input :	No Input parameters
--	|
--  |      Output:  It returns o_currentBuild (current Build), o_currentRelID (current ReleaseID) & the o_simOSID
--	|				(Sim OS ID from CS).
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  DB calls to simulate the Base client Install.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simInstallBaseClient <<<'

IF EXISTS (select * from sysobjects where name='simInstallBaseClient')
	drop procedure simInstallBaseClient
IF EXISTS (select * from GxQscripts where name='simInstallBaseClient')
	delete from GxQscripts where name = 'simInstallBaseClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simInstallBaseClient')
	delete from GXDBVersions where aliasname = 'simInstallBaseClient'
GO
print '... Creating Procedure: simInstallBaseClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simInstallBaseClient
AS
  DECLARE @o_currentRelID integer
  DECLARE @o_currentBuild nvarchar(255)
  DECLARE @o_simOSID integer
SET NOCOUNT ON
-- Adding a Base client row in App_platform table.
DECLARE @pos			integer
IF NOT EXISTS (select * from APP_Platform where clientId=2 AND platformType=4)
BEGIN
	DECLARE @length			integer
	DECLARE	@installDir		nvarchar(255)
	DECLARE	@reversedDir	nvarchar(255)
	set @installDir = (select install_dir from APP_Platform where clientId=2 and platformType=1)
	set @reversedDir = REVERSE(@installDir)
	set @pos = CHARINDEX('\', @reversedDir)
	set @length = len(@installDir)
	set @installDir = LEFT(@installDir, @length - @pos)
	insert into APP_Platform values  (2, 4, @installDir, 0)
END
-- Adding rows in App_clientprop table for binaryset ID and simosinfo properties.
DECLARE @currentTime integer
set @currentTime = dbo.GetUnixTime(GETDATE())
DECLARE	@SimOSInfo		nvarchar(255)
DECLARE	@simOSID		integer
set @simOSID = (select simOperatingSystemId from APP_Client where id=2)
DECLARE	@OSName			nvarchar(255)
DECLARE	@OSRelease		nvarchar(255)
DECLARE	@OSVersion		nvarchar(255)
select @OSName=name, @OSRelease=release, @OSVersion=version from simos where id=@simOSID
DECLARE	@hardware		nvarchar(255)
set @hardware = dbo.GetClientHardwareName(2, NULL)
set @SimOSInfo = @OSName + ':-' + @OSRelease + ':-' + @OSVersion + ':-' + @hardware
DECLARE @BinarySetID	integer
set @pos = 0
set @pos = CHARINDEX('x64', @OSName)
IF(@pos > 0)
	set @BinarySetID = 3
ELSE
BEGIN
	set @pos = CHARINDEX('64', @OSName)
	IF(@pos > 0)
		set @BinarySetID = 2
	ELSE
		set @BinarySetID = 1
END
IF NOT EXISTS (select * from App_clientprop where componentnameid=2 AND attrName='Binary Set ID')
	insert into App_clientprop values (2, 'Binary Set ID', 7, @BinarySetID, @currentTime, 0, 0)
IF NOT EXISTS (select * from App_clientprop where componentnameid=2 AND attrName='Sim OS Info')
	insert into App_clientprop values (2, 'Sim OS Info', 1, @SimOSInfo, @currentTime, 0, 0)
-- Adding row in patchinfo table.
DECLARE @currentRelID	integer
DECLARE	@currentBuild	nvarchar(255)
DECLARE	@nodeName		nvarchar(255)
set @currentRelID = (select Releaseid from APP_Client where id=2)
IF EXISTS (select * from Patchinfo where clientid=2 AND AppTypeId=1000)
BEGIN
	set @nodeName = (select Node from Patchinfo where clientid=2 AND AppTypeId=1000)
	set @currentBuild = (select BuildIdString from Patchinfo where clientid=2 AND AppTypeId=1000)
	IF NOT EXISTS (select * from PatchInfo where clientId=2 AND ApptypeId=1001)
		insert into PatchInfo values (2, @currentRelID, 1001, @currentBuild, 0,  'None', 'None', @nodeName, 1, 0, 1, '', '')
END
-- Adding Job results dir for CS if it is not populated already.
DECLARE @tblRetCode integer
DECLARE	@jobResultDir	nvarchar(255)
set @jobResultDir = (select jobResultDir from App_Client where id=2)
IF(@jobResultDir = '' OR @jobResultDir = 'NO DIR')
BEGIN
	set @installDir = (select install_dir from APP_Platform where clientId=2 and platformType=1)
	set @reversedDir = REVERSE(@installDir)
	set @pos = CHARINDEX('\', @reversedDir)
	set @length = len(@installDir)
	set @installDir = LEFT(@installDir, @length - @pos)
	set @jobResultDir = @installDir + '\iDataAgent\JobResults'
	Update App_Client set jobResultDir=@jobResultDir where id=2
	set @tblRetCode = @@error
	if (@tblRetCode <> 0)
	BEGIN
		set @tblRetCode = @@error;
		print 'RETVAL: Table [App_Client] ErrorCode: ' + CAST(@tblRetCode as varchar)
	END
END
SELECT @currentRelID, @currentBuild, @simOSID
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simInstallBaseClient')
	delete from GxQscripts where name = 'simInstallBaseClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simInstallBaseClient')
	delete from GXDBVersions where aliasname = 'simInstallBaseClient'
GO

insert into GXDBVersions values(2, 'simInstallBaseClient',  '00010005027800010000', 'simInstallBaseClient', '00010005027800010000')
GO

