

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simHandleRecursivePackageDependency.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simHandleRecursivePackageDependency.sp,v $ $Id: simHandleRecursivePackageDependency.sp,v 1.1.278.1 2018/03/27 08:50:02 jiechen Exp $";
--
--  +========================================================================+
--  |      Name	 :  simHandleRecursivePackageDependency()
--  |
--  | Description:  It updates the Rank for the dependent Packages in recursive manner.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  SIM Package Dependency sort criteria
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simHandleRecursivePackageDependency <<<'

IF EXISTS (select * from sysobjects where name='simHandleRecursivePackageDependency')
	drop procedure simHandleRecursivePackageDependency
IF EXISTS (select * from GxQscripts where name='simHandleRecursivePackageDependency')
	delete from GxQscripts where name = 'simHandleRecursivePackageDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simHandleRecursivePackageDependency')
	delete from GXDBVersions where aliasname = 'simHandleRecursivePackageDependency'
GO
print '... Creating Procedure: simHandleRecursivePackageDependency'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simHandleRecursivePackageDependency
  @iPackageID integer,
  @iPackageRanking integer
AS
SET NOCOUNT ON
DECLARE @lPackageID1 int
DECLARE @lPackageRanking1 int
DECLARE cur_Level CURSOR  LOCAL FOR
	SELECT S.simDependentPackageId, Rank FROM simPackage T, SimPackageDependency S
	WHERE T.id = @iPackageID  AND S.simPackageId= @iPackageID AND Rank <= @iPackageRanking
UPDATE simPackage set Rank = @iPackageRanking + 1 where id in
(SELECT S.simDependentPackageId  FROM simPackage T, SimPackageDependency S
WHERE T.id = @iPackageID  AND S.simPackageId= @iPackageID) AND Rank <= @iPackageRanking
OPEN cur_Level
	FETCH NEXT FROM cur_Level INTO @lPackageID1, @lPackageRanking1
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @myRanking INT
		SET @myRanking = (SELECT Rank from simPackage where ID = @lPackageID1)
		IF (@myRanking = @iPackageRanking +1 )
		BEGIN
			EXEC simHandleRecursivePackageDependency @lPackageID1,@myRanking
		END
		FETCH NEXT FROM cur_Level INTO @lPackageID1, @lPackageRanking1
	END
CLOSE cur_Level
DEALLOCATE cur_Level
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simHandleRecursivePackageDependency')
	delete from GxQscripts where name = 'simHandleRecursivePackageDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simHandleRecursivePackageDependency')
	delete from GXDBVersions where aliasname = 'simHandleRecursivePackageDependency'
GO

insert into GXDBVersions values(2, 'simHandleRecursivePackageDependency',  '00010001027800010000', 'simHandleRecursivePackageDependency', '00010001027800010000')
GO

