

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetVersionOfClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetVersionOfClient.sp,v $ $Id: simGetVersionOfClient.sp,v 1.1.210.3 2018/03/27 09:18:49 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simGetVersionOfClient()
--  |
--  | Description:  Retrieves the version of the Galaxy Client
--  | 				It will just check one of the products installed on the
--  |				client assuming that every product is from the same
--  |				release
--  |
--  |       Input:  ClientID
--	|
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:	This cursor have a problem at the moment where the client
--  | 				is being installed since we might have two different
--  |				versions at the same time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        madeira 	Initial release
--  |   1.2        madeira 	Added buildId to OUT parameter
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetVersionOfClient <<<'

IF EXISTS (select * from sysobjects where name='simGetVersionOfClient')
	drop procedure simGetVersionOfClient
IF EXISTS (select * from GxQscripts where name='simGetVersionOfClient')
	delete from GxQscripts where name = 'simGetVersionOfClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetVersionOfClient')
	delete from GXDBVersions where aliasname = 'simGetVersionOfClient'
GO
print '... Creating Procedure: simGetVersionOfClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetVersionOfClient
  @i_clientId integer
AS
  DECLARE @o_release char(32)
  DECLARE @o_buildId char(32)
  DECLARE @o_releaseID integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	SET NOCOUNT ON
	declare @clientId integer
-- Match       1:1 items in Parameter list, in order!
   set @clientId = @i_clientId
--			FETCH ALL THE ALERT ACTION ROWS FOR WHICH THERE IS A USER ASSOCIATION
--			--------------------------------------------------------------------------
--	select TOP 1 R.release, C.buildid, R.id
--	FROM simclientappsv2 C, simAllGalaxyRel R
--		WHERE C.clientid = @clientId and
--		      R.id = C.releaseId
--		ORDER BY C.id DESC
--	SELECT TOP 1 SR.Release, LU.Build, LU.Releaseid from LicUsage LU, SimAllGalaxyRel SR
--		WHERE LU.OpType='Install' AND LU.CId = @clientId AND SR.id = LU.Releaseid AND LU.Apptype NOT IN ( 1018, 1060 )
--		ORDER BY SR.Release DESC
DECLARE	@BUILD	varchar(32)
SET @BUILD = '0(' + (select attrval from App_clientprop where componentNameId =  @clientId AND attrname='Galaxy Build') + ')'
SELECT TOP 1 SR.Release, @BUILD as Build, CL.ReleaseId FROM App_Client CL
	JOIN SimAllGalaxyRel SR ON CL.releaseId = SR.id
WHERE cl.id =  @clientId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetVersionOfClient')
	delete from GxQscripts where name = 'simGetVersionOfClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetVersionOfClient')
	delete from GXDBVersions where aliasname = 'simGetVersionOfClient'
GO

insert into GXDBVersions values(2, 'simGetVersionOfClient',  '00010001021000030000', 'simGetVersionOfClient', '00010001021000030000')
GO

