

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetVersionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetVersionInfo.sp,v $ $Id: simGetVersionInfo.sp,v 1.25.2.2 2018/03/22 01:40:33 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetVersionInfo()
--  |
--  | Description:  Retrieves the version of the Galaxy Client
--  | 				It will just check one of the products installed on the
--  |				client assuming that every product is from the same
--  |				release
--  |
--  |       Input:  ClientID
--	|
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:	This cursor have a problem at the moment where the client
--  | 				is being installed since we might have two different
--  |				versions at the same time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetVersionInfo <<<'

IF EXISTS (select * from sysobjects where name='simGetVersionInfo')
	drop procedure simGetVersionInfo
IF EXISTS (select * from GxQscripts where name='simGetVersionInfo')
	delete from GxQscripts where name = 'simGetVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetVersionInfo')
	delete from GXDBVersions where aliasname = 'simGetVersionInfo'
GO
print '... Creating Procedure: simGetVersionInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetVersionInfo
  @ClientId integer,
  @AppType integer,
  @LicType integer
AS
  DECLARE @Release varchar(32)
  DECLARE @Build varchar(32)
  DECLARE @RelBuild varchar(32)
  DECLARE @ReleaseID integer
  DECLARE @InstallTime integer
	DECLARE @ClientType  integer
	DECLARE	@ReleaseVersion	varchar(32)
	SET NOCOUNT ON
	DECLARE @appInstallTime  integer=0
	DECLARE @licInstallTime  integer=0
	--SET @appInstallTime = ISNULL((select modified from APP_iDAName where clientId = @ClientId AND appTypeId = @AppType AND status = 0), 0)
	SELECT TOP 1 @appInstallTime = dbo.getUnixTime(OpTimeUTC) FROM LicUsage WHERE cid = @ClientId AND @AppType = @AppType ORDER BY OpTimeUTC Desc
	SET @appInstallTime = ISNULL((select modified from APP_iDAName WHERE clientId = @ClientId AND appTypeId = @AppType AND status = 0 AND (modified > 0) AND modified < @appInstallTime), @appInstallTime)
	IF @appInstallTime = NULL OR @appInstallTime = 0
    BEGIN
        SET @appInstallTime = (select refTime from APP_Client where id = @ClientId)
    END
	set @Release = (select SR1.Release from SimAllGalaxyRel SR1, App_client client1 where client1.id = @ClientId and SR1.id = client1.releaseid)
	set @ReleaseID = (select releaseid from App_client where id = @ClientId)
set @ReleaseVersion = 'BUILD80'
	set @ClientType = ( SELECT type FROM APP_CommCell cc WHERE id = (
																	SELECT origccid from APP_Client
																	WHERE id = @ClientId
																  )
						)
	IF @ClientType <> 1 AND NOT EXISTS (SELECT id FROM simInstalledPackages WHERE @ClientId = @ClientId)
	BEGIN
		SET NOCOUNT OFF
		IF EXISTS( SELECT id FROM APP_ClientProp WHERE componentNameId = @ClientId and attrName = 'Foreign Client Version' )
		BEGIN
			SELECT _clientprop.attrVal, '', ('') as RelAndBuild,
			-1, NULL--, dbo.GetUnixTime( GETDATE() ) 'InstTime'
			FROM APP_Client client, APP_ClientProp _clientprop
			WHERE client.id = @ClientId AND client.id = _clientprop.componentNameId
			AND _clientprop.attrName = 'Foreign Client Version'	AND _clientprop.modified = 0
		END
		ELSE
		BEGIN
			SELECT 'N/A', '', ('') as RelAndBuild, -1, NULL
		END
		RETURN
	END
	IF exists (select * from Licusage where cid = @ClientId and Apptype = 1001)
	BEGIN
		set @Build = (select TOP 1 L.Build from Licusage L where L.cid = @ClientId and L.Apptype = 1001)
	END
	ELSE IF (@ReleaseID = 12)
	BEGIN
		set @Build = '0(BUILD76)'
	END
	ELSE IF (@ReleaseID = 13)
	BEGIN
		set @Build = '0(BUILD68)'
	END
	ELSE IF (@ReleaseID = 14)
	BEGIN
		set @Build = '0(BUILD84)'
	END
	ELSE
	BEGIN
		SELECT @ReleaseVersion = attrVal FROM APP_ClientProp
		WHERE componentNameId = @ClientId
		AND attrName =  'Galaxy Build'
		set @Build = '('+@ReleaseVersion+')'
	END
	IF @ReleaseID > 14 AND CHARINDEX('(', @Build) > 0
		SET @Build = SUBSTRING(@Build, CHARINDEX('(', @Build), LEN(@Build)-CHARINDEX('(', @Build)+1)
	IF @AppType > 0 AND @LicType > 0
	BEGIN
		IF EXISTS (SELECT * from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
			LU.AppType = @AppType AND LU.LicType = @LicType AND LU.LicType NOT IN (71, 10, 26))
		BEGIN
			SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND LU.AppType = @AppType AND
			LU.LicType = @LicType AND
			LU.LicType NOT IN (71, 10, 26)
			ORDER BY LU.id DESC
		END
		ELSE
		BEGIN
			SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
			LU.LicType NOT IN (71, 10, 26)
			ORDER BY LU.id DESC
		END
	END
	ELSE IF  @AppType > 0
	BEGIN
		IF EXISTS (SELECT *  from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
			LU.AppType = @AppType AND LU.LicType NOT IN (71, 10, 26))
		BEGIN
			SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND LU.AppType = @AppType AND
			LU.LicType NOT IN (71, 10, 26)
			ORDER BY LU.id DESC
		END
		ELSE
		BEGIN
			SET @licInstallTime = 0
			if (@appInstallTime = 0) -- for PseudoClient when there is install time
			SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
			LU.LicType NOT IN (71, 10, 26)
			ORDER BY LU.id DESC
		END
	END
	ELSE IF  @LicType > 0
	BEGIN
		IF EXISTS (SELECT * from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
			LU.LicType = @LicType AND LU.LicType NOT IN (71, 10, 26))
		BEGIN
			SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND LU.LicType = @LicType AND
			LU.LicType NOT IN (71, 10, 26)
			ORDER BY LU.id DESC
		END
		ELSE
		BEGIN
			SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
			WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
			LU.LicType NOT IN (71, 10, 26)
			ORDER BY LU.id DESC
		END
	END
	ELSE
	BEGIN
		SELECT @licInstallTime = dbo.GetUnixTime(LU.OpTimeUTC) from LicUsage LU, SimAllGalaxyRel SR
		WHERE LU.OpType='Install' AND LU.CId = @ClientId AND SR.id = LU.Releaseid AND
		LU.LicType NOT IN (71, 10, 26)
		ORDER BY LU.id DESC
	END
SELECT	@Release, @Build,  RelAndBuild = CASE WHEN @ReleaseID > 14 THEN (@Release+@Build) ELSE @Release+'.'+@Build END,
	@ReleaseID, CASE WHEN @licInstallTime = 0 or (@appInstallTime > 0 AND @appInstallTime < @licInstallTime) THEN @appInstallTime ELSE @licInstallTime END
	SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO


IF EXISTS (select * from GxQscripts where name = 'simGetVersionInfo')
	delete from GxQscripts where name = 'simGetVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetVersionInfo')
	delete from GXDBVersions where aliasname = 'simGetVersionInfo'
GO

insert into GXDBVersions values(2, 'simGetVersionInfo',  '00010025000200020000', 'simGetVersionInfo', '00010025000200020000')
GO

