

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetUpdatesNeedsDownload.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetUpdatesNeedsDownload.sp,v $ $Id: simGetUpdatesNeedsDownload.sp,v 1.1.2.14.4.1 2021/02/17 21:07:06 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  simGetUpdatesNeedsDownload
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Get the updates which are available on server but not downloaded
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simGetUpdatesNeedsDownload')
BEGIN
	print '>>> Drop Stored Procedure: simGetUpdatesNeedsDownload <<<'
	drop procedure simGetUpdatesNeedsDownload
END
IF EXISTS (select * from GxQscripts where name='simGetUpdatesNeedsDownload')
	delete from GxQscripts where name = 'simGetUpdatesNeedsDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetUpdatesNeedsDownload')
	delete from GXDBVersions where aliasname = 'simGetUpdatesNeedsDownload'
GO
print '... Creating Procedure: simGetUpdatesNeedsDownload'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simGetUpdatesNeedsDownload
  @inSPMajor INTEGER,
  @inSPMinor INTEGER,
  @inTransactionId INTEGER,
  @inUpdatesConfigXML XML,
  @inConfigChecksum BIGINT,
  @inUseNewConfig INTEGER
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @oOSId INTEGER
  DECLARE @oUpdatesList VARCHAR(255)
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
DECLARE @notDownloadedUpdates TABLE (OSId INT, UpdatesNumber VARCHAR(256))
DECLARE @osTable TABLE (releaseId INT, updateOSId INT)
DECLARE @patchToDownload TABLE(OSId INT, BinarySetID INT, UpdatesNumber VARCHAR(256), TransactionId INT)
DECLARE @SPVersionId INTEGER = -1
DECLARE @installedCUNum INTEGER = 0
DECLARE @installedCUTransId INTEGER = @inTransactionId
DECLARE @latestCUNum INTEGER = 0
DECLARE @latestCUTransId INTEGER = @inTransactionId
DECLARE @localVisibilityLevel INT = 0
SELECT @localVisibilityLevel = value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Patch Visibility Level' AND modified = 0
-- All OSes and Releases in current CommCell
INSERT INTO @osTable
EXEC dbo.GetUpdateOSTypesFromClientList '0'
-- use the entry with max revisionId
SELECT @SPVersionId = Id FROM PatchSPVersion WITH(NOLOCK) WHERE SPMajor = @inSPMajor AND SPMinor = @inSPMinor AND TransactionId = @inTransactionId  ORDER BY RevisionId DESC
IF @SPVersionId < 0
	GOTO EXIT_HERE
-- if checksum does not match, update the XML in PatchUpdatesInfo table and repopulate it
IF NOT EXISTS (SELECT SPVersionId, Checksum FROM PatchUpdatesInfo I WITH(NOLOCK) JOIN PatchSPVersion V WITH(NOLOCK) ON I.spVersionId = V.id
	WHERE V.SPMajor = @inSPMajor AND V.SPMinor = @inSPMinor AND V.TransactionId = @inTransactionId AND Checksum = @inConfigChecksum AND BinarySetID = 0)
BEGIN
	DELETE PatchUpdatesInfo
	INSERT INTO PatchUpdatesInfo
	SELECT @SPVersionId, x.ref.value('(@hotfixName)[1]', 'VARCHAR(512)'),
		(SELECT TOP 1 _ID
		FROM dbo.CCM_SplitStringByToken(
			(SELECT _ID
				FROM dbo.CCM_SplitStringByToken(x.ref.value('(@hotfixName)[1]', 'VARCHAR(512)') , '_')
				WHERE _ID LIKE '%.exe'), '.')
		WHERE _ID NOT LIKE 'exe'),
		x.ref.value('(@binarySetId)[1]', 'INT'),
		x.ref.value('(@pkgList)[1]', 'VARCHAR(2048)'),
		x.ref.value('(@checkSum)[1]', 'BIGINT'),
		x.ref.value('(@sizeInBytes)[1]', 'BIGINT'),
		x.ref.value('(@TransactionId)[1]', 'INT')
	FROM @inUpdatesConfigXML.nodes('/UpdatePatches_HotfixList/Hotfix') AS x(ref)
	WHERE @inUseNewConfig = 0 OR (ISNULL(x.ref.value('(@TransactionId)[1]', 'INT'), 0) = 0)
		OR (ISNULL(x.ref.value('(@VisibilityFlag)[1]', 'INT'), 0) = 0)
		OR ((ISNULL(x.ref.value('(@VisibilityFlag)[1]', 'INT'), 0) & @localVisibilityLevel) <> 0)
	-- Update the config file checksum in the end
	INSERT INTO PatchUpdatesInfo VALUES(@SPVersionId, 'HotfixConfiguration.xml', '', 0, '', @inConfigChecksum, 0, 0)
END
-- Get updates from PatchUpdatesInfo table (except HotfixConfiguration.xml whose binarySetId is 0)
INSERT INTO @PatchToDownload
SELECT P.NewUpdateOSID, P.BinarySetID, S.UpdatesNumber, S.Reserved
FROM PatchUpdatesInfo S WITH(NOLOCK) JOIN PatchUpdateOS P WITH(NOLOCK) ON P.binarysetId = S.BinarySetID
WHERE NewUpdateOSID IN (SELECT updateOSId FROM @osTable WHERE releaseId = 16) AND S.BinarySetID > 0
SELECT TOP 1 @installedCUNum = sip.UPNumber, @installedCUTransId = pup.MaxTransactionId FROM simInstalledPackages sip WITH(NOLOCK) JOIN PatchUPVersion pup ON sip.UPNumber = pup.UPNumber
	JOIN PatchSPVersion psp1 ON sip.spVersionId = psp1.id
	JOIN PatchSPVersion psp2 ON pup.spVersionId = psp2.id
	WHERE clientId = 2 AND psp1.release = psp2.release AND psp1.build = psp2.build AND psp1.SPMajor = psp2.SPMajor AND psp1.SPMinor = psp2.SPMinor AND psp1.TransactionId = psp2.TransactionId
	ORDER BY sip.UPNumber DESC, pup.MaxTransactionId DESC
SET @latestCUNum = @installedCUNum
SET @latestCUTransId = @installedCUTransId
SELECT TOP 1 @latestCUNum = pup.UPNumber,
			 @latestCUTransId = pup.MaxTransactionId
	FROM PatchUPVersion pup WITH(NOLOCK) JOIN PatchSPVersion psp1 WITH(NOLOCK) ON pup.spVersionId = psp1.id
	WHERE psp1.SPMajor = @inSPMajor AND psp1.SPMinor = @inSPMinor AND psp1.TransactionId = @inTransactionId AND pup.bIsAvailableForDownload = 1 ORDER BY pup.UPNumber DESC
-- Use CS installed value if DB table has lower CU than CS installed
IF @latestCUNum < @installedCUNum
BEGIN
	SET @latestCUNum = @installedCUNum
	SET @latestCUTransId = @installedCUTransId
END
-- Updates available on server but not in CS cache for current release
IF @latestCUNum = 0
-- NO CU on download center
BEGIN
	INSERT INTO @notDownloadedUpdates
	SELECT DISTINCT Q.OSId, Q.UpdatesNumber
	FROM @PatchToDownload AS Q FULL OUTER JOIN
		(SELECT DISTINCT pmc.OSId, SUBSTRING(pini.PatchName, LEN(pini.PatchName) - CHARINDEX('_', REVERSE(pini.PatchName)) + 2, LEN(pini.PatchName)) AS ID
			FROM PatchMultiCache pmc WITH(NOLOCK) JOIN PatchCacheUpdateMap pcum ON pmc.id = pcum.cacheID JOIN PatchINI pini ON pcum.UpdateId = pini.id) AS S
			ON Q.OSId = S.OsId AND Q.UpdatesNumber = S.ID
	WHERE S.ID IS NULL AND Q.TransactionId > @latestCUTransId
END
ELSE IF @latestCUNum = @installedCUNum
-- CS installed latest CU on download center which is not 0
BEGIN
	INSERT INTO @notDownloadedUpdates
	SELECT DISTINCT Q.OSId, Q.UpdatesNumber
	FROM @PatchToDownload AS Q FULL OUTER JOIN
		(SELECT DISTINCT pmc.OSId, SUBSTRING(pini.PatchName, LEN(pini.PatchName) - CHARINDEX('_', REVERSE(pini.PatchName)) + 2, LEN(pini.PatchName)) AS ID
			FROM PatchMultiCache pmc WITH(NOLOCK) JOIN PatchCacheUpdatePackMap pcupm WITH(NOLOCK) ON pmc.id = pcupm.cacheID
			JOIN PatchUPVersion pup WITH(NOLOCK) ON pcupm.UpdatePackID = pup.UPVersionID
			JOIN PatchUpdatePackPatchesMap puppm ON pup.UPVersionID = puppm.UpdatePackID JOIN PatchINI pini ON puppm.UpdateId = pini.id WHERE puppm.bIsAdditionalUpdate = 1) AS S
			ON Q.OSId = S.OsId AND Q.UpdatesNumber = S.ID
	WHERE S.ID IS NULL AND Q.TransactionId > @latestCUTransId
END
ELSE
-- download center has higher CU than CS installed
BEGIN
	INSERT INTO @notDownloadedUpdates
	SELECT DISTINCT Q.OSId, Q.UpdatesNumber
	FROM @PatchToDownload AS Q
	WHERE Q.TransactionId > @latestCUTransId
END
EXIT_HERE:
SELECT OSId, UpdatesNumber FROM @notDownloadedUpdates ORDER BY OSId ASC, UpdatesNumber ASC
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetUpdatesNeedsDownload')
	delete from GxQscripts where name = 'simGetUpdatesNeedsDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetUpdatesNeedsDownload')
	delete from GXDBVersions where aliasname = 'simGetUpdatesNeedsDownload'
GO

insert into GXDBVersions values(2, 'simGetUpdatesNeedsDownload',  'v1.1.2.14.4.1', 'simGetUpdatesNeedsDownload', 'v1.1.2.14.4.1')
GO

