

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetUPInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetUPInfo.sp,v $ $Id: simGetUPInfo.sp,v 1.1.2.5 2020/07/10 22:28:34 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  simGetUPInfo()
--  |
--  | Description: Return information of Cumulative Update Pack
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetUPInfo')
BEGIN
	print '>>> Drop Stored Procedure: simGetUPInfo <<<'
	drop procedure simGetUPInfo
END
IF EXISTS (select * from GxQscripts where name='simGetUPInfo')
	delete from GxQscripts where name = 'simGetUPInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetUPInfo')
	delete from GXDBVersions where aliasname = 'simGetUPInfo'
GO
print '... Creating Procedure: simGetUPInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simGetUPInfo
  @inSimRelId INT,
  @inBuild INT,
  @inSPMajor INT,
  @inSPMinor INT,
  @inTransactionId INT,
  @inCUNum INT,
  @inCSInstalledVerXML XML,
  @inHighestInstalledTransId INT,
  @inGUIOpType INT
AS
  DECLARE @oCUNumber INT
  DECLARE @oCUTransactionId INT
  DECLARE @oIsCUAvaiableForDownload INT
  DECLARE @oIsCUShownInGUI INT
SET NOCOUNT ON
DECLARE @csInstalledRelease	INT = 0
DECLARE @csInstalledBuild	INT = 0
DECLARE @csInstalledSPMajor	INT = 0
DECLARE @csInstalledSPMinor	INT = 0
DECLARE @csInstalledSPTransId	INT = 0
DECLARE @csInstalledCUNum	INT = 0
DECLARE @tmpFullInfo TABLE (CUNum INT, CUTransId INT, CUAvail INT, CUShowInGUI INT)
DECLARE @useCSLevelCU INT = 0
DECLARE	 @currentUTCTime DATETIME = GETUTCDATE()
-- 1. get CS installed SP version and CU info
SELECT DISTINCT @csInstalledRelease = Req.FulLVersion.value('(./spVersion/@ReleaseId)[1]', 'int'),
		   @csInstalledBuild = Req.FulLVersion.value('(./spVersion/@Build)[1]', 'int'),
		   @csInstalledSPMajor = Req.FulLVersion.value('(./spVersion/@Major)[1]', 'int'),
		   @csInstalledSPMinor = Req.FulLVersion.value('(./spVersion/@Minor)[1]', 'int'),
		   @csInstalledSPTransId = Req.FulLVersion.value('(./spVersion/@TransactionId)[1]', 'int'),
		   @csInstalledCUNum = Req.FulLVersion.value('(./cumulativeUpdatePackVersion/@Number)[1]', 'int')
	FROM @inCSInstalledVerXML.nodes('/FullVersion') as Req(FulLVersion)
IF @inGUIOpType = 1 OR @inGUIOpType = 2
-- Latst opition is selected, honor that
BEGIN
	INSERT INTO @tmpFullInfo
	SELECT TOP 1 U.UPNumber, U.MaxTransactionId, U.bIsAvailableForDownload, U.bShowInGUI
		FROM PatchSPVersion S WITH(NOLOCK) JOIN PatchUPVersion U WITH(NOLOCK) ON U.SPVersionId = S.Id
		WHERE S.Release = @inSimRelId AND S.Build = @inBuild AND S.SPMajor = @inSPMajor AND S.SPMinor = @inSPMinor
		AND S.TransactionId = @inTransactionId AND dbo.GetUnixTime(DATEADD(dd, -U.nGUIDownloadDelayDays, @currentUTCTime)) > U.Timestamp
		AND U.nGUIDownloadDelayDays >= 0 AND U.bIsAvailableForDownload = 1 ORDER BY U.MaxTransactionId DESC, U.UPNumber DESC
	IF NOT EXISTS (SELECT CUNum FROM @tmpFullInfo)
	BEGIN
		IF @inTransactionId <> @csInstalledSPTransId
			--different recut, just use 0
			INSERT INTO @tmpFullInfo VALUES(0, 0, 1, 0)
		ELSE
		    --no HPK has higher transaction Id than installed one, insert CS installed one
			SET @useCSLevelCU = 1
	END
	ELSE IF (@inTransactionId = @csInstalledSPTransId) AND EXISTS (SELECT CUNum FROM @tmpFullInfo WHERE CUNum < @csInstalledCUNum)
	BEGIN
		--lower than cs installed, update to cs installed one
		SET @useCSLevelCU = 1
		DELETE @tmpFullInfo
	END
	IF NOT EXISTS (SELECT CUNum FROM @tmpFullInfo)
	BEGIN
		-- For CS level, we just get CS installed CU and also need to check bIsAvailableForDownload flag since CUConfiguration.xml is already downloaded and parsed before calling this
		IF @useCSLevelCU = 1 AND @csInstalledCUNum > 0
			INSERT INTO @tmpFullInfo
			SELECT TOP 1 U.UPNumber, U.MaxTransactionId, U.bIsAvailableForDownload, U.bShowInGUI
				FROM PatchSPVersion S WITH(NOLOCK) JOIN PatchUPVersion U WITH(NOLOCK) ON U.SPVersionId = S.Id
				WHERE S.Release = @inSimRelId AND S.Build = @inBuild AND S.SPMajor = @inSPMajor AND S.SPMinor = @inSPMinor
				AND S.TransactionId = @inTransactionId AND U.UPNumber = @csInstalledCUNum AND U.bIsAvailableForDownload = 1 ORDER BY U.MaxTransactionId DESC, U.UPNumber DESC
		ELSE IF @csInstalledCUNum = 0
			INSERT INTO @tmpFullInfo VALUES(0, 0, 1, 0)
	END
END
ELSE IF @inGUIOpType = 3
-- specific SP is selected
BEGIN
	-- ignore the cutofftime
	IF @inTransactionId <> @csInstalledSPTransId
	-- different SP
	INSERT INTO @tmpFullInfo
	SELECT TOP 1 U.UPNumber, U.MaxTransactionId, U.bIsAvailableForDownload, U.bShowInGUI
		FROM PatchSPVersion S WITH(NOLOCK) JOIN PatchUPVersion U WITH(NOLOCK) ON U.SPVersionId = S.Id
		WHERE S.Release = @inSimRelId AND S.Build = @inBuild AND S.SPMajor = @inSPMajor AND S.SPMinor = @inSPMinor
		AND S.TransactionId = @inTransactionId AND U.UPNumber = @inCUNum AND U.bIsAvailableForDownload = 1 ORDER BY U.MaxTransactionId DESC, U.UPNumber DESC
	ELSE
	-- same SP, we will honor the inHighestInstalledTransId
	INSERT INTO @tmpFullInfo
	SELECT TOP 1 U.UPNumber, U.MaxTransactionId, U.bIsAvailableForDownload, U.bShowInGUI
		FROM PatchSPVersion S WITH(NOLOCK) JOIN PatchUPVersion U WITH(NOLOCK) ON U.SPVersionId = S.Id
		WHERE S.Release = @inSimRelId AND S.Build = @inBuild AND S.SPMajor = @inSPMajor AND S.SPMinor = @inSPMinor
		AND S.TransactionId = @inTransactionId AND U.UPNumber = @inCUNum AND U.UPNumber >= @csInstalledCUNum
		AND U.MaxTransactionId >= @inHighestInstalledTransId AND U.bIsAvailableForDownload = 1 ORDER BY U.MaxTransactionId DESC, U.UPNumber DESC
	IF @inCUNum = 0
		INSERT INTO @tmpFullInfo VALUES(0, 0, 1, 0)
END
SELECT CUNum, CUTransId, CUAvail, CUShowInGUI FROM @tmpFullInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simGetUPInfo')
	delete from GxQscripts where name = 'simGetUPInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetUPInfo')
	delete from GXDBVersions where aliasname = 'simGetUPInfo'
GO

insert into GXDBVersions values(2, 'simGetUPInfo',  '00010001000200050000', 'simGetUPInfo', '00010001000200050000')
GO

