

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetSRMLicenceDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/28/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetSRMLicenceDetails.sp,v $ $Id: simGetSRMLicenceDetails.sp,v 1.7.200.2 2018/03/27 09:05:30 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetSRMLicenceDetails <<<'

IF EXISTS (select * from sysobjects where name='simGetSRMLicenceDetails')
	drop procedure simGetSRMLicenceDetails
IF EXISTS (select * from GxQscripts where name='simGetSRMLicenceDetails')
	delete from GxQscripts where name = 'simGetSRMLicenceDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetSRMLicenceDetails')
	delete from GXDBVersions where aliasname = 'simGetSRMLicenceDetails'
GO
print '... Creating Procedure: simGetSRMLicenceDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetSRMLicenceDetails
  @i_clientId integer,
  @i_appType integer
AS
  DECLARE @o_isSRMFLALicenceConsumed integer
  DECLARE @o_numberOfFLDFileEntries bigint
  DECLARE @o_isSRMEnabled integer
  DECLARE @o_errorStr varchar(MAX)
	DECLARE @bIsValid		integer
	DECLARE @expTime		integer
	DECLARE @errorMsg		varchar(1024)
	SET @o_isSRMFLALicenceConsumed = 0
	SET @o_numberOfFLDFileEntries = 0
	SET @o_isSRMEnabled = 0
	IF (OBJECT_ID('tempdb.dbo.#tmpLicCheckTable') IS NOT NULL)
			DROP TABLE #tmpLicCheckTable
	CREATE TABLE #tmpLicCheckTable (
		isValid		integer,
		expTime		integer,
		errorMsg	varchar(1024)
		)
	-- 1) validate SRM FLA Licence
	-- 0 - clientId (CId = 2) from LicUsage
	-- 1108 - AppType from APP_iDAType "File Level Enabler for SRM"
	-- 186 - short_name from simLicAppTypeV2 "File Level Enabler for SRM"
	INSERT INTO #tmpLicCheckTable
		EXEC simValidLicenseCheck 0, 1108, 186
	SELECT @bIsValid = isValid FROM #tmpLicCheckTable
	-- 2) If FLA Licence valid, get number of FLDFiles for given ClientId
	DECLARE @appType int
	DECLARE @simLicAppType int
	SET @appType = (CASE @i_appType
WHEN 42 THEN 600
WHEN 29 THEN 605
	END )
	-- 3) validate SRM Licence
	DELETE FROM #tmpLicCheckTable
	SELECT @simLicAppType = simLicAppType
	FROM simAppTypeLicTypeMap
	WHERE appTypeId = @appType
	INSERT INTO #tmpLicCheckTable
		EXEC simValidLicenseCheck @i_clientId, @appType, @simLicAppType
	SELECT @o_isSRMEnabled = isValid FROM #tmpLicCheckTable
SP_EXIT:
	IF (OBJECT_ID('tempdb.dbo.#tmpLicCheckTable') IS NOT NULL)
		DROP TABLE #tmpLicCheckTable
	IF ( (@o_isSRMFLALicenceConsumed > 0) AND (@o_isSRMEnabled > 0) )
		SET @o_errorStr = 'simGetSRMLicenceDetails Completed successfully'
	SELECT @o_isSRMFLALicenceConsumed, @o_numberOfFLDFileEntries, @o_isSRMEnabled, @o_errorStr
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'simGetSRMLicenceDetails')
	delete from GxQscripts where name = 'simGetSRMLicenceDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetSRMLicenceDetails')
	delete from GXDBVersions where aliasname = 'simGetSRMLicenceDetails'
GO

insert into GXDBVersions values(2, 'simGetSRMLicenceDetails',  '00010007020000020000', 'simGetSRMLicenceDetails', '00010007020000020000')
GO

